unit DConfig;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, Buttons, Inifiles;

Const Ver = 'V2.01';

Procedure Konfiguration (AktIni: TInifile);

Type TFups = (fIndirekt, fDirekt, fBeide);
Var
   CopyTo1, CopyTo2,
   FQDN, Suchen, AddToMessageID, MixGroupIni,
     MailsTo, OwnGr, FupsGr, IgnoreGroups, DontIgnoreGroups: String;
   OnlyDirectFups: TFups;
   Anz1, Anz2, MailAnz, GesAnz,
     NewGroups_TestMax, TestMaxPostings: LongInt;
   ShowAnz, ShowSearch, Simulate, SimulateShow,
     DontCountOwnPostings, Konfiguriert: boolean;
   lIgnoreGroups, lDontIgnoreGroups, lMixGroups, lMailsTo: TStringlist;

Procedure LadeEinstellungen (Ini: TIniFile);

type
  TDlgConfig = class(TForm)
    pg: TPageControl;
    tsGrundeinstellungen: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    Label1: TLabel;
    txtFQDN: TEdit;
    Label2: TLabel;
    cbModus: TComboBox;
    labCopyTo: TLabel;
    txtCopyTo: TEdit;
    labCopyTo2: TLabel;
    txtCopyTo2: TEdit;
    Label5: TLabel;
    txtIgnore: TEdit;
    Label6: TLabel;
    Label7: TLabel;
    txtDontIgnore: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    txtMixGroup: TEdit;
    chkTestmodus: TCheckBox;
    Label11: TLabel;
    Label12: TLabel;
    txtAddToMessageID: TEdit;
    chkTestShow: TCheckBox;
    Label14: TLabel;
    txtNeuMax: TEdit;
    Label15: TLabel;
    Label16: TLabel;
    txtAltMax: TEdit;
    Label17: TLabel;
    chkShowSearch: TCheckBox;
    chkShowErgebnis: TCheckBox;
    chkIgnoreOwn: TCheckBox;
    butOK: TButton;
    butAbbruch: TButton;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure butOKClick(Sender: TObject);
    procedure RunTest(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    Ini: TInifile;
    Procedure Test;
    Procedure Einstellungen_anzeigen;
    Procedure Einstellungen_speichern;
  end;

implementation

Uses uHamster, uVerkn, DChHamGr;

{$R *.DFM}

Const Abschnitt = 'Settings';
      Link = 'CopyFups konfigurieren.lnk';

Procedure Konfiguration (AktIni: TIniFile);
begin
   With TDlgConfig.Create(nil) do try
      Ini := AktIni;
      ShowModal
   finally
      free
   end
end;

Procedure LadeEinstellungen (Ini: TIniFile);

   Function GetSetting(Const Bez, Def: String): String;
   begin
      Result := Ini.ReadString (Abschnitt, Bez, 'Default-Value');
      If Result = 'Default-Value' then begin
         If FileExists(Ini.Filename)
            then Ini.WriteString(Abschnitt, Bez, Def);
         Result := Def;
      end
   end;

Var s: String; p: Integer;
begin
   {If Not FileExists(ExtractFilePath(ParamStr(0))+Link)
      then CreateLink(ParamStr(0), '/cfg', ExtractFilePath(ParamStr(0))+Link, Link);}
   ShowAnz := GetSetting ('ShowAnz', '1') = '1';
   ShowSearch := GetSetting ('ShowSearch', '1') = '1';
   CopyTo1 := GetSetting ('CopyTo', '');
   CopyTo2 := GetSetting ('CopyTo2', '');
   IgnoreGroups := GetSetting ('IgnoreGroups', ''); s := IgnoreGroups;
   With lIgnoreGroups do If IgnoreGroups >'' then begin
      Clear;
      Repeat
         p := Pos(',', s);
         If p>0 then begin
            Add (Copy(s, 1, p-1)); s := Copy(s, p+1, Length(s)-p)
         end else begin
            Add (s); s := ''
         end
      Until s = ''
   end;
   DontIgnoreGroups := GetSetting ('DontIgnoreGroups', ''); s := DontIgnoreGroups;
   With lDontIgnoreGroups do If s>'' then begin
      Clear;
      Repeat
         p := Pos(',', s);
         If p>0 then begin
            Add (Copy(s, 1, p-1)); s := Copy(s, p+1, Length(s)-p)
         end else begin
            Add (s); s := ''
         end
      Until s = ''
   end;
   FQDN := GetSetting ('FQDN', '');
   Suchen := '@'+FQDN+'>';
   OnlyDirectFups := TFups(StrToInt(GetSetting('OnlyDirectFups', '1')));
   AddToMessageID := GetSetting ('AddToMessageID', '');
   Simulate := GetSetting ('TestOnly', '1') = '1';
   SimulateShow := GetSetting ('TestOnly_ShowPostings', '0') = '1';
   NewGroups_TestMax := StrToInt(GetSetting('NewGroups_TestMax', '250'));
   TestMaxPostings := StrToInt(GetSetting('TestMaxPostings', '0'));
   MixGroupIni := GetSetting ('MixGroup.ini', 'MixGroup.ini'); s := MixGroupIni;
   If (Copy(s,2,1)<>':') and (Copy(s,1,1)<>'\')
      then s := ExtractFilePath(Paramstr(0))+s;
   With TIniFile.Create(s) do try ReadSection (Abschnitt, lMixGroups) finally free end;
   DontCountOwnPostings := GetSetting('DontCountOwnPostings', '1') = '1';

   If OnlyDirectFups = fIndirekt then CopyTo2 := CopyTo1;

   If Not FileExists(Ini.Filename)
      then Messagebox (0, PChar('Erstkonfiguration - fr nachtrgliche nderungen einfach "CfgCpyFp.exe" starten!'),
                       PChar('Copy Followups '+Ver), MB_OK);
   Konfiguriert := (ParamCount = 0) and  (CopyTo1>'') and (FQDN>'')
end;

Procedure TDlgConfig.Einstellungen_speichern;
begin With Ini do begin
   { Grundeinstellungen }
   WriteString (Abschnitt, 'FQDN', txtFQDN.text);
   WriteInteger(Abschnitt, 'OnlyDirectFups', cbModus.ItemIndex);
   WriteString (Abschnitt, 'CopyTo', txtCopyTo.text);
   WriteString (Abschnitt, 'CopyTo2', txtCopyTo2.text);
   WriteString (Abschnitt, 'AddToMessageID', txtAddToMessageID.text);
   WriteInteger(Abschnitt, 'TestOnly', Ord(chkTestmodus.checked) );
   WriteInteger(Abschnitt, 'TestOnly_ShowPostings', Ord(chkTestShow.checked) );
   WriteInteger(Abschnitt, 'NewGroups_TestMax', StrToInt(txtNeuMax.text) );
   WriteInteger(Abschnitt, 'TestMaxPostings', StrToInt(txtAltMax.text) );
   { Gruppen }
   WriteString (Abschnitt, 'IgnoreGroups', txtIgnore.text);
   WriteString (Abschnitt, 'DontIgnoreGroups', txtDontIgnore.text);
   WriteString (Abschnitt, 'MixGroup.ini', txtMixGroup.text);
   { Anzeige }
   WriteInteger(Abschnitt, 'ShowSearch', Ord(chkShowSearch.checked) );
   WriteInteger(Abschnitt, 'ShowAnz', Ord(chkShowErgebnis.checked) );
   WriteInteger(Abschnitt, 'DontCountOwnPostings', Ord(chkIgnoreOwn.checked) )
end end;

procedure TDlgConfig.FormCreate(Sender: TObject);
begin
   caption := 'CopyFups '+Ver+' by Thomas G. Liesner - Einstellungen';
   pg.ActivePage := tsGrundeinstellungen;
   Einstellungen_anzeigen;
   Test
end;

Procedure TDlgConfig.Einstellungen_anzeigen;
begin
   { Grundeinstellungen }
   txtFQDN.text := FQDN;
   cbModus.ItemIndex := Ord(OnlyDirectFups);
   txtCopyTo.text := CopyTo1;
   txtCopyTo2.text := CopyTo2;
   txtAddToMessageID.text := AddToMessageID;
   chkTestmodus.checked := Simulate;
      chkTestShow.checked := SimulateShow; 
   txtNeuMax.text := IntToStr(NewGroups_TestMax);
   txtAltMax.text := IntToStr(TestMaxPostings);
   { Gruppen }
   txtIgnore.text := IgnoreGroups;
   txtDontIgnore.text := DontIgnoreGroups;
   txtMixGroup.text := MixGroupIni;
   { Anzeige }
   chkShowSearch.checked := ShowSearch;
   chkShowErgebnis.checked := ShowAnz;
   chkIgnoreOwn.checked := DontCountOwnPostings
end;

Procedure TDlgConfig.Test;
Var b: boolean;
begin
   { Grundeinstellungen }
   butOk.enabled := (txtFQDN.text > '') and (txtCopyTo.text > '');
   b := cbModus.ItemIndex = 2;
   labCopyTo2.visible := b;
   txtCopyTo2.visible := b;
   With labCopyTo do if b then Caption := 'Zielgruppe 1:' else Caption := 'Zielgruppe:';
   b := chkTestmodus.checked;
   chkTestShow.enabled := b;
   { Gruppen }
   txtDontIgnore.enabled := txtIgnore.text > '';
   { Anzeige }
   chkIgnoreOwn.enabled := chkShowSearch.checked or chkShowErgebnis.checked
end;

procedure TDlgConfig.butOKClick(Sender: TObject);
begin
   Einstellungen_speichern
end;

procedure TDlgConfig.RunTest(Sender: TObject);
begin
   Test
end;

procedure TDlgConfig.SpeedButton2Click(Sender: TObject);
Var s: String;
begin
   With txtCopyTo do begin
      s := text; If ChooseHamsterGruppe(s) then text := s
   end
end;

procedure TDlgConfig.SpeedButton1Click(Sender: TObject);
Var s: String;
begin
   With txtCopyTo2 do begin
      s := text; If ChooseHamsterGruppe(s) then text := s
   end
end;

initialization
   lIgnoreGroups := TStringlist.Create;
   lDontIgnoreGroups := TStringlist.Create;
   lMixGroups := TStringlist.Create;
finalization
   lIgnoreGroups.free;
   lDontIgnoreGroups.free;
   lMixGroups.free;
end.
