unit DSprache;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, cStdForm;

Function DialogSprache (Var AktSprache: String): boolean;

type
  TDlgSprache = class(THForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    labUeb: TLabel;
    l: TListBox;
    butHelp: TButton;
    procedure lClick(Sender: TObject);
    procedure lDblClick(Sender: TObject);
  private
    function GetSprache: String;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DlgSprache: TDlgSprache;

implementation

Uses IniFiles, uTools;

{$R *.DFM}

Function DialogSprache (Var AktSprache: String): boolean;
Var s, s2: String; r: TSearchRec; p: Integer;
begin
   If Not FileExists2(Sprachdatei('en')) then With TIniFile.Create(Sprachdatei('en')) do try
      WriteString('Init', 'Language', 'English')
   finally free end;
   If AktSprache = '' then AktSprache := 'en';
   With TDlgSprache.Create(nil) do try
      s := SprachDatei('*');
      If FindFirst (s, faAnyFile-faDirectory-faVolumeID, r) = 0 then begin
         Repeat
            With TIniFile.Create(ExtractFilePath(s)+r.name) do try
               s2 := ReadString('Init', 'Language', '')
            finally free end;
            If s2 > '' then begin
               p := l.Items.Add (s2 + ' ('+ExtractLanguageFromFile(r.Name)+')');
               If ExtractLanguageFromFile(r.Name) = AktSprache then l.ItemIndex := p
            end
         Until FindNext(r) <> 0;
         FindClose(r)
      end;
      Result := (ShowModal = mrOk) and (l.ItemIndex >= 0);
      If Result then begin
         AktSprache := GetSprache;
      end
   finally free end
end;

procedure TDlgSprache.lClick(Sender: TObject);
Var s: String;
begin
   s := Sprache;
   Sprache := GetSprache;
   LoadLanguageAgain;
   Sprache := s
end;

Function TDlgSprache.GetSprache: String;
Var i, p: Integer;
begin
   Result := l.Items[l.ItemIndex];
   p := 0;
   For i:=1 to Length(Result) do If Result[i]='(' then p := i+1;
   If p > 0 then Result := Copy(Result, p, Length(Result)-p)
end;

procedure TDlgSprache.lDblClick(Sender: TObject);
begin
   ModalResult := mrOk
end;

end.
