// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR      m
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit HConfigAutomatic;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, Menus, Clipbrd,
  Mask, ToolEdit, tScriptInsCmd,

  cStdForm, cActions, ImgList;

Function DialogAutomatics: Boolean;

type
  TActiveEntry = Record Node: TTreeNode; Info: TActionInfo2 end;
  TfrmConfigAutomatics = class(THForm)
    pg: TPageControl;
    tsGeneral: TTabSheet;
    tsActions: TTabSheet;
    OKBtn: TButton;
    CancelBtn: TButton;
    butHelp: TButton;
    chkPurgeDaily: TCheckBox;
    tvActions: TTreeView;
    labChooseAction: TLabel;
    labActionSettings: TLabel;
    frEditAction: TPanel;
    chkWaitProgram: TCheckBox;
    txtPars: TEdit;
    Label3: TLabel;
    txtProgram: TFilenameEdit;
    Label2: TLabel;
    cbScript: TComboBox;
    Label1: TLabel;
    ImageList1: TImageList;
    Label4: TLabel;
    chkCreateStatistics: TCheckBox;
    Label5: TLabel;
    chkPurgeNewsScoreFile: TCheckBox;
    chkCheckObsoleteDirs: TCheckBox;
    chkStartNNTP: TCheckBox;
    chkStartPOP3: TCheckBox;
    chkStartSMTP: TCheckBox;
    Bevel2: TBevel;
    chkStartIMAP: TCheckBox;
    chkStartReCo: TCheckBox;
    Label6: TLabel;
    chkOLEServer: TCheckBox;
    TabSheet1: TTabSheet;
    labChooseNewsserver: TLabel;
    lbNewsserver: TListBox;
    labMIDList: TLabel;
    labMIDInfo: TLabel;
    butSaveMIDList: TButton;
    butReloadMIDList: TButton;
    mMIDList: TMemo;
    butAddMIDsFromClipboard: TButton;
    labNewgroupinfoTitle: TLabel;
    labNewgroupinfoFilter: TLabel;
    txtNewgroupinfoFilter: TEdit;
    labStartType: TLabel;
    cbStarttype: TComboBox;
    chkPurgeMailScoreFile: TCheckBox;
    Label7: TLabel;
    butInfoForAction: TButton;
    MemoScriptlines: TMemo;
    butEditActionScript: TButton;
    chkWaitScript2: TCheckBox;
    butInserths2command: TButton;
    popScriptCommands: TPopupMenu;
    labEmptyTrash: TLabel;
    txtEmptyTrashAfterDays: TEdit;
    labEmptyTrash_days: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure tvActionsChange(Sender: TObject; Node: TTreeNode);
    procedure OnExitActionInputField(Sender: TObject);
    procedure lbNewsserverClick(Sender: TObject);
    procedure mMIDListChange(Sender: TObject);
    procedure butSaveMIDListClick(Sender: TObject);
    procedure butReloadMIDListClick(Sender: TObject);
    procedure butAddMIDsFromClipboardClick(Sender: TObject);
    procedure butInfoForActionClick(Sender: TObject);
    procedure butEditActionScriptClick(Sender: TObject);
    procedure butInserths2commandClick(Sender: TObject);
  private
    AktEntry: TActiveEntry;
    MIDFile, ActionInfo: String;
    InsertCommand: TInsertCommand;
    procedure LoadSettings;
    procedure SaveSettings;
    procedure SaveActions;
    procedure SaveAction;
    procedure CheckForMIDFileChanges;
  end;

implementation

uses Global, cAccount, Config, uTools, dScripts;

{$R *.DFM}

Function DialogAutomatics: Boolean;
begin
   With TfrmConfigAutomatics.Create(NIL) do try
      Result := ShowModal = mrOK
   finally Free end
end;

procedure TfrmConfigAutomatics.LoadSettings;
begin
   With CfgIni do begin
      chkPurgeDaily.Checked := ReadBool ('Setup', 'purge.daily', Def_Purge_Daily);
      chkCheckObsoleteDirs.Checked := ReadBool ('Setup', 'CheckDirs.daily', true);
      chkStartNNTP.Checked := ReadBool( 'Setup', CFG_LOCAL_AUTOSTART_NNTP, True );
      chkStartPOP3.Checked := ReadBool( 'Setup', CFG_LOCAL_AUTOSTART_POP3, True );
      chkStartSMTP.Checked := ReadBool( 'Setup', CFG_LOCAL_AUTOSTART_SMTP, True );
      chkStartIMAP.Checked := ReadBool( 'Setup', CFG_LOCAL_AUTOSTART_IMAP, false ); //IMAP
      chkStartReCo.Checked := ReadBool( 'Setup', CFG_LOCAL_AUTOSTART_ReCo, false );
      chkOLEServer.Checked := ReadBool( 'Setup', 'Startup.OLEServer', Def_OLE_Server);
      chkCreateStatistics.Checked := ReadBool ('Setup', 'CreateStatistics.daily', true);
      chkPurgeNewsScoreFile.Checked := ReadBool ('Setup', 'PurgeNewsScorefile.daily', true);
      chkPurgeMailScoreFile.Checked := ReadBool ('Setup', 'PurgeMailScorefile.daily', true);
      txtEmptyTrashAfterDays.Text := IntToStr(ReadInteger('EditDirs', 'EmptyTrashAfterXDays', 28));
      txtNewgroupinfoFilter.text := ReadString ( 'Setup', 'FilterNewGroupsInfo', Def_FilterNewGroupsInfo);
   end
end;

procedure TfrmConfigAutomatics.SaveSettings;
begin
   With CfgIni do begin
      WriteBool ('Setup', 'purge.daily', chkPurgeDaily.Checked);
      WriteBool ('Setup', 'CheckDirs.daily', chkCheckObsoleteDirs.Checked);
      WriteBool( 'Setup', CFG_LOCAL_AUTOSTART_NNTP, chkStartNNTP.Checked );
      WriteBool( 'Setup', CFG_LOCAL_AUTOSTART_POP3, chkStartPOP3.Checked );
      WriteBool( 'Setup', CFG_LOCAL_AUTOSTART_SMTP, chkStartSMTP.Checked );
      WriteBool( 'Setup', CFG_LOCAL_AUTOSTART_IMAP, chkStartIMAP.Checked ); //IMAP
      WriteBool( 'Setup', CFG_LOCAL_AUTOSTART_ReCo, chkStartReCo.Checked );
      WriteBool( 'Setup', 'Startup.OLEServer', chkOLEServer.Checked);
      WriteBool( 'Setup', 'CreateStatistics.daily', chkCreateStatistics.Checked);
      WriteBool ('Setup', 'PurgeNewsScorefile.daily', chkPurgeNewsScoreFile.Checked);
      WriteBool ('Setup', 'PurgeMailScorefile.daily', chkPurgeMailScoreFile.Checked);
      try
         WriteInteger('EditDirs', 'EmptyTrashAfterXDays', StrToInt('0'+Trim(txtEmptyTrashAfterDays.Text)))
      except end;
      WriteString ( 'Setup', 'FilterNewGroupsInfo', txtNewgroupinfoFilter.text);
   end
end;

Var TI: Integer = 0;

procedure TfrmConfigAutomatics.FormCreate(Sender: TObject);
Var Node1, Node2, Node3: TTreeNode; Userlist: TStringList; b: Boolean;

    Procedure Init ( Akt: TTreeNode; Const AktTyp: TActiontype; Const User, Infotext: String );
    begin
       With TActionInfo2(Akt.Data) do begin
          ActionTyp := AktTyp;
          ActionKey := ActionIniKeys[ActionTyp];
          If User > '' then ActionKey := ActionKey + '.' + User;
          With CfgIni do begin
             Exec := ReadString ('Actions', ActionKey + '.Exec', '');
             Pars := ReadString ('Actions', ActionKey + '.Pars', '');
             Script := ReadString ('Actions', ActionKey + '.Script', '');
             ScriptLinesAsStr := ReadString ('Actions', ActionKey + '.Scriptlines', '');
             try Wait := TWait(ReadInteger ('Actions', ActionKey + '.Wait', 0))
             except Wait := wNone end;
             try ExeStartTyp := TExeStarttype(ReadInteger ('Actions', ActionKey + '.ExeStartType', 0))
             except ExeStartTyp := stNormal end;
          end;
          Info := Infotext;
          b := Exec+Pars+Script+ScriptlinesAsStr>'';
          SetTreeNodeBold (Akt, b);
          If b then Akt.MakeVisible
       end
    end;

    Procedure Add (Const Level: Integer; Const AktTyp: TActiontype; Const bMultiAccounts: Boolean;
                    Const LangKey, LangDef, LangInfoDef: String );
    Var Title, Infotext: String; Akt: TTreeNode; i, UserID: Integer; Info: TActionInfo2;
    begin
       Title := Tr('Title.'+LangKey, LangDef);
       If langInfoDef > ''
          then Infotext := Tr('Title.'+LangKey+'.Info', LangInfoDef)
          else Infotext := '';
       Case Level of
          0: Akt := NIL; 1: Akt := Node1; 2: Akt := Node2; 3: Akt := Node3;
          else exit
       end;
       Akt := tvActions.Items.AddChild ( Akt, Title );
       Info := TActionInfo2.Create;
       Akt.Data := Info;
       Init (Akt, AktTyp, '', Infotext);
       Case Level of
          0: Node1 := Akt; 1: Node2 := Akt; 2: Node3 := Akt;
       end;
       If bMultiAccounts then begin
          for i:=0 to Userlist.Count-1 do begin
             UserID := LongInt( Userlist.Objects[i] );
             Akt := tvActions.Items.AddChild ( Node3, TrF('Title.Mailfor', 'for %s',
                CfgAccounts.Value[UserID, ACTP_FULLNAME]
                + ' (' + CfgAccounts.Value[UserID, ACTP_USERNAME] + ')' ));
             Info := TActionInfo2.Create;
             Akt.Data := Info;
             Init (Akt, AktTyp, CfgAccounts.Value[UserID, ACTP_USERNAME], Infotext);
          end
       end
    end;

Var st: TExeStartType;
    i: Integer;
begin
   pg.ActivePage := pg.Pages[TI];

   InsertCommand := TInsertCommand.Create ( popScriptCommands, MemoScriptlines );

   // Prepare Starttype
   With cbStarttype, Items do begin
      Clear;
      For st := Low(TExeStartType) to High(TExeStartType) do begin
         Add ( TrGl(kGlobal, 'Action.ExeStartType.Caption.'+IntToStr(Ord(st)),
            ExeStartCaption[st] ) )
      end
   end;

   // Prepare Treeview
   With tvActions do begin
      For i := 0 to Items.Count-1 do If Items[i].Data<>NIL then TActionInfo2(Items[i].Data).Free;
      Items.Clear;
   end;
   Userlist := TStringList.Create;
   frEditAction.Visible := false;
   try
      CfgAccounts.SnapshotOfIDs( Userlist );
      Add ( 0, atNone, false, 'Hamster', 'Hamster', '' );
      Add ( 1, atStartUp, false, 'OnStartUp', 'Startup',
         'This action is executed, when Hamster is started and initialized. No parameters are used.' );
      Add ( 1, atShutDown, false, 'OnShutDown', 'Shutdown',
         'This action is executed, when Hamster is closed, if you don''t choose "wait", Hamster can '
          + 'be terminated, before the action is done. No parameters are used.' );
      Add ( 0, atNone, false, 'Statusline', 'Statusline', '' );
      Add ( 1, atStatusClick, false, 'OnStatusbarClick', 'Click',
         'This action is executed, when the user clicks on the statusbar, so it is also executed on '
          +'an double-click! No parameters are used.' );
      Add ( 1, atStatusDblClick, false, 'OnStatusbarDblClick', 'Double-Click',
         'This action is executed, when the user double-clicks on the statusbar. If there'' no action '
          + 'defined, Hamster opens the dialog with the mail/news-directories. No parameters are used.' );
      Add ( 0, atNone, false, 'TrayIcon', 'Tray-Icon', '' );
      Add ( 1, atTrayIconClick, false, 'OnTrayIconClick', 'Click',
         'This action is executed, when the user clicks on the tray-icon. If there''s no action '
          + 'defined, Hamster activates his main window. No parameters used.' );
      Add ( 1, atTrayIconDblClick, false, 'OnTrayIconDblClick', 'Double-Click',
         'This action is executed, when the user double-clicks on the tray-icon. No parameters are used.' );
      Add ( 1, atTrayIconMiddleClick, false, 'OnTrayIconMiddleClick', 'Click with middle mousebutton',
         'This action is executed, when the user clicks with the middle mousebutton on the tray-icon. '
          + 'No parameters used.' );
      Add ( 1, atTrayIconMiddleDblClick, false, 'OnTrayIconMiddleDblClick', 'Double-Click with middle mousebutton',
         'This action is executed, when the user double-clicks with the middle mousebutton on the tray-icon. No parameters are used.' );
      Add ( 0, atNone, false, 'News', 'News/Postings', '' );
      Add ( 1, atNewsPreprocess, false, 'NewsPreProcess', 'Pre-Process',
         'This action is executed first, when any posting is send through hamster, and before Hamster analyses, '
          + 'if all needed headers are set, if it is a local posting etc. Parameter contains the filename.');
      Add ( 1, atNews, false, 'NewsGeneral', 'Process',
         'This action is executed, before the posting is really saved. If a deeper action is '
          +'defined, too, the general action isn''t used. Parameter contains the filename.' );
      Add ( 2, atNewsOut, false, 'OutgoingNews', 'Outgoing News',
         'This action is used for postings to external newsservers. Parameter contains the filename.' );
      Add ( 2, atNewsLocal, false, 'LocalNews', 'Local Posting',
         'This action is used for postings to internal groups, Hamster waits always, until the'
          + 'action has executed. Parameter contains the filename.' );
      Add ( 2, atNewsGateway, false , 'Mail2News', 'Mail-to-News-Gateway',
         'This action is used for mails, which are converted to local postings. This conversion '
          + 'is done, if a "postto"-rule in the Mailfilt.hst is successfull. Hamster waits '
          + 'always, until the action has executed. Parameter contains the fileName.' );
      Add ( 1, atNewsInNNTP, false, 'NewsInNNTP', 'Incoming (NNTP)',
         'This action is executed for every posting pulled from an NNTP-Server (after Scoring). The usage '
          + 'of this action will increase the time needed for pulling news. '
          + 'Parameter contains the filename.');
      Add ( 0, atNone, false, 'Mails', 'Mails', '');
      Add ( 1, atMail, false, 'MailGeneral', 'Process',
         'This action is executed for every incoming or outgoing or local mail, save a deeper action '
          + 'is defined, too, then only the special action is used. '
          + 'Parameters contain filename and in some cases the user-account.' );
      Add ( 2, atMailHeader, false, 'MailHeader/2', 'Header of incoming mails',
         'This action is executed before the Mailfilt.hst test the mail, the original headers '
          + 'are saved, Hamster waits for the end of the action, so you can append or modify '
          + 'headers in the action, which are then checked by the Mailfilt.hst. Attention: '
          + 'The changes are permanent!'
          + 'Parameter contains the filename.' );
      Add ( 2, atMailIn, true, 'IncomingMail', 'Incoming Mail',
         'This action is executed for every incoming Mail (POP3-Server), please be '
          + 'carefully, if you change the mail itself not to damage it! '
          + 'Parameters contain filename and user-account.' );
      Add ( 2, atMailInternal, true, 'InternalMail', 'Internal Mail',
         'This action is executed for every internal Mail (Info-Mails from Hamster itself). '
          + 'Parameter contains the filename.' );
      Add ( 2, atMailLocal, true, 'LocalMail', 'Local Mail',
         'This action is executed for every Mail to an local account. '
          + 'Parameter contains the filename.' );
      Add ( 2, atMailOut, false, 'OutgoingMail', 'Outgoing Mail',
         'This action is executed for every Mail to an external mailadress. '
          + 'Parameter contains the filename.' );
      Add ( 0, atNone, false, 'DUN', 'DialUp-Network', 'DUN-Functions.');
      Add ( 1, atDUNBeforeDial, false, 'DUN.beforeDial', 'Before Dial',
         'This action is executed, when Hamster dials a DUN-Connection. The parameter '
         + 'contains the name of the DUN-connection to be dialed after.');
      Add ( 1, atDUNDialFailed, false, 'DUN.dialfailed', 'Dial failed',
         'This action is executed, when DUN-connection can''t be opened. The parameter '
         + 'contains the name of the DUN-connection which didn''t work.');
      Add ( 1, atDUNConnected, false, 'DUN.connected', 'Connected',
         'This action is executed, when DUN-connection was opened successfully. '
         + 'The parameter contains the given IP-address as a number.');
      Add ( 1, atDUNHangup, false, 'DUN.hangup', 'HangUp',
         'This action is executed, when a DUN-connection is closed wheather is was closed '
         + 'from windows before or by Hamster now.');
      Add ( 0, atNone, false, 'Mixed', 'Mixed', '' );
      Add ( 1, atSearchMID, false, 'SearchMID', 'Search unknown Message-ID',
         'This action is executed, when a message-id is asked by a newsreader, '
         + 'which is unknown to hamster and will be searched on next newsserver-pull. '
         + 'Parameter is the searched Message-ID.' );
      Add ( 1, atGroupDblClick, false, 'GroupDblClick', 'Double-Click on Newsgroup',
         'This action is executed, when the user double-click on a groupname in the '
          + 'news(server)-configuration-dialog. If not defined, Hamster opens the '
          + 'group-settings. Parameter is the groupname.' );
      tvActions.Perform ( WM_VSCROLL, SB_TOP, 0 );
      tvActions.Perform ( WM_HSCROLL, SB_LEFT, 0 );
   finally
      Userlist.free
   end;

   // Scriptlist
   Reload_Scriptlist;
   cbScript.Items.Assign ( Scriptlist );

   // Newsserverlist
   lbNewsserver.Clear;
   if FileExists2( PATH_BASE + CFGFILE_SERVER_NNTP ) then begin
      lbNewsserver.Items.LoadFromFile( PATH_BASE + CFGFILE_SERVER_NNTP )
   end;

   // Settings
   LoadSettings;
end;

Procedure TfrmConfigAutomatics.SaveActions;

   Procedure Test (Const Key, Value, Def: String);
   Var s: String;
   begin
      With CfgIni do begin
         s := ReadString('Actions', Key, Def);
         If s <> Value then begin
            If Value = Def then DeleteKey ('Actions',  Key)
                           else WriteString('Actions', Key, Value)
         end
      end
   end;

Var i: Integer; Info: TActionInfo2;
begin
   With tvActions do For i := 0 to Items.Count-1 do With Items[i] do begin
      Info := Data;
      With Info do begin
         If ActionTyp > atNone then begin
            Test ( ActionKey + '.Exec', Exec, '' );
            Test ( ActionKey + '.Pars', Pars, '' );
            Test ( ActionKey + '.Script', Script, '' );
            Test ( ActionKey + '.Scriptlines', ScriptlinesAsStr, '' );
            If Exec+Pars+Script > '' then begin
               Test ( ActionKey + '.Wait', IntToStr(Ord(Wait)), '0' )
            end;
            If Exec > '' then begin
               Test ( ActionKey + '.ExeStartType', IntToStr(Ord(ExeStartTyp)), '0')
            end
         end
      end
   end
end;

procedure TfrmConfigAutomatics.OKBtnClick(Sender: TObject);
begin
   CheckForMIDFileChanges;
   SaveSettings;
   SaveActions;
   ReloadActions;
   ModalResult := mrOK
end;


procedure TfrmConfigAutomatics.FormDestroy(Sender: TObject);
begin
   FreeAndNil(InsertCommand);
   TI := pg.ActivePage.PageIndex
end;

procedure TfrmConfigAutomatics.tvActionsChange(Sender: TObject;
  Node: TTreeNode);
Var b: Boolean;
begin
   SaveAction;
   AktEntry.Info := NIL;
   If Assigned(Node) then begin
      AktEntry.Node := Node;
      AktEntry.Info := Node.Data
   end;
   b := Assigned(AktEntry.Info) and (AktEntry.Info.ActionTyp > atNone);
   frEditAction.Visible := b;
   labActionSettings.Visible := b;
   butInfoForAction.visible := b;
   If b then begin
      ActionInfo := AktEntry.Info.Info;
      txtProgram.Text := AktEntry.Info.Exec;
      txtPars.Text := AktEntry.Info.Pars;
      With cbStartType do try ItemIndex := Ord(AktEntry.Info.ExeStartTyp)
      except ItemIndex := 0 end;
      chkWaitProgram.Checked := (AktEntry.Info.Wait IN[wAll, wExec])
                             or (AktEntry.Info.ActionTyp IN WaitAlways);
      chkWaitProgram.enabled := Not (AktEntry.Info.ActionTyp IN WaitAlways);
      cbScript.Text := AktEntry.Info.Script;
      MemoScriptlines.Lines.Assign(AktEntry.Info.Scriptlines);
      chkWaitScript2.Checked := (AktEntry.Info.Wait IN[wAll, wScript])
                             or (AktEntry.Info.ActionTyp IN WaitAlways);
      chkWaitScript2.enabled := Not (AktEntry.Info.ActionTyp IN WaitAlways);
   end
end;

procedure TfrmConfigAutomatics.OnExitActionInputField(Sender: TObject);
begin
   SaveAction
end;

procedure TfrmConfigAutomatics.SaveAction;
Var b: Boolean;
begin
   If Assigned(AktEntry.Info) then begin
      With AktEntry.Info do begin
         If ActionTyp > atNone then begin
            Exec := Trim(txtProgram.Text);
            Pars := Trim(txtPars.Text);
            Script := Trim(cbScript.Text);
            Scriptlines.Assign(MemoScriptlines.Lines);
            If chkWaitProgram.Checked and chkWaitScript2.Checked then Wait := wAll
            else If chkWaitProgram.Checked then Wait := wExec
            else If chkWaitScript2.Checked then Wait := wScript
            else Wait := wNone;
            ExeStartTyp := TExeStartType(cbStarttype.ItemIndex);
            b := Exec+Pars+Script+ScriptlinesAsStr > ''
         end else begin
            b := false
         end
      end;
      SetTreeNodeBold ( AktEntry.Node, b )
   end
end;

procedure TfrmConfigAutomatics.CheckForMIDFileChanges;
begin
   If (MIDFile > '') and butSaveMIDList.Enabled then begin
      If Application.MessageBox(
         PChar(Tr('MIDFile.SaveChanges', 'Do you want to save the changes on the last file?')),
         PChar(Caption),
         MB_ICONQUESTION + MB_YESNO ) = IDYES
      then begin
         butSaveMIDList.OnClick(NIL)
      end
   end
end;

procedure TfrmConfigAutomatics.lbNewsserverClick(Sender: TObject);
Var s: String; p: Integer;
begin
   CheckForMIDFileChanges;
   // Get Filename
   With lbNewsserver do begin
      If ItemIndex < 0 then Exit;
      s := Items[ItemIndex]
   end;
   p := Pos(',', s);
   If p > 0 then Delete(s, p, Length(s)-p+1);
   s := PATH_SERVER + s + '\' + SRVFILE_GETMIDLIST;
   // Load file
   With mMIDList.Lines do begin
      If FileExists2(s) then LoadFromFile(s) else Clear
   end;
   MIDFile := s;
   // Show Controls
   labMIDList.Visible := true;
   mMIDList.Visible := true;
   butSaveMIDList.Visible := true;
   butReloadMIDList.Visible := true;
   labMIDInfo.Visible := true;
   // Disable buttons
   butSaveMIDList.enabled := false;
   butReloadMIDList.enabled := false;
end;

procedure TfrmConfigAutomatics.mMIDListChange(Sender: TObject);
begin
   // Enable buttons
   butSaveMIDList.enabled := true;
   butReloadMIDList.enabled := true;
end;

procedure TfrmConfigAutomatics.butSaveMIDListClick(Sender: TObject);
begin
   mMIDList.Lines.SaveToFile (MIDFile);
   // Disable buttons
   butSaveMIDList.enabled := false;
   butReloadMIDList.enabled := false;
end;

procedure TfrmConfigAutomatics.butReloadMIDListClick(Sender: TObject);
begin
   If FileExists2(MIDFile)
      then mMIDList.Lines.LoadFromFile (MIDFile)
      else mMIDList.Lines.Clear;
   // Disable buttons
   butSaveMIDList.enabled := false;
   butReloadMIDList.enabled := false;
end;

procedure TfrmConfigAutomatics.butAddMIDsFromClipboardClick(
  Sender: TObject);
Var sl, slMIDFile: TStringList; MID, s: String;
    i, j, p: Integer; Save: Boolean;
begin
   sl := TStringList.Create;
   slMIDFile := TStringList.Create;
   try
      s := Clipboard.AsText;
      Repeat
         MID := '';
         p := Pos('<', s);
         If p = 0 then break;
         Delete(s, 1, p-1);
         p := Pos('>', s);
         If p = 0 then break;
         MID := Copy(s, 1, p);
         Delete(s, 1, p);
         If (Pos(#13, MID)=0) and (Pos(#10, MID)=0)
             and (Pos(' ', MID)=0) and (Pos(^I, MID)=0)
             and (Pos('@', MID) > 0)
         then begin
            sl.Add(MID)
         end
      until s = '';
      If sl.Count > 0 then begin
         CheckForMIDFileChanges;
         For i := 0 to lbNewsserver.Items.Count-1 do begin
            s := lbNewsserver.Items[i];
            p := Pos(',', s);
            If p > 0 then Delete(s, p, Length(s)-p+1);
            s := PATH_SERVER + s + '\' + SRVFILE_GETMIDLIST;
            With slMIDFile do begin
               If FileExists2(s) then LoadFromFile(s) else Clear;
               If Trim(Text) = '' then Clear;
               Save := false;
               For j := 0 to sl.Count-1 do begin
                  If IndexOf(sl[j]) < 0 then begin
                     Add(sl[j]);
                     Save := true
                  end
               end;
               If Save then SaveToFile(s)
            end
         end;
         If (MIDFile > '') and FileExists2(MIDFile) then begin
            mMIDList.Lines.LoadFromFile(MIDFile);
            butSaveMIDList.enabled := false;
            butReloadMIDList.enabled := false;
         end
      end; // sl.Count > 0
   finally
      sl.Free;
      slMIDFile.free
   end
end;

procedure TfrmConfigAutomatics.butInfoForActionClick(Sender: TObject);
begin
   MessageBox( 0, PChar(ActionInfo), PChar(Caption), MB_OK or MB_ICONINFORMATION );
end;

procedure TfrmConfigAutomatics.butEditActionScriptClick(Sender: TObject);
begin
   With cbScript do If Text > '' then EditFile(PATH_HSC + Text)
end;

procedure TfrmConfigAutomatics.butInserths2commandClick(Sender: TObject);
begin
   InsertCommand.PopUp
end;

end.

