// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit HConfigGroup;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, IniFiles, cStdForm, ShellApi, ComCtrls;

Procedure DialogEditGroup (Const Nam: String);

Procedure DialogEditGroupActivate (f: TForm);
Procedure DialogEditGroupExec (Const Nam: String);
Procedure DialogEditGroupDeactivate;

type
  TLocalServerInfo = Record Low, Min, Max: Integer end;
  TfrmConfigGroup = class(THForm)
    btnOK: TButton;
    btnCancel: TButton;
    GroupBox1: TGroupBox;
    emPullLimit: TEdit;
    labPullLimit: TLabel;
    labDaysToKeepArticles: TLabel;
    emKeepArts: TEdit;
    Label2: TLabel;
    Label4: TLabel;
    emDescription: TEdit;
    cboType: TComboBox;
    Label5: TLabel;
    cbPostServer: TComboBox;
    Label6: TLabel;
    optServer: TRadioButton;
    optFeederOnly: TRadioButton;
    cbPullLimitDef: TComboBox;
    butEditIni: TButton;
    tcRefs: TTabControl;
    tbRefNext: TTrackBar;
    labRefInfo: TLabel;
    butHelp: TButton;
    labMailto: TLabel;
    txtMailaddr: TEdit;
    labMailFor: TLabel;
    procedure butEditIniClick(Sender: TObject);
    procedure cbPullLimitDefClick(Sender: TObject);
    procedure cbPostServerClick(Sender: TObject);
    procedure tcRefsChange(Sender: TObject);
    procedure tbRefNextChange(Sender: TObject);
    procedure cboTypeClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
    Groupname, PostServer: String;
    Serverinfos: Array of TLocalServerInfo;
    bRefSet: Boolean;
    procedure LoadSettings;
    procedure SaveSettings;
    Procedure TestPullLimitField;
    procedure SetRefInfo (DoFull: boolean); // JAWO 20.07.01;
  public
    { Public-Deklarationen }
  end;

implementation

{$R *.DFM}

{JW} {ArtFile}
// uses Global, cArtFile, Config;
uses Global, Config;
{JW}

// Normal Execution

Procedure DialogEditGroup (Const Nam: String);
begin
   With TfrmConfigGroup.Create(NIL) do try
      Groupname := Nam;
      LoadSettings;
      If ShowModal = mrOK then begin
         SaveSettings
      end
   finally
      free
   end
end;

// Special Execution

Var
   Dlg: TfrmConfigGroup;
   ParentForm: TForm;

Procedure DialogEditGroupActivate (f: TForm);
begin
   Dlg := TfrmConfigGroup.Create(NIL);
   Parentform := f;
   f.Enabled := false;
   With Dlg do begin
      Caption := '';
      Show;
      Enabled := false
   end
end;
Procedure DialogEditGroupExec (Const Nam: String);
begin
   With Dlg do try
      Groupname := Nam;
      LoadSettings;
      Enabled := true;
      BringToFront;
      Modalresult := mrNone;
      cboType.SetFocus;
      emDescription.SetFocus;
      Repeat
         Application.ProcessMessages;
         Sleep(1)
      until (Not Visible) or (Modalresult <> mrNone);
      If Modalresult = mrOk then SaveSettings
   finally
      DialogEditGroupDeactivate
   end
end;
Procedure DialogEditGroupDeactivate;
begin
   If Assigned(Dlg) then With Dlg do begin
      Free;
      Dlg := NIL;
      ParentForm.Enabled := true;
      ParentForm.BringToFront
   end
end;

// ------------------------------------------

procedure TfrmConfigGroup.LoadSettings;
var  Filename, s, srv: String;
     x, i: Integer;
begin
   Caption := Caption + ' ' + Groupname;
   Filename := PATH_GROUPS + GroupName + '\data' + EXT_CFG;
   {emmIni.Lines.LoadFromFile( Filename );}

   With cboType.Items do begin
      Clear;
      AddObject (Tr('Type.y', 'Posting allowed ("y")'), Pointer(Ord('y')));
      AddObject (Tr('Type.n', 'Readonly ("n")'), Pointer(Ord('n')));
      AddObject (Tr('Type.m', 'Moderated ("m")'), Pointer(Ord('m')));
      AddObject (Tr('Type.g', 'Gateway ("g")'), Pointer(Ord('g')));
   end;

   With TIniFile.Create( Filename ) do try

      emDescription.Text := ReadString( 'Info',  'Description', '' );
      emKeepArts.Text    := ReadString( 'Setup', 'purge.articles.keepdays', '' );
      PostServer         := ReadString( 'Setup', 'postserver', '');

      s := ReadString( 'Setup', 'pull.limit', '' );
      With cbPullLimitDef do begin
         If s > '' then begin
            try x := StrToInt(s) except x := 0 end;
            If x = 0 then ItemIndex := 1
            else If x > 0 then ItemIndex := 2
            else ItemIndex := 3;
            emPullLimit.Text := IntToStr(Abs(x))
         end else begin
            ItemIndex := 0;
            emPullLimit.Text := ''
         end
      end;
      TestPullLimitField;

      s := ReadString( 'Setup', 'type', '' );
      if s='' then s:='y';
      if not( s[1] in ['y','n','m','g'] ) then s:='y';
      With cboType do begin
         for i:=0 to Items.Count-1 do begin
            if Char(Items.Objects[i])=s[1] then begin
               ItemIndex:=i;
               OnClick (NIL);
               break
            end
         end
      end;

      txtMailAddr.Text := ReadString( 'Setup', 'Moderator', '' );

      With cbPostServer do begin
         Clear;
         tcRefs.Tabs.Clear;
         Items.Add ('<'+Tr('Use.default.Postserver', 'Use default Post-Server')+'>');
         With CfgHamster do begin
            for i:=0 to PullCount-1 do begin
               if lowercase(PullGroup[i])=lowercase(GroupName) then begin
                  srv := PullServer[i];
                  if not ServerIsReadOnly[srv] then Items.Add (srv);
                  tcRefs.Tabs.Add (srv)
               end;
            end;
         end
      end;
      If Postserver > '' then i := cbPostServer.Items.IndexOf(Postserver)
                         else i := 0;
      If i < 0 then i := 0;
      cbPostServer.ItemIndex := i;
      optFeederOnly.Checked := ReadString( 'Setup', 'feedonly', '0' )='1';
      optServer.Checked := Not optFeederOnly.Checked;

      tcRefs.Visible := tcRefs.Tabs.Count > 0;
      SetLength (Serverinfos, tcRefs.Tabs.Count);
      For i := 0 to tcRefs.Tabs.Count-1 do With Serverinfos[i] do begin
         Low := ReadInteger ( 'Ranges', tcRefs.Tabs[i]+'.Low', 0);
         Min := ReadInteger ( 'Ranges', tcRefs.Tabs[i]+'.Min', 0);
         Max := ReadInteger ( 'Ranges', tcRefs.Tabs[i]+'.Max', Min);
      end;
      SetRefInfo (true)
   finally
      Free
   end
end;

procedure TfrmConfigGroup.SaveSettings;
var  Filename, s: String; x, i: Integer;
begin
   i := cbPostserver.ItemIndex;
   If i=0 then Postserver := ''
          else Postserver := cbPostserver.Items[i];
   Filename := PATH_GROUPS + GroupName + '\data' + EXT_CFG;

   With TIniFile.Create( Filename ) do try

      WriteString( 'Info', 'Description', emDescription.Text );

      // TGL: Auswahl statt >, <, =0 Gemurks
      s := emPullLimit.Text;
      x := 0;
      If s > '' then try x := Abs(StrToInt(s)) except end;
      Case cbPullLimitDef.ItemIndex of
         0: DeleteKey  ( 'Setup', 'pull.limit' );
         1: WriteString( 'Setup', 'pull.limit', '0' );
         2: WriteInteger( 'Setup', 'pull.limit', x );
         3: WriteInteger( 'Setup', 'pull.limit', -x );
      end;

      WriteString( 'Setup', 'Moderator', txtMailAddr.Text );

      s := emKeepArts.Text;
      if s='' then DeleteKey  ( 'Setup', 'purge.articles.keepdays' )
              else WriteString( 'Setup', 'purge.articles.keepdays', s );
   {JW}
      if optFeederOnly.checked then begin
         Postserver:='';              
         WriteString( 'Setup', 'feedonly', '1' );
      end else begin
         WriteString( 'Setup', 'feedonly', '0' )
      end;
   {JW}

      s := PostServer;
      if s='' then DeleteKey  ( 'Setup', 'postserver' )
              else WriteString( 'Setup', 'postserver', s );


      With cboType do begin
         If ItemIndex<0
            then s:='y'
            else s:=Char(Items.Objects[ItemIndex])
      end;
      if s='' then begin
         s:='y'
      end else begin
         if not( s[1] in ['y','n','m', 'g'] ) then s:='y'
      end;
      WriteString( 'Setup', 'type', s[1] );

      If tcRefs.Tabs.Count > 0 then begin
         For i := 0 to tcRefs.Tabs.Count-1 do With Serverinfos[i] do begin
            WriteInteger ( 'Ranges', tcRefs.Tabs[i]+'.Min', Min)
         end
      end

   finally
      Free
   end
end;

procedure TfrmConfigGroup.butEditIniClick(Sender: TObject);
begin
   EditFile (PATH_GROUPS + GroupName + '\data' + EXT_CFG)
end;

procedure TfrmConfigGroup.TestPullLimitField;
begin
   With emPullLimit do begin
      If cbPullLimitDef.ItemIndex > 1 then begin
         enabled := true; Color := clWindow; Font.Color := clWindowText
      end else begin
         enabled := false; Color := clBtnFace; Font.Color := clBtnFace
      end
   end
end;

procedure TfrmConfigGroup.cbPullLimitDefClick(Sender: TObject);
begin
   TestPullLimitField
end;

procedure TfrmConfigGroup.cbPostServerClick(Sender: TObject);
begin
   optServer.Checked := true
end;

procedure TfrmConfigGroup.tcRefsChange(Sender: TObject);
begin
   SetRefInfo (true); // JAWO 20.07.01
end;

Procedure TfrmConfigGroup.SetRefInfo (DoFull: boolean); // JAWO 20.07.01;
begin
   If Assigned(ServerInfos) then
   With ServerInfos [tcRefs.TabIndex] do begin
      labRefInfo.caption := TrF('labRefInfo',
         'Articles available on server from %s to %s, begin next pull with #%s e.g. reload last %s articles.',
         [IntToStr(Low), IntToStr(Max), IntToStr(Min+1), IntToStr(Max-Min)]);
      If DoFull then begin  // JAWO 20.07.01
         bRefSet := true;
//         tbRefNext.Min := 0;
//         tbRefNext.Max := 0;
//         tbRefNext.Position := 0;
         tbRefNext.Min := Max; // JAWO 20.07.01
         tbRefNext.Max := Max;
         tbRefNext.Min := Low;
         tbRefNext.Position := Min;
         tbRefNext.Invalidate;
         bRefSet := false
      end
   end
end;

procedure TfrmConfigGroup.tbRefNextChange(Sender: TObject);
begin
   If bRefSet then Exit;
   With ServerInfos [tcRefs.TabIndex] do begin
      Min := tbRefNext.Position;
      SetRefInfo (false) // JAWO 20.07.01
   end
end;

procedure TfrmConfigGroup.cboTypeClick(Sender: TObject);
Var c: Char; s: String; b: Boolean;
begin
   With cboType do begin
      If ItemIndex >= 0 then c := Char(Items.Objects[ItemIndex])
                        else c := 'y'
   end;
   s := '';
   Case c of
      'm': s := Tr('MailadressOf.Moderator', '(Moderator)');
      'g': s := Tr('MailadressOf.Gateway', '(Gateway)')
   end;
   b := s > '';
   labMailTo.Visible := b;
   txtMailAddr.Visible := b;
   labMailFor.Visible := b;
   labMailFor.Caption := s;
   b := c IN ['y', 'm'];
   optServer.Enabled := b;
   optFeederonly.Enabled := b;
   cbPostServer.Enabled := b;
end;

procedure TfrmConfigGroup.FormCreate(Sender: TObject);
begin
   optServer.Visible := Def_AdvancedConfiguration;
   optFeederOnly.Visible := Def_AdvancedConfiguration;
   butEditIni.Visible := Def_AdvancedConfiguration;
end;

end.
