// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR      m
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit HConfigLocalServer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, dGroupSelect, uTools, cStdForm, Menus;

Function DialogLocalServer: Boolean;

type
  TfrmConfigLocalServer = class(THForm)
    pg: TPageControl;
    tsGeneral: TTabSheet;
    tsNNTP: TTabSheet;
    tsPOP3: TTabSheet;
    gbLocalPOP3: TGroupBox;
    labPortPOP3: TLabel;
    emPop3Port: TEdit;
    OKBtn: TButton;
    CancelBtn: TButton;
    labMaxSizePOP3: TLabel;
    emMaxBytesPOP3: TEdit;
    Label16: TLabel;
    butHelp: TButton;
    labMaxPOP3Clients: TLabel;
    txtMaxPOP3ClientsAll: TEdit;
    gbNewsserver: TGroupBox;
    labPortNNTP: TLabel;
    emNntpPort: TEdit;
    txtMaxNNTPClientsAll: TEdit;
    labMaxNNTPClients: TLabel;
    labMaxSizeNNTP: TLabel;
    emMaxBytesNNTP: TEdit;
    labNNTPBytes: TLabel;
    tsRemoteControl: TTabSheet;
    labMaxPOP3ClientsAndIP: TLabel;
    txtMaxPOP3ClientsIP: TEdit;
    labMaxNNTPClientsAndIP: TLabel;
    txtMaxNNTPClientsIP: TEdit;
    gbFQDN: TGroupBox;
    labFQDNMID: TLabel;
    labFQDNHamster: TLabel;
    emFQDNMID: TEdit;
    chkMIDFQDNisLocal: TCheckBox;
    emFQDNHamster: TEdit;
    chkCryptMID: TCheckBox;
    gbLocalMails: TGroupBox;
    Label6: TLabel;
    Label19: TLabel;
    emIsLocalDomain: TEdit;
    Label29: TLabel;
    Label15: TLabel;
    emEnvelopeFrom: TEdit;
    chkSendInfoMailLocal: TCheckBox;
    tsSMTP: TTabSheet;
    gbLocalSMTP: TGroupBox;
    Label30: TLabel;
    Label3: TLabel;
    labSMTPSecurity: TLabel;
    labMaxSizeSMTP: TLabel;
    labSMTPBytes: TLabel;
    labMaxSMTPClients: TLabel;
    labMaxSMTPClientsAndIP: TLabel;
    emSmtpPort: TEdit;
    chkSmtpAuthPOP3: TCheckBox;
    chkGenMailMID: TCheckBox;
    chkSmtpAuthAUTH: TCheckBox;
    chkAddXHeaderMail: TCheckBox;
    emMaxBytesSMTP: TEdit;
    chkAddReceivedHeaderMail: TCheckBox;
    txtMaxSMTPClientsAll: TEdit;
    txtMaxSMTPClientsIP: TEdit;
    cbTLSSMTP: TComboBox;
    cbTLSNNTP: TComboBox;
    cbTLSPOP3: TComboBox;
    gbRemoteControl: TGroupBox;
    labReCoPort: TLabel;
    labMaxReCoClients: TLabel;
    labMaxReCoClientsAndIP: TLabel;
    emReCoPort: TEdit;
    txtMaxReCoClientsAll: TEdit;
    txtMaxReCoClientsIP: TEdit;
    cbBindNNTP: TComboBox;
    labBindNNTPtoIP: TLabel;
    cbBindPOP3: TComboBox;
    labBindPOP3toIP: TLabel;
    labBindSMTPtoIP: TLabel;
    cbBindSMTP: TComboBox;
    cbBindReco: TComboBox;
    labBindReCoToIP: TLabel;
    GroupBox2: TGroupBox;
    butIPAccess: TButton;
    Label7: TLabel;
    chkSMTPLocalMailReqNotAuth: TCheckBox;
    labSSLUsageSMTP: TLabel;
    labSSLUsagePOP3: TLabel;
    labSSLUsageNNTP: TLabel;
    chkTLSReco: TCheckBox;
    chkBounceUnknownLocalUsers: TCheckBox;
    labSMTPAddOpts: TLabel;
    chkAdvancedSettings: TCheckBox;
    tsIMAP: TTabSheet;
    gbLocalIMAP: TGroupBox;
    labPortIMAP: TLabel;
    labMaxSizeIMAP: TLabel;
    Label8: TLabel;
    labMaxIMAPClients: TLabel;
    labMaxIMAPClientsAndIP: TLabel;
    labBindIMAPtoIP: TLabel;
    labSSLUsageIMAP: TLabel;
    emIMAPPort: TEdit;
    emMaxBytesIMAP: TEdit;
    txtMaxIMAPClientsAll: TEdit;
    txtMaxIMAPClientsIP: TEdit;
    cbTLSIMAP: TComboBox;
    cbBindIMAP: TComboBox;
    Label23: TLabel;
    Label10: TLabel;
    emKeepArts: TEdit;
    Label11: TLabel;
    emKeepHist: TEdit;
    labKillfileLogPurge: TLabel;
    emKeepKill: TEdit;
    Label4: TLabel;
    labMailhistory: TLabel;
    txtMailHistory: TEdit;
    labPOP3SASL: TLabel;
    txtPOP3SASL: TPanel;
    butPOP3SASL: TButton;
    labSMTPSASL: TLabel;
    txtSMTPSASL: TPanel;
    butSMTPSASL: TButton;
    labReCoSASL: TLabel;
    txtReCoSASL: TPanel;
    butReCoSASL: TButton;
    pgNNTP: TPageControl;
    tsNNTP_AddHeader: TTabSheet;
    tsNNTP_AdditionalOptions: TTabSheet;
    tsNNTP_CancelMessages: TTabSheet;
    chkGenMID: TCheckBox;
    chkAddUserAgent: TCheckBox;
    chkAddAddPath: TCheckBox;
    chkPostToUnknown: TCheckBox;
    chkAddUnknownMIDs: TCheckBox;
    chkAddLocalInjection: TCheckBox;
    labCancels: TLabel;
    labSupersedes: TLabel;
    labCancelVerify: TLabel;
    labCancelControlMsgs: TLabel;
    labCancelWhere: TLabel;
    chkCancelsLocal: TCheckBox;
    chkCancelsNNTP: TCheckBox;
    chkCancelsFeed: TCheckBox;
    Label13: TLabel;
    Label14: TLabel;
    chkSupersedesLocal: TCheckBox;
    Label17: TLabel;
    chkSupersedesNNTP: TCheckBox;
    Label18: TLabel;
    chkSupersedesFeed: TCheckBox;
    chkCancelVerifyLocal: TCheckBox;
    Label20: TLabel;
    chkCancelVerifyNNTP: TCheckBox;
    Label21: TLabel;
    chkCancelVerifyFeed: TCheckBox;
    chkCancelControlMsgsLocal: TCheckBox;
    Label22: TLabel;
    chkCancelControlMsgsNNTP: TCheckBox;
    Label24: TLabel;
    chkCancelControlMsgsFeed: TCheckBox;
    Label1: TLabel;
    chkCancelDeleteLocal: TCheckBox;
    Label2: TLabel;
    chkCancelDeleteNNTP: TCheckBox;
    Label5: TLabel;
    chkCancelDeleteFeed: TCheckBox;
    chkIMAPDisableSASL: TCheckBox;
    chkIMAPDisableLOGIN: TCheckBox;
    labIMAPDisableAuthMethods: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure emFQDNMIDChange(Sender: TObject);
    procedure butIPAccessClick(Sender: TObject);
    procedure chkSmtpAuthAUTHClick(Sender: TObject);
    procedure chkAdvancedSettingsClick(Sender: TObject);
    procedure butPOP3SASLClick(Sender: TObject);
    procedure butSMTPSASLClick(Sender: TObject);
    procedure butReCoSASLClick(Sender: TObject);
  private
    procedure LoadSettings;
    procedure SaveSettings;
    procedure Test;
  end;

implementation

uses Global, fAccount, HConfigIPAccess, Config, dInput, fGroup,
     cIPAccess, hConfigSASL;

{$R *.DFM}

Function DialogLocalServer: Boolean;
begin
   With TfrmConfigLocalServer.Create(NIL) do try
      Result := ShowModal = mrOK
   finally Free end
end;

procedure TfrmConfigLocalServer.LoadSettings;
var  i: Integer; 
begin

   chkAdvancedSettings.Checked := Def_AdvancedConfiguration;

   With CfgIni do begin
      emNntpPort.Text := inttostr( ReadInteger( 'Setup', 'local.port.nntp', Def_LocalNntpServer_Port ) );
      emPop3Port.Text := inttostr( ReadInteger( 'Setup', 'local.port.pop3', Def_LocalPop3Server_Port ) );
      emIMAPPort.Text := inttostr( ReadInteger( 'Setup', 'local.port.IMAP', Def_LocalIMAPServer_Port ) ); //IMAP
      emSmtpPort.Text := inttostr( ReadInteger( 'Setup', 'local.port.smtp', Def_LocalSmtpServer_Port ) );
      emRECOPort.Text := inttostr( ReadInteger( 'Setup', 'local.port.reco', Def_LocalReCoServer_Port ) );

      txtMaxNNTPClientsAll.Text := IntToStr (ReadInteger ( 'Setup', 'MaxLocalNNTPServers',Def_Max_Local_NNTP_Servers ));
      txtMaxPOP3ClientsAll.Text := IntToStr (ReadInteger ( 'Setup', 'MaxLocalPOP3Servers',Def_Max_Local_POP3_Servers ));
      txtMaxIMAPClientsAll.Text := IntToStr (ReadInteger ( 'Setup', 'MaxLocalIMAPServers',Def_Max_Local_IMAP_Servers )); //IMAP
      txtMaxSMTPClientsAll.Text := IntToStr (ReadInteger ( 'Setup', 'MaxLocalSMTPServers',Def_Max_Local_SMTP_Servers ));
      txtMaxRECOClientsAll.Text := IntToStr (ReadInteger ( 'Setup', 'MaxLocalRECOServers',Def_Max_Local_RECO_Servers ));

      txtMaxNNTPClientsIP.Text := IntToStr (ReadInteger ( 'Setup', 'MaxLocalNNTPServersPerIP',Def_Max_Local_NNTP_Servers_Per_IP ));
      txtMaxPOP3ClientsIP.Text := IntToStr (ReadInteger ( 'Setup', 'MaxLocalPOP3ServersPerIP',Def_Max_Local_POP3_Servers_Per_IP ));
      txtMaxIMAPClientsIP.Text := IntToStr (ReadInteger ( 'Setup', 'MaxLocalIMAPServersPerIP',Def_Max_Local_IMAP_Servers_Per_IP )); //IMAP
      txtMaxSMTPClientsIP.Text := IntToStr (ReadInteger ( 'Setup', 'MaxLocalSMTPServersPerIP',Def_Max_Local_SMTP_Servers_Per_IP ));
      txtMaxRECOClientsIP.Text := IntToStr (ReadInteger ( 'Setup', 'MaxLocalRECOServersPerIP',Def_Max_Local_RECO_Servers_Per_IP ));

      chkSmtpAuthAUTH.Checked  := ReadBool( 'Setup', 'local.authreq.esmtp', Def_LocalAuthReqESmtp );
      chkSMTPLocalMailReqNotAuth.Checked
                               := ReadBool( 'Setup', 'local.mail.reqnotauth', Def_LocalMailReqNotAuth);
      chkSmtpAuthPOP3.Checked  := ReadBool( 'Setup', 'local.authreq.smtp',  Def_LocalAuthReqSmtp  );
      chkPostToUnknown.Checked := ReadBool( 'Setup', 'local.nntp.posttounknown', Def_LocalNntpPostToUnknown );
      chkAddUnknownMIDs.Checked := ReadBool( 'Setup', 'local.nntp.searchunknownMIDs', Def_LocalNntpSearchUnknownMIDs );

      chkAddXHeaderMail.Checked := ReadBool( 'Setup', 'mail.addxhamster', Def_Mail_AddXHamster );
      chkAddReceivedHeaderMail.checked := ReadBool( 'Setup', 'mail.addreceived', Def_Mail_AddReceived );
      emIsLocalDomain.Text   := ReadString( 'Setup', 'local.mail.islocaldomain', Def_IsLocalDomain );

      emKeepArts.Text  := inttostr( ReadInteger( 'Setup', 'purge.articles.keepdays', Def_Purge_Articles_KeepDays ) );
      emKeepHist.Text  := inttostr( ReadInteger( 'Setup', 'purge.history.keepdays',  Def_Purge_History_KeepDays ) );
      emKeepKill.Text  := inttostr( ReadInteger( 'Setup', 'purge.kills.keepdays',    Def_Purge_Kills_KeepDays ) );

      txtMailHistory.Text  := inttostr( ReadInteger( 'Setup', 'purge.mhistory.keepdays', Def_Purge_MHistory_KeepDays ));

      emMaxBytesNNTP.Text := inttostr( ReadInteger( 'Setup', 'local.limit.textsize.nntp', Def_LocalLimitTextSizeNntp ) );
      emMaxBytesPOP3.Text := inttostr( ReadInteger( 'Setup', 'local.limit.textsize.pop3', Def_LocalLimitTextSizePop3 ) );
      emMaxBytesIMAP.Text := inttostr( ReadInteger( 'Setup', 'local.limit.textsize.IMAP', Def_LocalLimitTextSizeIMAP ) ); //IMAP
      emMaxBytesSMTP.Text := inttostr( ReadInteger( 'Setup', 'local.limit.textsize.smtp', Def_LocalLimitTextSizeSmtp ) );

      chkCryptMID.checked := Readbool('Setup','mid.crypt',Def_crypt_MID);   //HSR {MID-Crypt}{optional}
      chkSendInfoMailLocal.checked := Readbool('Setup', 'SendInfoMailLocalOnly',Def_SendInfoMailLocalOnly); //HSR {{LOCAL_ONLY_ADMIN}{optional}

      emFQDNMID.Text      := ReadString( 'Setup', 'FQDN', Def_FQDNforMIDs );
      chkMIDFQDNisLocal.Checked := CfgIni.ReadBool('Setup', 'local.mail.LocalMIDFQDN', Def_MID_FQDN_local );
      emFQDNHamster.Text      := ReadString( 'Setup', 'FQDN2', Def_FQDN );
      emEnvelopeFrom.Text:= ReadString('Setup','DefaultEnvelopeFrom',Def_EnvelopeFrom); //HRR
      i := ReadInteger( 'Setup', 'generate.MID', Def_GenerateNewsMID );
      if emFQDNMID.Text='' then i := GENERATEMID_NEVER;
      chkGenMID.Checked := (i=GENERATEMID_IFNOTSET);

      i := ReadInteger( 'Setup', 'mail.generate.MID', Def_GenerateMailMID );
      chkGenMailMID.Checked := (i<>GENERATEMID_NEVER);

      chkBounceUnknownLocalUsers.Checked := CfgIni.ReadBool('Setup', 'local.mail.BounceIfUnknownUser', Def_BounceMailToSender);

      chkAddUserAgent.Checked   := ReadBool('SETUP','AddUserAgent', Def_News_AddUserAgent);

      chkAddAddPath.Checked := ReadBool('SETUP','News.AddPath',Def_News_AddPath);

      chkCancelsFeed.checked := ReadBool('Setup', 'news.feededcancel', Def_News_FeededCancel);
      chkSupersedesFeed.checked := ReadBool('Setup', 'news.feededsupersedes', Def_News_FeededSupersedes);
      chkCancelVerifyFeed.checked := ReadBool('Setup', 'news.feededcancelverify', Def_News_FeededCancelVerify );
      chkCancelControlMsgsFeed.checked := ReadBool( 'Setup', 'news.feededcancelcontrolmsg', Def_News_FeededCancelControlMsg);
      chkCancelDeleteFeed.Checked := ReadBool( 'Setup', 'news.feededcanceldelete', Def_News_FeededCancelDelete);

      txtPOP3SASL.Caption := ReadString ( 'Setup', 'local.pop3.sasl', Def_LocalPop3SASL );
      txtSMTPSASL.Caption := ReadString ( 'Setup', 'local.smtp.sasl', Def_LocalSmtpSASL );
      txtReCoSASL.Caption := ReadString ( 'Setup', 'local.reco.sasl', Def_LocalReCoSASL );

      cbTLSNNTP.ItemIndex := ReadInteger( 'Setup', 'local.nntp.tlsmode', Def_LocalNntpTlsMode );
      cbTLSSMTP.ItemIndex := ReadInteger( 'Setup', 'local.smtp.tlsmode', Def_LocalSMTPTlsMode );
      cbTLSPOP3.ItemIndex := ReadInteger( 'Setup', 'local.pop3.tlsmode', Def_LocalPOP3TlsMode );
      cbTLSIMAP.ItemIndex := ReadInteger( 'Setup', 'local.IMAP.tlsmode', Def_LocalIMAPTlsMode ); //IMAP

      chkTLSReco.Checked  := CfgIni.ReadBool ( 'Setup', 'local.reco.usetls', Def_LocalRecoUseTls );
      {/SSL}
      {JW} {li}
      chkAddLocalInjection.Checked := ReadBool('SETUP','news.localinjection',Def_News_LocalInjection);

      chkIMAPDisableSASL.Checked := ReadBool( 'Setup', 'IMAP.SASL.LOGINDisable', Def_IMAP_DisableSASLLogin );
      chkIMAPDisableLOGIN.Checked := ReadBool( 'Setup', 'IMAP.LOGINDisable', Def_IMAP_DisableLogin );
   end;
 {JW}
   // IP-ACCESS
   cbBindNNTP.Text := CfgIni.ReadString ( 'Setup', 'local.nntp.serverbind', Def_LocalNNTPServerBind);
   cbBindPOP3.Text := CfgIni.ReadString ( 'Setup', 'local.pop3.serverbind', Def_LocalPOP3ServerBind);
   cbBindIMAP.Text := CfgIni.ReadString ( 'Setup', 'local.IMAP.serverbind', Def_LocalIMAPServerBind); //IMAP
   cbBindSMTP.Text := CfgIni.ReadString ( 'Setup', 'local.smtp.serverbind', Def_LocalSMTPServerBind);
   cbBindRECO.Text := CfgIni.ReadString ( 'Setup', 'local.reco.serverbind', Def_LocalRECOServerBind);
end;

procedure IniWriteInt( Section, Item, Value: String );
var  iValue: Integer;
begin
   try
      iValue := strtoint( Value );
      CfgIni.WriteInteger( Section, Item, iValue );
   except
   end
end;

procedure TfrmConfigLocalServer.SaveSettings;
begin With CfgIni do begin
   IniWriteInt( 'Setup', 'local.port.nntp', emNntpPort.Text );
   if chkGenMID.Checked and (emFQDNMID.Text<>'')
      then WriteInteger( 'Setup', 'generate.MID', GENERATEMID_IFNOTSET )
      else WriteInteger( 'Setup', 'generate.MID', GENERATEMID_NEVER );

   WriteString ( 'Setup', 'FQDN', Trim(emFQDNMID.Text) );
   CfgIni.WriteBool('Setup', 'local.mail.LocalMIDFQDN', chkMIDFQDNisLocal.Checked );
   WriteString ( 'Setup', 'FQDN2', Trim(emFQDNHamster.Text) );

   emEnvelopefrom.Text:=Trim(emEnvelopeFrom.Text);  //HRR
   WriteString('Setup','DefaultEnvelopeFrom',emEnvelopeFrom.Text);
   IniWriteInt( 'Setup', 'purge.articles.keepdays', emKeepArts.Text );
   IniWriteInt( 'Setup', 'purge.history.keepdays',  emKeepHist.Text );
   IniWriteInt( 'Setup', 'purge.kills.keepdays',    emKeepKill.Text );
   WriteBool( 'Setup', 'local.nntp.posttounknown', chkPostToUnknown.Checked );
   WriteBool( 'Setup', 'local.nntp.searchunknownMIDs', chkAddUnknownMIDs.Checked );

   WriteBool( 'Setup', 'mail.addxhamster', chkAddXHeaderMail.Checked );
   WriteBool( 'Setup', 'mail.addreceived', chkAddReceivedHeaderMail.checked );

   WriteBool( 'Setup', 'local.mail.BounceIfUnknownUser', chkBounceUnknownLocalUsers.Checked);

   IniWriteInt( 'Setup', 'local.port.pop3', emPop3Port.Text );
   if chkGenMailMID.Checked
      then WriteInteger( 'Setup', 'mail.generate.MID', GENERATEMID_IFNOTSET )
      else WriteInteger( 'Setup', 'mail.generate.MID', GENERATEMID_NEVER );

   IniWriteInt( 'Setup', 'local.port.IMAP', emIMAPPort.Text ); //IMAP

   IniWriteInt( 'Setup', 'local.port.smtp', emSmtpPort.Text );
   WriteBool( 'Setup', 'local.authreq.smtp', chkSmtpAuthPOP3.Checked );
   WriteBool( 'Setup', 'local.mail.reqnotauth', chkSMTPLocalMailReqNotAuth.Checked);

   WriteBool( 'Setup', 'local.authreq.esmtp', chkSmtpAuthAUTH.Checked );
   WriteString( 'Setup', 'local.mail.islocaldomain', emIsLocalDomain.Text );

   IniWriteInt ( 'Setup', 'MaxLocalNNTPServers', txtMaxNNTPClientsAll.Text );
   IniWriteInt ( 'Setup', 'MaxLocalPOP3Servers', txtMaxPOP3ClientsAll.Text );
   IniWriteInt ( 'Setup', 'MaxLocalIMAPServers', txtMaxIMAPClientsAll.Text );//IMAP
   IniWriteInt ( 'Setup', 'MaxLocalSMTPServers', txtMaxSMTPClientsAll.Text );
   IniWriteInt ( 'Setup', 'MaxLocalRECOServers', txtMaxRECOClientsAll.Text );

   IniWriteInt ( 'Setup', 'MaxLocalNNTPServersPerIP', txtMaxNNTPClientsIP.Text );
   IniWriteInt ( 'Setup', 'MaxLocalPOP3ServersPerIP', txtMaxPOP3ClientsIP.Text );
   IniWriteInt ( 'Setup', 'MaxLocalIMAPServersPerIP', txtMaxIMAPClientsIP.Text );//IMAP
   IniWriteInt ( 'Setup', 'MaxLocalSMTPServersPerIP', txtMaxSMTPClientsIP.Text );
   IniWriteInt ( 'Setup', 'MaxLocalRECOServersPerIP', txtMaxRECOClientsIP.Text );

   IniWriteInt( 'Setup', 'local.limit.textsize.nntp', emMaxBytesNNTP.Text );
   IniWriteInt( 'Setup', 'local.limit.textsize.pop3', emMaxBytesPOP3.Text );
   IniWriteInt( 'Setup', 'local.limit.textsize.IMAP', emMaxBytesIMAP.Text ); //IMAP
   IniWriteInt( 'Setup', 'local.limit.textsize.smtp', emMaxBytesSMTP.Text );

   With txtPOP3SASL do If Caption = POP3SupportedSASL
      then DeleteKey ( 'Setup', 'local.pop3.sasl' )
      else WriteString ( 'Setup', 'local.pop3.sasl', Caption );
   With txtSMTPSASL do If Caption = SMTPSupportedSASL
      then DeleteKey ( 'Setup', 'local.smtp.sasl' )
      else WriteString ( 'Setup', 'local.smtp.sasl', Caption );
   With txtReCoSASL do If Caption = ReCoSupportedSASL
      then DeleteKey ( 'Setup', 'local.reco.sasl' )
      else WriteString ( 'Setup', 'local.reco.sasl', Caption );

   IniWriteInt( 'Setup', 'purge.mhistory.keepdays', txtMailHistory.Text );

   Writebool('Setup','mid.crypt',chkCryptMID.checked);   //HSR {MID-Crypt}{optional}
   {JW} {chkSendInfoMailLocal}
   //   Writebool('Setup','SendInfoMailLocalOnly', Def_SendInfoMailLocalOnly); //HSR {{LOCAL_ONLY_ADMIN}{optional}
   Writebool('Setup','SendInfoMailLocalOnly', chkSendInfoMailLocal.checked);
   {/JW}
   WriteBool( 'SETUP','AddUserAgent',chkAddUserAgent.Checked); {JW} {Useragent}
   WriteBool( 'SETUP','news.AddPath',chkAddAddpath.Checked); {JW} {AddPath}

   WriteBool( 'Setup', 'news.feededcancel', chkCancelsFeed.checked);
   WriteBool( 'Setup', 'news.feededsupersedes', chkSupersedesFeed.checked);
   WriteBool( 'Setup', 'news.feededcancelverify', chkCancelVerifyFeed.checked );
   WriteBool( 'Setup', 'news.feededcancelcontrolmsg', chkCancelControlMsgsFeed.checked);
   WriteBool( 'Setup', 'news.feededcanceldelete', chkCancelDeleteFeed.checked);

{MG}{SSL}
   WriteInteger( 'Setup', 'local.nntp.tlsmode', cbTLSNNTP.ItemIndex );
   WriteInteger( 'Setup', 'local.smtp.tlsmode', cbTLSSMTP.ItemIndex );
   WriteInteger( 'Setup', 'local.pop3.tlsmode', cbTLSPOP3.ItemIndex );
   WriteInteger( 'Setup', 'local.IMAP.tlsmode', cbTLSIMAP.ItemIndex ); //IMAP
   WriteBool   ( 'Setup', 'local.reco.usetls', chkTLSReco.Checked );

   WriteBool( 'SETUP','news.localinjection',chkAddLocalInjection.Checked); {JW} {li}

   // IP-ACCESS
   WriteString ( 'Setup', 'local.nntp.serverbind', cbBindNNTP.Text);
   WriteString ( 'Setup', 'local.pop3.serverbind', cbBindPOP3.Text);
   WriteString ( 'Setup', 'local.IMAP.serverbind', cbBindIMAP.Text); //IMAP
   WriteString ( 'Setup', 'local.smtp.serverbind', cbBindSMTP.Text);
   WriteString ( 'Setup', 'local.ReCo.serverbind', cbBindRECO.Text);

   WriteString( 'Setup', 'local.port.reco', emRECOPort.Text );

   WriteBool( 'Setup', 'IMAP.SASL.LOGINDisable', chkIMAPDisableSASL.Checked );
   WriteBool( 'Setup', 'IMAP.LOGINDisable', chkIMAPDisableLOGIN.Checked );

end end;

Var TI: Integer = 0;
    TINNTP: Integer = 0;

procedure TfrmConfigLocalServer.FormCreate(Sender: TObject);
Var s: String;
begin
   pg.ActivePage := pg.Pages[TI];
   pgNNTP.ActivePage := pgNNTP.Pages[TINNTP];

   LoadSettings;

   s := Tr('HintInfoAboutFQDNs',
        'ATTENTION: FQDN stands for "Full qualified domain name". It has to '
         + 'be a world-wide unique and registered identifier. Especially, '
         + 'if you are going to use this server as a peering partner for other '
         + 'servers, a false FQDN could generate much problems. And if the FQDN '
         + 'for Message-IDs is not unique, your postings could collide with other '
         + 'postings from other people.');
   emFQDNMID.hint := s;
   emFQDNHamster.hint := s;

   // IP-ACCESS
   cbBindNNTP.Items.Text := '127.0.0.1' + #13#10 + GetLocalIPs;
   If Def_AdvancedConfiguration then cbBindNNTP.Items.Add('0.0.0.0');
   cbBindPOP3.Items.Assign (cbBindNNTP.Items);
   cbBindIMAP.Items.Assign (cbBindNNTP.Items); //IMAP
   cbBindSMTP.Items.Assign (cbBindNNTP.Items);
   cbBindReCo.Items.Assign (cbBindNNTP.Items);
end;

procedure TfrmConfigLocalServer.OKBtnClick(Sender: TObject);

   Function TestFQDN (Const ed: TEdit): boolean;
   Var s: String; i, m: Integer; c: Char;
       b, IsIP: Boolean; IP: Array[1..4] of Integer;
   begin
      Result := true;
      s := LowerCase(Trim(Ed.text));
      If s > '' then begin
         IsIP := true; m := 1;
         For i := 1 to 4 do IP[i]:=0;
         For i := 1 to Length(s) do If IsIP then begin
            c := s[i];
            If c = '.' then begin
               Inc(m);
               If m > 4 then IsIP := false
            end else begin
               If c IN ['0'..'9'] then begin
                  IP[m] := IP[m]*10 + Ord(c) - Ord('0');
                  If IP[m] > 255 then IsIP := false
               end else IsIP := false
            end
         end;
         If IsIP then IsIP := m = 4;
         If IsIP
            then b := (IP[1] = 127) or (IP[1] = 10)
                      or ((IP[1]=192) and (IP[2]=168))
                      or ((IP[1]=172) and (IP[2]>=16) and (IP[2]<32))
            else b := ((Length(s)>=9) and (Copy(s, Length(s)-8, 9)='localhost'))
                      or (Pos('@', s) > 0) or (Pos('.', s)=0) or (Pos(' ', s)>0);
         If b then begin
            pg.ActivePage := tsGeneral;
            Ed.SetFocus;
            Application.MessageBox (PChar(TrF('FQDN.UnallowedValue2',
               '"%s" is not an full qualified domain name, please enter nothing'
                   +' or an valid FQDN!', ed.text)),
               PChar(Caption), MB_ICONWARNING + MB_OK );
            Result := false
         end
      end
   end;

Var s: String;
begin
   // Local Domains
   If Not TestFQDN (emFQDNMID) then exit;
   If Not TestFQDN (emFQDNHamster) then Exit;
   // Envelope from
   s := Trim(emEnvelopeFrom.Text);
   If s = '' then begin
      pg.ActivePage := tsGeneral;
      emEnvelopeFrom.SetFocus;
      If Application.MessageBox (PChar(Tr('EnvelopeFrom.missed',
            'This "Envelope-From-Adress"-field must be filled! Choose "Yes" to fill it with the default value "admin".')),
            PChar(Caption), MB_ICONWARNING + MB_YESNO )
         = IDYES then emEnvelopeFrom.Text := 'admin';
      Exit
   end;
   // IP-Access
   s := '';
   With cbBindNNTP do If Not IsValidIP (Text) then begin
      pg.ActivePage := tsNNTP;
      Application.MessageBox(
         PChar(TrF('SaveError.NoValidIP', '"%s" is no valid IP', text)),
         PChar(caption),
         MB_ICONINFORMATION + MB_OK );
      Exit
   end;
   With cbBindPOP3 do If Not IsValidIP (Text) then begin
      pg.ActivePage := tsPOP3;
      Application.MessageBox(
         PChar(TrF('SaveError.NoValidIP', '"%s" is no valid IP', text)),
         PChar(caption),
         MB_ICONINFORMATION + MB_OK );
      Exit
   end;
   With cbBindSMTP do If Not IsValidIP (Text) then begin
      pg.ActivePage := tsSMTP;
      Application.MessageBox(
         PChar(TrF('SaveError.NoValidIP', '"%s" is no valid IP', text)),
         PChar(caption),
         MB_ICONINFORMATION + MB_OK );
      Exit
   end;
   With cbBindIMAP do If Not IsValidIP (Text) then begin //IMAP
      pg.ActivePage := tsIMAP;
      Application.MessageBox(
         PChar(TrF('SaveError.NoValidIP', '"%s" is no valid IP', text)),
         PChar(caption),
         MB_ICONINFORMATION + MB_OK );
      Exit
   end;
   // Ready
   SaveSettings;
   ModalResult := mrOK
end;

procedure TfrmConfigLocalServer.FormDestroy(Sender: TObject);
begin
   TI := pg.ActivePage.PageIndex;
   TINNTP := pgNNTP.ActivePage.PageIndex;
end;

Procedure TfrmConfigLocalServer.Test;
Var b: Boolean;
begin
   b := Trim(emFQDNMID.Text)>'';
   chkCryptMid.Enabled := b;
   chkGenMID.Enabled := b;
   chkGenMailMID.Enabled := b;
   b := Trim(emFQDNHamster.Text)>'';
   chkAddAddPath.Enabled := b;
   chkAddLocalInjection.Enabled := b;
   b := chkSmtpAuthAUTH.Checked;
   chkSMTPLocalMailReqNotAuth.Enabled := b
end;

procedure TfrmConfigLocalServer.emFQDNMIDChange(Sender: TObject);
begin
   Test
end;

procedure TfrmConfigLocalServer.butIPAccessClick(Sender: TObject);
begin
   DialogIPAccess
end;

procedure TfrmConfigLocalServer.chkSmtpAuthAUTHClick(Sender: TObject);
begin
   Test
end;

procedure TfrmConfigLocalServer.chkAdvancedSettingsClick(Sender: TObject);
Var b: Boolean; i: Integer; c: TControl;
begin

   b := chkAdvancedSettings.checked;

   // Tabsheets
   tsGeneral.TabVisible := b;
   tsRemoteControl.TabVisible := b;

   // Single Settings
   // - News
   labSSLUsageNNTP.Visible := b; cbTLSNNTP.Visible := b;
   labMaxNNTPClients.Visible := b; txtMaxNNTPClientsAll.Visible := b;
   labMaxNNTPClientsAndIP.Visible := b; txtMaxNNTPClientsIP.Visible := b;
   chkAddAddPath.Visible := b;
   chkAddLocalInjection.Visible := b;
   labMaxSizeNNTP.Visible := b; emMaxBytesNNTP.Visible := b; labNNTPBytes.Visible := b;
   // - POP3
   labSSLUsagePOP3.Visible := b; cbTLSPOP3.Visible := b;
   labMaxPOP3Clients.Visible := b; txtMaxPOP3ClientsAll.Visible := b;
   labMaxPOP3ClientsAndIP.Visible := b; txtMaxPOP3ClientsIP.Visible := b;
   // - IMAP
   labSSLUsageIMAP.Visible := b; cbTLSIMAP.Visible := b;
   labMaxIMAPClients.Visible := b; txtMaxIMAPClientsAll.Visible := b;
   labMaxIMAPClientsAndIP.Visible := b; txtMaxIMAPClientsIP.Visible := b;
   // - SMTP
   labSSLUsageSMTP.Visible := b; cbTLSSMTP.Visible := b;
   labMaxSMTPClients.Visible := b; txtMaxSMTPClientsAll.Visible := b;
   labMaxSMTPClientsAndIP.Visible := b; txtMaxSMTPClientsIP.Visible := b;
   chkSMTPLocalMailReqNotAuth.Visible := b;
   labSMTPAddOpts.Visible := b;
   chkBounceUnknownLocalUsers.Visible := b;
   labMaxSizeSMTP.Visible := b; emMaxBytesSMTP.Visible := b; labSMTPBytes.Visible := b;
   chkAddReceivedHeaderMail.Visible := b;
   labKillfileLogPurge.Visible := b; emKeepKill.Visible := b;

   If Archivmode then begin
      tsGeneral.TabVisible := false;
      With gbNewsserver do begin
         For i := 0 to ControlCount-1 do begin
            c := Controls[i];
            If (c <> labPortNNTP) and (c <> emNNTPPort) then c.Visible := false
         end
      end;
      With gbLocalPOP3 do begin
         For i := 0 to ControlCount-1 do begin
            c := Controls[i];
            If (c <> labPortPOP3) and (c <> emPOP3Port) then c.Visible := false
         end
      end;
      With gbLocalIMAP do begin //IMAP
         For i := 0 to ControlCount-1 do begin
            c := Controls[i];
            If (c <> labPortIMAP) and (c <> emIMAPPort) then c.Visible := false
         end
      end;
      With gbLocalSMTP do begin
         For i := 0 to ControlCount-1 do begin
            c := Controls[i];
            c.Visible := false
         end
      end
   end

end;

procedure TfrmConfigLocalServer.butPOP3SASLClick(Sender: TObject);
begin
   With txtPOP3SASL do Caption := ChooseSASL ( POP3SupportedSASL, Caption )
end;

procedure TfrmConfigLocalServer.butSMTPSASLClick(Sender: TObject);
begin
   With txtSMTPSASL do Caption := ChooseSASL ( SMTPSupportedSASL, Caption )
end;

procedure TfrmConfigLocalServer.butReCoSASLClick(Sender: TObject);
begin
   With txtReCoSASL do Caption := ChooseSASL ( ReCoSupportedSASL, Caption )
end;

end.
