// ============================================================================U
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR      m
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit HConfigLocalUser;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, dGroupSelect, uTools, cStdForm, Menus;

Function DialogLocalUserAndPWs: boolean;

type
  TfrmConfigUserAndPW = class(THForm)
    pg: TPageControl;
    TabPasswords: TTabSheet;
    Label5: TLabel;
    lstPasswords: TListBox;
    btnPasswordsEdit: TButton;
    btnPasswordsClear: TButton;
    TabAccounts: TTabSheet;
    Label28: TLabel;
    btnGroupAdd: TButton;
    btnAccDel: TButton;
    btnAccEdit: TButton;
    Button2: TButton;
    Button3: TButton;
    labPWBase: TLabel;
    cbPWBase: TComboBox;
    labMaxScriptPW: TLabel;
    emMaxScriptPW: TEdit;
    trAccount: TTreeView;
    Tree1Popup: TPopupMenu;
    Tree2Popup: TPopupMenu;
    NewUser1: TMenuItem;
    EditGroup1: TMenuItem;
    DeleteGroup1: TMenuItem;
    EditUser1: TMenuItem;
    DeleteUser1: TMenuItem;
    TreeFullExp: TCheckBox;
    btnUserAdd: TButton;
    NewGroup1: TMenuItem;
    butHelp: TButton;
    tsAliases: TTabSheet;
    Label1: TLabel;
    mAliases: TMemo;
    Label2: TLabel;
    chkAdvancedSettings: TCheckBox;
{JW}
    procedure FormCreate(Sender: TObject);
    procedure btnPasswordsEditClick(Sender: TObject);
    procedure btnPasswordsClearClick(Sender: TObject);
    procedure cbPWBaseChange(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure emMaxScriptPWExit(Sender: TObject);
{HSR} {GROUPS}
    procedure trAccountContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure NewUser1Click(Sender: TObject);
    procedure DeleteUser1Click(Sender: TObject);
    procedure EditUser1Click(Sender: TObject);
    procedure EditGroup1Click(Sender: TObject);
    procedure DeleteGroup1Click(Sender: TObject);
    procedure BtnAddClick(Sender: TObject);
    procedure BtnEditClick(Sender: TObject);
    procedure BtnDeleteClick(Sender: TObject);
    procedure NewGroup1Click(Sender: TObject);
    procedure trAccountChange(Sender: TObject; Node: TTreeNode);
    procedure trAccountMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure trAccountDblClick(Sender: TObject);
    procedure trAccountDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure trAccountDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure chkAdvancedSettingsClick(Sender: TObject);
{/HSR}
  private
    { Private-Deklarationen }
    OldPWBase, AnzRAS: Integer;
    procedure LoadSettings;
    procedure SaveSettings;
    procedure ShowPasswords;
    Procedure ShowAccounts( Const SelGroup: String; Const SelUserID: Integer);              //HSR //Groups (gendert)
    function  EntryWithUserAndPW(const s: String): String;
{HSR} {Groups}
    procedure EditGroup(GroupName: string);

    procedure NewGroup;
    procedure DeleteGroup(GroupID : Integer);
    procedure EditUser(UserID : integer);
    procedure NewUser(Group : string);
    procedure DeleteUser(UserID : integer);
    procedure SetStateForAccountButtons;
    Procedure TestDragDrop(Source: TObject; X, Y: Integer; Var Von, Nach: TTreeNode);
{/HSR}
  end;

implementation

uses Global, fAccount, cAccount, Config, cPasswordFile, dInput,
     fGroup, cMailAlias;

{$R *.DFM}

Function DialogLocalUserAndPWs: boolean;
begin
   With TfrmConfigUserAndPW.Create (NIL) do try
      Result := ShowModal = mrOK
   finally Free end
end;

procedure TfrmConfigUserAndPW.ShowAccounts( Const SelGroup: String; Const SelUserID: Integer);              //HSR //Groups (gendert)
var  UserIDs, Groups: TStringList;
     UserID, i, p: Integer;
     UserName, Group, s: String;
     Nodes: TTreeNodes; SelN, N: TTreeNode;
begin
   Groups := TStringList.Create;
   UserIDs := TStringList.Create;
   SelN := NIL;
   With trAccount do try
      Nodes := Items;
      Nodes.BeginUpdate;
      try
         Nodes.Clear;
         With CfgAccounts.GrpFile do begin
            For i:=1 to ReadInteger( GRPM_SECTION,GRPM_GROUPMAX,1) do begin
               s := ReadString(GRPM_SECTION2,IntToStr(i),'');
               N := Nodes.Add (NIL, s+ ', '+ CfgAccounts.ValueOfGroup[i, GRP_DESC]);
               Groups.AddObject(s, N);
               If s = SelGroup then SelN := N
            end
         end;
         CfgAccounts.SnapshotOfIDs( UserIDs );
         for i:=0 to UserIDs.Count-1 do begin
            UserID := LongInt( UserIDs.Objects[i] );
            UserName := CfgAccounts.Value[ UserID, ACTP_USERNAME ];
            Group    := CfgAccounts.Value[ UserID, ACTP_GROUP    ];
            p := Groups.IndexOf(Group);
            If (Group='') or (p<0) then begin
               p := 0; Group := Groups[p];
               CfgAccounts.Value[UserID, ACTP_GROUP]:=Group
            end;
            s := UserName + ', ' + CfgAccounts.Value[UserID,ACTP_FULLNAME] + ', ';
            If Trim(CfgAccounts.Value[UserID,ACTP_PASSWORD])=''
               then s:=s+TrGl(kGlobal, 'PW.None','{NONE}')
               else s:=s+TrGl(kGlobal, 'PW.Set','{SET}');
            N := Nodes.AddChild(Groups.Objects[p] as TTreeNode, s);
            If UserID = SelUserID then SelN := N
         end;
         if TreeFullExp.checked then FullExpand;
         SetStateForAccountButtons;
         If Assigned(SelN) then Selected := SelN;
         n := nodes.Item[0];
         While Assigned(n) do begin
           n.Alphasort;
           n := n.getNextSibling
         end
      finally
         Nodes.EndUpdate
      end
   finally
      UserIDs.Free; Groups.free
   end
end;

procedure TfrmConfigUserAndPW.SetStateForAccountButtons;
Var b: Boolean;
begin
   b := Assigned(trAccount.Selected);
   btnUserAdd.Enabled := b;
   btnAccEdit.Enabled := b;
   btnAccDel.Enabled := b;
end;

procedure TfrmConfigUserAndPW.LoadSettings;
begin
   chkAdvancedSettings.Checked := Def_AdvancedConfiguration;
   ShowPasswords;
   ShowAccounts( 'Admin', ACTID_INVALID );
   With CfgIni do begin
      OldPWBase  := ReadInteger( 'Setup', 'password.codebase', Def_PasswordCodeBase );
      cbPWBase.ItemIndex  := OldPWBase;
      emMaxScriptPW.Text  := IntToStr( ReadInteger( 'Setup', 'MaxScriptPWNumber', Def_MaxScriptPWNumber ));
   end;
   TreeFullExp.checked := CfgIni.ReadBool('Setup','config.local.treefull', Def_Cfg_Tree_Fullexpand);
   if TreeFullExp.checked then trAccount.FullExpand;
   { TODO : BESCHREIBUNG!!!!!! }
   MailAlias.LoadFromFile (mAliases.Lines)
end;

procedure IniWriteInt( Section, Item, Value: String );
var  iValue: Integer;
begin
     try
        iValue := strtoint( Value );
        CfgIni.WriteInteger( Section, Item, iValue );
     except
     end;
end;

procedure TfrmConfigUserAndPW.SaveSettings;
begin With CfgIni do begin
   WriteInteger ( 'Setup', 'password.codebase', cbPWBase.ItemIndex );
   IniWriteInt ( 'Setup', 'MaxScriptPWNumber', emMaxScriptPW.Text );
   WriteBool( 'Setup', 'config.local.treefull', TreeFullExp.checked); //HSR //Groups
   MailAlias.SaveIntoFile (mAliases.Lines)
end end;

Var TI: Integer = 0;

procedure TfrmConfigUserAndPW.FormCreate(Sender: TObject);
begin
   pg.ActivePage := pg.Pages[TI];
   LoadSettings;
end;

Function TfrmConfigUserAndPW.EntryWithUserAndPW (Const s: String): String;
Var u, p: String;
begin
   if PasswordFile.LoadPassword( s, u, p ) then begin
      if u='' then u:=TrGl(kGlobal, 'PW.None','{NONE}')
              else if u<>'?' then begin
                 if Copy(s,1,1)='$' then u:='"'+u+'"'
                                    else u:=TrGl(kGlobal, 'PW.Set','{SET}');
              end;
      if p='' then p:=TrGl(kGlobal, 'PW.None','{NONE}')
              else if p<>'?' then p:=TrGl(kGlobal, 'PW.Set','{SET}');
   end else begin
      u := TrGl(kGlobal, 'PW.None','{NONE}');
      p := TrGl(kGlobal, 'PW.None','{NONE}');
   end;
   if u='?' then u:=TrGl(kGlobal, 'PW.Ask','{ASK}');
   if p='?' then p:=TrGl(kGlobal, 'PW.Ask','{ASK}');
   Result := s + ',' + u + ',' + p
end;

procedure TfrmConfigUserAndPW.ShowPasswords;
var  i : Integer;
     TS, RasConns   : TStringList;
     l              : LongInt;
     OldItemIndex   : Integer;
begin
   OldItemIndex := lstPasswords.ItemIndex;

   lstPasswords.Clear;

   TS := TStringList.Create;

   try
      TS.Sorted := True;
      TS.Duplicates := dupIgnore;

      // add RAS-connections
      RasConns := TStringList.Create;
      try
         With TRasDialer.Create do try
            GetConnectionList( RasConns )
         finally free end;
         AnzRAS := RasConns.Count;
         for l:=0 to AnzRAS-1 do TS.Add( RasConns[l] )
      finally
         RasConns.Free
      end;

      // add placeholders to be used in scripts
      TS.Sorted := False;
      for i:=1 to Def_MaxScriptPWNumber do TS.Add( '$' + inttostr(i) );

      // show current settings
      for i:=0 to TS.Count-1 do lstPasswords.Items.Add( EntryWithUserAndPW (TS[i]) );

      if (OldItemIndex>=0) and (OldItemIndex<lstPasswords.Items.Count) then begin
         lstPasswords.ItemIndex := OldItemIndex;
      end else begin
         lstPasswords.ItemIndex := 0;
      end
   finally TS.free end
end;

procedure TfrmConfigUserAndPW.btnPasswordsEditClick(Sender: TObject);
var  i, j : Integer;
     s    : String;
     ID   : String;
     U, P1, P2: String;
begin
     if (lstPasswords.ItemIndex<0) or (lstPasswords.ItemIndex>=lstPasswords.Items.Count) then exit;
     i := lstPasswords.ItemIndex;
     s := lstPasswords.Items[i];
     if copy(s,1,1)='#' then s := '';
     if s='' then exit;
     j  := Pos( ',', s );
     ID := copy( s, 1, j-1 );
     U  := '';
     P1 := '';
     P2 := '';
     if not InputDlgStr( PChar(ID), TrGl(kGlobal,'DlgPWEdit.Username', 'Username (?=ask when needed):'), U,
        0{HlpInputUserPasswordForLocal} ) then exit;
     if not InputDlgPwd( PChar(ID), TrGl(kGlobal,'DlgPWEdit.Password', 'Password (?=ask when needed):'), P1,
        0{HlpInputUserPasswordForLocal} ) then exit;
     if (P1<>'') and (P1<>'?') then begin
        if not InputDlgPwd( PChar(ID), TrGl(kGlobal,'DlgPWEdit.RepeatPW', 'Repeat password:'), P2,
           0{HlpInputUserPasswordForLocal} ) then exit;
        if P1<>P2 then begin
           Application.MessageBox( PChar(TrGl(kGlobal,'DlgPWEdit.DifferentPWs',
                                   'Given passwords were not equal!^MPassword remains unchanged!')),
                                   PChar(TrGl(kGlobal,'DlgPWEdit.Caption', 'Change password')),
                                   MB_ICONEXCLAMATION );
           exit
        end
     end;

     PasswordFile.SavePassword( True, ID, U, P1 );
     ShowPasswords
end;

procedure TfrmConfigUserAndPW.btnPasswordsClearClick(Sender: TObject);
var  i, j : Integer;
     s    : String;
     ID   : String;
     U, P : String;
begin
     if (lstPasswords.ItemIndex<0) or (lstPasswords.ItemIndex>=lstPasswords.Items.Count) then exit;

     i := lstPasswords.ItemIndex;
     s := lstPasswords.Items[i];
     if copy(s,1,1)='#' then s := '';
     if s='' then exit;

     j  := Pos( ',', s );
     ID := copy( s, 1, j-1 );

     U := '';
     P := '';

     PasswordFile.SavePassword( True, ID, U, P );
     ShowPasswords
end;

procedure TfrmConfigUserAndPW.cbPWBaseChange(Sender: TObject);
begin
   If OldPWBase <> cbPWBase.ItemIndex then
      Application.MessageBox (PChar(Tr('PWBaseChange.RestartAndSetPWsAgain',
         'You have to restart Hamster and set all passwords again after changing this value!')),
         PChar(Caption), MB_ICONWARNING + MB_OK )
end;

procedure TfrmConfigUserAndPW.Button2Click(Sender: TObject);
begin
   SaveSettings;
   ModalResult := mrOK
end;

procedure TfrmConfigUserAndPW.FormDestroy(Sender: TObject);
begin
   TI := pg.ActivePage.PageIndex
end;

procedure TfrmConfigUserAndPW.emMaxScriptPWExit(Sender: TObject);
Var Neu, i: Integer;
begin
   try
      Neu := StrToInt(emMaxScriptPW.text);
      If Neu < 5 then begin
         Neu := 5; emMaxScriptPW.text := IntToStr(Neu)
      end else If Neu > 99 then begin
         Neu := 99; emMaxScriptPW.text := IntToStr(Neu)
      end
   except
      exit
   end;
   With lstPasswords.Items do begin
      If AnzRAS+Neu < Count then begin
         For i := Count downto AnzRAS+Neu do Delete(i)
      end else If AnzRAS+Neu > Count then begin
         For i := Count-AnzRAS+1 to Neu do Add ( EntryWithUserAndPW ('$' + inttostr(i)) )
      end
   end
end;

{HSR} {GROUPS}

procedure TfrmConfigUserAndPW.trAccountContextPopup(Sender: TObject;
  MousePos: TPoint; var Handled: Boolean);
Var P: TPoint; N: TTreeNode;
begin
   With trAccount do begin
      P := MousePos;
      N := GetNodeAt(P.x, P.y);
      If Assigned(N) then Selected := N;
      If Selected=NIL then exit;
      //trAccount.Selected:=TreeAccount1.Selected;
      P := ClientToScreen(MousePos);
      Case Selected.Level of
         0: Tree1popup.Popup(P.x, P.y);
         1: Tree2popup.Popup(P.x, P.y);
      end;
   end
end;

procedure TfrmConfigUserAndPW.NewUser1Click(Sender: TObject);
begin
   With trAccount do begin
      If Selected = NIL then Exit;
      Case Selected.Level of
         0: NewUser(StripFirst(Selected.Text));
         1: NewUser(StripFirst(Selected.Parent.Text));
      end
   end
end;

procedure TfrmConfigUserAndPW.DeleteUser1Click(Sender: TObject);
//procedure TfrmConfigLocal.btnAccDelClick(Sender: TObject);
begin
   With trAccount do If Assigned(Selected) then With Selected do begin
      If Level=1 then DeleteUser(CfgAccounts.UserIDOf(StripFirst(Text)))
   end
end;

procedure TfrmConfigUserAndPW.EditUser1Click(Sender: TObject);
begin
   With trAccount do If Assigned(Selected) then With Selected do begin
      EditUser(CfgAccounts.UserIDOf(StripFirst(Text)))
   end
end;

procedure TfrmConfigUserAndPW.EditGroup1Click(Sender: TObject);
begin
   With TrAccount do If Assigned(Selected) then
      EditGroup(StripFirst(Selected.Text))
end;

procedure TfrmConfigUserAndPW.DeleteGroup1Click(Sender: TObject);
begin
   With TrAccount do If Assigned(Selected) then
      DeleteGroup(CfgAccounts.GroupIDOf(StripFirst(Selected.Text)));
end;

procedure TfrmConfigUserAndPW.BtnAddClick(Sender: TObject);
Var N: TTreeNode;
begin
   If Sender = btnGroupAdd then begin
      NewGroup
   end else If Sender = btnUserAdd then begin
      N := TrAccount.Selected;
      If Not Assigned(N) then Exit;
      If N.Level = 1 then N := N.Parent;
      NewUser (StripFirst(N.Text))
   end
end;

procedure TfrmConfigUserAndPW.BtnEditClick(Sender: TObject);
Var N: TTreeNode;
begin
  N := trAccount.Selected;
  if N=nil then exit;
  Case N.Level of
     0: EditGroup (StripFirst(N.Text));
     1: EditUser(CfgAccounts.UserIDOf(StripFirst(N.Text)))
  end
end;

procedure TfrmConfigUserAndPW.BtnDeleteClick(Sender: TObject);
var N: TTreeNode;
begin
  N := trAccount.Selected;
  if N=Nil then exit;
  With N do Case Level of
     0: DeleteGroup(CfgAccounts.GroupIDOf(StripFirst(Text)));
     1: DeleteUser(CfgAccounts.UserIDOf(StripFirst(Text)))
  end
end;

procedure TfrmConfigUserAndPW.NewGroup1Click(Sender: TObject);
begin
   NewGroup
end;


//----------- Funktionalitt ---------------------------------------------------


procedure TfrmConfigUserAndPW.DeleteGroup(GroupID : Integer);                  //HSR
  //To-Do  //berwachen!
var
  s,s1,s2     : String;
  i           : Integer;
  bDelUser    : boolean;
begin
  if GroupID=1 then begin
    Application.MessageBox(
        PChar(Tr('DeleteGroup.AdminUndeleteble', 'Administrator-Group can''t be deleted!')),
        PChar(Caption), MB_ICONWARNING + MB_OK );
     exit
  end;
  s := TrF('DeleteGroup.QuestionDeleteGroupNr', 'Delete Group %s ?',
     ['"'
     + CfgAccounts.Grpfile.ReadString(GRPM_SECTION2,IntToStr(GroupID),'Error please say no!') + '", "'
     + CfgAccounts.ValueOfGroup[GroupID,GRP_DESC]
     + '"']);
  If Application.MessageBox( PChar(s), PChar(Caption), MB_ICONQUESTION + MB_YESNO )
     <> IDYES then Exit;
  s := Tr('DeleteGroup.QuestionDeleteAccountsFromGroup', 'Delete all Accounts of the Group too? if "No", they will be moved to the admin-group');
  Case Application.MessageBox( PChar(s), PChar(Caption), MB_ICONQUESTION + MB_YESNOCANCEL ) of
     IDYES: bDelUser := true;
     IDNO: bDelUser := false;
     else Exit
  end;

  //Alle bisherigen Group-Eintrge von Usern umwandeln nach 'Admin' (oder lschen)
  s2:=Cfgaccounts.GrpFile.ReadString(GRPM_SECTION2,IntToStr(GroupID),'');
  if s2='' then exit;
  for i:=1 to CfgAccounts.ActFile.ReadInteger( 'Common','UserIDMax',1) do begin
    s1:=Cfgaccounts.value[i,ACTP_GROUP];
    if s1=s2 then begin
      if bDelUser
         then DeleteUser(i)
         else Cfgaccounts.value[i,ACTP_GROUP]:='Admin';
    end;
  end;

  CfgAccounts.GroupDelete(GroupID);
  ShowAccounts( '', ACTID_INVALID );
end;

Procedure TfrmConfigUserAndPW.EditGroup(GroupName: string);
var
  GroupID    : integer;
begin
   GroupID:=CfgAccounts.GroupIDOf(GroupName);
   if GroupID=ACTID_INVALID then exit;
   DialogEditGroup(GroupID);
   ShowAccounts( CfgAccounts.ValueOfGroup[GroupID, GRP_NAME],ACTID_INVALID )
end;

procedure TfrmConfigUserAndPW.NewGroup;                                        //HSR
Var GroupName, GroupDesc: String; GroupID, p: Integer;
begin
   GroupName := '';
   if not InputDlgStr( Tr('NewGroup.caption', 'Add new group'),
                       Tr('NewGroup.Groupname', 'Groupname:'),
                       GroupName, 0{HlpAddLocalAccount} ) then exit;
   p := Pos(',', Groupname);
   If p > 0 then begin
      GroupDesc := Trim(Copy(Groupname, p+1, Length(Groupname)-p));
      GroupName := Trim(Copy(Groupname, 1, p-1))
   end else begin
      GroupDesc := GroupName
   end;
   If GroupName = '' then Exit;
   if not CfgAccounts.IsUniqueGroupname( GroupName ) then begin
      Application.MessageBox( PChar(TrGl(kMessages, 'Groupname.must.unique', 'Groupname has to be unique!')),
                              PChar(Tr('NewGroup.caption', 'Add new group')),
                              MB_ICONEXCLAMATION );
      exit;
   end;
   GroupID:=CfgAccounts.GrpFile.ReadInteger( GRPM_SECTION,GRPM_GROUPMAX,1)+1;
   CfgAccounts.Grpfile.WriteString(GRPM_SECTION2,IntToStr(GroupID),GroupName);
   CfgAccounts.Grpfile.WriteInteger(GRPM_SECTION,GRPM_GROUPMAX,GroupID);
   CfgAccounts.ValueOfGroup[ GroupID, GRP_DESC ] := GroupDesc;
   CfgAccounts.ValueOfGroup[ GroupID, GRP_NEWSREAD ] := '.*';
   CfgAccounts.ValueOfGroup[ GroupID, GRP_NEWSPOST ] := '.*';
   EditGroup(GroupName);
   ShowAccounts( CfgAccounts.ValueOfGroup[GroupID, GRP_NAME],ACTID_INVALID )
end;

procedure TfrmConfigUserAndPW.EditUser(UserID : integer);                      //HSR
begin
   DialogEditUser( UserID, mAliases.Lines );
   ShowAccounts( '', UserID );
end;

procedure TfrmConfigUserAndPW.NewUser(Group : string);                         //HSR
var  DefaultsID, UserID, i, p: Integer;
     UserName, UserDesc, GroupName, Aliasentry: String;
     ok, DeactivateAlias: Boolean;
begin
     if Group='' then Groupname:='Admin' else groupname:=group;
     UserName := '';
     DeactivateAlias := false;
     Repeat
        if not InputDlgStr(
           TrF('NewAccount.caption2', 'Add new account (group "%s")', Group),
           Tr('NewAccount.Username', 'Username:'),
           UserName, 0{HlpAddLocalAccount} )
        then exit;
        if UserName='' then exit;
        {HSR}{Bad_Char}
        ok := true;

        p := Pos(',', Username);
        If p > 0 then begin
           UserDesc := Trim(Copy(Username, p+1, Length(Username)-p));
           UserName := Trim(Copy(Username, 1, p-1))
        end else begin
           UserDesc := UserName
        end;
        For i := 1 to Length(Username) do begin
           If Not (Username[i] IN AccountChars) then begin
              Application.MessageBox(
                 PChar(TrF('NewAccount.bad.char', 'New account contains one or more illegal chars, "%s" is not allowed in a username!', Username[i])),
                 PChar(Tr('NewAccount.bad.char.caption','Error: username is wrong')),
                 MB_OK );
              ok := false;
              break
           end
        end;
        if ok and (not CfgAccounts.IsUniqueUsername( UserName )) then begin
           Application.MessageBox( PChar(TrGl(kMessages, 'Username.must.unique', 'Username has to be unique!')),
                PChar(Tr('NewAccount.caption', 'Add new account')),
                MB_ICONEXCLAMATION );
           ok := false
        end;
        If ok and MailAlias.exists ( UserName, Aliasentry ) then begin
           Case Application.MessageBox(
              PChar(TrF('Username.equals.alias',
                    'There exist already an alias with this name, which would hide the new user, should the alias-entry "%s" be deactivated?',
                    Aliasentry)),
                PChar(Tr('NewAccount.caption', 'Add new account')),
                MB_ICONQUESTION + MB_YESNOCANCEL )
           of
              IDYES: DeactivateAlias := true;
              IDNO: DeactivateAlias := false;
              IDCANCEL: ok := false
           end
        end else begin
           DeactivateAlias := false
        end
     until ok;
{/HSR}
     With CfgAccounts do begin
        DefaultsID := GroupIDOf(Groupname);
        UserID := Add( ACTID_NEW );
        if UserID=ACTID_INVALID then exit;
        Value[ UserID, ACTP_USERNAME ] := UserName;
        if DefaultsID<>ACTID_INVALID then begin {HSR-Changes}
           Value[UserID,ACTP_FULLNAME] := UserDesc;
           Value[UserID,ACTP_NEWSPOST] := ValueOfGroup[DefaultsID,GRP_NEWSPOST];
           Value[UserID,ACTP_NEWSREAD] := ValueOfGroup[DefaultsID,GRP_NEWSREAD];
           Value[UserID,ACTP_NEWSPEER] := ValueOfGroup[DefaultsID,GRP_NEWSPEER];
           Value[UserID,ACTP_NEWNEWS]  := ValueOfGroup[DefaultsID,GRP_NEWNEWS];
           Value[UserID,ACTP_CANCEL] := ValueOfGroup[DefaultsID,GRP_NEWSCANCEL];
           Value[UserID,ACTP_MAILBOX ] := ValueOfGroup[DefaultsID,GRP_MAILBOX ];
           Value[UserID,ACTP_MAILADDR] := ValueOfGroup[DefaultsID,GRP_MAILADDR];
           Value[UserID,ACTP_MAILSEND] := ValueOfGroup[DefaultsID,GRP_MAILSEND];
           Value[UserID,ACTP_REMOTECONTROL] := ValueOfGroup[DefaultsID,GRP_REMOTE];
           Value[UserID,ACTP_GROUP   ] := Groupname;              //HSR
           HasMailbox( UserID ); // create/remove mailbox
        end
     end;
//     frmAccount.btnCancel.Visible:=false;
     EditUser(UserID);
//     frmAccount.btnCancel.Visible:=true;
     ShowAccounts( '', UserID );

     If DeactivateAlias and (AliasEntry > '') then begin
        MailAlias.Deactivate (Aliasentry);
        MailAlias.LoadFromFile (mAliases.Lines)
     end
end;

procedure TfrmConfigUserAndPW.DeleteUser(UserID : integer);                                    //HSR
var
  s           : String;
  TS          : TSearchRec;
  i           : Integer;

//procedure TfrmConfigLocal.btnAccDelClick(Sender: TObject);

begin
  if UserID=ACTID_ADMIN then begin
    Application.MessageBox(
        PChar(Tr('DeleteAccount.AdminUndeleteble', 'Administrator-account can''t be deleted!')),
        PChar(Caption), MB_ICONWARNING + MB_OK );
//    MessageDlg( PChar(Tr('DeleteAccount.AdminUndeleteble',
//                'Administrator-account can''t be deleted!')),
//                 mtError, [mbAbort], 0 );
     exit;
  end;

  i := SysUtils.FindFirst( CfgAccounts.MailBoxPath( UserID ) + '*.'
     + CfgIni.ReadString( 'Setup', 'mail.ext.out', 'msg' ),
                           faAnyFile-faDirectory, TS );
  SysUtils.FindClose( TS );
  if i=0 then begin
{     MessageDlg( PChar(Tr('DeleteAccount.StillHasMails',
                 'Account still has mails and can''t be deleted!')),
                 mtError, [mbAbort], 0 );
}
     Application.MessageBox(
         PChar(Tr('DeleteAccount.StillHasMails', 'Account still has mail and can''t be deleted!')),
         PChar(Caption), MB_ICONWARNING + MB_OK );
     exit;
  end;
  s := TrF('DeleteAccount.QuestionDeleteAccountNr', 'Delete account #%s ?',
     [inttostr(UserID) + ' ("'
     + CfgAccounts.Value[UserID,ACTP_USERNAME] + '", "'
     + CfgAccounts.Value[UserID,ACTP_FULLNAME]
     + '")']);
  If Application.MessageBox( PChar(s), PChar(Caption), MB_ICONQUESTION + MB_YESNO )
     <> IDYES
  then Exit;
  CfgAccounts.Value[ UserID, ACTP_MAILBOX ] := '0';
  CfgAccounts.HasMailbox( UserID ); // remove mailbox
  CfgAccounts.Delete( UserID );
  ShowAccounts( '', ACTID_INVALID )
end;
{/HSR}

procedure TfrmConfigUserAndPW.trAccountChange(Sender: TObject;
  Node: TTreeNode);
begin
   SetStateForAccountButtons
end;

procedure TfrmConfigUserAndPW.trAccountMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   SetStateForAccountButtons
end;

procedure TfrmConfigUserAndPW.trAccountDblClick(Sender: TObject);
begin
   btnAccEdit.Click
end;


procedure TfrmConfigUserAndPW.TestDragDrop(Source: TObject; X, Y: Integer;
   Var Von, Nach: TTreeNode);
begin
   Von := NIL;
   Nach := NIL;
   If Source = trAccount then begin
      If Assigned(trAccount.Selected) then begin
         With trAccount.Selected do begin
            If (Level = 1) and (StripFirst(Text)<>'admin')
               then Von := trAccount.Selected
         end
      end
   end;
   If Assigned(Von) then begin
      Nach := trAccount.GetNodeAt(x,y);
      If Assigned(Nach) then begin
         If (Nach.Level <> 0) then Nach := NIL
         else If Von.Parent = Nach then Nach := NIL
      end
   end
end;

procedure TfrmConfigUserAndPW.trAccountDragDrop(Sender, Source: TObject; X,
  Y: Integer);
Var Von, Nach: TTreeNode; User, Group: String;
begin
   TestDragDrop(Source, X, Y, Von, Nach);
   If Assigned(Von) and Assigned(Nach) then begin
      User := StripFirst(Von.Text);
      Group := StripFirst(Nach.Text);
      CfgAccounts.Value[ CfgAccounts.UserIDOf(user), ACTP_GROUP ] := Group;
      ShowAccounts( '',ACTID_INVALID )
   end
end;

procedure TfrmConfigUserAndPW.trAccountDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
Var Von, Nach: TTreeNode;
begin
   TestDragDrop(Source, X, Y, Von, Nach);
   Accept := Assigned(Von) and Assigned(Nach)
end;

procedure TfrmConfigUserAndPW.chkAdvancedSettingsClick(Sender: TObject);
Var b: Boolean;
begin
   b := chkAdvancedSettings.Checked;

   tsAliases.TabVisible := b;
   labMaxScriptPW.Visible := b; emMaxScriptPW.Visible := b;

   If Archivmode then begin
      TabPasswords.TabVisible := false;
   end

end;

end.
