// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit HConfigNewsServer;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, IniFiles, cStdForm, Mask, ToolEdit;

Procedure DialogEditNNTPServer (Const Nam, Port: String);

type
  TfrmConfigNewsServer = class(THForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    butHelp: TButton;
    Panel1: TPanel;
    Label2: TLabel;
    labUsernamePW: TLabel;
    labPWStatus: TLabel;
    labOverrideConnectTimeout: TLabel;
    labOverrideCommandTimeOut: TLabel;
    labOverrideTimeOutDefaults: TLabel;
    labPort: TLabel;
    chkReadOnly: TCheckBox;
    chkReloadGroups: TCheckBox;
    chkReloadDescs: TCheckBox;
    butPWSet: TButton;
    butPWClear: TButton;
    emTimeoutConnect: TEdit;
    emTimeoutCommand: TEdit;
    butEditIni: TButton;
    cbServerPort: TComboBox;
    gbSSL: TGroupBox;
    labVerifyFile: TLabel;
    labSSLUsage: TLabel;
    labSSLVerify: TLabel;
    cbSSLMode: TComboBox;
    cbVerifyMode: TComboBox;
    txtVerifyFile: TFilenameEdit;
    chkAdvancedSettings: TCheckBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    DirectoryEdit1: TDirectoryEdit;
    Button1: TButton;
    procedure FormActivate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure butPWSetClick(Sender: TObject);
    procedure butPWClearClick(Sender: TObject);
    procedure butEditIniClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cbSSLModeChange(Sender: TObject);
    procedure cbVerifyModeChange(Sender: TObject);
    procedure chkAdvancedSettingsClick(Sender: TObject);
  private
    { Private declarations }
    ServerName, User, PW: String; UChg: boolean;
    procedure LoadSettings;
    procedure SaveSettings;
    procedure SetPWInfo;
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}

uses Global, cPasswordFile, dInput, Config, uTools, uSSL;

Procedure DialogEditNNTPServer (Const Nam, Port: String);
begin
   With TfrmConfigNewsServer.Create(NIL) do try
      Caption := Caption + ' ' + Nam;
      ServerName := Nam;
      cbServerPort.Text := Port;
      {MG}{SSL}
      cbSSLMode.ItemIndex    := 0;
      cbVerifyMode.ItemIndex := 0;
      cbSSLModeChange( nil );
      {/SSL}
      ShowModal
   finally Free end
end;

procedure TfrmConfigNewsServer.LoadSettings;
var  Filename: String;
begin
   chkAdvancedSettings.Checked := Def_AdvancedConfiguration;

   Filename := PATH_SERVER + ServerName + '\' + SRVFILE_INI;
   if not FileExists2( Filename ) then exit;

   // emmIni.Lines.LoadFromFile( Filename );

   With TIniFile.Create( Filename ) do try
      chkReadOnly    .Checked := ReadBool( 'Setup', 'ReadOnly',     False );
      chkReloadGroups.Checked := ReadBool( 'Pull',  'ReloadGroups', False );
      chkReloadDescs .Checked := ReadBool( 'Pull',  'ReloadDescs',  False );
      emTimeoutConnect.text := ReadString( 'Setup', 'Remote.Timeout.Connect', ReadString( 'Setup', 'RemoteTimeoutConnect', ''));
      emTimeoutCommand.text := ReadString( 'Setup', 'Remote.Timeout.Command', ReadString( 'Setup', 'RemoteTimeoutCommand', ''));
      {MG}{SSL}
      cbSSLMode.ItemIndex    := ReadInteger( 'NNTP', 'SSLMode', 0 );
      cbVerifyMode.ItemIndex := ReadInteger( 'NNTP', 'SSLVerifyLevel', 0 );
      txtVerifyFile.Text     := ReadString( 'NNTP', 'SSLCaFile', '' );
      {/SSL}
   finally free end;
   {MG}{SSL}
   DoEnable ( gbSSL, SSLReady );
   cbSSLModeChange( nil );
   {/SSL}
   PasswordFile.LoadPassword (Servername, User, PW);
   SetPWInfo;

   UChg := false
end;

procedure TfrmConfigNewsServer.SaveSettings;
var  Filename: String; SrvLst:TStringList; i:integer;
begin
   if FileExists2( PATH_BASE + CFGFILE_SERVER_NNTP ) then begin
      SrvLst:=TStringList.Create;;
      With SrvLst do begin
         LoadFromFile( PATH_BASE + CFGFILE_SERVER_NNTP );
         For i:=0 To SrvLst.count-1  do
           if pos(Servername+',',SrvLst.strings[i]) = 1 then
              SrvLst.Strings[i]:= Servername+','+cbServerPort.Text;

         SaveToFile( PATH_BASE + CFGFILE_SERVER_NNTP );
      end;
      SrvLst.Free;
   end;

   Filename := PATH_SERVER + Servername + '\' + SRVFILE_INI;
   With TIniFile.Create( Filename ) do try
      WriteBool( 'Setup', 'ReadOnly',     chkReadOnly    .Checked );
      WriteBool( 'Pull',  'ReloadGroups', chkReloadGroups.Checked );
      WriteBool( 'Pull',  'ReloadDescs',  chkReloadDescs .Checked );
      DeleteKey  ( 'Setup', 'RemoteTimeoutConnect' );
      WriteString( 'Setup', 'Remote.Timeout.Connect', emTimeoutConnect.text);
      DeleteKey  ( 'Setup', 'RemoteTimeoutCommand' );
      WriteString( 'Setup', 'Remote.Timeout.Command', emTimeoutCommand.text);
      {MG}{SSL}
      WriteInteger('NNTP', 'SSLMode', cbSSLMode.ItemIndex);
      WriteInteger('NNTP', 'SSLVerifyLevel', cbVerifyMode.ItemIndex);
      WriteString('NNTP', 'SSLCaFile', txtVerifyFile.Text);
      {/SSL}
   finally
      Free
   end;

   If UChg then PasswordFile.SavePassword (true, ServerName, User, PW);
end;


procedure TfrmConfigNewsServer.FormActivate(Sender: TObject);
begin
   LoadSettings;
end;

procedure TfrmConfigNewsServer.OKBtnClick(Sender: TObject);
begin
   SaveSettings;
   ModalResult := mrOK;
end;

procedure TfrmConfigNewsServer.SetPWInfo;
Var u, p: String;
begin
   PasswordFile.PasswordInfo (ServerName, User, PW, u, p);
   labPWStatus.caption := u + ' / ' + p
end;

procedure TfrmConfigNewsServer.butPWSetClick(Sender: TObject);
Var ID, U, P1, P2: String;
begin
   ID := ServerName;
   if not InputDlgStr( PChar(ID), TrGl(kGlobal, 'DlgPWEdit.Username', 'Username (?=ask when needed):'), U,
      0{HlpInputUserPasswordForServer}  ) then exit;
   if not InputDlgPwd( PChar(ID), TrGl(kGlobal, 'DlgPWEdit.Password', 'Password (?=ask when needed):'), P1,
      0{HlpInputUserPasswordForServer} ) then exit;
   if (P1<>'') and (P1<>'?') then begin
      if not InputDlgPwd( PChar(ID), TrGl(kGlobal, 'DlgPWEdit.RepeatPW', 'Repeat password:'), P2,
         0{HlpInputUserPasswordForServer} ) then exit;
      if P1<>P2 then begin
         Application.MessageBox( PChar(TrGl(kGlobal, 'DlgPWEdit.DifferentPWs',
                                 'Given passwords were not equal!^MPassword remains unchanged!')),
                                 PChar(TrGl(kGlobal, 'DlgPWEdit.Caption', 'Change password')),
                                 MB_ICONEXCLAMATION );
         exit
      end
   end;
   User := U; PW := P1; UChg := true; SetPWInfo
end;

procedure TfrmConfigNewsServer.butPWClearClick(Sender: TObject);
begin
   If (User > '') or (PW>'') then begin
      User := ''; PW := ''; UChg := true;
      SetPWInfo
   end
end;

procedure TfrmConfigNewsServer.butEditIniClick(Sender: TObject);
begin
   EditFile (PATH_SERVER + ServerName + '\' + SRVFILE_INI)
end;

procedure TfrmConfigNewsServer.FormCreate(Sender: TObject);
begin
   FillSSLModeList ( cbSSLMode.Items );
   FillSSLVerifyModeList ( cbVerifyMode.Items );
   labPWStatus.Font.Style := [fsBold]
end;

procedure TfrmConfigNewsServer.cbSSLModeChange(Sender: TObject);
begin
   cbVerifyMode.Enabled := cbSSLMode.ItemIndex > 0;
   cbVerifyModeChange( Sender )
end;

procedure TfrmConfigNewsServer.cbVerifyModeChange(Sender: TObject);
begin
   txtVerifyFile.Enabled := (cbVerifyMode.ItemIndex > 0) and (cbSSLMode.ItemIndex > 0)
end;

procedure TfrmConfigNewsServer.chkAdvancedSettingsClick(Sender: TObject);
Var b: Boolean;
begin
   b := chkAdvancedSettings.Checked;
   butEditIni.Visible := b;
   gbSSL.Visible := b;
   labOverrideTimeOutDefaults.Visible := b;
   labOverrideConnectTimeout.Visible := b;
   emTimeoutConnect.Visible := b;
   labOverrideCommandTimeOut.Visible := b;
   emTimeoutCommand.Visible := b;
end;

end.
