// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit HConfigPOP3Server;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, IniFiles, cStdForm, Mask, ToolEdit;

Procedure DialogEditPop3Server (Const Nam, Port: String);

type
  TfrmConfigPop3Server = class(THForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    butHelp: TButton;
    Panel1: TPanel;
    labUsernamePW: TLabel;
    labPWStatus: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    labFiltersection2: TLabel;
    labOverrideTimeOutDefaults: TLabel;
    labOverrideConnectTimeout: TLabel;
    labOverrideCommandTimeOut: TLabel;
    labServerPort: TLabel;
    butPWSet: TButton;
    butPWClear: TButton;
    txtFiltersection: TEdit;
    butEditSection2: TButton;
    cbUser: TComboBox;
    emTimeoutConnect: TEdit;
    emTimeoutCommand: TEdit;
    cbServerPort: TComboBox;
    butEditIni: TButton;
    gbSSL: TGroupBox;
    labVerifyFile: TLabel;
    labSSLUsage: TLabel;
    labSSLVerify: TLabel;
    cbSSLMode: TComboBox;
    cbVerifyMode: TComboBox;
    txtVerifyFile: TFilenameEdit;
    chkAdvancedSettings: TCheckBox;
    labSASL: TLabel;
    txtSASL: TPanel;
    butSASL: TButton;
    cbLeaveOnServer: TComboBox;
    procedure butPWSetClick(Sender: TObject);
    procedure butPWClearClick(Sender: TObject);
    procedure butEditSection2Click(Sender: TObject);
    procedure butEditIniClick(Sender: TObject);
    procedure cbSSLModeChange(Sender: TObject);
    procedure cbVerifyModeChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure chkAdvancedSettingsClick(Sender: TObject);
    procedure butSASLClick(Sender: TObject);
  private
    { Private declarations }
    User, PW, ServerName: String;
    UChg: boolean;
    procedure SetPWInfo;
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}

uses Global, uTools, cPasswordFile, Config, cAccount, uSSL, hConfigSASL,
     dInput, dEditMailFilterSection;

Procedure DialogEditPop3Server (Const Nam, Port: String);
var  Filename: String; UserIDs: TStringlist; i: Integer;
     UserID: LongInt; UserName, FullName, s: String;
begin
   With TfrmConfigPop3Server.Create(NIL) do try

      chkAdvancedSettings.Checked := Def_AdvancedConfiguration;

      Caption := Caption + ' ' + Nam;
      ServerName := Nam;
      cbServerPort.Text := Port;
      Filename := PATH_SERVER + POP3ServerNameToPath(ServerName) + '\' + SRVFILE_INI;
      UserIDs := TStringlist.Create;
      cbUser.Clear;
      try
         CfgAccounts.SnapshotOfIDs( UserIDs );
         for i:=0 to UserIDs.Count-1 do begin
            UserID := LongInt( UserIDs.Objects[i] );
            UserName := CfgAccounts.Value[ UserID, ACTP_USERNAME ];
            FullName := CfgAccounts.Value[ UserID, ACTP_FULLNAME ];
            cbUser.Items.AddObject (UserName + ' = '+Fullname, Pointer(Length(Username)))
         end
      finally UserIDs.free end;
      With TIniFile.Create( Filename ) do try
         UserName := LowerCase( ReadString ( 'POP3', 'Localuser', Def_Postmaster ) );
         With cbUser do begin
            For i:=0 to Items.Count-1 do
               If LowerCase(Copy(Items[i], 1, LongInt(Items.Objects[i]))) = Username
                  then begin ItemIndex := i; break end;
            If ( ItemIndex < 0 ) and ( Items.Count > 0 ) then ItemIndex := 0
         end;
         txtFiltersection.text := ReadString('POP3', 'FilterSection', '*');
         If txtFiltersection.text = '' then txtFiltersection.text := '*';
         s := ReadString('POP3', 'LeaveOnServer', '?');
         With cbLeaveOnServer do begin
            If s = '1' then ItemIndex := 1
            else If s = '0' then ItemIndex := 2
            else ItemIndex := 0
         end;
         emTimeoutConnect.text := ReadString( 'Setup', 'Remote.Timeout.Connect', ReadString( 'Setup', 'RemoteTimeoutConnect', ''));
         emTimeoutCommand.text := ReadString( 'Setup', 'Remote.Timeout.Command', ReadString( 'Setup', 'RemoteTimeoutCommand', ''));

         txtSASL.Caption := ReadString ( 'POP3', 'SASL', POP3LocalSASL );

         {MG}{SSL}
         cbSSLMode.ItemIndex    := ReadInteger( 'POP3', 'SSLMode', 0 );
         cbVerifyMode.ItemIndex := ReadInteger( 'POP3', 'SSLVerifyLevel', 0 );
         txtVerifyFile.Text     := ReadString( 'POP3', 'SSLCaFile', '' );
         {/SSL}
      finally free end;
      DoEnable ( gbSSL, SSLReady );
      cbSSLModeChange( nil );
      PasswordFile.LoadPassword (ServerName, User, PW);
      SetPWInfo;
      UChg := false;

      //////////////////////////////
      If ShowModal = mrOK then begin
      //////////////////////////////
         if FileExists2( PATH_BASE + CFGFILE_SERVER_POP3 ) then begin
            With TStringList.Create do try
               LoadFromFile( PATH_BASE + CFGFILE_SERVER_POP3 );
               For i:=0 To Count-1  do begin
                  if Pos(ServerName+',', Strings[i]) = 1 then begin
                     Strings[i]:= ServerName+','+cbServerPort.Text
                  end
               end;
               SaveToFile( PATH_BASE + CFGFILE_SERVER_POP3 );
            finally Free end
         end;
         With TIniFile.Create( Filename ) do try
            With cbUser do begin
               If ItemIndex >= 0
                  then Username := Copy(Items[ItemIndex], 1, LongInt(Items.Objects[ItemIndex]))
                  else Username := Def_Postmaster;
            end;
            WriteString('POP3', 'LocalUser', Username);
            If txtFiltersection.text = '' then txtFiltersection.text := '*';
            WriteString('POP3', 'FilterSection', txtFiltersection.text);
            Case cbLeaveOnServer.ItemIndex of
               1: s := '1';
               2: s := '0';
               else s := '?';
            end;
            WriteString('POP3', 'LeaveOnServer', s);
            DeleteKey  ( 'Setup', 'RemoteTimeoutConnect' );
            WriteString( 'Setup', 'Remote.Timeout.Connect', emTimeoutConnect.text);
            DeleteKey  ( 'Setup', 'RemoteTimeoutCommand' );
            WriteString( 'Setup', 'Remote.Timeout.Command', emTimeoutCommand.text);

            With txtSASL do If Caption = POP3LocalSASL
               then DeleteKey ( 'POP3', 'SASL' )
               else WriteString ( 'POP3', 'SASL', Caption );

            {MG}{SSL}
            WriteInteger('POP3', 'SSLMode', cbSSLMode.ItemIndex);
            WriteInteger('POP3', 'SSLVerifyLevel', cbVerifyMode.ItemIndex);
            WriteString( 'POP3', 'SSLCaFile', txtVerifyFile.Text);
            {/SSL}
         finally
            Free
         end;
         If UChg then PasswordFile.SavePassword (true, ServerName, User, PW)
      end
   finally
      free
   end
end;

procedure TfrmConfigPop3Server.SetPWInfo;
Var u, p: String;
begin
   PasswordFile.PasswordInfo (ServerName, User, PW, u, p);
   labPWStatus.caption := u + ' / ' + p
end;

procedure TfrmConfigPop3Server.butPWSetClick(Sender: TObject);
Var ID, U, P1, P2: String;
begin
   ID := ServerName;
   if not InputDlgStr( PChar(ID), TrGl(kGlobal, 'DlgPWEdit.Username', 'Username (?=ask when needed):'), U,
      0{HlpInputUserPasswordForServer}  ) then exit;
   if not InputDlgPwd( PChar(ID), TrGl(kGlobal, 'DlgPWEdit.Password', 'Password (?=ask when needed):'), P1,
      0{HlpInputUserPasswordForServer} ) then exit;
   if (P1<>'') and (P1<>'?') then begin
      if not InputDlgPwd( PChar(ID), TrGl(kGlobal, 'DlgPWEdit.RepeatPW', 'Repeat password:'), P2,
         0{HlpInputUserPasswordForServer} ) then exit;
      if P1<>P2 then begin
         Application.MessageBox( PChar(TrGl(kGlobal,'DlgPWEdit.DifferentPWs',
                                 'Given passwords were not equal!^MPassword remains unchanged!')),
                                 PChar(TrGl(kGlobal,'DlgPWEdit.Caption', 'Change password')),
                                 MB_ICONEXCLAMATION );
         exit
      end
   end;
   User := U; PW := P1; UChg := true; SetPWInfo
end;

procedure TfrmConfigPop3Server.butPWClearClick(Sender: TObject);
begin
   If (User > '') or (PW>'') then begin
      User := ''; PW := ''; UChg := true;
      SetPWInfo
   end
end;

procedure TfrmConfigPop3Server.butEditSection2Click(Sender: TObject);
Var sl: TStringlist; s, fn, v: String; b: boolean; von, bis, i: Integer;
begin
   fn := PATH_BASE + CFGFILE_MFILTER;
   v  := '['+LowerCase(txtFilterSection.text)+']';
   b  := false;
   With TDlgEditMailFilterSection.Create(nil) do try
      Caption := Format(caption, ['['+txtFilterSection.text+']']);
      sl := TStringlist.Create;
      try
         If FileExists2(fn) then sl.LoadFromFile(fn);
         von := -1; bis := -1;
         For i:=0 to sl.Count-1 do begin
            s := Trim(sl[i]);
            If b then begin
               If Copy(s, 1, 1)='[' then If s[Length(s)] = ']' then begin
                  bis := i-1; break
               end
            end else begin
               If Lowercase(s)=v then begin b := true; von := i+1 end
            end
         end;
         If (von > 0) and (bis < 0) then bis := sl.Count-1;
         While (bis > von) and (Trim(sl[bis])='') do Dec(bis);

         Memo.Lines.Clear;
         If von > 0 then For i:=von to bis do Memo.lines.Add (sl[i]);

         If ShowModal = mrOk then begin
            If (von > 0) and (bis >= von) then begin
               For i:=von to bis do sl.Delete(von);
               For i:=0 to Memo.lines.Count-1 do sl.Insert (von+i, Memo.lines[i])
            end else If (von > 0) then begin
               For i:=von to sl.Count-1 do sl.Delete(von);
               For i:=0 to Memo.lines.Count-1 do sl.Add (Memo.lines[i])
            end else begin
               If (sl.Count > 0) and (sl[sl.Count-1]<>'') then sl.Add('');
               sl.Add('['+txtFilterSection.text+']');
               For i:=0 to Memo.lines.Count-1 do sl.Add (Memo.lines[i])
            end;
            sl.SaveToFile (fn)
         end

      finally sl.free end;
   finally free end
end;

procedure TfrmConfigPop3Server.butEditIniClick(Sender: TObject);
begin
   EditFile (PATH_SERVER + POP3ServerNameToPath(ServerName) + '\' + SRVFILE_INI)
end;

procedure TfrmConfigPop3Server.cbSSLModeChange(Sender: TObject);
begin
   cbVerifyMode.Enabled := cbSSLMode.ItemIndex > 0;
   cbVerifyModeChange( Sender )
end;

procedure TfrmConfigPop3Server.cbVerifyModeChange(Sender: TObject);
begin
   txtVerifyFile.Enabled := (cbVerifyMode.ItemIndex > 0) and (cbSSLMode.ItemIndex > 0)
end;

procedure TfrmConfigPop3Server.FormCreate(Sender: TObject);
begin
   FillSSLModeList ( cbSSLMode.Items );
   FillSSLVerifyModeList ( cbVerifyMode.Items );
   labPWStatus.Font.Style := [fsBold]
end;

procedure TfrmConfigPop3Server.chkAdvancedSettingsClick(Sender: TObject);
Var b: Boolean;
begin
   b := chkAdvancedSettings.Checked;
   butEditIni.Visible := b;
   labFiltersection2.Visible := b;
   txtFiltersection.Visible := b;
   butEditSection2.Visible := b;
   labOverrideTimeOutDefaults.Visible := b;
   labOverrideConnectTimeout.Visible := b;
   emTimeoutConnect.Visible := b;
   labOverrideCommandTimeOut.Visible := b;
   emTimeoutCommand.Visible := b;
   labSASL.Visible := b;
   txtSASL.Visible := b;
   butSASL.Visible := b;
   gbSSL.Visible := b;
end;

procedure TfrmConfigPop3Server.butSASLClick(Sender: TObject);
begin
   With txtSASL do Caption := ChooseSASL ( POP3LocalSASL, Caption )
end;

end.

