            //SASL_WANTED := ReadString( 'SMTP', 'SASL', SMTPLocalSASL )
// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit HConfigSMTPServer;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, IniFiles, cStdForm, Mask, ToolEdit;

Procedure DialogEditSMTPServer (Const Nam, Port: String);

type
  TfrmConfigSMTPServer = class(THForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    butHelp: TButton;
    Panel1: TPanel;
    labUsernamePW: TLabel;
    labPWStatus: TLabel;
    labOverrideTimeOutDefaults: TLabel;
    labOverrideConnectTimeout: TLabel;
    labOverrideCommandTimeOut: TLabel;
    labPort: TLabel;
    butPWSet: TButton;
    butPWClear: TButton;
    chkAUTH: TCheckBox;
    emTimeoutConnect: TEdit;
    emTimeoutCommand: TEdit;
    cbServerPort: TComboBox;
    butEditIni: TButton;
    gbSSL: TGroupBox;
    labVerifyFile: TLabel;
    labSSLUsage: TLabel;
    labSSLVerify: TLabel;
    cbSSLMode: TComboBox;
    cbVerifyMode: TComboBox;
    txtVerifyFile: TFilenameEdit;
    chkAdvancedSettings: TCheckBox;
    labSASL: TLabel;
    txtSASL: TPanel;
    butSASL: TButton;
    procedure butPWSetClick(Sender: TObject);
    procedure butPWClearClick(Sender: TObject);
    procedure butEditIniClick(Sender: TObject);
    procedure chkAUTHClick(Sender: TObject);
    procedure cbSSLModeChange(Sender: TObject);
    procedure cbVerifyModeChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure chkAdvancedSettingsClick(Sender: TObject);
    procedure butSASLClick(Sender: TObject);
  private
    { Private declarations }
    Servername, User, PW: String; UChg: boolean;
    procedure SetPWInfo;
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}

uses Global, cPasswordFile, Config, cAccount, utools, uSSL, hConfigSASL,
     dInput, dEditMailFilterSection;

Procedure DialogEditSMTPServer (Const Nam, Port: String);
Var Filename, s: String; i:Integer;
begin
   With TfrmConfigSMTPServer.Create(NIL) do try
      chkAdvancedSettings.Checked := Def_AdvancedConfiguration;
      Servername := Nam;
      cbServerPort.Text := Port;
      Filename := PATH_SERVER + POP3ServerNameToPath(ServerName) + '\' + SRVFILE_INI;
      With TIniFile.Create( Filename ) do try
         chkAuth.checked := ReadString('SMTP', 'AUTH', '0') = '1';
         emTimeoutConnect.text := ReadString( 'Setup', 'Remote.Timeout.Connect', ReadString( 'Setup', 'RemoteTimeoutConnect', ''));
         emTimeoutCommand.text := ReadString( 'Setup', 'Remote.Timeout.Command', ReadString( 'Setup', 'RemoteTimeoutCommand', ''));

         txtSASL.Caption := ReadString ( 'SMTP', 'SASL', SMTPLocalSASL );
         {MG}{SSL}
         cbSSLMode.ItemIndex    := ReadInteger( 'SMTP', 'SSLMode', 0 );
         cbVerifyMode.ItemIndex := ReadInteger( 'SMTP', 'SSLVerifyLevel', 0 );
         txtVerifyFile.Text     := ReadString( 'SMTP', 'SSLCaFile', '' );
         {/SSL}
      finally free end;
      DoEnable ( gbSSL, SSLReady );
      cbSSLModeChange( nil );
      PasswordFile.LoadPassword (ServerName, User, PW);
      SetPWInfo;
      UChg := false;
      chkAUTH.OnClick(NIL);

      /////////////////////////////////////////////
      If ShowModal = mrOK then begin
      /////////////////////////////////////////////

         If FileExists2( PATH_BASE + CFGFILE_SERVER_SMTP ) then begin
            With TStringList.Create do try
               LoadFromFile( PATH_BASE + CFGFILE_SERVER_SMTP );
               For i:=0 To Count-1  do begin
                 if Pos(ServerName+',',strings[i]) = 1 then begin
                    Strings[i]:= ServerName+','+cbServerPort.Text
                 end
               end;
               SaveToFile( PATH_BASE + CFGFILE_SERVER_SMTP )
            finally Free end
         end;
         With TIniFile.Create( Filename ) do try
            If chkAuth.checked then s := '1' else s := '0';
            WriteString('SMTP', 'AUTH', s);
            DeleteKey  ( 'Setup', 'RemoteTimeoutConnect' );
            WriteString( 'Setup', 'Remote.Timeout.Connect', emTimeoutConnect.text);
            DeleteKey  ( 'Setup', 'RemoteTimeoutCommand' );
            WriteString( 'Setup', 'Remote.Timeout.Command', emTimeoutCommand.text);

            With txtSASL do If Caption = SMTPLocalSASL
               then DeleteKey ( 'SMTP', 'SASL' )
               else WriteString ( 'SMTP', 'SASL', Caption );
            {MG}{SSL}
            WriteInteger('SMTP', 'SSLMode', cbSSLMode.ItemIndex);
            WriteInteger('SMTP', 'SSLVerifyLevel', cbVerifyMode.ItemIndex);
            WriteString( 'SMTP', 'SSLCaFile', txtVerifyFile.Text);
            {/SSL}
         finally Free end;
         If UChg then PasswordFile.SavePassword (true, ServerName, User, PW)
      end
   finally
      free
   end
end;

procedure TfrmConfigSMTPServer.SetPWInfo;
Var u, p: String;
begin
   PasswordFile.PasswordInfo (ServerName, User, PW, u, p);
   labPWStatus.caption := u + ' / ' + p
end;

procedure TfrmConfigSMTPServer.butPWSetClick(Sender: TObject);
Var ID, U, P1, P2: String;
begin
   ID := ServerName;
   if not InputDlgStr( PChar(ID), TrGl(kGlobal, 'DlgPWEdit.Username', 'Username (?=ask when needed):'), U,
      0{HlpInputUserPasswordForServer}  ) then exit;
   if not InputDlgPwd( PChar(ID), TrGl(kGlobal, 'DlgPWEdit.Password', 'Password (?=ask when needed):'), P1,
      0{HlpInputUserPasswordForServer} ) then exit;
   if (P1<>'') and (P1<>'?') then begin
      if not InputDlgPwd( PChar(ID), TrGl(kGlobal, 'DlgPWEdit.RepeatPW', 'Repeat password:'), P2,
         0{HlpInputUserPasswordForServer} ) then exit;
      if P1<>P2 then begin
         Application.MessageBox( PChar(TrGl(kGlobal,'DlgPWEdit.DifferentPWs',
                                 'Given passwords were not equal!^MPassword remains unchanged!')),
                                 PChar(TrGl(kGlobal,'DlgPWEdit.Caption', 'Change password')),
                                 MB_ICONEXCLAMATION );
         exit
      end
   end;
   User := U; PW := P1; UChg := true;
   SetPWInfo;
   chkAuth.OnClick(NIL)
end;

procedure TfrmConfigSMTPServer.butPWClearClick(Sender: TObject);
begin
   If (User > '') or (PW>'') then begin
      User := ''; PW := ''; UChg := true;
      SetPWInfo;
      chkAuth.OnClick(NIL)
   end
end;

procedure TfrmConfigSMTPServer.butEditIniClick(Sender: TObject);
begin
   EditFile (PATH_SERVER + ServerName + '\' + SRVFILE_INI)
end;

procedure TfrmConfigSMTPServer.chkAUTHClick(Sender: TObject);
Var b: Boolean;
begin
   b := User+PW > '';
   butPWClear.Enabled := b;
   b := chkAUTH.Checked;
   labUsernamePW.Enabled := b;
   labPWStatus.Enabled := b;
   butPWSet.Enabled := b
end;

procedure TfrmConfigSMTPServer.cbSSLModeChange(Sender: TObject);
begin
   cbVerifyMode.Enabled := cbSSLMode.ItemIndex > 0;
   cbVerifyModeChange( Sender )
end;

procedure TfrmConfigSMTPServer.cbVerifyModeChange(Sender: TObject);
begin
   txtVerifyFile.Enabled := (cbVerifyMode.ItemIndex > 0) and (cbSSLMode.ItemIndex > 0)
end;

procedure TfrmConfigSMTPServer.FormCreate(Sender: TObject);
begin
   FillSSLModeList ( cbSSLMode.Items );
   FillSSLVerifyModeList ( cbVerifyMode.Items );
   labPWStatus.Font.Style := [fsBold]
end;

procedure TfrmConfigSMTPServer.chkAdvancedSettingsClick(Sender: TObject);
Var b: Boolean;
begin
   b := chkAdvancedSettings.Checked;
   butEditIni.Visible := b;
   labOverrideTimeOutDefaults.Visible := b;
   labOverrideConnectTimeout.Visible := b;
   emTimeoutConnect.Visible := b;
   labOverrideCommandTimeOut.Visible := b;
   emTimeoutCommand.Visible := b;
   labSASL.Visible := b;
   txtSASL.Visible := b;
   butSASL.Visible := b;
   gbSSL.Visible := b;
end;

procedure TfrmConfigSMTPServer.butSASLClick(Sender: TObject);
begin
   With txtSASL do Caption := ChooseSASL ( SMTPLocalSASL, Caption )
end;

end.
