unit HConfigSSLAdvanced;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, cStdForm;

Procedure Dialog_AdvancedSSLSettings;

type
  TfrmConfigSSLAdvanced = class(THForm)
    gbEncAlgo: TGroupBox;
    chkDES: TCheckBox;
    chkRC4: TCheckBox;
    chkIDEA: TCheckBox;
    chk3DES: TCheckBox;
    chkRC2: TCheckBox;
    gbMessageDigests: TGroupBox;
    chkSHA1: TCheckBox;
    chkMD5: TCheckBox;
    butHelp: TButton;
    butOK: TButton;
    butCancel: TButton;
    gbCompatibility: TGroupBox;
    chkSSLv2: TCheckBox;
    chkExport: TCheckBox;
    chkADH: TCheckBox;
    labWarn: TLabel;
    chkAES: TCheckBox;
    procedure butOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure chkIDEAClick(Sender: TObject);
  private
    SettingsLoaded : Boolean;
    procedure LoadSettings;
    procedure SaveSettings;
  public
    { Public-Deklarationen }
  end;

implementation

uses Config, uSSL;

{$R *.dfm}

Procedure Dialog_AdvancedSSLSettings;
begin
   With TfrmConfigSSLAdvanced.Create(NIL) do try
      ShowModal
   finally
      free
   end
end;

Procedure TfrmConfigSSLAdvanced.butOKClick(Sender: TObject);
begin
     SaveSettings;
     Modalresult := mrOk
end;

procedure TfrmConfigSSLAdvanced.LoadSettings;
begin
     with CfgIni do begin
        chkRC2.Checked    := ReadBool( 'SSL', 'UseRC2', True );
        chkRC4.Checked    := ReadBool( 'SSL', 'UseRC4', True );
        chkIDEA.Checked   := ReadBool( 'SSL', 'UseIDEA', False );
        chkDES.Checked    := ReadBool( 'SSL', 'UseDES', True );
        chk3DES.Checked   := ReadBool( 'SSL', 'Use3DES', True );
        chkMD5.Checked    := ReadBool( 'SSL', 'UseMD5', True );
        chkAES.Checked    := ReadBool( 'SSL', 'UseAES', True ); {MG}{AES}
        chkSHA1.Checked   := ReadBool( 'SSL', 'UseSHA1', True );
        chkADH.Checked    := ReadBool( 'SSL', 'UseADH', False );
        chkExport.Checked := ReadBool( 'SSL', 'UseExportAlgorithms', False );
        chkSSLv2.Checked  := ReadBool( 'SSL', 'UseServerModeV2', False );
     end;
     SettingsLoaded := True;
end;

procedure TfrmConfigSSLAdvanced.SaveSettings;
begin
     with CfgIni do begin
        WriteBool( 'SSL', 'UseRC2', chkRC2.Checked );
        WriteBool( 'SSL', 'UseRC4', chkRC4.Checked );
        WriteBool( 'SSL', 'UseIDEA', chkIDEA.Checked );
        WriteBool( 'SSL', 'UseDES', chkDES.Checked );
        WriteBool( 'SSL', 'Use3DES', chk3DES.Checked );
        WriteBool( 'SSL', 'UseMD5', chkMD5.Checked );
        WriteBool( 'SSL', 'UseAES', chkAES.Checked ); {MG}{AES}
        WriteBool( 'SSL', 'UseSHA1', chkSHA1.Checked );
        WriteBool( 'SSL', 'UseADH', chkADH.Checked );
        WriteBool( 'SSL', 'UseExportAlgorithms', chkExport.Checked );
        WriteBool( 'SSL', 'UseServerModeV2', chkSSLv2.Checked );
     end;
end;

procedure TfrmConfigSSLAdvanced.FormCreate(Sender: TObject);
begin
   SettingsLoaded := False;
   LoadSettings;
   chkAES.visible := OpenSSLVersion >= $00907003;
end;

procedure TfrmConfigSSLAdvanced.chkIDEAClick(Sender: TObject);
begin
     if SettingsLoaded and chkIDEA.Checked then begin
        if Application.MessageBox(
           Pchar( TrGl( kGlobal, 'LicenseInfo.IDEA',
              'The IDEA algorithm is patented in various countries by Ascom ' +
              'Systec Ltd. of CH-5506 Maegenwil, Switzerland, who allow it ' +
              'to be used on a royalty-free basis for certain non-profit ' +
              'applications. Commercial users must obtain a license from the ' +
              'company in order to use IDEA. Their web page is ' +
              'http://www.ascom.ch/.' +
              '^m^m' +
              'The free use of software containing the IDEA algorithm is ' +
              'strictly limited to non revenue generating data transfer ' +
              'between private individuals, i.e. not serving commercial purposes.' +
              '^m^m' +
              'Do you really want to enable ciphers that use IDEA?' ) ),
           PChar( Format( TrGl(kGlobal, 'LicenseInfo.Caption',
              'License Info - %s' ), ['IDEA'] ) ),
           MB_YESNO ) = IDYES
        then chkIDEA.Checked := True
        else chkIDEA.Checked := False
     end;
end;

end.
