// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit HConfigScore;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, cStdForm;

type
  TfrmConfigScore = class(THForm)
    pnlEdit: TPanel;
    emmScore: TMemo;
    pnlBtn: TPanel;
    btnOK: TButton;
    btnCancel: TButton;
    Label1: TLabel;
    emLogLimit: TEdit;
    butHelp: TButton;
    procedure btnOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

implementation

{$R *.DFM}

uses Global, Config, uTools;

procedure TfrmConfigScore.btnOKClick(Sender: TObject);
var  i: Integer;
begin
   emmScore.Lines.SaveToFile( PATH_BASE + CFGFILE_SCORES );
   try i := strtoint(TrimWhSpace(emLogLimit.Text)) except i := Def_ScoreLogLimit end;
   if i<>Def_ScoreLogLimit then begin
      Def_ScoreLogLimit := i;
      CfgIni.WriteInteger( 'Setup', 'score.loglimit', Def_ScoreLogLimit );
   end;
   ModalResult := mrOK;
end;

procedure TfrmConfigScore.FormCreate(Sender: TObject);
begin
   LoadWindowState( Self, 'ScoreEdit' );
   if FileExists2( PATH_BASE + CFGFILE_SCORES ) then begin
      emmScore.Lines.LoadFromFile( PATH_BASE + CFGFILE_SCORES );
   end else emmScore.Lines.Clear;
   emLogLimit.Text := inttostr(Def_ScoreLogLimit);
   OnResize(NIL)
end;

procedure TfrmConfigScore.FormResize(Sender: TObject);
begin
     pnlEdit.Height := ClientHeight - pnlBtn.Height;
     btnCancel.Left := pnlBtn.Width - btnCancel.Width - 4;
     btnOK.Left     := btnCancel.Left - btnOK.Width - 4;
end;

procedure TfrmConfigScore.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
     SaveWindowState( Self, 'ScoreEdit' );
end;

end.
