{***************************************************************
 *
 * Unit Name: Main
 * Purpose  :
 * Author   :
 * History  :
 *
 ****************************************************************}

// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit Main; // Main-window

// ----------------------------------------------------------------------------
// Hamster's main window
// ----------------------------------------------------------------------------

interface

{$INCLUDE Compiler.inc}

uses Windows, Dialogs, Messages, SysUtils, Classes, Menus, ExtCtrls, StdCtrls, ComCtrls,
     Controls, Forms, ShellApi, cServerNNTP, cServerPOP3, cServerSMTP, Global,
     tScriptInsCmd, contnrs, consts,
     Graphics, cStdForm, Buttons;

type
  TTransfer = (trSMTP, trPOP3, trNNTP);
  TTransfers = Set of TTransfer;
Const
  TransferAll = [trSMTP, trPOP3, trNNTP];  
type
  THamsterMainWindow = class(THForm)
    StatusBar: TStatusBar;
    Timer1: TTimer;
    Menu: TMainMenu;
    mnuFile: TMenuItem;
    mnuHelp: TMenuItem;
    mnuHelpAbout: TMenuItem;
    mnuFileExit: TMenuItem;
    mnuOnline: TMenuItem;
    mnuLocalNntp: TMenuItem;
    mnuOnlineStop: TMenuItem;
    mnuOnlinePull: TMenuItem;
    mnuSepFile1: TMenuItem;
    mnuFilePurge: TMenuItem;
    mnuFileRebuild: TMenuItem;
    mnuConfigNews: TMenuItem;
    mnuFileKills: TMenuItem;
    N5: TMenuItem;
    mnuLocalPop3: TMenuItem;
    mnuLocalSmtp: TMenuItem;
    mnuLocal: TMenuItem;
    mnuSepOnline2: TMenuItem;
    mnuOnline1: TMenuItem;
    mnuOnline2: TMenuItem;
    mnuOnline3: TMenuItem;
    mnuOnline4: TMenuItem;
    mnuOnline5: TMenuItem;
    mnuOnline6: TMenuItem;
    mnuOnline7: TMenuItem;
    mnuOnline8: TMenuItem;
    mnuOnline9: TMenuItem;
    mnuHelpContents: TMenuItem;
    N6: TMenuItem;
    pg: TPageControl;
    PageLog: TTabSheet;
    PageThreads: TTabSheet;
    lstLog: TListBox;
    lstThd: TListBox;
    mnuHelpSysInfos: TMenuItem;
    mnuScript: TMenuItem;
    mnuPullSingleNNTP: TMenuItem;
    mnuFileReset: TMenuItem;
    N1: TMenuItem;
    TrayPopup: TPopupMenu;
    mnuFileRebuildGlobalLists: TMenuItem;
    N2: TMenuItem;
    Image1a: TImage;
    Image2b: TImage;
    mnuRefreshMenuItems: TMenuItem;
    mnuScriptSeparator: TMenuItem;
    mnuStopAllScripts: TMenuItem;
    N7: TMenuItem;
    pnlLogTop: TPanel;
    chkLogAutoScroll: TCheckBox;
    TabErrors: TTabSheet;
    lstLogErrors: TListBox;
    mnuResetCountersAndLog: TMenuItem;
    mnuResetCountersOnly: TMenuItem;
    mnuResetLogOnly: TMenuItem;
    mnuSepLocal2: TMenuItem;
    mnuEditNewsScoreFile: TMenuItem;
    mnuEditMailScoreFile: TMenuItem;
    TabThread: TTabSheet;
    lstThread: TListBox;
    mnuConfigHamster: TMenuItem;
    mnuConfigMail: TMenuItem;
    mnuConfigUserAndPW: TMenuItem;
    N9: TMenuItem;
    mnuConfig: TMenuItem;
    mnuRASDial: TMenuItem;
    Panel1: TPanel;
    butCloseLogThread: TButton;
    butUpdateThreadLog: TButton;
    popLogs: TPopupMenu;
    pmShowThread: TMenuItem;
    pmCopyLineToClipboard: TMenuItem;
    pmCopyAllToClipboard: TMenuItem;
    N10: TMenuItem;
    N11: TMenuItem;
    pmClearLogs: TMenuItem;
    Image2a: TImage;
    Image1c: TImage;
    Image2c: TImage;
    Image1b: TImage;
    Panel2: TPanel;
    butCloseErrorsAndWarnings: TButton;
    mnuResetErrorsOnly: TMenuItem;
    Panel3: TPanel;
    butThreadsToThread: TButton;
    butLogToThread: TButton;
    butErrorsToThread: TButton;
    mnuScriptDemo: TMenuItem;
    mnuRASHangup: TMenuItem;
    N12: TMenuItem;
    mnuPullSinglePOP3: TMenuItem;
    mnuPullSingleSMTP: TMenuItem;
    mnuManageScriptsAndModules: TMenuItem;
    frShell: TPanel;
    labShell: TLabel;
    txtShell: TEdit;
    mnuConfigLocalServer: TMenuItem;
    N13: TMenuItem;
    mnuOpenDirs: TMenuItem;
    tsJobs: TTabSheet;
    lbJobs: TListBox;
    Panel4: TPanel;
    butKillJob: TSpeedButton;
    butJobPrioMin: TSpeedButton;
    butJobPrioMax: TSpeedButton;
    butKillAllJobs: TSpeedButton;
    butInsertShellcommand: TButton;
    popShell: TPopupMenu;
    N14: TMenuItem;
    mnuLocalReCo: TMenuItem;
    mnuReloadConfig: TMenuItem;
    mnuEditHamsterIni: TMenuItem;
    mnuEdithostsresolvingnamestoIPs: TMenuItem;
    mnuEditspecialfiles: TMenuItem;
    N4: TMenuItem;
    mnuSepConfig1: TMenuItem;
    mnuSwitchAdvancedSettings: TMenuItem;
    mnuConfigAutomatics: TMenuItem;
    N15: TMenuItem;
    mnuLocalIMAP: TMenuItem;
    butStopThread: TButton;
    History1: TMenuItem;
    mnuHelpFAQ: TMenuItem;
    mnuSepHelp2: TMenuItem;
    mnuAllHelpfiles: TMenuItem;
    mnuOnlineAllNNTP: TMenuItem;
    mnuOnlineAllPOP3: TMenuItem;
    N18: TMenuItem;
    mnuSepFile2: TMenuItem;
    mnuSepConfig2: TMenuItem;
    mnuSepOnline1: TMenuItem;
    mnuSepLocal1: TMenuItem;
    mnuSepHelp1: TMenuItem;
    mnuTools2: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure lstLogDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure Timer1Timer(Sender: TObject);
    procedure mnuHelpAboutClick(Sender: TObject);
    procedure mnuFileExitClick(Sender: TObject);
    procedure mnuLocalNntpClick(Sender: TObject);
    procedure mnuOnlineStopClick(Sender: TObject);
    procedure mnuOnlinePullClick(Sender: TObject);
    procedure mnuFilePurgeClick(Sender: TObject);
    procedure mnuFileRebuildClick(Sender: TObject);
    procedure mnuConfigNewsClick(Sender: TObject);
    procedure mnuFileKillsClick(Sender: TObject);
    procedure mnuLocalPop3Click(Sender: TObject);
    procedure mnuLocalSmtpClick(Sender: TObject);
    procedure mnuOnline1Click(Sender: TObject);
    procedure mnuHelpContentsClick(Sender: TObject);
    procedure mnuHelpSysInfosClick(Sender: TObject);
    procedure mnuFileRebuildGlobalListsClick(Sender: TObject);
    procedure OnRefreshMenuItems(Sender: TObject);
    procedure mnuMyScriptClick(Sender: TObject);
    procedure mnuMyRASDialClick(Sender: TObject);
    procedure chkLogAutoScrollClick(Sender: TObject);
    procedure mnuResetCountersAndLogClick(Sender: TObject);
    procedure mnuEditNewsScoreFileClick(Sender: TObject);
    procedure mnuEditMailScoreFileClick(Sender: TObject);
    procedure lstLogDblClick(Sender: TObject);
    procedure mnuConfigHamsterClick(Sender: TObject);
    procedure mnuConfigMailClick(Sender: TObject);
    procedure CloseConnection1Click(Sender: TObject);
    procedure mnuConfigUserAndPWClick(Sender: TObject);
    procedure butCloseLogThreadClick(Sender: TObject);
    procedure mnuFileClick(Sender: TObject);
    procedure pgDrawTab(Control: TCustomTabControl;
      TabIndex: Integer; const Rect: TRect; Active: Boolean);
    procedure butUpdateThreadLogClick(Sender: TObject);
    procedure popLogsPopup(Sender: TObject);
    procedure pmShowThreadClick(Sender: TObject);
    procedure pmCopyLineToClipboardClick(Sender: TObject);
    procedure pmCopyAllToClipboardClick(Sender: TObject);
    procedure pmClearLogsClick(Sender: TObject);
    procedure pgChange(Sender: TObject);
    procedure butCloseErrorsAndWarningsClick(Sender: TObject);
    procedure lstThdClick(Sender: TObject);
    procedure StatusBarDrawPanel(StatusBar: TStatusBar;
      Panel: TStatusPanel; const Rect: TRect);
    procedure mnuManageScriptsAndModulesClick(Sender: TObject);
    procedure txtShellKeyPress(Sender: TObject; var Key: Char);
    procedure txtShellKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormResize(Sender: TObject);
    procedure mnuConfigLocalServerClick(Sender: TObject);
    procedure butKillJobClick(Sender: TObject);
    procedure lbJobsClick(Sender: TObject);
    procedure butInsertShellcommandClick(Sender: TObject);
    procedure mnuOpenDirsClick(Sender: TObject);
    procedure mnuLocalReCoClick(Sender: TObject);
    procedure mnuReloadConfigClick(Sender: TObject);
    procedure mnuEditHamsterIniClick(Sender: TObject);
    procedure lstAnyLogMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure StatusBarDblClick(Sender: TObject);
    procedure StatusBarClick(Sender: TObject);
    procedure mnuEdithostsresolvingnamestoIPsClick(Sender: TObject);
    procedure mnuSwitchAdvancedSettingsClick(Sender: TObject);
    procedure mnuConfigClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure mnuConfigAutomaticsClick(Sender: TObject);
    procedure mnuLocalIMAPClick(Sender: TObject);
    procedure butStopThreadClick(Sender: TObject);
    procedure History1Click(Sender: TObject);
    procedure mnuHelpFAQClick(Sender: TObject);
    procedure mnuOnlineAllNNTPClick(Sender: TObject);
    procedure mnuOnlineAllPOP3Click(Sender: TObject);
    procedure labShellClick(Sender: TObject);
  private
    { Private-Deklarationen }
    HistPos: Integer;
    ShellHist: TStringList;
    LogsShowHints: Boolean;
    CheckMailboxes: TStringlist;
    slMenuScripts: TStringList;
    lHideMenuItems: TObjectlist;
    LbHorizExtent  : Integer;
    OldStatusText  : String;
    OldTrayHint    : String;
    OldTrayIconHandle: THandle;
    WMTaskbarCreate : Cardinal; /// JHS ///
    BottomlineFormat, HintFormat: String;
    SingleThreadID: String;
    SingleThreadBegin: String;
    LastPage: Byte; LastPageWasErrors: boolean;
    LastStats: TDateTime;
    InsertCommand: TInsertCommand;
    JobIsDone: Boolean;
    procedure mnuMyPullClick(Sender: TObject);
    procedure WMCopyData(var Message: TMessage); message WM_COPYDATA;
    procedure WMHamster(var Message: TMessage); message WM_HAMSTER;
    procedure WMNotifyGUI(var Message: TMessage); message WM_NOTIFYGUI;
    procedure WMTrayNotify(var Message: TMessage); message WM_TRAYNOTIFY;
    procedure WMSysCommand(var Message: TWMSysCommand); message WM_SYSCOMMAND;
     {JW}
     procedure WMCreate(var Message: TMessage);  message WM_CREATE;
     procedure WMDestroy(var Message: TMessage);  message WM_DESTROY;
     {JW}
    procedure StartTransfer( ServerList: String; Const Typ: TTransfers );
    procedure VisualSettings;
    function  MsgHook( var Msg: TMessage ): Boolean;
    procedure ShowNewsJobs;
    procedure TestJobButtons;
    procedure UpdateScriptMenu_Scripts;
    Procedure ExecJobIsDone (Sender: TObject);
    procedure PurgeDaily(const bwait: boolean);
    // Application-Events
    procedure AppActivate(Sender: TObject);
    procedure AppIdle(Sender: TObject; Var Done: Boolean);
    procedure AppException(Sender: TObject; E: Exception);
    Function  AppHelp(Command: Word; Data: Longint; var CallHelp: Boolean): Boolean;
    function  Allowed(Sender: TObject): boolean;
    procedure SetCaption;
    procedure ExtractThreadID(l: TListbox; Const Org: String;
       var SingleThreadID, SingleThreadBegin: String; Const OnlyID: Boolean);
    procedure SetAdvancedSettings;
    function Hidden(Sender: TObject): boolean;
    procedure mnuHelpFileClick(Sender: TObject);
    procedure LogToClipboard(Lb: TListbox; const ab, bis: Integer);
    procedure mnuMenuScriptClick(Sender: TObject);
  protected
    function ChangeLanguageFor(c: TComponent): boolean; override;
  public
    { Public-Deklarationen }
    ConfigWndActive: Integer;
    ModalActive    : Integer;
    FontColor, BrushColor: Array[0..7] of Integer;
    procedure ResetCounter(const Nr: Integer);
    Function  StartScript( ScriptFile, ParameterList: String; WaitForEnd: boolean ): Integer;
    procedure OnShowManualClick(Sender: TObject);
    procedure AppMinimize(Sender: TObject);
    function  GetTrayIconHandle: THandle;
    Function  LogIDtoIndex(Const ID: Integer): Integer;
    Procedure FullVisualSettings; // includes hiding of menus, too!
  end;

var
   HamsterTrayIcon  : TNotifyIconData;
   HamsterMainWindow: THamsterMainWindow;

implementation

{$R *.DFM}

{JW} {lSSL}
uses Clipbrd, ComServ,
     cLogFile, dSplash, cActions, cArticle,
     uTools, Config, dAbout, DHistory,
     HConfigSettings, HConfigNews, HConfigMail, dIPAccess,
     HConfigLocalUser, HConfigLocalServer, HConfigAutomatic,
     HKillsMain, dScripts, dEditDir, dGroupSelect,
     tTransfer, tMaintenance, tScript, uCommands,
     dInput, WinSock,  //HRR 01-01-02
     uRasDyn, uWinSock,
     cFiltersNews, //TGL /AutoTest News-Scorefile
     cFiltersMail, //TGL /AutoTest Mail-Scorefile
     cNewsJobs,
     cIPAccess, //JW //Reload IPaccess
     cMailAlias,//JW //Reload Malias
     tBase,
     uSSL; {MG}{SSL}
{JW}

Const MaxShellHistLines = 100;

procedure THamsterMainWindow.WMCreate(var Message: TMessage);
Var XP: Boolean;

  Function MakeEvent (Const ManRes, IniSt: Boolean; Const s: String): THandle;
  begin
     If XP then begin
        Result := CreateEventGrandAccess (ManRes, IniSt, PChar('Global\'+MutexString+'_'+s))
     end else begin
        {JW} {critical event}
        EnterCriticalSection(CS_Event);
        Result := CreateEvent (NIL, ManRes, IniSt, PChar(MutexString+'_'+s));
        LeaveCriticalSection(CS_Event);
        {JW}
     end
  end;

begin
   XP := IsWindowsXP;
   EventPurge        :=  MakeEvent (True,  False, 'purge');
   EventMain         :=  MakeEvent (True,  True,  'main');
   EventMailOut      :=  MakeEvent (False, False, 'mailout');
   EventMailIn       :=  MakeEvent (False, False, 'mailin' );
   EventNewsOut      :=  MakeEvent (False, False, 'newsout');
   EventMailInternal :=  MakeEvent (False, False, 'mailinternal');
   EventRasConnected :=  MakeEvent (True,  False, 'rasconnected');
   EventRasHangUp    :=  MakeEvent (True,  False, 'rashangup');
   WMTaskbarCreate := RegisterWindowMessage('TaskbarCreated'); /// JHS ///
end;

procedure THamsterMainWindow.WMDestroy(var Message: TMessage);
begin
   {JW} {purge event}
   EnterCriticalSection(CS_Event);
   try
      ResetEvent(EventPurge);
      CloseHandle(EventPurge);
      {JW}
      ResetEvent(EventMain);
      CloseHandle(EventMain);
      CloseHandle(EventMailOut);
      CloseHandle(EventMailIn);
      CloseHandle(EventMailInternal);
      CloseHandle(EventRASConnected);
      CloseHandle(EventRASHangup);
      CloseHandle(EventNewsOut);
   finally
      LeaveCriticalSection(CS_Event);
   end
end;


procedure THamsterMainWindow.WMCopyData(var Message: TMessage);
var  X: TCopyDataStruct;
     s, Parameters, MutexParam, ScriptName: String;
     i1: Integer;
     WaitForEnd: boolean;
begin
   try
      Move( Pointer(Message.lParam)^, X, sizeof(X) );

      case X.dwData of
         1, 2: begin // start script // JAWO ScriptAvail 18.12.2000 (new return value)
               SetLength( s, X.cbData );
               if (X.cbData > 0) then begin // are there parameters at all?
                  Move( X.lpData^, s[1], X.cbData );
                  // Format: <script> LF (<Param> [(CR <Param>)]*)? FF (0|1) FF <mutex>
                  Log( LOGID_DEBUG, 'WMCopyDataX(' + inttostr(X.dwData) + ', ' + s + ')' );
                  i1 := pos (FF, s);
                  if (i1 > 1) then begin // are there correct delimiters?
                     Parameters := copy (s, 1, i1-1);   // script and parameters
                     MutexParam := copy (s, i1+1, Length(s)-i1); // waitflag and mutex
                     WaitForEnd := (copy (MutexParam, 1, 1) = '1');
                     while (pos (FF, MutexParam) <> 0) do begin // mutex is always last parameter
                        MutexParam := copy (MutexParam, pos(FF, MutexParam)+1, Length(MutexParam))
                     end;
                     MutexParam := trim (MutexParam);
                     if (MutexParam = MutexString) then begin // is it for me?
                        i1 := pos (LF, Parameters);
                        if (i1 > 1) then begin
                           ScriptName := copy (Parameters, 1, i1-1);
                           Parameters := copy (Parameters, i1+1, Length(Parameters)-i1)
                        end else begin
                           ScriptName := Parameters;
                           Parameters := ''
                        end;
                        case X.dwData of // JAWO ScriptAvail 18.12.2000 (new return value)
                           1: X.cbData := StartScript (ScriptName, Parameters, WaitForEnd);
                           2: begin
                                 Log( LOGID_ERROR, 'Invalid parameter: "' + ScriptName + '"' );
                                 X.cbData := 0;
                              end;
                        end;
//                          X.cbData := StartScript (ScriptName, Parameters, WaitForEnd);
                     end;
                  end; // i1 > 1
               end; // X.cbData > 0
         end else  // case X.dwData
            Log (LOGID_ERROR, 'WMCopyData ( ' + inttostr(X.dwData) + ' ) : unknown message ID received' );
      end;

   except
      on E: Exception do
         Log( LOGID_ERROR, 'Msg.WMCopyData.Exception: ' + E.Message );
   end;
end;

Function THamsterMainWindow.GetTrayIconHandle: THandle;
Var thds: Integer;
begin
   EnterCriticalSection( CS_COUNTER );
   thds := CntActiveTasks;
   LeaveCriticalSection( CS_COUNTER );
   if thds = 0 then begin
      If CntErrors > 0 then Result := Image1c.Picture.Icon.Handle
      else If CntWarnings > 0 then Result := Image1b.Picture.Icon.Handle
      else Result := Image1a.Picture.Icon.Handle
   end else begin
      If CntErrors > 0 then Result := Image2c.Picture.Icon.Handle
      else If CntWarnings > 0 then Result := Image2b.Picture.Icon.Handle
      else Result := Image2a.Picture.Icon.Handle
   end
end;

procedure THamsterMainWindow.WMHamster(var Message: TMessage);
begin
   Message.Result := Commands.HamMessage (Message.wParam, Message.lParam)
end;

procedure THamsterMainWindow.WMTrayNotify(var Message: TMessage);
var  P : TPoint;
     MI: TMenuItem;

   procedure AddItems( SrcItems, DestItems: TMenuItem );
   var  i: Integer;
        MI: TMenuItem;
   begin
      for i:=0 to SrcItems.Count-1 do begin
         with SrcItems[i] do begin
            MI := TMenuItem.Create( Self );
            MI.Caption := Caption;
            MI.Enabled := Enabled;
            MI.Checked := Checked;
            MI.Visible := Visible;
            MI.OnClick := OnClick;
            MI.Tag     := Tag;
            DestItems.Add( MI );
         end;
         AddItems( SrcItems[i], MI );
      end;
   end;

begin
   Case Message.lParam of
      WM_LBUTTONDOWN: If Not Actions.Exec ( atTrayIconClick, '' ) then OnShowManualClick( Self );
      WM_LBUTTONDBLCLK: Actions.Exec ( atTrayIconDblClick, '' );
      WM_MBUTTONDOWN: Actions.Exec ( atTrayIconMiddleClick, '' );
      WM_MBUTTONDBLCLK: Actions.Exec ( atTrayIconMiddleDblClick, '' );
      WM_RBUTTONDOWN: begin
         if (CriticalState>0) or (ModalActive>0) then begin
            OnShowManualClick( Self );
            exit
         end;
         GetCursorPos( P );
         // Create Popup-Menu:
         // - Remove old Entries
         while TrayPopup.Items.Count>0 do TrayPopup.Items[0].Free;
         // - Add main-menus without two special entries in "file"
         AddItems( Menu.Items, TrayPopup.Items );
         With TrayPopup.Items[0] do begin
            Items[Count-2].visible := false;
            Items[Count-1].visible := false
         end;
         // - Add "-"
         MI := TMenuItem.Create( Self ); MI.Caption := '-'; TrayPopup.Items.Add( MI );
         // - Add "Show"
         If Message.lParam <> WM_LBUTTONDBLCLK then begin
            MI := TMenuItem.Create( Self );
            With MI do begin
               Caption := Tr('PopUpMenu.Show', '&Show'); OnClick := OnShowManualClick;
               Default := true
            end;
            TrayPopup.Items.Add( MI )
         end;
         // - Add "Minimize"
         MI := TMenuItem.Create( Self );
         With MI do begin
            Caption := Tr('PopUpMenu.Minimize', '&Minimize'); OnClick := AppMinimize;
         end;
         TrayPopup.Items.Add( MI );
         // - Add "-"
         MI := TMenuItem.Create( Self ); MI.Caption := '-'; TrayPopup.Items.Add( MI );
         // - Add "Exit"
         MI := TMenuItem.Create( Self );
         MI.Caption := Tr('PopUpMenu.Exit', 'E&xit');
         MI.OnClick := mnuFileExitClick;
         TrayPopup.Items.Add( MI );
         // Popup
         SetForegroundWindow( Handle );
         TrayPopup.Popup( P.x, P.y );
         PostMessage( Handle, WM_NULL, 0, 0 );
      end
   end
end;

procedure THamsterMainWindow.WMSysCommand(var Message: TWMSysCommand);
begin
   if ((Message.CmdType and $FFF0)=SC_CLOSE) and Def_MinimizeOnClose then begin
      Message.Result := 0;
      Application.Minimize;
   end else begin
      inherited;
   end;
end;

procedure THamsterMainWindow.OnShowManualClick(Sender: TObject);
Var i: Integer;
begin
   Application.Restore;
   Visible := True;
   Application.BringToFront;
   For i := 0 to Screen.CustomFormCount-1 do begin
      If Screen.CustomForms[i] <> self then With Screen.CustomForms[i] do begin
         If WindowState = wsMinimized then WindowState := wsNormal;
         BringToFront
      end
   end
end;

procedure THamsterMainWindow.AppMinimize(Sender: TObject);
begin
   //if Screen.CustomFormCount>1 then begin inherited; Exit end;
   Visible := False;
   ShowWindow( Application.Handle, SW_HIDE );
end;

procedure THamsterMainWindow.AppException(Sender: TObject; E: Exception);
begin
   Log( LOGID_ERROR, 'Main.Exception.Msg: ' + E.Message );
   Log( LOGID_ERROR, 'Main.Exception.Snd: ' + Sender.ClassName );
end;

Function THamsterMainWindow.AppHelp(Command: Word; Data: Longint; var CallHelp: Boolean): Boolean;
Var x: Word;
begin
   Result := true;
   If Lowercase(ExtractFileExt(Application.Helpfile)) = '.chm' then begin
      x := ShellExecute ( Application.handle, PChar('open'), PChar(Application.Helpfile), NIL, NIL, SW_SHOWNORMAL ) ;
      If x < 32 then Log( LOGID_ERROR, TrGlF(kLog, 'Error.running.chm_help',
         'Error %s when running chm-helpfile "%s"', [IntToStr(x), Application.Helpfile] ) );
      CallHelp := false
   end else begin
      If (Command = HELP_CONTEXT) and (Data>0) then begin
         Application.HelpJump ( IntToStr(Data) );
         CallHelp := false
      end else begin
         CallHelp := true            
      end
   end
end;

procedure THamsterMainWindow.AppIdle(Sender: TObject; Var Done: Boolean);
begin
   SaveChangedLangFiles;
   Done := true
end;

Procedure THamsterMainWindow.UpdateScriptMenu_Scripts;

   Procedure RekSort (Mi: TMenuItem);
   Var i, p: Integer; Temp: TMenuItem;
   begin
      p := 0;
      With Mi do begin
         For i := 0 to Count-1 do begin
            If Items[i] = mnuScriptSeparator then system.break;
            Case Items[i].Tag of
               0: RekSort(Items[i]);
               1: begin
                     Temp := Items[i];
                     Remove(Temp);
                     Insert(p, Temp);
                     Inc(p)
                  end
            end
         end;
      end
   end;

   Function Conform(s: String): String;
   Var i, p: Integer;
   begin
      SetLength(Result, Length(s));
      p := 0;
      For i := 1 to Length(s) do begin
         If s[i] <> '&' then begin
            Inc(p); Result[p] := UpCase(s[i])
         end
      end;
      SetLength(Result, p)
   end;

Type TMenuPosition = (mpFile, mpConfig, mpOnline, mpLocal, mpTools, mpHelp);
Var i, j, p: Integer;
    s, s2: String;
    bNew, bok, bfound: Boolean;
    Start, MI, Mi2: TMenuItem;
    MPos: TMenuPosition;
    InsertScripts: Array[TMenuPosition] of TStringList;
    sl: TStringList;
begin
   Reload_Scriptlist;
   // Menu: Script
   With mnuScript do While Items[0] <> mnuScriptSeparator do Items[0].free;
   With mnuScriptDemo do While Count>0 do Items[0].Free;

   // Menu: Not needed would be deleted
   mnuScriptDemo.Visible := Not Hidden(mnuScriptDemo);

   sl := TStringList.Create;
   try
      // Script => Menu
      // --------------
      sl.Assign(Scriptlist);
      With sl do begin
         For i := 0 to Count-2 do begin
            For j := i+1 to Count-1 do begin
               If Conform(sl[i]) > Conform(sl[j]) then begin
                  s := sl[i]; sl[i] := sl[j]; sl[j] := s
               end
            end
         end
      end;
      for i:=sl.Count-1 downto 0 do begin
         // Create New Menuitem
         MI := TMenuItem.Create( Self );
         s := sl[i];
         If lowercase(Copy(ExtractFileName(s),1,5))='demo-' then begin

            MI.Enabled:=False;
            Mi.Tag:=4;                                                   //HSR //Prior-Scripts
            mnuScriptDemo.Insert( mnuScriptDemo.count, MI );             //HSR //Prior-Scripts

         end else begin

            Start := mnuScript;
            Repeat
               p := Pos('\', s);
               If p > 0 then begin
                  s2 := Copy(s, 1, p-1);
                  Delete(s, 1, p);
                  bNew := true;
                  For j := 0 to Start.Count-1 do begin
                     If Start.Items[j] = mnuScriptSeparator then break;
                     If (Start.Items[j].Tag = 0) and (LowerCase(Start.Items[j].Caption)=LowerCase(s2)) then begin
                        Start := Start.Items[j]; bNew := false; break
                     end
                  end;
                  If bNew then begin
                     Mi2 := TMenuItem.Create(Self);
                     Mi2.Caption := s2;
                     Mi2.Tag := 0;
                     Start.Insert(0, Mi2);
                     Start := Mi2
                  end
               end;
            until p = 0;
            Start.Insert(0, Mi)
         end;
         // Set Menuproperties
         MI.Tag     := 1;
         MI.Caption := ChangeFileExt(s, '');
         MI.OnClick := mnuMyScriptClick;
      end;
      RekSort (mnuScript);
      // Special Items
      // -------------
      // - Clear
      For MPos := Low(TMenuPosition) to High(TMenuPosition) do begin
         InsertScripts[MPos] := TStringList.Create;
         InsertScripts[MPos].Sorted := true
      end;
      try
         slMenuScripts.Clear;
         // - Insert
         For i := sl.Count-1 downto 0 do begin
            FileMode := 0;
            With TTextReader.Create(PATH_HSC + sl[i], 1024) do try
               bFound := false;
               While Not (EOF or bFound) do begin
                  s := Trim(ReadLine);
                  If LowerCase(Copy(s, 1, 7))='#!menu:' then begin
                     bFound := true;
                     Delete(s, 1, 7);
                     p := Pos('=', s);
                     If p > 0 then begin
                        s2 := LowerCase(Copy(s, 1, p-1));
                        bOK := true;
                        MPos :=  Low(TMenuPosition);
                        If s2 = 'file' then MPos := mpFile
                        else If s2 = 'config' then MPos := mpConfig
                        else If s2 = 'online' then MPos := mpOnline
                        else If s2 = 'local' then MPos := mpLocal
                        else If s2 = 'tools' then MPos := mpTools
                        else If s2 = 'help' then MPos := mpHelp
                        else begin
                           Log ( LOGID_WARN, 'Script "'+sl[i]
                              +'" includes an invalid #!menu-command: "'+s2+'" is no defined destination!');
                           bOK := false
                        end;
                        If bOK then begin
                           InsertScripts[MPos].AddObject(
                              Copy(s, p+1, Length(s)-p),
                              Pointer(slMenuScripts.Add (sl[i]))
                           )
                        end
                     end
                  end
               end
            finally
               free
            end
         end;
         With mnuFile do
            While Items[mnuSepFile1.MenuIndex+1]<>mnuSepFile2 do
               Delete(mnuSepFile1.MenuIndex+1);
         With mnuConfig do
            While Items[mnuSepConfig1.MenuIndex+1]<>mnuSepConfig2 do
               Delete(mnuSepConfig1.MenuIndex+1);
         With mnuOnline do
            While Items[mnuSepOnline1.MenuIndex+1]<>mnuSepOnline2 do
               Delete(mnuSepOnline1.MenuIndex+1);
         With mnuLocal do
            While Items[mnuSepLocal1.MenuIndex+1]<>mnuSepLocal2 do
               Delete(mnuSepLocal1.MenuIndex+1);
         mnuTools2.Clear;
         With mnuHelp do
            While Items[mnuSepHelp1.MenuIndex+1]<>mnuSepHelp2 do
               Delete(mnuSepHelp1.MenuIndex+1);
         For MPos := Low(TMenuPosition) to High(TMenuPosition) do begin
            For i := InsertScripts[MPos].Count-1 downto 0 do begin
               MI := TMenuItem.Create(Self);
               MI.Tag := Longint(InsertScripts[MPos].Objects[i]);
               MI.OnClick := mnuMenuScriptClick;
               Mi.Caption := InsertScripts[MPos][i];
               Case MPos of
                  mpFile:    mnuFile.Insert(mnuSepFile1.MenuIndex+1, MI);
                  mpConfig:  mnuConfig.Insert(mnuSepConfig1.MenuIndex+1, MI);
                  mpOnline:  mnuOnline.Insert(mnuSepOnline1.MenuIndex+1, MI);
                  mpLocal:   mnuLocal.Insert(mnuSepLocal1.MenuIndex+1, MI);
                  mpTools:   mnuTools2.Insert(0, MI);
                  mpHelp:    mnuHelp.Insert(mnuSepHelp1.MenuIndex+1, MI);
               end
            end
         end;
         mnuTools2.Visible := (Not Hidden(mnuTools2)) and (mnuTools2.Count>0) 
      finally
         For MPos := Low(TMenuPosition) to High(TMenuPosition)
            do InsertScripts[MPos].free
      end
   finally
      sl.free
   end;

   // Menu: Not needed would be deleted
   if mnuScriptDemo.Count<=0 then mnuScriptDemo.visible:=false;

end;

Procedure THamsterMainWindow.mnuMenuScriptClick (Sender: TObject);
begin
   If Sender=NIL then Exit;
   If Not (Sender is TMenuItem) then Exit;
   AllShutdownReq := False;
   Timer1Timer(Self);
   StartScript( PATH_HSC + slMenuScripts[(Sender as TMenuItem).Tag], '', false)
end;

procedure THamsterMainWindow.OnRefreshMenuItems(Sender: TObject);
Var TS, RasConns: TStringList;
    MI: TMenuItem;
    i, Nr : Integer;
    s: String;
    v: Boolean;
    r: TSearchRec;
begin
   TS := TStringList.Create;
   try
      // Menu: Online (server groups)
      If Not ArchivMode then begin
         Nr := 0;
         for i:=1 to 9 do begin
            s := CfgIni.ReadString( 'Online-Menu', 'Title'+inttostr(i), '' );
            if s='' then v:=False else v:=True;
            If v and (s <> '-') then begin Inc(Nr); s := '&' + inttostr(Nr) + ': ' + s end;
            With FindComponent('mnuOnline'+Inttostr(i)) as TMenuItem do begin
               Caption := s;
               Visible:= v;
               HelpContext := HelpIDFor('mnuOnline1-9') 
            end
         end;
         mnuSepOnline1.Visible := Nr > 1
      end;

      If Not ArchivMode then begin
         // Menu: Online / Single server NNTP
         TS.Clear;
         With CfgHamster do
            for i:=0 to ServerCount-1 do TS.Add( ServerName[i] + ',' + ServerPort[i] );
         TS.Sort;
         With mnuPullSingleNNTP do begin
            While Count>0 do Items[0].Free;
            for i:=0 to TS.Count-1 do begin
               Add( TMenuItem.Create( Self ) );
               With Items[Count-1] do begin Caption := TS[i]; OnClick := mnuMyPullClick end
            end;
            Visible := (Not Hidden(mnuPullSingleNNTP)) and (TS.Count > 0)
         end;
         // Menu: Online / Single server POP3
         TS.Clear;
         With CfgHamster do begin
            For i:=0 to Pop3ServerCount-1 do begin
               TS.Add( Pop3ServerName[i] + ',' + Pop3ServerPort[i] )
            end
         end;
         TS.Sort;
         With mnuPullSinglePOP3 do begin
            While Count>0 do Items[0].Free;
            for i:=0 to TS.Count-1 do begin
               Add( TMenuItem.Create( Self ) );
               With Items[Count-1] do begin Caption := TS[i]; OnClick := mnuMyPullClick end
            end;
            Visible := (Not Hidden(mnuPullSinglePOP3)) and (TS.Count > 0)
         end;
         // Menu: Online / Single server SMTP
         TS.Clear;
         With CfgHamster do
            For i:=0 to SMTPServerCount-1 do TS.Add( SMTPServerName[i] + ',' + SMTPServerPort[i] );
         TS.Sort;
         With mnuPullSingleSMTP do begin
            While Count>0 do Items[0].Free;
            for i:=0 to TS.Count-1 do begin
               Add( TMenuItem.Create( Self ) );
               With Items[Count-1] do begin Caption := TS[i]; OnClick := mnuMyPullClick end
            end;
            Visible := (Not Hidden(mnuPullSingleSMTP)) and (TS.Count > 0)
         end
      end;

      // Menu: RAS-Connections
      While mnuRasDial.Count > 0 do mnuRasDial.Items[0].free;
      RasConns := TStringList.Create;
      If Not Assigned(RasDialer) then Rasdialer := TRasDialer.Create;
      try
         RasDialer.GetConnectionList( RasConns );
         RasConns.Sort;
         for i:=0 to RasConns.Count-1 do begin
            MI := TMenuItem.Create( Self );
            MI.Caption := RasConns[i];
            MI.OnClick := mnuMyRASDialClick;
            mnuRasDial.Insert( i, MI )
         end;
         mnuRasDial.Visible := (RasConns.Count > 0) and (Not Hidden(mnuRasDial));
         mnuRasHangUp.Visible := (RasConns.Count > 0) and (Not Hidden(mnuRasHangUp));
      finally
         RasConns.free
      end;

      // Available help-files
      TS.Clear;
      If FindFirst(PATH_BASE + '*.hlp', faAnyfile-faDirectory-faVolumeID, r)=0 then try
         Repeat TS.Add(r.Name) until FindNext(r)<>0
      finally
         FindClose(r)
      end;
      If FindFirst(PATH_BASE + '*.chm', faAnyfile-faDirectory-faVolumeID, r)=0 then try
         Repeat
            TS.Add(r.Name)
         until FindNext(r)<>0
      finally
         FindClose(r)
      end;
      For i := 0 to TS.Count-1 do begin
         s := LowerCase(TS[i]);
         s[1] := UpCase(s[1]);
         TS[i] := s
      end;
      TS.Sort;
      With mnuAllHelpfiles do begin
         While Count>0 do Items[0].Free;
         For i := 0 to TS.Count-1 do begin
            MI := TMenuItem.Create( Self );
            MI.Caption := TS[i];
            MI.OnClick := mnuHelpFileClick;
            Add(MI)
         end
      end

   finally
      TS.Free;
   end;
   UpdateScriptMenu_Scripts;
end;

Procedure THamsterMainWindow.mnuHelpFileClick (Sender: TObject);
begin
   If Sender is TMenuItem then begin
      ShellExecute (Application.Handle,
                    PChar('open'),
                    PChar(PATH_BASE + (Sender as TMenuItem).Caption),
                    NIL,
                    NIL,
                    SW_SHOWNORMAL)
   end
end;

Procedure THamsterMainWindow.PurgeDaily (Const bwait: boolean);
Var Akt, Alt: String;
begin
   JobIsDone := false;
   Akt := FormatDateTime('yyyymmdd', Now);
   Alt := CfgIni.ReadString('Setup', 'purge.lastdailypurge', '');
   If Akt > Alt then begin
      CfgIni.WriteString('Setup', 'purge.lastdailypurge', Akt);
      AllShutdownReq := False;
      IncCounter(CanCloseNow,1);
      Log( LOGID_SYSTEM, TrGl(kLog, 'System.Purge.Start', 'Starting purge ...') );
      TThreadPurge.Create( $FFFF , '', ExecJobIsDone).resume;
      If bWait then Repeat Application.ProcessMessages until JobIsDone;
      IncCounter(CanCloseNow,-1)
   end
end;

procedure THamsterMainWindow.FormCreate(Sender: TObject);
//var  j: Integer; Waitflag: boolean; ScriptFile, ParameterList: String;
Var ErrorCode: Integer;
    WSAData: TWSAData;    //HRR 01-01-02
    ScriptFile, ParameterList: String;
    Waitflag: Boolean;

   Procedure GetColor ( Const Idx: Integer; Const Key: String; Const DefTextCol, DefBrushCol: TColor );
   Var s: String;
   begin
      FontColor [Idx] := DefTextCol;
      BrushColor [Idx] := DefBrushCol;
      s := CfgIni.ReadString('Main', 'Color.'+key+'.text', '');
      If s > '' then try
         FontColor [Idx] := StringToColor(s)
      except
         Log ( LOGID_WARN, TrF('NoValidColor', '"%s" is no valid color', s) )
      end;
      s := CfgIni.ReadString('Main', 'Color.'+key+'.brush', '');
      If s > '' then try
         BrushColor [Idx] := StringToColor(s)
      except
         Log ( LOGID_WARN, TrF('NoValidColor', '"%s" is no valid color', s) )
      end;
   end;

begin
   Application.HintPause := 500;
   Application.HintHidePause := 30000;
   ErrorCode := WSAStartup($0101, WSAData);  //HRR 01-01-02
   if ErrorCode <> 0 then begin
     Log(LOGID_Error, 'WSAStartup-Error: '+SysErrorMessage(ErrorCode)+' ('+IntToStr(ErrorCode)+')');
   end;
   pg.Align := alClient;

   CheckMailboxes := TStringList.Create;

   slMenuScripts := TStringList.Create;

   lHideMenuItems := TObjectlist.Create;
   lHideMenuItems.OwnsObjects := false;

   LastStats := Now;
   ShellHist := TStringList.Create;
   InsertCommand := TInsertCommand.Create ( popShell, txtShell );

   GetColor ( 1, 'debug',   clLtGray, clWhite );
   GetColor ( 2, 'detail',  clBlack,  clWhite );
   GetColor ( 3, 'info',    clBlack,  clWhite );
   GetColor ( 4, 'system',  clWhite,  clBlue );
   GetColor ( 5, 'warning', clBlack,  clYellow );
   GetColor ( 6, 'error',   clWhite,  clRed );
   GetColor ( 0, 'else',    clBlack,  clWhite );
   lstLog.Color := BrushColor[0];

   LogsShowHints := CfgIni.ReadBool ( 'Main', 'Logs.ShowHints', true);
   try
      If CfgIni.ReadBool ( 'Main', 'ShellHist.Log', true)
        then If FileExists2( PATH_LOGS + 'ShellHis.log')
              then ShellHist.LoadFromFile( PATH_LOGS + 'ShellHis.log' );
      HistPos := ShellHist.Count;
      If FileExists2( PATH_BASE + 'Hamst_1a.ico')
         then Image1a.Picture.LoadFromFile ( PATH_BASE + 'Hamst_1a.ico' );
      If FileExists2( PATH_BASE + 'Hamst_1b.ico')
         then Image1b.Picture.LoadFromFile ( PATH_BASE + 'Hamst_1b.ico' );
      If FileExists2( PATH_BASE + 'Hamst_1c.ico')
         then Image1c.Picture.LoadFromFile ( PATH_BASE + 'Hamst_1c.ico' );
      If FileExists2( PATH_BASE + 'Hamst_2a.ico')
         then Image2a.Picture.LoadFromFile ( PATH_BASE + 'Hamst_2a.ico' );
      If FileExists2( PATH_BASE + 'Hamst_2b.ico')
         then Image2b.Picture.LoadFromFile ( PATH_BASE + 'Hamst_2b.ico' );
      If FileExists2( PATH_BASE + 'Hamst_2c.ico')
         then Image2c.Picture.LoadFromFile ( PATH_BASE + 'Hamst_2c.ico' );
   except end;
   If FileExists2( PATH_BASE + 'Hamster.ico') then begin
      Application.Icon.LoadFromFile ( PATH_BASE + 'Hamster.ico' );
      Icon.LoadFromFile ( PATH_BASE + 'Hamster.ico' )
   end;

   With Application do begin
      OnException := AppException;
      OnMinimize  := AppMinimize;
      OnActivate := AppActivate;
      OnIdle := AppIdle;
      OnHelp := AppHelp;
      HookMainWindow( MsgHook )
   end;

   hWndMainWindow := Handle;
   ModalActive   := 0;

   with HamsterTrayIcon do begin
      cbSize := sizeof(HamsterTrayIcon);
      Wnd    := Handle;
      uID    := 42;
      uFlags := NIF_MESSAGE or NIF_ICON or NIF_TIP;
      uCallbackMessage := WM_TRAYNOTIFY;
      hIcon  := GetTrayIconHandle;
      szTip  := '';
   end;
   OldTrayIconHandle := HamsterTrayIcon.hIcon;
   Shell_NotifyIcon( NIM_ADD, @HamsterTrayIcon );

   {$IFDEF D5GE} // Delphi 5
   Menu.AutoHotkeys := maManual;
   TrayPopup.AutoHotkeys := maManual;
   {$ENDIF}

   OldStatusText := '';
   OldTrayHint   := '';
   AllShutdownReq   := False;
   SetCounter(CanCloseNow,0);
   ConfigWndActive   := 0;

   Log( LOGID_SYSTEM,
        GetMyStringFileInfo('ProductName','Hamster') + ' ' + GetMyVersionInfo(true)
             + ' ' + TrGl(kLog,'Started', 'started') );

   If Def_OLE_Server then begin
      Log( LOGID_SYSTEM, TrGlF(kLog, 'COMServerStartedAs',
         'COM/DCOM Server started with name: %s', Def_OLE_Server_Name ) ); {JW} {OLE-Server}
   end;

   LocalNntpServer := nil;
   LocalPop3Server := nil;
   LocalSmtpServer := nil;
   LocalIMAPServer := NIL;
   LocalReCoServer := NIL;

   ConfigLoad (ctAll);

   {MG}{SSL}
   SSLReady := InitializeSSL;
   If SSLReady then begin
      Log( LOGID_SYSTEM, TrGl(kLog, 'SSL.InitDone',
           'OpenSSL crypto libraries initialized') )
   end else begin
      Log( LOGID_DETAIL, TrGl(kLog, 'SSL.InitError',
           'OpenSSL initialization failed - SSL functions disabled') );
      Case Def_LocalNntpTlsMode of
        1: Log( LOGID_WARN, TrGl(kLog, 'SSL.InitError.NNTP.TLSMode.1',
           'SSL-initialization failed, so local NNTP-Server won''t use SSL') );
        2: Log( LOGID_ERROR, TrGl(kLog, 'SSL.InitError.NNTP.TLSMode.2',
           'SSL-initialization failed, so local NNTP-Server won''t accept any connection') );
      end;
      Case Def_LocalSMTPTlsMode of
        1: Log( LOGID_WARN, TrGl(kLog, 'SSL.InitError.SMTP.TLSMode.1',
           'SSL-initialization failed, so local SMTP-Server won''t use SSL') );
        2: Log( LOGID_ERROR, TrGl(kLog, 'SSL.InitError.SMTP.TLSMode.2',
           'SSL-initialization failed, so local SMTP-Server won''t accept any connection') );
      end;
      Case Def_LocalPOP3TlsMode of
        1: Log( LOGID_WARN, TrGl(kLog, 'SSL.InitError.POP3.TLSMode.1',
           'SSL-initialization failed, so local POP3-Server won''t use SSL') );
        2: Log( LOGID_ERROR, TrGl(kLog, 'SSL.InitError.POP3.TLSMode.2',
           'SSL-initialization failed, so local POP3-Server won''t accept any connection') );
      end;
      If Def_LocalRecoUseTls then begin
        Log( LOGID_ERROR, TrGl(kLog, 'SSL.InitError.Reco.TLSMode',
           'SSL-initialization failed, so local ReCo-Server won''t accept any connection') );
      end
   end;
   {/SSL}

   If Not LoadWindowState( Self, 'Main' ) then begin
      Left := (Screen.Width - Width) div 2;
      Top := (Screen.Height - Height) div 2;
   end;

   LastStats := Now;
   Timer1.Interval := LOGFILEREFRESH * 100;
   Timer1.Enabled := True;

   LbHorizExtent := 0; // lstLog.ClientWidth - GetSystemMetrics(SM_CXVSCROLL);
   SendMessage( lstLog.Handle, LB_SETHORIZONTALEXTENT, LbHorizExtent, 0 );
   With lstLog do ItemHeight := Canvas.TextHeight('Gg');
   With lstThd do ItemHeight := Canvas.TextHeight('Gg');
   With lstLogErrors do ItemHeight := Canvas.TextHeight('Gg');
   With lstThread do ItemHeight := Canvas.TextHeight('Gg');

   pg.OwnerDraw := true;
   LastPage := CfgIni.ReadInteger( 'Main', 'Tab', 0 );
   If (pg.Pages[LastPage] <> PageLog) then LastPage := 0;
   pg.ActivePage := pg.Pages[LastPage];

   TabThread.TabVisible := false;
   TabErrors.TabVisible := false;

   IncCounter( CntOutboxChk, 1 );

   OnResize (NIL);

   SplashOff;
   If CfgIni.ReadInteger( 'Setup', 'startup.hide', 0 ) = 0 then Show;

   FullVisualSettings;

   Application.ProcessMessages;

   If Not ArchivMode then begin
      If CfgIni.ReadBool ('Setup', 'CheckDirs.daily', true) then begin
         CheckObsoleteServerDirs;
         CheckObsoleteGroupDirs
      end;
      With TFiltersNews.Create( PATH_BASE + CFGFILE_SCORES ) do try
         Purge;
         Test
      finally Free end;
      With TFiltersMail.Create( PATH_BASE + CFGFILE_MFILTER ) do try
         Purge;
         Test
      finally Free end;
      if not FileExists2( PATH_SERVER + SRVFILE_ALLDESCS ) then begin
         GlobalListMarker( glTODO );
         TThreadRebuildGlobalLists.Create.resume
      end;
      EmptyTrash;
      If Def_purge_Daily then PurgeDaily (true);
      If CfgIni.ReadBool( 'Setup', 'CreateStatistics.daily', true) then begin
         JobIsDone := false;
         With TThreadStatistics.Create do begin
            OnTerminate := ExecJobIsDone;
            resume
         end;
         Repeat Application.ProcessMessages until JobIsDone
      end;
   end;

   if Winsock2Installed then begin

      if CfgIni.ReadBool( 'Setup', CFG_LOCAL_AUTOSTART_NNTP, True ) then begin
         LocalServerActivate( stNNTP, saSTART );
         HamsterMainWindow.mnuLocalNntp.Checked := LocalServerIsActive( stNNTP );
      end;

      if CfgIni.ReadBool( 'Setup', CFG_LOCAL_AUTOSTART_POP3, True ) then begin
         LocalServerActivate( stPOP3, saSTART );
         HamsterMainWindow.mnuLocalPop3.Checked := LocalServerIsActive( stPOP3 );
      end;

      if CfgIni.ReadBool( 'Setup', CFG_LOCAL_AUTOSTART_IMAP, false ) then begin //IMAP
         LocalServerActivate( stIMAP, saSTART );
         HamsterMainWindow.mnuLocalIMAP.Checked := LocalServerIsActive( stIMAP );
      end;

      If Not ArchivMode then begin
         if CfgIni.ReadBool( 'Setup', CFG_LOCAL_AUTOSTART_SMTP, True ) then begin
            LocalServerActivate( stSMTP, saSTART );
            HamsterMainWindow.mnuLocalSmtp.Checked := LocalServerIsActive( stSMTP );
         end
      end;

      if CfgIni.ReadBool( 'Setup', CFG_LOCAL_AUTOSTART_RECO, false ) then begin
         LocalServerActivate( stRECO, saSTART );
         HamsterMainWindow.mnuLocalReCo.Checked := LocalServerIsActive( stRECO );
      end

   end;

   Actions.Exec ( atStartUp, '' );

   Case ScriptAvail (ScriptFile, ParameterList, WaitFlag) of
      1: HamsterMainWindow.StartScript (ScriptFile, ParameterList, WaitFlag);
      2: Log( LOGID_ERROR, 'Invalid parameter: "' + ScriptFile  + '"');
   end;

end;

Procedure THamsterMainWindow.VisualSettings;

   Procedure SearchForMailboxEntries (Const Org: String);
   Var i, M: Integer; c: Char; s: String;
   Const MailboxChars = ['A'..'Z', '0'..'9', '_', '-', '.'];
   begin
      M := 0;
      For i:=1 to Length(Org) do begin
         c := Org[i];
         Case M of
            0: If c='%' then Inc(M);
            1: If UpCase(c)='M' then Inc(M) else M := 0;
            2: If c = ':' then Inc(M) else M := 0;
            3: If UpCase(c) IN MailboxChars then begin
                  Inc(M); s := c
               end;
            4: begin
                  If c = '%' then begin
                     CheckMailBoxes.Add (s); M := 0
                  end
                  else If UpCase(c) IN MailboxChars then s := s + c
                  else M := 0
               end
         end
      end
   end;

Var i: integer;
begin
   SetCaption;
   SetAdvancedSettings;
   i := CfgIni.ReadInteger( 'Main', 'ShowShell', Def_ShowShell );
   frShell.Visible := i > 0;
   Case i of 1: frShell.Align := alTop; 2: frShell.Align := alBottom end;

   BottomlineFormat := CfgIni.ReadString( 'Main', 'BottomLineFormat',
     Tr('Bottomline.Default', 'Tasks/Jobs=%TA/%JO   OutBox: N/M=%NO/%MO'
        + '   News=%NI (Load=%NL History=%NH Kill=%NK)'
        + '   Mails=%MI   Bytes=%BY'));
   HintFormat := CfgIni.ReadString( 'Main', 'HintFormat',
     Tr('HintFormat.Default', 'Tasks/Jobs=%TA/%JO,  N/M=%NO/%MO,  Arts=%NI,  Mails=%MI'));

   CheckMailboxes.Clear;
   SearchForMailboxEntries (BottomlineFormat);
   SearchForMailboxEntries (HintFormat);

   Timer1Timer (Timer1);

   OnRefreshMenuItems( Self );
   mnuHelpFAQ.Enabled := HelpFAQID > '';
   TestJobButtons;

   If ArchivMode then begin
      With mnuFile do For i := 0 to Count-1 do
         If Items[i]<>mnuFileExit then Items[i].Visible := false;
      With mnuConfig do For i := 0 to Count-1 do
         If (Items[i]<>mnuConfigHamster)
             and (Items[i]<>mnuConfigUserAndPW)
             and (Items[i]<>mnuConfigLocalServer)
         then Items[i].Visible := false;
      With mnuOnline do For i := 0 to Count-1 do
         If (Items[i]<>mnuOnlineStop) and
            (Items[i]<>mnuRASDial) and
            (Items[i]<>mnuRASHangUp)
         then Items[i].Visible := false;
      mnuManageScriptsAndModules.Visible := false;
      With mnuLocal do For i := 0 to Count-1 do
         If (Items[i]<>mnuLocalNNTP) and
            (Items[i]<>mnuLocalPOP3)
         then Items[i].Visible := false;
   end;
end;

procedure THamsterMainWindow.SetAdvancedSettings;
begin
   With mnuSwitchAdvancedSettings do begin
      If Def_AdvancedConfiguration
         then Caption := Tr('AdvancedConfig.Disable', 'Disable advanced Configuration')
         else Caption := Tr('AdvancedConfig.Enable', 'Enable advanced Configuration')
   end
end;

procedure THamsterMainWindow.SetCaption;
Var s: String;

  Function ExpandWildCards(Const s: String): String;
  Var p: Integer;
  begin
     Result := s;
     p := Pos('%hamster%', LowerCase(Result));
     If p > 0 then begin
        Delete(Result, p, 9);
        Insert( GetMyStringFileInfo('ProductName','Hamster'), Result, p)
     end;
     p := Pos('%version%', LowerCase(Result));
     If p > 0 then begin
        Delete(Result, p, 9);
        Insert( GetMyBuildInfo, Result, p)
     end;
     p := Pos('%readonly%', LowerCase(Result));
     If p > 0 then begin
        Delete(Result, p, 10);
        If ArchivMode then begin
           Insert( '['+Tr('CaptionAdd.ReadOnly', 'ReadOnly')+']', Result, p)
        end
     end
  end;

begin
   s := CfgIni.ReadString('Main', 'Title', '');
   If s = '' then s := '%Hamster% V%Version% %Readonly%';
   Caption := Trim(ExpandWildCards(s));
   s := CfgIni.ReadString('Main', 'TaskbarTitle', '');
   If s = '' then s := 'Hamster';
   Application.Title := Trim(ExpandWildCards(s))
end;

procedure THamsterMainWindow.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
{JW} {End}
   CanClose:=True;
   // Nur schlieen wenn Hamster im unkritischen Zustand
   if CriticalState>0 then begin
      CanClose := False;
      Log( LOGID_SYSTEM, TrGl(kLog, 'Shutdown.rejected', 'Shutdown rejected') );
      exit;
   end;
   // Nur schlieen wenn Hamster kein Setup-Men offen hat
{   if ConfigWndActive>0 then begin
      CanClose := False;
      Log( LOGID_SYSTEM, TrGl(kLog, 'Shutdown.rejected.ActiveConfigMenu',
           'Shutdown rejected, config menue active') );
      exit;
   end; }
   // Nur schlieen wenn Hamster nichts gefhrliches tut
   if GetCounter(CanCloseNow)=0 then begin
      CountOutboxes;
      // Nur den User Fragen wenn der Hamster nich mit Script-Befehl beendet wird
      If (Not ArchivMode)
         and (not CloseByScript)
         and (CfgIni.ReadInteger('Setup','main.AskIfOutboxNotEmpty', 0) = 1)
         and (CntOutboxN + CntOutboxM > 0)
      then begin
         If Application.MessageBox(
            PChar(TrF('QuitHamster.butOutboxNotEmpty',
              'There are %s articles and %s mail in the outbox. Do you really '
              +'want to quit Hamster now?',
                 [IntToStr(CntOutboxN), IntToStr(CntOutboxM)])),
            PChar(caption),
            MB_ICONQUESTION + MB_YESNO + MB_DEFBUTTON2) = IDNO
         then begin
            CanClose := false;
            Log( LOGID_SYSTEM, TrGl(kLog, 'Shutdown.Rejected.ByUser', 'Shutdown rejected by user') );
         end else begin
            Log( LOGID_SYSTEM, TrGl(kLog, 'Shutdown.Accepted.ByUser', 'Shutdown accepted by user') );
         end
      end
   end else begin
      Log(LOGID_WARN, TrGl(kLog,'Shutdown.Rejected.ThreadsWorking', 'Can''t shutdown because of active internal threads'));
      CanClose := False;
      exit;
   end
end;


procedure THamsterMainWindow.FormDestroy(Sender: TObject);
Var i, ErrorCode : Integer;     //HRR 01-01-02
begin

   Actions.Exec ( atShutDown, '' );

   // Delete Registry-Entries for OLE-Server, if OLE-Server was disabled in this session!
   If Def_OLE_Server and (Not CfgIni.ReadBool('Setup','startup.OLEServer', Def_OLE_Server)) then begin
      DllUnregisterServer
   end;

   ErrorCode := WSACleanup;   //HRR 01-01-02
   if ErrorCode <> 0 then begin
     Log(LOGID_Error, 'WSACleanup-Error: '+SysErrorMessage(ErrorCode)+' ('+IntToStr(ErrorCode)+')');
   end;

   i := 0;
   while GetCounter(CntActiveTasks)>0 do begin
      Log( LOGID_WARN, TrGlF(kLog, 'Shutdown.ThreadsStillActive',
           'Shutdown all tasks (%s still active)',
           IntToStr(GetCounter(CntActiveTasks)) ) );

      AllShutDownReq := True;
      {JW} {critical event}
      EnterCriticalSection(CS_Event);
      SetEvent( EVT_STOPSCRIPT );
      LeaveCriticalSection(CS_Event);
      {JW}
      Sleep( 500 );
      inc( i );
      if i>=20 then begin
          Log(LOGID_WARN, TrGl(kLog,'Shutdown.ThreadsNotTerminated',
             'Can''t terminate all tasks before exit application'));
          Sleep (500);
          break
      end
   end;
   if HamsterTrayIcon.hIcon<>0 then Shell_NotifyIcon(NIM_DELETE,
                                                     @HamsterTrayIcon );

   Application.UnHookMainWindow( MsgHook );

   try if Assigned(LocalNntpServer) then LocalNntpServer.Free
   finally LocalNntpServer:=nil end;

   try if Assigned(LocalPop3Server) then LocalPop3Server.Free
   finally LocalPop3Server:=nil end;

   try if Assigned(LocalImapServer) then LocalImapServer.Free
   finally LocalImapServer:=nil end;

   try if Assigned(LocalSmtpServer) then LocalSmtpServer.Free
   finally LocalSmtpServer:=nil end;

   try if Assigned(LocalReCoServer) then LocalReCoServer.Free
   finally LocalReCoServer:=nil end;

   if SSLReady then FreeSSL; {MG}{SSL}
   
   if (CntArtLoad>0) then With CfgIni do begin
      WriteInteger('Stats','Load', ReadInteger('Stats','Load',0)+CntArtLoad);
      WriteInteger('Stats','Hist', ReadInteger('Stats','Hist',0)+CntArtHist);
      WriteInteger('Stats','Kill', ReadInteger('Stats','Kill',0)+CntArtKill);
      WriteInteger('Stats','ByMid',  ReadInteger('Stats','ByMid',0)+CntArtByMid); //HSR //GetByMid-Counter
   end;

   SaveWindowState( Self, 'Main' );
   CfgIni.WriteInteger( 'Main', 'Tab', pg.ActivePage.PageIndex );

   ConfigShutdown;

   Log( LOGID_SYSTEM, TrGl(kLog, 'end', 'END') );

   CheckMailBoxes.Free;
   If CfgIni.ReadBool ( 'Main', 'ShellHist.Log', true)
      then try ShellHist.SaveToFile ( PATH_LOGS + 'ShellHis.log') except end
      else If FileExists2(PATH_LOGS + 'ShellHis.log') then DeleteFile(PATH_LOGS + 'ShellHis.log');

   ShellHist.Free;
   InsertCommand.Free;
   lHideMenuItems.Free;
   slMenuScripts.Free;
end;


procedure THamsterMainWindow.lstLogDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var  ID, l, Idx: Integer; TX   : String; lstLog: TListBox;
begin
   lstLog := TListBox(Control);

   TX := lstLog.Items[Index];
   ID := Integer(lstLog.Items.Objects[Index]);

   try with lstLog.Canvas do begin
      Idx := LogIDtoIndex(ID);
      Font.Color := FontColor[idx];
      Brush.Color := BrushColor[idx];
      FillRect(Rect);
      TextOut( Rect.Left + Rect.Bottom-Rect.Top - 2, Rect.Top, TX );
      If odSelected IN State then begin
         Pen.Color := Font.Color;
         Brush.Color := clBlack;
         Polygon ( [ Point(Rect.left+2, Rect.Top+2),
                     Point(Rect.left+2, Rect.Bottom-2),
                     Point(Rect.Bottom-Rect.Top-4, Rect.Top + (Rect.Bottom-Rect.Top) Div 2),
                     Point(Rect.left+2, Rect.Top+2) ] )
      end;

      l := TextWidth( TX );
      if l>LbHorizExtent then begin
         LbHorizExtent := l;
         SendMessage( lstLog.Handle, LB_SETHORIZONTALEXTENT, LbHorizExtent, 0 );
      end;
   end except end;
end;

const DoLog: Boolean = False;

procedure THamsterMainWindow.Timer1Timer(Sender: TObject);
Var thds, jobs: Integer;

   { TGL }
   Function ExpandInfo (Const s: String): String;
   Var s2, s3: String; i, j, l: Integer;
   begin
      Result := s;
      i := 1;
      While i <= Length(Result)-1 do begin
         s3 := ''; l := 3;
         If (Result[i]='^') and (UpCase(Result[i+1])='M') then begin
            Result[i] := #13; Result[i+1] := #10; Inc(i)
         end else
         If (Result[i]='%') and (i<=Length(Result)-2) then begin
            s2 := UpCase(Result[i+1])+UpCase(Result[i+2]);
            If s2 = 'TA' then s3 := inttostr(thds)
            else If s2 = 'JO' then s3 := inttostr(thds+jobs)
            else If s2 = 'NO' then s3 := CurrToStrF( CntOutboxN, ffNumber, 0 )
            else If s2 = 'MO' then s3 := CurrToStrF( CntOutboxM, ffNumber, 0 )
            else If s2 = 'NE' then s3 := CurrToStrF( CntNewsErr, ffNumber, 0 )
            else If s2 = 'NI' then s3 := CurrToStrF( CntArtNew, ffNumber, 0 )
            else If s2 = 'NL' then s3 := CurrToStrF( CntArtLoad, ffNumber, 0 )
            else If s2 = 'NH' then s3 := CurrToStrF( CntArtHist, ffNumber, 0 )
            else If s2 = 'NK' then s3 := CurrToStrF( CntArtKill, ffNumber, 0 )
            else If s2 = 'NM' then s3 := CurrToStrF( CntArtByMid,ffNumber, 0 ) //HSR //GetByMid-Counter
            else If s2 = 'MI' then s3 := CurrToStrF( CntMailNew, ffNumber, 0 )
            else If s2 = 'BY' then s3 := CurrToStrF( CntByteIn+CntByteOut, ffNumber, 0 )
            else If s2 = 'KB' then s3 := CurrToStrF( (CntByteIn+CntByteOut) div 1024, ffNumber, 0 )
            else If (s2[1]='X') and (s2[2] IN['0'..'9']) then s3 := CurrToStrF( CntCustomValues[Ord(s2[2])-Ord('0')], ffNumber, 0 )
            else If s2 = 'M:' then begin
               l := 0;
               For j := 0 to CheckMailboxes.Count-1 do begin
                  If LowerCase(Copy(Result, i+3, Length(CheckMailboxes[j])+1))
                     = LowerCase(CheckMailboxes[j])+'%'
                  then begin
                     s3 := IntToStr(LongInt(CheckMailboxes.Objects[j]));
                     l := 3 + Length(CheckMailboxes[j]) + 1;
                     Break
                  end
               end
            end
            else l := 0;
            If l > 0 then begin
               Delete (Result, i, l);
               Insert (s3, Result, i);
               Inc(i, Length(s3))
            end
         end;
         Inc(i)
      end;
   end;


var  s, ss, st: String; i, z: Integer; LogIdType: Pointer;
     H: THandle; b, b2: boolean; r: TSearchRec;
begin
   try
      // Count Mails
      With CheckMailboxes do begin
         For i:=0 to Count-1 do begin
            z := 0;
            If FindFirst( PATH_MAILS + Strings[i] + '\'+'*.'+
                CfgIni.ReadString( 'Setup', 'news.ext.out', 'msg' ),
                faAnyfile-faDirectory-faVolumeID, r) = 0
            then begin
               Repeat Inc(z) Until FindNext(r)<>0;
               FindClose(r)
            end;
            Objects[i] := Pointer(z)
         end
      end;

      // get current status-infos
      if Assigned(NewsJobs) then jobs:=NewsJobs.JobList.Count else jobs:=0;
      EnterCriticalSection( CS_COUNTER );
      if CntOutBoxChk>0 then CountOutboxes;
      thds := CntActiveTasks;
      ss := ' '+ExpandInfo (BottomlineFormat);
      st := ' '+ExpandInfo (HintFormat);
      LeaveCriticalSection( CS_COUNTER );

      // update status-msg.
      if ss<>OldStatusText then begin StatusBar.Panels[0].Text:=ss; OldStatusText:=ss end;
      if st<>OldTrayHint then begin
         OldTrayHint := st;
         StrPLCopy( @HamsterTrayIcon.szTip, st, 63 );
         if HamsterTrayIcon.hIcon<>0 then Shell_NotifyIcon( NIM_MODIFY, @HamsterTrayIcon );
      end;

      // update log- and threads-display
      LogFile.Enter;
      try
         if LogFile.ViewCount > 0 then begin
            lstLog.Items.BeginUpdate; // Lisbox "Logs"
            lstLogErrors.Items.BeginUpdate; // Listbox "Errors & Warnings"
            while lstLog.Items.Count>=LogFile.ViewMax do lstLog.Items.Delete(0);
            for i:=0 to LogFile.ViewCount-1 do begin
               LogIdType := Pointer( LogFile.ViewType[i] ); // LOGID_xxx
               lstLog.Items.AddObject( LogFile.ViewLine[i], LogIdType );
               If (LongWord(LogIdType) and (LOGID_WARN or LOGID_ERROR))<>0 then begin
                  With lstLogErrors do
                     ItemIndex := Items.AddObject( LogFile.ViewLine[i], LogIdType );
                  If (LongWord(LogIdType) and LOGID_WARN) > 0 then begin
                     Inc(CntWarnings) {; If (CntWarnings = 1) and (CntErrors = 0) then pg.RePaint}
                  end else begin
                     Inc(CntErrors) {; If CntErrors = 1 then pg.RePaint}
                  end;
                  s := '';
                  If CntErrors > 0 then begin
                     s := s + InttoStr(CntErrors)+' ';
                     If CntErrors = 1
                        then s := s + Tr('Error', 'Error')
                        else s := s + Tr('Errors', 'Errors')
                  end;
                  If CntWarnings > 0 then begin
                     If s > '' then s := s + ' '+Tr('and', 'and')+' ';
                     s := s + InttoStr(CntWarnings)+' ';
                     If CntWarnings = 1
                        then s := s + Tr('Warning', 'Warning')
                        else s := s + Tr('Warnings', 'Warnings')
                  end;
                  If s > '' then s := s + ' (' + Tr('Lines', 'Lines') + ')';
                  TabErrors.Caption := s;
               end
            end;
            LogFile.ViewClear;

            if chkLogAutoScroll.Checked then lstLog.ItemIndex:=lstLog.Items.Count-1;

            lstLogErrors.Items.EndUpdate;
            lstLog.Items.EndUpdate
         end;

         b := lstLogErrors.Items.Count > 0;
         If (Not B) and (pg.ActivePage = TabErrors) then pg.ActivePageIndex := LastPage;
         b2 := b and (Not TabErrors.TabVisible);
         TabErrors.TabVisible := b;
         If b2 and Def_AutoActivateErrorLog then pg.ActivePage := TabErrors;
      finally
         LogFile.Leave;
      end;

      // Threads
      if LogFile.TaskChanged then begin
         LogFile.Enter;
         with lstThd do try
            For i:=Items.Count-1 downto LogFile.TaskCount do
               Items.Delete(i);
            For i:=0 to Items.Count-1 do
               If Items[i] <> LogFile.TaskLine[i] then
                  Items[i] := LogFile.TaskLine[i];
            For i:=Items.Count to LogFile.TaskCount-1 do
               Items.Add( LogFile.TaskLine[i] );
         finally
            LogFile.Leave;
         end;
         lstThdClick (NIL)
      end;

      // adjust "color" of tray-icon
      H := GetTrayIconHandle;
      if OldTrayIconHandle <> H then begin
         HamsterTrayIcon.hIcon := H;
         if HamsterTrayIcon.hIcon<>0 then Shell_NotifyIcon( NIM_MODIFY, @HamsterTrayIcon );
         OldTrayIconHandle := H;
      end;

      if thds=0 then begin // only if nothing else is in progress
         if trunc(LastStats)<>trunc(Now) then begin // day changed
            LastStats := Now;
            If Not ArchivMode then begin
               // create statistics once per day
               If CfgIni.ReadBool( 'Setup', 'CreateStatistics.daily', true) then begin
                  TThreadStatistics.Create.resume
               end;
               // Purge old news-filter entries
               If CfgIni.ReadBool ('Setup', 'PurgeNewsScorefile.daily', true) then begin
                  With TFiltersNews.Create( PATH_BASE + CFGFILE_SCORES ) do try
                     Purge
                  finally Free end
               end;
               // Purge old mail-filter entries
               If CfgIni.ReadBool ('Setup', 'PurgeMailScorefile.daily', true) then begin
                  With TFiltersMail.Create( PATH_BASE + CFGFILE_MFILTER ) do try
                     Purge
                  finally Free end
               end;
               // Purge mails/postings from trash
               EmptyTrash
            end
         end;
      end;

      ShowNewsJobs;

      mnuResetErrorsOnly.enabled := CntWarnings + CntErrors > 0

   except
   end;
end;

procedure THamsterMainWindow.ShowNewsJobs;
Var L: TNewsJobDefs; s: String; i, ID: Integer; IDFound: Boolean;
begin
   With lbJobs do try
      NewsJobs.Joblist.GetList (L);
      If High(L) < Low(L) then begin
         Clear; Exit
      end;
      i := ItemIndex;
      If i < 0 then ID := 0 else ID := Integer(Items.Objects[i]);
      IDFound := false;
      For i := Items.Count to High(L) do Items.Add('');
      For i := High(L)+1  to Items.Count-1 do Items.Delete(High(L)+1);
      For i := Low(L) to High(L) do begin
         s := L[i].Server + ': ' + JobInfo(L[i].Typ, L[i].Par) + ', Priority: '+IntToStr(L[i].Prio);
         If Items[i]<>s then Items[i] := s;
         If Integer(Items.Objects[i])<>L[i].ID then Items.Objects[i] := Pointer(L[i].ID);
         If Integer(Items.Objects[i]) = ID then begin
            ItemIndex := i; IDFound := true
         end
      end;
      If (Not IDFound) and (ItemIndex>=0) then ItemIndex := -1
   finally
      TestJobButtons
   end
end;

Procedure THamsterMainWindow.TestJobButtons;
Var b: Boolean; Anz: Integer;
begin
   Anz := lbJobs.Items.Count;
   tsJobs.Caption := TrF('Joblist.Count', 'Newsjobs-Queue: %s', IntToStr(Anz));
   butKillAllJobs.Enabled := Anz > 0;
   b := lbJobs.ItemIndex >= 0;
   butKillJob.Enabled := b;
   butJobPrioMin.Enabled := b;
   butJobPrioMax.Enabled := b
end;

{----------------------------------------------------------------- Menus -----}

procedure THamsterMainWindow.mnuFileExitClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   Close;
end;

procedure THamsterMainWindow.mnuHelpAboutClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   if not Assigned(DlgAbout) then Application.CreateForm(TDlgAbout, DlgAbout);
   inc( ModalActive );
   DlgAbout.ShowModal;
   dec( ModalActive );
end;

{JW} {lSSL}
procedure THamsterMainWindow.mnuLocalNntpClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   if mnuLocalNntp.Checked then LocalServerActivate( stNNTP, saSTOP  )
                           else LocalServerActivate( stNNTP, saSTART );
   mnuLocalNntp.Checked := LocalServerIsActive( stNNTP );
end;

procedure THamsterMainWindow.mnuLocalPop3Click(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   if mnuLocalPop3.Checked then LocalServerActivate( stPOP3, saSTOP  )
                           else LocalServerActivate( stPOP3, saSTART );
   mnuLocalPop3.Checked := LocalServerIsActive( stPOP3 );
end;


procedure THamsterMainWindow.mnuLocalSmtpClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   if mnuLocalSmtp.Checked then LocalServerActivate( stSMTP, saSTOP  )
                           else LocalServerActivate( stSMTP, saSTART );
   mnuLocalSmtp.Checked := LocalServerIsActive( stSMTP );
end;

procedure THamsterMainWindow.mnuOnlineStopClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   Commands.StopAllTasks
end;

// Wolfgang Jaeth
Function THamsterMainWindow.StartScript( ScriptFile, ParameterList: String; WaitForEnd: boolean ): Integer;
begin
   if (ScriptFile = '-?') then begin
      inc( ModalActive );
      Application.MessageBox ('hamster [ [/w] [/svc] [/ro] [/rw] scriptname.hsc [scriptparameter ...] ]' +
         CR + CR +'  /w  =  wait for end' + CR +'  /svc  =  run as server'
         + CR +'  /ro  =  readonly / CD-mode' + CR +'  /rw  =  read/write = standard mode',
         PChar(TrGl(kMessages, 'Titel.CommandLinePars', 'Hamster''s commandline-parameters:')),
         MB_ICONINFORMATION);
      dec( ModalActive );
      Result := 0;
   end else begin
      Result := StartNewScript (ScriptFile, ParameterList, WaitForEnd)
   end
end;

procedure THamsterMainWindow.mnuMyScriptClick(Sender: TObject);
var  ScriptFile: String; MI: TMenuItem;
begin
   If Not Allowed(Sender) then Exit;
   if not(Sender is TMenuItem) then exit;
   MI := Sender as TMenuItem;
   Case MI.Tag of
      1: begin // run
            ScriptFile := MI.Caption + '.hsc';
            While Assigned(Mi) and Assigned(Mi.Parent) and (Mi.Parent.Tag < 100) do begin
               Mi := Mi.Parent;
               ScriptFile := MI.Caption + '\' + Scriptfile
            end;
            AllShutdownReq := False;
            Timer1Timer(Self);
            StartScript( ScriptFile, '', false);
         end;
      3: begin // stop
            {JW} {critical event}
            EnterCriticalSection(CS_Event);
            SetEvent( EVT_STOPSCRIPT );
            LeaveCriticalSection(CS_Event);
            {JW}
         end;
   end;
end;

procedure THamsterMainWindow.mnuMyRASDialClick(Sender: TObject);
Var s: String;
begin
   If Not (Sender is TMenuItem) then exit;
   s := (Sender as TMenuItem).caption;
   With TThreadRASDial.Create (s) do resume;
end;

procedure THamsterMainWindow.CloseConnection1Click(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   RasDialer.Hangup
end;


procedure THamsterMainWindow.mnuFileRebuildGlobalListsClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   AllShutdownReq := False;
   Timer1Timer(Self);
   IncCounter(CanCloseNow,1);
   Log( LOGID_SYSTEM, TrGl(kLog, 'System.RebuildGlobalLists.Start',
       'Start rebuilding of global lists ...') );
   TThreadRebuildGlobalLists.Create.resume;
   IncCounter(CanCloseNow,-1);
end;

procedure THamsterMainWindow.mnuFilePurgeClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   {PW} {Ask-Before-Purge}
   if MessageBox( Handle,
      PChar(Tr('PurgeGroups.AskStart',
      'Purging groups may take some time.^MStart it now?')),
      PChar(Tr('PurgeGroups.Caption', 'Purge groups'))
      , MB_ICONQUESTION or MB_YESNO ) = IDYES
   then begin
      PurgeNow;
      Timer1Timer(Self)
   end
end;

procedure THamsterMainWindow.mnuFileRebuildClick(Sender: TObject);
Var thds: Integer;
begin
   If Not Allowed(Sender) then Exit;
   AllShutdownReq := False;
   Timer1.Enabled := True;

   EnterCriticalSection( CS_COUNTER );
   thds := CntActiveTasks;
   LeaveCriticalSection( CS_COUNTER );
   if thds>0 then exit;

   if MessageBox( Handle,
      PChar(Tr('RebuildHistory.AskStart',
      'Rebuilding of history may take some time.^MStart it now?')),
      PChar(Tr('RebuildHistory.Caption', 'Rebuild history'))
      , MB_ICONQUESTION or MB_YESNO ) <> IDYES then exit;

   InterlockedIncrement( CriticalState );
   Enabled := False;
   With TThreadHistoryRebuild.Create do try
      FreeOnTerminate := False;
      Resume;
      while WaitForSingleObject(Handle,1000)=WAIT_TIMEOUT do begin
         Application.ProcessMessages;
      end
   finally
      Free
   end;
   Enabled := True;
   InterlockedDecrement( CriticalState );
end;


procedure THamsterMainWindow.mnuConfigHamsterClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   inc( ModalActive );
   inc( ConfigWndActive );
   With TfrmConfigSettings.Create(nil) do try
      If ShowModal = mrOK then begin
         SetCurrentDirectory( PChar(PATH_BASE) );
         Screen.Cursor := crHourGlass;
         ConfigLoad (ctGeneral);
         Timer1.Interval := LOGFILEREFRESH * 100
      end;
      If LanguageChanged then begin
         Self.LoadLanguageAgain;
         SetCaption
      end;
      VisualSettings;
      OnRefreshMenuItems( Self );
   finally
      free;
      Screen.Cursor := crDefault;
      dec( ModalActive );
      dec( ConfigWndActive )
   end
end;

procedure THamsterMainWindow.mnuConfigNewsClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   if not (CriticalState>0) then begin
      inc( ModalActive );
      inc( ConfigWndActive );
      With TfrmConfigNews.Create(nil) do try
         If (ShowModal = mrOk) or Changes then begin
            Screen.Cursor := crHourGlass;
            ConfigLoad (ctNews);
            OnRefreshMenuItems( Self )
         end;
      finally
         free; Screen.Cursor := crDefault;
         dec( ModalActive );
         dec( ConfigWndActive )
      end
   end else begin
      Log( LOGID_WARN, TrGl(kLog, 'System.Purge.NoReady', 'Hamster is not ready for this action - purging database') )
   end
end;

procedure THamsterMainWindow.mnuConfigMailClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   if not (CriticalState>0) then begin
      inc( ModalActive );
      inc( ConfigWndActive );
      With TfrmConfigMail.Create(nil) do try
         If (ShowModal = mrOk) or Changes then begin
            Screen.Cursor := crHourGlass;
            ConfigLoad (ctMail);
            OnRefreshMenuItems( Self )
         end;
      finally
         free;
         Screen.Cursor := crDefault;
         dec( ModalActive );
         dec( ConfigWndActive )
      end;
   end else Log( LOGID_WARN, TrGl(kLog, 'System.Purge.NoReady', 'Hamster is not ready for this action - purging database') );
end;

procedure THamsterMainWindow.mnuConfigUserAndPWClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   inc( ModalActive );
   inc( ConfigWndActive );
   try
      If DialogLocalUserAndPWs then begin
         Screen.Cursor := crHourGlass;
         ConfigLoad (ctUserPW);
         OnRefreshMenuItems (Self)
      end
   finally
      Screen.Cursor := crDefault;
      dec( ModalActive );
      dec( ConfigWndActive )
   end
end;

{JW-Chg} {Modal}
procedure THamsterMainWindow.mnuFileKillsClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   Commands.DialogKillfileLog(1)
end;
{/JW}                   

procedure THamsterMainWindow.mnuOnlinePullClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   if not (CriticalState>0) then begin
      StartTransfer( '', TransferAll ); // all servers
   end else begin
      Log( LOGID_WARN, TrGl(kLog, 'System.Purge.NoReady', 'Hamster is not ready for this action - purging database') )
   end
end;

procedure THamsterMainWindow.mnuOnline1Click(Sender: TObject);
var  MenuNo: Integer;
     s     : String;
begin
   if not (CriticalState>0) then begin
      MenuNo := (Sender as TMenuItem).Tag;
      s := CfgIni.ReadString( 'Online-Menu', 'Server'+inttostr(MenuNo), '' );
      if s='' then exit;
      StartTransfer( s, TransferAll );
   end else begin
      Log( LOGID_WARN, TrGl(kLog, 'System.Purge.NoReady', 'Hamster is not ready for this action - purging database') )
   end
end;

procedure THamsterMainWindow.mnuMyPullClick(Sender: TObject);
begin
   if not(Sender is TMenuItem) then exit;
   if not (CriticalState>0)
      then StartTransfer( (Sender as TMenuItem).Caption, TransferAll )
      else Log( LOGID_WARN, TrGl(kLog, 'System.Purge.NoReady', 'Hamster is not ready for this action - purging database') );
end;

procedure THamsterMainWindow.StartTransfer( ServerList: String; Const Typ: TTransfers );
Var s, NewsServer, POP3Server, SMTPServer: String;
    bNews, bMail, bFound: Boolean;
    i: Integer;
begin
   AllShutdownReq := False;
   IncCounter(CanCloseNow,1);
   Timer1Timer(Self);
   NewsServer := '';
   POP3Server  := '';
   SMTPServer := '';
   If Serverlist > '' then begin
      With TStringList.Create do try
         bMail := false;
         bNews := false;
         Text := SplitServerList (ServerList);
         For i := 0 to Count-1 do begin
            s := Strings[i];
            bFound := false;
            If CfgHamster.ServerIndexof[s] >= 0 then begin
               Newsserver := Newsserver + ';' + s;
               bNews := true; bFound := true
            end;
            If CfgHamster.POP3ServerIndexOf [ s ] >= 0 then begin
               POP3Server := POP3Server + ';' + s;
               bMail := true; bFound := true
            end;
            If CfgHamster.SMTPServerIndexOf [ s ] >= 0 then begin
               SMTPServer := SMTPServer + ';' + s;
               bMail := true; bFound := true
            end;
            If Not bFound then Log ( LOGID_WARN, TrGlF(kLog, 'UnknownServerForTransfer', 'No valid server: "%s"!', s))
         end
      finally
         free
      end
   end else begin
      bMail := true;
      bNews := true
   end;

   If bMail and ((trPOP3 IN Typ) or (trSMTP IN Typ)) then begin
      s := '';
      If trPOP3 IN Typ then s := s + POP3Server;
      If trSMTP IN Typ then s := s + SMTPServer;
      If s > '' then s := s + ';';
      If (Serverlist = '') or (s > '') then begin
         if (CfgHamster.Pop3ServerCount>0) or (CfgHamster.SmtpServerCount>0) then begin
            Log( LOGID_SYSTEM, TrGl(kLog, 'System.MailThread.Starting', 'Starting "mail"-thread ...') );
            With TThreadPop3AndSmtp.Create( s, 0 ) do resume;
            Sleep( 1000 );
         end
      end
   end;

   If bNews and (trNNTP IN Typ) then begin
      If NewsServer > '' then NewsServer := NewsServer + ';';
      if CfgHamster.ServerCount>0 then begin
         Log( LOGID_SYSTEM, TrGl(kLog, 'System.NewsJobThreads.Starting', 'Starting "newsjob"-threads ...') );
         NewsJobs.AddPostDef  ( NewsServer );
         NewsJobs.AddPullDef  ( NewsServer );
         NewsJobs.StartThreads( NewsServer );
      end
   end;

   Log( LOGID_SYSTEM, TrGl(kLog, 'System.AllThreads.started', 'All threads started.') );
   IncCounter(CanCloseNow,-1);
end;

procedure THamsterMainWindow.mnuHelpContentsClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   Application.HelpCommand( HELP_CONTENTS, 0 );
end;

procedure THamsterMainWindow.mnuHelpSysInfosClick(Sender: TObject);
var  WSockInfo, s, h, SysDir, WinDir: String;
     p: array[0..256] of Char;
     dw: DWord;
begin
   If Not Allowed(Sender) then Exit;
   s := 'Hamster: ' + GetMyStringFileInfo('ProductName','Hamster')
                    + ' ' + GetMyVersionInfo(true) + #13#10;
   s := s + #13#10;
   s := s + Tr('DlgInfo.Platform', 'Platform')+': ' + GetWinVerInfo + #13#10;
   s := s + #13#10;

   GetSystemDirectory ( p, 256 ); SysDir:=String(p)+'\';
   GetWindowsDirectory( p, 256 ); WinDir:=String(p)+'\';
   h := 'wsock32.dll';
   s := s + 'File ' + h + ': ' + GetFileInfo( SysDir + h ) + #13#10;
   h := 'ws2_32.dll ';
   s := s + 'File ' + h + ': ' + GetFileInfo( SysDir + h ) + #13#10;
   h := 'rasapi32.dll';
   s := s + 'File ' + h + ': ' + GetFileInfo( SysDir + h ) + #13#10;

   WSockInfo := s;

   s := s + #13#10;
   dw := 256;
   if GetComputerName(p,dw) then h:=String(p) else h:=Tr('DlgInfo.None', '(none)');
   s := s + Tr('DlgInfo.ComputerName', 'Computer-Name')+': ' + h + #13#10;
   dw := 256;
   if GetUserName(p,dw) then h:=String(p) else h:=Tr('DlgInfo.None', '(none)');
   s := s + Tr('DlgInfo.UserName', 'User-Name')+': ' + h
   + #13#10
   + '______________________________________'
   + #13#10
   + #13#10;
   s := s + Tr('DlgInfo.CopyToClipboard.Question', 'Copy Info to clipboard?');
   inc( ModalActive );
   If Application.MessageBox( PChar(s), PChar(Tr('DlgInfo.Caption', 'Hamster''s System-Information')),
       MB_ICONQUESTION + MB_YESNO + MB_DEFBUTTON1) = IDYES
   then begin
      Clipboard.Clear;
      Clipboard.AsText := WSockInfo
   end;
   dec( ModalActive );
end;

procedure THamsterMainWindow.chkLogAutoScrollClick(Sender: TObject);
begin
   LogFile.Enter; 
   try
      if chkLogAutoScroll.Checked then lstLog.ItemIndex:=lstLog.Items.Count-1;
   finally
      LogFile.Leave;
   end;
end;

procedure THamsterMainWindow.mnuResetCountersAndLogClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   ResetCounter(TMenuItem(Sender).Tag)
end;

procedure THamsterMainWindow.ResetCounter(Const Nr: Integer);
begin
   If (Nr = 0) or (Nr = 1) then begin
      EnterCriticalSection( CS_COUNTER );
      CntArtNew  := 0;
      CntArtLoad := 0;
      CntArtHist := 0;
      CntArtKill := 0;
      CntArtByMid:= 0; //HSR //GetByMid-Counter
      CntMailNew := 0;
      CntByteIn  := 0;
      CntByteOut := 0;
      inc( CntOutBoxChk );
      LeaveCriticalSection( CS_COUNTER )
   end;
   If (Nr = 0) or (Nr = 2) then begin
      LogFile.Enter;
      try
         lstLog.Clear;
         lstLogErrors.Clear;
         CntWarnings := 0; CntErrors := 0;
      finally
         LogFile.Leave;
      end;
   end;
   If Nr = 3 then begin
      LogFile.Enter;
      try
         lstLogErrors.Clear;
         CntWarnings := 0; CntErrors := 0;
      finally
         LogFile.Leave;
      end;
   end
end;

procedure THamsterMainWindow.mnuEditNewsScoreFileClick(Sender: TObject);
Const Default = '[*]'+#13#10#13#10;
begin
   If Not Allowed(Sender) then Exit;
   If Not FileExists2(PATH_BASE + CFGFILE_SCORES) then begin
      With TFileStream.Create(PATH_BASE + CFGFILE_SCORES, fmCreate) do try
         Write ( default[1], Length(default) )
      finally Free end
   end;
   EditFile(PATH_BASE + CFGFILE_SCORES)
end;

procedure THamsterMainWindow.mnuEditMailScoreFileClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   EditFile(PATH_BASE + CFGFILE_MFILTER)
end;

Procedure THamsterMainWindow.ExtractThreadID (l: TListbox; Const Org: String;
   Var SingleThreadID, SingleThreadBegin: String; Const OnlyID: Boolean);
Var p1, p2: Integer; s: String;
begin
   SingleThreadID := '';
   SingleThreadBegin := '';
   If l = lstThd then begin
      p1 := Pos('=', Org);
      If p1 > 0 then begin
         s := Copy(Org, 1, p1-1);
         p1 := pos(' ', s);
         If p1>0 then Delete(s, 1, p1);
         If Copy(s, Length(s), 1) = ')' then Delete(s, Length(s), 1);
         If OnlyID
            then SingleThreadID := s
            else SingleThreadID := '{'+s+'}'
      end
   end else begin
      p1 := Pos('{', Org);
      p2 := Pos('}', Org);
      If (p1 > 0) and (p2 > p1) then begin
         SingleThreadBegin := Org;
         If OnlyID
            then SingleThreadID := Copy(Org, p1+1, p2-p1+1-2)
            else SingleThreadID := Copy(Org, p1, p2-p1+1);
      end
   end
end;

procedure THamsterMainWindow.lstLogDblClick(Sender: TObject);
Var l: TListbox; s: String;
begin
   LogFile.Enter;
   try
      If pg.ActivePage = PageThreads then l := lstThd
      else If pg.ActivePage = PageLog then l := lstLog
      else If pg.ActivePage = TabErrors then l := lstLogErrors
      else exit;
      If l.ItemIndex < 0 then exit;
      s := l.Items[l.ItemIndex];
   finally
      LogFile.Leave;
   end;
   ExtractThreadID (l, s, SingleThreadID, SingleThreadBegin, false);
   If SingleThreadID > '' then begin
      butUpdateThreadLogClick (nil);
      If pg.ActivePage = TabErrors then LastPageWasErrors := true;
      TabThread.TabVisible := true;
      pg.ActivePage := TabThread
   end
end;

procedure THamsterMainWindow.butUpdateThreadLogClick(Sender: TObject);
Var i: Integer;
begin
   LogFile.Enter;
   try
      lstThread.Clear;
      For i:=0 to lstLog.Items.Count-1 do If Pos(SingleThreadID, lstLog.Items[i]) > 0 then begin
         lstThread.Items.AddObject (lstLog.Items[i], lstLog.Items.Objects[i]);
         If lstLog.Items[i] = SingleThreadBegin then lstThread.ItemIndex := lstThread.Items.Count-1
      end;
   finally
      LogFile.Leave;
   end;
end;

procedure THamsterMainWindow.butCloseLogThreadClick(Sender: TObject);
begin

   If LastPageWasErrors and TabErrors.TabVisible
      then Pg.ActivePage := TabErrors
      else Pg.ActivePageIndex := LastPage;
   TabThread.TabVisible := false

end;

function THamsterMainWindow.ChangeLanguageFor(c: TComponent): boolean;
begin
   Result := (c <> mnuOnline1) and (c <> mnuOnline2) and (c <> mnuOnline3) and
             (c <> mnuOnline4) and (c <> mnuOnline5) and (c <> mnuOnline6) and
             (c <> mnuOnline7) and (c <> mnuOnline8) and (c <> mnuOnline9)
end;

procedure THamsterMainWindow.AppActivate(Sender: TObject);
begin
   CountOutboxes
end;

procedure THamsterMainWindow.mnuFileClick(Sender: TObject);
Var b: boolean;
begin
   b := CntActiveTasks = 0;
   mnuFileRebuildGlobalLists.enabled := b;
   mnuFilePurge.enabled := b;
   mnuFileRebuild.enabled := b;
end;

procedure THamsterMainWindow.pgDrawTab(
  Control: TCustomTabControl; TabIndex: Integer; const Rect: TRect;
  Active: Boolean);
Var l, r: Integer; s: String;
begin
   With Control.Canvas do begin
      If TabErrors.TabVisible and (TabErrors.TabIndex = TabIndex) then begin
         If ColoredTabs then begin
            If CntErrors > 0 then begin
               Brush.Color := TabColorErrorBrush; Font.Color := TabColorErrorText
            end else If CntWarnings > 0 then begin
               Brush.Color := TabColorWarningBrush; Font.Color := TabColorWarningText
            end
         end                   // ###########################
      end;
      FillRect(Rect);
      // Find page to tabindex
      With TStringlist.Create do try
         With PageThreads do If TabVisible then Add(Caption);
         With tsJobs do If TabVisible then Add(Caption);
         With PageLog do If TabVisible then Add(Caption);
         With TabErrors do If TabVisible then Add(Caption);
         With TabThread do If TabVisible then Add(Caption);
         If TabIndex > Count-1 then s := '???' else s := Strings[TabIndex]
      finally
         free
      end;
      {For i := 0 to pg.PageCount-1 do begin
         If pg.Pages[i].TabVisible then Inc(l);
         If l = TabIndex then begin
            s := IntToStr(l)+'/'+IntToStr(i)+'/'+pg.Pages[l].Caption;
            break
         end;
      end;
      {If (l>2) and (Not TabErrors.TabVisible) then Inc(l);
      s := pg.Pages[l].Caption;}
      For l := Length(s)-1 downto 1 do If (s[l]='&') and (s[l+1]='&')
         then System.Delete (s, l+1, 1);
      l := Rect.left + ((Rect.right - Rect.left - TextWidth(s)) div 2);
      r := Rect.top + ((Rect.bottom - Rect.top - TextHeight('Gg')) div 2);
      TextOut ( l, r, s )
   end
end;

Var ActiveLog: TListbox;

procedure THamsterMainWindow.popLogsPopup(Sender: TObject);
begin
   Case pg.ActivePageIndex of
      0: ActiveLog := lstThd;
      1: ActiveLog := lbJobs;
      2: ActiveLog := lstLog;
      3: ActiveLog := lstLogErrors;
      4: ActiveLog := lstThread;
      else abort
   end;
   pmShowThread.visible := (ActiveLog = lstThd) and (ActiveLog.ItemIndex >= 0);
   pmCopyLineToClipboard.enabled := ActiveLog.ItemIndex >= 0;
   pmCopyAllToClipboard.enabled := ActiveLog.Items.Count > 0;
   pmClearLogs.visible := (ActiveLog <> lstThread) and (lstLog.Items.Count > 0)
end;

procedure THamsterMainWindow.pmShowThreadClick(Sender: TObject);
begin
   ActiveLog.OnDblClick (ActiveLog)
end;

Procedure THamsterMainWindow.LogToClipboard(Lb: TListbox; Const ab, bis: Integer);
var i, ID: Integer; s, Dest: String;
begin
   Dest := '';
   For i := ab to bis do begin
      s  := lb.Items[i];
      ID := Integer(lb.Items.Objects[i]);
      s := Copy(s, 1, 20) + LogIdToMarker(ID) + ' ' + Copy(s, 21, Length(s));
      Dest := Dest + s + #13#10
   end;
   Clipboard.AsText := Dest
end;

procedure THamsterMainWindow.pmCopyLineToClipboardClick(Sender: TObject);
begin
   Logfile.enter;
   try
      If ActiveLog.Items.Count = 0 then exit;
      LogToClipboard(ActiveLog, ActiveLog.ItemIndex, ActiveLog.ItemIndex)
   finally
      Logfile.Leave
   end
end;
procedure THamsterMainWindow.pmCopyAllToClipboardClick(Sender: TObject);
begin
   Logfile.enter;
   try
      LogToClipboard(ActiveLog, 0, ActiveLog.Items.Count-1)
   finally
      Logfile.Leave
   end
end;
procedure THamsterMainWindow.pmClearLogsClick(Sender: TObject);
begin
   mnuResetCountersAndLogClick (mnuResetLogOnly)
end;

procedure THamsterMainWindow.pgChange(Sender: TObject);
begin
   If pg.ActivePageIndex IN[0, 2] then LastPage := pg.ActivePageIndex; // #########
   LastPageWasErrors := pg.ActivePage = TabErrors
end;

procedure THamsterMainWindow.butCloseErrorsAndWarningsClick(
  Sender: TObject);
begin
   Pg.ActivePageIndex := LastPage;
   lstLogErrors.Clear;
   CntWarnings := 0;
   CntErrors := 0;
   TabErrors.TabVisible := false;
   LastPageWasErrors := false
end;

function THamsterMainWindow.MsgHook(var Msg: TMessage): Boolean;
begin
   if RunAsService then begin
      // Ignore WM_ENDSESSION+ENDSESSION_LOGOFF (i.e. don't terminate
      // application) if user just logs off. This allows Hamster.exe
      // to be run as a service with appropriate tools like "SrvAny".
      Result := (Msg.Msg=WM_ENDSESSION) and (DWORD(Msg.LParam)=ENDSESSION_LOGOFF);
   end else begin
      Result := False;
   end;
   if Msg.Msg = WMTaskbarCreate then begin /// JHS ///
      HamsterTrayIcon.hIcon := 0; /// JHS ///
      PostMessage( hWndMainWindow, WM_HAMSTER, HAM_MSG_SHOWICON, 1 ); /// JHS ///
   end; /// JHS ///
end;

procedure THamsterMainWindow.lstThdClick(Sender: TObject);
begin
   butThreadsToThread.Enabled := lstThd.ItemIndex >= 0;
   butStopThread.Enabled := lstThd.ItemIndex >= 1
end;

procedure THamsterMainWindow.StatusBarDrawPanel(StatusBar: TStatusBar; //JK //Statusbar
  Panel: TStatusPanel; const Rect: TRect);
Var textheight:Integer;
begin
  with StatusBar do begin
    // windows.GetClientRect(HANDLE,crect);
    textheight:=Canvas.TextHeight('AgW');
    Canvas.TextRect(Rect,2,(Rect.Bottom+1-textheight)div 2,Panel.Text);
    // Canvas.TextOut(2,(crect.Bottom+1-textheight)div 2,SimpleText);
  end;
end;

procedure THamsterMainWindow.mnuManageScriptsAndModulesClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   DialogManageScripts
end;

// Shell

procedure THamsterMainWindow.txtShellKeyPress(Sender: TObject; var Key: Char);
Var s, s2: String; sl: TStringList; p: Integer;
begin
   Case Key of
      ^m: begin
         Key := #0;
         s := txtShell.Text;
         If s = '' then Exit;
         txtShell.Text := '';
         pg.ActivePage := PageLog;
         sl := TStringList.Create;
         try
            sl.Add ('#!hs2');
            If FileExists2 ( PATH_HSM + CFGFILE_SHELLMOD )
               then sl.Add ('#!load hs2shell.hsm');
            s2 := s;
            Repeat
               p := Pos('', s2);
               If p > 0
                  then begin sl.Add (Copy(s2, 1, p-1)); Delete(s2, 1, p) end
                  else begin sl.Add (s2); s2 := '' end
            until s2 = '';
            sl.Add ('quit');
            StartScriptLines ( sl, false )
         finally
            sl.free
         end;
         With ShellHist do begin
            Add (s);
            While IndexOf (s) < Count-1 do Delete(IndexOf (s));
            While Count > MaxShellHistLines do Delete(0);
            HistPos := Count
         end
      end;
      '(': begin
         p := txtShell.SelStart;
         txtShell.SelText := '(  )';
         txtShell.SelStart := p+2;
         Key := #0
      end;
      '"': begin
         p := txtShell.SelStart;
         txtShell.SelText := '""';
         txtShell.SelStart := p+1;
         Key := #0
      end;
      ^T: begin txtShell.SelText := ''; Key := #0 end; 
   end
end;

procedure THamsterMainWindow.txtShellKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
   Case Key of
      {VK_ESCAPE: If Shift = [] then begin
         txtShell.Text := ''; Key := 0
      end;}
      VK_UP: If HistPos > 0 then begin
         If Shift = [] then Dec(HistPos)
         else If Shift = [ssCtrl] then HistPos := 0
         else exit;
         txtShell.Text := ShellHist[HistPos];
         Key := 0
      end;
      VK_DOWN: If HistPos < ShellHist.Count-1 then begin
         If Shift = [] then Inc(HistPos)
         else If Shift = [ssCtrl] then HistPos := ShellHist.Count-1
         else exit;
         txtShell.Text := ShellHist[HistPos];
         Key := 0
      end;
      VK_INSERT: If Shift = [] then begin
         butInsertShellcommand.Click;
         Key := 0
      end;
{      VK_F1: begin
         Application.HelpCommand( HELP_KEY, LongInt(PChar('hampurge')) );
         Key := 0
      end }
   end
end;

procedure THamsterMainWindow.FormResize(Sender: TObject);
Var x: Integer;
begin
   x := pg.Width - 15;
   With butUpdateThreadLog do Left := x - Width - 10 - butCloseLogThread.Width;
   With butCloseLogThread do Left := x - Width;
   With butCloseErrorsAndWarnings do Left := x - Width;
end;

procedure THamsterMainWindow.mnuConfigLocalServerClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   If DialogLocalServer then begin
      ConfigLoad (ctLocalServer);
      IPAccessCheck.reload;
      With mnuLocalNntp do begin
         If Checked then begin OnClick(NIL); OnClick(NIL) end
      end;
      With mnuLocalPOP3 do begin
         If Checked then begin OnClick(NIL); OnClick(NIL) end
      end;
      With mnuLocalSMTP do begin
         If Checked then begin OnClick(NIL); OnClick(NIL) end
      end;
      With mnuLocalReCo do begin
         If Checked then begin OnClick(NIL); OnClick(NIL) end
      end;
      With mnuLocalIMAP do begin
         If Checked then begin OnClick(NIL); OnClick(NIL) end
      end;
   end
end;

procedure THamsterMainWindow.butKillJobClick(Sender: TObject);
Var i, ij, p: Integer;
begin
   If Sender = butKillAllJobs then begin
      NewsJobs.JobList.Clear
   end else begin
      i := lbJobs.ItemIndex;
      try p := Longint(lbJobs.Items.Objects[i]) except p := 0 end;
      If p > 0 then begin
         ij := NewsJobs.JobList.JobIndexID( p );
         If Sender = butKillJob then begin
            NewsJobs.JobList.Delete(ij)
         end else begin
             If Sender = butJobPrioMin then begin
                NewsJobs.JobList.SetPriority(ij, 0)
             end else
             If Sender = butJobPrioMax then begin
                NewsJobs.JobList.SetPriority(ij, JOBPRIO_SRVINFOS)
             end
         end
      end
   end;
   TestJobButtons
end;

procedure THamsterMainWindow.lbJobsClick(Sender: TObject);
begin
   TestJobButtons
end;

procedure THamsterMainWindow.butInsertShellcommandClick(Sender: TObject);
begin
   InsertCommand.PopUp
end;

procedure THamsterMainWindow.mnuOpenDirsClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   DialogEditDir
end;

procedure THamsterMainWindow.mnuLocalReCoClick(
  Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   if mnuLocalReCo.Checked then LocalServerActivate( stRECO, saSTOP  )
                           else LocalServerActivate( stRECO, saSTART );
   mnuLocalReCo.Checked := LocalServerIsActive( stRECO );
end;

procedure THamsterMainWindow.WMNotifyGUI(var Message: TMessage);
begin
   try
      case Message.WParam of
         GUI_MSG_SERVERSTATE_CHANGED: begin
            mnuLocalNntp.Checked := LocalServerIsActive( stNNTP );
            mnuLocalPop3.Checked := LocalServerIsActive( stPOP3 );
            mnuLocalSmtp.Checked := LocalServerIsActive( stSMTP );
            mnuLocalIMAP.Checked := LocalServerIsActive( stIMAP ); //IMAP
            mnuLocalReCo.Checked := LocalServerIsActive( stRECO );
         end;
         GUI_MSG_RELOAD_SCRIPTS: begin
            UpdateScriptMenu_Scripts
         end;
      end;

   except
      on E: Exception do
         Log( LOGID_ERROR, 'Msg.WMNotifyGUI.Exception: ' + E.Message );
   end;
end;

procedure THamsterMainWindow.ExecJobIsDone(Sender: TObject);
begin
   JobIsDone := true
end;

procedure THamsterMainWindow.mnuReloadConfigClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   ConfigLoad (ctAll);
   OnRefreshMenuItems( Self );
   With TFiltersNews.Create( PATH_BASE + CFGFILE_SCORES ) do try Test finally Free end;
   With TFiltersMail.Create( PATH_BASE + CFGFILE_MFILTER ) do try Test finally Free end;
end;

procedure THamsterMainWindow.mnuEditHamsterIniClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   EditFile(PATH_BASE + 'hamster.ini')
end;

procedure THamsterMainWindow.lstAnyLogMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
Var P: TPoint; idx: Integer; s: String;
begin
   If Not LogsShowHints then Exit;
   If Sender is TListbox then begin
      With Sender as TListbox do begin
         P.x := x;
         P.y := y;
         idx := ItemAtPos (P, true);
         s := '';
         If idx >= 0 then try s := Items[idx] except end;
         If s <> Hint then begin
            Hint := s;
            Application.CancelHint;
            Application.ActivateHint (P)
         end
      end
   end
end;

procedure THamsterMainWindow.StatusBarDblClick(Sender: TObject);
begin
   If Not Actions.Exec ( atStatusDblClick, '' ) then DialogEditDir
end;

procedure THamsterMainWindow.StatusBarClick(Sender: TObject);
begin
   Actions.Exec ( atStatusClick, '' )
end;

Function THamsterMainWindow.Allowed (Sender: TObject): boolean;
begin
   Result := true;
   If Assigned(Sender) then If Sender is TMenuItem then begin
      With TMenuItem(Sender) do Result := Enabled and Visible
   end;
   If ConfigWndActive > 0 then Result := false
end;

Function THamsterMainWindow.Hidden (Sender: TObject): boolean;
begin
   Result := lHideMenuItems.IndexOf(Sender) >= 0
end;

procedure THamsterMainWindow.mnuEdithostsresolvingnamestoIPsClick(
  Sender: TObject);
Var FileName, Path: String; T: textfile; Missing: Boolean;
begin
   If Not Allowed(Sender) then Exit;
   Missing := Not GetHostsDirectory(Path);
   FileName := IncludeTrailingBackslash(Path)+'hosts';
   If Missing then begin
      AssignFile(t, IncludeTrailingBackslash(Path)+'hosts');
      FileMode := 1;
      Rewrite(t);
      Writeln(t, '127.0.0.1'+#9+'localhost');
      CloseFile(t)
   end;
   EditFile( FileName )
end;

procedure THamsterMainWindow.mnuConfigClick(Sender: TObject);
begin
   mnuEdithostsresolvingnamestoIPs.Visible := (Not Hidden(mnuEdithostsresolvingnamestoIPs))
     and Def_AdvancedConfiguration;
   mnuEditHamsterIni.Visible := Not Hidden(mnuEditHamsterIni) and Def_AdvancedConfiguration;
   mnuEditMailScoreFile.visible := (Not Hidden(mnuEditMailScoreFile)) and
      ( Def_AdvancedConfiguration or ( FileExists2(PATH_BASE + CFGFILE_MFILTER)
         and (GetFileSize(PATH_BASE + CFGFILE_MFILTER)>0) ) );
   mnuEditNewsScoreFile.visible := (Not Hidden(mnuEditNewsScoreFile)) and
      ( Def_AdvancedConfiguration or ( FileExists2(PATH_BASE + CFGFILE_SCORES)
         and (GetFileSize(PATH_BASE + CFGFILE_SCORES)>0) ) );
   mnuEditspecialfiles.Visible := (Not Hidden(mnuEditspecialfiles)) and
      (mnuEditNewsScoreFile.Visible or mnuEditMailScoreFile.Visible);
   mnuFileKills.Visible :=
      (Not Hidden(mnuFileKills)) and
      (Def_AdvancedConfiguration or  ( FileExists2(PATH_GROUPS + CFGFILE_SCORELOG)
         and (GetFileSize(PATH_GROUPS + CFGFILE_SCORELOG)>0) ) );
   mnuFileKills.enabled := CntActiveTasks = 0;
end;

procedure THamsterMainWindow.FormKeyPress(Sender: TObject; var Key: Char);
begin
   If Key = #27 then begin
      If (ActiveControl = txtShell) and (txtShell.Text > '')
         then txtShell.Text := ''
         else AppMinimize (NIL);
      Key := #0
   end
end;

procedure THamsterMainWindow.mnuSwitchAdvancedSettingsClick(
  Sender: TObject);
begin
   Def_AdvancedConfiguration := Not Def_AdvancedConfiguration;
   SetAdvancedSettings;
   CfgIni.WriteBool ('Setup', 'AdvancedConfiguration', Def_AdvancedConfiguration);
end;

procedure THamsterMainWindow.mnuConfigAutomaticsClick(Sender: TObject);
begin
   DialogAutomatics;
   ConfigLoad (ctAutomatics)
end;

procedure THamsterMainWindow.mnuLocalIMAPClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   if mnuLocalImap.Checked then LocalServerActivate( stIMAP, saSTOP  )
                           else LocalServerActivate( stIMAP, saSTART );
   mnuLocalIMAP.Checked := LocalServerIsActive( stIMAP );
end;

procedure THamsterMainWindow.butStopThreadClick(Sender: TObject);
Var ID, s, dummy: String;
begin
   s := '';
   With lstThd do try If ItemIndex >= 0 then s := Items[ItemIndex] except end;
   If s > '' then begin
      ExtractThreadID (lstThd, s, ID, dummy, true);
      If Not ThreadControl.Stop ( ID ) then Log ( LOGID_WARN,
          TrF('Warning.ThreadAlreadyStopped', 'The Thread "%s" is already stopped', ID) )
   end
end;

procedure THamsterMainWindow.History1Click(Sender: TObject);
begin
   DialogHistory
end;

procedure THamsterMainWindow.mnuHelpFAQClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   Application.HelpJump ( HelpFAQID )
end;

function THamsterMainWindow.LogIDtoIndex(const ID: Integer): Integer;
begin
   case ID of
      LOGID_ERROR : Result := 6;
      LOGID_WARN  : Result := 5;
      LOGID_SYSTEM: Result := 4;
      LOGID_INFO  : Result := 3;
      LOGID_DETAIL: Result := 2;
      LOGID_DEBUG : Result := 1;
      else          Result := 0;
   end;
end;

procedure THamsterMainWindow.FullVisualSettings;

  Procedure ShowAll (M: TMenuItem);
  Var i: integer;
  begin
     M.Visible := true;
     M.Enabled := true;
     For i := 0 to M.Count-1 do ShowAll(M.Items[i])
  end;

Var i: Integer; s, s2: String; p: integer; AktMenu: TComponent;
begin
   For i := 0 to Menu.Items.Count-1 do ShowAll(Menu.Items[i]);
   VisualSettings;
   s := Trim(Def_HideMenuItems);
   While s > '' do begin
      p := Pos(',', s);
      If p > 0 then begin s2 := Trim(Copy(s, 1, p-1)); Delete(s, 1, p) end
               else begin s2 := Trim(s); s := '' end;
      If s2 > '' then begin
         AktMenu := FindComponent (s2);
         If Assigned(AktMenu) then If AktMenu is TMenuItem then begin
            lHideMenuItems.Add (AktMenu);
            (AktMenu as TMenuItem).Visible := false
         end
      end
   end;
end;

procedure THamsterMainWindow.mnuOnlineAllNNTPClick(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   if not (CriticalState>0) then begin
      StartTransfer( '', [trNNTP] );
   end else begin
      Log( LOGID_WARN, TrGl(kLog, 'System.Purge.NoReady', 'Hamster is not ready for this action - purging database') )
   end
end;

procedure THamsterMainWindow.mnuOnlineAllPOP3Click(Sender: TObject);
begin
   If Not Allowed(Sender) then Exit;
   if not (CriticalState>0) then begin
      StartTransfer( '', [trPOP3] ); // all servers
   end else begin
      Log( LOGID_WARN, TrGl(kLog, 'System.Purge.NoReady', 'Hamster is not ready for this action - purging database') )
   end
end;

procedure THamsterMainWindow.labShellClick(Sender: TObject);
begin
   Actions.ExecForAcc(atMailIn, 'SPAM', '')
end;

end.

