unit cActions;

interface

Uses Windows, Dialogs, classes;

Type
  TActiontype =
      (atNone,
       atStartUp, atShutDown,
       atSearchMID,
       atNewsPreprocess, atNews, atNewsOut, atNewsLocal, atNewsGateway,
       atNewsInNNTP,
       atMailHeader, atMail, atMailIn, atMailInternal, atMailLocal, atMailOut,
       atGroupDblClick,
       atTrayIconClick, atTrayIconDblClick,
       atTrayIconMiddleClick, atTrayIconMiddleDblClick,
       atStatusClick, atStatusDblClick,
       atDUNBeforeDial, atDUNDialFailed, atDUNConnected, atDUNHangup);
Const
  ActionIniKeys: Array[TActiontype] of String
    = ('',
       'startup', 'shutdown',
       'searchMID',
       'news.preprocess', 'news', 'news.out', 'news.local', 'news.gateway',
       'news.nntp',
       'mail.getheader', 'mail', 'mail.in', 'mail.internal', 'mail.local', 'mail.out',
       'group.doubleclick',
       'trayicon.click', 'trayicon.doubleclick',
       'trayicon.middleclick', 'trayicon.middledoubleclick',
       'status.click', 'status.doubleclick',
       'dun.beforedial', 'dun.dialfailed', 'dun.connected', 'dun.hangup');
  ActionParent: Array[TActiontype] of TActiontype =
      (atNone,
       atNone, atNone,
       atNone,
       atNone, atNone, atNews, atNews, atNews,
       atNone,
       atNone, atNone, atMail, atMail, atMail, atMail,
       atNone,
       atNone, atNone,
       atNone, atNone,
       atNone, atNone,
       atNone, atNone, atNone, atNone);
  WaitAlways: Set of TActionType =
       [atNews, atNewsPreprocess, atNewsLocal, atNewsGateway,
        atNewsInNNTP,
        atMailHeader];

Type
  TWait = (wNone, wAll, wExec, wScript); // 0, 1, 2, 3
  TExeStartType = (stNormal, stHidden);
Const
  ExeStartValue: Array[TExeStartType] of Integer = ( SW_SHOWNORMAL, SW_SHOWMINNOACTIVE );
  ExeStartCaption: Array[TExeStartType] of String = ( 'normal', 'hidden' );
Type
  TActionInfo2 = Class
  private
    function GetScriptlinesAsStr: String;
    procedure PutScriptlinesAsStr(const Value: String);
  public
     ActionTyp: TActionType;
     ActionKey, Script, Exec, Pars, Info: String;
     Scriptlines: TStrings;
     Wait: TWait;
     ExeStartTyp: TExeStartType;
     // Nur zur Laufzeit
     Tested, Used: Boolean;
     Account: String;
     Wildcard0, Wildcard1: Integer;
     constructor Create;
     destructor Destroy; override;
     Property ScriptlinesAsStr: String read GetScriptlinesAsStr Write PutScriptlinesAsStr;
  end;
  TActions = Class
    private
      Def_ActionsTimeoutInit, Def_ActionsTimeoutExec: DWord;
      Infos: Array[TActionType] of TActionInfo2;
      procedure TestInfo(const AktTyp: TActiontype; Const Acc: String);
      Function ExecFileAndWait(const aCmdLine: String; Const WorkDir: String;
         Const ShowWindow: Integer; Const doWait: Boolean): Boolean;
    public
      constructor Create;
      destructor destroy; override;
      Procedure ClearInfo;
      Function Exists (const Typ: TActiontype): Boolean;
      Function Exec(const Typ: TActiontype; Const Parameter: String): boolean;
      Function ExecForAcc(const Typ: TActiontype; Const Acc, Parameter: String): boolean;
  end;

Function Actions: TActions;
Procedure ReloadActions;

implementation

Uses SysUtils, Config, ShellAPI, tScript, cLogFile, cStdForm;

Var L: TActions;

Function Actions: TActions;
begin
   If Not Assigned(L) then L := TActions.Create;
   Result := L
end;

Procedure ReloadActions;
begin
   If Assigned(L) then FreeAndNil(L)
end;

function TActions.ExecFileAndWait(const aCmdLine: String; Const WorkDir: String;
   Const ShowWindow: Integer; Const doWait: Boolean): Boolean;
var
   StartupInfo : TStartupInfo;
   ProcessInfo : TProcessInformation;
   x: DWord;
   PWorkdir: PChar;
begin
   FillChar(StartupInfo, SizeOf(TStartupInfo), 0);
   with StartupInfo do begin
      cb:= SizeOf(TStartupInfo);
      dwFlags:= STARTF_USESHOWWINDOW or STARTF_FORCEONFEEDBACK;
      wShowWindow:= ShowWindow;


   end;
   If WorkDir > ''
      then PWorkDir := PChar(WorkDir)
      else PWorkDir := NIL;
   Result := CreateProcess(nil,PChar(aCmdLine), nil, nil, False,
                           NORMAL_PRIORITY_CLASS, nil, PWorkDir,
                           StartupInfo, ProcessInfo);
   if doWait and Result then begin
      x := Def_ActionsTimeoutInit;
      If x < INFINITE / 1000 then x := x * 1000 else x := INFINITE;
      Case WaitForInputIdle(ProcessInfo.hProcess, x) of
         WAIT_TIMEOUT: begin
            Log ( LOGID_ERROR, TrGlF(kLog, 'Actions.Exec.Init.Timeout',
               'Error: Timeout when waiting for initialization of "%s"',
               aCmdLine ));
            exit
         end;
         $FFFFFFFF: begin
            try
               RaiseLastWin32Error
            except
               On E:Exception do Log ( LOGID_ERROR, TrGlF(kLog, 'Actions.Exec.Init.Error',
                   'Error "%s" when waiting for initialization of "%s"',
                   [E.message, aCmdLine] ) )
            end;
            exit
         end;
      end;
      x := Def_ActionsTimeoutExec;
      If x < INFINITE / 1000 then x := x * 1000 else x := INFINITE;
      If WaitForSingleObject(ProcessInfo.hProcess, x) = WAIT_TIMEOUT then begin
         Log ( LOGID_ERROR, TrGlF(kLog, 'Actions.Exec.Run.Timeout',
            'Error: Timeout when waiting for termination of "%s"',
            aCmdLine ) );
         exit
      end
   end
end;

{ TActions }

Const Abschn = 'Actions';

procedure TActions.ClearInfo;
Var i: TActiontype;
begin
   Def_ActionsTimeoutInit := 60;
   Def_ActionsTimeoutExec := 180;
   With CfgIni do begin
      IRead( Abschn, 'Timeout.ExecInit', Def_ActionsTimeoutInit );
      IRead( Abschn, 'Timeout.ExecRun', Def_ActionsTimeoutExec )
   end;
   For i := Low(TActiontype) to High(i) do Infos[i].Tested := false
end;

constructor TActions.Create;
Var i: TActiontype;
begin
   For i := Low(TActiontype) to High(i) do Infos[i] := TActioninfo2.Create;
   ClearInfo;
end;

procedure TActions.TestInfo(const AktTyp: TActiontype; Const Acc: String);
Var AktKey: String;
begin
   With Infos[AktTyp] do begin
      ActionTyp := AktTyp;     
      If Tested and (Acc = Account) then Exit;
      Tested := false;
      Account := '';
      AktKey := ActionIniKeys[AktTyp]+'.';
      If Acc > '' then AktKey := AktKey + Acc + '.';
      With CfgIni do begin
         Exec := ReadString( Abschn, AktKey+'exec', '' );
         Pars := ReadString( Abschn, AktKey+'pars', '' );
         Wildcard0 := 0;
         Wildcard1 := 0;
         Script := ReadString( Abschn, AktKey+'script', '' );
         ScriptlinesAsStr := ReadString( Abschn, AktKey+'scriptlines', '' );
         try Wait := TWait(ReadInteger( Abschn, AktKey+'wait', 0 ))
         except Wait := wNone end;
         try ExeStartTyp := TExeStartType(ReadInteger( Abschn, AktKey+'exestarttype', 0 ))
         except ExeStartTyp := stNormal end;
      end;
      Used := Exec + Script + Trim(ScriptlinesAsStr) > '';
      If (Acc > '') and (Not Used) and (ActionParent[ActionTyp] > atNone) then begin
         TestInfo (ActionParent[ActionTyp], Acc);
         If Infos[ActionParent[ActionTyp]].Used
            then Infos[ActionTyp] := Infos[ActionParent[ActionTyp]]
      end;
      If (Acc > '') and (Not Used) then TestInfo (ActionTyp, '');
      If Used then begin
         If (Pars > '') and (Wildcard1 = 0) then begin
            Wildcard1 := pos('%1', Pars );
            If Wildcard1 > 0 then Delete (Pars, Wildcard1, 2)
         end;
         If (Pars > '') and (Wildcard0 = 0) then begin
            Wildcard0 := pos('%0', Pars );
            If Wildcard0 > 0 then Delete (Pars, Wildcard0, 2)
         end;
      end else
      If ActionParent[ActionTyp] > atNone then begin
         TestInfo (ActionParent[ActionTyp], Acc);
         If Infos[ActionParent[ActionTyp]].Used
            then Infos[ActionTyp] := Infos[ActionParent[ActionTyp]]
      end;
      Account := Acc;
      Tested := true
   end
end;

Function TActions.Exec(const Typ: TActiontype; Const Parameter: String): boolean;
begin
   If Exists(Typ) then Result := ExecForAcc ( Typ, '', Parameter )
                  else Result := false
end;

function TActions.ExecForAcc(const Typ: TActiontype; const Acc,
  Parameter: String): boolean;
Var AktPar, WorkDir: String;
    W: TWait; p2: Integer; DoWait: Boolean;
begin
   TestInfo (Typ, Acc);
   With Infos[Typ] do begin
      Result := Used;
      If Not Result then Exit;
      If Typ IN WaitAlways then W := wAll else W := Wait;
      If Exec > '' then begin
         AktPar := Pars;
         WorkDir := ExtractFileDir(Exec);
         If WildCard1 > 0 then Insert ( Parameter, AktPar, WildCard1 );
         If WildCard0 > 0 then begin
            p2 := WildCard0;
            If (WildCard1 > 0) and (WildCard1 < p2) then p2 := p2 + Length(Parameter);
            Insert ( LowerCase(ActionIniKeys[Typ]), AktPar, p2 )
         end;
         If W IN [wAll, wExec] then begin
            Log (LOGID_DETAIL, TrGlF (kLog, 'Action.ExecWait', 'Action-Type %s - Execute and wait: %s',
               [ActionIniKeys[Typ], Exec+' '+AktPar] ) );
            ExecFileAndWait('"'+Exec+'" '+AktPar, Workdir, ExeStartValue[ExeStartTyp], true)
         end else begin
            Log (LOGID_DETAIL, TrGlF (kLog, 'Action.ExecAsync', 'Action-Type %s - Execute: %s',
               [ActionIniKeys[Typ], Exec+' '+AktPar] ) );
            ShellExecute( 0, 'open', PChar(Exec), PChar(AktPar),
               PChar(WorkDir), ExeStartValue[ExeStartTyp] )
         end
      end;
      If Script > '' then begin
         AktPar := LowerCase(ActionIniKeys[Typ]) + #13#10 + Parameter;
         If Acc > '' then AktPar := AktPar + #13#10 + Acc;
         If W IN [wAll, wScript] then begin
            Log (LOGID_DETAIL, TrGlF (kLog, 'Action.ScriptWait2', 'Action-Type %s - run script "%s", Wait=%s',
               [ActionIniKeys[Typ], Script, '1'] ) );
            StartNewScript ( Script, AktPar, true)
         end else begin
            Log (LOGID_DETAIL, TrGlF (kLog, 'Action.ScriptWait2', 'Action-Type %s - run script "%s", Wait=%s',
               [ActionIniKeys[Typ], Script, '0'] ) );
            StartNewScript ( Script, AktPar, false)
         end
      end;
      If ScriptLinesAsStr > '' then begin
         AktPar := LowerCase(ActionIniKeys[Typ]) + #13#10 + Parameter;
         If Acc > '' then AktPar := AktPar + #13#10 + Acc;
         DoWait := W IN [wAll, wScript];
         If DoWait
            then Log (LOGID_DETAIL, TrGlF (kLog, 'Action.ScriptLinesWait', 'Action-Type %s - run scriptlines, Wait=%s',
               [ActionIniKeys[Typ], '1'] ) )
            else Log (LOGID_DETAIL, TrGlF (kLog, 'Action.ScriptLinesWait', 'Action-Type %s - run scriptlines, Wait=%s',
               [ActionIniKeys[Typ], '0'] ) );
         StartScriptLines ( Scriptlines, DoWait )
      end
   end
end;

function TActions.Exists(const Typ: TActiontype): Boolean;
begin
   TestInfo (Typ, '');
   Result := Infos[Typ].Used
end;

destructor TActions.destroy;
Var i: TActiontype;
begin
  inherited;
  For i := Low(TActiontype) to High(i) do Infos[i].free
end;

{ TActionInfo2 }

constructor TActionInfo2.Create;
begin
   Scriptlines := TStringList.Create;
end;

destructor TActionInfo2.Destroy;
begin
  inherited;
  FreeAndNil(Scriptlines)
end;

function TActionInfo2.GetScriptlinesAsStr: String;
begin
   If Scriptlines.Count = 0 then begin
      Result := ''
   end else begin
      Result := StringReplace( Scriptlines.text, #13#10, '', [rfReplaceAll] );
      While (Result > '') and (Result[Length(Result)]='') do Delete(Result, Length(Result), 1)
   end
end;

procedure TActionInfo2.PutScriptlinesAsStr(const Value: String);
begin
   Scriptlines.Text := StringReplace( Value, '',  #13#10, [rfReplaceAll] )
end;

initialization
   L := NIL;
finalization
   If Assigned(L) then FreeAndNil(L)
end.
