{***************************************************************
 *
 * Unit Name: cMailRouter
 * Purpose  :
 * Author   :
 * History  :
 *
 ****************************************************************}

unit cMailRouter;

interface

uses windows, cArticle, cArtFiles, Classes;

type
 tBounceType = (btNone,btAdmin,btSender);
 tMailType   = (mtUnknown,mtSMTP,mtESMTP,mtPOP,mtScript,mtNews2Mail,mtInternal,mtBounce); //JW //Bounce

Const
 MailTypeNames: Array[tMailType] of String =
    ( 'unknown', 'SMTP', 'ESMTP', 'POP3', 'Script', 'Hamster-NewsToMail-Gate',
      'Hamster-Internal', 'Hamster-Bounce' );

type
 tRouter = class(tObject)
    private
       BounceType : tBounceType;    //Destination user if bounce genereted
       fResultStr     : String;     //resulttext
       AllRecipientsOk : Boolean;
       IsMailAlias     : Boolean;   // Property for rerouted  //JW //MailAlias
                                    // via MAlias.hat
    public
       MailSource      : tMailSource;
       MailType        : tMailType;
       MailFrom : String;           // name@provi.der or accountname
       InIP            : LongInt;
       InIpStr         : String;
       MailTo : tStringList;        // List of name@provi.der or accountname
       MailText : tArticle;           //Mailheader and Mailbody
       MailRemoveMids : String;     //FQDN for Msg-Id to remove
       MailAddXHamster : Boolean;
       MailAddReceived : Boolean;
       MailHelo       : String;     //Helo-string from mailclient
       GenerateMailMID : Integer;
       UserID          : Integer; {JW} {CurrendUserID}
       Property ResultStr: String read FResultStr;
       constructor Create;
       Destructor Destroy; Override;
       Function Execute: boolean;
    end;

 PMailToObj = ^tMailToObj;
 TMailToObj = record
   IMAPFolder : String;
   IMAPFlags  : String;
 end;

 function NewMail(EnvFrom,EnvTo,MsgText:String):Boolean;
 function SendInfoMail( Const Recipient, Subject, MailBody: String ): Boolean;
 procedure RemoveMailMessageID( Msg: TArticle );


implementation

uses cStdForm,Config,uWinSock,SysUtils,Global,uTools,cAccount,uDateTime, cLogfile,
     cActions, cMailAlias;

constructor tRouter.Create;
begin
   Inherited Create;
   BounceType:=btAdmin;
   fResultStr:='';
   MailSource:=msIncoming;
   MailType:=mtUnknown;
   MailHelo:='';
   InIP:=LookupLocalHostAddr;
   InIpStr:=LookupLocalHostName;
   MailTo:=tStringList.Create;
   MailText:=tArticle.Create;
   MailRemoveMids:=Def_Mail_RemoveMids;
   MailAddXHamster:=Def_Mail_AddXHamster;
   MailAddReceived:=Def_Mail_AddReceived;
   GenerateMailMID:=Def_GenerateMailMID;
   AllRecipientsOk:=False;
   UserId:=-1; {JW} {CurrendUserID}
end;

Destructor tRouter.Destroy;
begin
   MailTo.Free;
   MailText.Free;
   Inherited Destroy;
end;

procedure AddToLog(ID:Word; Msg:String);
begin
   Log(Id, 'Mailrouter: '+Msg);
end;

procedure SendBounce(BounceType:tBounceType;BounceTo, BounceMsg:String);
Var s: String;
begin
   With TRouter.Create do try
      try
         if (BounceType=btSender) and (ExtractMailAddr(BounceTo)='') then BounceType := btAdmin;
         if BounceType <> btNone then begin
            MailFrom:='<>';
            If BounceType = btSender then begin
               MailTo.Add(BounceTo);
               s := BounceTo
            end else begin
               MailTo.Add('<'+Def_Postmaster+'>');
               If Def_FQDN <> ''
                  then s := Def_Postmaster+'@'+trim(Def_FQDN)
                  else s := Def_Postmaster+'@hamster.invalid';
            end;
            if Def_FQDN >'' then begin
               MailText.Text:='From: local-smtp@' + Def_FQDN + CRLF
                    + 'To: ' + s + CRLF
                    + 'Date: ' + DateTimeGMTToRfcDateTime( NowGMT, NowRfcTimezone ) + CRLF
                    + 'Subject: '+TrGl('Mailinfo', 'LocalSMTP.FailureNotice.Subject','[Local SMTP] Failure notice') + CRLF
                    + 'Message-ID: ' + MidGenerator( Def_FQDNforMIDs ) + CRLF
                    + CrLf
                    + BounceMsg
            end else begin
               MailText.Text:='From: local-smtp@hamster.invalid' + CRLF
                    + 'To: ' + s + CRLF
                    + 'Date: ' + DateTimeGMTToRfcDateTime( NowGMT, NowRfcTimezone ) + CRLF
                    + 'Subject: '+TrGl('Mailinfo', 'LocalSMTP.FailureNotice.Subject','[Local SMTP] Failure notice') + CRLF
                    + 'Message-ID: ' + MidGenerator( Def_FQDNforMIDs ) + CRLF
                    + CrLf
                    + BounceMsg
            end;
            BounceType:= btNone;
            MailSource:=msInternal;
            MailType:=mtBounce; //JW //Bounce
            Execute
         end else begin
            AddToLog( LOGID_WARN, TrGl('Mailinfo', 'mailrouter.doublebouncesuppressed',
               'double bounce by mail routing suppressed'))
         end
      except
         on E: Exception do AddToLog( LOGID_ERROR,
            TrGlF('Mailinfo', 'mailrouter.bounce.error', 'Bounce - %s', E.Message ) );
      end
   finally
      Free
   end
end;

{#########################################################################}

function NewMail(EnvFrom,EnvTo,MsgText:String):Boolean;
Var i: Integer; s: String;
begin
   result:=false;
   With TRouter.Create do try
      try
         if EnvFrom = '' then raise Exception.Create('missing header "Envelope From:"');
         if EnvTo = '' then raise Exception.Create('missing header "Envelope To:"');
         MailType:=mtScript;
         MailFrom:=ExtractMailAddr(EnvFrom);
         i:=1;
         repeat
            s:=ExtractMailAddr(Split(EnvTo,';',i));
            inc(i);
            if s > '' then begin
               MailTo.Add(s);
               AddToLog(LOGID_DETAIL, TrGlF('Mailinfo', 'mailrouter.addtoreceiverlist',
                  'Mailrouter add %s to receiver list', s ) )
            end
         until s='';
         MailText.Text:=MsgText;
         MailType:=mtScript;
         Result := Execute;
         If Result
            then AddToLog(LOGID_Detail, TrGlF('Mailinfo', 'mailrouter.routedfromscriptfor',
               'Mail routed from script for %s', MailFrom ) )
            else AddToLog(LOGID_Error, ResultStr);
      except
         on E: Exception do AddToLog(LOGID_Error, TrGlF('Mailinfo','mailrouter.newmail.error',
           'NewMail - %s', e.Message))
      end
   finally
      free
   end
end;

function SendInfoMail( Const Recipient, Subject, MailBody: String ): Boolean;
// function generate the header for a e-mail with subject and recipient
// and add the MailBody. If local delivery only of infomail configured
// then this function replace the remotely e-mail address with address of
// admin. If the recipient a locally known object then this function
// replace the recipient with the local username.
var  RcptID, RcptType: LongInt;
     ToHeader, TheMail, UseRecipient: String;
     bLocal: Boolean;
begin
   UseRecipient := Recipient;
   ToHeader:='';
   RcptType:=LOCALMAILTYPE_INVALID;
   RcptID:=ACTID_INVALID;
   AddToLog(LOGID_INFO, TrGlF('Mailinfo', 'Mailrouter.SendInfoMail',
      'Sending InfoMail for %s, Subject: "%s"', [useRecipient, Subject]));
   // check if recipient local user and set RcptID if exist
   RcptID := CfgAccounts.UserIDOf (useRecipient);
   if RcptID=ACTID_INVALID then begin
      // check if recipient a local Mailbox or local Mailaddress
      if not CfgAccounts.IsLocalMailbox(useRecipient, RcptID, RcptType, bLocal ) then begin
         RcptID := ACTID_INVALID
      end
   end;
   // set the To-Header variable if the user not known local
   if RcptID=ACTID_INVALID then begin   // User is not local
      // check format of recipient for Infomail if with old local addressformat go to admin only
      if pos('@',UseRecipient)=0 then begin
         // Make indirect recipient as local known
         RcptID:=ACTID_ADMIN
      end else begin
         // check if send infomails local only then replace the recipient
         if Def_SendInfoMailLocalOnly
            then RcptID:=ACTID_ADMIN
            else ToHeader:='<'+FilterEmailOfFrom(UseRecipient)+'>';
      end
   end;
   // if recipient local know replace local address
   if RcptID<>ACTID_INVALID then begin
      UseRecipient := CfgAccounts.Value[RcptID,ACTP_USERNAME]; // read mailbox for local user
      // log error is missing local mailbox and set admin as target
      if UseRecipient='' then begin
         AddToLog(LOGID_Warn, TrGl('Mailinfo', 'mailrouter.nomailboxforlocaluser',
             'Internal error. No mailbox found for local user'));
         Userecipient:='admin';
         RcptID:=ACTID_ADMIN
      end;
      ToHeader := CfgAccounts.Value[RcptID,ACTP_FULLNAME];
      // set fullname if available and add recipient
      If ToHeader > ''
         then ToHeader := '"'+ToHeader+'" <'+FilterEmailOfFrom(UseRecipient)+'>'
         else ToHeader := '<'+FilterEmailOfFrom(UseRecipient)+'>';
   end;
   // build header for infomail
   if Def_FQDN > ''
      then TheMail := 'From: "Hamster-Info" <local-hamster-info@'+trim(Def_FQDN) + '>'
      else TheMail := 'From: "Hamster-Info" <local-hamster-info@hamster.invalid>';
   TheMail := TheMail + CRLF
            + 'To: ' + ToHeader + CRLF
            + 'Date: ' + DateTimeGMTToRfcDateTime( NowGMT, NowRfcTimezone ) + CRLF
            + 'Subject: ' + Subject + CRLF
            + 'Message-ID: ' + MidGenerator( Def_FQDNforMIDs ) + CRLF
            + CRLF // header/body-sep.
            + MailBody;
   // create new routing object
   With TRouter.Create do try
      try
         MailSource:=msInternal; // set sourcetype for action
         MailType:=mtInternal; // set sourcetype for routing
         // make envelope from if so given
         if Def_EnvelopeFrom > '' then begin
            MailFrom:=Def_EnvelopeFrom
         end else begin
            if Def_FQDN<>'' then MailFrom:='admin@'+Def_FQDN
                            else MailFrom:='admin'
         end;
         // add recipient
         MailTo.Add(useRecipient);
         // add mail with header and body
         MailText.Text:=TheMail;
         // activate mailrouter
         Result := Execute
      except
         Result:=false
      end
   finally
      Free
   end
end;

procedure RemoveMailMessageID( Msg: TArticle );
var  OldMID, OldFQDN : String; i : Integer;
begin
   OldMID := Msg['Message-ID:'];
   OLDFQDN := lowercase(OldMID); {JAWO 01.04.2001: mail.removemids case insenistive}
   i := Pos( '<', OldFQDN );
   if i=0 then OldFQDN:='' else OldFQDN:=copy(OldFQDN,i+1,Length(OldFQDN)-i);
   i := Pos( '@', OldFQDN );
   if i=0 then OldFQDN:='' else OldFQDN:=copy(OldFQDN,i+1,Length(OldFQDN)-i);
   i := Pos( '>', OldFQDN );
   if i=0 then OldFQDN:='' else OldFQDN:=copy(OldFQDN,1,i-1);
   If OldFQDN > '' then begin
      // test, if old-FQDN is in list of FQDNs to be removed
      With TParser.Create do try
         Parse( Def_Mail_RemoveMids, ',' );
         i := 0;
         While sPart(i,'')<>'' do begin
            If sPart(i,'')=OldFQDN then begin
               Log( LOGID_INFO, TrGlF(kLog, 'Info.MID_removed',
                  'Note: Message-ID %s removed.', OldMID) );
               Msg.DeleteHeader('Message-ID');
               break;
            end;
            inc(i);
         end
      finally
         free
      end
   end
end;


Function tRouter.Execute: boolean;
   {--------------------------------------------------------------------------}
   {JW} {Helo}
   function CheckMailHelo(helo:String):string;
   begin
    while (pos('"',helo)<>0) do begin
     delete(helo,pos('"',helo),1);
     AddToLog( LOGID_WARN, 'wrong >"< character  in helo string deleted');
    end;
     while (pos(' ',helo)<>0) do begin
     delete(helo,pos(' ',helo),1);
     AddToLog( LOGID_WARN, 'wrong space character in helo string deleted');
    end;
    result:=helo;
   end;
   {--------------------------------------------------------------------------}
   {/JW}
   procedure SetErrorResult(ErrorMsg:String);
   begin
      fResultStr:=ErrorMsg;
      AddToLog(LogId_Warn,ErrorMsg);
      AllRecipientsOk:=False;
   end;
   {--------------------------------------------------------------------------}
   Function AppendFQDN(Const Address: String): String;
   begin
      Result := Address;
      If Pos('@', Result) = 0 then begin
         If Def_FQDN > ''
            then Result := Result + '@'+Def_FQDN
            else Result := Result + '@localhost'
      end
   end;
   {--------------------------------------------------------------------------}
   function MakeEnvelopeFormat(const Address : String):String;
   begin
    Result:=TrimWhSpace(FilterEmailOfFrom(Address));
    if Result<>'' then begin
      if Result[1]<>'<' then Result:='<'+Result;
      if Result[length(Result)]<>'>' then Result:=Result+'>';
     end else begin
      result:='<>';
    end;
   end;
   {--------------------------------------------------------------------------}
   {JW} {bounce local}
   procedure SendBounce(ABounceType:tBounceType; BounceTo, BounceMsg: String);
   Var Router: TRouter; s: String;
   begin
      Router := TRouter.Create;
      try
         try
            // If not bounce destination available then bounce only to admin
            if (ABounceType=btSender) and (ExtractMailAddr(BounceTo)='') then ABounceType:=btAdmin;
            // if bounce type btNone then double bounce detected and suppressed
            if ABounceType <> btNone then begin
               With Router do begin
                  // make empty from Header
                  MailFrom:='<>';
                  If ABounceType = btSender then begin // bounce to sender
                     MailTo.Add(BounceTo);
                     s := BounceTo;
                     AddToLog( LOGID_INFO, TrGlF('Mailinfo', 'mailrouter.bounceto',
                        'bounce message to %s', BounceTo));
                  end else begin // bounce to postmaster
                     AddToLog( LOGID_INFO, TrGl('Mailinfo', 'mailrouter.bouncetopostmaster',
                        'bounce message to postmaster'));
                     MailTo.Add('<'+Def_Postmaster+'>');
                     If Def_FQDN <> ''
                        then s := Def_Postmaster+'@'+trim(Def_FQDN)
                        else s := Def_Postmaster+'@hamster.invalid';
                  end;
                  if Def_FQDN<>'' then begin
                     MailText.Text:='From: local-smtp@' + Def_FQDN + CRLF
                          + 'To: ' + s + CRLF
                          + 'Date: '
                          + DateTimeGMTToRfcDateTime( NowGMT, NowRfcTimezone ) + CRLF
                          + 'Subject: '+TrGl('Mailinfo',
                                             'LocalSMTP.FailureNotice.Subject',
                                             '[Local SMTP] Failure notice') + CRLF
                          + 'Message-ID: ' + MidGenerator( Def_FQDNforMIDs ) + CRLF
                          + CrLf
                          + BounceMsg
                  end else begin
                     MailText.Text:='From: local-smtp@hamster.invalid' + CRLF
                          + 'To: ' + s + CRLF
                          + 'Date: '
                          + DateTimeGMTToRfcDateTime( NowGMT, NowRfcTimezone ) + CRLF
                          + 'Subject: '+TrGl('Mailinfo',
                                      'LocalSMTP.FailureNotice.Subject',
                                      '[Local SMTP] Failure notice') + CRLF
                          + 'Message-ID: ' + MidGenerator( Def_FQDNforMIDs ) + CRLF
                          + CrLf
                          + BounceMsg
                  end;
                  BounceType := btNone;     // set bounce type to prevent double bounce
                  MailSource := msInternal;  // set mailsource
                  MailType := mtBounce;      // set mailtype
                  Execute   // activate Mailrouter recursive
               end
            end else begin
               AddToLog( LOGID_WARN, TrGl('Mailinfo', 'mailrouter.doublebouncesuppressed',
                  'double bounce by mail routing suppressed'))
            end
         except
            on E: Exception do AddToLog( LOGID_ERROR, 'Bounce - '+E.Message );
         end
      finally
         Router.Free
      end
   end;
   {JW}

   Procedure ExecAction (Const FN, Account: String; Const Source: tMailSource);
   begin
      Case Source of
         msOutgoing: begin
            Actions.Exec ( atMailOut, FN );
            {JW} {critical event}
            EnterCriticalSection(CS_Event);
            PulseEvent(EventMailOut) ;
            LeaveCriticalSection(CS_Event);
            {JW}
         end;
         msLocal: Actions.ExecForAcc ( atMailLocal, Account, FN );
         msIncoming: begin
            Actions.ExecForAcc ( atMailIn, Account, FN );
            {JW} {critical event}
            EnterCriticalSection(CS_Event);
            PulseEvent(EventMailIn);
            LeaveCriticalSection(CS_Event);
            {JW}
         end;
         msInternal: begin
            Actions.ExecForAcc ( atMailInternal, Account, FN );
            {JW} {critical event}
            EnterCriticalSection(CS_Event);
            PulseEvent(EventMailInternal);
            LeaveCriticalSection(CS_Event);
            {JW}
         end
      end
   end;

var s, FN, Account, n, h, UIDL, BounceMsg, RecFrom, RecBy, RecWith: String;
    DestNr, LocalMailType, i: Integer;
    MailAddr : String;
    MailAddr2: String; //JW //MailAlias
    MailAddr3: String; //JW //AliasRecursion
    bLocal: boolean;//JW //AliasRecursion
    MailToObj : pMailToObj;
    IMAPFolder : String;
    IMAPFlags : String;
begin
   Result := false;
   IsMailAlias := False;

   h := MailTypeNames[MailType];
   Case MailSource of
      msIncoming : s:='Incoming';
      msOutgoing : s:='Outgoing';
      msInternal : s:='Internal';
      msLocal    : s:='Local';
      else         s:='unknown';
   end;
   DestNr := 0;
   while DestNr < MailTo.Count do begin
      n:=n+' '+MailTo[DestNr];
      inc(DestNr);
   end;
   AddToLog( LOGID_DETAIL, 'Routing mail with mailtype: '+h+
                          ', Mailsource: '+s+ ', for ' + MailFrom + ', to '+n );
   n:='';
   If MailTo.Count=0 then begin
      fResultStr:='554 Transaction failed (missing recipients)';
      exit
   end;
   {JW} {Mailbody}
   If MailText.FullBody = '' then begin
     If not (MailType IN [mtPOP]) then begin
       fResultStr:='554 Transaction failed (missing mail-body)';
       exit;
     end else begin
       AddToLog( LOGID_Warn, TrGl('Mailinfo', 'Mailrouter.MailWithoutBodyFromPOP3',
             'Mail without body received from remote POP3 server'));
       MailText.FullBody := '[Received Mail without body from remote server, Mail-Body added by Hamster]'
          +CRLF+'.'+CRLF
     end;
   end;
   {JW}
   fResultStr:='554 Transaction failed (unknown reason, see logfile)';
   BounceMsg:='';

   try
      // remove Mail-MID if configured to do so
      If MailRemoveMids<>'' then RemoveMailMessageID( MailText );
      // add Mail-MID if configured to do so
      If GenerateMailMID=GENERATEMID_IFNOTSET then begin
         If MailText['Message-ID:']='' then begin
           If Trim(Def_FQDNforMids)='' then AddToLog(LOGID_WARN,'Mailrouter: No FQDN found to generate MID');
           MailText['Message-ID:'] := MidGenerator(Def_FQDNForMids)
         end
      end;
      // add Hamster-header if configured to do so
      If MailAddXHamster and (Mailtype<>mtNews2Mail) then begin
         MailText['X-Posting-Agent'] := OUR_VERINFO
      end;
      // add Received-stamp
      If MailAddReceived then begin
         try
            UIDL := UIDLGenerator;
            MailHELO:=CheckMailHelo(MailHELO); //JW //Helo
            //create RecFrom
            If InIp<>0 then n := LookupHostName(InIP)
                       else n:='unknown';
            h := '';
            if (MailHELO<>'') and (MailHELO<>n) then h:=' (HELO ' + MailHelo + ')';
            RecFrom:='from '+n;
            if h<>'' then RecFrom:=RecFrom+h;
            If InIp<>0 then RecFrom:=RecFrom+' ['+nAddrToStr(InIp)+']';
            //create RecBy
            RecBy:='by ';
            if Def_FQDN<>'' then RecBy:=RecBy+Def_FQDN
                            else RecBy:=RecBy+LookupLocalHostName;
            RecBy:=RecBy+' ('+nAddrToStr(LookupLocalHostAddr)+') ';
            If UserID > -1 then RecBy:=RecBy+' (userid '+IntToStr(UserID)+')';
            //create RecWith
            h := MailTypeNames[MailType]
                + ' ('+GetMyStringFileInfo('ProductName','Hamster') + ' '
                + GetMyVersionInfo(false)+')';
            RecWith := 'with '+h+' ; '+DateTimeGMTToRFCDateTime(NowGMT,NowRfcTimezone);
            MailText.AddHeaderFirst('Received', RecFrom+CrLf+#9+RecBy+CrLf+#9+RecWith)
         except
            s:='';
         end
      end;
      if (MailFrom > '') and (MailText['Return-Path']='') then begin
         MailText['Return-Path:'] := '<'+FilterEmailOfFrom(MailFrom)+'>' // RFC2822
      end;
      If Mailtype=mtNews2Mail then begin
         MailText['X-Gate:'] := OUR_VERINFO+' NewsToMail-Gate'
      end;

      // deliver to local recipients
      AllRecipientsOk:=True;
      fResultStr:='';
      DestNr := 0;
      while DestNr<MailTo.Count do begin
         MailAddr2 := lowercase(trim(ExtractMailAddr( MailTo[DestNr] )));
         MailAddr3:='';
         MailAddr := MailAlias.Resolve(MailAddr2);
         {HSR} {IMAP-Folder 03}
         MailToObj := PMailToObj(MailTo.Objects[DestNr]);
         if Assigned(MailToObj) then begin
           IMAPFolder := MailToObj^.IMAPFolder;
           IMAPFlags  := MailToObj^.IMAPFlags;
         end else begin
           IMAPFolder := '';
           IMAPFlags  := '';
         end;
         {/HSR}
         if lowercase(trim(MailAddr))<>Mailaddr2 then begin
            AddToLog( LOGID_INFO, 'Mailrouter: reroute '+MailAddr2+' to '+MailAddr );
            MailText.AddHeader('X-Resent-To:', 'for '+Mailaddr2+' to '+ Mailaddr+' with alias list');
            MailText.AddHeader('X-Resent-By: ', 'Hamster-Mailrouter (' + IIf(Def_FQDN='', 'unknown FQDN', Def_FQDN) + ')');
            IsMailAlias:=True;
         end;
         MailTo[DestNr]:=MailAddr;
         MailAddr := ExtractMailAddr( MailAddr );

         if CfgAccounts.IsLocalMailbox( MailAddr, UserID, LocalMailType, bLocal) then begin
            if LocalMailType=LOCALMAILTYPE_NORMAL then begin
               // Mark mail as local if received by local server
               if (MailType IN [mtSMTP, mtESMTP]) then MailSource:=msLocal;
               s := MailText.Text; // mail-data
               // precede message with (local-only) info-lines
               If MailText[OUR_X_HEADER] = '' then begin
                  s := OUR_X_HEADER + ' ' + 'UIDL='     + UIDL + ' '
                     + 'Received=' + DateTimeToTimeStamp(Now) + CRLF
                     + s
               end;
               If SaveUniqueMailMsg( CfgAccounts.MailboxPath( UserID ),
                                         s, GenerateMailMID, MailSource,
                                         CfgAccounts.HasIMAPbox(UserID),
                                         IMAPFolder, IMAPFlags,
                                         FN, Account ) //IMAP (Chg)
               then begin
                  ExecAction(FN, Account, MailSource)
               end else begin
                  SetErrorResult('554 Transaction failed (couldn''t save local)');
               end;
            end else begin
               {JW} {bounce local}
               // set bounce destinatation to sender of message
               // if mail source loacaly and option ist defined
               // the Data.BounceType<>btNone Statement prevent
               // double bounce
               if (MailType IN [mtSMTP, mtESMTP]) and
                  Def_BounceMailToSender and (BounceType<>btNone)
               then begin
                  BounceType:=btSender
               end;
              {JW}
               if BounceMsg='' then BounceMsg:='|| [Hamster]'+CrLf+'||'+CrLf;
               If LocalMailType = LOCALMAILTYPE_INVALID then begin
                  BounceMsg:= BounceMsg + '|| '
                      + TrGl('Mailinfo', 'LocalSMTP.FailureNotice.InvalidRecipient',
                              'Invalid recipient') + ': ' + MailAddr + CRLF;
               end else begin // LOCALMAILTYPE_UNKNOWN
                  BounceMsg:= BounceMsg + '|| '
                      + TrGl('Mailinfo', 'LocalSMTP.FailureNotice.UnknownLocalRecipient',
                              'Unknown local recipient') + ': ' + MailAddr + CRLF
               end
            end;
            MailTo.Delete(DestNr); // remove local recipient from rcpt-list
         end else begin
            inc( DestNr )
         end
      end; // deliver to local recipients finished

      // deliver to remote recipients (i.e. save in Mail.Out)
      If MailTo.Count>0 then begin
         If MailType=mtPOP then begin
            //Delete headers added by Hamster-POP3-Client
            MailText.DeleteHeader(OUR_X_HEADER);
            MailText.DeleteHeader('X-Hamster-To:');
            s := '';
            for i:=0 to MailTo.Count-1 do begin
               If i > 0 then s := s + ',';
               s := s + MailTo[i];
            end;
            MailText.AddHeader('X-Resent-To:', s+' for external destination');
            MailText.AddHeader('X-Resent-By:',
               'Hamster-Mailrouter (' + IIf(Def_FQDN='', 'unknown FQDN', Def_FQDN)+')');
         end;

         // Mail.Out-Format:
         // - Setting !MAIL FROM:
         If IsMailAlias
            or (MailType IN [mtPOP, mtUnknown, mtInternal])
            or ((MailType=mtNews2Mail) and Def_Gate_UseHamsterEnvelope)
         then begin
            if Def_EnvelopeFrom > '' then begin
               s := EnvelopeMAILFROM
                    + MakeEnvelopeFormat(AppendFQDN(FilterEmailOfFrom(Def_EnvelopeFrom)))
                    + CRLF;
               MailText.AddHeader('Sender:', Def_EnvelopeFrom)
            end else begin
               AddToLog( LOGID_WARN, TrGl('Mailinfo', 'Mailrouter.NoEnvelopeFromSet',
                  'No envelope "From:" entry found in configuration.') );
               s := EnvelopeMAILFROM + MakeEnvelopeFormat(MailFrom) + CRLF
            end
         end else begin
            s := EnvelopeMAILFROM + MakeEnvelopeFormat(MailFrom) + CRLF;
         end;
         // - Setting !RCPT TO:
         for i:=0 to MailTo.Count-1 do begin
            s := s + EnvelopeRCPTTO + MakeEnvelopeFormat(MailTo[i]) + CRLF
         end;
         // - Save
         s := s + MailText.Text;
         // JAWO 06.01.03 (mail.out-Action bei xp2 local account)
         MailSource := msOutgoing;
         Account := '';
         // JAWO
         If SaveUniqueMailMsg( PATH_MAIL_OUT, s, GenerateMailMID, MailSource,
            false, '', '', FN, Account )
         then begin
            IncCounter( CntOutboxChk, 1 );
            ExecAction(FN, Account, MailSource)
         end else begin
            SetErrorResult('554 Transaction failed (couldn''t save in mail.out)')
         end
      end; // deliver to remote recipients finished

      // Set info about bounces
      if BounceMsg > '' then begin
         AddToLog( LOGID_Detail, 'mail from '+MailFrom+' to unknow local recipient will bounce');
         BounceMsg := BounceMsg + '|| '
            + TrGl('Mailinfo', 'MailFollows','Undelivered mail follows:') + CRLF + CRLF
            + MailText.Text;
         // detect double bounce
         if pos('<>',MailFrom)=0 then begin
            SendBounce(BounceType, MailFrom, BounceMsg)
         end else begin
            // set bounce destination to postmaster
            SendBounce(btAdmin, MailFrom, BounceMsg);
            AddToLog( LOGID_WARN, 'double bounce detected, suppressed and forward to postmaster' );
         end
      end;

      Result := AllRecipientsOK;
      if Result and (BounceMsg = '') then begin
         AddToLog( LOGID_Detail, 'Mail from '+MailFrom+' delivered to all recipients')
      end;
      If Result then begin
         fResultStr:='250 OK'
      end else begin
         If ResultStr='' then fResultStr:='554 Transaction failed (see Log)'
      end
   except
      on E: Exception do begin
         AddToLog( LOGID_ERROR, E.Message );
         Result:=False;
         fResultStr:='554 Transaction failed (Exception, see Log)'
      end
   end
end;

end.


