// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit dAbout; // Dialog: About ...

interface

uses SysUtils, ExtCtrls, Controls, StdCtrls, ComCtrls, Forms, Classes, uTools,
  Graphics, cStdForm;

type
  TDlgAbout = class(THForm)
    OKButton: TButton;
    pg: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    mLicence: TMemo;
    mCredits: TMemo;
    Panel1: TPanel;
    ProgramIcon: TImage;
    Bevel2: TBevel;
    Version: TLabel;
    Maintainer: TLabel;
    Download: TLabel;
    emDownload: TEdit;
    emVersion: TEdit;
    emMaintainer: TEdit;
    emProductName: TEdit;
    ProductName: TLabel;
    TabSheet4: TTabSheet;
    mAuthors: TMemo;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

Var
  DlgAbout: TDlgAbout = nil;

// ----------------------------------------------------------------------------

implementation

Uses Config, global;

{$R *.DFM}

Const

  InfoAuthors =
   '"Hamster-Classic" is based on "Hamster Vr. 1.3.21.0", which was released as ' +
   'Open Source in July 2000. The addition "-Classic" was used to distinguish it ' +
   'from other successors of Hamster.^m^m' +
   'The authors of "Hamster-Classic" are:^m' +
   '  Juergen Haible, <juergen.haible@t-online.de>^m'+
   '  Thomas G. Liesner, <tgl@gmx.de>^m'+
   '  Joern Weber <listen@joernweber.de>^m'+
   '  Heiko Studt <useHamster@myokay.net>^m'+
   '  Philipp Kern <mail@philkern.de>^m'+
   '  and many more...^m^m'+
   'See file Changes.txt for more details on who did what.';

  InfoLicence_a =
   '==============================================================^m' +
   'Hamster, a free news- and mailserver for personal, family and workgroup use. ' +
   'Copyright (c) 1999, Juergen Haible (<juergen.haible@t-online.de>).^m^m' +
   'Permission is hereby granted, free of charge, to any person obtaining a copy of this ' +
   'software and associated documentation files (the "Software"), to deal in the Software ' +
   'without restriction, including without limitation the rights to use, copy, modify, merge, ' +
   'publish, distribute, sublicense, and/or sell copies of the Software, and to permit ' +
   'persons to whom the Software is furnished to do so, subject to the following ' +
   'conditions:^m^m' +
   'The above copyright notice and this permission notice shall be included in all copies ' +
   'or substantial portions of the Software.^m^m';
  InfoLicence_b =
   'THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, ' +
   'EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES ' +
   'OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND ' +
   'NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT ' +
   'HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, ' +
   'WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING ' +
   'FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR ' +
   'OTHER DEALINGS IN THE SOFTWARE.^m' +
   '==============================================================';

  InfoCredits =
   'The "regular expression"-routines used in Hamster use a Win32-port of ' +
   '"Perl-Compatible Regular Expression (PCRE)" written by Philip Hazel ' +
   '(<ph10@cam.ac.uk>), Copyright (c) 1997-2000 by University of Cambridge (see ' +
   'ftp://ftp.csx.cam.ac.uk/pub/software/programming/pcre/ for more details).^m^m' +
   'Although the wrapper-class used for PCRE uses a slightly different approach, parts of ' +
   'it are at least inspired by the concepts used in "uperlre". "uperlre" is a wrapper-class ' +
   'for PCRE written by Luu Tran (<xnews@newsguy.com>), author of ' +
   '"XNews"-newsreader (see http://xnews.newsguy.com/ for more details).^m^m' +
   'Thanks! :-)';

  InfoOpenSSL =
   '^m^mThis product includes software developed by the OpenSSL Project for ' +
   'use in the OpenSSL Toolkit (http://www.openssl.org/). This product ' +
   'includes cryptographic software written by Eric Young (eay@cryptsoft.com). ' +
   'This product includes software written by Tim Hudson (tjh@cryptsoft.com).';

procedure TDlgAbout.FormCreate(Sender: TObject);
begin
   pg.ActivePage := pg.Pages[0];
   emProductName.Text := GetMyStringFileInfo( 'ProductName', 'Hamster'   );
   emMaintainer.Text  := GetMyStringFileInfo( 'Maintainer',  '(not set)' );
   emDownload.Text    := GetMyStringFileInfo( 'Download',  '(not set)' );
   emVersion.Text     := GetMyVersionInfo(true);
   mAuthors.Text := Tr('AuthorsV2', InfoAuthors);
   mLicence.Text := Tr('LicenceV1/a', InfoLicence_a) + Tr('LicenceV1/b', InfoLicence_b);

   if SSLReady then mLicence.Text := mLicence.Text + Tr('OpenSSL', InfoOpenSSL); {MG}{SSL}

   mCredits.Text := Tr('CreditsV2', InfoCredits);

   With emProductName.Font do begin Style := [fsBold]; Size := Size + 4 end;
   With emMaintainer.Font do Style := [fsBold];
   With emVersion.Font do Style := [fsBold];
   With emDownload.Font do Style := [fsBold];
end;

procedure TDlgAbout.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     Release;
     DlgAbout := nil;
end;

// ----------------------------------------------------------------------------

procedure TDlgAbout.Button1Click(Sender: TObject);
begin
   Help
end;

end.

