// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit dSplash; // Dialog: splash-window

interface

uses StdCtrls, Controls, ExtCtrls, Classes, Forms, Graphics, cStdForm;

type
  TDlgSplash = class(THForm)
    Msg: TStaticText;
    Bevel1: TBevel;
    Image1: TImage;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

procedure SplashOn( Const s: String );
procedure SplashOff;

// ----------------------------------------------------------------------------

implementation

{$R *.DFM}

Var
  DlgSplash: TDlgSplash = nil;

procedure SplashOn( Const s: String );
begin
   if not Assigned(DlgSplash) then DlgSplash := TDlgSplash.Create(Nil);
   DlgSplash.Msg.Caption := #13#10 + s;
   DlgSplash.Show;
   Application.ProcessMessages;
end;

procedure SplashOff;
begin
   if not Assigned( DlgSplash ) then exit;
   DlgSplash.Visible := False;
   DlgSplash.Release;
   DlgSplash := nil;
end;

procedure TDlgSplash.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   DlgSplash := nil;
   Release;
end;

// ----------------------------------------------------------------------------

end.
