// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit fAccount;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, cStdForm, ComCtrls;

Procedure DialogEditUser (Const UserID: Integer; Aliase: TStrings);
Procedure TestNewsAccess (Const sRead, sPost: String);
  
type
  TfrmAccount = class(THForm)
    btnOK: TButton;
    btnCancel: TButton;
    butHelp: TButton;
    pg: TPageControl;
    tsGeneral: TTabSheet;
    tsNews: TTabSheet;
    tsMailSettings: TTabSheet;
    tsRemoteControl: TTabSheet;
    Label2: TLabel;
    emUserName: TEdit;
    Label4: TLabel;
    emFullname: TEdit;
    emPassword: TEdit;
    Label3: TLabel;
    btnPasswordChange: TButton;
    Label8: TLabel;
    emGroup: TComboBox;
    Label6: TLabel;
    emNewsRead: TEdit;
    Label5: TLabel;
    emNewsPost: TEdit;
    chkNewsnews: TCheckBox;
    chkpeernews: TCheckBox;
    chkMailSend: TCheckBox;
    Label7: TLabel;
    emMailAddr: TEdit;
    labAdvancedSettings: TLabel;
    butTestNewsaccess: TButton;
    chkRemoteControl: TCheckBox;
    chkModeCancel: TCheckBox;
    chkAdvancedSettings: TCheckBox;
    rgLocalMB: TRadioGroup;
    labAliase: TLabel;
    procedure btnPasswordChangeClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure butTestNewsaccessClick(Sender: TObject);
    procedure chkAdvancedSettingsClick(Sender: TObject);
  private
    ID: Integer;
  end;

implementation

{$R *.DFM}

uses cAccount, cMailAlias, Global, Config, dInput, cServerNNTP;

Procedure DialogEditUser (Const UserID: Integer; Aliase: TStrings);
Var gr, Info, s, s2: String; p, i: Integer; bFirst: Boolean;
begin
   With TfrmAccount.Create(NIL) do try
      ID := UserID;
      With CfgAccounts do begin
         emUsername.Text := Value[ UserID, ACTP_USERNAME ];
         s :=  Trim(Value[ UserID, ACTP_PASSWORD ]);
         If s = '' then emPassword.Text:=TrGl(kGlobal, 'PW.None', '{NONE}')
                   else emPassword.Text:=TrGl(kGlobal, 'PW.Set', '{SET}');
         emFullname.Text := Value[ UserID, ACTP_FULLNAME ];
         emNewsPost.Text := Value[ UserID, ACTP_NEWSPOST ];
         emNewsRead.Text := Value[ UserID, ACTP_NEWSREAD ];
         emMailAddr.Text := Value[ UserID, ACTP_MAILADDR ];
         //chkMailBox.Checked  := ( Value[ UserID, ACTP_MAILBOX  ] = '1' );
         try {IMAP}
            rgLocalMB.itemindex := StrToInt( Value [ UserID, ACTP_MAILBOX  ] )
         except rgLocalMB.itemindex := 0 end;
         chkMailSend.Checked := ( Value[ UserID, ACTP_MAILSEND ] = '1' );
         chkpeernews.Checked := ( Value[ UserID, ACTP_NEWSPEER ] = '1' );
         chkNewsnews.Checked := ( Value[ UserID, ACTP_NEWNEWS ] = '1' );
         chkRemoteControl.Checked := ( Value[ UserID, ACTP_REMOTECONTROL ] = '1' );
         chkModeCancel.Checked := ( Value[ UserID, ACTP_CANCEL ] = '1' );
         if UserID=ACTID_ADMIN then begin
            if rgLocalMB.ItemIndex <> 1 then begin
               rgLocalMB.ItemIndex := 1;
               CfgAccounts.HasMailbox( UserID ); // create/remove mailbox
            end;
            rgLocalMB.Enabled := False
         end;
         {HSR} //Groups
         gr := Value[ UserID, ACTP_GROUP ];
         With emGroup do With Items do begin
            Clear;
            for i:=1 to CfgAccounts.GrpFile.ReadInteger( GRPM_SECTION, GRPM_GROUPMAX,1) do begin
              s := Grpfile.ReadString(GRPM_SECTION2,IntToStr(i),'');
              If s > '' then begin
                 p := Add(s);
                 If s = gr then ItemIndex := p
              end
            end
         end;
         { Aliases_Account }
         { Search entries, which ends with "=Username" and add first part }
         Info := '';
         s := LowerCase(Value[ UserID, ACTP_USERNAME ])+'=';
         bfirst := true;
         For i := 0 to Aliase.Count-1 do begin
            s2 := Trim(Aliase[i]);
            If (s2 > '') and (Not (s2[1] IN [';', '#', '/'])) then begin
               p := Pos(s, LowerCase(s2));
               If p=1 then begin
                  If bFirst then begin
                     Info := Info + Tr('Forward.to', 'Forward to: ');
                     bfirst := false
                  end else begin
                     Info := Info + ', '
                  end;
                  Info := Info + Trim(Copy(s2, Length(s)+1, Length(s2)))
               end
            end
         end;
         bfirst := true;
         s := '='+LowerCase(Value[ UserID, ACTP_USERNAME ]);
         For i := 0 to Aliase.Count-1 do begin
            s2 := Trim(Aliase[i]);
            If (s2 > '') and (Not (s2[1] IN [';', '#', '/'])) then begin
               p := Pos(s, LowerCase(s2));
               If (p > 0) and (p = Length(s2)-Length(s)+1) then begin
                  If bFirst then begin
                     If Info > '' then Info := Info + #13#10#13#10;
                     Info := Info + Tr('Aliases', 'Alias(es): ');
                     bfirst := false
                  end else begin
                     Info := Info + ', '
                  end;
                  Info := Info + Trim(Copy(s2, 1, p-1))
               end
            end
         end;
         labAliase.Caption := Info;
         {/HSR}
         if emUsername.text='admin' then emGroup.enabled:=false
      end;
      {/HSR}
      chkAdvancedSettings.Checked := Def_AdvancedConfiguration;
      If ShowModal = mrOK then begin
         With CfgAccounts do begin
            Value[ UserID, ACTP_FULLNAME ] := emFullname.Text;
            Value[ UserID, ACTP_NEWSPOST ] := emNewsPost.Text;
            Value[ UserID, ACTP_NEWSREAD ] := emNewsRead.Text;
            Value[ UserID, ACTP_MAILADDR ] := emMailAddr.Text;
            Value[ UserID, ACTP_GROUP    ] := emGroup.Text;           //HSR //Groups
            {IMAP}
            if Value[ UserID, ACTP_MAILBOX  ] <> IntToStr(rgLocalMB.itemindex) then begin
               if rgLocalMB.itemindex = 2 then InitIMAPMailbox( UserID );
               Value[ UserID, ACTP_MAILBOX  ] := IntToStr(rgLocalMB.itemindex);
            end;
            CfgAccounts.HasMailbox( UserID ); // create/remove mailbox
            if chkMailSend.Checked then Value[ UserID, ACTP_MAILSEND ]:='1'
                                   else Value[ UserID, ACTP_MAILSEND ]:='0';
            if chkpeernews.Checked then Value[ UserID, ACTP_NEWSPEER ]:='1'
                                   else Value[ UserID, ACTP_NEWSPEER ]:='0';
            if chkNewsnews.Checked then Value[ UserID, ACTP_NEWNEWS ]:='1'
                                   else Value[ UserID, ACTP_NEWNEWS ]:='0';
            If chkModeCancel.Checked then Value[ UserID, ACTP_CANCEL ] := '1'
                                     else Value[ UserID, ACTP_CANCEL ] := '0';
            if chkRemoteControl.Checked then Value[ UserID, ACTP_REMOTECONTROL ]:='1'
                                   else Value[ UserID, ACTP_REMOTECONTROL ]:='0';
         end
      end
   finally Free end
end;

procedure TfrmAccount.btnPasswordChangeClick(Sender: TObject);
var  P1, P2: String;
begin
     P1 := '';
     P2 := '';
     if not InputDlgPwd( TrGl(kGlobal,'DlgPWEdit.Caption', 'Change password'),
                         TrGl(kGlobal,'DlgPWEdit.PromptPW1', 'New password:'),
                         P1, 0{HlpChangePassword} ) then exit;
     if not InputDlgPwd( TrGl(kGlobal,'DlgPWEdit.Caption', 'Change password'),
                         TrGl(kGlobal,'DlgPWEdit.PromptPW2', 'Repeat new password:'),
                         P2, 0{HlpChangePassword} ) then exit;

     if P1<>P2 then begin
        Application.MessageBox( PChar(TrGl(kGlobal,'DlgPWEdit.DifferentPWs',
                                'Given passwords were not equal!^MPassword remains unchanged!')),
                                PChar(TrGl(kGlobal,'DlgPWEdit.Caption', 'Change password')),
                                MB_ICONEXCLAMATION );
        exit;
     end;

     CfgAccounts.Value[ ID, ACTP_PASSWORD ] := P1;
     if P1='' then emPassword.Text:=TrGl(kGlobal,'PW.None', '{NONE}')
              else emPassword.Text:=TrGl(kGlobal,'PW.Set', '{SET}');
end;

Var LastPage: Integer = 0;

procedure TfrmAccount.FormCreate(Sender: TObject);
begin
   pg.ActivePageIndex := LastPage
end;

procedure TfrmAccount.FormDestroy(Sender: TObject);
begin
   LastPage := pg.ActivePageIndex
end;

procedure TfrmAccount.butTestNewsaccessClick(Sender: TObject);
begin
   TestNewsAccess (emNewsRead.Text, emNewsPost.Text)
end;

Procedure TestNewsAccess (Const sRead, sPost: String);
Var s, sAnd, Info: String;
    slNo, slRead, slWrite: TStringlist;
    i: Integer;
begin
   slNo    := TStringList.Create;
   slRead  := TStringList.Create;
   slWrite := TStringList.Create;
   try
      slNo.sorted := true;
      slRead.sorted := true;
      slWrite.sorted := true;
      sAnd := TrGl(kGlobal, 'Test.NewsReadWrite.and', 'and');
      Info := '';
      For i := 0 to CfgHamster.ActiveCount-1 do begin
         s := CfgHamster.ActiveName[i];
         Case GetPermissionForGroup ( s, sPost, sRead ) of
            PERM_NOTH: slNo.Add (s);
            PERM_READ: slRead.Add (s);
            PERM_POST: slWrite.Add (s)
         end
      end;
      With slWrite do If Count > 0 then begin
         Info := TrGl(kGlobal, 'Test.Post.text', 'User can post into following groups') + ': ';
         For i := 0 to Count-2 do begin
            If i < Count-2 then Info := Info + Strings[i] + ', '
                           else Info := Info + Strings[i] + ' ' + sAnd + ' '
         end;
         Info := Info + Strings[Count-1];
         Application.MessageBox(
            PChar(Info),
            PChar(TrGl(kGlobal, 'Test.Post.caption', 'Groups matching read and post-regexp')),
            MB_ICONINFORMATION )
      end;
      With slRead do If Count > 0 then begin
         Info := TrGl(kGlobal, 'Test.Read.text', 'User can read following groups') + ': ';
         For i := 0 to Count-2 do begin
            If i < Count-2 then Info := Info + Strings[i] + ', '
                           else Info := Info + Strings[i] + ' ' + sAnd + ' '
         end;
         Info := Info + Strings[Count-1];
         Application.MessageBox(
            PChar(Info),
            PChar(TrGl(kGlobal, 'Test.Read.caption', 'Groups matching only read-regexp')),
            MB_ICONINFORMATION )
      end;
      With slNo do If Count > 0 then begin
         Info := TrGl(kGlobal, 'Test.NoAccess.text', 'User has no access to following groups') + ': ';
         For i := 0 to Count-2 do begin
            If i < Count-2 then Info := Info + Strings[i] + ', '
                           else Info := Info + Strings[i] + ' ' + sAnd + ' '
         end;
         Info := Info + Strings[Count-1];
         Application.MessageBox(
            PChar(Info),
            PChar(TrGl(kGlobal, 'Test.NoAccess.caption', 'Groups don''t matching read-regexp')),
            MB_ICONINFORMATION )
      end;
   finally
      slNo.Free;
      slRead.Free;
      slWrite.free
   end;
end;

procedure TfrmAccount.chkAdvancedSettingsClick(Sender: TObject);
Var b: Boolean;
begin
   b := chkAdvancedSettings.Checked;

   labAdvancedSettings.Visible := b;
   chkNewsNews.Visible := b;
   chkPeerNews.Visible := b;
   chkModeCancel.Visible := b;
   tsRemoteControl.TabVisible := b;
end;

end.
