unit fGroup;                                                               //HSR //Groups

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, cStdForm, ComCtrls;

type
  TfrmGroup = class(THForm)
    grpAccount: TGroupBox;
    emDescription: TEdit;
    GroupBox1: TGroupBox;
    btnOK: TButton;
    btnCancel: TButton;
    butHelp: TButton;
    pg: TPageControl;
    tsNews: TTabSheet;
    Label1: TLabel;
    Label9: TLabel;
    labAdvancedSettings: TLabel;
    chkNewsnews: TCheckBox;
    butTestNewsaccess: TButton;
    emNewsRead: TEdit;
    emNewsPost: TEdit;
    chkpeernews: TCheckBox;
    tsMailSettings: TTabSheet;
    Label7: TLabel;
    emMailAddr: TEdit;
    chkMailSend: TCheckBox;
    tsRemoteControl: TTabSheet;
    chkRemoteControl: TCheckBox;
    chkModeCancel: TCheckBox;
    chkAdvancedSettings: TCheckBox;
    rgLocalMB: TRadioGroup;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure butTestNewsaccessClick(Sender: TObject);
    procedure chkAdvancedSettingsClick(Sender: TObject);
  end;

Procedure DialogEditGroup (Const GroupID: Integer);

implementation
                        
uses
  cAccount, Global, Config, dInput, fAccount, inifiles;

{$R *.DFM}

Procedure DialogEditGroup (Const GroupID: Integer);
Var s: String;
begin
   With TFrmGroup.Create(NIL) do try
     With CfgAccounts do begin
        s  := ValueOfGroup[ GroupID, GRP_DESC     ];
        If s = '' then s := CfgAccounts.GrpFile.ReadString( GRPM_SECTION2, IntToStr(GroupID), '');
        emDescription.Text  := s;
        emNewsPost.Text     := ValueOfGroup[ GroupID, GRP_NEWSPOST ];
        emNewsRead.Text     := ValueOfGroup[ GroupID, GRP_NEWSREAD ];
        emMailAddr.Text     := ValueOfGroup[ GroupID, GRP_MAILADDR ];
        // chkMailBox.Checked  := ( ValueOfGroup[ GroupID, GRP_MAILBOX  ] = '1' );
        try {IMAP}
           rgLocalMB.itemindex := StrToInt( ValueOfGroup[ GroupID, GRP_MAILBOX  ] )
        except rgLocalMB.itemindex := 0 end;
        chkMailSend.Checked := ( ValueOfGroup[ GroupID, GRP_MAILSEND ] = '1' );
        chkPeerNews.Checked := ( ValueOfGroup[ GroupID, GRP_NEWSPEER ] = '1' );
        chkNewsNews.Checked := ( ValueOfGroup[ GroupID, GRP_NEWNEWS ] = '1' );
        chkModeCancel.Checked := ( ValueOfGroup[ GroupID, GRP_NEWSCANCEL ] = '1' );
        chkRemoteControl.Checked := ( ValueOfGroup[ GroupID, GRP_REMOTE ] = '1' )
     end;
     chkAdvancedSettings.Checked := Def_AdvancedConfiguration;
     If ShowModal = mrOk then begin
        With CfgAccounts do begin
           ValueOfGroup[ GroupID, GRP_DESC     ] := emDescription.Text;
           ValueOfGroup[ GroupID, GRP_NEWSPOST ] := emNewsPost.Text;
           ValueOfGroup[ GroupID, GRP_NEWSREAD ] := emNewsRead.Text;
           ValueOfGroup[ GroupID, GRP_MAILADDR ] := emMailAddr.Text;
           ValueOfGroup[ GroupID, GRP_MAILBOX  ] := IntToStr(rgLocalMB.itemindex); //IMAP
           if chkMailSend.Checked then ValueOfGroup[ GroupID, GRP_MAILSEND ]:='1'
                                  else ValueOfGroup[ GroupID, GRP_MAILSEND ]:='0';
           if chkpeernews.Checked then ValueOfGroup[ GroupID, GRP_NEWSPEER ]:='1'
                                  else ValueOfGroup[ GroupID, GRP_NEWSPEER ]:='0';
           If chkNewsNews.Checked then ValueOfGroup[ GroupID, GRP_NEWNEWS ]:='1'
                                  else ValueOfGroup[ GroupID, GRP_NEWNEWS ]:='0';
           If chkModeCancel.Checked then ValueOfGroup[ GroupID, GRP_NEWSCANCEL ]:='1'
                                  else ValueOfGroup[ GroupID, GRP_NEWSCANCEL ]:='0';
           If chkRemoteControl.Checked
                                  then ValueOfGroup[ GroupID, GRP_REMOTE ]:='1'
                                  else ValueOfGroup[ GroupID, GRP_REMOTE ]:='0';
        end
     end
   finally Free end
end;

Var Last: Integer = 0;

procedure TfrmGroup.FormCreate(Sender: TObject);
begin
   pg.ActivePageIndex := Last;
   labAdvancedSettings.Font.Style := [fsUnderline]
end;

procedure TfrmGroup.FormDestroy(Sender: TObject);
begin
   Last := pg.ActivePageIndex
end;

procedure TfrmGroup.butTestNewsaccessClick(Sender: TObject);
begin
   TestNewsAccess (emNewsRead.Text, emNewsPost.Text)
end;

procedure TfrmGroup.chkAdvancedSettingsClick(Sender: TObject);
Var b: Boolean;
begin
   b := chkAdvancedSettings.Checked;
   labAdvancedSettings.Visible := b;
   chkNewsNews.Visible := b;
   chkPeerNews.Visible := b;
   chkModeCancel.Visible := b;
   tsRemoteControl.TabVisible := b;
end;

end.
