unit uImapUtils;

interface

Uses Classes;

Procedure FindIMAPMails (Const Directory: String; Const List: TStrings; Const ShowIMAPSubDirs: boolean);

function  TrimQuotes( Data: String ): String;
function  TrimParentheses( Data: String ): String;
function  QuotedStringOrToken( s: String ): String;
function  NString( Data: String ): String;
procedure SplitString( SubStr: String; var Data: String; out Rest: String );
procedure SplitStringWhSpace( var Data: String; out Rest: String );
function  SwitchByteOrder( Input: Longint ): Longint; {MG}{IMAP-UID-ByteOrder}

// ----------------------------------------------------------------------------

implementation

uses uTools, SysUtils;

function TrimEnclosingChars( Data, FirstChar, LastChar: String ): String;
var  i: Integer;
begin
     Data := TrimWhSpace( Data );
     i := length( Data );
     if (i>1) and (Data[1] = FirstChar) and (Data[i] = LastChar) then
        Result := copy( Data, 2, i-2 )
     else
        Result := Data
end;

function TrimQuotes( Data: String ): String;
begin
     Result := TrimEnclosingChars( Data, '"', '"' )
end;

function TrimParentheses( Data: String ): String;
begin
     Result := TrimEnclosingChars( Data, '(', ')' )
end;

function QuotedStringOrToken( s: String ): String;
var  i : Integer;
begin
     s := TrimWhSpace( s );  // Bugfix
     i := Length(s);
     if (i > 1) and (s[1] = '"') then begin
        i := Pos( '"' , Copy(s,2,i-1) ) + 1;
        if i > 1 then begin                                   // Quoted string
            Result := Copy( s, 2, i-2 );
            exit
        end
     end;                                                      // Token
     i := PosWhSpace( s ) - 1;
     if i = -1 then i := Length(s);
     Result := Copy( s, 1, i );
end;

function NString( Data: String ): String;
Var i, j: Integer;
begin
   if Data = '' then begin
      Result := 'NIL'
   end else begin
      Result := '"';
      j := 1;
      // Escape quotes and backslashes: '"' -> '\"' and '\' -> '\\'
      for i := 1 to Length( Data ) do begin
         if Data[i] in ['"','\'] then begin
            Result := Result + Copy( Data, j, i-j ) + '\';
            j := i;
         end
      end;
      Result := Result + Copy( Data, j, Length(Data)-j+1 ) + '"'
   end
end;

procedure SplitStringIdx( Idx: Integer; var Data: String; out Rest: String );
begin
     if Idx > 0 then begin
        Rest := Copy( Data, Idx+1, Length(Data)-Idx );
        SetLength( Data, Idx-1 );
     end else Rest := '';
end;

procedure SplitString( SubStr: String; var Data: String; out Rest: String );
begin
     SplitStringIdx( Pos( SubStr, Data ), Data, Rest );
end;

procedure SplitStringWhSpace( var Data: String; out Rest: String );
begin
     SplitStringIdx( PosWhSpace( Data ), Data, Rest );
     TrimWhSpace( Rest );
end;

{MG}{IMAP-UID-ByteOrder}
function SwitchByteOrder( Input: Longint ): Longint;
begin
     Result :=  Input                shl 24 +
               (Input and $0000FF00) shl  8 +
               (Input and $00FF0000) shr  8 +
                Input                shr 24
end;
{/IMAP-UID-ByteOrder}

// ----------------------------------------------------------------------------

Procedure FindIMAPMails (Const Directory: String; Const List: TStrings; Const ShowIMAPSubDirs: boolean);
Var Root: String;

  Procedure Find ( Const Dir: String );
  Var r: TSearchRec;
  begin
     If FindFirst(Dir+'*.*', faAnyfile-faVolumeID, r) = 0 then try
        Repeat
           If (r.Attr and faDirectory) > 0 then begin
              If ShowIMAPSubDirs then begin
                 If (r.Name<>'.') and (r.Name<>'..') then Find(Dir+r.Name+'\')
              end
           end else If LowerCase(ExtractFileExt(r.Name))='.msg' then begin
              List.Add ( Copy ( Dir+r.Name, Length(Root)+1, Length(Dir+r.Name) ) )
           end
        until FindNext(r) <> 0
     finally
        FindClose(r)
     end
  end;

begin
   List.Clear;
   Root := IncludeTrailingBackSlash(Directory);
   Find (Root)
end;

end.