unit DEditDir;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, StdCtrls, ImgList, Menus, Clipbrd,
  cStdForm;

Const
  UA_UpdateList = WM_USER + 400;
  UA_UpdatePreview = WM_USER + 401;

Procedure DialogEditDir;
Procedure DialogEditDirClose;
Function  IsDialogEditDirOpen: boolean;
Procedure EmptyTrash;

Const
  DefColWidths =
     'Default=80 Newsgroups=140 Subject=180 Date=110 KB=40 Lines=40 To=130 From=130 Score=30 ';
type
  TShowFiles = (sfMsg, sfErr, sfAll);
  TPreviewTextAttr = (ptaNone, ptaAdd, ptaInstead);
  TImageIndex = (iiTrash, iiMailboxEmpty, iiMail, iiMailboxFull, iiMailOutFull,
                 iiNewsEmpty, iiNewsOutFull, iiNewsErrFull, iiMailOutEmpty,
                 iiTrashFull);
  TDirType = (dtDontExists, dtNews, dtMailPOP3, dtMailIMAP, dtTrash);
  TDlgEditDir = class(THForm)
    ilDirsBig: TImageList;
    lvDirs: TListView;
    Panel2: TPanel;
    Timer: TTimer;
    MainMenu1: TMainMenu;
    mnuFile: TMenuItem;
    mnuEdit: TMenuItem;
    mnuView: TMenuItem;
    mnuEditFile: TMenuItem;
    mnuDelete: TMenuItem;
    mnuCopy: TMenuItem;
    mnuRename: TMenuItem;
    N2: TMenuItem;
    mnuExplorer: TMenuItem;
    N3: TMenuItem;
    mnuExit: TMenuItem;
    mnuSelectAll: TMenuItem;
    mnuView1: TMenuItem;
    mnuView2: TMenuItem;
    mnuView3: TMenuItem;
    mnuPreviewState: TMenuItem;
    N5: TMenuItem;
    mnuSaveSortingSequence: TMenuItem;
    popLinks: TPopupMenu;
    popFile: TPopupMenu;
    mnupopEdit: TMenuItem;
    mnupopDelete: TMenuItem;
    mnupopRenameTo: TMenuItem;
    mnupopCopyAs: TMenuItem;
    mnuPreviewFixedPitchFont: TMenuItem;
    mnuPreviewAllHeader: TMenuItem;
    mnuPreviewWordwrap: TMenuItem;
    mnuROT13: TMenuItem;
    N1: TMenuItem;
    popPreview: TPopupMenu;
    mnupopCopytoClipboad: TMenuItem;
    mnupopSelectAll: TMenuItem;
    N6: TMenuItem;
    mnupopROT13: TMenuItem;
    N7: TMenuItem;
    mnupopFixedpitchfont: TMenuItem;
    mnupopAllHeader: TMenuItem;
    mnupopWordwrap: TMenuItem;
    mnuHelp: TMenuItem;
    mnuPreview: TMenuItem;
    N4: TMenuItem;
    mnuPreviewTextattributes: TMenuItem;
    Ignore1: TMenuItem;
    Formatbutshoworiginalcharstoo1: TMenuItem;
    Formatandsuppressoriginalchars1: TMenuItem;
    frFiles: TPanel;
    SplitFiles: TSplitter;
    lv: TListView;
    frFile: TPanel;
    mFile: TRichEdit;
    N8: TMenuItem;
    mnuSmallIcons: TMenuItem;
    ilDirsSmall: TImageList;
    mnuMoveTo: TMenuItem;
    popMoveTo: TPopupMenu;
    procedure FormCreate(Sender: TObject);
    procedure lvDirsResize(Sender: TObject);
    procedure chkShowAllClick(Sender: TObject);
    procedure lvColumnClick(Sender: TObject; Column: TListColumn);
    procedure lvCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure lvDblClick(Sender: TObject);
    procedure mnuEditFileClick(Sender: TObject);
    procedure mnuDeleteClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure mnuRunExplorerClick(Sender: TObject);
    procedure lvDirsDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure lvDirsDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure lvStartDrag(Sender: TObject; var DragObject: TDragObject);
    procedure lvEndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure mnuSelectAllClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);
    procedure lvKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure lvCustomDrawItem(Sender: TCustomListView; Item: TListItem;
      State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure lvDirsClick(Sender: TObject);
    procedure lvDirsKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure lvDirsChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure TimerTimer(Sender: TObject);
    procedure lvChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure mnuCopyAsClick(Sender: TObject);
    procedure mnuRenameToClick(Sender: TObject);
    procedure mnuView1Click(Sender: TObject);
    procedure mnuView2Click(Sender: TObject);
    procedure mnuView3Click(Sender: TObject);
    procedure mnuPreviewStateClick(Sender: TObject);
    procedure mnuViewClick(Sender: TObject);
    procedure mnuSaveSortingSequenceClick(Sender: TObject);
    procedure mFileMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure popLinksPopup(Sender: TObject);
    procedure mFileMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure mnuPreviewFixedPitchFontClick(Sender: TObject);
    procedure mnuPreviewAllHeaderClick(Sender: TObject);
    procedure mnuPreviewWordwrapClick(Sender: TObject);
    procedure mnuROT13Click(Sender: TObject);
    procedure mnuEditClick(Sender: TObject);
    procedure mnupopCopytoClipboadClick(Sender: TObject);
    procedure mnupopSelectAllClick(Sender: TObject);
    procedure popPreviewPopup(Sender: TObject);
    procedure Formatandsuppressoriginalchars1Click(Sender: TObject);
    procedure mnuPreviewTextattributesClick(Sender: TObject);
    procedure mnuPreviewClick(Sender: TObject);
    procedure mnuSmallIconsClick(Sender: TObject);
    procedure mnuMoveToClick(Sender: TObject);
    procedure SplitFilesMoved(Sender: TObject);
  private
    AspectListToPreview: Double;
    slFiles, slLinks: TStringList;
    LinkActiv, FixedPitchFont, ShowAllHeader,
       ShowIMAPSubDirs, WordWrap, SmallIcons, ShowTrash: Boolean;
    ShowFiles, LastShowFiles: TShowFiles;
    NewsShowHeaderList, MailShowHeaderList, Ueb,
       LastDir, Directory, LastFilename, InclMailboxes, ExclMailboxes: String;
    lIndex, ColumnToSort, NewsDefaultColumnSort, MailDefaultColumnSort: Integer;
    Preview, SortUp, NewsDefaultSortUp, MailDefaultSortUp,
       First, UserChange, WaitForShowList, WaitForShowFile: Boolean;
    MaxLines, Dateidatum, DirectoryID, MaxDirs: Integer;
    LastDirType: TDirType;
    PreviewTextAttr: TPreviewTextAttr;
    ColWidths: String;
    CheckDirHandle: Array of Word;
    Procedure Anzeige;
    Function CheckDirType (Const Dir: String): TDirType;
    procedure LoadData(Item: TListItem);
    procedure CopyLink(Sender: TObject);
    procedure OpenLink(Sender: TObject);
    procedure PreviewVisible(const Value: Boolean);
    procedure ShowFile (Const ReDraw: Boolean = false);
    procedure UpdateFile (Const ReDraw: Boolean = false);
    Procedure UAShowList (Var M: TMessage); message UA_UpdateList;
    Procedure UAShowFile (Var M: TMessage); message UA_UpdatePreview;
    procedure CheckMailState;
    procedure SetIconType(const b: Boolean);
    procedure PrepareDirectoryList;
    procedure DeleteItem(const AskFor, KillReally: Boolean);
    Procedure SetColWidth (Const Title: String; Const Value: Integer);
    Function  GetColWidth (Const Title: String): Integer;
    procedure SetColWidths;
    function  CopyFromDirectoryToDirEntryOK(LI: TListItem): Boolean;
    procedure ExecMoveToDir(Sender: TObject);
    procedure MoveFilesFromDirToDirEntry(LI: TListItem);
    Function  KillWhenDelete(const Dir: String): boolean;
    procedure Kill(const FileName: String; Const KillAlways: boolean);
    procedure CloseMailState;
    procedure InitMailState;
  protected
    Procedure CreateParams(var Params: TCreateParams); override;
  end;

implementation

Uses cArticle, cAccount, global, Config, uDateTime, uTools,
     ShellAPI, uImapUtils, cLogfile;

{$R *.DFM}

Var Dlg: TDlgEditDir;
    DlgOpen: Boolean;
    Lock: TRTLCriticalSection;

Function  IsDialogEditDirOpen: boolean;
begin
   EnterCriticalSection( Lock );
   try
      Result := DlgOpen
   finally
      LeaveCriticalSection( Lock );
   end
end;

Procedure DialogEditDir;
Var b: Boolean;
begin
   EnterCriticalSection( Lock );
   try
      If DlgOpen then begin
         b := true
      end else begin
         b := false;
         DlgOpen := true;
         Dlg := TDlgEditDir.Create(Application);
         Dlg.Ueb := Trim(Dlg.Caption);
      end;
      With Dlg do begin
         If b then BringToFront else Show;
         UserChange:= true;
         If Windowstate = wsMinimized then WindowState := wsNormal
      end
   finally
      LeaveCriticalSection( Lock );
   end
end;

Procedure DialogEditDirClose;
begin
   EnterCriticalSection( Lock );
   try
      If DlgOpen then begin
         DlgOpen := false;
         Dlg.Close
      end
   finally
      LeaveCriticalSection( Lock )
   end
end;

procedure TDlgEditDir.FormCreate(Sender: TObject);
Var idx, x, i, Col: Integer; Pre, s: String; Up: Boolean;
begin
   First := true;
   lv.DoubleBuffered := true;
   With CfgIni do begin
      Directory := LowerCase(ReadString('EditDirs', 'LastDir', PATH_NEWS_OUT));
      InclMailboxes := ReadString('EditDirs', 'Mailboxes', '');
      ExclMailboxes := ReadString('EditDirs', 'NoMailboxes', '');
      try
         ShowFiles := TShowFiles(ReadInteger('EditDirs', 'ShowFileTypes', 0))
      except ShowFiles := sfMsg end;
      ColWidths := ReadString('EditDirs', 'ColWidths', DefColWidths);
      Preview := ReadBool('EditDirs', 'ShowDirectly', true);
      Wordwrap := ReadBool('EditDirs', 'Preview_Wordwrap', false);
      mFile.WordWrap := Wordwrap;
      ShowTrash := ReadBool('EditDirs', 'ShowTrash', true);
      ShowAllHeader := ReadBool('EditDirs', 'Preview_AllHeader', false);
      SetIconType ( ReadBool('EditDirs', 'UseSmallIcons', false) );
      FixedPitchFont := ReadBool('EditDirs', 'Preview_FixedPitchFont', false);
      x := ReadInteger('EditDirs', 'UpdateIntervalms', 1000);
      If x < 100 then x := 100;
      Timer.Interval := x;
      MaxLines := 300;
      IRead ('EditDirs', 'Preview_MaxLines', MaxLines);
      ShowIMAPSubdirs := ReadBool ('EditDirs', 'ShowIMAPSubDirs', true);
      try
         PreviewTextAttr := TPreviewTextAttr(ReadInteger('EditDirs', 'Preview_TextAttr', Ord(ptaInstead)))
      except
         PreviewTextAttr := ptaInstead
      end;
      For idx := 0 to 1 do begin
         If idx = 0 then Pre := 'news.' else Pre := 'mail.';
         s := ReadString('EditDirs', pre+'ShowHeaders', '');
         If s = '' then begin
            s := 'Subject, From, To, CC, Newsgroups, Followup-To, Lines, Control, Supersedes, Message-ID, Date';
            WriteString('EditDirs', pre+'ShowHeaders', s)
         end;
         s := ','+LowerCase(s)+',';
         s := StringReplace ( s, #9, ' ', [rfReplaceAll]);
         s := StringReplace ( s, '  ', ' ', [rfReplaceAll]);
         s := StringReplace ( s, ', ', ',', [rfReplaceAll]);
         Col := ReadInteger ('EditDirs', pre+'DefColumnSort', -1);
         If (Col < 0) then begin
            Col := 0;
            WriteInteger ('EditDirs', pre+'DefColumnSort', Col)
         end;
         i := ReadInteger ('EditDirs', pre+'DefColumnSortUp', -1);
         If (i < 0) or (i > 1) then begin
            i := 1; WriteInteger ('EditDirs', pre+'DefColumnSortUp', i)
         end;
         Up := i > 0;
         If idx = 0 then begin
            NewsShowHeaderList := s;
            NewsDefaultColumnSort := Col;
            NewsDefaultSortUp := Up;
         end else begin
            MailShowHeaderList := s;
            MailDefaultColumnSort := Col;
            MailDefaultSortUp := Up;
         end;
      end;
      AspectListToPreview := ReadFloat('EditDirs', 'AspectListToPreview', 0.66) 
   end;
   If Not LoadWindowState ( Self, 'EditDirs' ) then begin
      Width := Screen.Width - 150;
      Height := Screen.Height - 150;
      Left := (Screen.Width - Width) div 2;
      Top := (Screen.Height - Height) div 2
   end;
   //ilDirs.AddIcon(Application.Icon);
   slFiles := TStringList.Create;
   slLinks := TStringList.Create;
   PrepareDirectoryList;
   CheckMailState
end;

Procedure TDlgEditDir.PrepareDirectoryList;
Var UserIDs: TStringList; p, i: Integer; s, s2: String;

   Procedure AddDir (Const ACaption, APath: String; Const AID: Integer;
      Const AImageIndex: TImageIndex);
   begin
      With lvDirs.Items.Add do begin
         Caption := ACaption;
         // Subitem 0: Full Path
         // Subitem 1: Account-ID only for mail-dirs
         // Subitem 2: Caption without count of msg/err-files
         SubItems.Add(LowerCase(IncludeTrailingBackslash(APath)));
         SubItems.Add(IntToStr(AID));
         SubItems.Add(ACaption);
         ImageIndex := Ord(AImageIndex)
      end
   end;

   Procedure AddMailDir (Const i: Integer);
   begin
      If Pos(','+LowerCase(UserIDs[i])+',', ','+LowerCase(ExclMailboxes)+',')>0 then Exit;
      AddDir ( UserIDs[i], PATH_MAILS + UserIDs[i],
         Integer(UserIDs.Objects[i]), iiMailboxEmpty )
   end;

Var ok: Boolean;
begin
   With lvDirs do begin
      Largeimages := ilDirsBig;
      Smallimages := ilDirsSmall;
      With Items do begin
         Clear;
         AddDir(Tr('Icon.News_Out', 'News.out'), PATH_NEWS_OUT, 0, iiNewsEmpty);
         AddDir(Tr('Icon.News_err', 'News.err'), PATH_NEWS_ERR, 0, iiNewsEmpty);
         AddDir(Tr('Icon.Mail_Out', 'Mail.out'), PATH_MAIL_OUT, 0, iiMailOutEmpty);
         UserIDs := TStringList.Create;
         try
            UserIDs.sorted := true;
            With CfgAccounts, Users do try
               Lock;
               For i := 0 to Count-1 do begin
                  If Users[i].UseMailboxtype IN [mbtPOP3, mbtIMAP] then begin
                     UserIDs.AddObject(Users[i].Username, Pointer(Users[i].ID))
                  end
               end
            finally
               Unlock
            end;
            If InclMailboxes > '' then begin
               s := InclMailboxes;
               Repeat
                  p := Pos(',', s);
                  If p > 0 then begin
                     s2 := Trim(Copy(s, 1, p-1));
                     System.Delete(s, 1, p)
                  end else begin
                     s2 := s; s := ''
                  end;
                  i := UserIDs.IndexOf(s2);
                  If i>=0 then AddMailDir(i)
               until s = ''
            end else begin
               For i := 0 to UserIDs.Count-1 do AddMailDir(i)
            end;
            If ShowTrash then AddDir(Tr('Icon.Trash', 'Trash!'), PATH_TRASH, 0, iiTrash);
            MaxDirs := Count-1;
            InitMailState
         finally
            UserIDs.free
         end
      end;
      ItemFocused := Items[0];
      ItemFocused.Selected := true;
      ok := false;
      For i := 0 to MaxDirs do begin
         If LowerCase(Directory) = LowerCase(Items[i].SubItems[0]) then begin
            ok := true;
            break
         end
      end;
      If Not ok then Directory := Items[0].SubItems[0]
   end;
   With lv do begin
      Largeimages := ilDirsBig;
      SmallImages := ilDirsBig;
   end
end;

procedure TDlgEditDir.lvDirsResize(Sender: TObject);
Var x, v: Integer;
begin
   v := (ClientHeight div 2);
   With lvDirs do begin
      If Items.Count > 0 then begin
         x := Items[Items.Count-1].DisplayRect(drBounds).Bottom + 10;
         If x > v then Height := v else Height := x
      end
   end
end;

Procedure TDlgEditDir.Anzeige;
begin
   If WaitForShowList then Exit;
   WaitForShowList := true;
   PostMessage(Handle, UA_UpdateList, 0, 0)
end;

procedure TDlgEditDir.chkShowAllClick(Sender: TObject);
begin
   If UserChange then Anzeige
end;

procedure TDlgEditDir.lvColumnClick(Sender: TObject; Column: TListColumn);
begin
   If Dlg = NIL then Exit;
   If Screen.ActiveForm = Self then Screen.Cursor := crHourglass;
   try
      If Dlg = NIL then Exit;
      If ColumnToSort = Column.Index
         then SortUp := Not SortUp
         else SortUp := true;
      ColumnToSort := Column.Index;
      (Sender as TCustomListView).AlphaSort
   finally
      Screen.Cursor := crDefault
   end
end;

procedure TDlgEditDir.lvCompare(Sender: TObject; Item1, Item2: TListItem;
  Data: Integer; var Compare: Integer);
Var ix, SortCol: Integer; D1, D2: TDateTime; Typ: String;
begin
  If ShowFiles = sfAll then SortCol := 0 else SortCol := ColumnToSort;
  if SortCol = 0 then
     Compare := CompareText(Item1.Caption,Item2.Caption)
  else begin
     LoadData (Item1);
     LoadData (Item2);
     ix := SortCol - 1;
     Typ := lv.Columns[SortCol].Caption;
     If Typ = 'Lines' then begin
        Compare := StrToInt('0'+Item1.SubItems[ix]) - StrToInt('0'+Item2.SubItems[ix]);
        If Compare <> 0 then Compare := Compare div Abs(Compare)
     end else
     If Typ = 'KB' then begin
        Compare := Sgn(StrToFloat2(Item1.SubItems[ix]) - StrToFloat2(Item2.SubItems[ix]));
        If Compare <> 0 then Compare := Compare div Abs(Compare)
     end else
     If Typ = 'Date' then begin
        D1 := RfcDateTimeToDateTimeGMT( Item1.SubItems[ix], NowGMT );
        D2 := RfcDateTimeToDateTimeGMT( Item2.SubItems[ix], NowGMT );
        If D1 > D2 then Compare := 1
        else If D1 < D2 then Compare := -1
        else Compare := 0
     end else
     If Typ = 'Score' then begin
        Compare := StrToInt(Item1.SubItems[ix]) - StrToInt(Item2.SubItems[ix]);
        If Compare <> 0 then Compare := Compare div Abs(Compare)
     end else begin
        Compare := CompareText(Item1.SubItems[ix],Item2.SubItems[ix])
     end
  end;
  If Not SortUp then Compare := -Compare
end;

procedure TDlgEditDir.lvDblClick(Sender: TObject);
begin
   If Assigned(lv.ItemFocused) then EditFile(Directory + lv.ItemFocused.Caption)
end;

procedure TDlgEditDir.mnuEditFileClick(Sender: TObject);
Var i: integer;
begin
   With lv do begin
      For i := 0 to Items.Count-1 do With Items[i] do begin
         If selected then EditFile(Directory + Caption)
      end
   end
end;

procedure TDlgEditDir.mnuDeleteClick(Sender: TObject);
begin
   DeleteItem (true, false)
end;

procedure TDlgEditDir.DeleteItem(Const AskFor, KillReally: Boolean);
Var i, offs: Integer; Question: String;
begin
   With lv do begin
      If SelCount = 0 then begin
         If ItemFocused <> NIL
            then ItemFocused.Selected := true
            else Exit
      end;
      If KillWhenDelete(Directory) or KillReally
         then Question := TrF('Delete.Ask', 'Do you really want to delete this/these %s file(s) now?',
                          IntToStr(SelCount))
         else Question := TrF('MoveToTrash.Ask', 'Move this/these %s file(s) into the trash now?',
                          IntToStr(SelCount));
      if (Not AskFor) or (MessageBox( Handle,
         PChar(Question),
         PChar(Tr('Delete.Caption', 'Delete file(s)'))
         , MB_ICONQUESTION or MB_YESNO ) = IDYES)
      then begin
         offs := 0;
         For i := 0 to Items.Count-1 do With Items[i-offs] do begin
            If selected then begin
               Kill ( Directory + Caption, KillReally );
               Delete;
               Inc(offs)
            end
         end;
         CheckMailState
      end
   end
end;

procedure TDlgEditDir.FormResize(Sender: TObject);
begin
   frFile.Width := Round(ClientWidth * AspectListToPreview)
end;

procedure TDlgEditDir.mnuRunExplorerClick(Sender: TObject);
begin
   ShellExecute ( Application.handle, PChar('open'), PChar('Explorer'), PChar('"'+Directory+'"'), NIL, SW_SHOWNORMAL )
end;

procedure TDlgEditDir.lvDirsDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
Var LI: TListItem;
begin
   Accept := false;
   // Check Source
   // - Must be file-list
   If Source <> lv then Exit;
   // Check Destination
   LI := (Sender as TListView).GetItemAt (x, y);
   // - exists?
   If Not Assigned(LI) then Exit;
   // Check default-tests
   Accept := CopyFromDirectoryToDirEntryOK(LI)
end;

Function TDlgEditDir.CopyFromDirectoryToDirEntryOK (LI: TListItem): Boolean;
Var DestDir: String;
begin
   Result := false;
   // Check Source
   // - IMAP not allowed
   If CheckDirType(Directory)=dtMailIMAP then Exit;
   // Check Destination
   // - exists?
   If Not Assigned(LI) then Exit;
   // - Source <> destination
   If LI.selected then exit;
   // - Only from News to News or Mail to Mail, if not all files active
   DestDir := LI.SubItems[0];
   If DestDir <> LowerCase(PATH_TRASH) then begin
      If ( Directory <> LowerCase(PATH_TRASH) ) and ( ShowFiles <> sfAll ) then begin
         If CheckDirType(DestDir)<>CheckDirType(Directory) then Exit
      end;
      // - Not into IMAP-directories
      If CheckDirType(DestDir)=dtMailIMAP then exit
   end;
   // All ok!
   Result := true
end;

procedure TDlgEditDir.lvDirsDragDrop(Sender, Source: TObject; X,
  Y: Integer);
Var LI: TListItem;
begin
   LI := (Sender as TListView).GetItemAt (x, y);
   If LI.SubItems[0]=''
      then mnuDeleteClick (NIL)
      else MoveFilesFromDirToDirEntry (LI)
end;

function TDlgEditDir.CheckDirType(const Dir: String): TDirType;
Var s, s2: String; i, ID: Integer; AktItem: TListItem;
begin
   s := IncludeTrailingBackslash(UpperCase(Dir));
   If (s = UpperCase(PATH_NEWS_OUT)) or (s = UpperCase(PATH_NEWS_ERR)) then
      Result := dtNews
   else If s = UpperCase(PATH_TRASH) then
      Result := dtTrash
   else begin
      Result := dtMailPOP3;
      AktItem := NIL;
      With lvDirs, Items do begin
         For i := 0 to Count-1 do begin
            If Items[i].SubItems[0] = Dir then begin
               AktItem := Items[i];
               break
            end
         end
      end;
      If Assigned(AktItem) then begin
         s2 := AktItem.SubItems[1];
         If s2 > '' then begin
            ID := StrToInt(s2);
            With CfgAccounts do try
               Lock;
               If Assigned(Users.Find(ID)) then
                  If Users.Find(ID).UseMailboxtype = mbtIMAP
                     then Result := dtMailIMAP
            finally
               Unlock
            end
         end
      end else begin
         Result := dtDontExists
      end
   end
end;

procedure TDlgEditDir.lvStartDrag(Sender: TObject;
  var DragObject: TDragObject);
begin
   UserChange := false
end;

procedure TDlgEditDir.lvEndDrag(Sender, Target: TObject; X, Y: Integer);
begin
   UserChange := true
end;

procedure TDlgEditDir.mnuSelectAllClick(Sender: TObject);
Var i: Integer;
begin
   With lv do begin
      For i := 0 to Items.Count-1 do With Items[i] do begin
         If Not selected then selected := true
      end
   end
end;

procedure TDlgEditDir.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   EnterCriticalSection( Lock );
   try
      If Self = dlg then begin
         DlgOpen := false;
         dlg := NIL
      end;
      Timer.Enabled := false;
      {Application.ProcessMessages;}
      Action := caFree
   finally
      LeaveCriticalSection( Lock )
   end
end;

procedure TDlgEditDir.FormDestroy(Sender: TObject);
begin
   CloseMailState;
   slLinks.Free;
   slFiles.Free;
end;

procedure TDlgEditDir.mnuExitClick(Sender: TObject);
begin
   Close
end;

procedure TDlgEditDir.lvKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
Var p: Integer; KeyState: TShiftState;
begin
   KeyState := Shift * [ssShift, ssAlt, ssCtrl];
   Case Key of
      VK_DELETE:
         If KeyState = [] then begin
            Key := 0; DeleteItem(true, false)
         end else
         If KeyState = [ssCtrl] then begin
            Key := 0; DeleteItem(true, true)
         end else
         If KeyState = [ssShift] then begin
            Key := 0; DeleteItem(false, false)
         end else
         If KeyState = [ssShift, ssCtrl] then begin
            Key := 0; DeleteItem(false, true)
         end;
      VK_RETURN: If KeyState = [] then begin Key := 0; lvDblClick (NIL) end;
      VK_LEFT: If KeyState = [] then begin
         Key := 0; p := lvDirs.ItemFocused.Index - 1;
         If p >= 0 then begin
            lvDirs.ItemFocused := lvDirs.Items[p];
            lvDirs.ItemFocused.Selected := true
         end
      end;
      VK_RIGHT: If KeyState = [] then begin
         Key := 0; p := lvDirs.ItemFocused.Index + 1;
         If p <= MaxDirs then begin // No way to bin
            lvDirs.ItemFocused := lvDirs.Items[p];
            lvDirs.ItemFocused.Selected := true
         end
      end;
   end
end;

procedure TDlgEditDir.FormShow(Sender: TObject);
begin
   Anzeige
end;

Procedure TDlgEditDir.LoadData (Item: TListItem);
Var tf: textfile;
    Typ, s: String;
    i, x, p, Sc: Integer;
begin
   If ShowFiles <> sfAll then begin
      If Item.SubItems.Count <> lv.Columns.Count - 1 then begin
         AssignFile(tf, Directory+Item.Caption);
         FileMode := 0;
         try
            Reset(tf)
         except
            exit
         end;
         With TArticle.Create do try
            x := 0;
            While Not EOF(tf) do begin
               Readln(tf, s);
               If s = '' then break;
               Inc(x);
               If x > 80 then break;
               AddHeader (s)
            end;
            MimeDecodeHeaders;
            For i := 1 to lv.Columns.Count - 1 do begin
               If Item.SubItems.Count<i then begin
                  Typ := lv.Columns[i].Caption;
                  If Typ = 'KB' then begin
                     Item.SubItems.Add (FormatFloat(',0.0', FileSize(Directory+Item.Caption)/1024))
                  end else
                  If Typ = 'Score' then begin
                     s := Header['X-Hamster-Info'];
                     Sc := 0;
                     If s > '' then begin
                        p := Pos('Score=', s);
                        If p > 0 then begin
                           Delete(s, 1, p+5);
                           p := Pos(' ', s);
                           If p > 1 then begin
                              try Sc := StrToInt(Copy(s, 1, p-1)) except end
                           end
                        end
                     end;
                     Item.SubItems.Add (IntToStr(Sc))
                  end
                  else Item.SubItems.Add (Header[Typ])
               end
            end;
         finally Free end;
         CloseFile (tf)
      end
   end
end;

procedure TDlgEditDir.lvCustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
   DefaultDraw:=true;
   LoadData (Item)
end;

procedure TDlgEditDir.lvDirsClick(Sender: TObject);
begin
   If Not UserChange then Exit;
   UserChange := false;
   try
      try
         If lvDirs.ItemFocused = NIL then Exit;
         If lvDirs.ItemFocused.SubItems.Count = 0 then Exit;
         Directory := lvDirs.ItemFocused.SubItems[0];
      except
         Directory := ''
      end;
      Anzeige
   finally
      UserChange := true
   end
end;

procedure TDlgEditDir.lvDirsKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   lvDirsClick (NIL)
end;

procedure TDlgEditDir.lvDirsChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
   If Change = ctState then lvDirsClick(NIL)
end;

procedure TDlgEditDir.TimerTimer(Sender: TObject);
begin
   CheckMailstate;
   Anzeige
end;

procedure TDlgEditDir.lvChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
   ShowFile
end;

Procedure TDlgEditDir.PreviewVisible(Const Value: Boolean);
begin
   If frFile.Visible = Value then Exit;
   frFile.Visible := false;
   SplitFiles.Visible := false;
   frFile.Visible := Value;
   SplitFiles.Visible := Value;
end;

Procedure TDlgEditDir.ShowFile (Const ReDraw: Boolean = false);
begin
   If WaitForShowFile then Exit;
   WaitForShowFile := true;
   PostMessage(Handle, UA_UpdatePreview, Ord(Redraw), 0)
end;
procedure TDlgEditDir.UpdateFile(const ReDraw: Boolean);
begin
   If WaitForShowFile then Exit;
   WaitForShowFile := true;
   PostMessage(Handle, UA_UpdatePreview, Ord(Redraw), 1)
end;


procedure TDlgEditDir.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
   With CfgIni do begin
      WriteString('EditDirs', 'LastDir', Directory);
      SetColWidths;
      WriteString('EditDirs', 'ColWidths', ColWidths);
      WriteInteger('EditDirs', 'ShowFileTypes', Ord(ShowFiles));
      WriteBool('EditDirs', 'ShowDirectly', Preview);
      WriteBool('EditDirs', 'Preview_Wordwrap', Wordwrap);
      WriteBool('EditDirs', 'Preview_AllHeader', ShowAllHeader);
      WriteBool('EditDirs', 'Preview_FixedPitchFont', FixedPitchFont);
      WriteBool('EditDirs', 'UseSmallIcons', SmallIcons);
      WriteBool('EditDirs', 'ShowIMAPSubDirs', ShowIMAPSubdirs);
      WriteInteger('EditDirs', 'Preview_TextAttr', Ord(PreviewTextAttr));
      WriteFloat ('EditDirs', 'AspectListToPreview', AspectListToPreview)
   end;
   SaveWindowState ( Self, 'EditDirs' );
end;

procedure TDlgEditDir.mnuCopyAsClick(Sender: TObject);
Var Alt, Neu: String; i: Integer;
begin
   With TStringList.Create do try
      For i := 0 to lv.Items.Count-1 do
         If lv.Items[i].selected
            then Add(lv.Items[i].Caption);
      For i := 0 to Count-1 do begin
         Alt := Directory + Strings[i];
         Neu := Alt;
         If InputQuery ( 'Copy To', 'Filename:', Neu) then begin
            If Neu <> Alt then begin
               If FileExists2(Neu) then
                  ShowMessage('There is already a file with this filename -> Abort!')
               else begin
                  If Not CopyFile ( PChar(Alt), PChar(Neu), false ) then begin
                     ShowMessage ('Error when copy!')
                  end
               end
            end
         end
      end;
      CheckMailState
   finally
      free
   end
end;

procedure TDlgEditDir.mnuRenameToClick(Sender: TObject);
Var Alt, Neu: String; i: Integer;
begin
   With TStringList.Create do try
      For i := 0 to lv.Items.Count-1 do
         If lv.Items[i].selected
            then Add(lv.Items[i].Caption);
      For i := 0 to Count-1 do begin
         Alt := Strings[i];
         Neu := Alt;
         If InputQuery ( 'Rename to', 'New filename:', Neu) then begin
            If Neu <> Alt then begin
               If FileExists2(Directory + Neu) then
                  ShowMessage('There is already a file with this filename -> Abort!')
               else begin
                  If Not RenameFile ( Directory + Alt, Directory + Neu ) then begin
                     ShowMessage ('Error when rename!')
                  end
               end
            end
         end
      end;
      CheckMailState
   finally
      free
   end
end;

procedure TDlgEditDir.mnuView1Click(Sender: TObject);
begin
   ShowFiles := sfMsg;
   Anzeige
end;

procedure TDlgEditDir.mnuView2Click(Sender: TObject);
begin
   ShowFiles := sfErr;
   Anzeige
end;

procedure TDlgEditDir.mnuView3Click(Sender: TObject);
begin
   ShowFiles := sfAll;
   Anzeige
end;

procedure TDlgEditDir.mnuPreviewStateClick(Sender: TObject);
begin
   Preview := Not Preview;
   Anzeige;
   ShowFile
end;

procedure TDlgEditDir.mnuViewClick(Sender: TObject);
Var Col: Integer; up: Boolean; Typ: TDirType;
begin
   Typ := CheckDirType(Directory);
   Case Typ of
      dtNews: begin Col := NewsDefaultColumnSort; up := NewsDefaultSortUp end;
      else begin Col := MailDefaultColumnSort; up := MailDefaultSortUp end;
   end;
   mnuSaveSortingSequence.Enabled := (Typ<>dtTrash)
      and ((Col <> ColumnToSort) or (up <> SortUp));
   mnuView1.Checked := ShowFiles = sfMsg;
   mnuView2.Checked := ShowFiles = sfErr;
   mnuView3.Checked := ShowFiles = sfAll;
   mnuSmallIcons.Checked := SmallIcons
end;

procedure TDlgEditDir.mnuSaveSortingSequenceClick(Sender: TObject);
Var Col: Integer; up: Boolean; Pre: String;
begin
   Case CheckDirType(Directory) of
     dtNews: begin
         Pre := 'news.';
         Col := ColumnToSort;
         up := SortUp;
         NewsDefaultColumnSort := Col;
         NewsDefaultSortUp := up
     end;
     dtMailPOP3, dtMailIMAP: begin
        Pre := 'mail.';
        Col := ColumnToSort;
        up := SortUp;
        MailDefaultColumnSort := Col;
        MailDefaultSortUp := up
     end;
     else exit
   end;
   With CfgIni do begin
      WriteInteger ('EditDirs', pre+'DefColumnSort', Col);
      If up
         then WriteInteger ('EditDirs', pre+'DefColumnSortUp', 1)
         else WriteInteger ('EditDirs', pre+'DefColumnSortUp', 0)
   end
end;

// ------------------ Find and run Links -----------------------

Function CheckLink (Const Wort : String; Links: TStrings): Boolean;
Var s, v: String;
begin
   Result := false;
   s := Wort;
   If Copy(s,1,1)='"' then Delete(s, 1, 1);
   If Length(s)>1 then If s[Length(s)]='"' then Delete(s, Length(s), 1);
   If s = '' then Exit;
   If Length(s)>3 then begin
      If (s[1]='<') and (s[Length(s)-1]='>') then s := Copy ( s, 2, Length(s)-3 )
      else
      If (s[1]='<') and (s[Length(s)]='>') then s := Copy ( s, 2, Length(s)-2 )
   end;
   v := LowerCase(s);
   Links.Clear;
   If (copy(v,1,7)='http://')
       OR (copy(v,1,6)='ftp://')
       OR (copy(v,1,6)='file://')
       OR (copy(v,1,5)='news:')
       OR (copy(v,1,7)='mailto:')
   then begin
      Links.Add (s)
   end;
   If pos('@',v)>0 then begin
      Links.Add ('mailto:'+s);
      Links.Add ('news:'+s)
   end else
   If pos('www.',v)=1 then begin
      Links.Add ('http://'+s)
   end;
   Result := Links.Count > 0
end;

procedure TDlgEditDir.mFileMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
Var i, Wert, LineNumber, LinePos: Integer; Line, Wort: String;
    Point: TPoint; re: TRichedit;
begin
   slLinks.Clear;
   If Sender is TRichedit then re := TRichedit(Sender) else exit;
   // Get absolute position of character beneath mouse
   Point.x:= X; Point.y:= Y;
   Wert := re.Perform(EM_CHARFROMPOS, 0, LParam(@Point));
   if Wert >= 0 then begin
      LineNumber:= re.Perform(EM_LINEFROMCHAR, Wert, 0);
      LinePos:= Wert - re.Perform(EM_LINEINDEX, LineNumber, 0);
      Line:= re.Lines[LineNumber];
      If (LinePos = 0) or (LinePos > Length(Line)) then Exit;
      If Line[LinePos] IN [#9, ' '] then Exit;
      For i := LinePos+1 to Length(Line) do If Line[i] IN [#9, ' '] then begin
         Delete(Line, i, Length(Line)); break
      end;
      For i := LinePos-1 downto 1 do If Line[i] IN [#9, ' '] then begin
         Delete(Line, 1, i); break
      end;
      Wort := Line;
      if (length(wort)>2) and (Linepos<>Length(re.Lines[LineNumber])) and CheckLink(Wort, slLinks) then begin
         re.Cursor := crHandPoint; re.Hint := Wort;
         LinkActiv := true
      end else begin
         re.Cursor := crDefault; re.Hint := ''
      end;
      //Application.CancelHint;
      Application.ActivateHint (Point)
   end else begin
      re.Cursor := crDefault;
   end
end;

procedure TDlgEditDir.popLinksPopup(Sender: TObject);
Var M: TMenuItem; i: Integer;
begin
   With popLinks, Items do begin
      Clear;
      For i := 0 to slLinks.Count-1 do begin
         M := TMenuItem.Create(popLinks);
         M.Caption := 'Open <'+slLinks[i]+'>';
         M.Tag := i; M.OnClick := OpenLink;
         Add (M)
      end;
      If slLinks.Count > 1 then begin
         M := TMenuItem.Create(popLinks);
         M.Caption := '-';
         Add (M)
      end;
      For i := 0 to slLinks.Count-1 do begin
         M := TMenuItem.Create(popLinks);
         M.Caption := 'Copy <'+slLinks[i]+'>';
         M.Tag := i; M.OnClick := CopyLink;
         Add (M)
      end;
   end
end;

procedure TDlgEditDir.mFileMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
Var p: TPoint;
begin
   If LinkActiv then If slLinks.Count > 0 then begin
      LinkActiv := false;
      p.x := x; p.y := y;
      p := mFile.ClientToScreen(p);
      popLinks.Popup (p.x, p.y)
   end
end;

procedure TDlgEditDir.OpenLink(Sender: TObject);
Var x: Integer;
begin
   If Not (Sender is TMenuItem) then Exit;
   x := (Sender as TMenuItem).Tag;
   If Tag < slLinks.Count then begin
      ShellExecute(Handle, 'open', PChar(slLinks[x]), nil, nil, SW_SHOWNORMAL);
   end
end;

procedure TDlgEditDir.CopyLink(Sender: TObject);
Var x: Integer;
begin
   If Not (Sender is TMenuItem) then Exit;
   x := (Sender as TMenuItem).Tag;
   If Tag < slLinks.Count then Clipboard.AsText := slLinks[x]
end;

// -------------------------------

procedure TDlgEditDir.FormKeyPress(Sender: TObject; var Key: Char);
begin
   If Key = #27 then begin
      If frFile.Visible
         then PreviewVisible (false)
         else Close;
      Key := #0
   end
end;

procedure TDlgEditDir.mnuPreviewFixedPitchFontClick(Sender: TObject);
begin
   FixedPitchFont := Not FixedPitchFont;
   ShowFile (true)
end;

procedure TDlgEditDir.mnuPreviewAllHeaderClick(Sender: TObject);
begin
   ShowAllHeader := Not ShowAllHeader;
   ShowFile (true)
end;

procedure TDlgEditDir.mnuPreviewWordwrapClick(Sender: TObject);
begin
   Wordwrap := Not WordWrap;
   mFile.WordWrap := Wordwrap
end;

procedure TDlgEditDir.mnuROT13Click(Sender: TObject);
Var z, i, Start, Len, AnfZeile, EndZeile, AnfSpalte, EndSpalte, von, bis: Integer;
    c: char; s: String;
begin
   If frFile.Visible then begin
      With mFile do begin
         Start := SelStart;
         Len := SelLength;
         AnfZeile := SendMessage (Handle, EM_LINEFROMCHAR, Start, 0);
         AnfSpalte := Start - SendMessage (Handle, EM_LINEINDEX, AnfZeile, 0) + 1;
         EndZeile := SendMessage (Handle, EM_LINEFROMCHAR, Start+Len-1, 0);
         EndSpalte := Start+Len-1 - SendMessage (Handle, EM_LINEINDEX, EndZeile, 0) + 1;
         For Z := AnfZeile to EndZeile do begin
            s := Lines[z];
            If s > '' then begin
               If Z = AnfZeile then von := AnfSpalte else von := 1;
               If Z = EndZeile then bis := Endspalte else bis := Length(s);
               For i := von to bis do begin
                  c := s[i];
                  Case UpCase(c) of
                     'A'..'M': s[i] := Chr(Ord(c)+13);
                     'N'..'Z': s[i] := Chr(Ord(c)-13);
                  end
               end;
               Lines[z] := s
            end
         end;
         SelStart := Start;
         SelLength := Len;
      end
   end
end;

procedure TDlgEditDir.mnuEditClick(Sender: TObject);
begin
   mnuROT13.Enabled := frFile.visible
end;

procedure TDlgEditDir.mnupopCopytoClipboadClick(Sender: TObject);
Var p: Integer;
begin
   With mFile do begin
      If SelText > '' then begin
         CopyToClipboard
      end else begin
         p := SelStart;
         SelectAll;
         CopyToClipboard;
         SelStart := p
      end
   end
end;

procedure TDlgEditDir.mnupopSelectAllClick(Sender: TObject);
begin
   mFile.SelectAll
end;

procedure TDlgEditDir.popPreviewPopup(Sender: TObject);
begin
   mnuPopFixedPitchFont.Checked := FixedPitchFont;
   mnuPopAllHeader.Checked := ShowAllHeader;
   mnuPopWordwrap.Checked := WordWrap;
end;

Function ExtIsPreviewAble (Const s: String): Boolean;
Var e: String;
begin
   e := LowerCase(ExtractFileExt(s));
   Result := (e='.msg') or (e='.err')
end;

procedure TDlgEditDir.UAShowFile(var M: TMessage);
Type
    TWordStyle = (wsFirst, wsDefault, wsBold, wsItalic, wsUnderlined);
Var FileName, s, s2, cSep: String;
    LastStyle, Style: TWordStyle;
    p, z, Einr, i: Integer;
    OnlyUpdate, Redraw, bBody, bChosen, bQP, b: Boolean;
    slTemp: TStringList;

    Function Hex2Dez(Const c: Char): Byte;
    begin
       Case c of
         '1'..'9': Result := Ord(c)-Ord('0');
         'a'..'f': Result := Ord(c)-Ord('a')+10;
         'A'..'F': Result := Ord(c)-Ord('A')+10;
         else Result := 0
       end
    end;

Var f: Textfile;    
begin
   If Dlg = NIL then Exit;
   WaitForShowFile := false;
   Redraw := Boolean(M.wParam);
   OnlyUpdate := M.lParam = 1;
   slTemp := TStringList.Create;
   try
      If ReDraw then LastFileName := '';
      If (lastFileName > '') and (FileAge(LastFileName)<>Dateidatum) then LastFileName := '';

      {Application.ProcessMessages;
      If Dlg = NIL then Exit;}
      If Assigned(lv.ItemFocused)
         then FileName := Directory + lv.ItemFocused.Caption
         else FileName := '';
      If OnlyUpdate then begin
         bChosen := frFile.Visible and FileExists2(FileName)
               and Preview and ExtIsPreviewAble(FileName)
      end else begin
         bChosen := (FileName > '') and FileExists2(FileName)
            and Preview and ExtIsPreviewAble(FileName)
      end;
      If (Not bChosen) and frFile.Visible then
         PreviewVisible (false)
      else If bChosen then begin
         PreviewVisible (true);
         If FileName <> LastFilename then begin
            LastFilename := FileName;
            Dateidatum := FileAge(LastFileName);
            FileMode := 0;
            AssignFile( f, FileName );
            FileMode := 0;
            try
               Reset (f);
            except
               With mFile, Lines do try
                  BeginUpdate;
                  SetFontFixed ( mFile.Font, FixedPitchFont );
                  Clear;
                  SelAttributes.Color := clRed;
                  Lines.Add ('<<< This file can not be opened now >>>');
               finally
                  EndUpdate
               end;
               Abort;
            end;
            z := 0;
            bBody := false; bQP := false; b := true;
            try
               mFile.Lines.BeginUpdate;
               SetFontFixed ( mFile.Font, FixedPitchFont );
               mFile.Clear;
               While Not EOF(F) do begin
                  If bBody then begin
                     Inc(z);
                     If z >= MaxLines then begin
                        mFile.SelAttributes.Color := clRed;
                        mFile.Lines.Add ('<<< Skipped, more than '+IntToStr(z)+' lines >>>');
                        break
                     end
                  end;
                  Readln(f, s);
                  If (Not bBody) and (s='') then bBody := true;
                  If bBody then
                     b := true
                  else If Not (s[1] IN [' ', ^I]) then begin
                     p := Pos(':', s);
                     If p > 0 then begin
                        s2 := Lowercase(Copy(s, 1, p-1));
                        If ShowAllHeader then begin
                           b := true
                        end else begin
                           If CheckDirType(Directory)=dtNews
                              then b := 0 < Pos(','+s2+',', NewsShowHeaderList )
                              else b := 0 < Pos(','+s2+',', MailShowHeaderList )
                        end;
                        If (s2 = 'content-transfer-encoding')
                            and (Pos('quoted-printable', LowerCase(s)) > 0)
                                then bQP := true
                     end else b := false
                  end;
                  If b then begin
                     If bBody then begin
                        mFile.SelAttributes.Style := [];
                        If bQP then begin
                           While (Not EOF(f)) and (Copy(s, Length(s), 1) = '=') do begin
                              System.Delete (s, Length(s), 1);
                              Readln(f, s2);
                              s := s + s2
                           end;
                           For i := Length(s)-2 downto 1 do begin
                              If (s[i]='=')
                                 and (s[i+1] IN['A'..'F', 'a'..'f', '0'..'9'])
                                 and (s[i+2] IN['A'..'F', 'a'..'f', '0'..'9'])
                              then begin
                                 s[i] := Char(Hex2Dez(s[i+1])*16+Hex2Dez(s[i+2]));
                                 System.Delete(s, i+1, 2)
                              end
                           end
                        end;
                        For i := 1 to Length(s) do If s[i]=#0 then s[i] := ' ';
                        If (s = '-- ') then begin
                           mFile.SelAttributes.Color := clFuchsia
                        end else begin
                           Einr := 0;
                           For i := 1 to Length(s) do Case s[i] of
                              '|', '>': Inc(Einr);
                              ' ': ;
                              else break
                           end;
                           If Einr = 0 then mFile.SelAttributes.Color := clBlack
                           else If (Einr mod 2)=1 then mFile.SelAttributes.Color := clBlue
                           else mFile.SelAttributes.Color := clNavy
                        end;
                        // Eigentliche Anzeige der Bodyzeile
                        If (PreviewTextAttr = ptaNone) or ((Pos('*', s)=0) and (Pos('/', s)=0) and (Pos('_', s)=0)) then begin
                           mFile.Lines.Add (s)
                        end else begin
                           LastStyle := wsFirst;
                           slTemp.Clear;
                           Repeat
                              p := 0; cSep := '';
                              For i := 1 to Length(s) do begin
                                 If s[i] IN[' ',',', ';', '(', ')', '.', '!', '?'] then begin
                                    cSep := s[i]; p := i; break
                                 end
                              end;
                              If p = 0 then begin
                                 s2 := s; s := ''
                              end else begin
                                 s2 := Copy(s, 1, p-1);
                                 System.Delete(s, 1, p)
                              end;
                              Style := wsDefault;
                              If s2 > '' then begin
                                 If Length(s2)>2 then begin
                                    If (s2[1]='*') and (s2[Length(s2)]='*') then Style := wsBold
                                    else
                                    If (s2[1]='/') and (s2[Length(s2)]='/') then Style := wsItalic
                                    else
                                    If (s2[1]='_') and (s2[Length(s2)]='_') then Style := wsUnderlined
                                 end;
                                 If (Style <> wsDefault) and (PreviewTextAttr = ptaInstead) then begin
                                    s2 := ' '+Copy(s2, 2, Length(s2)-2)+' '
                                 end;
                                 If Style = LastStyle then
                                    slTemp[slTemp.Count-1] := slTemp[slTemp.Count-1] + s2 + cSep
                                 else If Style = wsDefault then begin
                                    slTemp.AddObject(s2+cSep, Pointer(Style));
                                    LastStyle := Style
                                 end else begin
                                    slTemp.AddObject(s2, Pointer(Style));
                                    If cSep > '' then slTemp.AddObject(cSep, Pointer(wsDefault))
                                 end
                              end else begin
                                 If slTemp.Count > 0
                                    then slTemp[slTemp.Count-1] := slTemp[slTemp.Count-1] + cSep
                                    else If cSep > '' then slTemp.AddObject (cSep, Pointer(wsDefault))
                              end
                           until s = '';
                           For i := 0 to slTemp.Count-1 do begin
                              Case TWordStyle(slTemp.Objects[i]) of
                                 wsBold: mFile.SelAttributes.Style := [fsBold];
                                 wsItalic: mFile.SelAttributes.Style := [fsItalic];
                                 wsUnderlined: mFile.SelAttributes.Style := [fsUnderline];
                                 else mFile.SelAttributes.Style := []
                              end;
                              mFile.SelText := slTemp[i];
                              mFile.SelStart := mFile.SelStart + mFile.SelLength;
                              mFile.SelLength := 0
                           end;
                           mFile.Lines.Add ('')
                        end
                     end else begin
                        mFile.SelAttributes.Style := [fsBold];
                        mFile.SelAttributes.Color := clPurple;
                        mFile.Lines.Add (s)
                     end;
                  end
               end;
               mFile.SelStart := 0
            finally
               mFile.Lines.EndUpdate
            end;
            CloseFile(F)
         end
      end
   finally
      slTemp.free
   end
end;

procedure TDlgEditDir.UAShowList(var M: TMessage);
Var r: TSearchRec;
    Offs, i, j, p: Integer;
    s, Ext: String;
    b: Boolean;
    DirType: TDirType;
begin
   try
      If Dlg = NIL then Exit;
      Timer.Enabled := false;
      If Not UserChange then Exit;
      Userchange := false;
      try
         Caption := Trim(Ueb) + ' "' + Directory + '"';
         With lvDirs do begin
            For i := 0 to Items.Count-1 do begin
               s := Items[i].SubItems[0];
               b := (s = Directory);
               If b <> Items[i].Selected then Items[i].Selected := b;
               If b and (ItemFocused <> Items[i]) then ItemFocused := Items[i]
            end;
            s := ItemFocused.SubItems[1];
            If s > '' then DirectoryID := StrToInt(s) else DirectoryID := 0
         end;
         With lv do With Items do begin
            If First or (ShowFiles<>LastShowFiles) then begin
               If ShowFiles = sfAll then Viewstyle := vsList
            end;
            DirType := CheckDirType(Directory);
            s := IncludeTrailingBackslash(UpperCase(Directory));
            If DirType = dtNews then begin
               If s=UpperCase(PATH_NEWS_OUT) then lIndex := Ord(iiNewsOutFull)
               else If s=UpperCase(PATH_NEWS_ERR) then lIndex := Ord(iiNewsErrFull)
               else lIndex := Ord(iiNewsEmpty)
            end else begin
               If s=UpperCase(PATH_MAIL_OUT) then lIndex := Ord(iiMailOutFull)
               else lIndex := Ord(iiMail)
            end;
            If Directory = '' then begin
               Clear
            end else begin
               Case ShowFiles of
                  sfMsg: Ext := '*.msg';
                  sfErr: Ext := '*.err';
                  else Ext := '*.*'
               end;
               If DirType=dtMailIMAP then begin
                  FindIMAPMails(Directory, slFiles, ShowIMAPSubDirs)
               end else begin
                  slFiles.Clear;
                  If FindFirst(Directory+Ext, faAnyfile, r) = 0 then try
                     Repeat
                        If (r.Name[1]<>'.') and ((r.Attr and faDirectory)=0)
                           then slFiles.Add(r.Name)
                     until FindNext(r) <> 0
                  finally
                     FindClose(r)
                  end
               end;
               If (Directory <> LastDir) or (ShowFiles<>LastShowFiles) then begin
                  Clear;
               end;
               Offs := 0;
               b := false;
               try
                  If slFiles.Count = 0 then begin
                     If Count > 0 then begin
                        If Not b then begin b:= true; BeginUpdate end;
                        Clear;
                     end
                  end else begin
                     For i := 0 to Count-1 do begin
                        j := i-offs;
                        p := slFiles.IndexOf(Items[i].caption);
                        If p < 0 then begin
                           If Not b then begin b:= true; BeginUpdate end;
                           Delete(j);
                           Inc(offs)
                        end else begin
                           slFiles.Delete (p);
                        end
                     end;
                     For i := 0 to slFiles.Count-1 do begin
                        If Not b then begin b:= true; BeginUpdate end;
                        With Add do begin
                           Caption := slFiles[i];
                           s := LowerCase(ExtractFileExt(slFiles[i]));
                           If Directory = LowerCase(PATH_TRASH) then begin
                              ImageIndex := Ord(iiTrash)
                           end else begin
                              If s = '.msg' then ImageIndex := lIndex
                              else If s = '.err' then ImageIndex := Ord(iiNewsErrFull)
                              else If s = '.bak' then ImageIndex := Ord(iiTrash)
                              else ImageIndex := -1
                           end
                        end
                     end
                  end
               finally
                  If b then EndUpdate
               end
            end;
            If First or (LastDirType <> DirType) then begin
               SetColWidths;
               With Columns do begin
                  Clear;
                  Add.Caption := Tr('Filename', 'Filename');
                  If DirType=dtNews then Add.Caption := 'Newsgroups';
                  Add.Caption := 'Subject';
                  If DirType<>dtNews then With Add do begin Caption := 'Score'; Alignment := taCenter end;
                  With Add do begin Caption := 'KB'; Alignment := taRightJustify end;
                  With Add do begin Caption := 'Lines'; Alignment := taRightJustify end;
                  If DirType<>dtNews then Add.Caption := 'To';
                  Add.Caption := 'From';
                  Add.Caption := 'Date';
                  Items[0].Width := GetColWidth('default');
                  For i := 1 to Count-1 do Items[i].Width := GetColWidth(Items[i].Caption)
               end;
               LastDirType := DirType
            end;
            If (Directory<>LastDir) or (ShowFiles<>LastShowFiles) then begin
               Case DirType of
                  dtNews: begin ColumnToSort := NewsDefaultColumnSort; SortUp := NewsDefaultSortUp end;
                  dtMailPOP3, dtMailIMAP: begin ColumnToSort := MailDefaultColumnSort; SortUp := MailDefaultSortUp end;
                  dtTrash: begin ColumnToSort := 0; SortUp := false end;
                  else raise Exception.Create('Internal error - UAShowList with unknown DirType '+IntToStr(Ord(DirType)));
               end;
               Alphasort
            end;
            If First or (ShowFiles<>LastShowFiles) then begin
               If ShowFiles <> sfAll then Viewstyle := vsReport
            end;
            LastDir := Directory;
            LastShowFiles := ShowFiles;
            b := Directory > '';
            If b <> frFiles.Visible then begin
               frFiles.Visible := b;
               If b then lv.SetFocus
            end
         end;
         mnuDelete.enabled := DirType<>dtMailIMAP;
         mnuCopy.enabled := DirType<>dtMailIMAP;
         mnuRename.enabled := DirType<>dtMailIMAP;
         mnuPopDelete.enabled := DirType<>dtMailIMAP;
         mnupopCopyAs.enabled := DirType<>dtMailIMAP;
         mnupopRenameTo.enabled := DirType<>dtMailIMAP;
         If First then First := false;
      finally
         Userchange := true
      end;
      Timer.Enabled := true;
      UpdateFile
   finally
      WaitForShowList := false
   end
end;

procedure TDlgEditDir.mnuPreviewTextattributesClick(Sender: TObject);
Var i: Integer;
begin
   With mnuPreviewTextattributes do begin
      For i := 0 to Count-1 do begin
          Items[i].Checked := Items[i].Tag = Ord(PreviewTextAttr)
      end
   end
end;
procedure TDlgEditDir.Formatandsuppressoriginalchars1Click(
  Sender: TObject);
begin
   If Sender is TMenuItem then begin
      PreviewTextAttr := TPreviewTextAttr((Sender as TMenuItem).Tag);
      ShowFile (true)
   end
end;

procedure TDlgEditDir.mnuPreviewClick(Sender: TObject);
begin
   mnuPreviewState.enabled := ShowFiles <> sfAll;
   mnuPreviewState.Checked := Preview;
   mnuPreviewFixedPitchFont.Checked := FixedPitchFont;
   mnuPreviewAllHeader.Checked := ShowAllHeader;
   mnuPreviewWordwrap.Checked := WordWrap;
end;

Procedure TDlgEditDir.InitMailState;
begin
  SetLength(CheckDirHandle, MaxDirs+1);
end;

Procedure TDlgEditDir.CloseMailState;
Var i: Integer;
begin
   For i := 0 to MaxDirs do FindCloseChangeNotification(CheckDirHandle[i])
end;

Procedure TDlgEditDir.CheckMailState;
Var NewCaption, s: String;
    AnzMsg, AnzErr, i, Idx: Integer;
    r: TSearchRec;
    b: Boolean;
begin
   With lvDirs do begin
      For i := 0 to MaxDirs do begin
         b := false;
         If CheckDirHandle[i] = 0 then begin
             CheckDirHandle[i] := FindFirstChangeNotification(
                 PChar(ExcludeTrailingBackslash(Items[i].SubItems[0])),
                 false,
                 FILE_NOTIFY_CHANGE_FILE_NAME );
             b := true
         end else begin
            While WaitForSingleObject(CheckDirHandle[i], 1) = WAIT_OBJECT_0 do begin
               b := true;
               If Not FindNextChangeNotification(CheckDirHandle[i]) then RaiseLastOSError
            end
         end;
         If b then begin
            AnzMsg := 0; AnzErr := 0;
            If Findfirst(Items[i].SubItems[0]+'*.*', faAnyfile-faDirectory-faVolumeID, r) = 0 then try
               Repeat
                  s := LowerCase(ExtractFileExt(r.Name));
                  If s = '.msg' then Inc(AnzMsg)
                  else If s = '.err' then Inc(AnzErr)
               until FindNext(r)<>0
            finally FindClose(r) end;
            If AnzMsg+AnzErr > 0 then begin
               Case i of
                  0:   Idx := Ord(iiNewsOutFull);
                  1:   Idx := Ord(iiNewsErrFull);
                  2:   Idx := Ord(iiMailOutFull);
                  else begin
                     If Items[i].SubItems[0]=LowerCase(PATH_TRASH)
                        then Idx := Ord(iiTrashFull)
                        else Idx := Ord(iiMailboxFull)
                  end
               end
            end else begin
               Case i of
                  0,1: Idx := Ord(iiNewsEmpty);
                  2:   Idx := Ord(iiMailOutEmpty);
                  else begin
                     If Items[i].SubItems[0]=LowerCase(PATH_TRASH)
                        then Idx := Ord(iiTrash)
                        else Idx := Ord(iiMailboxEmpty)
                  end
               end
            end;
            NewCaption := Items[i].SubItems[2];
            If AnzMsg+AnzErr > 0 then begin
               NewCaption := NewCaption + '('+IntToStr(AnzMsg);
               If AnzErr>0 then NewCaption := NewCaption + '/'+IntToStr(AnzErr);
               NewCaption := NewCaption + ')'
            end;
            With Items[i] do begin
               If ImageIndex <> Idx then ImageIndex := Idx;
               If Caption <> NewCaption then Caption := NewCaption
            end
         end
      end
   end
end;

procedure TDlgEditDir.mnuSmallIconsClick(Sender: TObject);
begin
   SetIconType ( Not SmallIcons )
end;

procedure TDlgEditDir.SetIconType (Const b: Boolean);
begin
   SmallIcons := b;
   With lvDirs do begin
      If b
         then Viewstyle := vsSmallIcon
         else Viewstyle := vsIcon;
      OnResize(NIL)
   end
end;

procedure TDlgEditDir.CreateParams(var Params: TCreateParams);
begin
   inherited;
   If CfgIni.ReadBool ( 'EditDirs', 'OwnTaskbarEntry', false ) then begin
      with Params do begin
         ExStyle := ExStyle or WS_EX_APPWINDOW;
         WndParent := GetDesktopWindow;
      end
   end
end;

function TDlgEditDir.GetColWidth(const Title: String): Integer;
Var s: String; i, p: Integer;
begin
   s := ' ' + LowerCase(ColWidths);
   p := Pos(' '+LowerCase(Title)+'=', s);
   If p < 0 then begin
      If LowerCase(Title)='default'
         then Result := 80
         else Result := GetColWidth ('default')
   end else begin
      Result := 0;
      Inc(p, Length(Title)+2);
      For i := p to Length(s) do begin
         If s[i] IN['0'..'9'] then Result := Result*10 + Ord(s[i])-Ord('0')
                              else break
      end
   end
end;

procedure TDlgEditDir.SetColWidths;
Var i: integer;
begin
   With lv.Columns do begin
      If Count>0 then begin
         SetColWidth('Default', Items[0].Width);
         For i := 1 to Count-1 do SetColWidth(Items[i].Caption, Items[i].Width)
      end
   end
end;

procedure TDlgEditDir.SetColWidth(const Title: String;
  const Value: Integer);
Var s: String; p: integer;
begin
   s := ' ' + LowerCase(ColWidths);
   p := Pos(' '+LowerCase(Title)+'=', s);
   If p = 0 then begin
      ColWidths := Trim(ColWidths) + ' ' + Title + '=' + IntToStr(Value)
   end else begin
      Inc(p, Length(Title)+1);
      While (p<=Length(ColWidths)) and (ColWidths[p] IN['0'..'9']) do Delete(ColWidths, p, 1);
      Insert ( IntToStr(Value), ColWidths, p )
   end
end;

procedure TDlgEditDir.mnuMoveToClick(Sender: TObject);
Var p: TPoint; MI: TMenuItem; i: Integer; LI: TListItem;
begin
   If lv.Items.Count = 0 then begin
      Beep;
      exit
   end;
   GetCursorPos(p);
   With popMoveTo, Items do begin
      Clear;
      For i := 0 to MaxDirs do begin
         LI := lvDirs.Items[i];
         If CopyFromDirectoryToDirEntryOK(LI) then begin
            MI := TMenuItem.Create(popMoveTo);
            Mi.Caption := LI.SubItems[2];
            Mi.Tag := i;
            Mi.OnClick := ExecMoveToDir;
            Add ( MI )
         end
      end;
      PopUp ( p.x, p.y )
   end
end;
procedure TDlgEditDir.ExecMoveToDir(Sender: TObject);
begin
   MoveFilesFromDirToDirEntry ( lvDirs.Items[(Sender as TMenuItem).Tag] )
end;

procedure TDlgEditDir.MoveFilesFromDirToDirEntry(LI: TListItem);
Var i, offs: Integer;
begin
   With lv do begin
      offs := 0;
      For i := 0 to Items.Count-1 do With Items[i-offs] do begin
         If selected then begin
            MoveFile ( PChar(Directory + Caption), PChar(LI.SubItems[0] + Caption) );
            Delete;
            Inc(offs)
         end
      end
   end;
   CheckMailState
end;

procedure TDlgEditDir.SplitFilesMoved(Sender: TObject);
begin
   AspectListToPreview := frFile.Width / ClientWidth;
end;

function TDlgEditDir.KillWhenDelete(const Dir: String): boolean;
begin
   Result := (Not ShowTrash) or (LowerCase(Dir)=LowerCase(PATH_TRASH))
end;
procedure TDlgEditDir.Kill (Const FileName: String; Const KillAlways: boolean);
begin
   If KillWhenDelete(ExtractFilePath(FileName)) or KillAlways
      then DeleteFile(FileName)
      else RenameFile ( FileName, PATH_TRASH + ExtractFileName(FileName) )
end;

Procedure EmptyTrash;
Var Days: Integer; Found, Killed: integer;
    Handle: THandle;
    FindData: TWin32FindData;
    LocalFileTime: TFileTime;
    i, Age: Integer;
    s: String;
begin
   Days := CfgIni.ReadInteger('EditDirs', 'EmptyTrashAfterXDays', 28);
   If Days = 0 then begin
      Log( LOGID_SYSTEM, 'Empty Trash Folder: Function is deactivated');
   end else begin
      Log( LOGID_SYSTEM, 'Empty Trash Folder: Start');
      Found  := 0;
      Killed := 0;
      Handle := FindFirstFile(PChar(PATH_TRASH+'*.*'), FindData);
      if Handle <> INVALID_HANDLE_VALUE then try
         Repeat
            if (FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY) = 0 then begin
               FileTimeToLocalFileTime(FindData.ftLastWriteTime, LocalFileTime);
               if FileTimeToDosDateTime(LocalFileTime, LongRec(Age).Hi, LongRec(Age).Lo) then begin
                  Inc(Found);
                  If Trunc(FileDateToDateTime(Age)+days) <= Trunc(Now) then begin
                     s := PATH_TRASH;
                     For i := 0 to MAX_PATH - 1 do begin
                        If FindData.cFileName[i] > #0 then s := s + FindData.cFileName[i]
                                                      else break
                     end;
                     If DeleteFile( s ) then Inc(Killed)
                  end
               end
            end
         until Not FindNextFile(Handle, FindData)
      finally
        Windows.FindClose(Handle);
      end;
      Log( LOGID_SYSTEM, 'Empty Trash Folder: Done - '+IntToStr(Killed)
         +' of '+IntToStr(Found)+' files deleted');
   end
end;

initialization
   InitializeCriticalSection( Lock );
finalization
   DeleteCriticalSection( Lock );
end.
