// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit HConfigMail;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, dGroupSelect, uTools, cStdForm;

type
  TfrmConfigMail = class(THForm)
    pg: TPageControl;
    TabSettingsPOP3: TTabSheet;
    TabMailserverPOP3: TTabSheet;
    Label20: TLabel;
    lstSrvPop3: TListBox;
    btnSrvPop3Add: TButton;
    btnSrvPop3Del: TButton;
    grpPullingPOP3: TGroupBox;
    TabMailserverSMTP: TTabSheet;
    lstSrvSmtp: TListBox;
    btnSrvSmtpAdd: TButton;
    btnSrvSmtpDel: TButton;
    btnSrvSmtpSel: TButton;
    emSendServer: TEdit;
    labPreferredSMTPServer: TLabel;
    Label1: TLabel;
    Button2: TButton;
    Button3: TButton;
    btnSrvPop3Settings: TButton;
    butSMTPProps: TButton;
    TabSettingsSMTP: TTabSheet;
    grpSMTP: TGroupBox;
    labSMTPAttempts: TLabel;
    chkDeleteFailedMails: TCheckBox;
    txtSMTPAttempts: TEdit;
    butHelp: TButton;
    grpMail2News: TGroupBox;
    chkLeaveMails: TCheckBox;
    chkFilterByUIDL: TCheckBox;
    grpFilterPOP3: TGroupBox;
    chkflupforgate: TCheckBox;
    chkGateUseHamsterEnvelope: TCheckBox;
    labNotify: TLabel;
    labDelete: TLabel;
    txtNotify: TEdit;
    txtIgnore: TEdit;
    txtDelete: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Button1: TButton;
    labIgnore: TLabel;
    chkAddReceivedHeaderMail: TCheckBox;
    labPOP3AddHeader: TLabel;
    chkAdvancedSettings: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure btnSrvPop3AddClick(Sender: TObject);
    procedure btnSrvPop3DelClick(Sender: TObject);
    procedure btnSrvSmtpAddClick(Sender: TObject);
    procedure btnSrvSmtpDelClick(Sender: TObject);
    procedure btnSrvSmtpSelClick(Sender: TObject);
    procedure lstSrvPop3DrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure btnSrvPop3SettingsClick(Sender: TObject);
    procedure butSMTPPropsClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure lstSrvPop3DblClick(Sender: TObject);
    procedure txtNotifyKeyPress(Sender: TObject; var Key: Char);
    procedure lstSrvSmtpDblClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure chkAdvancedSettingsClick(Sender: TObject);
  private
    { Private-Deklarationen }
    HinweisFinaleAenderung: String;
    procedure LoadSettings;
    procedure SaveSettings;
    procedure SavePOP3Server;
    procedure SaveSMTPServer;
  public
    changes: boolean;
  end;

implementation

uses Global, Config, cPasswordFile, cArtFiles, HConfigGroup, cClientNNTP,
     FileCtrl, cAccount, fAccount, dInput, tMaintenance, dSplash,
     hConfigPOP3Server, hConfigSMTPServer, cLogFile;

{$R *.DFM}

procedure RemoveServerDir( Nam: String );

   Procedure DelSrvFile ( Const FileName: String);
   Var s: String;
   begin
      s := PATH_SERVER + Nam + '\' + Filename;
      If FileExists2(s) then DeleteFile(s);
      s := ChangeFileExt(s, '.bak');
      If FileExists2(s) then DeleteFile(s)
   end;

begin
     // delete known server-files
     DelSrvFile ( SRVFILE_INI );
     DelSrvFile ( SRVFILE_HELPTEXT );
     DelSrvFile ( SRVFILE_GROUPS );
     DelSrvFile ( SRVFILE_GRPDESCS );
     DelSrvFile ( SRVFILE_OVERVIEWFMT );
     DelSrvFile ( SRVFILE_GETMIDLIST );
     DelSrvFile ( SRVFILE_GREETING );
     DelSrvFile ( 'newgrps.txt' ); // used til 1.3.19

     // remove directory
     if not RemoveDir( PATH_SERVER + Nam ) then begin
        Log( LOGID_WARN, TrGlF(kLog, 'Warning.Server.DirUndeleteble',
            'Couldn''t remove directory "%s"!', PATH_SERVER + Nam) )
     end;
end;

procedure TfrmConfigMail.LoadSettings;
begin

   chkAdvancedSettings.Checked := Def_AdvancedConfiguration;

   lstSrvPop3.Clear;
   if FileExists2( PATH_BASE + CFGFILE_SERVER_POP3 ) then begin
      lstSrvPop3.Items.LoadFromFile( PATH_BASE + CFGFILE_SERVER_POP3 );
      lstSrvPop3.ItemIndex := 0;
   end;
   lstSrvSmtp.Clear;
   if FileExists2( PATH_BASE + CFGFILE_SERVER_SMTP ) then begin
      lstSrvSmtp.Items.LoadFromFile( PATH_BASE + CFGFILE_SERVER_SMTP );
      lstSrvSmtp.ItemIndex := 0;
   end;
   emSendServer.Text := CfgIni.ReadString ( 'Setup', 'preferred.smtpserver', Def_SmtpServer );

   chkflupforgate.Checked := CfgIni.ReadBool('Setup','mail.flupforgate',Def_Flup);
   chkGateUseHamsterEnvelope.Checked := CfgIni.ReadBool('Setup', 'mail.GateUseHamsterEnvelope', Def_Gate_UseHamsterEnvelope);

   chkLeaveMails.Checked   := CfgIni.ReadBool( 'Setup', 'mail.leaveonserver', True  );
   chkFilterByUIDL.Checked := CfgIni.ReadBool( 'Setup', 'mail.filterbyuidl',  False );

   chkAddReceivedHeaderMail.checked := CfgIni.ReadBool('Setup','pop3.addreceived', Def_POP3_AddReceived);

   txtNotify.text := CfgIni.ReadString ('Setup', 'mail.filter.mailsize.notify', '0');
   txtIgnore.text := CfgIni.ReadString ('Setup', 'mail.filter.mailsize.ignore', '0');
   txtDelete.text := CfgIni.ReadString ('Setup', 'mail.filter.mailsize.delete', '0');

   txtSMTPAttempts.text := CfgIni.ReadString ('Setup', 'sendmail.attempts.max', IntToStr(Def_SendMailAttemptsMax));
   chkDeleteFailedMails.Checked := CfgIni.ReadBool( 'Setup', 'sendmail.attempts.del', Def_SendMailAttemptsDel );
end;

procedure IniWriteInt( Section, Item, Value: String );
var  iValue: Integer;
begin
     try
        iValue := strtoint( Value );
        CfgIni.WriteInteger( Section, Item, iValue );
     except
     end;
end;

procedure TfrmConfigMail.SavePOP3Server;
begin
   lstSrvPop3.Items.SaveToFile   ( PATH_BASE + CFGFILE_SERVER_POP3 );
   changes := true
end;
procedure TfrmConfigMail.SaveSMTPServer;
begin
   lstSrvSmtp.Items.SaveToFile   ( PATH_BASE + CFGFILE_SERVER_SMTP );
   CfgIni.WriteString( 'Setup', 'preferred.smtpserver', emSendServer.Text );
   changes := true
end;

procedure TfrmConfigMail.SaveSettings;
begin
   CfgIni.WriteBool( 'Setup', 'mail.leaveonserver', chkLeaveMails.Checked   );
   CfgIni.WriteBool( 'Setup', 'mail.filterbyuidl',  chkFilterByUIDL.Checked );
   CfgIni.WriteInteger ('Setup', 'mail.filter.mailsize.notify', StrToInt('0'+txtNotify.text));
   CfgIni.WriteInteger ('Setup', 'mail.filter.mailsize.ignore', StrToInt('0'+txtIgnore.text));
   CfgIni.WriteInteger ('Setup', 'mail.filter.mailsize.delete', StrToInt('0'+txtDelete.text));
   CfgIni.WriteBool( 'Setup','mail.flupforgate', chkflupforgate.Checked);
   CfgIni.WriteBool( 'Setup', 'mail.GateUseHamsterEnvelope', chkGateUseHamsterEnvelope.Checked);
   CfgIni.WriteBool('Setup','pop3.addreceived', chkAddReceivedHeaderMail.checked);
   CfgIni.WriteInteger ('Setup', 'sendmail.attempts.max', StrToInt('0'+txtSMTPAttempts.text));
   CfgIni.WriteBool( 'Setup', 'sendmail.attempts.del',  chkDeleteFailedMails.Checked );
end;

Var TI: Integer = 0;

procedure TfrmConfigMail.FormCreate(Sender: TObject);
begin
   chkAddReceivedHeaderMail.Enabled := Def_FQDN > '';
   pg.ActivePage := pg.Pages[TI];
   HinweisFinaleAenderung := Tr('AttentionFinalChange',
      'Attention: This change is permanent e.g. you can''t discard it with "abort" later');
   LoadSettings;
   With lstSrvPOP3 do ItemHeight := Canvas.TextHeight('Gg');
   With lstSrvSMTP do ItemHeight := Canvas.TextHeight('Gg');
end;

procedure TfrmConfigMail.btnSrvPop3AddClick(Sender: TObject);
var  s, Nam : String; i: Integer; b: Boolean;
begin
     s := 'pop.xxx.xx';
     if InputDlgStr( Tr('AddPOP3Server.caption', 'Mailserver (POP3)'),
                     Tr('AddPOP3Server.Prompt2', 'Format: Servername[/Alias][,Port]')
                     + #13#10#13#10 + '(' + HinweisFinaleAenderung+')', s, 0{HlpAddPop3Server} ) then begin
        while Pos(' ',s)>0 do System.Delete( s, Pos(' ',s), 1 );
        StripURLType(s);
        if s<>'' then begin
           if Pos( ',', s )=0 then s:=s+',pop3';
           Nam := copy( s, 1, Pos(',',s)-1 );
           b := false;
           With lstSrvPop3 do begin
              For i := 0 to Items.Count-1 do begin
                 If LowerCase(Copy(Items[i], 1, Length(Nam)+1))=LowerCase(Nam)+',' then begin
                    b := true;
                    break
                 end
              end
           end;
           If b then begin
              Application.MessageBox( PChar(Tr('AddPop3Server.AliasNeeded',
                 'This Servername is already used, you have to add an "alias" to use it twice or more.')),
                 PChar(Caption), MB_ICONINFORMATION )
           end else begin
              lstSrvPop3.ItemIndex := lstSrvPop3.Items.Add( s );
              ForceDirectories( PATH_SERVER + POP3ServerNameToPath(Nam) );
              SavePOP3Server;
              btnSrvPop3Settings.Click
           end
        end
     end;
end;

procedure TfrmConfigMail.btnSrvPop3DelClick(Sender: TObject);
var  Idx, i: Integer;
     Nam   : String;
//     Nam2  : String;
begin
     if (lstSrvPop3.ItemIndex<0) or (lstSrvPop3.ItemIndex>=lstSrvPop3.Items.Count) then exit;

     Idx := lstSrvPop3.ItemIndex;
     Nam := lstSrvPop3.Items[Idx];
     i := Pos( ',', Nam );
     if i>0 then Nam:=copy(Nam,1,i-1);

     If Application.MessageBox(
        PChar(TrF('DelPop3Server.Ask', 'Delete server "%s" with all its data and info?', Nam)
              + ' (' + HinweisFinaleAenderung+')'),
        PChar(Caption), MB_ICONQUESTION + MB_YESNO )
     <> IDYES then Exit;

     // delete server-files and -dir
     RemoveServerDir( POP3ServerNameToPath(Nam) );

{     if i > 0 then
       for i:=0 to lstSrvpop3.Items.count-1 do begin
         Nam2 := copy(lstSrvpop3.Items[i],1,pos(',',lstSrvpop3.Items[i])-1);
         if Nam2 = Nam then
           lstSrvPop3.Items.Delete( i );
       end;
     else}     { TODO : Alias2, mu einkommentiert werden }
       lstSrvPop3.Items.Delete( Idx );

     SavePOP3Server;
     if lstSrvPop3.Items.Count>0 then begin
        if Idx>=lstSrvPop3.Items.Count then dec(Idx);
        lstSrvPop3.ItemIndex := Idx;
     end;
end;

procedure TfrmConfigMail.btnSrvSmtpAddClick(Sender: TObject);
var  s, Nam : String; b: Boolean; i: Integer;
begin
   s := 'mail.xxx.xx';
   if InputDlgStr( Tr('AddSMTPServer.Caption', 'Mailserver (SMTP)'),
                   Tr('AddSMTPServer.Prompt', 'Format: Servername[,Port]')
                   + #13#10#13#10 + '(' + HinweisFinaleAenderung+')', s,
                   0{HlpAddSMTPServer} )
   then begin
      while Pos(' ',s)>0 do System.Delete( s, Pos(' ',s), 1 );
      StripURLType(s);
      if s<>'' then begin
         if Pos( ',', s )=0 then s:=s+',smtp';
         Nam := copy( s, 1, Pos(',',s)-1 );
         b := false;
         With lstSrvSmtp do begin
            For i := 0 to Items.Count-1 do begin
               If LowerCase(Copy(Items[i], 1, Length(Nam)+1))=LowerCase(Nam)+',' then begin
                  b := true;
                  break
               end
            end
         end;
         If b then begin
           Application.MessageBox(
               PChar(Tr('AddSMTPServer.NoDoubleServers', 'This Server is already used!')),
               PChar(Caption), MB_ICONWARNING + MB_OK )
         end else begin
            lstSrvSmtp.ItemIndex := lstSrvSmtp.Items.Add( s );

            ForceDirectories( PATH_SERVER + POP3ServerNameToPath(Nam) );
            SaveSMTPServer;
            butSMTPProps.Click
         end
      end
   end
end;

procedure TfrmConfigMail.btnSrvSmtpDelClick(Sender: TObject);
var  Idx, i: Integer;
     Nam   : String;
begin
     if (lstSrvSmtp.ItemIndex<0) or (lstSrvSmtp.ItemIndex>=lstSrvSmtp.Items.Count) then exit;

     Idx := lstSrvSmtp.ItemIndex;
     Nam := lstSrvSmtp.Items[Idx];
     i := Pos( ',', Nam );
     if i>0 then Nam:=copy(Nam,1,i-1);

     If Application.MessageBox(
        PChar(TrF('DelSMTPServer.Ask', 'Delete server "%s" with all its data and info?', Nam)
                  + ' (' + HinweisFinaleAenderung+')'),
        PChar(Caption), MB_ICONQUESTION + MB_YESNO )
     <> IDYES then Exit;

     // delete server-files and -dir
     RemoveServerDir( POP3ServerNameToPath(Nam) );
     { TODO : Alias3, hier mu es auch eingefgt werden }
     If lstSrvSmtp.Items[Idx] = emSendServer.Text then emSendServer.Text := '';
     lstSrvSmtp.Items.Delete( Idx );
     SaveSMTPServer;
     if lstSrvSmtp.Items.Count>0 then begin
        if Idx>=lstSrvSmtp.Items.Count then dec(Idx);
        lstSrvSmtp.ItemIndex := Idx;
     end;
end;

procedure TfrmConfigMail.btnSrvSmtpSelClick(Sender: TObject);
begin
     if lstSrvSmtp.ItemIndex<0 then exit;
     if lstSrvSmtp.ItemIndex>=lstSrvSmtp.Items.Count then exit;
     emSendServer.Text := lstSrvSmtp.Items[ lstSrvSmtp.ItemIndex ];
     SaveSMTPServer
end;

procedure TfrmConfigMail.lstSrvPop3DrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var  t, ID, User, PW, u, p: String;
begin
   with (Control as TListBox).Canvas do begin
      t := (Control as TListBox).Items[Index];
      ID := Copy(t, 1, Pos(',', t)-1);
      If PasswordFile.LoadPassword (ID, User, PW) then begin
         PasswordFile.PasswordInfo (ID, User, PW, U, P);
         If User > '' then U := '"'+User+'"';
         t := t + ', '+U+'/'+P
      end;
      FillRect(Rect);
      TextOut( Rect.Left, Rect.Top, t );
   end
end;

procedure TfrmConfigMail.btnSrvPop3SettingsClick(Sender: TObject);
var  Idx, i: Integer;
     s, Nam, Port: String;
begin
   With lstSrvPOP3 do With Items do begin
      Idx := ItemIndex;
      If Idx < 0 then exit;
      s := Items[Idx];
      i := Pos( ',', s );
      if i>0 then begin
         Nam := copy( s, 1, i-1 );
         Port :=  copy( s, i+1, length(s)-i );
         DialogEditPop3Server (Nam, Port);
         LoadFromFile( PATH_BASE + CFGFILE_SERVER_POP3 );
         ItemIndex :=Idx
      end
   end
end;

{Var i, Idx: Integer; Nam, U, P1, P2: String;
begin
   if (lstSrvPop3.ItemIndex<0) or (lstSrvPop3.ItemIndex>=lstSrvPop3.Items.Count) then exit;

   Idx := lstSrvPop3.ItemIndex;
   Nam := lstSrvPop3.Items[Idx];
   i := Pos( ',', Nam );
   if i>0 then Nam:=copy(Nam,1,i-1);

   if not InputDlgStr( PChar(Nam), TrGl(kGlobal, 'DlgPWEdit.Username', 'Username (?=ask when needed):'), U  ) then exit;
   if not InputDlgPwd( PChar(Nam), TrGl(kGlobal, 'DlgPWEdit.Password', 'Password (?=ask when needed):'), P1 ) then exit;
   if (P1<>'') and (P1<>'?') then begin
      if not InputDlgPwd( PChar(Nam), TrGl(kGlobal, 'DlgPWEdit.RepeatPW', 'Repeat password:'), P2 ) then exit;
      if P1<>P2 then exit;
   end;

   PasswordFile.SavePassword (true, Nam, U, P1);
   lstSrvPop3.Refresh
end;}

procedure TfrmConfigMail.butSMTPPropsClick(Sender: TObject);
var  Idx, i: Integer;
     s,s2: String;
begin
   Idx := lstSrvSMTP.ItemIndex;
   if (Idx < 0) then exit;
   s := lstSrvSMTP.Items[Idx];
   i := Pos( ',', s ); if i>0 then s2 := copy( s, 1, i-1 );
   i := Pos( ',', s ); if i>0 then s :=  copy( s, i+1, length(s)-length(s2) );
   DialogEditSMTPServer(s2, s);
   With lstSrvSMTP do With Items do begin
      i:=ItemIndex;
      LoadFromFile( PATH_BASE + CFGFILE_SERVER_SMTP );
      ItemIndex:=i;
   end;
   lstSrvSmtp.Refresh
end;

procedure TfrmConfigMail.Button2Click(Sender: TObject);
begin
   SaveSettings
end;

procedure TfrmConfigMail.FormDestroy(Sender: TObject);
begin
   TI := pg.ActivePage.PageIndex
end;

procedure TfrmConfigMail.lstSrvPop3DblClick(Sender: TObject);
begin
   btnSrvPop3Settings.OnClick (nil)
end;

procedure TfrmConfigMail.txtNotifyKeyPress(Sender: TObject; var Key: Char);
begin
   If (Key > #31) and Not (Key IN ['0'..'9']) then Key := #0;  
end;

procedure TfrmConfigMail.lstSrvSmtpDblClick(Sender: TObject);
begin
   butSMTPProps.OnClick (NIL)
end;

procedure TfrmConfigMail.Button1Click(Sender: TObject);
begin
   EditFile (PATH_BASE + CFGFILE_MFILTER)
end;

procedure TfrmConfigMail.chkAdvancedSettingsClick(Sender: TObject);
Var b: Boolean;
begin
   b := chkAdvancedSettings.Checked;
   labPOP3AddHeader.Visible := b;
   chkAddReceivedHeaderMail.Visible := b;
   grpMail2News.Visible := b;
   grpFilterPOP3.Visible := b;
end;

end.

