// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit HConfigNews;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, dGroupSelect, uTools, cStdForm;

type
  TfrmConfigNews = class(THForm)
    pg: TPageControl;
    TabNewsserver: TTabSheet;
    Label2: TLabel;
    lstSrvNntp: TListBox;
    btnSrvNntpAdd: TButton;
    btnSrvNntpDel: TButton;
    TabNewsgroups: TTabSheet;
    Label3: TLabel;
    lstNewsgroups: TListBox;
    btnNewsgroupsDel: TButton;
    TabNewsPulls: TTabSheet;
    Label4: TLabel;
    lstNewsPulls: TListBox;
    btnNewsPullsAdd: TButton;
    btnNewsPullsDel: TButton;
    Label1: TLabel;
    emPostServer: TEdit;
    btnSrvNntpSel: TButton;
    btnNewsgroupsAddLocal: TButton;
    TabSettings: TTabSheet;
    btnNewsgroupsSet: TButton;
    grpSetNews: TGroupBox;
    Label8: TLabel;
    Label16: TLabel;
    emPullLimit: TEdit;
    emPullFirst: TEdit;
    labBlueMeansLocalGroup: TLabel;
    btnSrvNntpSet: TButton;
    butPurgeNow: TButton;
    Button2: TButton;
    Button3: TButton;
    Label5: TLabel;
    Label7: TLabel;
    butServerNewsPulls: TButton;
    butPullNow: TButton;
    Label6: TLabel;
    cbPullLimitDef: TComboBox;
    cbPullLimitEmpty: TComboBox;
    chkGetParts: TCheckBox;
    labGetPartsMax: TLabel;
    txtGetPartsMax: TEdit;
    labGetPartsMin: TLabel;
    txtGetPartsMin: TEdit;
    butHelp: TButton;
    butResetGroup: TButton;
    gbAdditionalSettings: TGroupBox;
    chkGetAutoServerInfos: TCheckBox;
    chkAdvancedSettings: TCheckBox;
    chkDropResidualNewsJobs: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure btnSrvNntpAddClick(Sender: TObject);
    procedure btnSrvNntpDelClick(Sender: TObject);
    procedure btnNewsgroupsDelClick(Sender: TObject);
    procedure btnNewsPullsAddClick(Sender: TObject);
    procedure btnNewsPullsDelClick(Sender: TObject);
    procedure btnSrvNntpSelClick(Sender: TObject);
    procedure btnNewsgroupsAddLocalClick(Sender: TObject);
    procedure btnNewsgroupsSetClick(Sender: TObject);
    procedure lstNewsgroupsDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure btnSrvNntpSetClick(Sender: TObject);
    procedure lstSrvNntpDblClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure butPurgeNowClick(Sender: TObject);
    procedure lstSrvNntpDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure lstNewsgroupsDblClick(Sender: TObject);
    procedure butServerNewsPullsClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure lstNewsPullsDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure butPullNowClick(Sender: TObject);
    procedure cbPullLimitDefClick(Sender: TObject);
    procedure chkGetPartsClick(Sender: TObject);
    procedure butResetGroupClick(Sender: TObject);
    procedure lstNewsgroupsClick(Sender: TObject);
    procedure lstNewsPullsClick(Sender: TObject);
    procedure chkAdvancedSettingsClick(Sender: TObject);
  private
    { Private-Deklarationen }
    HinweisFinaleAenderung: String;
    procedure LoadSettings;
    procedure SaveSettings;
    procedure SaveNewsserver;
    procedure SaveNewsgroups;
    procedure SaveNewspulls;
    procedure AddNewsPull (Const Pull: String);
    procedure DelNewsPull (Const Pull: String);
    Procedure TestPullLimitFields;
    Procedure Test;
  public
    Changes: boolean;
  end;

implementation

uses Global, Config, cPasswordFile, cArtFiles, cNewsJobs, HConfigGroup, cClientNNTP,
     FileCtrl, cAccount, fAccount, dInput, HConfigNewsServer, tMaintenance, dSplash,
     dGroupSelectFromServer, Main, IniFiles, ShellAPI, cLogFile, cActions;

{$R *.DFM}

procedure RemoveServerDir( Nam: String );

   Procedure DelSrvFile ( Const FileName: String);
   Var s: String;
   begin
      s := PATH_SERVER + Nam + '\' + Filename;
      If FileExists2(s) then DeleteFile(s);
      s := ChangeFileExt(s, '.bak');
      If FileExists2(s) then DeleteFile(s)
   end;

begin
   // delete known server-files
   DelSrvFile ( SRVFILE_INI );
   DelSrvFile ( SRVFILE_HELPTEXT );
   DelSrvFile ( SRVFILE_GROUPS );
   DelSrvFile ( SRVFILE_GRPDESCS );
   DelSrvFile ( SRVFILE_OVERVIEWFMT );
   DelSrvFile ( SRVFILE_GETMIDLIST );
   DelSrvFile ( SRVFILE_GREETING );
   DelSrvFile ( 'newgrps.txt' ); // used til 1.3.19
   // remove directory
   if not RemoveDir( PATH_SERVER + Nam ) then begin
      Log( LOGID_WARN, TrGlF(kLog, 'Warning.Server.DirUndeleteble',
          'Couldn''t remove directory "%s"!', PATH_SERVER + Nam) )
   end
end;

procedure TfrmConfigNews.LoadSettings;
Var x: Integer;
begin

   chkAdvancedSettings.Checked := Def_AdvancedConfiguration;

   lstSrvNntp.Clear;
   if FileExists2( PATH_BASE + CFGFILE_SERVER_NNTP ) then begin
      With lstSrvNntp do With Items do begin
         LoadFromFile( PATH_BASE + CFGFILE_SERVER_NNTP );
         If Count > 0 then ItemIndex := 0
      end
   end;
   emPostServer.Text := CfgIni.ReadString ( 'Setup', 'preferred.postserver', Def_PostServer );

   chkGetParts.Checked := CfgIni.ReadBool ('Setup','news.makeparts',Def_parts_make);
   txtGetPartsMax.text := IntToStr(CfgIni.ReadInteger('Setup','news.sizeofparts.max',Def_parts_size_Max));
   txtGetPartsMin.text := IntToStr(CfgIni.ReadInteger('Setup','news.sizeofparts.min',Def_parts_size_Min));

   chkGetAutoServerInfos.checked := CfgIni.ReadBool( 'Setup', 'nntp.autogetserverinfos', Def_NNTPAutoGetServerInfos);
   chkDropResidualNewsJobs.checked := CfgIni.ReadBool( 'Setup', 'nntp.dropresidualjobs', Def_NNTPDropResidualJobs);

   With lstNewsgroups do begin
      Clear;
      if FileExists2( PATH_BASE + CFGFILE_ACTIVE ) then begin
         Items.LoadFromFile( PATH_BASE + CFGFILE_ACTIVE );
         If Items.Count>0 then begin
            Selected[0] := true;
            ItemIndex := 0
         end
      end;
      OnClick (nil)
   end;

   With lstNewsPulls do begin
      Clear;
      if FileExists2( PATH_BASE + CFGFILE_PULLS ) then begin
         Items.LoadFromFile( PATH_BASE + CFGFILE_PULLS );
         If Items.Count>0 then begin
            ItemIndex := 0;
            Selected[0] := true
         end
      end;
      OnClick (NIL)
   end;

   x := CfgIni.ReadInteger( 'Setup', 'pull.limit', Def_Pull_Limit );
   emPullLimit.Text := IntToStr(Abs(x));
   With cbPullLimitDef do begin
      If x = 0 then ItemIndex := 0
      else If x > 0 then ItemIndex := 1
      else ItemIndex := 2
   end;

   x := CfgIni.ReadInteger( 'Setup', 'pull.limit.first', Def_Pull_Limit );
   emPullFirst.Text := IntToStr(Abs(x));
   With cbPullLimitEmpty do begin
      If x = 0 then ItemIndex := 0
      else If x > 0 then ItemIndex := 1
      else ItemIndex := 2
   end;

   TestPullLimitFields;
   Test;

   Changes := false

end;

procedure TfrmConfigNews.SaveSettings;
Var s: String; x: Integer;
begin

   s := emPullLimit.Text; x := 0;
   If s > '' then try x := StrToInt(s) except end;
   Case cbPullLimitDef.ItemIndex of
      0: x := 0;
      1: x := Abs(x);
      2: x := -Abs(x)
   end;
   CfgIni.WriteInteger( 'Setup', 'pull.limit', x );

   CfgIni.WriteBool ('Setup','news.makeparts',chkGetParts.Checked);
   CfgIni.WriteInteger('Setup','news.sizeofparts.max',StrToInt('0'+Trim(txtGetPartsMax.Text)));
   CfgIni.WriteInteger('Setup','news.sizeofparts.min',StrToInt('0'+Trim(txtGetPartsMin.Text)));

   CfgIni.WriteBool ('Setup', 'nntp.autogetserverinfos', chkGetAutoServerInfos.checked);
   CfgIni.WriteBool ('Setup', 'nntp.dropresidualjobs', chkDropResidualNewsJobs.checked);

   s := emPullFirst.Text; x := 0;
   If s > '' then try x := StrToInt(s) except end;
   Case cbPullLimitEmpty.ItemIndex of
      0: x := 0;
      1: x := Abs(x);
      2: x := -Abs(x)
   end;
   CfgIni.WriteInteger( 'Setup', 'pull.limit.first', x );

end;

procedure TfrmConfigNews.SaveNewsgroups;
begin
   lstNewsgroups.Items.SaveToFile( PATH_BASE + CFGFILE_ACTIVE );
   CfgHamster.ReloadActiveList;
   Changes := true
end;

procedure TfrmConfigNews.SaveNewspulls;
begin
   lstNewsPulls.Items.SaveToFile( PATH_BASE + CFGFILE_PULLS  );
   CfgHamster.ReloadPullList;
   Changes := true
end;

procedure TfrmConfigNews.SaveNewsserver;
begin
   lstSrvNntp.Items.SaveToFile( PATH_BASE + CFGFILE_SERVER_NNTP );
   CfgIni.WriteString ( 'Setup', 'preferred.postserver', emPostServer.Text );
   Changes := true
end;

Var TI: Integer = 0;

procedure TfrmConfigNews.FormCreate(Sender: TObject);
begin
   HelpContext := 0{HlpConfigNews}; 
   pg.ActivePage := pg.Pages[TI];
   labBlueMeansLocalGroup.Font.Color := clBlue;
   HinweisFinaleAenderung := Tr('AttentionFinalChange',
      'Attention: This change is permanent e.g. you can''t discard it with "abort" later');
   LoadSettings;
   With lstNewsgroups do ItemHeight := Canvas.TextHeight('Gg');
   With lstSrvNntp do ItemHeight := Canvas.TextHeight('Gg');
   With lstNewsPulls do ItemHeight := Canvas.TextHeight('Gg');
end;

procedure TfrmConfigNews.btnSrvNntpAddClick(Sender: TObject);
var  s, Nam : String; i: Integer; b: Boolean;
begin
   s := 'news.xxx.xx';
   if InputDlgStr( Tr('AddNewsserver.Caption', 'Newsserver (NNTP)'),
                   Tr('AddNewsserver.Prompt', 'Format: Servername[,Port]')
                   + #13#10#13#10 + '(' + HinweisFinaleAenderung+')',
                   s, 0{HlpAddNewsserver} ) then begin
      while Pos(' ',s)>0 do System.Delete( s, Pos(' ',s), 1 );
      StripURLType(s);
      if s<>'' then begin
         if Pos( ',', s )=0 then s:=s+',nntp';
         Nam := copy(s, 1, Pos(',',s)-1);
         b := false;
         With lstSrvNntp do begin
            For i := 0 to Items.Count-1 do begin
               If LowerCase(Copy(Items[i], 1, Length(Nam)+1))=LowerCase(Nam)+',' then begin
                  b := true;
                  break
               end
            end
         end;
         If b  then begin
            Application.MessageBox(
                PChar(Tr('AddNNTPServer.NoDoubleServer', 'This server exists already in list!')),
                PChar(Caption),
                MB_ICONWARNING + MB_OK)
         end else begin
            lstSrvNntp.ItemIndex := lstSrvNntp.Items.Add(s);
            ForceDirectories(PATH_SERVER + Nam);
            SaveNewsserver;
            btnSrvNntpSet.Click
         end
      end
   end
end;

procedure TfrmConfigNews.btnSrvNntpSetClick(Sender: TObject);
var  i: Integer;
     s,s2: String;
begin
   if lstSrvNntp.ItemIndex<0 then exit;
   if lstSrvNntp.ItemIndex>=lstSrvNntp.Items.Count then exit;

   s := lstSrvNntp.Items[ lstSrvNntp.ItemIndex ];
   i := Pos( ',', s ); if i>0 then s2 := copy( s, 1, i-1 );
   i := Pos( ',', s ); if i>0 then s :=  copy( s, i+1, length(s)-length(s2) );

   DialogEditNNTPServer (s2, s);
   With lstSrvNntp do With Items do begin
      i:=ItemIndex;
      LoadFromFile( PATH_BASE + CFGFILE_SERVER_NNTP );
      ItemIndex:= i;
   end;
end;

procedure TfrmConfigNews.btnSrvNntpDelClick(Sender: TObject);
var  Idx, i, j: Integer;
     Nam, s   : String;
     SavePulls: boolean;
begin
   if (lstSrvNntp.ItemIndex<0) or (lstSrvNntp.ItemIndex>=lstSrvNntp.Items.Count) then exit;

   Idx := lstSrvNntp.ItemIndex;
   Nam := lstSrvNntp.Items[Idx];
   i := Pos( ',', Nam );
   if i>0 then Nam:=copy(Nam,1,i-1);

   If Application.MessageBox(
         PChar(TrF('DeleteNNTPServer.Ask', 'Delete server "%s" with all its data and info?', Nam)
               + ' (' + HinweisFinaleAenderung+')'),
         PChar(Caption), MB_ICONQUESTION + MB_YESNO )
      = IDYES
   then begin
      // delete server-files and -dir
      RemoveServerDir( Nam );
      If lstSrvNntp.Items[Idx] = emPostServer.Text then emPostServer.Text := '';
      lstSrvNntp.Items.Delete( Idx );
      SaveNewsserver;
      // change focus on next server
      if lstSrvNntp.Items.Count>0 then begin
         if Idx>=lstSrvNntp.Items.Count then dec(Idx);
         lstSrvNntp.ItemIndex := Idx;
      end;
      // delete pulls for server also
      SavePulls := False;
      Idx := 0;
      while Idx<lstNewsPulls.Items.Count do begin
         s := lstNewsPulls.Items[Idx];
         j := Pos( ',', s );
         if j=0 then s:='' else s:=copy(s,j+1,Length(s)-j);
         if CompareText( Nam, s )=0 then begin
            lstNewsPulls.Items.Delete(Idx);
            SavePulls := True;
         end else begin
            inc(Idx);
         end;
      end;
      if SavePulls then begin
         SaveNewspulls;
         lstNewsgroups.Refresh; // due to color
      end
   end
end;

procedure TfrmConfigNews.btnSrvNntpSelClick(Sender: TObject);
begin
   if lstSrvNntp.ItemIndex<0 then exit;
   if lstSrvNntp.ItemIndex>=lstSrvNntp.Items.Count then exit;
   emPostServer.Text := lstSrvNntp.Items[ lstSrvNntp.ItemIndex ];
   SaveNewsserver
end;

procedure TfrmConfigNews.btnNewsgroupsAddLocalClick(Sender: TObject);
var  s: String;
begin
   s := '';
   DialogEditGroupActivate (Self);
   try
      if InputDlgStr( Tr('AddLocalGroup.Caption', 'Add local group'),
                      Tr('AddLocalGroup.Prompt', 'Group-name:')
                      + ' (' + HinweisFinaleAenderung+')',
                      s, 0{HlpAddLocalGroup} ) then
      begin
         if IsNewsgroup( s ) then begin
            if (s<>'') and (lstNewsgroups.Items.IndexOf(s)<0) then begin
               lstNewsgroups.ItemIndex := lstNewsgroups.Items.Add( s );
               CreateGroup( s ); // Gruppenpfad erstellen
               SaveNewsgroups;
               DialogEditGroupExec( s ) // btnNewsgroupsSet.Click
            end
         end else begin
            Application.MessageBox( PChar(Tr('AddLocalGroup.InvalidGroupName', 'Invalid newsgroup-name!')),
                                    PChar(Tr('AddLocalGroup.Caption', 'Add local group')), MB_ICONEXCLAMATION );
         end
      end
   finally
      DialogEditGroupDeActivate
   end
end;

procedure TfrmConfigNews.btnNewsgroupsSetClick(Sender: TObject);
Var i: Integer;
begin
   With lstNewsgroups do begin
      For i := 0 to Items.Count-1 do If Selected[i] then begin
         DialogEditGroup (Items[i])
      end;
      Refresh
   end
end;

procedure TfrmConfigNews.btnNewsgroupsDelClick(Sender: TObject);
Var Anz, i, j, Idx, Offs: Integer; s, Group: String;
    SaveGroups, SavePulls: Boolean;
begin
   With lstNewsgroups do begin
      Anz := 0;
      For i := 0 to Items.Count-1 do If selected[i] then begin
         Group := Items[i];
         // protect internal groups from being deleted
         for j:=INTERNALGROUP_DEFAULT to INTERNALGROUP_LASTGROUP do begin
            if AnsiCompareText( INTERNALGROUP[j], Group )=0 then begin
               Application.MessageBox(
                   PChar(TrF('DeleteGroupXXX.InternalUndeletable', 'Internal group %s can''t be deleted!', Group)),
                   PChar(Caption), MB_ICONWARNING + MB_OK );
               Selected[i] := false;
               break
            end;
         end;
         If selected[i] then Inc(Anz)
      end;
      Case Anz of
         0: Exit;
         1: s := TrF('DeleteGroup.Ask', 'Delete group "%s" with all its articles?', Group);
         else s := TrF('DeleteGroups.Ask', 'Delete these %s groups with all their articles?', IntToStr(Anz));
      end;
      If MessageBox( Handle,
         PChar(s + ' (' + HinweisFinaleAenderung+')'),
         PChar(Caption),
         MB_ICONQUESTION or MB_YESNO or MB_DEFBUTTON2 ) = IDYES
      then begin
         Offs := 0; SaveGroups := False; SavePulls := False;
         For i := 0 to Items.Count-1 do If Selected[i-Offs] then begin
            Idx := i-Offs; Group := Items[idx];
            // Delete Group itself
            if ArticleBase.DeleteGroup( Group ) = -1 then begin
               Application.MessageBox(
                   PChar(TrF('DeleteGroupXXX.Error.InUse', 'Group %s is in use and can''t be deleted!', Group)),
                   PChar(Caption), MB_ICONWARNING + MB_OK );
               continue
            end;
            // Update Listbox
            lstNewsgroups.Items.Delete( Idx );
            Inc(Offs);
            SaveGroups := true;
            If Items.Count>0 then begin
               if Idx>=Items.Count then dec(Idx);
               ItemIndex := Idx;
            end;
            // delete pulls for group also
            Idx := 0;
            while Idx<lstNewsPulls.Items.Count do begin
               s := lstNewsPulls.Items[Idx];
               j := Pos( ',', s );
               if j=0 then s:='' else s:=copy(s,1,j-1);
               if CompareText( Group, s )=0 then begin
                  lstNewsPulls.Items.Delete(Idx);
                  SavePulls := True
               end else begin
                  inc(Idx)
               end;
            end
         end;
         // Save changes
         If SaveGroups then SaveNewsgroups;
         if SavePulls then SaveNewspulls;
         OnClick (Sender)
      end
   end
end;

procedure TfrmConfigNews.btnNewsPullsAddClick(Sender: TObject);
var  i: Integer;
     Liste: TStringList;
begin
   if GlobalListMarker( glTEST ) then begin
      {if MessageBox( Handle, PChar(Tr('GroupsChanged-Rebuild.Text',
         'List of available newsgroups has changed.^M'
         + 'Rebuild the global list, used for selecting new groups, now?')),
         PChar(Tr('GroupsChanged-Rebuild.Caption','Rebuild global lists')),
         MB_ICONQUESTION or MB_YESNO )=IDYES
      then begin}
         InterlockedIncrement( CriticalState );
         Enabled := False;
         SplashOn( TrGl(kMessages, 'Rebuild_Grouplist', 'Rebuilding group-list.^MPlease wait!') );
         Screen.Cursor := crHourGlass;
         Application.ProcessMessages;
         With TThreadRebuildGroupsList.Create do try
            FreeOnTerminate := False;
            Resume;
            while WaitForSingleObject(Handle,1000)=WAIT_TIMEOUT do Application.ProcessMessages;
         finally
            Free
         end;
         Screen.Cursor := crDefault;
         SplashOff;
         Enabled := True;
         InterlockedDecrement( CriticalState );
      {end;}
   end;
   Liste := TStringList.Create;
   try
      If GetGroupPull (Liste) then begin
         For i := 0 to Liste.Count-1 do AddNewsPull (Liste[i]);
         SaveNewsgroups;
         SaveNewspulls;
         lstNewsgroups.Refresh
      end
   finally
      Liste.free
   end
end;

procedure TfrmConfigNews.btnNewsPullsDelClick(Sender: TObject);
Var Anz, p, i, Idx, Offs: Integer; s, s1, s2: String;
begin
   With lstNewsPulls do begin
      Anz := 0;
      For i := 0 to Items.Count-1 do If selected[i] then begin
         Inc(Anz);
         s1 := Items[i];
         p := Pos(',', s1);
         s2 := Copy(s1, p+1, Length(s1));
         Delete (s1, p, Length(s2)+1);
      end;
      Case Anz of
         0: Exit;
         1: s := TrF('DeleteNewsPull.Ask', 'Delete pull of group "%s" over newsserver "%s"?',
                 [Trim(s1), Trim(s2)]);
         else s := TrF('DeleteNewsPulls.Ask', 'Delete these %s pulls now?', IntToStr(Anz));
      end;
      If MessageBox( Handle,
         PChar(s + ' (' + HinweisFinaleAenderung+')'),
         PChar(Caption),
         MB_ICONQUESTION or MB_YESNO or MB_DEFBUTTON2 ) = IDYES
      then begin
         Offs := 0;
         For i := 0 to Items.Count-1 do If Selected[i-Offs] then begin
            Idx := i-Offs;
            Inc(Offs);
            Items.Delete (Idx)
         end;
         SaveNewspulls;
         OnClick (Sender)
      end
   end
end;

procedure TfrmConfigNews.lstNewsgroupsDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var  t, t2: String;
begin
     with (Control as TListBox).Canvas do begin
        t := (Control as TListBox).Items[Index];
        if not CfgHamster.ExistPullServer(t) then begin
           if [odSelected]<=State then Font.Color := clYellow
                                  else Font.Color := clBlue;
        end;
        Case CfgHamster.ActiveType[t] of
           'm': t2 := ' ('+Tr('Group.is.moderated', 'moderated')+')';
           'n': t2 := ' ('+Tr('Group.is.ReadOnly', 'read-only')+')';
           'g': t2 := ' ('+Tr('Group.is.Gateway', 'gateway')+')';
           else t2 := ''
        end;
        FillRect(Rect);
        TextOut( Rect.Left, Rect.Top, t );
        If t2 > '' then begin
           If Not (odSelected IN State) then Font.Color := clGreen;
           TextOut( Rect.Left + TextWidth(t), Rect.Top, t2 )
        end
     end;
end;

procedure TfrmConfigNews.lstSrvNntpDblClick(Sender: TObject);
begin
   btnSrvNntpSetClick (self)
end;

procedure TfrmConfigNews.Button2Click(Sender: TObject);
begin
   SaveSettings
end;

procedure TfrmConfigNews.butPurgeNowClick(Sender: TObject);
Var i: Integer; 
begin
   AllShutdownReq := False;
   HamsterMainWindow.Timer1Timer(Self);
   IncCounter(CanCloseNow,1);
   With lstNewsgroups do try
      Log( LOGID_SYSTEM, TrGl(kLog, 'System.Purge.Start', 'Starting purge ...') );
      For i := 0 to Items.Count-1 do begin
         If selected[i] then begin
            TThreadPurge.Create( HAM_PURGEOPT_DONEWS, Items[i], NIL).resume
         end
      end
   finally
      IncCounter(CanCloseNow,-1);
   end
end;

procedure TfrmConfigNews.lstSrvNntpDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var  t, ID, User, PW, u, p: String;
begin
    with (Control as TListBox).Canvas do begin
       t := (Control as TListBox).Items[Index];
       ID := Copy(t, 1, Pos(',', t)-1);
       If CfgHamster.ServerIsReadOnly[ID]
          then Font.Color := clGreen;
       If PasswordFile.LoadPassword (ID, User, PW) then begin
          PasswordFile.PasswordInfo (ID, User, PW, U, P);
          t := t + ', '+U+'/'+P
       end;
       FillRect(Rect);
       TextOut( Rect.Left, Rect.Top, t );
    end;
end;

procedure TfrmConfigNews.lstNewsgroupsDblClick(Sender: TObject);
Var Group: String; i: Integer;
begin
   With lstNewsgroups do begin
      For i := 0 to Items.Count-1 do If Selected[i] then begin
         Group := Items[i]; break
      end
   end;
   If Not Actions.Exec ( atGroupDblClick, Group, '' )
      then btnNewsgroupsSetClick (self)
end;

procedure TfrmConfigNews.butServerNewsPullsClick(Sender: TObject);
Var Server, AddGr, DelGr: String; p: Integer;
begin
   If lstSrvNntp.ItemIndex >= 0 then begin
      Server := lstSrvNntp.Items[lstSrvNntp.ItemIndex];
      Server := Copy(Server, 1, Pos(',', Server)-1);
      If GroupPullsForServer (Server, AddGr, DelGr) and (AddGr+DelGr>'') then begin
         Repeat
            p := pos(',', AddGr);
            If p>0 then begin
               AddNewsPull ( Copy(AddGr, 1, p) + Server );
               Delete (AddGr, 1, p)
            end
         Until p = 0;
         Repeat
            p := pos(',', DelGr);
            If p>0 then begin
               DelNewsPull ( Copy(DelGr, 1, p) + Server );
               Delete (DelGr, 1, p)
            end
         Until p = 0;
         SaveNewsgroups;
         SaveNewspulls;
         lstNewsgroups.Refresh
      end
   end
end;

procedure TfrmConfigNews.FormDestroy(Sender: TObject);
begin
   TI := pg.ActivePage.PageIndex
end;

procedure TfrmConfigNews.AddNewsPull(const Pull: String);
Var j: Integer; s: String;
begin
   s := Pull; j := Pos( ',', s );
   if (s<>'') and (j>0) then begin
      if lstNewsPulls.Items.IndexOf( s ) < 0 then begin
         lstNewsPulls.ItemIndex := lstNewsPulls.Items.Add( s );
      end else begin
         lstNewsPulls.ItemIndex := lstNewsPulls.Items.IndexOf( s );
      end;
      // ggf. neue Gruppe erstellen
      s := TrimWhSpace( copy( s, 1, j-1 ) );
      if s<>'' then begin
         j := lstNewsgroups.Items.IndexOf( s );
         if j<0 then begin
            lstNewsgroups.ItemIndex := lstNewsgroups.Items.Add( s );
            CreateGroup( s ); // Gruppenpfad erstellen
         end
      end
   end
end;

procedure TfrmConfigNews.DelNewsPull(const Pull: String);
Var i: Integer;
begin
   With lstNewsPulls do begin
      i := Items.IndexOf(Pull);
      If i>=0 then begin
         Items.Delete( i );
         SaveNewspulls;
         if Items.Count>0 then begin
            if i>=Items.Count then dec(i);
            ItemIndex := i
         end;
         Refresh
      end
   end
end;

procedure TfrmConfigNews.lstNewsPullsDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
Var p, l: Integer; t: String;
begin
{   with (Control as TListBox).Canvas do begin
      Font.Style := [];
      t := (Control as TListBox).Items[Index];
      p := Pos(',', t);
      FillRect(Rect);
      If CfgHamster.ServerIsReadOnly[Copy(t, p+1, Length(t))]
         then Font.Color := clGreen
         else Font.Color := clBlue;
      TextOut( Rect.Left, Rect.Top, Copy(t, 1, p));
      l := TextWidth( Copy(t, 1, p) );
      Font.Color := clBlack;
      TextOut( Rect.Left + l, Rect.Top, Copy(t, p+1, Length(t)-p));
   end; }
   with (Control as TListBox).Canvas do begin
      t := (Control as TListBox).Items[Index];
      p := Pos(',', t);
      FillRect(Rect);
      If CfgHamster.ServerIsReadOnly[Copy(t, p+1, Length(t))] then Font.Color := clGreen;
      Font.Style := [fsBold];
      TextOut( Rect.Left, Rect.Top, Copy(t, 1, p));
      l := TextWidth( Copy(t, 1, p)+' ' );
      Font.Style := [];
      TextOut( Rect.Left + l, Rect.Top, Copy(t, p+1, Length(t)-p));
   end;
end;

procedure TfrmConfigNews.butPullNowClick(Sender: TObject);
Var i, j: Integer; Gruppe: String; b: Boolean;
begin
   With lstNewsgroups, NewsJobs.Joblist do begin
      Enter;
      b := false;
      try
         For i := 0 to Items.Count-1 do If selected[i] then begin
            b := true;
            Gruppe := Items[i];
            For j := 0 to CfgHamster.PullCount-1 do begin
               If CfgHamster.PullGroup[j] = Gruppe then begin
                  JobSet ( CfgHamster.PullServer[j], JOBTYPE_NEWSPULL, Gruppe, 999 )
               end
            end
         end;
         If b then NewsJobs.StartThreads ('')
      finally
         Leave
      end
   end
end;

procedure TfrmConfigNews.cbPullLimitDefClick(Sender: TObject);
begin
   TestPullLimitFields
end;

procedure TfrmConfigNews.TestPullLimitFields;
begin
   emPullLimit.Visible := cbPullLimitDef.ItemIndex > 0;
   emPullFirst.Visible := cbPullLimitEmpty.ItemIndex > 0;
end;

procedure TfrmConfigNews.chkGetPartsClick(Sender: TObject);
begin
   Test
end;



procedure TfrmConfigNews.Test;
begin
   txtGetPartsMax.Enabled := chkGetParts.Checked;
   txtGetPartsMin.Enabled := chkGetParts.Checked;
end;

procedure TfrmConfigNews.butResetGroupClick(Sender: TObject);
Var Anz, i: Integer; s1, s2: String; ResetIni: Boolean;
begin
   With lstNewsgroups do begin
      Anz := 0;
      For i := 0 to Items.Count-1 do If selected[i] then Inc(Anz);
      Case Anz of
         0: Exit;
         1: begin
               s1 := Tr('ResetGroup.AskStart', 'Do you really want to reset this group? '
                     + 'This will kill all saved articles and depending entries in the '
                     + 'news history and is not reversible!');
               s2 := Tr('ResetGroup.Caption', 'Reset group')
            end;
         else
            begin
               s1 := TrF('ResetGroups.AskStart', 'Do you really want to reset these %s groups? '
                     + 'This will kill all saved articles and depending entries in the '
                     + 'news history and is not reversible!', IntToStr(Anz));
               s2 := Tr('ResetGroups.Caption', 'Reset groups')
            end
      end;
      If MessageBox( Handle, PChar(s1), PChar(s2), MB_ICONQUESTION or MB_YESNO or MB_DEFBUTTON2 )
         = IDYES
      then begin
         Case MessageBox( Handle, PChar(Tr('ResetGroups.AskResetIni',
            'Reset the INI-File? If "Yes", Hamster will handle the group as completly new, so that'
              +' next pull elder articles will be reloaded again with new internal numbers.')),
            PChar(s2), MB_ICONQUESTION or MB_YESNOCANCEL )
         of
           IDYES: ResetIni := true;
           IDNo: ResetIni := false;
           else exit
         end;
         AllShutdownReq := False;
         HamsterMainWindow.Timer1Timer(Self);
         IncCounter(CanCloseNow,1);
         try
            Log( LOGID_SYSTEM, TrGl(kLog, 'System.Reset.Start', 'Starting reset ...') );
            For i := 0 to Items.Count-1 do begin
               If selected[i] then begin
                  TThreadPurgeReset.Create( Items[i], ResetIni ).resume
               end
            end
         finally
            IncCounter(CanCloseNow,-1)
         end
      end
   end
end;

procedure TfrmConfigNews.lstNewsgroupsClick(Sender: TObject);
Var Anz, i: Integer;
begin
   Anz := 0;
   With lstNewsgroups do begin
      For i := 0 to Items.Count-1 do If selected[i] then Inc(Anz)
   end;
   btnNewsgroupsSet.Enabled := Anz = 1;
   butPullNow.Enabled := Anz > 0;
   butPurgeNow.Enabled := Anz > 0;
   butResetGroup.Enabled := Anz > 0;
   btnNewsgroupsDel.Enabled := Anz > 0
end;

procedure TfrmConfigNews.lstNewsPullsClick(Sender: TObject);
Var Anz, i: Integer;
begin
   Anz := 0;
   With lstNewsPulls do begin
      For i := 0 to Items.Count-1 do If selected[i] then Inc(Anz)
   end;
   btnNewsPullsDel.Enabled := Anz > 0
end;

procedure TfrmConfigNews.chkAdvancedSettingsClick(Sender: TObject);
Var b: Boolean;
begin

   b := chkAdvancedSettings.Checked;

   chkGetParts.Visible := b;
   labGetPartsMax.Visible := b;
   txtGetPartsMax.Visible := b;
   labGetPartsMin.Visible := b;
   txtGetPartsMin.Visible := b;
   gbAdditionalSettings.Visible := b;
   butPullNow.Visible := b;
   butPurgeNow.Visible := b;

end;

end.

