// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit HConfigSettings;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, dGroupSelect, uTools, cStdForm,
  Mask, ToolEdit;

type
  TfrmConfigSettings = class(THForm)
    pg: TPageControl;
    TabSettings: TTabSheet;
    grpSetLog2: TGroupBox;
    labViewLog: TLabel;
    chkVError: TCheckBox;
    chkVWarning: TCheckBox;
    chkVSystem: TCheckBox;
    chkVInfo: TCheckBox;
    chkVDebug: TCheckBox;
    labLogfileLinesToView2: TLabel;
    emLogView: TEdit;
    TabOnlineMenu: TTabSheet;
    Label24: TLabel;
    lstMenuAvail: TListBox;
    lstMenuSel: TListBox;
    btnMenuSel: TButton;
    btnMenuDel: TButton;
    lbMenuItems: TListBox;
    labAvServ: TLabel;
    labSelServ: TLabel;
    labTitle: TLabel;
    emMenuTitle: TEdit;
    grpSetHam: TGroupBox;
    chkStartupHide: TCheckBox;
    chkVDetail: TCheckBox;
    chkMinimizeOnClose: TCheckBox;
    TabSheet1: TTabSheet;
    chkSplashScreen: TCheckBox;
    Button1: TButton;
    Button2: TButton;
    butChooseLanguage: TButton;
    chkAskOutbox: TCheckBox;
    Label1: TLabel;
    ListBox1: TListBox;
    Label2: TLabel;
    Button4: TButton;
    Button5: TButton;
    butUp: TButton;
    butDown: TButton;
    butSeparator: TButton;
    butDel: TButton;
    TabInternalGroups: TTabSheet;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    cbPostedOK: TComboBox;
    cbPostedFails: TComboBox;
    cbStatistics: TComboBox;
    cbCancels: TComboBox;
    cbNewGroups: TComboBox;
    cbUnknown: TComboBox;
    cbPullErrors: TComboBox;
    TabSheet3: TTabSheet;
    grpSetEditor: TGroupBox;
    labEditor: TLabel;
    labEditorPars: TLabel;
    txtEditor: TFilenameEdit;
    txtEditorPars: TEdit;
    GbTimoutExternal: TGroupBox;
    Label12: TLabel;
    Label15: TLabel;
    emTimeoutConnect: TEdit;
    emTimeoutCommand: TEdit;
    labRefreshTitle: TLabel;
    tbRefresh: TTrackBar;
    labRefreshValue: TLabel;
    chkAutoActivateErrorLog: TCheckBox;
    gbTaskDelimiter: TGroupBox;
    labTaskDelimiter: TLabel;
    emTaskDelimiter: TEdit;
    gbScriptLanguage: TGroupBox;
    butHelp: TButton;
    labHs2Shell: TLabel;
    cbhs2Shell: TComboBox;
    butRegisterHsc: TButton;
    labDefGr: TLabel;
    cbDefGroup: TComboBox;
    butCreateLocalGroup: TButton;
    tsSSL: TTabSheet;
    labRandFile: TLabel;
    gbCerts: TGroupBox;
    labPrivateKeyPair: TLabel;
    labCaPath: TLabel;
    labCaFile: TLabel;
    labPassword: TLabel;
    labPWStatus: TLabel;
    txtVerifyFile: TEdit;
    txtPrivateKeyPair: TEdit;
    butPWSet: TButton;
    btnSSLAdvanced: TButton;
    gbEncryption: TGroupBox;
    chkCiphLow: TCheckBox;
    chkCiphMedium: TCheckBox;
    chkCiphHigh: TCheckBox;
    gbProtocols: TGroupBox;
    chkSSLv3: TCheckBox;
    chkTLSv1: TCheckBox;
    txtRandFile: TEdit;
    txtVerifyPath: TDirectoryEdit;
    chkAdvancedSettings: TCheckBox;
    tsLogfiles: TTabSheet;
    gbMainlog: TGroupBox;
    LabLogFiles: TLabel;
    emLogFiles: TEdit;
    labSaveLog2: TLabel;
    chkFError: TCheckBox;
    chkFWarning: TCheckBox;
    chkFSystem: TCheckBox;
    chkFInfo: TCheckBox;
    chkFDetail: TCheckBox;
    chkFDebug: TCheckBox;
    gbAdditionalLogs: TGroupBox;
    butOpenLog1: TButton;
    labOpenLogfile: TLabel;
    butOpenLog2: TButton;
    butOpenLog3: TButton;
    butOpenLog4: TButton;
    Label13: TLabel;
    labSaveMaxLines: TLabel;
    labIncomingMails: TLabel;
    txtMaxLogLinesIncomingMails: TEdit;
    txtMaxLogLinesOutgoingMails: TEdit;
    txtMaxLogLinesOutgoingNews: TEdit;
    txtMaxLogLinesRAS: TEdit;
    labOutgoingMails: TLabel;
    labOutgoingNews: TLabel;
    labRASLog: TLabel;
    butOpenLogIncomingMails: TButton;
    butOpenLogOutgoingMails: TButton;
    butOpenLogOutgoingNews: TButton;
    butOpenLogRAS: TButton;
    butHideMenuItems: TButton;
    gbCodepage: TGroupBox;
    labCodepage: TLabel;
    cbCodepage: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure lbMenuItemsClick(Sender: TObject);
    procedure btnMenuSelClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure butChooseLanguageClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure emMenuTitleChange(Sender: TObject);
    procedure butUpClick(Sender: TObject);
    procedure butSeparatorClick(Sender: TObject);
    procedure tbRefreshChange(Sender: TObject);
    procedure butRegisterHscClick(Sender: TObject);
    procedure butCreateLocalGroupClick(Sender: TObject);
    procedure btnSSLAdvancedClick(Sender: TObject);
    procedure butPWSetClick(Sender: TObject);
    procedure chkAdvancedSettingsClick(Sender: TObject);
    procedure butOpenAnyLogClick(Sender: TObject);
    procedure butHideMenuItemsClick(Sender: TObject);
  private
    { Private-Deklarationen }
    User, PW: String; UChg: boolean; {MG}{SSL}
    CalcRefreshTime_Fmt: String;
    procedure LoadSettings;
    procedure SaveSettings;
    procedure CalcRefreshTime;
    procedure SetPWInfo; {MG}{SSL}
  protected
    Function ChangeLanguageFor(c: TComponent): boolean; override;
  public
    { Public-Deklarationen }
    LanguageChanged: boolean;
  end;

implementation

uses Global, Config, cPasswordFile, cArtFiles, HConfigGroup, cClientNNTP,
     FileCtrl, cAccount, fAccount, dInput, tMaintenance, dSplash, HConfigSSLAdvanced,
     Registry, cLogFile, dMainMenuItems, Main;

{$R *.DFM}

Const KeyID = 'OpenSSL private certificate'; {MG}{SSL}

procedure TfrmConfigSettings.LoadSettings;

   Procedure SetIG (Von: TStrings; Nach: TComboBox; Const Bez: String;
      Const AllowDefEntry: Boolean = true);
   Var s, def: String; p: Integer;
   begin
      Nach.Items.Assign (von);
      If AllowDefEntry then Nach.Items.Insert(0, Tr('Default-Entry', '<Default>'));
      def := CfgIni.ReadString( 'Setup', 'internalgroup.default', 'internal.misc');
      s := CfgIni.ReadString( 'Setup', 'internalgroup.' + Bez, def);
      p := Nach.Items.IndexOf(s);
      If AllowDefEntry and ((LowerCase(s) = LowerCase(def)) or (p<0))
         then Nach.ItemIndex := 0
         else If p >= 0 then Nach.ItemIndex := p
   end;

   Procedure SetViewLogCheckbox( Const i: Integer; chk: TCheckbox; Const ID: Integer );
   Var idx: Integer;
   begin
      idx := HamsterMainWindow.LogIDtoIndex(ID);
      chk.Checked := (i and ID ) <> 0;
      chk.Font.Color := HamsterMainWindow.FontColor[Idx];
      chk.Color      := HamsterMainWindow.BrushColor[Idx];
   end;

var  p, i, MenuNo: Integer;
     s, Title : String;
     sl: TStringlist;
     r: TSearchRec;
begin
   chkAdvancedSettings.Checked := Def_AdvancedConfiguration;

   tbRefresh.Position := CfgIni.ReadInteger( 'Setup', 'log.file.refresh', LOGFILEREFRESH );

   emLogFiles.Text  := inttostr( CfgIni.ReadInteger( 'Setup', 'log.file.max', Logfile.FileMax ) );
   emLogView.Text   := inttostr( CfgIni.ReadInteger( 'Setup', 'log.view.max', Logfile.Viewmax ) );

   emTimeoutConnect.text := inttostr( CfgIni.ReadInteger( 'Setup', 'remote.timeout.connect', Def_RemoteTimeoutConnect ) );
   emTimeoutCommand.text := inttostr( CfgIni.ReadInteger( 'Setup', 'remote.timeout.command', Def_RemoteTimeoutCommand ) );

   chkStartupHide.Checked := ( CfgIni.ReadInteger('Setup','startup.hide',1) = 1 );
   chkSplashScreen.Checked := ( CfgIni.ReadInteger('Setup','startup.splash',1) = 1 );
   chkAskOutbox.Checked := ( CfgIni.ReadInteger('Setup','main.AskIfOutboxNotEmpty', 0) = 1 );
   chkMinimizeOnClose.Checked := CfgIni.ReadBool('Setup','main.minimizeonclose',Def_MinimizeOnClose);
   With cbhs2Shell do try
      ItemIndex := CfgIni.ReadInteger('Main','ShowShell',Def_ShowShell);
      If ItemIndex < 0 then ItemIndex := 0
   except
      ItemIndex := 0
   end;

   chkAutoActivateErrorLog.Checked := CfgIni.ReadBool('Setup','main.autoactivateerrorlog',Def_AutoActivateErrorLog);

   txtEditor.text := CfgIni.ReadString ( 'Setup', 'editor.app', Def_EditorApp );
   txtEditorPars.text := CfgIni.ReadString ( 'Setup', 'editor.params', Def_EditorParams );

   i := strtoint( '$' + CfgIni.ReadString ( 'Setup', 'log.file.mask', inttohex( Logfile.FileMask, 4 ) ) );
   SetViewLogCheckbox( i, chkFError,   LOGID_ERROR  );
   SetViewLogCheckbox( i, chkFWarning, LOGID_WARN   );
   SetViewLogCheckbox( i, chkFSystem,  LOGID_SYSTEM );
   SetViewLogCheckbox( i, chkFInfo,    LOGID_INFO   );
   SetViewLogCheckbox( i, chkFDetail,  LOGID_DETAIL );
   SetViewLogCheckbox( i, chkFDebug,   LOGID_DEBUG  );
   // chkFFull   .Checked := (i and LOGID_FULL  )<>0;

   i := strtoint( '$' + CfgIni.ReadString ( 'Setup', 'log.view.mask', inttohex( Logfile.ViewMask, 4 ) ) );
   SetViewLogCheckbox( i, chkVError,   LOGID_ERROR  );
   SetViewLogCheckbox( i, chkVWarning, LOGID_WARN   );
   SetViewLogCheckbox( i, chkVSystem,  LOGID_SYSTEM );
   SetViewLogCheckbox( i, chkVInfo,    LOGID_INFO   );
   SetViewLogCheckbox( i, chkVDetail,  LOGID_DETAIL );
   SetViewLogCheckbox( i, chkVDebug,   LOGID_DEBUG  );
   // chkVFull   .Checked := (i and LOGID_FULL  )<>0;

   txtMaxLogLinesIncomingMails.Text := CfgIni.ReadString('Setup', 'purge.mailinlog.keeplines',  '0');
   txtMaxLogLinesOutgoingMails.Text := CfgIni.ReadString('Setup', 'purge.mailoutlog.keeplines', '0');
   txtMaxLogLinesOutgoingNews.Text  := CfgIni.ReadString('Setup', 'purge.newsoutlog.keeplines', '0');
   txtMaxLogLinesRAS.Text           := CfgIni.ReadString('Setup', 'purge.rasdiallog.keeplines', '0');

   With lbMenuItems do With Items do begin
      For MenuNo:=1 to 9 do begin
         s := CfgIni.ReadString( 'Online-Menu', 'Title'+inttostr(MenuNo), '');
         If s = '' then Title := Tr('OnlineMenu.Empty', '(empty)') else Title := s;
         With TStringlist(Objects[AddObject( Title, TStringlist.Create)]) do begin
            Add (s);
            Add (CfgIni.ReadString( 'Online-Menu', 'Server'+inttostr(MenuNo), '' ))
         end
      end
   end;
   lbMenuItemsClick( self );

   emTaskDelimiter.Text := IntToStr(CfgIni.ReadInteger ( 'Setup', 'MaxTasks',Def_MaxTasks));

   sl := TStringlist.Create;
   With sl do try
      if FileExists2( PATH_BASE + CFGFILE_ACTIVE ) then LoadFromFile( PATH_BASE + CFGFILE_ACTIVE );
      For i := Count-1 downto 0 do If CfgHamster.ExistPullServer(Strings[i]) then Delete(i);
      Sorted := true;
      SetIG (sl, cbDefGroup,      'default', false);
      SetIG (sl, cbPostedOk,      'postok');
      SetIG (sl, cbPostedFails,   'posterrors');
      SetIG (sl, cbStatistics,    'statistics');
      SetIG (sl, cbCancels,       'cancelnotify');
      SetIG (sl, cbNewGroups,     'newgroups');
      SetIG (sl, cbUnknown,       'unknowngroup');
      SetIG (sl, cbPullErrors,    'pullerrors');
   finally free end;

   {MG}{SSL}
   User := '';
   DoEnable ( tsSSL, SSLReady, 2 );
   with CfgIni do begin
      txtRandFile.Text        := ReadString ( 'SSL', 'RandFile', '' );
      txtPrivateKeyPair.text  := ReadString ( 'SSL', 'PrivateKeyPair', '' );
      txtVerifyPath.text      := ReadString ( 'SSL', 'CaPath', '' );
      txtVerifyFile.text      := ReadString ( 'SSL', 'CaFile', '' );
      chkSSLv3.Checked        := ReadBool ( 'SSL', 'UseSSLv3', True );
      chkTLSv1.Checked        := ReadBool ( 'SSL', 'UseTLSv1', True );
      chkCiphLow.Checked      := ReadBool ( 'SSL', 'LowEncryption', False );
      chkCiphMedium.Checked   := ReadBool ( 'SSL', 'MediumEncryption', True );
      chkCiphHigh.Checked     := ReadBool ( 'SSL', 'HighEncryption', True );
   end;
   PasswordFile.LoadPassword( KeyID, User, PW );
   SetPWInfo;
   UChg := false;

   With cbCodepage do begin
      Items.Clear;
      If FindFirst(PATH_BASE + '*_*.cnv', faAnyfile-faDirectory-faVolumeID, r)=0 then try
         Text := CfgIni.ReadString ( 'Setup', 'local.codepage', Def_Codepage);
         Repeat
            s := ChangeFileExt(r.Name, '');
            p := Pos('_', s);
            If p > 0 then begin
               Delete(s, 1, p);
               If Items.IndexOf(s)<0 then Items.Add(s)
            end
         until FindNext(r)<>0
      finally
         FindClose(r)
      end;
   end;
   CalcRefreshTime
end;

procedure IniWriteInt( Section, Item, Value: String );
var  iValue: Integer;
begin
     try
        iValue := strtoint( Value );
        CfgIni.WriteInteger( Section, Item, iValue );
     except
     end;
end;

procedure TfrmConfigSettings.SaveSettings;

   Procedure SetIG (cb: TComboBox; Const Bez: String;
          Const AllowDefEntry: Boolean = true);
   begin
      If AllowDefEntry and (cb.ItemIndex=0)
         then CfgIni.DeleteKey ('Setup', 'internalgroup.' + Bez)
         else If cb.ItemIndex >= 0 then CfgIni.WriteString( 'Setup', 'internalgroup.' + Bez, cb.Items[cb.ItemIndex])
   end;

var  i, MenuNo: Integer;
begin
   CfgIni.WriteInteger( 'Setup', 'log.file.refresh', tbRefresh.Position );

   if chkStartupHide.Checked then i:=1 else i:=0;
   CfgIni.WriteInteger( 'Setup', 'startup.hide', i );

   if chkSplashScreen.Checked then i:=1 else i:=0;
   CfgIni.WriteInteger( 'Setup', 'startup.splash', i );

   if chkAskOutbox.Checked then i:=1 else i:=0;
   CfgIni.WriteInteger( 'Setup', 'main.AskIfOutboxNotEmpty', i );

   CfgIni.WriteBool( 'Setup', 'main.minimizeonclose', chkMinimizeOnClose.Checked );
   CfgIni.WriteBool( 'Setup', 'main.autoactivateerrorlog', chkAutoActivateErrorLog.Checked );

   CfgIni.WriteInteger('Main','ShowShell', cbhs2Shell.ItemIndex);

   CfgIni.WriteString ( 'Setup', 'editor.app', txtEditor.text );
   CfgIni.WriteString ( 'Setup', 'editor.params', txtEditorPars.text );

   IniWriteInt( 'Setup', 'log.view.max',            emLogView.Text );
   IniWriteInt( 'Setup', 'log.file.max',            emLogFiles.Text );

   IniWriteInt( 'Setup', 'remote.timeout.connect', emTimeoutConnect.text );
   IniWriteInt( 'Setup', 'remote.timeout.command', emTimeoutCommand.text );

   i := 0;
   if chkFError  .Checked then i := (i or LOGID_ERROR );
   if chkFWarning.Checked then i := (i or LOGID_WARN  );
   if chkFSystem .Checked then i := (i or LOGID_SYSTEM);
   if chkFInfo   .Checked then i := (i or LOGID_INFO  );
   if chkFDetail .Checked then i := (i or LOGID_DETAIL);
   if chkFDebug  .Checked then i := (i or LOGID_DEBUG );
   // if chkFFull   .Checked then i := (i or LOGID_FULL  );
   Logfile.FileMask := i;
   CfgIni.WriteString ( 'Setup', 'log.file.mask', inttohex( i, 4 ) );

   i := 0;
   if chkVError  .Checked then i := (i or LOGID_ERROR );
   if chkVWarning.Checked then i := (i or LOGID_WARN  );
   if chkVSystem .Checked then i := (i or LOGID_SYSTEM);
   if chkVInfo   .Checked then i := (i or LOGID_INFO  );
   if chkVDetail .Checked then i := (i or LOGID_DETAIL);
   if chkVDebug  .Checked then i := (i or LOGID_DEBUG );
   Logfile.ViewMask := i;
   // if chkVFull   .Checked then i := (i or LOGID_FULL  );
   CfgIni.WriteString ( 'Setup', 'log.view.mask', inttohex( i, 4 ) );

   CfgIni.WriteInteger('Setup', 'purge.mailinlog.keeplines',
      StrToInt('0'+Trim(txtMaxLogLinesIncomingMails.Text)));
   CfgIni.WriteInteger('Setup', 'purge.mailoutlog.keeplines',
      StrToInt('0'+Trim(txtMaxLogLinesOutgoingMails.Text)));
   CfgIni.WriteInteger('Setup', 'purge.newsoutlog.keeplines',
      StrToInt('0'+Trim(txtMaxLogLinesOutgoingNews.Text)));
   CfgIni.WriteInteger('Setup', 'purge.rasdiallog.keeplines',
      StrToInt('0'+Trim(txtMaxLogLinesRAS.Text)));

   With lbMenuItems do With Items do begin
      For MenuNo:=1 to 9 do With TStringlist(Objects[MenuNo-1]) do begin
         CfgIni.WriteString( 'Online-Menu', 'Title'+inttostr(MenuNo), Strings[0] );
         CfgIni.WriteString( 'Online-Menu', 'Server'+inttostr(MenuNo),  Strings[1] )
      end
   end;

   SetIG (cbDefGroup,      'default', false);
   SetIG (cbPostedOk,      'postok');
   SetIG (cbPostedFails,   'posterrors');
   SetIG (cbStatistics,    'statistics');
   SetIG (cbCancels,       'cancelnotify');
   SetIG (cbNewGroups,     'newgroups');
   SetIG (cbUnknown,       'unknowngroup');
   SetIG (cbPullErrors,    'pullerrors');

   CfgIni.WriteInteger ( 'Setup', 'MaxTasks', StrToInt('0'+emTaskDelimiter.Text));
                              
   {MG}{SSL}
   if SSLReady then begin with CfgIni do begin
      WriteString( 'SSL', 'RandFile', txtRandFile.Text );
      WriteString( 'SSL', 'PrivateKeyPair', txtPrivateKeyPair.text );
      WriteString( 'SSL', 'CaPath', txtVerifyPath.text );
      WriteString( 'SSL', 'CaFile', txtVerifyFile.text );
      WriteBool( 'SSL', 'UseSSLv3', chkSSLv3.Checked );
      WriteBool( 'SSL', 'UseTLSv1', chkTLSv1.Checked );
      WriteBool( 'SSL', 'LowEncryption', chkCiphLow.Checked );
      WriteBool( 'SSL', 'MediumEncryption', chkCiphMedium.Checked );
      WriteBool( 'SSL', 'HighEncryption', chkCiphHigh.Checked );
   end end;
   If UChg then begin
      PasswordFile.SavePassword (false, KeyID, User, PW);
      PasswordFile.SavePassword (true, KeyID, User, PW);
   end;
   {/SSL}
   CfgIni.WriteString ( 'Setup', 'local.codepage', cbCodepage.text);

   Init_InternalGroups
end;

Var TI: Integer = 0;

procedure TfrmConfigSettings.FormCreate(Sender: TObject);
begin
   LoadSettings;

   With butChooseLanguage.Font do begin
      Size := Size + 2;
      Style := [fsBold]
   end;
   labPWStatus.Font.Style := [fsBold];

   LanguageChanged := false;
   pg.ActivePage := pg.Pages[TI];

   GbTimoutExternal.Visible := Not ArchivMode;

   butOpenLog1.Enabled := FileExists(LogFile.Logfilename(0));
   butOpenLog2.Enabled := FileExists(LogFile.Logfilename(1));
   butOpenLog3.Enabled := FileExists(LogFile.Logfilename(2));
   butOpenLog4.Enabled := FileExists(LogFile.Logfilename(3));
end;

procedure TfrmConfigSettings.lbMenuItemsClick(Sender: TObject);
var  i, k        : Integer;
     s, Srv      : String;
     b           : boolean;
     sl          : TStringlist;
begin
     lstMenuAvail.Clear;
     lstMenuSel.Clear;

     i := lbMenuItems.ItemIndex;
     b := (i>=0) and (i < lbMenuItems.Items.Count);

     butUp.enabled := b and (i>0);
     butDown.enabled := b and (i<lbMenuItems.Items.Count-1);
     butDel.enabled := b; butSeparator.enabled := b;

     labTitle.visible := b; emMenuTitle.visible := b;

     If b then begin
        s := TStringlist(lbMenuItems.Items.Objects[i])[0];
        emMenuTitle.Text := s;
        If (s = '') or (s = '-') then b := false
     end;
     labAvServ.visible := b; lstMenuAvail.visible := b;
     labSelServ.visible := b; lstMenuSel.visible := b;
     btnMenuSel.visible := b; btnMenuDel.visible := b;

     If not b then exit;

     With lbMenuItems do With Items do begin
        sl := TStringlist(Objects[i]);

        With TStringlist.Create do try
           If FileExists2( PATH_BASE + CFGFILE_SERVER_NNTP ) then begin
              LoadFromFile( PATH_BASE + CFGFILE_SERVER_NNTP );
              For i:=0 to Count-1 do begin
                 s := Strings[i]; if copy(s,1,1)='#' then s:='';
                 if s<>'' then lstMenuAvail.Items.Add( s )
              end
           end;
           if FileExists2( PATH_BASE + CFGFILE_SERVER_POP3 ) then begin
              LoadFromFile( PATH_BASE + CFGFILE_SERVER_POP3 );
              For i:=0 to Count-1 do begin
                 s := Strings[i]; if copy(s,1,1)='#' then s:='';
                 if s<>'' then lstMenuAvail.Items.Add( s )
              end
           end;
           if FileExists2( PATH_BASE + CFGFILE_SERVER_SMTP ) then begin
              LoadFromFile( PATH_BASE + CFGFILE_SERVER_SMTP );
              For i:=0 to Count-1 do begin
                 s := Strings[i]; if copy(s,1,1)='#' then s:='';
                 if s<>'' then lstMenuAvail.Items.Add( s )
              end
           end
        finally free end;

        s := sl[1]; if s='' then exit;

        i := 0;
        repeat
           Srv := ParseString( i, '', s, ';' );
           if Srv > '' then begin
              k := lstMenuAvail.Items.IndexOf(Srv);
              if k>=0 then begin
                 lstMenuSel.Items.Add( lstMenuAvail.Items[k] );
                 lstMenuAvail.Items.Delete( k );
              end;
              inc( i )
           end
        until Srv = ''
     end
end;

procedure TfrmConfigSettings.btnMenuSelClick(Sender: TObject);
var  i: Integer; s: String;
begin
     If (Sender = btnMenuSel) or (Sender = lstMenuAvail) then begin
        i := lstMenuAvail.ItemIndex; If i<0 then exit;
        lstMenuSel.Items.Add( lstMenuAvail.Items[i] );
        lstMenuAvail.Items.Delete( i )
     end else if (Sender = btnMenuDel) or (Sender = lstMenuSel) then begin
        i := lstMenuSel.ItemIndex; If i<0 then exit;
        lstMenuAvail.Items.Add( lstMenuSel.Items[i] );
        lstMenuSel.Items.Delete( i );
     end else exit;

     s := '';
     For i:=0 to lstMenuSel.Items.Count-1 do begin
        If i>0 then s := s + ';';
        s := s + lstMenuSel.Items[i]
     end;

     i := lbMenuItems.ItemIndex;
     If i >= 0 then With TStringlist(lbMenuItems.Items.Objects[i])
        do Strings[1] := s
end;

procedure TfrmConfigSettings.Button1Click(Sender: TObject);
begin
   SaveSettings;
   Modalresult := mrOk
end;

procedure TfrmConfigSettings.butChooseLanguageClick(Sender: TObject);
Var AktShell: Integer;
begin
   If SetLanguage then LanguageChanged := true;
   If LanguageChanged then begin
      //AktScriptLanguage := cbChooseScriptLanguage.ItemIndex;
      AktShell := cbhs2Shell.ItemIndex;
      LoadLanguageAgain;
      //cbChooseScriptLanguage.ItemIndex := AktScriptLanguage;
      cbhs2Shell.ItemIndex := AktShell
   end
end;

procedure TfrmConfigSettings.FormDestroy(Sender: TObject);
begin
   With lbMenuItems.Items do While Count > 0 do begin
      TStringlist(Objects[0]).free;
      Delete(0)
   end;
   TI := pg.ActivePage.PageIndex
end;

procedure TfrmConfigSettings.emMenuTitleChange(Sender: TObject);
Var s1, s2: String; i: Integer;
begin
   i := lbMenuItems.ItemIndex;
   If i >= 0 then With TStringlist(lbMenuItems.Items.Objects[i]) do begin
      s1 := Strings[0]; s2 := emMenuTitle.text;
      If s1 <> s2 then begin
         Strings[0] := emMenuTitle.text;
         If s2 = ''
            then lbMenuItems.Items[i] := Tr('OnlineMenu.Empty', '(empty)')
            else lbMenuItems.Items[i] := s2;
         If (s1 = '') or (s2 = '') or (s1 = '-') or (s2 = '-')
            then lbMenuItemsClick (self)
      end
   end
end;

procedure TfrmConfigSettings.butUpClick(Sender: TObject);
Var s: String; p: Pointer; v, b: Integer;
begin
   With lbMenuItems do begin
      v := ItemIndex;
      If Sender = butUp then b := v-1
      else If Sender = butDown then b := v+1
      else exit;
      If (v IN[0..Items.Count-1]) and (b IN[0..Items.Count-1]) then With Items do begin
         s := Items[v]; Items[v] := Items[b]; Items[b] := s;
         p := Objects[v]; Objects[v] := Objects[b]; Objects[b] := p;
         ItemIndex := b; OnClick(self)
      end
   end
end;

procedure TfrmConfigSettings.butSeparatorClick(Sender: TObject);
Var x: Integer; s: String;
begin
   With lbMenuItems do begin
      x := ItemIndex;
      If (x IN[0..Items.Count-1]) then begin

         If Sender = butSeparator then s := '-'
         else If Sender = butDel then s := ''
         else exit;

         TStringlist(Items.Objects[x])[0] := s;
         If s = '' then s := Tr('OnlineMenu.Empty', '(empty)');
         Items[x] := s;
         OnClick(self)
      end
   end
end;

function TfrmConfigSettings.ChangeLanguageFor(c: TComponent): boolean;
begin
   Result := (c <> cbDefGroup) and
             (c <> cbPostedOk) and (c <> cbPostedFails) and (c <> cbStatistics) and
             (c <> cbCancels) and (c <> cbNewGroups) and (c <> cbUnKnown) and
             (c <> cbPullErrors)
end;

procedure TfrmConfigSettings.tbRefreshChange(Sender: TObject);
begin
   CalcRefreshTime
end;

procedure TfrmConfigSettings.CalcRefreshTime;
begin
   If CalcRefreshTime_Fmt = '' then CalcRefreshTime_Fmt := labRefreshValue.caption;
   labRefreshValue.caption := Format(CalcRefreshTime_Fmt, [FormatFloat('0.000', tbRefresh.Position / 10)])
end;

procedure TfrmConfigSettings.butRegisterHscClick(Sender: TObject);
begin
   With TRegistry.Create do try
      RootKey := HKEY_LOCAL_MACHINE;
      OpenKey('Software\Classes\.hsc', true);
      WriteString('', 'HamsterScript');
      CloseKey;
      OpenKey('Software\Classes\HamsterScript', true);
      WriteString('', 'Hamster-Scriptfile');
      CloseKey;
      OpenKey('Software\Classes\HamsterScript\Shell\Open\Command', true);
      WriteString('', '"'+ParamStr(0)+'" "%1" %*');
      CloseKey;
      OpenKey('Software\Classes\HamsterScript\Shell\Edit\Command', true);
      WriteString('', 'Notepad.exe "%1"');
      CloseKey;
      OpenKey('Software\Classes\HamsterScript\DefaultIcon', true);
      WriteString('', PATH_BASE + 'scripts.ico');
      CloseKey;
   finally
      free
   end
end;

procedure TfrmConfigSettings.butCreateLocalGroupClick(Sender: TObject);
var  s: String;
begin
   s := '';
   if InputDlgStr( Tr('CreateLocalGroup.Caption', 'Create new local group'),
                   Tr('CreateLocalGroup.Prompt', 'Group-name:'),
                   s, 0 ) then
   begin
      If s = '' then Exit;
      if IsNewsgroup( s ) then begin
          If CfgHamster.ActiveIndexOf[s] < 0 then begin
             CreateGroup( s ); 
             // Add new Group to group lists
             cbDefGroup.Items.Add ( s );
             cbPostedOk.Items.Add ( s );
             cbPostedFails.Items.Add ( s );
             cbStatistics.Items.Add ( s );
             cbCancels.Items.Add ( s );
             cbNewGroups.Items.Add ( s );
             cbUnknown.Items.Add ( s );
             cbPullErrors.Items.Add ( s )
          end else begin
             Application.MessageBox(
                PChar(Tr('CreateLocalGroup.GroupExistsAlready', 'This groupname exists already!')),
                PChar(Tr('CreateLocalGroup.Caption', 'Add local Create new local group')), MB_ICONEXCLAMATION );
          end
      end else begin
         Application.MessageBox( PChar(Tr('CreateLocalGroup.InvalidGroupName', 'Invalid newsgroup-name!')),
                                 PChar(Tr('CreateLocalGroup.Caption', 'Create new local group')), MB_ICONEXCLAMATION );
      end;
   end
end;

procedure TfrmConfigSettings.btnSSLAdvancedClick(Sender: TObject);
begin
   Dialog_AdvancedSSLSettings
end;

{MG}{SSL}
procedure TfrmConfigSettings.butPWSetClick(Sender: TObject);
Var P1, P2: String;
begin
   if not InputDlgPwd( PChar(KeyID), TrGl(kGlobal, 'DlgPWEdit.Password',
      'Password (?=ask when needed):'), P1, 0{HlpInputUserPasswordForServer} )
   then exit;
   if P1<>'?' then begin
      if not InputDlgPwd( PChar(KeyID), TrGl(kGlobal, 'DlgPWEdit.RepeatPW',
         'Repeat password:'), P2, 0{HlpInputUserPasswordForServer} )
      then exit;
      if P1<>P2 then begin
         Application.MessageBox( PChar(TrGl(kGlobal,'DlgPWEdit.DifferentPWs',
            'Given passwords were not equal!^MPassword remains unchanged!')),
            PChar(TrGl(kGlobal,'DlgPWEdit.Caption', 'Change password')),
            MB_ICONEXCLAMATION );
         exit
      end;
      If Not CheckLatin1Charset(P1) then begin
         Application.MessageBox( PChar(TrGl(kGlobal,'DlgPWEdit.NoIsoCharsInPW',
            'Invalid password: It contains chars, which not exist in ASCII or ISO-8859-1, '
            +'this can cause problems with SSL!^MPassword remains unchanged!') ),
            PChar(TrGl(kGlobal,'DlgPWEdit.Caption', 'Change password')),
            MB_ICONEXCLAMATION );
         exit
      end
   end;
   PW := P1;
   UChg := true; SetPWInfo
end;

procedure TfrmConfigSettings.SetPWInfo;
Var u, p: String;
begin
   PasswordFile.PasswordInfo( KeyID, User, PW, u, p);
   labPWStatus.Caption := p
end;

procedure TfrmConfigSettings.chkAdvancedSettingsClick(Sender: TObject);
Var b: Boolean;
begin
   b := chkAdvancedSettings.Checked;
   // Sub Pages
   TabOnlineMenu.TabVisible := b and Not ArchivMode;
   TabInternalGroups.TabVisible := Not ArchivMode;
   tsSSL.TabVisible := b;
   // Group boxes
   gbTaskDelimiter.Visible := b;
   GbTimoutExternal.Visible := b;
   // Single Settings
   labHs2Shell.Visible := b; cbhs2Shell.Visible := b;
   labLogfileLinesToView2.Visible := b; emLogView.Visible := b;
   LabLogFiles.Visible := b and Not ArchivMode; emLogFiles.Visible := b and Not ArchivMode;
   labSaveLog2.Visible := Not ArchivMode;
   chkAskOutbox.Visible := Not ArchivMode;
   chkFError.Visible := Not ArchivMode;
   chkFWarning.Visible := Not ArchivMode;
   chkFSystem.Visible := Not ArchivMode;
   chkFInfo.Visible := Not ArchivMode;
   chkFDebug.Visible := Not ArchivMode;
   chkFDetail.Visible := Not ArchivMode;
end;

procedure TfrmConfigSettings.butOpenAnyLogClick(Sender: TObject);
Var x: Integer; s: String;
begin
   If Sender = NIL then Exit;
   x := (Sender as TButton).Tag;
   Case x of
      1..9: s := LogFile.Logfilename(x-1);
      10: s := PATH_LOGS + 'MailIn.log';
      20: s := PATH_LOGS + 'MailOut.log';
      30: s := PATH_LOGS + 'NewsOut.log';
      40: s := PATH_LOGS + 'RasDial.log';
      else Exit;
   end;
   If FileExists(s)
      then EditFile (s)
      else Application.MessageBox( PChar(TrF('EditLogfile.FileNotExists', 'File "%s" doesn''t exists.', s)),
             PChar(Caption), MB_ICONEXCLAMATION )
end;

procedure TfrmConfigSettings.butHideMenuItemsClick(Sender: TObject);
begin
   With HamsterMainWindow do begin
      If EditMenuItems ( Menu, [mnuConfigHamster,
         mnuOnline1, mnuOnline2, mnuOnline3, mnuOnline4, mnuOnline5,
         mnuOnline6, mnuOnline7, mnuOnline8, mnuOnline9],
         Def_HideMenuItems)
      then begin
         CfgIni.IWrite( 'Setup', 'main.hidemenuitems', Def_HideMenuItems );
         FullVisualSettings
      end
   end
end;

end.

