// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

program Hamster;

{%File 'H:\Hamster\Hamster_de.dat'}
{%File 'H:\Hamster\hamster_en.dat'}
{%File 'H:\Hamster\HamsterCmds_de.dat'}
{%File 'H:\Hamster\HamsterCmds.dat'}
{%File 'h:\hamster\hamster.ini'}
{%File 'Changes_en.txt'}
{%File 'Changes_de.txt'}

{$INCLUDE Compiler.inc}

uses
  Consts in 'Delphi\Consts.pas',
  OLEConst in 'Delphi\OLEConst.pas',
  Comconst in 'Delphi\Comconst.pas',
  Sysconst in 'Delphi\Sysconst.pas',
  Forms,
  IniFiles,
  ShellApi,
  Controls,
  Global in 'Global.pas',
  Config in 'Config.pas',
  uTools in 'uTools.pas',
  cHistoryNews in 'cHistoryNews.pas',
  cHistoryMail in 'cHistoryMail.pas',
  cArticle in 'cArticle.pas',
  cArticleFile in 'cArticleFile.pas',
  cArtFiles in 'cArtFiles.pas',
  cClientBase in 'cClientBase.pas',
  cClientNNTP in 'cClientNNTP.pas',
  cClientPOP3 in 'cClientPOP3.pas',
  cClientSMTP in 'cClientSMTP.pas',
  cFiltersBase in 'cFiltersBase.pas',
  cFiltersMail in 'cFiltersMail.pas',
  cFiltersNews in 'cFiltersNews.pas',
  cPasswordFile in 'cPasswordFile.pas',
  cIPAccess in 'cIPAccess.pas',
  Main in 'Main.pas' {HamsterMainWindow},
  dGroupSelectFromServer in 'dGroupSelectFromServer.pas' {GetGroupPullsForServerDlg},
  HConfigSettings in 'HConfigSettings.pas' {frmConfigSettings},
  HKillsMain in 'HKillsMain.pas' {frmKillsMain},
  dAbout in 'dAbout.pas' {DlgAbout},
  HConfigGroup in 'HConfigGroup.pas' {frmConfigGroup},
  HConfigScore in 'HConfigScore.pas' {frmConfigScore},
  Hamster_TLB in 'Hamster_TLB.pas',
  XApp in 'XApp.pas' {App: CoClass},
  cServerNNTP in 'cServerNNTP.pas',
  cServerPOP3 in 'cServerPOP3.pas',
  cServerSMTP in 'cServerSMTP.pas',
  cAccount2 in 'cAccount2.pas',
  fAccount in 'fAccount.pas' {frmAccount},
  cChunkRc in 'cChunkRc.pas',
  cIndexRc in 'cIndexRc.pas',
  dSplash in 'dSplash.pas' {DlgSplash},
  dInput in 'dInput.pas' {InputDlg},
  HConfigSMTPServer in 'HConfigSMTPServer.pas' {frmConfigSMTPServer},
  cHscEngine in 'cHscEngine.pas',
  cNewsJobs in 'cNewsJobs.pas',
  uMD5 in 'uMD5.pas',
  uBlowfish in 'uBlowfish.pas',
  uRasDyn in 'uRasDyn.pas',
  uPCRE in 'uPCRE.pas',
  cPCRE in 'cPCRE.pas',
  tBase in 'tBase.pas',
  tTransfer in 'tTransfer.pas',
  tMaintenance in 'tMaintenance.pas',
  tScript in 'tScript.pas',
  uWinSock in 'uWinSock.pas',
  uCRC32 in 'uCRC32.pas',
  uEncoding in 'uEncoding.pas',
  uDateTime in 'uDateTime.pas',
  cStdForm in 'cStdForm.pas',
  DSprache in 'DSprache.pas' {DlgSprache},
  HConfigNews in 'HConfigNews.pas' {frmConfigNews},
  HConfigMail in 'HConfigMail.pas' {frmConfigMail},
  dGroupSelect in 'dGroupSelect.pas' {GetGroupNameDlg},
  HConfigNewsServer in 'HConfigNewsServer.pas' {frmConfigNewsServer},
  dEditMailFilterSection in 'dEditMailFilterSection.pas' {DlgEditMailFilterSection},
  HConfigPOP3Server in 'HConfigPOP3Server.pas' {frmConfigPop3Server},
  cMailRouter in 'cMailRouter.pas',
  fGroup in 'fGroup.pas' {frmGroup},
  cMailAlias in 'cMailAlias.pas',
  dScripts in 'dScripts.pas' {DlgScripts},
  dIPAccess in 'dIPAccess.pas' {DlgIPAccess},
  HConfigLocalUser in 'HConfigLocalUser.pas' {frmConfigUserAndPW},
  DEditDir in 'DEditDir.pas' {DlgEditDir},
  dPopupBox in 'dPopupBox.pas',
  tScriptInsCmd in 'tScriptInsCmd.pas',
  cServerReCo in 'cServerReCo.pas',
  cServerBase in 'cServerBase.pas',
  cLogfile in 'cLogfile.pas',
  cSyncObjects in 'cSyncObjects.pas',
  cHscHamster in 'cHscHamster.pas',
  cResControl in 'cResControl.pas',
  uDynDLL in 'uDynDLL.pas',
  uSha1 in 'uSha1.pas',
  ComObj,
  ComServ,
  cActions in 'cActions.pas',
  uSSL in 'uSSL.pas',
  HConfigSSLAdvanced in 'HConfigSSLAdvanced.pas' {frmConfigSSLAdvanced},
  HConfigIPAccess in 'HConfigIPAccess.pas' {frmConfigIPAccess},
  HConfigAutomatic in 'HConfigAutomatic.pas' {frmConfigAutomatics},
  HConfigLocalServer in 'HConfigLocalServer.pas' {frmConfigLocalServer},
  uImapUtils in 'uimaputils.pas',
  cServerIMAP in 'cserverimap.pas',
  cImapMessage in 'cimapmessage.pas',
  hConfigSASL in 'hConfigSASL.pas' {DlgChooseSASL},
  dHistory in 'dHistory.pas' {DlgHistory},
  uCommands in 'uCommands.pas',
  dMainMenuItems in 'dMainMenuItems.pas' {DlgMainMenuItems},
  cIMAPMailbox in 'cIMAPMailbox.pas',
  cIMAPMailboxIndex in 'cIMAPMailboxIndex.pas',
  HMailKillsMain in 'HMailKillsMain.pas' {frmMailKillsMain},
  cAccount in 'cAccount.pas',
  cIMAPSearch in 'cIMAPSearch.pas';

{JW}

//HSR //Groups

{$R *.tlb}

{$R *.RES}

var  StartupHide: Integer;
     ShowSplash: boolean;
begin
  If LockApplication and (EVT_ISIDLE<>0) and (EVT_STOPSCRIPT<>0) then begin
     Logfile.Cached := false;
     Screen.Cursor := crAppStart;
     With CfgIni do begin
        Def_OLE_Server_Name := ReadString('Setup','comservername',Def_OLE_Server_Name);
        Def_OLE_Server := ReadInteger('Setup','startup.OLEServer', 1)=1;
        ShowSplash := ReadInteger ('Setup', 'startup.splash', 1) = 1;
        StartupHide := ReadInteger( 'Setup', 'startup.hide', 0 );
     end;
     If ShowSplash then SplashOn (TrGl(kMessages, 'HamsterStartedNow.wait', 'Hamster is starting now^MPlease wait a moment'));

     HamsterTrayIcon.hIcon := 0;

     If Def_OLE_Server then begin
        ComServer.SetServerName(Def_OLE_Server_Name);
        TAutoObjectFactory.Create(ComServer, TApp, Class_App, ciMultiInstance);
        Application.Initialize
     end;

     Application.Title := 'Hamster';

     if StartupHide=1 then Application.ShowMainForm := False;
     Application.CreateForm(THamsterMainWindow, HamsterMainWindow);
  Screen.Cursor := crDefault;
     Application.Run;

     if HamsterTrayIcon.hIcon<>0 then Shell_NotifyIcon( NIM_DELETE, @HamsterTrayIcon );

     UnlockApplication; // Unlock mutex.
  end else begin
     Logfile.Cancel
  end
end.

