unit dHistory;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls,
  cStdForm, ExtCtrls;

Procedure DialogHistory;

type
  TDlgHistory = class(THForm)
    tc: TTabControl;
    Memo: TRichEdit;
    Panel1: TPanel;
    butOverview: TButton;
    lbOverview: TListBox;
    butFind: TButton;
    butFindNext: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure tcChange(Sender: TObject);
    procedure butOverviewClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lbOverviewDblClick(Sender: TObject);
    procedure butFindClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    bFindnext, bOverview: Boolean;
    Find: String;
    Max: Integer;
    fFileNames: Array of String;
    procedure Load;
    procedure Check;
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

implementation

Uses global, uTools, Inifiles, cLogFile, dInput;

{$R *.DFM}

Procedure DialogHistory;
Var Akt, Nr, i, p1, p2: Integer; lang, LangName: String;
begin
   With TDlgHistory.Create(nil) do try
      With TFileList.Create(PATH_BASE, 'changes_??.txt', faAnyfile, [flFiles, flSorted]) do try
         SetLength(FFilenames, Count);
         Nr := 0; Akt := -1;
         For i := 0 to Count-1 do begin
            p1 := Pos('_', FileNames[i]);
            p2 := Pos('.txt', FileNames[i]);
            If (p2 = p1+3) and (p1>0) then begin
               Inc(Nr);
               lang := LowerCase(Copy(FileNames[i], p1+1, 2));
               If (Akt<0) and (lang='en') then Akt := Nr-1;
               If lang = LowerCase(Sprache) then Akt := Nr-1;
               FFilenames[Nr-1] := Files[i];
               With TMemIniFile.Create(PATH_BASE + 'hamster_'+lang+'.dat') do try
                  LangName := ReadString('Init', 'Language', '');
                  If LangName = '' then LangName := Lang
               finally Free end;
               tc.Tabs.Add (LangName)
            end
         end;
      finally Free end;
      If tc.Tabs.Count = 0 then begin
         Log ( LOGID_ERROR, Tr('No.Changes_??.txt.files.found', 'No files "changes_??.txt" found!' ))
      end else begin
         If Akt >= 0 then tc.TabIndex := Akt;
         Load;
         bOverview := false;
         Check;
         Show
      end;
   except
      Free
   end
end;

procedure TDlgHistory.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree
end;

Procedure TDlgHistory.Load;
Var s: String; i: Integer;
begin
   s := FFilenames[tc.TabIndex];
   If FileExists2(s) then Memo.Lines.LoadFromFile(s)
                    else Memo.Lines.Text := '(Missing '+s+')';
   With Memo.Lines do begin
      lbOverview.Items.Clear;
      For i := 1 to Count-2 do begin
         If (Trim(Strings[i-1]) = '') and (Trim(Strings[i])>'')
            //and (CountCharInString('.',Strings[i]) >= 3)
         then begin
            lbOverview.Items.AddObject ( Strings[i], Pointer(i) )
         end
      end;
      Max := Length(Text)
   end;
   If Memo.CanFocus then try Memo.SetFocus except end
end;

procedure TDlgHistory.tcChange(Sender: TObject);
begin
   Load
end;

procedure TDlgHistory.Check;
begin
   If bOverview then begin
      butOverview.Caption := Tr('butOverview.Details', 'Details');
      Memo.Visible := false;
      lbOverview.Visible := true
   end else begin
      butOverview.Caption := Tr('butOverview.Overview', 'Overview');
      lbOverview.Visible := false;
      Memo.Visible := true
   end;
   butFindNext.Enabled := bFindnext
end;

procedure TDlgHistory.butOverviewClick(Sender: TObject);
begin
   bOverview := Not bOverview;
   Check
end;

procedure TDlgHistory.FormCreate(Sender: TObject);
begin
   lbOverview.Align := alClient;
end;

procedure TDlgHistory.lbOverviewDblClick(Sender: TObject);
Var LineNr: Integer;
begin
   If lbOverview.ItemIndex < 0 then Exit;
   LineNr := Integer(lbOverview.Items.Objects[lbOverview.ItemIndex]);
   Memo.Perform ( EM_LineScroll, 0 , -Memo.Lines.Count);
   Memo.Perform ( EM_LineScroll, 0 , LineNr);
   butOverview.Click
end;

procedure TDlgHistory.butFindClick(Sender: TObject);
Var p, Line: Integer;
begin
   bOverview := false;
   Check;
   If Sender = butFind then begin
      If Not InputDlgStr ( Tr('DlgFind.caption', 'Find...'),
                           Tr('DlgFind.text', 'Search for:'),
         Find, 0) then exit;
      If Find = '' then Exit;
      Memo.SelStart := 1
   end;
   With Memo do begin
      p := FindText ( Find, SelStart+1, Max-SelStart, []);
      If p >= 0 then begin
         Line := SendMessage (Handle, EM_LINEFROMCHAR, p, 0);
         Perform ( EM_LineScroll, 0 , -Lines.Count);
         Perform ( EM_LineScroll, 0 , Line-5);
         SelStart := p; SelLength := Length(Find);
         bFindNext := FindText ( Find, SelStart+1, Max-SelStart, []) >= 0
      end else begin
         Beep;
         SelStart := 1;
         Perform ( EM_LineScroll, 0 , -Lines.Count);
         bFindNext := false
      end;
      SetFocus
   end;
   Check
end;

procedure TDlgHistory.FormActivate(Sender: TObject);
begin
   If Memo.CanFocus then try Memo.SetFocus except end
end;

procedure TDlgHistory.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   If (Key = VK_TAB) then begin
      If Shift=[ssCtrl] then begin
         Key := 0;
         With tc do TabIndex := ( TabIndex + 1 ) mod Tabs.Count;
         Load
      end else
      If Shift=[ssCtrl, ssShift] then begin
         Key := 0;
         With tc do If TabIndex = 0 then TabIndex := Tabs.Count-1
                                    else TabIndex := TabIndex - 1;
         Load
      end
   end
end;

end.
