unit dMainMenuItems;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CheckLst, menus, cStdForm;

Function EditMenuItems ( AMenu: TMainMenu;
   Const AHide: Array of TMenuItem; Var AList: String): Boolean;

type
  TDlgMainMenuItems = class(THForm)
    lbMenuItems: TCheckListBox;
    Button1: TButton;
    Label1: TLabel;
    Button2: TButton;
  private
     Menu: TMainMenu;
     Hide: Array of TMenuItem;
     List: String;
    procedure Init;
  end;

implementation

{$R *.DFM}

Function EditMenuItems ( AMenu: TMainMenu;
   Const AHide: Array of TMenuItem; Var AList: String): Boolean;
Var i: Integer;
begin
   With TDlgMainMenuItems.Create(NIL) do try
      Menu := AMenu;
      SetLength(Hide, Length(AHide));
      For i := Low(AHide) to High(AHide) do Hide[i] := AHide[i];
      List := ','+LowerCase(AList)+',';
      Init;
      Result := ShowModal = mrOK;
      If Result then begin
         AList := '';
         With lbMenuItems do begin
            For i := 0 to Items.Count-1 do begin
               If Not Checked[i] then begin
                  If AList > '' then AList := AList + ',';
                  AList := AList + TMenuItem(Items.Objects[i]).Name
               end
            end
         end
      end
   finally
      free
   end
end;


procedure TDlgMainMenuItems.Init;

   Procedure AddEntry (M: TMenuItem; Const Pre: String);
   Var i: Integer; s: String; b: Boolean;
   begin
      If M.Name = '' then Exit;
      For i := Low(Hide) to High(Hide) do If Hide[i]=M then Exit;
      s := M.Caption;
      If s = '-' then s := '----------';
      For i := Length(s) downto 1 do begin
         If (s[i]='&') then If (i = 1) or (s[i-1]<>'&') then Delete(s, i, 1)
      end;
      b := Pos(','+LowerCase(M.Name)+',', List)=0;
      lbMenuItems.Checked[lbMenuItems.Items.AddObject ( Pre + s, M )] := b;
      For i := 0 to M.Count-1 do AddEntry(M.Items[i], Pre+'   ' )
   end;

Var i: Integer;
begin
   lbMenuItems.Clear;
   For i := 0 to Menu.Items.Count-1 do AddEntry(Menu.Items[i], '');
end;

end.
