unit dScripts;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, cStdForm, ComCtrls, Menus,
  tScriptInsCmd, Mask, ToolEdit;

Procedure DialogManageScripts;
Procedure DialogManageScriptsClose;
Function IsDialogManageScriptsOpen: Boolean;

Var
   Scriptlist: TStringList;
Procedure Reload_Scriptlist;

type
  TAnzeige = (aBoth, aScripts, aModules);
  TDlgScripts = class(THForm)
    butClose: TButton;
    pg: TPageControl;
    tsScripts: TTabSheet;
    tsModules: TTabSheet;
    butDirNew: TButton;
    Label2: TLabel;
    lbHSCs: TListBox;
    butNew: TButton;
    butEdit: TButton;
    butRun: TButton;
    butCopyAs: TButton;
    butRename: TButton;
    butDelete: TButton;
    Label3: TLabel;
    lbModules: TListBox;
    butNewModule: TButton;
    butEditModule: TButton;
    butRenameModule: TButton;
    butDeleteModule: TButton;
    tsSettings: TTabSheet;
    tvMenus: TTreeView;
    butDirDelete: TButton;
    bevNoSubDirs: TBevel;
    labNoSubDirs: TLabel;
    butHelp: TButton;
    chkEditDirectly: TCheckBox;
    gbEdit: TGroupBox;
    mScript: TMemo;
    butSaveScript: TButton;
    butCancelScript: TButton;
    butZoom: TButton;
    butInsertInScript: TButton;
    labNoScriptSelected: TPanel;
    popInsert: TPopupMenu;
    butRun2: TButton;
    chkEditModuleDirectly: TCheckBox;
    gbeditModule: TGroupBox;
    labeditModule: TPanel;
    mModule: TMemo;
    butSaveModule: TButton;
    butCancelModule: TButton;
    butZoomModule: TButton;
    butInsertIntoModule: TButton;
    popInsert2: TPopupMenu;
    tcDefText: TTabControl;
    mDefText: TMemo;
    Panel1: TPanel;
    butSaveDef: TButton;
    butReloadDef: TButton;
    butInsertIntoDefText: TButton;
    labPathScript: TLabel;
    labPathRCScript: TLabel;
    txtPathScript: TDirectoryEdit;
    txtPathRCScript: TDirectoryEdit;
    popInsert3: TPopupMenu;
    labPathMod: TLabel;
    txtPathMod: TDirectoryEdit;
    optRCScripts: TRadioButton;
    optMenuScripts: TRadioButton;
    procedure butEditClick(Sender: TObject);
    procedure butDirNewClick(Sender: TObject);
    procedure butNewClick(Sender: TObject);
    procedure butRunClick(Sender: TObject);
    procedure butCopyAsClick(Sender: TObject);
    procedure butRenameClick(Sender: TObject);
    procedure butDeleteClick(Sender: TObject);
    procedure lbHSCsClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lbModulesClick(Sender: TObject);
    procedure lbHSCsDblClick(Sender: TObject);
    procedure butReloadDefClick(Sender: TObject);
    procedure butSaveDefClick(Sender: TObject);
    procedure mDefTextChange(Sender: TObject);
    procedure butNewModuleClick(Sender: TObject);
    procedure butRenameModuleClick(Sender: TObject);
    procedure butEditModuleClick(Sender: TObject);
    procedure butDeleteModuleClick(Sender: TObject);
    procedure tvMenusChange(Sender: TObject; Node: TTreeNode);
    procedure tvMenusDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure tvMenusDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure butDirDeleteClick(Sender: TObject);
    procedure tvMenusEdited(Sender: TObject; Node: TTreeNode;
      var S: String);
    procedure tvMenusEditing(Sender: TObject; Node: TTreeNode;
      var AllowEdit: Boolean);
    procedure butCloseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure chkEditDirectlyClick(Sender: TObject);
    procedure mScriptChange(Sender: TObject);
    procedure mScriptDblClick(Sender: TObject);
    procedure butSaveScriptClick(Sender: TObject);
    procedure butCancelScriptClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure butInsertInScriptClick(Sender: TObject);
    procedure chkEditModuleDirectlyClick(Sender: TObject);
    procedure butSaveModuleClick(Sender: TObject);
    procedure butCancelModuleClick(Sender: TObject);
    procedure butZoomModuleClick(Sender: TObject);
    procedure butInsertIntoModuleClick(Sender: TObject);
    procedure lbModulesDblClick(Sender: TObject);
    procedure mScriptKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure mModuleKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure butInsertIntoDefTextClick(Sender: TObject);
    procedure tcDefTextChange(Sender: TObject);
    procedure mDefTextKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure txtPathScriptChange(Sender: TObject);
    procedure optRCScriptsClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    Script_changed, Script_zoomed,
    Module_changed, Module_zoomed,
    Deftext_changed: Boolean;
    LastDefTextPage: Integer;
    InsertScriptCommand, InsertModuleCommand, InsertDefTextCommand: TInsertCommand;
    AktHSCPath, AktHSCPathRC, AktHSMPath: String;
    Procedure Anzeige (Const Typ: TAnzeige; Const AktEntry: String = '');
    Function GetHSC (Const FullName: Boolean; Out s: String; Out P: Integer): boolean;
    function GetHSM(const FullName: Boolean; out s: String): boolean;
    Function AktPath: String;
    Function GetPath (N: TTreeNode): String;
    procedure StatusScriptEditor;
    procedure StatusModuleEditor;
    procedure TestIfScriptSaved;
    Procedure TestIfModuleSaved;
    Procedure LoadDefText (Const Typ: Integer; Liste: TStrings);
    Procedure SaveDefText (Const Typ: Integer; Liste: TStrings);
    procedure LoadScriptlist;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  public
    { Public-Deklarationen }
  end;

implementation

Uses Global, uTools, Config, Main, dInput;

{$R *.DFM}

Var Dlg: TDlgScripts;

Procedure DialogManageScripts;
Var First: Boolean;
begin
   First := Not Assigned(Dlg);
   If First then begin
      Dlg := TDlgScripts.Create(NIL);
      With Dlg do begin
         Anzeige (aBoth);
         butReloadDef.Click;
         Show
      end
   end else begin
      With Dlg do begin
         WindowState := wsNormal;
         BringToFront
      end
   end
end;

Procedure DialogManageScriptsClose;
begin
   If Assigned(Dlg) then Dlg.Close
end;

Function IsDialogManageScriptsOpen: Boolean;
begin
   Result := Assigned(Dlg)
end;
// General

procedure TDlgScripts.FormCreate(Sender: TObject);
begin
   IsFixedFont ( [mDefText, mScript, mModule] );
   InsertScriptCommand := TInsertCommand.Create ( popInsert, mScript );
   InsertModuleCommand := TInsertCommand.Create ( popInsert2, mModule );
   InsertDefTextCommand:= TInsertCommand.Create ( popInsert3, mDefText );
   try
      pg.ActivePageIndex := CfgIni.ReadInteger('EditScripts', 'ActivePage', tsSettings.TabIndex)
   except
      pg.ActivePage := tsSettings
   end;
   LastDefTextPage := -1;
   tcDefText.TabIndex := 0;
   tcDefText.OnChange ( NIL );
   txtPathScript.Text := PATH_HSC;
   txtPathMod.Text := PATH_HSM;
   txtPathRCScript.Text := PATH_HSC_RC;
   LoadScriptlist;
   With CfgIni do begin
      chkEditDirectly.checked := ReadBool ( 'EditScripts', 'EditDirectly_HSC', false );
      chkEditModuleDirectly.checked := ReadBool ( 'EditScripts', 'EditDirectly_HSM', false );
   end;
   If Not LoadWindowState ( Self, 'EditScripts' ) then begin
      Left := (Screen.Width - Width) div 2;
      Top := (Screen.Height - Height) div 2
   end;
   StatusScripteditor;
   StatusModuleEditor;
   OnResize(NIL)
end;

Procedure TDlgScripts.LoadScriptlist;
Var Rec: Boolean;

   Procedure Search (Const Pfad: String; Node: TTreeNode);
   Var r: TSearchrec; NewNode: TTreeNode;
   begin
      If Not Rec then Exit;
      If FindFirst( Pfad + '*.*', faAnyfile, r) = 0 then begin
         Repeat
            If (r.Attr and faDirectory)>0 then begin
               If r.Name[1]<>'.' then begin
                  NewNode := tvMenus.Items.AddChild (Node, r.Name);
                  Search (Pfad+r.Name+'\', NewNode)
               end
            end
         until Findnext(r) <> 0;
         FindClose(r)
      end
   end;

   Var s: String;
begin
   Rec := LowerCase(AktHSCPath) <> LowerCase(PATH_BASE);
   tvMenus.Items.Clear;
   s := AktHSCPath;
   If Pos(LowerCase(PATH_BASE), LowerCase(s))=1
      then Delete(s, 1, Length(PATH_BASE));
   Search ( AktHSCPath, tvMenus.Items.Add ( NIL, s ) );
   bevNoSubDirs.Visible := Not Rec;
   labNoSubDirs.Visible := Not Rec;
   tvMenus.Visible := Rec;
   butDirNew.Visible := Rec;
   butDirDelete.Visible := Rec;
   tvMenus.AlphaSort;
   tvMenus.FullExpand;
   tvMenus.Selected := tvMenus.Items[0];
end;

procedure TDlgScripts.butCloseClick(Sender: TObject);
Var s: String;
begin
   If PATH_HSC <> AktHSCPath then begin
      s := AktHSCPath;
      If Pos(LowerCase(PATH_BASE), LowerCase(AktHSCPath))=1
         then Delete(s, 1, Length(PATH_BASE));
      PATH_HSC := AktHSCPath;
      CfgIni.WriteString('Directories', 'Scripts', s)
   end;
   If PATH_HSC_RC <> AktHSCPathRC then begin
      s := AktHSCPathRC;
      If Pos(LowerCase(PATH_BASE), LowerCase(AktHSCPathRC))=1
         then Delete(s, 1, Length(PATH_BASE));
      PATH_HSC_RC := AktHSCPathRC;
      CfgIni.WriteString('Directories', 'ScriptsRC', s)
   end;
   If PATH_HSM <> AktHSMPath then begin
      s := AktHSMPath;
      If Pos(LowerCase(PATH_BASE), LowerCase(AktHSMPath))=1
         then Delete(s, 1, Length(PATH_BASE));
      PATH_HSM := AktHSMPath;
      CfgIni.WriteString('Directories', 'Modules', s)
   end;
   PostMessage ( hWndMainWindow, WM_NOTIFYGUI, GUI_MSG_RELOAD_SCRIPTS, 0 );
   Close
end;

procedure TDlgScripts.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   TestIfScriptSaved;
   TestIfModuleSaved;
   CfgIni.WriteInteger('EditScripts', 'ActivePage', pg.ActivePageIndex);
   If Self = Dlg then Dlg := NIL;
   Action := caFree
end;

procedure TDlgScripts.FormDestroy(Sender: TObject);
begin
   InsertScriptCommand.Free;
   InsertModuleCommand.Free;
   InsertDefTextCommand.Free;
end;

procedure TDlgScripts.Anzeige (Const Typ: TAnzeige; Const AktEntry: String = '');
Var TS: TStringList; SR: TSearchrec; p: Integer;
begin
   TS := TStringList.Create;
   try
      If Typ IN[aBoth, aScripts] then begin
         TS.Clear;
         If FindFirst( AktPath + '*.hsc', faAnyFile, SR ) = 0 then begin
            Repeat
               If (SR.Attr and faDirectory) = 0 then TS.Add (SR.Name)
            until FindNext(SR) <> 0;
            FindClose(SR)
         end;
         TS.Sort;
         lbHSCs.Items.Assign(TS);
         p := lbHSCs.Items.IndexOf (AktEntry);
         If p >= 0 then begin
            lbHSCs.ItemIndex := p;
            lbHSCs.Selected[p] := true
         end;
         butEdit.Enabled := p >= 0;
         butDelete.Enabled := p >= 0;
         butRename.Enabled := p >= 0;
         butCopyAs.Enabled := p >= 0;
         butRun.Enabled := p >= 0;
         StatusScripteditor
      end;
      If Typ IN[aBoth, aModules] then begin
         TS.Clear;
         If FindFirst( AktHSMPath + '*.hsm', faAnyFile, SR ) = 0 then begin
            Repeat TS.Add (SR.Name) until FindNext(SR) <> 0;
            FindClose(SR)
         end;
         TS.Sort;
         lbModules.Items.Assign(TS);
         butEditModule.Enabled := false;
         butDeleteModule.Enabled := false;
         butRenameModule.Enabled := false;
         StatusModuleEditor
      end
   finally
      ts.free
   end
end;

// Scripts

// - Dirs

Procedure Reload_Scriptlist;
Var Rec: Boolean;

   Procedure Search (Const Pfad: String);
   Var r: TSearchrec;
   begin
      If FindFirst( Pfad + '*.*', faAnyfile, r) = 0 then begin
         Repeat
            If (r.Attr and faDirectory)>0 then begin
               If rec then If r.Name[1]<>'.' then Search (Pfad+r.Name+'\')
            end else
            If LowerCase(ExtractFileExt(r.Name))='.hsc' then begin
               Scriptlist.Add (Copy(Pfad, Length(PATH_HSC)+1, Length(Pfad)) + r.Name)
            end
         until Findnext(r) <> 0;
         FindClose(r)
      end
   end;

begin
   Rec := PATH_BASE <> PATH_HSC;
   Scriptlist.Clear;
   Scriptlist.sorted := false;
   Search ( PATH_HSC );
   Scriptlist.sorted := true
end;

procedure TDlgScripts.optRCScriptsClick(Sender: TObject);
begin
   tvMenus.Enabled := optMenuScripts.Checked;
   butDirNew.Enabled := optMenuScripts.Checked;
   butDirDelete.Enabled := optMenuScripts.Checked;
   Anzeige ( aScripts )
end;

procedure TDlgScripts.tvMenusChange(Sender: TObject; Node: TTreeNode);
Var b: Boolean; r: TSearchrec;
begin
   Anzeige ( aScripts );
   b := Assigned(tvMenus.selected);
   butDirNew.Enabled := b;
   If b then b := tvMenus.selected <> tvMenus.Items[0];
   If b then b := (Not tvMenus.selected.HasChildren) and (lbHSCs.Items.Count = 0);
   If b then begin
      If FindFirst(AktPath + '*.*', faAnyFile, r) = 0 then begin
         Repeat
            If ((r.Attr and faDirectory) = 0) or (r.Name[1]<>'.') then b := false
         until (Not b) or (FindNext(r)<>0);
         FindClose(r)
      end
   end;
   butDirDelete.Enabled := b
end;

procedure TDlgScripts.tvMenusDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
   Accept := (Source = lbHSCs)
              or
             ((Source = tvMenus) and (tvMenus.Selected<>tvMenus.Items[0]))
end;

procedure TDlgScripts.tvMenusDragDrop(Sender, Source: TObject; X,
  Y: Integer);
Var Node: TTreeNode;
    Path, s, k, Alt, Neu: String;
    p: Integer;
begin
   Node := tvMenus.GetNodeAt(x, y);
   If Not Assigned(Node) then Exit;
   If tvMenus.Selected = Node then Exit;
   Path := GetPath(Node);

   If Source = lbHSCs then begin
      While GetHSC(true, s, p) and GetHSC(false, k, p) do begin
         RenameFile (s, Path+k);
         lbHSCs.Selected [p] := false
      end;
      Anzeige (aScripts)
   end else
   If Source = tvMenus then begin
      Alt := ExcludeTrailingBackslash(AktPath);
      Neu := GetPath(Node) + tvMenus.Selected.Text;
      If RenameFile (Alt, Neu) then tvMenus.selected.MoveTo(Node, naAddChild)
   end
end;

function TDlgScripts.GetPath(N: TTreeNode): String;
Var N2: TTreeNode;
begin
   Result := '';
   N2 := N;
   While Assigned(N2) do begin
      Result := IncludeTrailingBackslash(N2.Text) + Result;
      N2 := N2.Parent
   end;
   If Pos(LowerCase(PATH_BASE), LowerCase(AktHSCPath))=1 then Result := PATH_BASE + Result
end;

function TDlgScripts.AktPath: String;
begin
   If optMenuScripts.Checked
      then Result := GetPath (tvMenus.Selected)
      else Result := AktHSCPathRC
end;

procedure TDlgScripts.butDirDeleteClick(Sender: TObject);
Var s: String;
begin
   s := GetPath(tvMenus.Selected);
   If MessageBox(Handle,
       PChar(TrF('DeleteSubmenu.Question', 'Do you really want to delete the empty Submenu "%s"?', s)),
       PChar(Tr('DeleteSubmenu.Caption', 'Delete Submenu')),
       MB_ICONEXCLAMATION + MB_YESNO ) = IDYES
   then begin
      RmDir(s);
      tvMenus.Selected.Delete
   end
end;

procedure TDlgScripts.tvMenusEdited(Sender: TObject; Node: TTreeNode;
  var S: String);
Var Alt, Neu: String;
begin
   Alt := ExcludeTrailingBackslash(AktPath);
   Neu := GetPath(tvMenus.Selected.Parent) + s;
   If Not RenameFile( Alt, Neu ) then s := tvMenus.Selected.Text
end;

procedure TDlgScripts.tvMenusEditing(Sender: TObject; Node: TTreeNode;
  var AllowEdit: Boolean);
begin
   AllowEdit := (Node <> tvMenus.Items[0])
end;

// - Scripts

Function TDlgScripts.GetHSC (Const FullName: Boolean; Out s: String; Out P: Integer): boolean;
Var i: Integer;
begin
   Result := false;
   p := 0;
   s := '';
   With lbHSCs do begin
      For i := 0 to Items.Count-1 do If Selected[i] then begin
         If Fullname then s := AktPath;
         s := s + Items[i];
         p := i;
         Result := true;
         Break
      end
   end
end;

procedure TDlgScripts.butDirNewClick(Sender: TObject);
Var s, Title: String;
begin
   Title := Tr('Script.NewSubmenu.Title', 'New Submenu');
   s := '';
   if InputDlgStr( Title, Tr('Script.NewSubmenu.Input', 'Input title for new Submenu:'), s, 0 ) then begin
      If CreateDirectory ( PChar(AktPath + s), NIL ) then begin
         tvMenus.Items.AddChild (tvMenus.selected, s);
         Anzeige (aScripts)
      end
   end
end;

procedure TDlgScripts.lbHSCsClick(Sender: TObject);
Var Anz: Integer;
begin
   Anz := lbHSCs.SelCount;
   butEdit.Enabled := Anz = 1;
   butDelete.Enabled := Anz > 0;
   butRename.Enabled := Anz = 1;
   butCopyAs.Enabled := Anz = 1;
   butRun.Enabled := Anz = 1;
   StatusScripteditor
end;

procedure TDlgScripts.lbHSCsDblClick(Sender: TObject);
begin
   If chkEditDirectly.checked
      then mScript.SetFocus
      else butEdit.Click
end;

procedure TDlgScripts.butNewClick(Sender: TObject);
Var Title, s: String; i: Integer; l: TStringList;
Const Ext = '.hsc';
begin
   TestIfScriptSaved;
   Title := Tr('NewScript.Caption', 'Create New Script');
   If InputDlgStr ( Title,
                    Tr('NewScript.Prompt', 'Enter Filename:'),
                    s, 0 ) then
   begin
      If LowerCase(ExtractFileExt(s))<>Ext then s := s + Ext;
      For i := 1 to Length(s) do begin
         If s[i] IN['!', '\', '/', '?', ':', '+'] then begin
            MessageBox(Handle,
               PChar(Tr('NewScript.Error_IllegalChar',
                        'This filename ist not allowed, you cannot use "!", "\", "/", "?", ":", "+" as Part of an hsc-Filename!')),
                     PChar(Title),
                     MB_ICONEXCLAMATION );
            Exit
         end
      end;
      s := AktPath + s;
      If FileExists2(s) then begin
         MessageBox(Handle,
            PChar(TrF('NewScriptOrModule.Error_FileExists', 'Not possible, because File "%s" exists!', s)),
            PChar(Title), MB_ICONEXCLAMATION );
      end else begin
         With TFileStream.Create (s, fmCreate) do try
            l := TStringList.Create;
            With l do try
              LoadDefText (0, l);
              Write (l.Text[1], Length(l.Text))
            finally l.Free end
         finally free end;
         Anzeige (aScripts, ExtractFileName(s));
         If chkEditDirectly.Checked then begin
            With mScript do If Enabled and Visible then SetFocus
         end else begin
            EditFile ( s )
         end
      end
   end
end;

procedure TDlgScripts.butEditClick(Sender: TObject);
Var s: String; p: Integer;
begin
   TestIfScriptSaved;
   If GetHSC(true, s, p) then EditFile ( s )
end;

procedure TDlgScripts.butRunClick(Sender: TObject);
Var s: String; p: Integer;
begin
   TestIfScriptSaved;
   If GetHSC(true, s, p) then begin
      AllShutdownReq := False;
      HamsterMainWindow.Timer1Timer(Self);
      HamsterMainWindow.StartScript( s, '', false)
   end
end;

procedure TDlgScripts.butCopyAsClick(Sender: TObject);
Var s1, s2, Title, Alt, Neu: String; i, p: Integer;
Const Ext = '.hsc';
begin
   TestIfScriptSaved;
   If Not GetHSC (false, Alt, p) then Exit;
   Neu := Alt;
   Title := Tr('CopyScriptAs.Caption', 'Copy Script as');
   If InputDlgStr ( Title,
                    Tr('RenameScript.Prompt', 'Enter new Filename:'),
                    Neu, 0 ) then
   begin
      If LowerCase(ExtractFileExt(Neu))<>Ext then Neu := Neu + Ext;
      If LowerCase(Neu) = LowerCase(Alt) then Exit;
      For i := 1 to Length(Neu) do begin
         If Neu[i] IN['!', '\', '/', '?', ':', '+'] then begin
            MessageBox(Handle,
               PChar(Tr('NewScript.Error_IllegalChar',
                        'This filename ist not allowed, you cannot use "!", "\", "/", "?", ":", "+" as Part of an hsc-Filename!')),
                     PChar(Title),
                     MB_ICONEXCLAMATION );
            Exit
         end
      end;
      s1 := AktPath + Neu;
      If FileExists2(s1) then begin
         MessageBox(Handle,
            PChar(TrF('NewScriptOrModule.Error_FileExists', 'Not possible, because File "%s" exists!', s1)),
            PChar(Title), MB_ICONEXCLAMATION );
         Exit
      end;
      s2 := AktPath + Alt;

      If CopyFile (PChar(s2), PChar(s1), true) then Anzeige(aScripts)

   end
end;

procedure TDlgScripts.butRenameClick(Sender: TObject);
Var s1, s2, Title, Alt, Neu: String; i, p: Integer;
Const Ext = '.hsc';
begin
   TestIfScriptSaved;
   If Not GetHSC (false, Alt, p) then Exit;
   Neu := ChangeFileExt(Alt, '');
   Title := Tr('RenameScript.Caption', 'Rename Script');
   If InputDlgStr ( Title,
                    Tr('RenameScript.Prompt', 'Enter new Filename:'),
                    Neu, 0 ) then
   begin
      If LowerCase(ExtractFileExt(Neu))<>Ext then Neu := Neu + Ext;
      If LowerCase(Neu) = LowerCase(Alt) then Exit;
      For i := 1 to Length(Neu) do begin
         If Neu[i] IN['!', '\', '/', '?', ':', '+'] then begin
            MessageBox(Handle,
               PChar(Tr('NewScript.Error_IllegalChar',
                        'This filename ist not allowed, you cannot use "!", "\", "/", "?", ":", "+" as Part of an hsc-Filename!')),
                     PChar(Title),
                     MB_ICONEXCLAMATION );
            Exit
         end
      end;
      s1 := AktPath + Neu;
      If FileExists2(s1) then begin
         MessageBox(Handle,
            PChar(TrF('NewScriptOrModule.Error_FileExists', 'Not possible, because File "%s" exists!', s1)),
            PChar(Title), MB_ICONEXCLAMATION );
         Exit
      end;
      s2 := AktPath + Alt;

      If RenameFile (s2, s1) then Anzeige(aScripts, ExtractFileName(s1))

   end
end;

procedure TDlgScripts.butDeleteClick(Sender: TObject);
Var s: String; p: Integer;
begin
   If MessageBox(Handle,
       PChar(Tr('DeleteScript.Question', 'Do you really want to delete the selected script(s)?')),
       PChar(Tr('DeleteScript.Caption', 'Delete Script(s)')),
       MB_ICONEXCLAMATION + MB_YESNO ) = IDYES
   then begin
      While GetHSC (true, s, p) do begin
         DeleteFile(s);
         lbHSCs.Selected[p] := false
      end;
      Anzeige(aScripts)
   end
end;

// - direct editing

procedure TDlgScripts.chkEditDirectlyClick(Sender: TObject);
begin
   StatusScripteditor
end;

procedure TDlgScripts.StatusScripteditor;
Var b: Boolean; s: String; p: Integer;
begin
   // Show Edit-Groupbox?
   b := chkEditDirectly.Checked;
   gbEdit.Visible := b;
   // Set Height of other controls
   If b then p := butDelete.Top + butDelete.Height
        else p := tsScripts.ClientHeight - 10; //gbEdit.Top + gbEdit.Height - 5;
   With tvMenus do Height := p - Top;
   With labNoSubDirs do Height := p - Top - 20;
   With bevNoSubDirs do Height := p - Top;
   With lbHSCs do Height := p - Top;
   // Zoomed Edit-Groupbox?
   With gbEdit do begin
      If Script_zoomed
         then Top := 5
         else Top := butDelete.Top + butDelete.Height + 6;
      Height := tsScripts.ClientHeight - 5 - Top;
      Width := tsScripts.ClientWidth - 2 * Left
   end;
   mScript.Height := gbEdit.Height - mScript.Top - 6;
   mScript.Width := gbEdit.ClientWidth - 2 * mScript.Left;
   optRCScripts.Visible := Not Script_Zoomed;
   optMenuScripts.Visible := Not Script_Zoomed;
   // Script available?
   b := b and GetHsc ( true, s, p );
   mScript.Visible := b;
   butSaveScript.visible := b;
   butCancelScript.visible := b;
   butZoom.visible := b or Script_zoomed;
   butInsertInScript.visible := b;
   butRun2.visible := b;
   // Load Script, if changed
   If s <> gbEdit.Caption then begin
      TestIfScriptSaved;
      gbEdit.Caption := s;
      If s > ''
         then mScript.Lines.LoadFromFile(s)
         else mScript.Clear;
      Script_changed := false
   end;
   // State of Script-Edit-Buttons
   butSaveScript.enabled := (s > '') and Script_changed;
   butCancelScript.enabled := (s > '') and Script_changed;
   butZoom.enabled := (s > '');
   butInsertInScript.enabled := (s > '');
end;

procedure TDlgScripts.mScriptChange(Sender: TObject);
begin
   If Sender = mScript then begin
      Script_changed := true;
      StatusScripteditor
   end else If Sender = mModule then begin
      Module_changed := true;
      StatusModuleeditor
   end
end;

procedure TDlgScripts.mScriptDblClick(Sender: TObject);
begin
   Script_zoomed := Not Script_zoomed;
   StatusScripteditor
end;

procedure TDlgScripts.butSaveScriptClick(Sender: TObject);
begin
   mScript.Lines.SaveToFile (gbEdit.Caption);
   Script_changed := false;
   StatusScriptEditor
end;

procedure TDlgScripts.butCancelScriptClick(Sender: TObject);
begin
   mScript.Lines.LoadFromFile (gbEdit.Caption);
   StatusScriptEditor
end;

procedure TDlgScripts.TestIfScriptSaved;
begin
   If gbEdit.Caption = '' then Exit;
   If Not Script_changed then Exit;
   If MessageBox(Handle,
       PChar(Tr('SaveScript.Question', 'Do you want to save the last changes?')),
       PChar(Tr('SaveScript.Caption', 'Unsaved changes in script')),
       MB_ICONQUESTION + MB_YESNO ) = IDYES
   then begin
      butSaveScriptClick (NIL)
   end
end;

procedure TDlgScripts.butInsertInScriptClick(Sender: TObject);
begin
   InsertScriptCommand.PopUp
end;

// Modules

Function TDlgScripts.GetHSM (Const FullName: Boolean; Out s: String): boolean;
begin
   Result := false;
   s := '';
   With lbModules do begin
      If ItemIndex < 0 then Exit;
      If Fullname then s := AktHSMPath;
      s := s + Items[ItemIndex];
      Result := true
   end
end;

procedure TDlgScripts.lbModulesClick(Sender: TObject);
begin
   butEditModule.Enabled := true;
   butDeleteModule.Enabled := true;
   butRenameModule.Enabled := true;
   StatusModuleEditor
end;

procedure TDlgScripts.butNewModuleClick(Sender: TObject);
Var Title, s: String; l: TStringList;
Const Ext = '.hsm';
begin
   TestIfModuleSaved;
   Title := Tr('NewModule.Caption', 'Create new module');
   If InputDlgStr ( Title,
                    Tr('NewScript.Prompt', 'Enter Filename:'),
                    s, 0 ) then
   begin
      If LowerCase(ExtractFileExt(s))<>Ext then s := s + Ext;
      s := AktHSMPath + s;
      If FileExists2(s) then begin
         MessageBox(Handle,
            PChar(TrF('NewScriptOrModule.Error_FileExists', 'Not possible, because File "%s" exists!', s)),
            PChar(Title), MB_ICONEXCLAMATION );
      end else begin
         With TFileStream.Create (s, fmCreate) do try
            l := TStringList.Create;
            With l do try
              LoadDefText (1, l);
              Write (l.Text[1], Length(l.Text))
            finally l.Free end
         finally free end;
         Anzeige (aModules);
         EditFile ( s )
      end
   end
end;

procedure TDlgScripts.butEditModuleClick(Sender: TObject);
Var s: String;
begin
   TestIfModuleSaved;
   If GetHSM(true, s) then EditFile ( s )
end;

procedure TDlgScripts.butRenameModuleClick(Sender: TObject);
Var s1, s2, Title, Alt, Neu: String;
Const Ext = '.hsm';
begin
   TestIfModuleSaved;
   If Not GetHSM (false, Alt) then Exit;
   Neu := Alt;
   Title := Tr('RenameModule.Caption', 'Rename module');
   If InputDlgStr ( Title,
                    Tr('RenameScript.Prompt', 'Enter new Filename:'),
                    Neu, 0 ) then
   begin
      If LowerCase(ExtractFileExt(Neu))<>Ext then Neu := Neu + Ext;
      If LowerCase(Neu) = LowerCase(Alt) then Exit;
      s1 := AktHSMPath + Neu;
      If FileExists2(s1) then begin
         MessageBox(Handle,
            PChar(TrF('NewScriptOrModule.Error_FileExists', 'Not possible, because File "%s" exists!', s1)),
            PChar(Title), MB_ICONEXCLAMATION );
         Exit
      end;
      s2 := AktHSMPath + Alt;
      If RenameFile (s2, s1) then Anzeige(aModules)
   end
end;

procedure TDlgScripts.butDeleteModuleClick(Sender: TObject);
Var s, k: String;
begin
   If GetHSM (true, s) and GetHSM (false, k) then begin
      If MessageBox(Handle,
          PChar(TrF('DeleteModule.Question', 'Do you really want to delete the module "%s"?', k)),
          PChar(Tr('DeleteModule.Caption', 'Delete module')),
          MB_ICONEXCLAMATION + MB_YESNO ) = IDYES
      then begin
         DeleteFile(s);
         Anzeige(aModules)
      end
   end
end;

// - Direct editing

procedure TDlgScripts.chkEditModuleDirectlyClick(Sender: TObject);
begin
   StatusModuleEditor
end;

procedure TDlgScripts.StatusModuleEditor;
Var b: Boolean; s: String; p: Integer;
begin
   // Show Edit-Groupbox?
   b := chkEditModuleDirectly.Checked;
   gbeditModule.Visible := b;
   // Set Height of other controls
   If b then p := butDeleteModule.Top + butDeleteModule.Height
        else p := gbEditModule.Top + gbEditModule.Height - 10;
   With lbModules do Height := p - Top;
   // Zoomed Edit-Groupbox?
   With gbEditModule do begin
      If Module_zoomed
         then Top := 5
         else Top := butDeleteModule.Top + butDeleteModule.Height + 10;
      Height := tsModules.Height - 10 - Top;
      Width := tsModules.ClientWidth - 2 * Left
   end;
   mModule.Height := gbEditModule.ClientHeight - mModule.Top - 6;
   mModule.Width := gbEditModule.ClientWidth - 2*mModule.left;
   // Script available?
   b := b and GetHSM ( true, s );
   mModule.Visible := b;
   butSaveModule.visible := b;
   butCancelModule.visible := b;
   butZoomModule.visible := b;
   butInsertIntoModule.visible := b;
   // Load Script, if changed
   If s <> gbEditModule.Caption then begin
      TestIfModuleSaved;
      gbEditModule.Caption := s;
      If s > ''
         then mModule.Lines.LoadFromFile(s)
         else mModule.Clear;
      Module_changed := false
   end;
   // State of Script-Edit-Buttons
   butSaveModule.enabled := (s > '') and Module_changed;
   butCancelModule.enabled := (s > '') and Module_changed;
   butZoomModule.enabled := (s > '');
   butInsertIntoModule.enabled := (s > '');
end;

procedure TDlgScripts.butSaveModuleClick(Sender: TObject);
begin
   mModule.Lines.SaveToFile (gbEditModule.Caption);
   Module_changed := false;
   StatusModuleEditor
end;

procedure TDlgScripts.butCancelModuleClick(Sender: TObject);
begin
   mModule.Lines.LoadFromFile (gbEditModule.Caption);
   StatusModuleEditor
end;

procedure TDlgScripts.butZoomModuleClick(Sender: TObject);
begin
   Module_zoomed := Not Module_zoomed;
   StatusModuleEditor
end;

procedure TDlgScripts.butInsertIntoModuleClick(Sender: TObject);
begin
   InsertModuleCommand.PopUp
end;

procedure TDlgScripts.TestIfModuleSaved;
begin
   If gbEditModule.Caption = '' then Exit;
   If Not Module_changed then Exit;
   If MessageBox(Handle,
       PChar(Tr('SaveModule.Question', 'Do you want to save the last changes?')),
       PChar(Tr('SaveModule.Caption', 'Unsaved changes in module')),
       MB_ICONQUESTION + MB_YESNO ) = IDYES
   then begin
      butSaveModuleClick (NIL)
   end
end;

// Default text...

// - Script

procedure TDlgScripts.mDefTextChange(Sender: TObject);
begin
   butReLoadDef.Enabled := true;
   butSaveDef.Enabled := true;
   Deftext_changed := true;
end;

procedure TDlgScripts.tcDefTextChange(Sender: TObject);
begin
   If Deftext_changed and (LastDefTextPage >= 0) then begin
      SaveDefText (LastDefTextPage, mDefText.Lines)
   end;
   LoadDefText(tcDefText.TabIndex, mDefText.Lines);
   LastDefTextPage := tcDefText.TabIndex
end;

procedure TDlgScripts.butReloadDefClick(Sender: TObject);
begin
   LoadDefText (tcDefText.TabIndex, mDefText.Lines)
end;

procedure TDlgScripts.butSaveDefClick(Sender: TObject);
begin
   SaveDefText (tcDefText.TabIndex, mDefText.Lines)
end;

// - Module

procedure TDlgScripts.LoadDefText (Const Typ: Integer; Liste: TStrings);
begin
   With Liste do begin
      Clear;
      Case Typ of
         0: If FileExists2 ( AktHSCPath + CFGFILE_DEFSCRIPT ) then
               LoadFromFile ( AktHSCPath + CFGFILE_DEFSCRIPT )
            else begin
               Clear;
               Add ( '#!load hamster.hsm' );
               Add ( '' );
               Add ( 'quit' )
            end;
         1: If FileExists2 ( AktHSMPath + CFGFILE_DEFModule ) then
               LoadFromFile ( AktHSMPath + CFGFILE_DEFModule )
            else begin
               Clear;
               Add ( '#!initialize' );
               Add ( 'return( 0 )' );
               Add ( '' );
               Add ( 'Sub ...' );
               Add ( '  ...' );
               Add ( 'endsub' )
            end;
         2: If FileExists2 ( AktHSMPath + CFGFILE_SHELLMOD ) then
               LoadFromFile ( AktHSMPath + CFGFILE_SHELLMOD )
            end
   end;
   butReLoadDef.Enabled := false;
   butSaveDef.Enabled := false;
   Deftext_changed := false
end;

procedure TDlgScripts.SaveDefText (Const Typ: Integer; Liste: TStrings);
begin
   With Liste do begin
      Case Typ of
         0: SaveToFile ( AktHSCPath + CFGFILE_DEFSCRIPT );
         1: SaveToFile ( AktHSMPath + CFGFILE_DEFModule );
         2: SaveToFile ( AktHSMPath + CFGFILE_SHELLMOD );
      end
   end;
   butReLoadDef.Enabled := false;
   butSaveDef.Enabled := false;
   Deftext_changed := false
end;

// -----------------------------------------------------------------------


procedure TDlgScripts.lbModulesDblClick(Sender: TObject);
begin
   If chkEditModuleDirectly.checked
      then mModule.Setfocus
      else butEditModule.Click
end;

procedure TDlgScripts.mScriptKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   Case Key of
      VK_INSERT: If Shift = [] then begin
         butInsertInScript.Click;
         Key := 0
      end
   end
end;

procedure TDlgScripts.mModuleKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   Case Key of
      VK_INSERT: If Shift = [] then begin
         butInsertIntoModule.Click;
         Key := 0
      end
   end
end;

procedure TDlgScripts.butInsertIntoDefTextClick(Sender: TObject);
begin
   InsertDefTextCommand.PopUp
end;

procedure TDlgScripts.mDefTextKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   Case Key of
      VK_INSERT: If Shift = [] then begin
         butInsertIntoDefText.Click;
         Key := 0
      end
   end
end;

procedure TDlgScripts.txtPathScriptChange(Sender: TObject);
begin
   Screen.Cursor := crHourglass;
   try
      Application.ProcessMessages;
      If Deftext_changed then SaveDefText (tcDefText.TabIndex, mDefText.Lines);
      TestIfScriptSaved;
      TestIfModuleSaved;
      AktHSCPath := IncludeTrailingBackslash(txtPathScript.Text);
      AktHSCPathRC := IncludeTrailingBackslash(txtPathRCScript.Text);
      AktHSMPath := IncludeTrailingBackslash(txtPathMod.Text);
      LoadScriptlist;
      Anzeige ( aModules );
      LoadDefText ( tcDefText.TabIndex, mDefText.Lines )
   finally
      Screen.Cursor := crDefault
   end
end;

procedure TDlgScripts.FormResize(Sender: TObject);
begin
  pg.Width := ClientWidth - 2 * pg.Left;
  pg.Height := ClientHeight - 3 * pg.Top - butHelp.Height;
  With butHelp do Top := 2 * pg.Top + pg.Height;
  With butClose do begin
     Top := butHelp.Top;
     Left := pg.Width + pg.Left - Width
  end;
  With tcDefText do begin
     Width := Parent.Width - 2*Left;
     Height := Parent.ClientHeight - Top - Left
  end;
  StatusScripteditor;
  StatusModuleEditor
end;

procedure TDlgScripts.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
   With CfgIni do begin
      WriteBool ( 'EditScripts', 'EditDirectly_HSC', chkEditDirectly.checked );
      WriteBool ( 'EditScripts', 'EditDirectly_HSM', chkEditModuleDirectly.checked );
   end;
   SaveWindowState ( Self, 'EditScripts' );
end;

procedure TDlgScripts.CreateParams(var Params: TCreateParams);
begin
   inherited;
   If CfgIni.ReadBool ( 'EditScripts', 'OwnTaskbarEntry', false ) then begin
      with Params do begin
         ExStyle := ExStyle or WS_EX_APPWINDOW;
         WndParent := GetDesktopWindow;
      end
   end
end;

initialization
   Scriptlist := TStringList.Create;
   Dlg := NIL;
finalization
   If Assigned(Dlg) then Dlg.Free;
   Scriptlist.free
end.








