// ============================================================================
// Hamster, a free news- and mailserver for personal, family and workgroup use.
// Copyright (c) 1999, Juergen Haible.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ============================================================================

unit fAccount;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, cStdForm, ComCtrls;

Procedure DialogEditUser (Const AUserID: Integer; Aliase: TStrings);
Procedure TestNewsAccess (Const sRead, sPost: String);
  
type
  TfrmAccount = class(THForm)
    btnOK: TButton;
    btnCancel: TButton;
    butHelp: TButton;
    pg: TPageControl;
    tsGeneral: TTabSheet;
    tsNews: TTabSheet;
    tsMailSettings: TTabSheet;
    tsRemoteControl: TTabSheet;
    Label2: TLabel;
    emUserName: TEdit;
    Label4: TLabel;
    emFullname: TEdit;
    emPassword: TEdit;
    Label3: TLabel;
    btnPasswordChange: TButton;
    Label8: TLabel;
    emGroup: TComboBox;
    Label6: TLabel;
    emNewsRead: TEdit;
    Label5: TLabel;
    emNewsPost: TEdit;
    Label7: TLabel;
    emMailAddr: TEdit;
    labAdvancedSettings: TLabel;
    butTestNewsaccess: TButton;
    chkAdvancedSettings: TCheckBox;
    rgLocalMailbox: TRadioGroup;
    labAliase: TLabel;
    chkOverrideGroupAccess: TCheckBox;
    Bevel1: TBevel;
    Label1: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    cbNewnews: TComboBox;
    cbPeerNews: TComboBox;
    cbModeCancel: TComboBox;
    chkOverrideMailboxtype: TCheckBox;
    cbMailsend: TComboBox;
    labMailSendAllowed: TLabel;
    Label11: TLabel;
    cbRemoteControl: TComboBox;
    labGroupMailboxtype: TLabel;
    labDefaultNewsRead: TLabel;
    labDefaultNewsPost: TLabel;
    butEditGroup: TButton;
    labGroupDefault1: TLabel;
    labGroupDefaultNewNews: TLabel;
    labGroupDefaultPeerNews: TLabel;
    labGroupDefaultModeCancel: TLabel;
    labGroupDefaultMailsend: TLabel;
    labGroupDefaultRemoteControl: TLabel;
    labGroupDefault2: TLabel;
    labGroupDefault3: TLabel;
    procedure btnPasswordChangeClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure butTestNewsaccessClick(Sender: TObject);
    procedure chkAdvancedSettingsClick(Sender: TObject);
    procedure chkOverrideGroupAccessClick(Sender: TObject);
    procedure chkOverrideMailboxtypeClick(Sender: TObject);
    procedure butEditGroupClick(Sender: TObject);
    procedure emGroupClick(Sender: TObject);
  private
    UserID, GroupID: Integer;
    Procedure ReadGroupSettings;
  end;

implementation

{$R *.DFM}

uses cAccount, cMailAlias, Global, Config, dInput, cServerNNTP, fGroup;

Procedure DialogEditUser (Const AUserID: Integer; Aliase: TStrings);
Var Info, User, s, s2: String; p, i: Integer; bFirst: Boolean;
    OldMBt: TMailboxtype;
begin
   With TfrmAccount.Create(NIL) do try
      UserID := AUserID;
      With CfgAccounts do try
         Lock;
         With Users.Find(UserID) do begin
            // General
            chkOverrideGroupAccess.OnClick(NIL);
            chkOverrideMailboxtype.OnClick(NIL);
            emUsername.Text := Username;
            If Trim(Password)=''
               then emPassword.Text:=TrGl(kGlobal, 'PW.None', '{NONE}')
               else emPassword.Text:=TrGl(kGlobal, 'PW.Set', '{SET}');
            emFullname.Text := Fullname;
            With emGroup, Items do begin
               Clear;
               For i := 0 to Groups.Count-1 do begin
                  p := Add(Groups[i].Name);
                  If Groups[i]=Group then ItemIndex := p
               end
            end;
            If UserID=ACTID_ADMIN then begin
               emGroup.Enabled := false
            end;
            // News
            chkOverrideGroupAccess.Checked := OverrideNewsaccess;
            emNewsPost.Text := NewsPostAccess;
            emNewsRead.Text := NewsReadAccess;
            SetTriValue(cbNewNews, NewsNews);
            SetTriValue(cbPeerNews, Newspeer);
            SetTriValue(cbModecancel, ModeCancel);
            // Mail
            emMailAddr.Text := Mailaddr;
            chkOverrideMailboxtype.Checked := OverrideMailboxtype;
            If UserID=ACTID_ADMIN then begin
               rgLocalMailbox.ItemIndex := 1;
               rgLocalMailbox.Enabled := false;
               HasMailbox; // create mailbox, if necessary
            end else begin
               rgLocalMailbox.itemindex := Ord(Mailboxtype)
            end;
            SetTriValue(cbMailSend, Mailsend);
            // Remote
            SetTriValue(cbRemoteControl, RemoteControl);
            // ------
            User := LowerCase(Username);
            ReadGroupSettings
         end;
         { Aliases_Account }
         { Search entries, which ends with "=Username" and add first part }
         Info := '';
         s := User+'=';
         bfirst := true;
         For i := 0 to Aliase.Count-1 do begin
            s2 := Trim(Aliase[i]);
            If (s2 > '') and (Not (s2[1] IN [';', '#', '/'])) then begin
               p := Pos(s, LowerCase(s2));
               If p=1 then begin
                  If bFirst then begin
                     Info := Info + Tr('Forward.to', 'Forward to: ');
                     bfirst := false
                  end else begin
                     Info := Info + ', '
                  end;
                  Info := Info + Trim(Copy(s2, Length(s)+1, Length(s2)))
               end
            end
         end;
         bfirst := true;
         s := '='+User;
         For i := 0 to Aliase.Count-1 do begin
            s2 := Trim(Aliase[i]);
            If (s2 > '') and (Not (s2[1] IN [';', '#', '/'])) then begin
               p := Pos(s, LowerCase(s2));
               If (p > 0) and (p = Length(s2)-Length(s)+1) then begin
                  If bFirst then begin
                     If Info > '' then Info := Info + #13#10#13#10;
                     Info := Info + Tr('Aliases', 'Alias(es): ');
                     bfirst := false
                  end else begin
                     Info := Info + ', '
                  end;
                  Info := Info + Trim(Copy(s2, 1, p-1))
               end
            end
         end;
         labAliase.Caption := Info;
      finally
         Unlock
      end;
      {/HSR}
      chkAdvancedSettings.Checked := Def_AdvancedConfiguration;
      If ShowModal = mrOK then begin
         With CfgAccounts do try
            Lock;
            With Users.Find(userID) do begin
               // General
               Groupname := emGroup.Text;
               Fullname := emFullname.Text;
               // News
               OverrideNewsaccess := chkOverrideGroupAccess.Checked;
               NewsPostAccess := emNewsPost.Text;
               NewsReadAccess := emNewsRead.Text;
               Newspeer := GetTriValue(cbPeernews);
               Newsnews := GetTriValue(cbNewnews);
               ModeCancel := GetTriValue(cbModeCancel);
               // Mail
               Mailaddr := emMailAddr.Text;
               OldMBt := UseMailboxtype;
               OverrideMailboxtype := chkOverrideMailboxtype.Checked;
               Mailboxtype := TMailboxtype(rgLocalMailbox.ItemIndex);
               If (UseMailboxtype<>OldMBt) and (UseMailboxtype=mbtIMAP) then InitIMAPMailbox;
               HasMailbox; // create/remove mailbox
               Mailsend := GetTriValue(cbMailSend);
               // Remote Control
               RemoteControl := GetTriValue(cbRemoteControl)
            end
         finally
            Unlock
         end
      end
   finally Free end
end;

procedure TfrmAccount.btnPasswordChangeClick(Sender: TObject);
var  P1, P2: String;
begin
     P1 := '';
     P2 := '';
     if not InputDlgPwd( TrGl(kGlobal,'DlgPWEdit.Caption', 'Change password'),
                         TrGl(kGlobal,'DlgPWEdit.PromptPW1', 'New password:'),
                         P1, 0{HlpChangePassword} ) then exit;
     if not InputDlgPwd( TrGl(kGlobal,'DlgPWEdit.Caption', 'Change password'),
                         TrGl(kGlobal,'DlgPWEdit.PromptPW2', 'Repeat new password:'),
                         P2, 0{HlpChangePassword} ) then exit;

     if P1<>P2 then begin
        Application.MessageBox( PChar(TrGl(kGlobal,'DlgPWEdit.DifferentPWs',
                                'Given passwords were not equal!^MPassword remains unchanged!')),
                                PChar(TrGl(kGlobal,'DlgPWEdit.Caption', 'Change password')),
                                MB_ICONEXCLAMATION );
        exit;
     end;
     With CfgAccounts do try
        Lock;
        Users.Find(UserID).Password := P1;
     finally
        Unlock
     end;
     if P1='' then emPassword.Text:=TrGl(kGlobal,'PW.None', '{NONE}')
              else emPassword.Text:=TrGl(kGlobal,'PW.Set', '{SET}');
end;

Var LastPage: Integer = 0;

procedure TfrmAccount.FormCreate(Sender: TObject);
begin
   pg.ActivePageIndex := LastPage;
end;

procedure TfrmAccount.FormDestroy(Sender: TObject);
begin
   LastPage := pg.ActivePageIndex
end;

procedure TfrmAccount.butTestNewsaccessClick(Sender: TObject);
begin
   TestNewsAccess (emNewsRead.Text, emNewsPost.Text)
end;

Procedure TestNewsAccess (Const sRead, sPost: String);
Var s, sAnd, Info: String;
    slNo, slRead, slWrite: TStringlist;
    i: Integer;
begin
   slNo    := TStringList.Create;
   slRead  := TStringList.Create;
   slWrite := TStringList.Create;
   try
      slNo.sorted := true;
      slRead.sorted := true;
      slWrite.sorted := true;
      sAnd := TrGl(kGlobal, 'Test.NewsReadWrite.and', 'and');
      Info := '';
      For i := 0 to CfgHamster.ActiveCount-1 do begin
         s := CfgHamster.ActiveName[i];
         Case GetPermissionForGroup ( s, sPost, sRead ) of
            PERM_NOTH: slNo.Add (s);
            PERM_READ: slRead.Add (s);
            PERM_POST: slWrite.Add (s)
         end
      end;
      With slWrite do If Count > 0 then begin
         Info := TrGl(kGlobal, 'Test.Post.text', 'User can post into following groups') + ': ';
         For i := 0 to Count-2 do begin
            If i < Count-2 then Info := Info + Strings[i] + ', '
                           else Info := Info + Strings[i] + ' ' + sAnd + ' '
         end;
         Info := Info + Strings[Count-1];
         Application.MessageBox(
            PChar(Info),
            PChar(TrGl(kGlobal, 'Test.Post.caption', 'Groups matching read and post-regexp')),
            MB_ICONINFORMATION )
      end;
      With slRead do If Count > 0 then begin
         Info := TrGl(kGlobal, 'Test.Read.text', 'User can read following groups') + ': ';
         For i := 0 to Count-2 do begin
            If i < Count-2 then Info := Info + Strings[i] + ', '
                           else Info := Info + Strings[i] + ' ' + sAnd + ' '
         end;
         Info := Info + Strings[Count-1];
         Application.MessageBox(
            PChar(Info),
            PChar(TrGl(kGlobal, 'Test.Read.caption', 'Groups matching only read-regexp')),
            MB_ICONINFORMATION )
      end;
      With slNo do If Count > 0 then begin
         Info := TrGl(kGlobal, 'Test.NoAccess.text', 'User has no access to following groups') + ': ';
         For i := 0 to Count-2 do begin
            If i < Count-2 then Info := Info + Strings[i] + ', '
                           else Info := Info + Strings[i] + ' ' + sAnd + ' '
         end;
         Info := Info + Strings[Count-1];
         Application.MessageBox(
            PChar(Info),
            PChar(TrGl(kGlobal, 'Test.NoAccess.caption', 'Groups don''t matching read-regexp')),
            MB_ICONINFORMATION )
      end;
   finally
      slNo.Free;
      slRead.Free;
      slWrite.free
   end;
end;

procedure TfrmAccount.chkAdvancedSettingsClick(Sender: TObject);
Var b: Boolean;
begin
   b := chkAdvancedSettings.Checked;
   labAdvancedSettings.Visible := b;
   cbNewNews.Visible := b;
   cbPeerNews.Visible := b;
   cbModeCancel.Visible := b;
   tsRemoteControl.TabVisible := b;
end;

procedure TfrmAccount.chkOverrideGroupAccessClick(Sender: TObject);
Var b: Boolean;
begin
   b := chkOverrideGroupAccess.checked;
   emNewsread.Visible := b;
   emNewspost.Visible := b;
   butTestNewsaccess.Enabled := b;
   labDefaultNewsRead.Visible := Not b;
   labDefaultNewsPost.Visible := Not b
end;

procedure TfrmAccount.chkOverrideMailboxtypeClick(Sender: TObject);
Var b: Boolean; 
begin
   b := chkOverrideMailboxtype.checked;
   rgLocalMailbox.Visible := b;
   labGroupMailboxtype.Visible := Not b
end;

procedure TfrmAccount.butEditGroupClick(Sender: TObject);
Var s: String; ID: Integer;
begin
   s := emGroup.Text;
   With CfgAccounts do try
      Lock;
      ID := Groups.IDOf(s)
   finally
      Unlock
   end;
   If ID > ACTID_INVALID then begin
      DialogEditGroup(ID);
      ReadGroupSettings
   end else begin
      beep
   end
end;

procedure TfrmAccount.emGroupClick(Sender: TObject);
begin
   ReadGroupSettings
end;

procedure TfrmAccount.ReadGroupSettings;
Var BoolInfo: Array[Boolean] of String; s: String;
begin
   s := emGroup.Text;
   BoolInfo[true] := TrGl(kGlobal, 'Yes', 'Yes');
   BoolInfo[false] := TrGl(kGlobal, 'No', 'No');
   With CfgAccounts do try
      Lock;
      GroupID := Groups.IDOf(s);
      If GroupID > ACTID_INVALID then begin
         With Groups.Find(GroupID) do begin
            labGroupDefaultNewNews.Caption := BoolInfo[DefaultNewNews];
            labGroupDefaultPeerNews.Caption := BoolInfo[DefaultNewspeer];
            labGroupDefaultModeCancel.Caption := BoolInfo[DefaultModeCancel];
            labGroupDefaultMailsend.Caption := BoolInfo[DefaultMailsend];
            labGroupDefaultRemoteControl.Caption := BoolInfo[DefaultRemoteControl];
            labGroupMailboxtype.Caption := '('+rgLocalMailbox.Items[Ord(DefaultMailboxtype)]+')';
            labDefaultNewsRead.Caption := DefaultNewsRead;
            labDefaultNewsPost.Caption := DefaultNewsPost;
         end
      end else begin
         labGroupDefaultNewNews.Caption := '???';
         labGroupDefaultPeerNews.Caption := '???';
         labGroupDefaultModeCancel.Caption := '???';
         labGroupDefaultMailsend.Caption := '???';
         labGroupDefaultRemoteControl.Caption := '???';
         labGroupMailboxtype.Caption := '(???)';
         labDefaultNewsRead.Caption := '???';;
         labDefaultNewsPost.Caption := '???';;
      end
   finally
      Unlock
   end;
end;

end.
