unit fGroup;                                                               //HSR //Groups

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, cStdForm, ComCtrls;

type
  TfrmGroup = class(THForm)
    grpAccount: TGroupBox;
    emDescription: TEdit;
    GroupBox1: TGroupBox;
    btnOK: TButton;
    btnCancel: TButton;
    butHelp: TButton;
    pg: TPageControl;
    tsNews: TTabSheet;
    Label1: TLabel;
    Label9: TLabel;
    labAdvancedSettings: TLabel;
    chkNewsnews: TCheckBox;
    butTestNewsaccess: TButton;
    emNewsRead: TEdit;
    emNewsPost: TEdit;
    chkpeernews: TCheckBox;
    tsMailSettings: TTabSheet;
    chkMailSend: TCheckBox;
    tsRemoteControl: TTabSheet;
    chkRemoteControl: TCheckBox;
    chkModeCancel: TCheckBox;
    chkAdvancedSettings: TCheckBox;
    rgLocalMB: TRadioGroup;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure butTestNewsaccessClick(Sender: TObject);
    procedure chkAdvancedSettingsClick(Sender: TObject);
  end;

Procedure DialogEditGroup (Const GroupID: Integer);

implementation
                        
uses
  cAccount, Global, Config, dInput, fAccount, inifiles;

{$R *.DFM}

Procedure DialogEditGroup (Const GroupID: Integer);
Var s: String;
begin
   With TFrmGroup.Create(NIL) do try
     With CfgAccounts do try
        Lock;
        If Groups.Find(GroupID)=NIL then Exit;
        With Groups.Find(GroupID) do begin
           s := Description;
           If s = '' then s := Name;
           emDescription.Text  := s;
           emNewsPost.Text     := DefaultNewsPost;
           emNewsRead.Text     := DefaultNewsRead;
           rgLocalMB.itemindex := Ord(DefaultMailboxtype);
           chkMailSend.Checked := DefaultMailsend;
           chkPeerNews.Checked := DefaultNewspeer;
           chkNewsNews.Checked := DefaultNewNews;
           chkModeCancel.Checked := DefaultModeCancel;
           chkRemoteControl.Checked := DefaultRemoteControl;
        end
     finally
        unlock
     end;
     chkAdvancedSettings.Checked := Def_AdvancedConfiguration;
     If ShowModal = mrOk then begin
        With CfgAccounts do try
           Lock;
           If Groups.Find(GroupID)=NIL then Exit;
           With Groups.Find(GroupID) do begin
              Description := emDescription.Text;
              DefaultNewsPost := emNewsPost.Text;
              DefaultNewsRead := emNewsRead.Text;
              DefaultMailboxtype := TMailboxtype(rgLocalMB.itemindex);
              DefaultMailsend := chkMailSend.Checked;
              DefaultNewspeer := chkpeernews.Checked;
              DefaultNewNews := chkNewsNews.Checked;
              DefaultModeCancel := chkModeCancel.Checked;
              DefaultRemoteControl := chkRemoteControl.Checked;
           end
        finally
           Unlock
        end
     end
   finally Free end
end;

Var Last: Integer = 0;

procedure TfrmGroup.FormCreate(Sender: TObject);
begin
   pg.ActivePageIndex := Last;
   labAdvancedSettings.Font.Style := [fsUnderline]
end;

procedure TfrmGroup.FormDestroy(Sender: TObject);
begin
   Last := pg.ActivePageIndex
end;

procedure TfrmGroup.butTestNewsaccessClick(Sender: TObject);
begin
   TestNewsAccess (emNewsRead.Text, emNewsPost.Text)
end;

procedure TfrmGroup.chkAdvancedSettingsClick(Sender: TObject);
Var b: Boolean;
begin
   b := chkAdvancedSettings.Checked;
   labAdvancedSettings.Visible := b;
   chkNewsNews.Visible := b;
   chkPeerNews.Visible := b;
   chkModeCancel.Visible := b;
   tsRemoteControl.TabVisible := b;
end;

end.
