unit hConfigSASL;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CheckLst, ExtCtrls;

Function ChooseSASL ( Const Supported, Chosen: String ): String;

type
  TDlgChooseSASL = class(TForm)
    Panel1: TPanel;
    lb: TCheckListBox;
    OKBtn: TButton;
    CancelBtn: TButton;
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

implementation

{$R *.DFM}

Function ChooseSASL ( Const Supported, Chosen: String ): String;
Var s, akt: String; i, p: Integer;
begin
   Result := Chosen;
   With TDlgChooseSASL.Create(NIL) do try
      lb.Items.Clear;
      s := Supported;
      While s > '' do begin
         p := Pos(' ', s);
         If p > 0 then begin
            akt := Copy(s, 1, p-1); Delete(s, 1, p)
         end else begin
            akt := s; s := ''
         end;
         If akt > '' then begin
            p := lb.Items.Add(akt);
            lb.Checked[p] := Pos(' '+akt+' ', ' '+chosen+' ') > 0
         end
      end;
      If ShowModal = mrOK then begin
         Result := '';
         For i := 0 to lb.Items.Count-1 do begin
            If lb.Checked[i] then begin
               If Result > '' then Result := Result + ' ';
               Result := Result + lb.Items[i]
            end
         end
      end
   finally
      free
   end
end;

end.
