unit tScriptInsCmd;

interface

Uses menus, Controls, stdctrls;

Type
  TInsertCommand = Class
  private
    FControl: TControl;
    FPop: TPopupMenu;
    Modulinfo, FileInfo: String;
    Procedure MenuClick ( Sender: TObject );
    Procedure ExpandMenu ( Sender: TObject );
    Procedure SetMenuType (MI: TMenuItem);
    Procedure Init ( pop: TPopupMenu; Control: TControl );
    procedure InitPopup;
    procedure LoadCommandList;
    function CheckModules: String;
    function CheckFile: String;
  public
    constructor Create ( pop: TPopupMenu; Edit: TEdit ); overload;
    constructor Create ( pop: TPopupMenu; Memo: TMemo ); overload;
    Procedure Popup;
  end;

implementation

Uses global, uTools, Config, cStdForm,
     windows, sysutils, classes, dialogs;

Var slCommands: TStringList;

Const
    kTestModules = '@TESTMODULES@';
    kForAllMods = '@ALLMODULES@=';
    kForAllMods_Wildcard = '$';
    kNNTPServerlist = '@NNTPSERVERLIST@';
    kPOP3Serverlist = '@POP3SERVERLIST@';
    kSMTPServerlist = '@SMTPSERVERLIST@';
    kRASlist = '@RASLIST@';

Function CountBlanks(Const s: String): Integer;
Var i: Integer;
begin
   Result := 0;
   For i := 1 to Length(s) do If s[i]=' ' then Inc(Result) else exit
end;

{ TInsertCommand }

Procedure TInsertCommand.Init ( pop: TPopupMenu; Control: TControl);
begin
   FControl := Control;
   FPop := Pop;
end;

constructor TInsertCommand.Create(pop: TPopupMenu; Edit: TEdit);
begin
  inherited Create;
  Init (pop, Edit)
end;

constructor TInsertCommand.Create(pop: TPopupMenu; Memo: TMemo);
begin
  inherited Create;
  Init (pop, Memo)
end;

procedure TInsertCommand.ExpandMenu(Sender: TObject);
Var bFirstItem: Boolean;
    i, T, T2: Integer; s: String;
    MI: TMenuItem;
begin
   bFirstItem := true;
   With Sender as TMenuItem do begin
      OnClick := NIL;
      T := CountBlanks(slCommands[Tag]);
      For i := Tag+1 to slCommands.Count-1 do begin
         s := slCommands[i];
         If s > '' then begin
            T2 := CountBlanks(s);
            If T2 <= T then begin
               System.break
            end else
            If T2 = T+1 then begin
               If bFirstItem then begin
                  bFirstItem := false;
                  MI := Items[0]
               end else begin
                  MI := TMenuItem.Create(NIL);
                  Add (MI)
               end;
               MI.Tag := I;
               SetMenuType (MI)
            end
         end
      end
   end
end;

procedure TInsertCommand.MenuClick(Sender: TObject);
Var s, s2, indent: String; p: Integer;
begin
   s := slCommands[(Sender as TMenuItem).Tag];
   p := Pos(':', s);
   Delete (s, 1, p);
   s := StringReplace ( s, '^m', #13#10, [rfReplaceAll] );
   If FControl is TEdit then begin
      If (Length(s)>2) and (Copy(s, Length(s)-1, 2)=#13#10)
         then Delete(s, Length(s)-1, 2);
      s := StringReplace ( s, #13#10, '', [rfReplaceAll] );
   end else
   If FControl is TMemo then With FControl as TMemo do begin
      p := SelStart; Indent := '';
      While (p-Length(Indent) > 1) and (Text[p-Length(Indent)-1]=' ')
         do Indent := Indent + ' ';
      s := StringReplace ( s, #13#10, #13#10 + Indent, [rfReplaceAll] );
   end;
   p := Pos('@', s);
   If p > 0 then begin
      s2 := Copy(s, p+1, Length(s)-p);
      s := Copy(s, 1, p-1)
   end else begin
      s2 := ''
   end;
   If FControl is TEdit then With FControl as TEdit do begin
      p := SelStart;
      SelText := s + s2;
      SetFocus;
      SelStart := p + Length(s)
   end else
   If FControl is TMemo then With FControl as TMemo do begin
      p := SelStart;
      SelText := s + s2;
      SetFocus;
      SelStart := p + Length(s)
   end;
end;

Procedure TInsertCommand.LoadCommandList;
Var Indent, s, s2, VarName: String;
    r: TSearchRec;
    sl: TStringList;
    M, p, i, offs, j, k: Integer;
    TitleForConsts: Boolean;
begin
   If Not Assigned(slCommands) then begin
      slCommands := TStringList.Create;
      s := PATH_BASE + CommandMenuFilename;
      If FileExists2(s) then begin
         slCommands.LoadFromFile(s);
         For i := slCommands.Count-1 downto 0 do begin
            s := slCommands[i];
            If Trim(s) = kTestModules then begin
               slCommands.Delete (i);
               offs := 0;
               Indent := '';
               For j := 1 to CountBlanks(s) do Indent := Indent + ' ';
               If FindFirst (PATH_HSM + '*.hsm', faAnyfile, r) = 0 then begin
                  sl := TStringList.Create;
                  try
                     Repeat
                        sl.LoadFromFile(PATH_HSM+r.Name);
                        TitleForConsts := false;
                        slCommands.Insert(i+Offs, Indent + r.Name );
                        Inc(Offs);
                        M := 0;
                        For k := 0 to sl.Count-1 do begin
                           s := Trim(sl[k]);
                           If (M=0) and (LowerCase(s) = '#!initialize') then Inc(M)
                           else
                           If (M IN[1, 2]) and (
                              (LowerCase(Copy(s, 1, 6)) = 'varset') or
                              (LowerCase(Copy(s, 1, 5)) = 'const')
                           ) then begin
                              If M = 1 then begin
                                 slCommands.Insert(i+Offs, Indent + ' Variables/Consts');
                                 Inc(Offs);
                                 M := 2
                              end;
                              p := Pos('(', s);
                              If p > 0 then begin
                                 If LowerCase(Copy(s, 1, 9)) = 'constenum' then begin
                                    s2 := Trim(Copy(s, p+1, Length(s)));
                                    Repeat
                                       p := Pos(',', s2);
                                       If p > 0 then begin
                                          VarName := Trim(Copy(s2, 1, p-1));
                                          Delete(s2, 1, p)
                                       end else begin
                                          VarName := Trim(s2);
                                       end;
                                       If Varname > '' then begin
                                          Varname := Indent + '  '+Varname+':'+Varname;
                                          If TitleForConsts then Varname := ' '+Varname;
                                          slCommands.Insert(i+Offs, Varname);
                                          Inc(offs)
                                       end
                                    until p = 0
                                 end else begin
                                    s2 := Trim(Copy(s, p+1, Length(s)));
                                    Repeat
                                       p := Pos(',', s2);
                                       If p > 0 then begin
                                          VarName := Trim(Copy(s2, 1, p-1));
                                          Varname := Indent + '  '+Varname+':'+Varname;
                                          If TitleForConsts then Varname := ' '+Varname;
                                          slCommands.Insert(i+Offs, Varname);
                                          Inc(offs);
                                          Delete(s2, 1, p);
                                       end
                                    until p = 0
                                 end
                              end
                           end
                           else
                           If (M IN[1, 2]) and (LowerCase(Copy(s, 1, 2)) = '##') then begin
                              If M = 1 then begin
                                 slCommands.Insert(i+Offs, Indent + ' Variables');
                                 Inc(Offs);
                                 M := 2
                              end;
                              s2 := s;
                              Delete(s2, 1, 2);
                              s2 := Trim(s2);
                              If s2 > '' then begin
                                 If s2[Length(s2)] = ':' then begin
                                    Delete(s2, Length(s2), 1); s2 := Trim(s2)
                                 end;
                                 If s2 > '' then begin
                                    TitleForConsts := true;
                                    slCommands.Insert(i+Offs, Indent + '  '+s2);
                                    Inc(offs)
                                 end
                              end
                           end
                           else
                           If (M = 1) and (LowerCase(Copy(s, 1, 6)) = 'return') then M := 3
                           else
                           If (M = 2) and (LowerCase(Copy(s, 1, 6)) = 'return') then M := 5
                           else
                           If (M IN [0, 3, 5, 10]) and (LowerCase(Copy(s, 1, 4)) = 'sub ') then begin
                              If M < 10 then begin
                                 slCommands.Insert(i+Offs, Indent + ' Subs/Functions');
                                 Inc(offs);
                                 M := 10
                              end;
                              s2 := Copy(s, 5, Length(s)-4);
                              p := Pos('(', s2);
                              If p > 0 then begin
                                 If (p<Length(s2)) and (s2[p+1]=' ') then Inc(p);
                                 Insert ( '@', s2, p )
                              end;
                              slCommands.Insert(i+Offs, Indent + '  '+s+':'+s2);
                              Inc(offs)
                           end
                        end;
                        If M IN [0, 1, 3] then begin
                           Dec(offs);
                           slCommands.Delete(i-Offs)
                        end
                     until FindNext(r) <> 0;
                  finally
                     FindClose(r);
                     sl.Free
                  end
               end
            end else
            If Copy(Trim(s), 1, Length(kForAllMods)) = kForAllMods then begin
               Indent := '';
               For j := 1 to CountBlanks(s) do Indent := Indent + ' ';
               s := Trim(s);
               Delete (s, 1, Length(kForAllMods));
               Offs := 0;
               slCommands.Delete(i+offs);
               If FindFirst (PATH_HSM + '*.hsm', faAnyfile, r) = 0 then try
                  Repeat
                     s2 := Indent+s;
                     s2 := StringReplace ( s2, kForAllMods_Wildcard, r.Name, [rfReplaceAll]);
                     slCommands.Insert (i+offs, s2);
                     Inc(offs)
                  until FindNext(r) <> 0;
               finally
                  FindClose(r)
               end
            end else
            If Trim(s) = kNNTPServerlist then begin
               Indent := '';
               For j := 1 to CountBlanks(s) do Indent := Indent + ' ';
               With CfgHamster do begin
                  If ServerCount = 0 then begin
                     slCommands.Delete (i)
                  end else begin
                     For j := 0 to ServerCount-1 do begin
                        s := ServerName[j] + ',' + ServerPort[j];
                        s := Indent + s + ':' + '"'+ s + '"';
                        If j = 0 then slCommands[i] := s
                        else slCommands.Insert(i+j, s)
                     end
                  end
               end
            end else
            If Trim(s) = kPOP3Serverlist then begin
               Indent := '';
               For j := 1 to CountBlanks(s) do Indent := Indent + ' ';
               With CfgHamster do begin
                  If POP3ServerCount = 0 then begin
                     slCommands.Delete (i)
                  end else begin
                     For j := 0 to POP3ServerCount-1 do begin
                        s := POP3ServerName[j] + ',' + POP3ServerPort[j];
                        s := Indent + s + ':' + '"'+ s + '"';
                        If j = 0 then slCommands[i] := s
                        else slCommands.Insert(i+j, s)
                     end
                  end
               end
            end else
            If Trim(s) = kSMTPServerlist then begin
               Indent := '';
               For j := 1 to CountBlanks(s) do Indent := Indent + ' ';
               With CfgHamster do begin
                  If SMTPServerCount = 0 then begin
                     slCommands.Delete (i)
                  end else begin
                     For j := 0 to SMTPServerCount-1 do begin
                        s := SMTPServerName[j] + ',' + SMTPServerPort[j];
                        s := Indent + s + ':' + '"'+ s + '"';
                        If j = 0 then slCommands[i] := s
                        else slCommands.Insert(i+j, s)
                     end
                  end
               end
            end else
            If Trim(s) = kRASList then begin
               Indent := '';
               For j := 1 to CountBlanks(s) do Indent := Indent + ' ';
               sl := TStringList.Create;
               If Not Assigned(RasDialer) then Rasdialer := TRasDialer.Create;
               try
                  RasDialer.GetConnectionList( sl );
                  sl.Sort;
                  If sl.Count = 0 then begin
                     slCommands.Delete (i)
                  end else begin
                     For j:=0 to sl.Count-1 do begin
                        s := sl[j];
                        s := Indent + s + ':' + '"'+ s + '"';
                        If j = 0 then slCommands[i] := s
                        else slCommands.Insert(i+j, s)
                     end
                  end
               finally
                  sl.free
               end
            end
         end
      end
   end
end;

Function TInsertCommand.CheckFile: String;
begin
   Result := PATH_BASE + CommandMenuFilename;
   Result :=   ':'+IntToStr(FileAge(Result))
//              +':'+IntToStr(FileSize(Result))
end;

Function TInsertCommand.CheckModules: String;
Var r: TSearchRec;
begin
   Result := '';
   If FindFirst (PATH_HSM + '*.hsm', faAnyfile, r) = 0 then try
      Repeat
         Result := Result + r.Name
                   + ':' + IntToStr(r.Time)
                   + ':' + IntToStr(r.Size)
                   + '#'
      until FindNext(r) <> 0
   finally
      FindClose(r)
   end
end;

Procedure TInsertCommand.InitPopup;
Var MI: TMenuItem; i: Integer; s: String;
begin
   If fpop.Items.Count = 0 then begin
      fpop.AutoHotkeys := maManual;
      With slCommands do begin
         If Count = 0 then Exit;
         For i := 0 to Count-1 do begin
            s := Strings[i];
            If s = '-' then
               fpop.Items.NewBottomLine
            else If CountBlanks(s)=0 then begin
               MI := TMenuItem.Create(NIL);
               MI.Tag := i;
               SetMenuType (MI);
               fpop.Items.Add (MI)
            end
         end
      end
   end
end;

procedure TInsertCommand.Popup;
Var p: TPoint; s: String; st, l: Integer;
begin
   With (FControl as TCustomEdit) do begin
      st := SelStart;
      l := SelLength;
      SetFocus;
      SelStart := st;
      SelLength := l
   end;
   s := CheckFile;
   If s <> FileInfo then begin
     fPop.Items.Clear;
     FreeAndNil(slCommands);
     FileInfo := s
   end;
   s := CheckModules;
   If s <> Modulinfo then begin
     fPop.Items.Clear;
     FreeAndNil(slCommands);
     ModulInfo := s
   end;
   LoadCommandList;
   InitPopup;
   GetCursorPos (p);
   fpop.Popup ( p.x, p.y )
end;

procedure TInsertCommand.SetMenuType(MI: TMenuItem);
Var p: Integer; Cmd, s: String;
begin
   p := MI.Tag;
   Cmd := slCommands[p];
   If p+1 > slCommands.Count-1
      then s := ''
      else s := slCommands[p+1];
   If CountBlanks(s) > CountBlanks(Cmd) then begin
      MI.Caption := Trim(Cmd);
      MI.OnClick := ExpandMenu;
      MI.Add (TMenuItem.Create(NIL))
   end else begin
      p := Pos(':', Cmd)-1;
      If p > 0 then begin
         MI.Caption := Trim(Copy(Cmd, 1, p));
         MI.OnClick := MenuClick
      end else begin
         MI.Caption := Trim(Cmd)
      end
   end
end;

initialization
   slCommands := NIL;
finalization
   If Assigned(slCommands) then slCommands.Free;
end.
