unit uCommands;

interface

Uses
     Global;

Type
   TCommands = class
     private
        Function AnyServer (Const Server: TLocalServerTypes; Const Par: Integer): Integer;
     public
        Function HamMessage(Const Cmd, Par: Integer): Integer;
        Procedure StopAllTasks;
        Procedure ShowMainWindow (Const par: Integer);
        Procedure ShowTrayIcon (Const par: Integer);
        Function  ConfigReload (Const Par: Integer): Integer;
        Procedure IPAccessReload;
        Function  ShutDown (Const Wait: Integer): boolean;
        Function  NNTPServer (Const Par: Integer): Integer;
        function  IMAPServer(const Par: Integer): Integer;
        function  POP3Server(const Par: Integer): Integer;
        function  ReCoServer(const Par: Integer): Integer;
        function  SMTPServer(const Par: Integer): Integer;
        Procedure ResetCounters(Const Par: Integer);
        function  DialogDirs(const Par: Integer): Integer;
        function  DialogScripts(const Par: Integer): Integer;
        function  DialogNewsKillfileLog(const Par: Integer): Integer;
        function  DialogMailKillfileLog(const Par: Integer): Integer; //PW Mail-KillLog 2003-06-06
   end;

Var
   Commands: TCommands;

implementation

Uses sysutils, Windows, messages, ShellAPI,
     // -----------------
     Main, Config, cIPAccess, cMailAlias, cLogfile, cStdForm,
     dEditDir, dScripts, dGroupSelect, HKillsMain,
     HMailKillsMain;

{ TCommands }

function TCommands.AnyServer(const Server: TLocalServerTypes;
  const Par: Integer): Integer;
begin
   Result := 1;
   If (Par >= 0) and (Par <= Ord(High(TLocalServerActivates))) then begin
      if LocalServerActivate( Server, TLocalServerActivates(Par) ) then Result := 0;
   end else
   If Par = 3 then begin
      If LocalServerIsActive( Server ) then Result := 1 else Result := 0
   end
end;

Function TCommands.HamMessage(const Cmd, Par: Integer): Integer;
begin
   Result := 1; // Default=Error (0=OK, 2=Unknown ID)
   try
      Log( LOGID_DEBUG,
           'Message(' + inttostr(Cmd) + ',' + inttostr(Par) + ')' );
      case Cmd of
         HAM_MSG_HAMSTER_EXIT: If Shutdown(Par) then Result := 0;
         HAM_MSG_LOCALNNTP_ONOFF: Result := NNTPServer(Par);
         HAM_MSG_LOCALSMTP_ONOFF: Result := SMTPServer(Par);
         HAM_MSG_LOCALPOP3_ONOFF: Result := POP3Server(Par);
         HAM_MSG_LOCALIMAP_ONOFF: Result := IMAPServer(Par);
         HAM_MSG_LOCALRECO_ONOFF: Result := ReCoServer(Par);
         HAM_MSG_RESET_COUNTERS: begin ResetCounters(Par); Result := 0 end;
         HAM_MSG_SHOWWINDOW: begin ShowMainWindow(Par); Result := 0 end;
         HAM_MSG_SHOWICON: begin ShowTrayIcon(Par); Result := 0 end;
         HAM_MSG_STOPALLTASKS: begin StopAllTasks; Result := 0 end;
         HAM_MSG_CONFIG_RELOAD: Result := ConfigReload(Par);
         HAM_MSG_CONFIG_IPAccess: begin IPAccessReload; Result := 0 end;
         HAM_MSG_DIRS: Result := DialogDirs(Par);
         HAM_MSG_SCRIPTS : Result := DialogScripts(Par);
         HAM_MSG_NEWSKILLFILELOG: Result := DialogNewsKillfileLog(Par);
         HAM_MSG_PULLNEWGROUPS: Case Par of
            1: If Not DialogPullNewGroupsOpen then begin
                  DialogPullNewGroups; Result := 0
               end;
            2: If DialogPullNewGroupsOpen then Result := 1 else Result := 0
         end;
         HAM_MSG_MAILKILLFILELOG: Result := DialogMailKillfileLog(Par);
         else Result:=2
      end;

   except
      on E: Exception do
         Log( LOGID_ERROR, 'Msg.WMHamster.Exception: ' + E.Message );
   end
end;

Function TCommands.DialogDirs (Const Par: Integer): Integer;
begin
   Result := -1;
   Case Par of
      1: begin DialogEditDir; Result := 0 end;
      0: begin DialogEditDirClose; Result := 0 end;
      2: If IsDialogEditDirOpen then Result := 1 else Result := 0;
   end
end;

Function TCommands.DialogScripts(Const Par: Integer): Integer;
begin
   Result := -1;
   Case Par of
      1: begin DialogManageScripts; Result := 0 end;
      0: begin DialogManageScriptsClose; Result := 0 end;
      2: If IsDialogManageScriptsOpen then Result := 1 else Result := 0;
   end
end;

Function TCommands.DialogNewsKillfileLog(Const Par: Integer): Integer;
begin
   Result := -1;
   Case Par of
      1: begin
            If HamsterMainWindow.ModalActive=0 then begin
               inc( HamsterMainWindow.ModalActive );
               DialogKillsMain;
               dec( HamsterMainWindow.ModalActive );
               Result := 0
            end else  begin
               Log( LOGID_WARN, 'Hamster already in modal state.')
            end
         end;
      0: begin DialogKillfileLogClose; Result := 0 end;
      2: If IsDialogKillfileLogOpen then Result := 1 else Result := 0;
   end
end;

{PW}{Mail-KillLog 2003-06-06}
Function TCommands.DialogMailKillfileLog(const Par: Integer): Integer; //PW Mail-KillLog 2003-06-06
begin
   Result := -1;
   Case Par of
      1: begin
            If HamsterMainWindow.ModalActive=0 then begin
               inc( HamsterMainWindow.ModalActive );
               DialogMailKillsMain;
               dec( HamsterMainWindow.ModalActive );
               Result := 0
            end else  begin
               Log( LOGID_WARN, 'Hamster already in modal state.')
            end
         end;
      0: begin DialogMailKillfileLogClose; Result := 0 end;
      2: If IsDialogMailKillfileLogOpen then Result := 1 else Result := 0;
   end
end;

function TCommands.NNTPServer(const Par: Integer): Integer;
begin
   Result := AnyServer ( stNNTP, Par );
   HamsterMainWindow.mnuLocalNntp.Checked := LocalServerIsActive( stNNTP );
end;
function TCommands.SMTPServer(const Par: Integer): Integer;
begin
   Result := AnyServer ( stSMTP, Par );
   HamsterMainWindow.mnuLocalSMTP.Checked := LocalServerIsActive( stSMTP );
end;
function TCommands.POP3Server(const Par: Integer): Integer;
begin
   Result := AnyServer ( stPOP3, Par );
   HamsterMainWindow.mnuLocalPOP3.Checked := LocalServerIsActive( stPOP3 );
end;
function TCommands.IMAPServer(const Par: Integer): Integer;
begin
   Result := AnyServer ( stIMAP, Par );
   HamsterMainWindow.mnuLocalIMAP.Checked := LocalServerIsActive( stIMAP );
end;
function TCommands.ReCoServer(const Par: Integer): Integer;
begin
   Result := AnyServer ( stReCo, Par );
   HamsterMainWindow.mnuLocalReCo.Checked := LocalServerIsActive( stReCo );
end;

Function TCommands.ShutDown(const Wait: Integer): boolean;
begin
   Result := false;
   if Wait>0 then sleep(Wait); { JW }
   if GetCounter(CanCloseNow)=0 then begin
      PostMessage( HamsterMainWindow.Handle, WM_CLOSE, 0, 0 );
      CloseByScript:=true;
      Result := true
   end else begin
      AllShutDownReq := True;
   end;
end;

procedure TCommands.StopAllTasks;
begin
   AllShutdownReq := true;
   EnterCriticalSection(CS_Event);
   SetEvent( EVT_STOPSCRIPT );
   LeaveCriticalSection(CS_Event);
   Log( LOGID_SYSTEM, TrGl(kLog, 'ShutDown_wait', 'Shutdown in progress - please wait' ) );
end;

Procedure TCommands.ResetCounters(const Par: Integer);
begin
   HamsterMainWindow.ResetCounter(Par)
end;

procedure TCommands.ShowMainWindow(const par: Integer);
begin
   Case Par of
      0: HamsterMainWindow.AppMinimize(HamsterMainWindow);
      1: HamsterMainWindow.OnShowManualClick(HamsterMainWindow);
   end
end;

procedure TCommands.ShowTrayIcon(const par: Integer);
begin
   if Par=0 then begin
      if HamsterTrayIcon.hIcon<>0 then begin
         HamsterTrayIcon.hIcon  := 0;
         Shell_NotifyIcon( NIM_DELETE, @HamsterTrayIcon );
      end;
   end else begin
      if HamsterTrayIcon.hIcon=0 then begin
         HamsterTrayIcon.hIcon:=HamsterMainWindow.GetTrayIconHandle;
         Shell_NotifyIcon( NIM_ADD, @HamsterTrayIcon );
      end;
   end
end;

function TCommands.ConfigReload(const Par: Integer): Integer;
begin
   If Par = 1 then begin
      MailAlias.Reload; //JW //Reload Malias
      HamsterMainWindow.OnRefreshMenuItems (NIL);
      If HamsterMainWindow.ConfigWndActive=0 then ConfigLoad (ctAll);
      Result := 0
   end else begin
      If HamsterMainWindow.ConfigWndActive=0
         then Result := 1
         else Result := 0;
   end
end;

procedure TCommands.IPAccessReload;
begin
   IPAccessCheck.reload
end;

initialization
   Commands := TCommands.Create;
finalization
   FreeAndNil(Commands)
end.
