unit uImapUtils;

interface

Uses Classes;

Procedure FindIMAPMails (Const Directory: String; Const List: TStrings; Const ShowIMAPSubDirs: boolean);

Type
  TIMAPStringtype = ( IMAP_STRING_ATOM, IMAP_STRING_QUOTED, IMAP_STRING_LITERAL );
  TIMAPStringtypes = Set of TIMAPStringtype;
Const
  IMAP_STRING_STRING  = [IMAP_STRING_QUOTED, IMAP_STRING_LITERAL];
  IMAP_STRING_ASTRING = IMAP_STRING_STRING + [IMAP_STRING_ATOM];

procedure GetString( var InStr: String; out OutStr: String; Const Stringtype: TIMAPStringtypes );
function  QuotedStringOrToken( s: String ): String;
function  TrimQuotes( Data: String ): String;
function  TrimParentheses( Data: String ): String;
function  NString( Data: String ): String;
procedure SplitString( SubStr: String; var Data: String; out Rest: String );
procedure SplitStringWhSpace( var Data: String; out Rest: String );
function  SwitchByteOrder( Input: Longint ): Longint; {MG}{IMAP-UID-ByteOrder}
function  CutFirstParam( var Parameters: String ): String;

// ----------------------------------------------------------------------------

implementation

uses uTools, SysUtils, cLogfile;

function TrimEnclosingChars( Data, FirstChar, LastChar: String ): String;
var  i: Integer;
begin
     Data := TrimWhSpace( Data );
     i := length( Data );
     if (i>1) and (Data[1] = FirstChar) and (Data[i] = LastChar) then
        Result := copy( Data, 2, i-2 )
     else
        Result := Data
end;

function TrimQuotes( Data: String ): String;
begin
     Result := TrimEnclosingChars( Data, '"', '"' )
end;

function TrimParentheses( Data: String ): String;
begin
     Result := TrimEnclosingChars( Data, '(', ')' )
end;

procedure GetString( var InStr: String; out OutStr: String; Const Stringtype: TIMAPStringtypes );
var  i, Size : Integer;
begin
   OutStr := '';
   if InStr = '' then exit;

   if (IMAP_STRING_QUOTED IN Stringtype) and (InStr[1] = '"') then begin
      i := 2;
      while i <= Length( InStr ) do begin
         case Instr[i] of
            '\' : System.Delete( InStr, i, 1 );
            '"' : begin
                     OutStr := Copy( InStr, 2, i-2 );
                     System.Delete( InStr, 1, i );
                     exit
                  end;
         end;
         inc( i )
      end;
      Log( LOGID_DEBUG, 'Error parsing quoted string: No closing quotation mark' )

   end else if (IMAP_STRING_LITERAL IN Stringtype) and (InStr[1] = '{') then begin
      for i := 2 to Length(InStr) do begin
         if InStr[i] = '}' then begin
            if InStr[i-1] = '+' // Literal+ //NHB
               then Size := StrToIntDef( Copy( InStr, 2, i-3 ), -1 )
               else Size := StrToIntDef( Copy( InStr, 2, i-2 ), -1 );
            System.Delete( InStr, 1, i + 2 );
            if Size < 0 then break;
            if Length(InStr) >= Size then begin
               OutStr := Copy( InStr, 1, Size );
               System.Delete( InStr, 1, Size );
            end else begin
               InStr := '';
               Log( LOGID_DEBUG, 'Error parsing literal string: literal too short' )
            end;
            exit
         end
      end;
      Log( LOGID_DEBUG, 'Error parsing literal string: malformed literal' )

   end else if (IMAP_STRING_ATOM IN Stringtype) then begin
      for i := 1 to Length(InStr) do begin
         if InStr[i] in [' ', '(', ')', '"'] then begin
            OutStr := Copy( InStr, 1, i-1 );
            System.Delete( InStr, 1, i-1 );
            exit
         end;
      end;
      OutStr := InStr;
   end;

   InStr := ''
end;

function QuotedStringOrToken( s: String ): String;
begin
   s := TrimWhSpace( s );
   GetString( s, Result, [IMAP_STRING_QUOTED, IMAP_STRING_ATOM] );
   Result := TrimWhSpace( Result )
end;

function NString( Data: String ): String;
Var i, j: Integer;
begin
   if Data = '' then begin
      Result := 'NIL'
   end else begin
      Result := '"';
      j := 1;
      // Escape quotes and backslashes: '"' -> '\"' and '\' -> '\\'
      for i := 1 to Length( Data ) do begin
         if Data[i] in ['"','\'] then begin
            Result := Result + Copy( Data, j, i-j ) + '\';
            j := i;
         end
      end;
      Result := Result + Copy( Data, j, Length(Data)-j+1 ) + '"'
   end
end;

procedure SplitStringIdx( Idx: Integer; var Data: String; out Rest: String );
begin
     if Idx > 0 then begin
        Rest := Copy( Data, Idx+1, Length(Data)-Idx );
        SetLength( Data, Idx-1 );
     end else Rest := '';
end;

procedure SplitString( SubStr: String; var Data: String; out Rest: String );
begin
     SplitStringIdx( Pos( SubStr, Data ), Data, Rest );
end;

procedure SplitStringWhSpace( var Data: String; out Rest: String );
begin
     SplitStringIdx( PosWhSpace( Data ), Data, Rest );
     TrimWhSpace( Rest );
end;

{MG}{IMAP-UID-ByteOrder}
function SwitchByteOrder( Input: Longint ): Longint;
begin
     Result :=  Input                shl 24 +
               (Input and $0000FF00) shl  8 +
               (Input and $00FF0000) shr  8 +
                Input                shr 24
end;
{/IMAP-UID-ByteOrder}

// ----------------------------------------------------------------------------

Procedure FindIMAPMails (Const Directory: String; Const List: TStrings; Const ShowIMAPSubDirs: boolean);
Var Root: String;

  Procedure Find ( Const Dir: String );
  Var r: TSearchRec;
  begin
     If FindFirst(Dir+'*.*', faAnyfile-faVolumeID, r) = 0 then try
        Repeat
           If (r.Attr and faDirectory) > 0 then begin
              If ShowIMAPSubDirs then begin
                 If (r.Name<>'.') and (r.Name<>'..') then Find(Dir+r.Name+'\')
              end
           end else If LowerCase(ExtractFileExt(r.Name))='.msg' then begin
              List.Add ( Copy ( Dir+r.Name, Length(Root)+1, Length(Dir+r.Name) ) )
           end
        until FindNext(r) <> 0
     finally
        FindClose(r)
     end
  end;

begin
   List.Clear;
   Root := IncludeTrailingBackSlash(Directory);
   Find (Root)
end;

function CutFirstParam( var Parameters: String ): String;
var  Str: String;
begin
     GetString( Parameters, Str, IMAP_STRING_ASTRING );
     Parameters := TrimWhSpace( Parameters );
     Result := TrimWhSpace( Str );
end;

end.