unit Korrektu;

{
Type:news-test Filename:H:\Hamster\Out\News\1634.mtg
}

interface

Uses Windows, Messages, SysUtils, Classes, Settings, ShellApi, uSkript,
     {$IFNDEF NOGUI} Dialogs, {$ENDIF} IniFIles;

{$IFDEF CopyIf}
Procedure CheckPosting (Posting: TStrings; AktOpt: TEinstellungen);
Procedure Stop;
{$ELSE}
Procedure NewsKorrektur;
{$ENDIF}

Procedure BoxQuote (Const Titel: String; Const Def: TCfgBoxQuotes; sl: TStrings);

Const Titel = {$IFDEF CopyIf} 'CopyIf ' {$ELSE} 'KorrNews ' {$ENDIF} + 'V'+Ver;

Procedure Fehler (Const Beschreibung, Rest: String); forward;

Type TRetry = (rNone, rRetryLine, rJumpNextLineAndStop, rJumpNextLineAndRun, rEndProgram);

implementation

Uses  UPerlRe, uArtikel, uGetString, uGetNum
      {$IFNDEF NOGUI}, DError {$ENDIF}
      {$IFDEF CopyIf}, DShow, uHamster {$ENDIF};

Const CRLF = ^M^J;
      ISOIntro = '=?'; ISODel = '?'; ISOExtro = '?=';
      ISODefCharset = 'ISO-8859-1';
      ISOStd = ISOIntro + ISODefCharset + ISODel + 'Q' + ISODel;
      {ISOStart2 = '=?ISO-8859-15?Q?';}
      ISODefZeilentrenner = ISOExtro + CRLF + ' ' + ISOIntro + ISODefCharset + ISODel + 'Q' + ISODel;
      kRe = 're:'; kWasbegin = '(was:'; kWasEnde = ')';
      StartUUEncode = 'begin 644 ';
      Adressfelder = ' from: reply-to: to: '; { lowercase! }
      HeaderReferences = 'references: ';
      HeaderSubject = 'subject: ';
      HeaderDate = 'Date: ';
      HeaderQPKodierung = 'content-transfer-encoding: quoted-printable';
      XHeaderbegin = 'X-';
      HexZiffern = '0123456789ABCDEF';
      MaxISOHeaderLen = 76;
      MIMEStdGrenze = [' '];
      MIMELinkeGrenzeFrom = MIMEStdGrenze + ['"', '('];
      MIMERechteGrenzeFrom = MIMEStdGrenze + ['"', ')'];
      MIMEVersion = 'Mime-Version: ';
      MIMEContentType = 'Content-Type: ';
      MIMEContentTransfer = 'Content-Transfer-Encoding: ';
      MIME_7Bit = '7bit';
      MIME_8Bit = '8bit';
      Headerzeichen = [#33..#128];
      HamsterFrom = '!MAIL FROM';
      HamsterTo = '!RCPT TO';

      Extraheader_ConvertHeader = 'X-CopyIf-Converted-Headers: ';
      Extraheader_ConvertBody = 'X-CopyIf-Converted-Body: ';
      Extraheader_OEBeginBug = 'X-CopyIf-OE-Begin-Bug: Fixed!';
      Extraheader_OEKillFalseReBug = 'X-CopyIf-OE-KillFalseRe-Bug: Fixed!';
      Extraheader_RepairOE = 'X-CopyIf-Repaired-OE-Quoting: ';
      HeaderCont = [^I, ' '];

      kTyp = 'Type:';
      kFilename = 'Filename:';

Var
      Dateiname: String;
      Only7Bit, Only7BitTested, Changed: boolean;
      Opt: TEinstellungen;
      Retry: TRetry;
      ChangeSig: boolean;
      {$IFNDEF CopyIf}
      FalscheMessageID, RichtigeMessageID: String;
      slBodyHeader: THeader;
      slAppend, slFN, slSig, {$ENDIF}
      slIntro, slVars, slVarsVal, slStack,
      slOptionenKey, slOptionenValue, slSonderheader: TStringlist;

      Skript: TSkript;

Type
   TLevel = -1..30;
      { Bedingte Ausfhrung: }
Var                
   Bed, Done: Array[TLevel] of Boolean;
   Level: TLevel;

{ --------------------------------------------------------------- }
{$IFDEF NOGUI}

Type
  TDlgError = Class
  public
    Skript_Dateiname,
    Fehlerhinweis,
    Zeileninhalt: String;
    ZeilenNr: Integer;
    AktRetry: TRetry;
    Constructor Create (p: Pointer);
    Procedure ShowModal;
  end;

Constructor TDlgError.Create (p: Pointer);
begin
end;

Procedure TDlgError.ShowModal;
Var s: String;
begin
   s := '';
   If Zeileninhalt > '' then begin
      If MessageBox (0, PChar('Fehler in "'+Skript_Dateiname+'" in Zeile '+IntToStr(ZeilenNr)+': '+ Fehlerhinweis+#13#10#13#10
                           +'Die fehlerhafte Zeile lautet:'+#13#10#13#10+Zeileninhalt+#13#10#13#10
                           +'Korrnews wird daher vorzeitig beendet - Skript bearbeiten?'),
                       NIL, MB_YESNO + MB_ICONERROR ) = IDYES
      then begin
         ShellExecute(GetDesktopWindow, 'open', PChar('Notepad.exe'), PChar(Skript_Dateiname), NIL, SW_SHOW)
      end;
      s := 'Fehler in "'+Skript_Dateiname+'" in Zeile '+IntToStr(ZeilenNr)+': '+ Fehlerhinweis+#13#10#13#10
                     +'Die fehlerhafte Zeile lautet:'+#13#10#13#10+Zeileninhalt+#13#10#13#10
                      +'Korrnews wird daher vorzeitig beendet - Skript bearbeiten?'
   end else begin
      MessageBox (0, PChar('Folgender Fehler ist aufgetreten: ' + Fehlerhinweis),
                     NIL, MB_OK + MB_ICONERROR )
   end;
   AktRetry := rEndProgram
end;

{$ENDIF}
{ --------------------------------------------------------------- }


Procedure assert(Const s: String);
begin
   If MessageBox (0, PChar(s), PChar('Assert'), MB_OKCANCEL) = IDCANCEL then Halt
end;

Function Sgn(Const x: Double): Integer;
begin
   If x > 0 then Result := 1
   else If x < 0 then Result := -1
   else Result := 0
end;

Function CvHex(Const s: String): Byte;
Var p1, p2: Integer;
begin
   p1 := Pos(Upcase(s[1]), HexZiffern); p2 := Pos(UpCase(s[2]), HexZiffern);
   If (p1>0) and (p2>0) then Result := (p1-1) * 16 + (p2-1)
                        else Result := 0
end;
Function HexStr(Const x: Byte): String;
begin
   Result := HexZiffern[(x div 16)+1] + HexZiffern[(x mod 16)+1]
end;

Function ExecAndWait(const Filename, Params: string;
                     WindowState: word): boolean;
var
  SUInfo: TStartupInfo;
  ProcInfo: TProcessInformation;
  CmdLine, Path: string;
  Buffer: String[255];
  p, R: Integer;
begin
   { ggf. passende Datei suchen ... }
   If Not FileExists(FileName) then begin
      Buffer[0] := Chr(255);
      R := FindExecutable( PChar(FileName), PChar(ExtractFilePath(Filename)), @Buffer[1]);
      p := Pos(#0, Buffer); If p>0 then Buffer[0] := Chr(P-1);
      If (R > 32) and (p > 0) then CmdLine := Buffer
   end else CmdLine := Filename;
  { Enclose filename in quotes to take care of
    long filenames with spaces. }
  Path := ExtractFilePath(CmdLine);
  CmdLine := '"' + CmdLine + '"';
  If Params > '' then CmdLine := CmdLine + ' ' + Params;
  FillChar(SUInfo, SizeOf(SUInfo), #0);
  with SUInfo do begin
    cb := SizeOf(SUInfo);
    dwFlags := STARTF_USESHOWWINDOW;
    wShowWindow := WindowState;
  end;
  Result := CreateProcess(NIL, PChar(CmdLine), NIL, NIL, FALSE,
                          CREATE_NEW_CONSOLE or
                          NORMAL_PRIORITY_CLASS, NIL,
                          PChar(Path),
                          SUInfo, ProcInfo);
  { Wait for it to finish. }
  if Result then
    WaitForSingleObject(ProcInfo.hProcess, INFINITE);
end;

{ Datum / Zeit dank Haible }

function GetCurrentTimeZoneBiasHrs : LongInt;
const TIME_ZONE_ID_UNKNOWN  = 0;
      TIME_ZONE_ID_STANDARD = 1;
      TIME_ZONE_ID_DAYLIGHT = 2;
var  TZI      : TTimeZoneInformation;
     TZResult : Integer;
begin
     TZResult := GetTimeZoneInformation(TZI);

     case TZResult of
        TIME_ZONE_ID_UNKNOWN : Result:=-(TZI.Bias                 ) div 60;
        TIME_ZONE_ID_STANDARD: Result:=-(TZI.Bias+TZI.StandardBias) div 60;
        TIME_ZONE_ID_DAYLIGHT: Result:=-(TZI.Bias+TZI.DaylightBias) div 60;
        else                   Result:=0;
     end;
end;

function NowGMT : TDateTime;
begin
   Result := Now - GetCurrentTimeZoneBiasHrs / 24.0;
end;

function DT2NNTPDate( DT: TDateTime; Const GMT: boolean) : String;
const DAYNAMES   = 'SunMonTueWedThuFriSat';
      MONTHNAMES = 'JanFebMarAprMayJunJulAugSepOctNovDec';
var  sDT         : String;
     DOW, MOY, St: Integer;
begin
     sDT := FormatDateTime( 'dd"."mm"."yyyy hh":"nn":"ss', DT );
     DOW := DayOfWeek( DT );  // 1=Sun, ..., 7=Sat
     MOY := strtoint( copy( sDT, 4, 2 ) );

     // Date: Fri, 27 Mar 1998 12:12:50 +1300
     Result := copy( DAYNAMES, DOW*3-2, 3 ) + ',' + ' '
             + copy( sDT, 1, 2 ) + ' '
             + copy( MONTHNAMES, MOY*3-2, 3 ) + ' '
             + copy( sDT, 7, 4 ) + ' '
             + copy( sDT, 12, 8 ) + ' ';

     St := GetCurrentTimeZoneBiasHrs;
     If GMT or (St=0) then
        Result := Result + 'GMT'
     else begin
        If St < 0 then Result := Result + '-'
                  else Result := Result + '+';
        St := Abs(St);
        Result := Result + Chr( Ord('0')+(St div 10) ) + Chr( Ord('0')+(St Mod 10) ) + '00'
     end
end;


{ Hilfsfunktionen }

Procedure LoadTextFile ( Const Dateiname: String; sl: TStrings );
Const MaxVers = 20; MinWait = 50; MaxWait = 200;
Var Vers: Integer;
begin
   Vers := 0;
   If Not FileExists(Dateiname) then begin
      sl.Clear
   end else begin
      try
         sl.LoadFromFile(Dateiname)
      except
         Inc(Vers);
         If Vers > MaxVers
            then raise
            else Sleep(Random(MaxWait-MinWait)+MinWait)
      end
   end
end;

{$IFNDEF CopyIf}
Procedure DeleteBodyHeader(Const Header: String);
Var Suchen: String; L, i: Integer;
begin
   Suchen := LowerCase(Header)+': '; L := Length(Suchen);
   For i:=0 to slBodyHeader.Count-1 do begin
      If Suchen = LowerCase(Copy(slBodyHeader[i], 1, L)) then begin
         Skript[Skript.FindObject(slBodyHeader.Objects[i])].Inhalt := '';
         slBodyHeader[i] := ''; break
      end
   end
end;
{$ENDIF}

Function ISOChar(Const c: Char): String;
begin
   Case c of
      ' ': Result := '_';
      Chr(0)..Pred(' '),
        '?', '_', '=',
           Chr(128)..Chr(255): Result := '='+HexStr(Ord(c));
      else Result := c;
   end
end;

Function ConvertToQP (Const Zeilen: String): String;
Var s, s2, Conv: String; c: Char; z, i, L: Integer; EndCR: boolean;
begin
   Result := '';
   If Zeilen = '' then exit;
   EndCR := (Length(Zeilen) > 2) and (Copy(Zeilen, Length(Zeilen)-1, 2) = #13#10);
   With TStringlist.Create do try
      Text := Zeilen;
      For z := 0 to Count-1 do begin
         L := 0; s := Strings[z]; Conv := '';
         For i:=1 to Length(s) do begin
            c := s[i];
            If (i=1) and (c='F') then s2 := '='+HexStr(Ord(c))
            else If c IN['=',Chr(0)..Chr(31),Chr(128)..Chr(255)] then s2 := '='+HexStr(Ord(c))
            else s2 := c;
            If L + Length(s2) > MaxISOHeaderLen then begin
               Conv := Conv + '=' + CRLF; L := 0
            end;
            L := L + length(s2); Conv := Conv + s2
         end;
         Strings[z] := Conv
      end;
      Result := text;
      If Not EndCR then Result := Copy(Result, 1, Length(Result)-2)
   finally free end
end;

Function DecodeQPString (Const s: String; Const IstHeader: boolean): String;
Var j, l: Integer;
begin
   Result := ''; j:=1; l := Length(s);
   While j <= l do begin
      Case s[j] of
         '_': If IstHeader then Result := Result + ' ' else Result := Result + '_';
         '=': If j+2<=l then begin
                 If (s[j+1] = #13) and (s[j+2] = #10) then
                    Inc(j, 2)
                 else If CvHex(s[j+1]+s[j+2]) > 0 then begin
                    Result := Result + Chr(CvHex(s[j+1]+s[j+2])); Inc(j,2)
                 end else Result := Result + s[j]
              end else Result := Result + s[j]
         else Result := Result + s[j]
      end;
      Inc(j)
   end
end;

Function DecodeBodyString (Const s: String): String;
begin
   If Artikel.qp then Result := DecodeQPString(s, false)
                 else Result := s
end;
Function EncodeBodyString (Const s: String): String;
begin
   If Artikel.qp then Result := ConvertToQP (s)
                 else Result := s
end;

// Decode a BASE64 encoded line - Thanx to Peter Haas
function DecodeLineBASE64 (Const s: String): String;
var  B: Cardinal; C: Char; z, I, J: Integer; s2: String;
begin
  Result := ''; z := 1;
  While z <= Length(s) do begin
    B:=0; J:=-1;
    repeat
      C := s[z]; Inc(z);
      case C of
        'A'..'Z' : I:=( 0-ord('A'))+Ord(C);
        'a'..'z' : I:=(26-Ord('a'))+ord(C);
        '0'..'9' : I:=(52-Ord('0'))+ord(C);
        '+'      : I:=62;
        '/'      : I:=63;
        else       I:=-1;
      end;
      if I>=0 then begin
        B:=(B shl 6) or Byte(I); inc(J);
      end;
    until (J=3) or (z > Length(s));
    {If J<3 then Showmessage('Now!');}
    If J > 0 then begin
       Case J of
          2: B := B shr 2;
          1: B := B shr 4;
       end;
       SetLength(s2, J);
       for I:=J downto 1 do begin
         s2[I]:=Chr(B); B:=B shr 8;
       end;
       Result := Result + s2
    end;
  end
end;

Function DecodeISO (Const s: String): String;
Var p1, p2, p3, i: Integer; s2: String;
    Charset: String; Codebase: Char;
begin
   Result := s;
   p1 := Pos(ISOIntro, LowerCase(s));
   If p1 = 0 then exit;

   p2 := 0;
   For i := p1+Length(ISOIntro) to Length(s)-Length(ISOExtro)-1-2 do begin
      Case s[i] of
         ISODel: begin p2 := i; break end;
         #13, #10: break
      end
   end;
   If (p2 = 0) or (s[p2+2]<>ISODel) then exit;

   CodeBase := UpCase(s[p2+1]);
   If (CodeBase <> 'Q') and (CodeBase <> 'B') then exit;

   Charset := LowerCase(Copy(s, p1+Length(ISOIntro), p2-p1-Length(ISOIntro)));
   If (Charset <> LowerCase(ISODefCharset)) then exit;

   p3 := 0;
   For i := p2+4 to Length(s)-Length(ISOExtro)+1 do begin
      If (s[i] = ISOExtro[1]) and (Copy(s, i, Length(ISOExtro)) = ISOExtro) then begin
         p3 := i; break
      end
   end;
   If p3 = 0 then exit;

   s2 := Copy(s, p2+3, p3-p2-3);
   Case CodeBase of
      'Q': s2 := DecodeQPString(s2, true);
      'B': s2 := DecodeLineBASE64(Copy(s2,1,Length(s2)-1));
      else exit
   end;
   Result := Copy(s, 1, p1-1) + s2 + DecodeISO (Copy(s, p3 + Length(ISOExtro), Length(s)))
end;

Function HeaderDecode (Const p: Integer; Const InclHeader: boolean): String;
begin
   If InclHeader then Result := Artikel.Header.Name[p] + ': ' else Result := '';
   Result := Result + DecodeISO (Artikel.Header.InhaltPerPos(p, hiOriginalOhneCRs))
end;

Function HeaderMIMEKodierung(Const H: String): String;

    Function Encode (Const Inhalt: String; Const p, q: Integer;
                     Var p2, q2: Integer): String;
    Var i: Integer;
    begin
       Result := '';
       For i := 1 to Length(Inhalt) do begin
         If (i < p) or (i > q) then Result := Result + Inhalt[i]
         else begin
            If i = p then begin p2 := Length(Result)+1; Result := Result + ISOStd end;
            Result := Result + ISOChar(Inhalt[i]);
            If i = q then begin q2 := Length(Result)+1; Result := Result + ISOExtro end
         end
       end
    end;

Var p, q, i, p2, q2: Integer; Neu, Header, Inhalt: String;
    EndLineWithMIME: Boolean; LinksGrenze, RechtsGrenze: Set of Char;
    Anfang, Rest: String;
begin
   Result := H;
   p := Pos(#13#10, H);
   If p>0 then begin
      Anfang := Copy(H, 1, p-1);
      Rest := Copy(H, p+2, Length(H))
   end else begin
      Anfang := H; Rest := ''
   end;
   p := Pos(': ', Anfang);
   EndLineWithMIME := (Rest > '')
                      and ((Copy(Rest, 1, Length(ISOStd)+1) = ' '+ISOStd));
   If p>0 then begin
      Header := Copy(Anfang, 1, p+1);
      If Pos(' '+Lowercase(Header), Adressfelder)>0 then begin
         LinksGrenze := MIMELinkeGrenzeFrom;
         RechtsGrenze := MIMERechteGrenzeFrom
      end else begin
         LinksGrenze := MIMEStdGrenze;
         RechtsGrenze := MIMEStdGrenze
      end;
      Inhalt := Copy(Anfang, p+2, Length(Anfang)-p-1);
      p := -1; q := -1;
      For i:=1 to Length(Inhalt) do If Ord(Inhalt[i])>127 then begin
         q := i; If p < 0 then p := i;
         {If Inhalt[i]='' then begin
            AktISOStart := ISOStart2; AktISOZeilenTrenner := ISOZeilenTrenner2
         end}
      end;
      If EndLineWithMIME or ((q>0) and (p>0)) then begin
         While (p > 1) and Not (Inhalt[p-1] IN LinksGrenze) do Dec(p);
         While (q < Length(Inhalt)) and Not (Inhalt[q+1] IN Rechtsgrenze) do Inc(q);
         If EndLineWithMIME then begin
            If p = -1 then begin
               p := 1; For  i:=2 to Length(Inhalt) do If Inhalt[i-1] IN LinksGrenze then p := i
            end;
            q := Length(Inhalt)
         end;
         Neu := Encode(Inhalt, p, q, p2, q2);
         If Length(Neu) > MaxISOHeaderLen then begin
            If p2 + Length(ISOStd) + 3 + Length(ISOExtro) > MaxISOHeaderLen then begin
               p := 1;
               For i:= 2 to MaxISOHeaderLen - Length(ISOStd) - Length(ISOExtro) - 3 - 1
                  do If Inhalt[i-1] IN LinksGrenze then p := i
            end;
            q := Length(Inhalt);
            Neu := Encode(Inhalt, p, q, p2, q2);
            { Erste Aufteilposition }
            p := MaxISOHeaderLen - Length(ISOExtro);
            Repeat
               If p >= q2-1 then p := q2-2;
               If Neu[p-2]='=' then Dec(p);
               If Neu[p-1]='=' then Dec(p);
               Neu := Copy(Neu, 1, p - 1) + ISODefZeilentrenner + Copy(Neu, p, Length(Neu) - p + 1);
               q := Length(ISODefZeilentrenner);
               p := p + q + MaxISOHeaderLen - Length(ISOStd) - Length(ISOExtro) - 1; { Neue Trennposition }
               q2 := q2 + q { Endekennung hat sich ebenfalls verschoben }
            Until Length(Neu) - p < 0
         end;
         Result := Header + Neu;
         If Rest > '' then Result := Result + #13#10 + Rest
      end
   end
end;

Function SetzeOption (Const s: String): boolean;
Var P: Integer; s2, Key, value: String;
begin
   Result := false;
   p := Pos('=', s);
   If p > 0 then begin
      Key := LowerCase(Trim(Copy(s,1,p-1)));
      s2 := Trim(Copy(s,p+1,Length(s)));
      If Not GetString(s2, Value) then Value := s2;
      p := slOptionenKey.IndexOf(key);
      If p<0 then begin
         slOptionenKey.Add(Key); slOptionenValue.Add(Value)
      end else slOptionenValue[p] := value;
      { Optionen wieder einlesen... }
      With Opt do begin
         ExtraKeys := slOptionenKey; ExtraValues := slOptionenValue;
         Opt.ReadSettings (false);
         ExtraKeys := NIL; ExtraValues := NIL
      end;
      Result := true
   end
end;

Function TestOnly7Bit: Boolean;
Var j, i: Integer; s2: String;
begin With Artikel do begin
   If Not Only7BitTested then begin
      Only7Bit := true;
      With Body do For i:= 0 to Count-1 do If Only7Bit then begin
         s2 := Strings[i]; For j:=1 to Length(s2) do If s2[j]>#127 then Only7Bit := false
      end;
      With slIntro do For i:= 0 to Count-1 do If Only7Bit then begin
         s2 := Strings[i]; For j:=1 to Length(s2) do If s2[j]>#127 then Only7Bit := false
      end;
      {$IFDEF CopyIf}
      {$ELSE}
      If ChangeSig then begin
         With slSig do For i:= 0 to Count-1 do If Only7Bit then begin
            s2 := Strings[i]; For j:=1 to Length(s2) do If s2[j]>#127 then Only7Bit := false
         end
      end else begin
         With Sig do For i:= 0 to Count-1 do If Only7Bit then begin
            s2 := Strings[i]; For j:=1 to Length(s2) do If s2[j]>#127 then Only7Bit := false
         end
      end;
      With slAppend do For i:= 0 to Count-1 do If Only7Bit then begin
         s2 := Strings[i]; For j:=1 to Length(s2) do If s2[j]>#127 then Only7Bit := false
      end;
      {$ENDIF}
   end;
   Result := Only7Bit

end end;

Type TRVN = (vnIllegal, vnExist, vnNew);
     TTypVariable = (tvMain, tvLokal, tvVarLokal, tvBeginLokal, tvEndLokal);

Function GetVarName (Var s, VarName: String): TRVN;
Var p: Integer;
begin
   Result := vnIllegal;
   s := Trim(s); VarName := '';
   If (s+' ')[1]='%' then begin
      p := 2;
      While (p<=length(s)) and (Upcase(s[p]) IN['A'..'Z','0'..'9','_','-','/','+','$','&']) do begin
         VarName := VarName + UpCase(s[p]); Inc(p)
      end;
      If (p<=Length(s)) and (s[p]='%') then begin
         s := Trim(Copy(s, p+1, Length(s)-p));
         If VarName > '' then
            If slVars.IndexOf(Varname) < 0
               then Result := vnNew
               else Result := vnExist;
      end
   end
end;
Function GetVarNameForGetStr (Var s, VarName: String): boolean;
begin
   Result := false;
   Case GetVarName(s, VarName) of
      vnNew: begin
         If Not (Bed[Level-1] and Bed[Level]) then begin
            Result := true;
         end else begin
            Fehler('Verwendung einer uninitialisierten Variable "%'+VarName+'%"', s)
         end
      end;
      vnExist: Result := true
   end
end;
Function VarNamePos (Const Bez: String): Integer;
Var s: String;
begin
   Result := slVars.IndexOf(UpperCase(Bez));
   If Result >= 0 then begin
      While TTypVariable(slVars.Objects[Result]) = tvVarLokal do begin
         s := UpperCase(slVarsVal[Result]);
         Repeat
            Inc(Result);
            If Result >= slVars.Count then Fehler('Interner Fehler - Variablenverwaltung macht Probleme', '')
         Until s = slVars[Result]
      end
   end
end;
Function ExistVarName (Const Bez: String): boolean;
begin
   Result := VarNamePos (Bez) >= 0
end;
Function SetVarValue (Const Bez, Inh: String): Integer;
begin
   With slVars do begin
      Result := VarNamePos (UpperCase(Bez));
      If Result < 0 then begin
         Result := 0; Insert (Result, UpperCase(Bez)); slVarsVal.Insert(Result, '')
      end;
      slVarsVal[Result] := Inh
   end
end;
Function GetVarValue (Const Bez: String): String;
Var p: Integer;
begin
   With slVars do begin
      p := VarNamePos (UpperCase(Bez));
      If p < 0 then Result := ''
               else Result := slVarsVal[p]
   end
end;
Procedure SetLokalVars (Const SubBez: String; Var ABez, AInh: Array of String; AVarTyp: Array of Boolean);
Var i: Integer;
begin
   slVars.InsertObject(0, '', Pointer(tvEndLokal)); slVarsVal.Insert(0,SubBez);
   For i:=High(ABez) downto Low(ABez) do If (ABez[i]>'') then begin
      If AVarTyp[i]
         then slVars.InsertObject(0, ABez[i], Pointer(tvVarLokal))
         else slVars.InsertObject(0, ABez[i], Pointer(tvLokal));
      slVarsVal.Insert(0, AInh[i])
   end;
   slVars.InsertObject(0, '', Pointer(tvBeginLokal)); slVarsVal.Insert(0,SubBez);
end;
Procedure ClearLokalVars;
Var i, p1, p2: Integer;
begin
   p1 := slVars.IndexOfObject(Pointer(tvBeginLokal));
   p2 := slVars.IndexOfObject(Pointer(tvEndLokal));
   If (p1>=0) and (p2>=0) then For i := p1 to p2 do begin
      slVars.Delete(p1); slVarsVal.Delete(p1)
   end
end;

Function Filename_HeaderDef: String;
begin
   {$IFDEF CopyIf}
   Result := ChangeFileExt (ParamStr(0), '.def');
   {$ELSE}
   Result := Opt.FilePath + Opt.HeaderDef;
   {$ENDIF}
end;

Function FilePath: String;
begin
   {$IFDEF CopyIf}
   Result := ExtractFilePath (ParamStr(0));
   {$ELSE}
   Result := Opt.FilePath;
   {$ENDIF}
end;

Function ErgaenzeDateiname (Const d: String): String;
begin
   If ((D+' ')[1]='\') or ((D+'  ')[2]=':')
      then Result := D
      else Result := FilePath + D
end;

Procedure FuelleSkript;
Var i, j: Integer; s, s2: String;
    sl: TStringlist;
begin
   sl := TStringlist.Create;
   try
      LoadTextFile (Filename_HeaderDef, sl);
      Skript.Fill  (Filename_HeaderDef, sl)
   finally sl.free end;
   With Skript do begin
      i := 0; j := 0;
      While i < Count do begin
         s := Trim(Skript[i].Inhalt); {Assert(s);}
         Skript.Zeile := i+1;
         If SucheUndKuerze('Do Include', s) and (j < 20) then begin
            If GetString (s, s2) then begin
               try
                  Skript.ExpandLineToFile (i, ErgaenzeDateiname(s2))
               except
                  On EInOutError do begin
                     Fehler ('Fehler beim Einlesen der Include-Datei "'+ErgaenzeDateiname(s2)+'"', s);
                  end
               end;
            end else Fehler ('Nach "Do Include" mu noch der gewnschte Dateiname folgen', s);
            Inc(j)
         end else begin
            Inc(i); j := 0
         end
      end
   end;
   {$IFNDEF CopyIf}
   For j:=0 to Opt.LDelXHeader.Count-1 do begin
      s := Trim(Opt.LDelXHeader[j]);
      If Pos(':', s) = 0 then s := s + ':';
      Skript.InsertLine(j, s)
   end;
   {$ENDIF}
end;

Procedure Fehler (Const Beschreibung, Rest: String);
Var Zeile2: Integer; {$IFNDEF NOGUI} i, j, p: Integer; s: String; {$ENDIF}


   Function ML(Const s: String): String;
   Var i: Integer;
   begin
      With TStringlist.Create do try
         Text := s;
         If Count>0 then Result := Strings[0] else Result := '';
         For i:=1 to Count-1 do Result := Result + #13#10 + '       <CRLF>' + Strings[i]
      finally free end
   end;

begin With Artikel do begin
   With TDlgError.Create(nil) do try
      If Skript.Zeile <= Skript.Count then begin
         Zeile2 := Skript.ZeilenNr[Skript.Zeile-1];
         ZeilenNr := Zeile2;
         Zeileninhalt := Skript[Skript.Zeile-1].Inhalt;
         Skript_Dateiname := Skript.Dateiname[Skript.Zeile-1]
      end else begin
         ZeilenNr := 0;
         {$IFNDEF NOGUI} Zeile2 := 0; {$ENDIF}
         Zeileninhalt := '';
         Skript_Dateiname := ''
      end;
      Fehlerhinweis := Beschreibung;

      {$IFNDEF NOGUI}
      With mGesamt do begin
         Clear;
         For i:=0 to Skript.Count-1 do Lines.Add(Skript[i].Inhalt)
      end;
      With mSkript do begin
         LoadTextFile(Skript_Dateiname, Lines);
         Perform(EM_LineScroll, 0 , Zeile2 - 5);
         p := 0; For i:=0 to Zeile2-2 do p := p + Length(Lines[i])+2;
         If Beschreibung = '' then begin
             p := p + Length(Lines[Zeile2-1])
         end else If Length(Rest) > 0  then begin
            s := Lines[Zeile2-1];
            j := Pos(Rest, s) - 1;
            If j>0 then p := p + j
         end;
         SelStart := p
      end;
      With mVars do With Lines do begin
         Clear;
         Add ('Zeile '+Inttostr(ZeilenNr)+'/'+InttoStr(Skript.Count)+': '+Zeileninhalt);
         If Level > 0 then begin
            Add (''); Add ('Bedingte Ausfhrung:');
            For i:=1 to Level do begin
               s := '  '; For j := 2 to i do s := s + ' ';
               If Bed[i] then s := s + 'Wird ausgefhrt' else s := s + 'Wird ignoriert';
               Add (s)
            end;
         end;
         If slStack.Count>0 then begin
            Add (''); Add ('Stack:');
            For i := 0 to slStack.Count-1 do Lines.Add ('  '+slStack[i]);
         end;
         If slVars.Count>0 then begin
            Add (''); Add ('Variablen:');
            For i := 0 to slVars.Count-1 do Case TTypVariable (slVars.Objects[i]) of
               tvMain: Lines.Add ('  Global %'+slVars[i] + '%="' + ML(slVarsVal[i]) + '"');
               tvLokal: Lines.Add ('      Parameter %'+slVars[i] + '%="' + ML(slVarsVal[i]) + '"');
               tvVarLokal: Lines.Add ('      Var-Parameter %'+slVars[i] + '% entspricht/ndert %' + slVarsVal[i] + '%');
               tvBeginLokal: Lines.Add ('  Ausfhrung von Sub '+slVarsVal[i]);
            end
         end;
         If slOptionenKey.Count>0 then begin
            Add (''); Add ('Neu gesetzte Optionen:');
            For i := 0 to slOptionenKey.Count-1 do
               Lines.Add ('  '+slOptionenKey[i] + '=' + slOptionenValue[i])
         end;
         {$IFDEF CopyIf}
         {$ELSE}
         If slBodyHeader.Count>0 then begin
            Add (''); Add ('Bodyheader:');
            For i := 0 to slBodyHeader.Count-1 do Add ('  '+slBodyHeader[i])
         end;
         {$ENDIF}
         If slIntro.Count>0 then begin
            Add (''); Add ('Einleitungszeile(n) "Intro":');
            For i := 0 to slIntro.Count-1 do Add ('  '+slIntro[i])
         end;
         {$IFDEF CopyIf}
         {$ELSE}
         If slAppend.Count>0 then begin
            Add (''); Add ('Anzuhngende "Lines":');
            For i := 0 to slAppend.Count-1 do Add ('  '+slAppend[i])
         end;
         If ChangeSig then begin
            Add (''); Add ('Gewhlte Signatur:');
            For i := 0 to slSig.Count-1 do Add ('  '+slSig[i])
         end;
         {$ENDIF}
         If Beschreibung = '' then begin
            Caption := 'Debuggen...';
            butRetry.free; butRetry := NIL;
            butSkip.free
         end else begin
            butWeiter.free; butNaechsteZeile.free
         end;
         If (Count>0) and (Lines[0]='') then Delete(0)
      end;
      With mText do begin
         tsText.caption := 'Datei: "'+Dateiname+'"';
         try Lines.text := Gesamttext except Lines.text := '<< Textdatei zu gro fr Memo >>' end
      end;
      {$ENDIF}
      Showmodal;
      Retry := AktRetry;
      Zeile2 := Skript.Zeile;
      {Case Retry of
         rJumpNextLineAndStop, rJumpNextLineAndRun: Inc(Zeile2);
      end;}
      FuelleSkript;
      Skript.Zeile := Zeile2
   finally
      free
   end;
   If Retry = rEndProgram then Halt
end end;

Function GetFirstElementOfKommaListe (Var s: String; Var Next: boolean): String;
Var p: Integer;
begin
   p := Pos(',', s);
   Next := (p>0);
   If Next then begin
      Result := Trim(Copy(s, 1, p-1)); s := Trim(Copy(s, p+1, Length(s)-p))
   end else begin
      Result := Trim(s); s := ''
   end
end;

Function MakeAdress (Const Name, Adresse: String): String;
Var Last, c: Char; ab, bis, i: Integer; bAnf: boolean;
begin
   Result := '';
   If (Name > '') and (Name <> Adresse) then begin
      ab := 1; bis := Length(Name);
      If (Name[1]='"') and (Name[Length(Name)]='"') then begin
         Inc(ab); Dec(bis)
      end;
      Last := ' '; bAnf := false;
      For i:=ab to bis do begin
         c := Name[i];
         If c IN['.', '"'] then bAnf := true;
         If (c = '"') and (Last <> '\') then Result := Result + '\';
         Result := Result + c; Last := c
      end;
      If Result > '' then begin
         If bAnf then Result := '"'+Result+'"';
         Result := Result + ' '
      end
   end;
   If Adresse > '' then begin
      If Adresse[1]<>'<' then Result := Result + '<';
      Result := Result + Adresse;
      If Adresse[Length(Adresse)]<>'>' then Result := Result + '>'
   end
end;

Procedure ExtractMailParts (Const Gesamt: String; Var Name, Vorname, Adresse: String);
Var p, i: Integer; s: String;
begin
   s := Trim(Gesamt);
   Adresse := ''; Name := ''; Vorname := '';
   If RegEx.MatchRS ('^.+@.+ (.+)$', s) then begin
      For i:=Length(s)-1 downto 1 do If s[i]='(' then begin
         Name := Trim(Copy(s, i+1, Length(s)-i-1));
         Adresse := Trim(Copy(s, 1, i-1))
      end
   end else If RegEx.MatchRS ('^.+ <.+@.+>$', s) then begin
      For i:=Length(s)-1 downto 1 do If s[i]='<' then begin
         Adresse := Copy(s, i+1, Length(s)-i-1);
         Name := Trim(Copy(s, 1, i-1))
      end
   end else If RegEx.MatchRS ('^<.+@.+>$', s) then begin
      Adresse := Copy(s, 2, Length(s)-2); Name := ''
   end else begin
      Adresse := s
   end;
   If Name > '' then begin
      Vorname := '';
      If (Name[1]='"') and (Name[Length(Name)]='"') then begin
         Name := Trim(Copy(Name, 2, Length(Name)-2))
      end;
      p := pos(',', Name);
      If p > 0 then Vorname := Trim(Copy(Name, p+1, Length(Name)-p))
      else begin
         p := pos(' ', Name);
         If p > 0 then Vorname := Trim(Copy(Name, 1, p-1))
      end
   end;
   If Adresse = '' then Adresse := s;
   If Name = '' then Name := Adresse;
   If Vorname = '' then Vorname := Adresse;
   {
   If Pos('"', s)>0 then begin
      p := Pos('"', s); p2 := Length(s)+1;
      For i:=p+1 to Length(s) do If s[i]='"' then p2 := i;
      Name := Copy(s, p+1, p2-p-1);
      s := Copy(s, 1, p-1) + Copy(s, p2+1, Length(s)-p2);
      p := pos('<', s); p2 := pos('>', s);
      If (p>0) and (p2>0) then begin
         Adresse := Copy(s, p+1, p2-p-1)
      end
   end else If Pos('(', s)>0 then begin
      p := pos('(', s); p2 := pos(')', s);
      If (p>0) and (p2>0) then begin
         Name := Copy(s, p+1, p2-p-1);
         Adresse := Trim ( Copy(s, 1, p-1) + Copy(s, p2+1, Length(s)-p2) )
      end
   end else If pos ('<', s)>0 then begin
      p := pos('<', s); p2 := pos('>', s);
      If (p>0) and (p2>0) then begin
         Adresse := Copy(s, p+1, p2-p-1);
         Name := Trim ( Copy(s, 1, p-1) + Copy(s, p2+1, Length(s)-p2) )
      end
   end;
   If Name = '' then Name := Gesamt;
   If Adresse = '' then Adresse := Gesamt;
   p := pos(' ', Name);
   If p>0
      then Vorname := Copy(Name, 1, p-1)
      else Vorname := Name
}
end;

Function Sonderzeichen_wandeln(Const s: String): String;
Var i: Integer; s2: String; b: boolean;
begin
   s2 := '';
   For i:=1 to Length(s) do begin
      b := (i<Length(s)) and (s[i+1] IN['A'..'Z']);
      Case s[i] of
         ' '..#127: s2 := s2 + s[i];
         '': s2 := s2 + 'ae';
         '': If b then s2 := s2 + 'AE' else s2 := s2 + 'Ae';
         '': s2 := s2 + 'oe';
         '': If b then s2 := s2 + 'OE' else s2 := s2 + 'Oe';
         '': s2 := s2 + 'ue';
         '': If b then s2 := s2 + 'UE' else s2 := s2 + 'Ue';
         '': If b then s2 := s2 + 'SS' else s2 := s2 + 'ss';
         '': s2 := s2 + ' Euro';
         '': s2 := s2 + 'Par.';
         '': s2 := s2 + '^2';
         '': s2 := s2 + '^3';
         '', '': s2 := s2 + '"';
         '': s2 := s2 + '''';
         else s2 := s2 + '?'
      end
   end;
   Result := s2
end;

Type TReplaceMode = (rmAll, rmFirst, rmLast);
     TReplaceWhere = (rwBody, rwSig, rwLines, rwHeader, rwHeader2, rwIntro, rwVar);

Procedure ReplaceInBody (Const Reg, Ersatz: String; Const Modus: TReplaceMode;
   Const Where: TReplaceWhere; Const VarName: String; Const AbZeile, BisZeile: Integer);
Var hl, htr: TStringlist;
    PerlRe: TPerlRe;

   Procedure Test (Const Org, Reg, Ersatz: String;
      Var Neu: String; Var Found: boolean);
   Var Anz, j, MaxAnz: Integer;
   begin
      Neu := ''; Found := false;
      If Modus = rmFirst then MaxAnz := 1 else MaxAnz := 0;
      PerlRe.Split2 (Reg, Org, Anz, hl, htr, MaxAnz, 'J', '');
      If Anz > 0 then begin
         Case Modus of
            rmAll:
               For j:=0 to hl.Count-1 do begin
                  If htr[j]>'' then Neu := Neu + Ersatz
                               else Neu := Neu + hl[j];
                  found := true
               end;
            rmFirst:
               For j:=0 to hl.Count-1 do begin
                  If (Not found) and (htr[j]>'') then begin
                     Neu := Neu + Ersatz; Found := true
                  end else Neu := Neu + hl[j]
               end;
            rmLast:
               For j:=hl.Count-1 downto 0 do begin
                  If (Not found) and (htr[j]>'') then begin
                     Neu := Ersatz + Neu; Found := true
                  end else Neu := hl[j] + Neu
               end;
         end
      end
   end;


Var i, LastPos: Integer; Neu, Ersatz2: String; found: boolean; Ziel: TStrings;
begin
   Ziel := NIL;
   Case Where of
      rwBody   : Ziel := Artikel.Body;
      rwSig    : {$IFNDEF CopyIF}
                  If ChangeSig then Ziel := slSig
                               else {$ENDIF} Ziel := Artikel.Sig;
      rwHeader : Ziel := Artikel.Header.sl;
      rwHeader2: Ziel := Artikel.Header2.sl;
      {$IFNDEF CopyIF}
      rwLines  : Ziel := slAppend;
      rwIntro  : Ziel := slIntro;
      {$ENDIF}
      rwVar    : ;
      else Fehler('Interner Fehler: Replace-Befehl fr Suchort #'+Inttostr(Ord(where))+' noch nicht definiert!', '')
   end;
   hl := TStringlist.Create;
   htr := TStringlist.Create;
   PerlRe := TPerlRe.Create(true, 0);
   LastPos := -1;
   Ersatz2 := EncodeBodyString(Ersatz);
   try
      If Where = rwVar then begin
         Test (GetVarValue(Varname), Reg, Ersatz, Neu, Found);
         If Found then SetVarValue(Varname, Neu)
      end else begin
         For i:=0 to Ziel.Count-1 do
            If (Ziel[i]>'') and ((AbZeile=-1) or (i+1 >= AbZeile)) and ((BisZeile=-1) or (i+1 <= BisZeile))
         then begin
            Test (Ziel[i], Reg, Ersatz, Neu, Found);
            If Found then begin
               Changed := true;
               If Modus = rmLast then begin LastPos := i; continue end;
               Ziel[i] := Neu; Changed := true;
               If Modus = rmFirst then break
            end
         end;
         If (Modus = rmLast) and (LastPos >= 0) then begin
            Ziel[LastPos] := Neu; Changed := true
         end
      end
   finally
      hl.free; htr.free; PerlRe.free
   end
         {Ersatz2 := ''; Token := false;
         For j:=1 to Length(Ersatz) do begin
            If Token then begin
               Case Ersatz[j] of
                  '1'..'9': begin
                     p := Ord(Ersatz[j])-ord('0');
                     try Ersatz2 := Ersatz2 + PerlRe.SubExp[p].text except end;
                  end;
                  '$': Ersatz2 := Ersatz2 + '$';
                  else Ersatz2 := Ersatz2 + Ersatz[j];
               end
            end
            else if Ersatz[j]='$' then Token := true
            else Ersatz2 := Ersatz2 + Ersatz[j]
         end;
         If Token then Ersatz2 := Ersatz2 + '$';}
end;

Function GetWord (Var s, Wort: String): boolean;
Var l, ls: Integer;
begin
   Result := false;
   s := Trim(s);
   If s > '' then begin
      If s[1] in Wortbestandteil then begin
         l := 1; ls := Length(s);
         While (l<ls) and (s[l+1] IN Wortbestandteil) do Inc(l);
         Wort := Copy(s, 1, l); s := Copy(s, l+1, ls-l);
         Result := true
      end
   end
end;

Function InterpreteWildCards (Const s: String): String;
Var p, q: Integer; flAnf, gef: boolean; s2, H, v: String; c: Char; W: String;
Const KlAuf = '('; KlZu = ')'; Anf = '"''';
begin
   s2 := s; Result := '';
   Repeat
      p := pos('%',s2); q := p; W := '';
      flAnf := false; gef := false;
      { Endekennzeichen suchen, Klammer und Stringausdrcke dabei berspringen... }
      If (p>0) and (Length(s2)>p) then Repeat
         Inc(q); c := s2[q];
         If flAnf then begin
            If (W > '') and (c = W[Length(W)]) then begin
               W := Copy(W, 1, Length(W)-1); flAnf := false
            end
         end else begin
            If Pos(c, Anf)>0 then begin W:=W+C; flAnf:=true end
            {else If Pos(c, KlAuf)>0 then W:=W+KlZu[Pos(c,KlAuf)]}
            else If c = KlAuf then W:=W + KlZu
            else If (Pos(c, KlZu)>0) and (W>'') and (c=W[Length(W)]) then W := Copy(W, 1, Length(W)-1)
         end;
         gef := (c='%') and (Not flAnf) and (W='')
      Until gef or (q = Length(s2));
      { Gefunden? }
      If (p>0) and gef then begin
         If p>1 then Result := Result + Copy(s2, 1, p-1);
         If q = p + 1 then begin
            Result := Result + '%'; Inc(q)
         end else begin
            H :=Copy(s2, p+1, q-p-1);
            If ExistVarName(H) then Result := Result + GetVarValue(h)
            else If GetString(H, v) then Result := Result + v
            else Fehler('"%'+H+'%" ist weder ein gltiger Stringbefehl noch eine existente Variable, '
                       +'sollte der entsprechende Header gemeint sein, dann bitte "%Header('+H+')%" verwenden.', s);
         end;
         s2 := Copy(s2, q+1, Length(s2)-q)
      end else begin
         Result := Result + s2; s2 := ''
      end
   Until s2 = ''
end;

Function Tested (Const s: String; Const TestQP, TestWildCards: boolean): String;
begin
   Result := s;
   If s > '' then begin
      If TestWildCards then Result := InterpreteWildCards(Result);
      If TestQP and Artikel.qp then Result := ConvertToQP(Result) else Only7BitTested := false
   end
end;

Function LoescheZwischen (Const Erstem: boolean; Const Such1, Such2: String;
    Const DelSuch, SetzeErsatztext: boolean; Const Ersatz: String): boolean;

   Function Found (sl: TStrings): boolean;
   Var M: Byte; i, p1, p2: Integer; s: String;
   begin
      p1 := 0; p2 := 0; M := 0;

      If Erstem then begin
         If Such1 = '' then begin M := 1; p1 := -1 end;
         For i:=0 to sl.Count-1 do begin
            s := sl[i];
            Case M of
               0: If RegEx.MatchRS (Such1, s) then begin p1 := i; Inc(M) end;
               1: If RegEx.MatchRS (Such2, s) then begin p2 := i; Inc(M); break end;
            end
         end
      end else begin
         If Such2 = '' then begin M := 1; p2 := sl.Count end;
         For i:=sl.Count-1 downto 0 do begin
            s := sl[i];
            Case M of
               0: If RegEx.MatchRS (Such2, s) then begin p2 := i; Inc(M) end;
               1: If RegEx.MatchRS (Such1, s) then begin p1 := i; Inc(M); break end;
            end
         end
      end;

      Result := (M = 2);
      If Result then begin
         For i:=1 to p2-p1-1 do sl.Delete(p1+1);
         If DelSuch then begin
            If Such1 > '' then sl.Delete(p1) else p1 := 0;
            If Such2 > '' then sl.Delete(p1)
         end;
         If SetzeErsatztext and (Ersatz>'') then begin
            If (Not DelSuch) then Inc(p1);
            sl.Insert(p1, Tested(Ersatz, true, true))
         end
      end
   end;

begin
   Result := true;
   If Not Found (Artikel.Sig)
      then If Not Found(Artikel.Body)
         then Result := false
end;


{$IFNDEF CopyIf}
Function TestHasSig: boolean;
begin
   Result := Artikel.HasSig or (slSig.Count>0)
end;
{$ENDIF}

Type TVerglTyp = (vtNix, vtLike, vtGleich, vtUngleich, vtBeginnt, vtEndet, vtEnthaelt, vtIn, vtIstLeer,
                  vtKleiner, vtGroesser, vtGroesserGleich, vtKleinerGleich);
     TVerknuepfungsTyp = (vtFirst, vtOr, vtXor, vtAnd);

Function TestBedingung(Var s: String): boolean;
Var s2, s3, s4: String; x1, x2: Double;
    vt: TVergltyp; Verknuepfung: TVerknuepfungstyp;
    Dreher, First, AktResult, PreResult, ok: boolean;
begin
   PreResult := true;
   First := true;
   s := Trim(s);

   While s > '' do begin

      Verknuepfung := vtFirst;
      If Not First then begin
         If SucheUndKuerze('or', s) then Verknuepfung := vtOr
         else If SucheUndKuerze('and', s) then Verknuepfung := vtAnd
         else If SucheUndKuerze('xor', s) then Verknuepfung := vtXor
         else break
      end;

      Dreher := false;
      While SucheUndKuerze('not', s) do Dreher := Not Dreher;

      AktResult := false;
      If Klammerung(s, s2, true) then begin
         AktResult := TestBedingung(s2);
         If s2 > '' then Fehler ('Keine zulssige Verknpfung in Bedingung: "'+s2+'", nur '
            +' "Not", "or", "and" und "xor" sind erlaubt.', s)
      end
      {$IFDEF CopyIf}
      {$ELSE}
      else If SucheUndKuerze('HasSignature', s) or SucheUndKuerze('HasSig', s) then begin
         AktResult := TestHasSig
      end
      else If SucheUndKuerze('Has8BitChars', s) then begin
         AktResult := Not TestOnly7Bit
      end
      else If SucheUndKuerze('ChangedLines', s) then begin
         AktResult := slAppend.Count > 0
      end
      else If SucheUndKuerze('ChangedSignature', s) or SucheUndKuerze('ChangedSig', s) then begin
         AktResult := ChangeSig
      end
      {$ENDIF}
      else If SucheUndKuerze('StrToBool', s) then begin
         If (Klammerung(s, s2, true) and GetString(s2, s3) and (s2=''))
            or GetString(s, s3)
         then begin
            IF (s3 = '') or (s3 = '0') or (LowerCase(s3) = 'false') or (LowerCase(s3) = 'falsch')
                 or (LowerCase(s3) = 'no')  or (LowerCase(s3) = 'nein')
            then AktResult := false
            else If (s3 = '1') or (LowerCase(s3) = 'true') or (LowerCase(s3) = 'wahr')
                 or (LowerCase(s3) = 'yes')  or (LowerCase(s3) = 'ja')
            then AktResult := true
            else Fehler('Der String "'+s3+'" kann nicht in einen boolschen Ausdruck konvertiert werden', s)
         end else Fehler('Nach StrToBool mu ein gltiger String-Ausdruck folgen!', s);
      end
      else If SucheUndKuerze('true', s) then begin
         AktResult := true
      end
      else If SucheUndKuerze('false', s) then begin
         AktResult := false
      end
      else If SucheUndKuerze('Ask', s) then begin
         ok := false;
         s4 := Titel;
         If Klammerung(s, s2, true) and GetString(s2, s3)
            and ((Trim(s2) = '') or (SucheUndKuerze(',', s2) and GetString(s2, s4)))
         then begin
            ok := true;
            If (Bed[Level-1] and Bed[Level])
               then AktResult := Messagebox (0, PChar(s3), PChar(s4), MB_ICONQUESTION + MB_YESNO) = IDYES
               else AktResult := false
         end;
         If Not ok then Fehler('Falsche Syntax, die Syntax fr Ask lautet: "Ask ( Text [, berschrift] )"', s)
      end
      else If SucheUndKuerze('Abort', s) then begin
         ok := false;
         s4 := Titel;
         If Klammerung(s, s2, true) and GetString(s2, s3)
            and ((Trim(s2) = '') or (SucheUndKuerze(',', s2) and GetString(s2, s4)))
         then begin
            ok := true;
            If (Bed[Level-1] and Bed[Level])
               then AktResult := Messagebox (0, PChar(s3), PChar(s4), MB_ICONSTOP + MB_OKCANCEL + MB_DEFBUTTON2) = IDCANCEL
               else AktResult := false
         end;
         If Not ok then Fehler('Falsche Syntax, die Syntax fr Abort lautet: "Abort ( Text [, berschrift] )"', s)
      end
      else If SucheUndKuerze('ChangedIntroduction', s) or SucheUndKuerze('ChangedIntro', s) then begin
         AktResult := slIntro.Count > 0
      end
      else If SucheUndKuerze('Changed', s) then begin
         AktResult := Changed or (slIntro.Count > 0)
      end
      else If SucheUndKuerze('VarExists', s) then begin
         ok := false;
         If Klammerung (s, s2, true) then begin
            Case GetVarName (s2, s3) of
               vnNew: AktResult := false;
               vnExist: AktResult := true;
               else Fehler ('"'+s2+'" ist kein zulssiger Variablenname', s)
            end;
            ok := Trim(s2) = ''
         end;
         If Not ok then Fehler ('Syntaxfehler, korrekt wre "VarExists (%Variablenname%)"', s)
      end
      else begin
         { Stringvergleich? }
         If GetString(s, s2) then begin
            vt := vtNix;
            If SucheUndKuerze('not', s) then Dreher := Not Dreher;
            { Vergleichstyp }
            If SucheUndKuerze('contains', s) then vt := vtEnthaelt
            else If SucheUndKuerze('>=', s) then vt := vtGroesserGleich
            else If SucheUndKuerze('<=', s) then vt := vtKleinerGleich
            else If SucheUndKuerze('equals', s) or SucheUndKuerze('=', s) then vt := vtGleich
            else If SucheUndKuerze('<>', s) then vt := vtUnGleich
            else If SucheUndKuerze('like', s) or SucheUndKuerze('matches', s) then vt := vtLike
            else If SucheUndKuerze('begins with', s) then vt := vtBeginnt
            else If SucheUndKuerze('ends with', s) then vt := vtEndet
            else If SucheUndKuerze('is empty', s) then vt := vtIstLeer
            else If SucheUndKuerze('in', s) then vt := vtIn
            else If SucheUndKuerze('less than', s) or SucheUndKuerze('<', s) then vt := vtKleiner
            else If SucheUndKuerze('greater than', s) or SucheUndKuerze('>', s) then vt := vtGroesser
            else Fehler('Unbekannte Vergleichsoperation "'+s+'", untersttzt werden nur '
                +'"contains", "equals"/"=", "<>", "like"/"matches", "begins with", '
                +'"ends with", "is empty", "in", "less than"/"<", "greater than"/">", '
                +'">=" und "<="', s);
            { Vergleich }
            If vt = vtIstLeer then AktResult := s2 = ''
            else begin
               If GetString(s, s3) then begin
                  Case vt of
                     vtGleich: AktResult := s2 = s3;
                     vtUngleich: AktResult := s2 <> s3;
                     vtBeginnt: AktResult := Copy(s2, 1, Length(s3)) = s3;
                     vtLike: AktResult := TestRegExp (s3, s2);
                     vtEndet: AktResult := Copy(s2, Length(s2)-Length(s3)+1,Length(s3)) = s3;
                     vtEnthaelt: AktResult := pos(s3, s2)>0;
                     vtIn: AktResult := pos(s2, s3)>0;
                     vtKleiner: AktResult := s2 < s3;
                     vtGroesser: AktResult := s2 > s3;
                     vtGroesserGleich: AktResult := s2 >= s3;
                     vtKleinerGleich: AktResult := s2 <= s3;
                     else Fehler('Interner Fehler, Vergleichsoperation #'+Inttostr(ord(vt))+' ist nicht programmiert', s)
                  end
               end else Fehler ('Vergleichsausdruck "'+s+'" fehlt bzw. mu mit ''"'' geklammert werden', s)
            end
         end else
         { Numerischer Vergleich? }
         If GetNumber(s, x1) then begin
            vt := vtNix;
            { Vergleichstyp }
            If SucheUndKuerze('=', s) then vt := vtGleich
            else If SucheUndKuerze('<>', s) then vt := vtUnGleich
            else If SucheUndKuerze('<', s) then vt := vtKleiner
            else If SucheUndKuerze('>', s) then vt := vtGroesser
            else If SucheUndKuerze('>=', s) then vt := vtGroesserGleich
            else If SucheUndKuerze('<=', s) then vt := vtKleinerGleich
            else Fehler('Unbekannte numerische Vergleichsoperation "'+s+'", untersttzt werden nur '
                +'"=", "<>", "<", ">", "<=", ">="', s);
            { Vergleich }
            If vt = vtIstLeer then AktResult := x1 <> 0
            else begin
               If GetNumber(s, x2) then begin
                  Case vt of
                     vtGleich: AktResult := x1 = x2;
                     vtUngleich: AktResult := x1 <> x2;
                     vtKleiner: AktResult := x1 < x2;
                     vtGroesser: AktResult := x1 > x2;
                     vtGroesserGleich: AktResult := x1 <= x2;
                     vtKleinerGleich: AktResult := x1 >= x2;
                     else Fehler('Interner Fehler, Vergleichsoperation #'+Inttostr(ord(vt))+' ist nicht programmiert', s)
                  end
               end else Fehler ('Vergleichswert fehlt!', s)
            end
         end else Fehler('Unbekannter Vergleichsausdruck "'+s+'"', s)
      end;
      If Dreher then AktResult := Not AktResult;

      Case Verknuepfung of
         vtFirst : PreResult := AktResult;
         vtOr    : PreResult := PreResult Or AktResult;
         vtXor   : PreResult := PreResult xor AktResult;
         vtAnd   : PreResult := PreResult and AktResult
      end;
      First := false
   end;
   Result := PreResult
end;

Type TStrTyp = (stHeader, stFull, stFirst, stLast, stDecodeISO, st8BitTo7Bit,
                stMakeAdresse, stMailAdr, stVorname, stName, stBoolVal,
                stBodyline, stInput, stReadIni, stVersion, stLine
               {$IFDEF CopyIf} {$ELSE}
                ,stBodyHeader, stFilePath, stFileName
               {$ENDIF} );
     TStrDef = Record Bez: String; Args: String; Simple: boolean end;

Const StrFuncs: Array[TStrTyp] of TStrDef
       = (
           ( Bez: 'Header'; Args: cStr; Simple: true ),
           ( Bez: 'Full'; Args: ''; Simple: false ),
           ( Bez: 'First'; Args: cStr; Simple: false ),
           ( Bez: 'Last'; Args: cStr; Simple: false ),
           ( Bez: 'DecodeISO'; Args: cStr; Simple: false ),
           ( Bez: '8BitTo7Bit'; Args: cStr; Simple: false ),
           ( Bez: 'MakeAdress'; Args: cStr+cStr; Simple: false ),
           ( Bez: 'Adress'; Args: cStr; Simple: false ),
           ( Bez: 'FirstName'; Args: cStr; Simple: false ),
           ( Bez: 'Name'; Args: cStr; Simple: false ),
           ( Bez: 'BoolToStr'; Args: cOwn; Simple: false ),
           ( Bez: 'Bodyline'; Args: cNum; Simple: false ),
           ( Bez: 'Input'; Args: cStr+cStr+cStr; Simple: false ),
           ( Bez: 'ReadIniStr'; Args: cStr+cStr+cStr+cStr; Simple: false ),
           ( Bez: 'Version'; Args: ''; Simple: false ),
           ( Bez: 'Line'; Args: cNum+cStr; Simple: false )
           {$IFDEF CopyIf}
           {$ELSE} ,
           ( Bez: 'BodyHeader'; Args: cStr; Simple: true ),
           ( Bez: 'Path'; Args: ''; Simple: false ),
           ( Bez: 'Filename'; Args: ''; Simple: false )
           {$ENDIF}
         );

Function ZusatzStringFunktionen (Var Pars: TStrParameter): String;
Var p: Integer; s1, s2, s3: String; c: Char;
    Raw: boolean;
begin
   With Pars do begin
      Case TStrTyp(Typ) of
         stHeader: Result := Artikel.Header.Inhalt(Trim(Strs[1]), hiOriginal);
         {$IFNDEF CopyIf}
         stBodyHeader: Result := slBodyHeader.Inhalt (Trim(Strs[1]), hiOriginal);
         stFileName: Result := ExtractFileName(Dateiname);
         stFilePath: Result := Opt.WorkPath;
         {$ENDIF}
         stFull: begin
            Raw := SucheUndKuerze('raw', Rest);
            If SucheUndKuerze('Header', Rest) then begin
               Result := Artikel.Header.Text;
               If SucheUndKuerze('without', Rest) then Repeat
                  If GetWord (Rest, s2) then begin
                     s2 := ToHeader(s2) + Artikel.Header.Inhalt(s2, hiOriginal);
                     p := pos(s2, Result);
                     If p>0 then Result := Copy(Result, 1, p-1) + Copy(Result, p+Length(s2)+2, Length(Result))
                  end else break
               Until Not SucheUndKuerze(',', Rest);
               If Not raw then Result := DecodeISO (Result)
            end else
            If SucheUndKuerze('Body', Rest) then begin
               Result := Artikel.Body.Text;
               If not raw and Artikel.qp then Result := DecodeQPString(Result, false)
            end else
            If SucheUndKuerze('Sig', Rest) or SucheUndKuerze('Signature', Rest)then begin
               Result := Artikel.Sig.Text;
               If not raw and Artikel.qp then Result := DecodeQPString(Result, false)
            end else
            If SucheUndKuerze('Intro', Rest) or SucheUndKuerze('Introduction', Rest)then begin
               Result := slIntro.Text;
               If Artikel.qp then Result := DecodeQPString(Result, false)
            end else
            If SucheUndKuerze('Article', Rest) or SucheUndKuerze('Posting', Rest)
               or SucheUndKuerze('Mail', Rest)
            then begin
               Result := Artikel.Gesamttext
            end else
            Fehler ('Ein Stringbefehl "Full '+Rest+'" ist nicht zulssig, nur "Full [raw] Body", '
                  +'"Full [raw] Header", "Full [raw] Sig[nature]" und "Full Posting/Article/Mail" '
                  +'sind erlaubt', Rest)
         end;
         stFirst, stLast: begin
            Result := Strs[1];
            If ((Result+' ')[1]='<') and (Result[Length(Result)]='>') then begin
               If TStrTyp(Typ)=stFirst then c:='>' else c:='<'
            end else c:=',';
            p := Pos(c, Result);
            If p > 0 then Case TStrTyp(Typ) of
              stFirst: Result := Copy(Result, 1, p-1);
              stLast: Repeat
                 Result := Copy(Result, p+1, length(Result)-p);
                 p := Pos(c, Result)
              Until p=0
            end;
            If c='>' then Result := Result + '>'
            else If c='<' then Result := '<' + Result;
         end;
         stDecodeISO: begin
            Result := DecodeISO (Strs[1]);
            Repeat
               p := Pos(#13#10' ', Result);
               If p=0 then p := Pos(#13#10#9, Result);
               If p>0 then Delete(Result, p, 3);
            Until p = 0
         end;
         st8BitTo7Bit: Result := Sonderzeichen_wandeln(Strs[1]);
         stMakeAdresse: Result := MakeAdress(Strs[1], Strs[2]);
         stMailAdr, stVorname, stName: begin
            ExtractMailParts (Strs[1], s1, s2, s3);
            Case TStrTyp(Typ) of
               stName: Result := s1;
               stVorname: Result := s2;
               stMailAdr: Result := s3;
            end
         end;
         stBoolVal: If TestBedingung(Rest) then Result := '1' else Result := '0';
         stBodyLine: begin
            p := Trunc(Nums[1]);
            If p IN[1..Artikel.Body.Count]
               then Result := DecodeBodyString(Artikel.Body[p-1])
               else Result := ''
         end;
         stLine: begin
            p := Trunc(Nums[1]);
            With TStringlist.Create do try
               Text := Strs[1];
               if (p>0) and (p<=Count) then Result := Strings[p-1] else Result := ''
            finally free end
         end;
         stInput: begin
            If Strs[1] = '' then Strs[1] := Titel;
            If Strs[2] = '' then Strs[2] := 'Bitte eingeben:';
            {$IFNDEF NOGUI}
            Result := InputBox (Strs[1], Strs[2], Strs[3])
            {$ELSE}
            MessageBox (0, PChar('Die Funktion InputBox steht in "'+ExtractFileName(ParamStr(0))+'" nicht zur Verfgung!'),
                           NIL, MB_ICONERROR );
            {$ENDIF}
         end;
         stReadIni: With TIniFile.Create(Strs[1]) do try Result := ReadString(Strs[2], Strs[3], Strs[4]) finally free end;
         stVersion: Result := Ver;
      end
   end
end;

Procedure RegZusatzStringFunktionen;
Var i: TStrTyp;
begin
   For i := Low(TStrTyp) to High(TStrTyp) do With StrFuncs[i] do
      Register_StrFunktion (Bez, Args, Simple, ZusatzStringFunktionen, Ord(i))
end;

Function NextMatchedLine (Const ab: Integer; Const Reg: String): Integer;
Var i: Integer; s: String;
begin
   Result := -1;
   For i:=ab to Artikel.Body.Count-1 do begin
      If i < 0 then Continue;
      s := DecodeBodyString(Artikel.Body[i]);
      If s>'' then IF Regex.MatchRS (Reg, s) then begin Result := i; BREAK end
   end
end;

Function CountMachedLines (Const Reg: String): Integer;
Var i: Integer; s: String;
begin
   Result := 0;
   For i:=0 to Artikel.Body.Count-1 do begin
      s := DecodeBodyString(Artikel.Body[i]);
      If s>'' then IF Regex.MatchRS (Reg, s) then Inc(Result)
   end
end;

Type TNumTyp = (fMatchedLines, fBodylines, fIntrolines, fSiglines, fHeaderlines,
                fCountLines, fNextMatchedLine);

Function ZusatzNumerischeFunktionen (Var Pars: TNumParameter): Double;
begin
   Result := 0;
   With Pars do begin
      Case TNumTyp(Typ) of
         fMatchedLines: Result := CountMachedLines (Strs[1]);
         fBodylines: Result := Artikel.Body.Count;
         fIntrolines: Result := slIntro.Count;
         fSiglines: {$IFNDEF CopyIF}
                If ChangeSig then Result := slSig.Count
                             else {$ENDIF} Result := Artikel.Sig.Count;
         fHeaderlines: Result := Artikel.Header.Count;
         fCountLines:
            With TStringlist.Create do try
               Text := Strs[1]; Result := Count
            finally free end;
         fNextMatchedLine: Result := NextMatchedLine(Trunc(Nums[1])-1, Strs[1])+1
      end
   end
end;

Procedure RegZusatzNumerischeFunktionen;
begin
   Register_NumFunktion ('MatchedLines', cStr, ZusatzNumerischeFunktionen, Ord(fMatchedLines));
   Register_NumFunktion ('Bodylines', '', ZusatzNumerischeFunktionen, Ord(fBodyLines));
   Register_NumFunktion ('CountLines', cStr, ZusatzNumerischeFunktionen, Ord(fCountLines));
   Register_NumFunktion ('IntroLines', '', ZusatzNumerischeFunktionen, Ord(fIntrolines));
   Register_NumFunktion ('SigLines', '', ZusatzNumerischeFunktionen, Ord(fSigLines));
   Register_NumFunktion ('Headerlines', '', ZusatzNumerischeFunktionen, Ord(fHeaderlines));
   Register_NumFunktion ('NextMatchedLine', cNum+cStr, ZusatzNumerischeFunktionen, Ord(fNextMatchedLine));
end;

{ ======================================================================= }
{                      Headerhilfsfunktionen                              }

Procedure Headerzeile_anhaengen (Const s: String);
begin
   Artikel.Header.Add (HeaderMIMEKodierung(s));
   Changed := true
end;

Function Split_Headerzeile (Const Ges: String; Var Header, Inhalt: String): boolean;
Var p, q: Integer; s: String;
begin
   Result := false; s := Ges;
   If (s='') or (s[1]=' ') then exit;
   p := Pos(':', s); q := Pos('=', s);
   If (p=0) and (q>0) then p:=q;
   While (p>2) and (s[p-1] IN HeaderCont) do begin
      s := Copy(s, 1, p-2) + Copy(s, p, Length(s)-p+1); Dec(p)
   end;
   If (p > 1) then begin
      Header := Copy (s, 1, p-1);
      If (Length(s)>p) and (s[p+1]<>' ')
         then Inhalt := Copy(s, p+1, Length(s)-p)
         else Inhalt := Copy(s, p+2, Length(s)-p-1);
      Result := true
   end
end;

Procedure TestHeader (Const s: String);
Var i: Integer;
begin
   If slSonderheader.IndexOf(s) >= 0 then exit;
   For i:=1 to Length(s) do begin
      If Not (s[i] IN Headerzeichen) then Fehler('Unzulssiges Zeichen "'+s[i]+'" in Headerbezeichnung!'
         + ' (Falls fr lokale Zwecke (Hamster) ntig, mu der Header "'+s+'" in ''lheader.txt'' aufgefhrt werden.)', s)
   end
end;

Procedure ExpandiereMakro (Const Vergleich: String; slErsatz: TStringlist);
Var i, j: Integer;
begin
   With Artikel.Body do For i:=Count-1 downto 0 do If Strings[i] = Vergleich then begin
      changed := true;
      Delete(i);
      For j := slErsatz.Count-1 downto 0 do Insert(i, slErsatz[j])
   end
end;

{ ======================================================================= }

{$IFDEF CopyIF}
Procedure ConvertQPHeader;
Var ConvertHeaders, s, s2: String; p, i: Integer;
begin
   If Artikel.Header.Position (Extraheader_ConvertHeader) >= 0 then exit;
   ConvertHeaders := '';
   With Artikel do begin
      For i:=Header.Count-1 downto 0 do begin
         s := Header[i];
         s2 := DecodeISO (s);
         If s <> s2 then begin
            Repeat
               p := Pos(#13#10' ', s2);
               If p = 0 then p := Pos(#13#10^I, s2);
               If p > 0 then Delete(s2, p, 3)
            Until p = 0;
            Header[i] := s2;
            If ConvertHeaders > '' then ConvertHeaders := ConvertHeaders + ', ';
            ConvertHeaders := ConvertHeaders + Header.Name[i] 
         end
      end
   end;
   If ConvertHeaders > '' then begin
      Headerzeile_anhaengen (Extraheader_ConvertHeader + ConvertHeaders);
      Changed := true
   end;
end;
{$ENDIF}

{$IFDEF CopyIf}
Procedure Check_ConvertOEBeginBug;

   Function Test (sl: TStrings): boolean;
   Var i: Integer; s: String;
   begin
      Result := false;
      For i := 0 to sl.Count-1 do begin
         s := sl[i];
         If (Length(s)>7) and (Copy(s,1,7)='begin  ') then begin
            If s[8] IN['A'..'Z', 'a'..'z', '0'..'9'] then begin
               Delete(s, 6, 1); sl[i] := s; Result := true
            end
         end
      end
   end;

Var b: boolean;   
begin
   b := false;
   If Test (Artikel.Body) then b := true;
   If Test (Artikel.Sig) then b := true;
   If b then begin
      Changed := true;
      Headerzeile_anhaengen (Extraheader_OEBeginBug)
   end
end;
{$ENDIF}

{$IFDEF CopyIf}
Procedure Check_ConvertOEKillFalseReBug;
Var Org, s: String; i, p: Integer; b: boolean;
begin
   Org := Artikel.Header.Inhalt (HeaderSubject, hiOriginal);
   If (Org > '') and (Artikel.Header.Position(HeaderReferences)<0) then begin
      s := DecodeISO (Org); p := Pos(':', s);
      If (p>0) and (p<4) and (Lowercase(Copy(s, 1, 3))<>'re:') then begin
         b := true;
         For i:=1 to p-1 do
            If Not (s[i] IN ['A'..'Z', 'a'..'z']) then begin b := false; break end;
         If b then begin
            Artikel.Header.Change (HeaderSubject, 'XX: '+Org);
            Headerzeile_anhaengen (Extraheader_OEKillFalseReBug);
            Changed := true
         end
      end
   end
end;
{$ENDIF}

{$IFNDEF CopyIf}
Procedure ChooseSig (Const Sigs: TStrings; Const Def: Integer);
Var i, j, Nr, Anz: Integer;
begin
   With Sigs do If Count > 0 then begin
      Anz := 0;
      If Trim(Strings[0])<>'--' then Insert(0, '--');
      For i:=0 to Count-1 do begin
         If Trim(Strings[i])='--' then Inc(Anz)
      end;
      If Def < 1 then Nr := Random(Anz) else Nr := Def-1;
      Anz := 0;
      For i:=0 to Count-1 do If Trim(Strings[i])='--' then begin
         Inc(Anz);
         If Anz > Nr then begin
            For j := 0 to i do Delete(0);
            break
         end
      end;
      For i:=0 to Count-1 do If Trim(Strings[i])='--' then begin
         While Count > i do Delete(i);
         break
      end;
      While (Count>0) and (Trim(Strings[Count-1])='') do Delete(Count-1)
   end
end;
{$ENDIF}

Procedure BoxQuote (Const Titel: String; Const Def: TCfgBoxQuotes; sl: TStrings);
Var l, i, j, p, x, br: Integer; s, TitelLinks, TitelRechts: String; bTitel: Boolean;
begin
   bTitel := Titel > '';
   With Def do begin
      TitelLinks := Titelumrandung;
      i := Pos('@', Titelumrandung);
      If i = 0 then begin
         br := Length(Titelumrandung) div 2;
         Titellinks := Copy(Titelumrandung, 1, br);
         TitelRechts := Copy(Titelumrandung, Length(Titelumrandung) - br + 1, br)
      end else begin
         Titellinks := Copy(Titelumrandung, 1, i-1);
         TitelRechts := Copy(Titelumrandung, i+1, Length(Titelumrandung)-i)
      end;
      If Not Nutzbar then exit;
      If bTitel then br := Length(TitelLinks+Titel+TitelRechts) + 2 else br := 10;
      For i := 1 to sl.Count-2 do begin
         x := Length(sl[i])+2;
         If x>br then br := x;
      end;
      If (Length(Titel) Mod 2) <> (Br Mod 2) then Inc(Br);
      s := ObereLinkeEcke; x := 0;
      Case Typ of
         bqSimple: begin
            s := s + StringOfChar(Oben, ZeilenbreiteOben);
            If bTitel then s := s + TitelLinks + Titel + TitelRechts
         end;
         bqOpened: begin
            x := (br - Length(Titel)) Div 2;
            s := s + StringOfChar(Oben, br);
            If (Length(Titel) Mod 2) <> (Br Mod 2) then Inc(Br)
         end;
         bqClosed: begin
            x := (br - Length(Titel)) Div 2;
            s := s + StringOfChar(Oben, br) + ObereRechteEcke;
         end
      end;
      If bTitel and (x>0) then begin
         For i := 1 to Length(Titel) do s[x+i+Length(ObereLinkeEcke)] := Titel[i];
         For i := 1 to Length(TitelLinks) do s[x+Length(ObereLinkeEcke)+i-Length(TitelLinks)] := TitelLinks[i];
         For i := 1 to Length(TitelRechts) do s[x+Length(Titel)+Length(ObereLinkeEcke)+i] := TitelRechts[i]
      end;
      sl[0] := s;
      For i:=1 to sl.Count-2 do Case Typ of
         bqSimple, bqOpened: sl[i] := LinkerRand + ' '+sl[i];
         bqClosed: begin
            s := LinkerRand + ' ' + sl[i];
            Repeat
               p := Pos(#9, s);
               If p > 0 then begin
                  s[p] := ' '; For j := p+1 to ((p Div 8)+1)*8 do Insert(' ', s, p)
               end
            Until p = 0;
            L := Length(s) - Length(LinkerRand) - 1;
            While L < br-1 do begin s := s + ' '; Inc(L) end;
            sl[i] := s + RechterRand
         end
      end;
      Case Typ of
         bqSimple: s := UntereLinkeEcke + StringOfChar(Unten, ZeilenbreiteUnten);
         bqOpened: s := UntereLinkeEcke + StringOfChar(Unten, br);
         bqClosed: s := UntereLinkeEcke + StringOfChar(Unten, br) + UntereRechteEcke;
      end;
      sl[sl.Count-1] := s;
   end
end;

Procedure ConvertBoxQuotes (Const Nr: Integer);
Var M: Byte; i, P1, P2, Zeile: Integer;
    s: String; bTitel: Boolean; Titel: String; slTemp: TStringlist;
begin
   M := 0; P1 := 0;
   bTitel := false;
   With BQ[Nr] do begin
      If Not Nutzbar then exit;
      Zeile := 0;
      While Zeile <= Artikel.Body.Count-1 do begin
         s := DecodeBodyString(Artikel.Body[Zeile]); Inc(Zeile);
         If bDatei then begin
            If Copy(s, 1, Length(Anfangszeile)) = Anfangszeile then begin
               slTemp := TStringlist.Create;
               s := Trim(Copy(s, length(Anfangszeile)+1, Length(s)));
               If FileExists(s) then begin
                  LoadTextfile (s, slTemp);
                  slTemp.Insert(0, ''); slTemp.Add ('');
                  BoxQuote (s, BQ[Nr], slTemp);
                  Dec (Zeile); Artikel.Body.Delete(Zeile);
                  For i:=0 to slTemp.Count-1 do begin
                     Artikel.Body.Insert (Zeile+i, EncodeBodyString(slTemp[i]));
                  end;
                  Inc (Zeile, slTemp.Count)
               end else begin
                  Fehler ('Die als BoxQuote anzuzeigende Datei "'+s+'" existiert nicht!', '')
               end
            end
         end else begin
            If s = Anfangszeile then begin M := 1; P1 := Zeile-1; bTitel := false end
            else If (s = Trennzeile) and (M=1) and (Zeile-1-P1=2) then begin Inc(M); bTitel := true end
            else If (s = Endzeile) and (M>0) then begin
               M := 0; p2 := Zeile-1;
               If bTitel then begin
                  Titel := Artikel.Body[P1+1];
                  Artikel.Body.Delete(P1+2); Artikel.Body.Delete(P1+1);
                  Dec(P2, 2); Dec (Zeile, 2)
               end else begin
                  Titel := ''
               end;
               slTemp := TStringlist.Create;
               try
                  For i:=P1 to P2 do slTemp.Add (DecodeBodyString(Artikel.Body[i]));
                  BoxQuote (Titel, BQ[Nr], slTemp);
                  For i:=P1 to P2 do Artikel.Body[i] := EncodeBodyString(slTemp[i-P1])
               finally slTemp.free end;
               changed := true
            end
         end
      end
   end
end;

{$IFDEF CopyIf}
{$ELSE}
Procedure Check_Headeranalyse;
Var i, j, L, p, q: Integer; b: boolean;
    s, s2, s3, s4, AktHeader, AktInhalt: String;
begin
   FalscheMessageID := '';

   { ----------- Headertest ------------ }

   With Artikel.Header do For i := 0 to Count-1 do begin
      s := Strings[i]; s2 := LowerCase(s); AktHeader := LowerCase(Name[i])+': ';
      If AktHeader = HeaderReferences then begin
         { Message-ID korrigieren? }
         If Opt.lKillMessageIDBegins.Count>0 then begin
            p := 0;
            For j:= 1 to Length(s) do If s[j] = '<' then p := j+1;
            If p > 0 then begin
               For j:=0 to Opt.lKillMessageIDBegins.Count-1 do begin
                  s3 := Opt.lKillMessageIDBegins[j];
                  If s3 = Copy(s, p, Length(s3)) then begin
                     Changed := true;
                     s := Copy(s, 1, p-1) + Copy(s, p+Length(s3), Length(s));
                     Strings[i] := s;
                     break
                  end
               end
            end
         end;
         { Message-ID zu lang? }
         If Opt.MaxReferencesLen>0 then begin
            s3 := Strings[i];
            With TStringlist.Create do try
               Repeat
                  p := Pos('<', s3);
                  If p>0 then begin
                     If p>1 then s3 := Copy(s3, p, Length(s3)-p+1);
                     p := Pos('>', s3);
                     If p>0 then begin
                        Add(Copy(s3, 1, p));
                        s3 := Copy(s3, p+1, Length(s3)-p)
                     end
                  end
               Until p=0;
               L := Count-1;
               For j:=0 to Count-1 do L := L + Length(Strings[j]);
               If (L>Opt.MaxReferencesLen) and (Count>4) then begin
                  { zwischen erstem und drittletzten Eintrag krzen, von vorne beginnen }
                  For j:=1 to Count-3-1 do If L>Opt.MaxReferencesLen then begin
                     Dec(L, Length(Strings[1])+1); Delete(1)
                  end;
                  { Krzung wegschreiben }
                  s := Copy(s, 1, Length(HeaderReferences)) + Strings[0];
                  For j:=1 to Count-1 do s := s + ' '+Strings[j]
               end
            finally free end;
            If s <> Strings[i] then begin
               Strings[i] := s; Changed := true
            end
         end;
         { References falten? }
         If Opt.FoldingReferences then begin
            s3 := Strings[i]; s := '';
            Repeat
               If (Length(s3)>MaxISOHeaderLen) and (Pos(#13#10, s3)=0) then begin
                  p := 0;
                  For q := Pos('>', s3)+1 to Length(s3) do
                     If (s3[q]='<') and ((p=0) or (q-2<MaxISOHeaderLen)) then p := q;
                  If p>0 then begin
                     s := s + Copy(s3, 1, p-2) + #13#10;
                     s3 := '    '+Trim(Copy(s3, p, Length(s3)-p+1));
                     Changed := true
                  end;
               end else p := 0
            Until p = 0;
            s := s + s3;
            Strings[i] := s
         end
      end else begin
         { Irgendein Header... }
         If Opt.CheckMIMEHeaders then begin
            p := pos(#13#10, s);
            If p>0 then s2 := DecodeISO(Copy(s, 1, p-1)) + Copy(s, p, Length(s)-p+1)
                   else s2 := DecodeISO(s);
            s2 := HeaderMIMEKodierung(s2);
            If s <> s2 then begin
               Changed := true; Strings[i] := s2; s := s2
            end
         end;
         If AktHeader = HeaderSubject then begin
            s4 := Left(Strings[i], Length(HeaderSubject));
            Repeat
               b := false;
               If Opt.ConvertToRe>'' then begin
                  s := HeaderDecode(i, false);
                  If Left(s, Length(Opt.ConvertToRe)) = Opt.ConvertToRe then begin
                     Strings[i] := s4 + HeaderMIMEKodierung('Re'+Trim(Copy(s, Length(Opt.ConvertToRe)+1, Length(s))));
                     Changed := true; b:=true
                  end
               end;
               If Opt.LFalseRes>'' then begin
                  s := HeaderDecode(i, false);
                  If LowerCase(Left(s, Length(kRe))) = kRe then begin
                     s := Trim(Copy(s, Length(kRe)+1, Length(s)));
                     p := Pos(':', s);
                     If p>0 then begin
                        s2 := LowerCase(Left(s, p-1));
                        If Pos(','+s2+',', ','+LowerCase(Opt.LFalseRes)+',')>0 then begin
                           s := s4 + 'Re: ' + Trim(Copy(s, p+1, Length(s)-p));
                           Strings[i] := HeaderMIMEKodierung(s);
                           Changed := true; b:=true
                        end
                     end
                  end
               end;
               If Opt.DelDoubleRes then begin
                  s := HeaderDecode(i, false);
                  s3 := 're: re:';
                  If LowerCase(Left(s, Length(s3))) = s3 then begin
                     Strings[i] := HeaderMIMEKodierung(s4 + 'Re: '+Trim(Copy(s, Length(s3)+1, Length(s))));
                     Changed := true; b:=true
                  end
               end
            Until not b;
            If Opt.CheckKillWasAfterRe then begin
               s := HeaderDecode(i, false);
               p := pos(kWasbegin, LowerCase(s));
               If (LowerCase(Left(s, Length(kRe)))=kRe) and (p>0) and (Right(s, Length(kWasEnde))=kWasEnde) then begin
                  Strings[i] := HeaderMIMEKodierung(s4 + Trim(Left(s, p-1)));
                  Changed := true
               end
            end;
            If Opt.CheckReplaceSubject8Bits then begin
               s := HeaderDecode(i, false);
               If (Copy(LowerCase(s), 1, 3) <> kRe) and (Copy(LowerCase(s), 1, 5) <> 'cmsg ')
                  and (Copy(LowerCase(s), 1, 7) <> 'cancel ')
               then begin
                  p := pos(kWasbegin, LowerCase(s));
                  If (p > 0) and (Right(s, Length(kWasEnde))=kWasEnde) then begin
                     s2 := Copy (s, p, Length(s)-p+1);
                     System.Delete(s, p, Length(s)-p+1)
                  end else begin
                     s2 := ''
                  end;
                  s3 := Sonderzeichen_wandeln(s)+s2;
                  If s<>s3 then begin
                     Strings[i] := s4 + HeaderMIMEKodierung(s3);
                     Changed := true
                  end
               end
            end
         end;
         { From / Reply-To wandeln? }
         If Opt.CheckFromReplyFormat then begin
            s := Strings[i];
            Split_Headerzeile (Strings[i], AktHeader, AktInhalt);
            If (LowerCase(AktHeader)='reply-to') or (LowerCase(AktHeader)='from') then begin
               ExtractMailParts (AktInhalt, s2, s3, s4);
               s2 := MakeAdress(s2, s4);
               If s2 <> AktInhalt then begin
                  Changed := true;
                  Strings[i] := AktHeader + ': ' + s2
               end
            end
         end
      end
   end;

   { ----------- Bodytest ------------ }

   With Artikel.Body do begin
      While Count>0 do begin
         s := Strings[0];
         If ((Opt.AllowXHeader and (Pos(XHeaderbegin, s)=1))
               or (Opt.AllowAnyHeader and (Copy(s,1,1)='@')))
         then begin
            { Eigene Headerzeilen }
            If Artikel.qp then s := DecodeQPString(s, false);
            If s[1]='@' then s2 := Copy(s,2,Length(s)-1) else s2 := s;
            If Split_Headerzeile (s2, AktHeader, AktInhalt) then begin
               s2 := AktHeader + ': ' + AktInhalt;
               slBodyHeader.AddObject(s2, Skript.Objects[Skript.AddLine(s2)]);
               Delete (0)
            end else break
         end else break
      end;
      While (Count > 1) and (Trim(Strings[0])='') do Delete(0)
   end

end;
{$ENDIF}

{$IFDEF CopyIf}
Procedure DefCounter (Const Bez: String; Const Sep: Boolean);
Var p: Integer;
begin
   With Opt.lCounter do begin
      If Sep then begin
         If (Count > 0) and (Strings[Count-1]>'') then Add ('')
      end else begin
         p := IndexOf(Bez);
         If p < 0 then Add(Bez)
      end
   end
end;

Procedure IncCounter (Const Bez, SubBez: String);
Var p, p2, i: Integer;
Const Einschub = ' - ';
begin
   With Opt.lCounter do begin
      p := IndexOf(Bez);
      If p<0 then p := Add(Bez);
      Objects[p] := Pointer(LongInt(Objects[p])+1);
      If SubBez > '' then begin
         p2 := 0;
         For i:=p+1 to Count-1 do begin
            if Copy(Strings[i], 1, Length(Einschub))<>Einschub
               then begin p := i-1; break end
               else If Strings[i] = Einschub+SubBez then p2 := i
         end;
         If p2 = 0 then begin p2 := p+1; Insert (p2, Einschub+SubBez) end;
         Objects[p2] := Pointer(LongInt(Objects[p2])+1)
      end
   end
end;
{$ENDIF}

Procedure SortHeader (Const Headerliste: String);
Var s, s2: String; i, p: Integer; b: boolean;
begin
   s := Headerliste;
   With TStringlist.Create do try
      Repeat
         s2 := GetFirstElementOfKommaListe (s, b);
         If s2>'' then Repeat
            p := Artikel.Header.Position (s2);
            If p >= 0 then begin
               Add (Artikel.Header[p]);
               Artikel.Header.Delete(p)
            end
         Until p < 0
      Until Not b;
      For i := Count-1 downto 0 do Artikel.Header.Insert(0, Strings[i])
   finally free end
end;

{ --------------------------------------------------------------------- }

Procedure Check_SetIntroduction (slIntro: TStringlist);
Var i: Integer; ok: boolean;
begin
   { Test, ob bereits vorhanden }
   If slIntro.Count <= Artikel.Body.Count then begin
      ok := false;
      For i:=0 to slIntro.Count-1 do If Artikel.Body[i] <> slIntro[i] then ok := true
   end else ok := true;
   { Einsetzen }
   If ok then begin
      If Artikel.Body.Text = #13#10 then
         Artikel.Body.Text := slIntro.text
      else For i:=slIntro.Count-1 downto 0 do begin
         Artikel.Body.Insert(0, slIntro[i]); changed := true
      end
   end
end;

Procedure Check_ConvertQP;
Var Modus: Integer;

    Procedure ConvertIt (sl: TStringlist);
    Var p, l: Integer; Var s2: String;
    begin
       l := 0;
       While l < sl.Count do begin
          s2 := sl[l];
          Repeat
             p := Pos('='#13#10, s2);
             If p>0 then begin s2 := Copy(s2, 1, p-1) + Copy(s2, p+3, Length(s2)) end
          Until p=0;
          While (l+1 < sl.Count) and (s2>'') and (s2[Length(s2)]='=') do begin
             s2 := Copy(s2, 1, Length(s2)-1) + sl[l+1]; sl.Delete(l+1)
          end;
          s2 := DecodeQPString (s2, false);
          If Modus = kQPTo7Bit then s2 := Sonderzeichen_wandeln(s2);
          sl[l] := s2;
          Inc(l)
       end
    end;

begin
   {$IFDEF CopyIf}
   If Artikel.Header.Position (Extraheader_ConvertBody) >= 0 then exit;
   Modus := kQPTo8Bit;
   {$ELSE}
   Modus := Opt.ConvertQPTo;
   {$ENDIF}
   With Artikel do If qp then If Modus IN[kQPTo8Bit, kQPTo7Bit] then begin
      Only7BitTested := false;
      ConvertIt (Body);
      ConvertIt (Sig);
      {$IFDEF CopyIf}
      ConvertIt (slIntro);
      {$ELSE}
      ConvertIt (slSig);
      {$ENDIF}
      If (Typ = atMIME) and (Header2.Count>0) then begin
         If TestOnly7Bit
            then Header2.Change (MIMEContentTransfer, MIME_7Bit)
            else Header2.Change (MIMEContentTransfer, MIME_8Bit)
      end else If (Typ IN[atNix, atText]) then begin
         If TestOnly7Bit then begin
            Header.Change (MIMEVersion, '');
            Header.Change (MIMEContentType, '');
            Header.Change (MIMEContentTransfer, '');
         end else If Modus = kQPTo8Bit then begin
            Header.Change (MIMEContentTransfer, MIME_8Bit);
            {$IFDEF CopyIf}
            Header.Change (Extraheader_ConvertBody, 'Quoted Printable => 8 Bit')
            {$ENDIF}
         end
      end;
      Artikel.qp := false;
      Changed := true
   end;
end;

Procedure Check_ConvertBase64;

    Procedure ConvertIt (sl: TStringlist);
    Var Erg: String; l: Integer;
    begin
       Erg := '';
       For l := 0 to sl.Count-1 do Erg := Erg + DecodeLineBASE64 (sl[l]);
       sl.text := Erg
    end;

Var s: String;
begin
   {$IFNDEF CopyIf} If Not Opt.ConvertBase64 then exit; {$ENDIF}
   With Artikel do If Base64 then begin
      If (Typ = atMIME) and (Header2.Count>0)
         then s := Header2.Inhalt(MIMEContentType, hiOriginal)
         else s := Header.Inhalt(MIMEContentType, hiOriginal);
      If LowerCase(Copy(s, 1, 10)) <> 'text/plain' then exit;
      ConvertIt (Body);
      Changed := true;
      If (Typ = atMIME) and (Header2.Count>0) then begin
         If TestOnly7Bit
            then Header2.Change (MIMEContentTransfer, MIME_7Bit)
            else Header2.Change (MIMEContentTransfer, MIME_8Bit);
      end else If (Typ IN[atNix, atText]) then begin
         If TestOnly7Bit then begin
            Header.Change (MIMEVersion, '');
            Header.Change (MIMEContentType, '');
            Header.Change (MIMEContentTransfer, '');
         end else begin
            Header.Change (MIMEContentTransfer, MIME_8Bit);
         end
      end;
      Artikel.qp := false
   end;
end;

{ --------------------------------------------------------------------- }

{$IFDEF CopyIf}
Var TempPosting: String;

Procedure Artikel_vollenden;
begin
   TempPosting := Artikel.Body.text;
   If slIntro.Count>0 then Check_SetIntroduction(slIntro);
   Posting.text := Artikel.Gesamttext
end;

Procedure Artikel_weiter_bearbeiten;
begin
   Artikel.Body.Text := TempPosting
end;
{$ENDIF}

Procedure BlockAnhaengen (slAdd: TStringlist; Const Rest: String; Const RawMode, TestQP, Clear: boolean);
Var Indent, j: Integer; s, s2, Inhalt: String; sl: TStringlist;
begin
   sl := TStringlist.Create;
   try
      If Clear then Inhalt := ''
               else Inhalt := slAdd.text;
      { Einzeiler }
      If Trim(Rest) > '' then begin
         { Aus Datei }
         s := Rest;
         If SucheUndKuerze('from', s) then begin
            If GetString(s, s2) then begin
               s2 := ErgaenzeDateiname(s2);
               If FileExists(s2) then begin
                  LoadTextFile ( s2, sl );
                  For j := 0 to sl.Count-1 do Inhalt := Inhalt + Tested(sl[j], TestQP, Not RawMode) + #13#10
               end else Fehler('Datei "'+s2+'" konnte nicht gefunden werden!', s)
            end else Fehler ('Nach "from" wird noch ein Dateiname erwartet.', s)
         { Direktzuweisung }
         end else If SucheUndKuerze(':', s) or SucheUndKuerze('=', s) or true then begin
            if GetString(s, s2)
               then Inhalt := Inhalt + Tested(s2, TestQP, false) + #13#10
               else
                  If true then Fehler ('Unzulssiger Stringausdruck: "'+s+'" ist keine String-Konstante, keine String-Funktion und keine Variable!', s)
                          else Inhalt := Inhalt + Tested(s, TestQP, Not RawMode) + #13#10
         end
      { Multi-Zeiler }
      end else begin
         Indent := -1;
         With Skript do Repeat
            If Zeile >= Count then break;
            Zeile := Zeile + 1;
            { RawMode: Keine "%"-Auswertung, dafr wird Einrckung beibehalten }
            s := Zeilen[Zeile-1].Inhalt;
            If RawMode then begin
               If Indent < 0 then begin
                  Indent := 0;
                  While Copy(s, 1, 1) = ' ' do begin
                     Inc(Indent); s := Copy(s, 2, Length(s)-1)
                  end
               end else
               For j:=1 to Indent do If Copy(s, 1, 1) = ' ' then s := Copy(s, 2, Length(s)-1)
            end else s := Trim(s);
            { Durch? }
            If LowerCase(Trim('-'+s)) = '-end' then break
            else begin
               Inhalt := Inhalt + Tested(s, TestQP, Not RawMode) + #13#10;
               changed := true
            end
         Until false
      end;
      slAdd.text := Inhalt
   finally
      sl.free
   end
end;

Function FindSub (Const Bez: String; Var Z: Integer; Var Pars: String): boolean; forward;
Function FindGoto (Const Bez: String; Var Z: Integer): boolean; forward;

Procedure Check_OE_Zitate;

  Function ZaehleEbenen(Const s: String): Integer;
  Var OtherChars: Boolean; i: Integer;
  begin
     Result := 0;
     OtherChars := false;
     If Copy(s,1,1)='>' then begin
        For i := 1 to Length(s) do Case s[i] of
           '>': Inc(Result);
           ' ', ^I: ;
           else begin OtherChars := true; break end
        end;
        If Not OtherChars then Result := -1
     end else
     If Copy(s,1,1)+' '=' ' then Result := -1
  end;

Var i {$IFDEF CopyIf} , Anz {$ENDIF}: Integer; s1, s2: String;
    Eb1, Eb2: Integer;
begin
   {$IFDEF CopyIf}
   If Artikel.Header.Position (Extraheader_RepairOE) >= 0 then exit;
   Anz := 0;
   {$ENDIF}
   i := 0;
   With Artikel do With Body do begin
      While i < Count-1 - 1 do begin
         s1 := DecodeBodyString(Strings[i]);   Eb1 := ZaehleEbenen(s1);
         s2 := DecodeBodyString(Strings[i+1]); Eb2 := ZaehleEbenen(s2);
         If (Eb1 > 0) and (Eb2 = 0) then begin
            If (Length(s1)+Length(s2) < 90+2*Eb1)
               and (Length(s1)+Length(s2)+Eb1 > 60) and ((Length(s2)<15) or (Pos(' ', s2)<15))
            then begin
               Strings[i] := EncodeBodyString(s1+' '+s2);
               Delete(i+1);
               {$IFDEF CopyIf} Inc(Anz); {$ENDIF}
               Changed := true
            end
         end;
         Inc(i)
      end
   end;
   {$IFDEF CopyIf}
   If Anz > 0 then Headerzeile_anhaengen (Extraheader_RepairOE + IntToStr(Anz) + 'x')
   {$ENDIF}
end;


{ For-Next-Schleife }
Procedure ForNextOnStack (Const ZeilenNr: Integer; Const VarBez: String;
   Const Ab, Bis, Step: Double);
begin
   slStack.InsertObject(0, 'For-Schleife', Pointer(ZeilenNr));
   slStack.Insert (1, VarBez);
   slStack.Insert (2, ToStr(Ab-Step));
   slStack.Insert (3, ToStr(Bis));
   slStack.Insert (4, ToStr(Step));
   SetVarValue (VarBez, ToStr(Ab))
end;
Procedure TestNext;
Var VarBez: String; x, Bis, Step: Double; i, j, Stack: Integer; Cont: boolean;
begin
   Cont := false;
   If slStack.Count > 0 then begin
      If Copy(slStack[0], 1, 3) <> 'For' then Fehler('"Next" ohne passendes "For"!', '');
      Step := ToNum(slStack[4]);
      x := ToNum(slStack[2]) + Step;
      Bis := ToNum(slStack[3]);
      Cont := ((Step > 0) and (x <= Bis)) or ((Step < 0) and (x >= Bis));
   end else Fehler('"Next" ohne vorheriges "For"!', '');

   i := LongInt(slStack.Objects[0]);
   If Cont then begin
      VarBez := slStack[1];
      x := ToNum(slStack[2]) + ToNum(slStack[4]); { Ab + Step }
      Skript.Zeile := i;
      SetVarValue (VarBez, ToStr(x));
      slStack[2] := ToStr(x)
   end else begin
      Stack := 1;
      For j := 0 to 4 do slStack.Delete(0);
      While (Stack <> 0) and (i < Skript.Count) do begin
         Inc(i);
         Case Skript[i-1].Typ of
            ztEndsub: Fehler('Zugehriges "Next" zum "For" fehlt in der aktuellen Prozedur!', '');
            ztSub: Fehler('Zugehriges "Next" mu sich vor einem Prozeduranfang (Sub ...) befinden!', '');
            ztFor: Inc(Stack);
            ztNext: Dec(Stack);
         end
      end;
      If Stack = 0 then Skript.Zeile := i
                   else Fehler('Zugehriges "Next" fehlt!', '');
   end
end;

{ Repeat-Until-Schleife }
Procedure RepeatOnStack (Const ZeilenNr: Integer);
begin
   slStack.InsertObject(0, 'Repeat-Schleife', Pointer(ZeilenNr));
   slStack.Insert (1, '')
end;
Procedure TestUntil;
Var i, j, Stack, NeuZ: Integer; Cont: boolean; Bedingung: String;
begin
   Cont := false; NeuZ := 0;
   If slStack.Count > 0 then begin
      If Copy(slStack[0], 1, 6) <> 'Repeat' then Fehler('"Until" ohne passendes "Repeat"!', '');
      Bedingung := slStack[1]; NeuZ := LongInt(slStack.Objects[1]);
      If NeuZ = 0 then begin
         i := LongInt(slStack.Objects[0]); Stack := 1;
         While (Stack <> 0) and (i < Skript.Count) do begin
            Inc(i);
            Case Skript[i-1].Typ of
               ztEndsub: Fehler('Zugehriges "Until" zum "Repeat" fehlt in der aktuellen Prozedur!', '');
               ztSub: Fehler('Zugehriges "Until" mu sich vor einem Prozeduranfang (Sub ...) befinden!', '');
               ztRepeat: Inc(Stack);
               ztUntil: Dec(Stack);
            end
         end;
         If Stack = 0 then NeuZ := i
                      else Fehler('Zugehriges "Until" fehlt!', '');
         slStack.Objects[1] := Pointer(NeuZ);
         Bedingung := Trim(Skript[i-1].Inhalt); SucheUndKuerze('Until', Bedingung); slStack[1] := Bedingung
      end;
      Cont := Not TestBedingung(Bedingung)
   end else Fehler('"Until" ohne vorheriges "Repeat"!', '');


   If Cont then begin
      Skript.Zeile := LongInt(slStack.Objects[0]);
   end else begin
      Skript.Zeile := NeuZ;
      For j := 0 to 1 do slStack.Delete(0)
   end
end;

{ While-Wend-Schleife }
Procedure WhileOnStack (Const ZeilenNr: Integer; Const Bedingung: String);
begin
   slStack.InsertObject(0, 'While-Schleife', Pointer(ZeilenNr));
   slStack.Insert (1, Bedingung)
end;
Procedure TestWend;
Var i, j, Stack: Integer; Cont: boolean; Bedingung: String;
begin
   Cont := false;
   If slStack.Count > 0 then begin
      If Copy(slStack[0], 1, 5) <> 'While' then Fehler('"Wend" ohne passendes "While"!', '');
      Bedingung := slStack[1];
      Cont := TestBedingung(Bedingung)
   end else Fehler('"Wend" ohne vorheriges "While"!', '');

   i := LongInt(slStack.Objects[0]);
   If Cont then begin
      Skript.Zeile := i
   end else begin
      Stack := 1;
      For j := 0 to 1 do slStack.Delete(0);
      While (Stack <> 0) and (i < Skript.Count) do begin
         Inc(i);
         Case Skript[i-1].Typ of
            ztEndsub: Fehler('Zugehriges "Wend" zum "While" fehlt in der aktuellen Prozedur!', '');
            ztSub: Fehler('Zugehriges "Wend" mu sich vor einem Prozeduranfang (Sub ...) befinden!', '');
            ztWhile: Inc(Stack);
            ztWend: Dec(Stack);
         end
      end;
      If Stack = 0 then Skript.Zeile := i
                   else Fehler('Zugehriges "Wend" fehlt!', '');
   end
end;

{ Endless-Loop-Schleife }
Procedure LoopOnStack (Const ZeilenNr: Integer);
begin
   slStack.InsertObject(0, 'Endless-Loop-Schleife', Pointer(ZeilenNr));
end;
Procedure TestLoop;
begin
   If slStack.Count > 0 then begin
      If Copy(slStack[0], 1, 7) <> 'Endless' then Fehler('"Loop" ohne passendes "Endless"!', '');
   end else Fehler('"Loop" ohne passendes "Endless"!', '');
   Skript.Zeile := LongInt(slStack.Objects[0])
end;

{ Break / Continue }

Procedure TestBreak;
Var i, Neu, Anz: Integer;
begin
   i := Skript.Zeile;
   Neu := -1; Anz := 0;
   While (Neu < 0) and (i < Skript.Count) do begin
      Inc(i);
      Case Skript[i-1].Typ of
         ztEndSub: Fehler('Break ohne passende Schleife, Prozeduren beendet man mit "Return"!', '');
         ztWend, ztUntil: begin Neu := i; Anz := 2 end;
         ztNext: begin Neu := i; Anz := 5 end;
         ztLoop: begin Neu := i; Anz := 1 end;
      end
   end;
   If Neu < 0 then Fehler ('Break ohne passende Schleife!', '');
   Skript.Zeile := Neu;
   For i := 1 to Anz do slStack.Delete(0)
end;

Procedure TestContinue;
Var s: String;
begin
   If slStack.Count = 0 then Fehler('Continue ohne passende Schleife', '')
   else begin
      s := slStack[0];
      If Copy(s, 1, 3) = 'For' then TestNext
      else
      If Copy(s, 1, 5) = 'While' then TestWend
      else
      If Copy(s, 1, 6) = 'Repeat' then TestUntil
      else
      If Copy(s, 1, 7) = 'Endless' then TestLoop
      else
      Fehler ('Auf das Konstrukt "'+s+'" kann "Continue" nicht angewendet werden!', '')
   end
end;

{ Sub / Endsub }
Procedure TestEndSub;
begin
   If slStack.Count > 0 then begin
      If Copy(slStack[0], 1, 3) <> 'Sub'
         then Fehler('Sub kann erst verlassen werden, wenn zumindest "'+slStack[slStack.Count-1]+'" beendet worden ist!', '');
      Skript.Zeile := LongInt(slStack.Objects[0]);
      slStack.Delete(0);
      ClearLokalVars
   end else Fehler('"Return"/"EndSub" ohne vorheriges "GoSub"!', '')
end;

{ Clear Stack }
Procedure ClearStackBetween (Const Ab, Bis: Integer);
Var i, Anz, SubStack: Integer;

   Procedure Test(Const i: Integer);
   begin
      If Not (i < Skript.Count) then exit;
      Case Skript[i].Typ of
         ztSub: Inc(SubStack);
         ztEndSub: Dec(SubStack);
         ztFor: Inc(Anz, 5); ztNext: Dec(Anz, 5);
         ztWhile, ztRepeat: Inc(Anz, 2); ztWend, ztUntil: Dec(Anz, 2);
         ztDo: Inc(Anz, 1); ztLoop: Dec(Anz, 1);
      end
   end;

begin
   Anz := 0; SubStack := 0;
   If Bis > Ab then begin
      For i := Ab+1 - 1 to Bis-1 - 1 do Test(i);
      Anz := - Anz
   end else begin
      For i := Ab-1 - 1 downto Bis+1 - 1 do Test(i)
   end;
   If SubStack <> 0 then Fehler('Goto wrde aktuelle Prozedur verlassen - solche Sprnge sind unzulssig!', '')
   else
   If Anz < 0 then Fehler('Goto wrde in das Innere einer Schleife springen - solche Sprnge sind unzulssig!', '')
   else
   If Anz > 0 then For i := 1 to Anz do slStack.Delete(0)
end;

{ Primrfunktionen fr Zeileninterpretation... }

Procedure InterpreteCommand (Var s: String);
Const MaxPar = 20;
Var s2, s3, s4, s5, AktHeader, AktInhalt: String;
    ok, b, b2, b3, Warten: boolean;
    i, p, Anz1, Anz2: Integer;
    ab, bis, Zahl: Double;
    Pars, Vars: Array[1..MaxPar] of String;
    VarTyp: Array[1..MaxPar] of boolean;
    x: Word;
    SetHeader, AppendHeader, RawMode: Boolean;
    rm: TReplaceMode; rw: TReplaceWhere;
    sltemp: TStringlist;
begin
   SetHeader := false; AppendHeader := false; RawMode := false;
   s2 := Trim(LowerCase(s));
   { Ablaufsteuerung }
   If SucheUndKuerze('stop', s) then Retry := rJumpNextLineAndStop {sssFehler ('', s)}
   else If SucheUndKuerze('quit', s) then begin
      Retry := rEndProgram; exit
   end
   else If SucheUndKuerze('Next', s) then TestNext
   else If SucheUndKuerze('gosub', s) then begin
      If GetWord(s, s2) then begin
         If FindSub(s2, p, s3) then begin
            { Variablendeklaration der Sub }
            Anz2 := 0;
            While Trim(s3) > '' do begin
               Inc(Anz2);
               VarTyp[Anz2] := SucheUndKuerze('Var', s3);
               If GetVarName(s3, s4) <> vnIllegal then begin
                  Vars[Anz2] := s4;
                  If (Trim(s3)>'') and (Not SucheUndKuerze(',',s3))
                     then Fehler('Ungltige Parameterliste', s)
               end else Fehler('Ungltige Parameterliste', s)
            end;
            { bergebene Parameter }
            Anz1 := 0;
            If Trim(s)>'' then begin
               If Not Klammerung(s, s3, true) then begin
                  s3 := s; s := ''
               end;
               While Trim(s3) > '' do begin
                  Inc(Anz1);
                  If Anz1 > Anz2 then break;
                  If VarTyp[Anz1] then begin
                     Case GetVarName(s3, s4) of
                        vnIllegal: Fehler('Als '+Inttostr(Anz1)+'. Parameter wird ein Variablenname erwartet', s);
                        vnNew: SetVarValue (s4, '')
                     end;
                     Pars[Anz1] := s4;
                     If (Trim(s3)>'') and (Not SucheUndKuerze(',',s3))
                        then Fehler('Ungltige Parameterliste', s)
                  end else If GetString(s3, s4) then begin
                     Pars[Anz1] := s4;
                     If (Trim(s3)>'') and (Not SucheUndKuerze(',',s3))
                        then Fehler('Ungltige Parameterliste', s)
                  end else Fehler('Ungltige Parameterliste', s)
               end
            end;
            { Weiter gehts }
            If Anz1 <> Anz2 then Fehler('Anzahl der Parameter fr Sub "'+s2+'" stimmt nicht!', s);
            SetLokalVars (s2, Vars, Pars, VarTyp);
            slStack.InsertObject(0, 'Sub '+s2, Pointer(Skript.Zeile));
            Skript.Zeile := p+1
         end else Fehler ('Kein "Sub '+s2+'" im Skript auffindbar!', s)
      end else Fehler('Hinter "GoSub" mu noch der Name der gewnschten Sub-Routine folgen!', s)
   end
   else If s2='return' then TestEndSub
   else If s2='break' then TestBreak
   else If (s2='cont') or (s2='continue') then TestContinue
   else If SucheUndKuerze('goto', s) then begin
      If GetWord(s, s2) then begin
         If FindGoto(s2, p) then begin
            ClearStackBetween (Skript.Zeile, p+1); 
            Skript.Zeile := p+1
         end else Fehler ('Kein Label ":'+s2+'" im Skript auffindbar!', s)
      end else Fehler('Hinter "GoTo" mu noch der Name des gewnschten Labels (ohne ":" davor) folgen!', s)
   end
   { Set-Befehle/Modi aktivieren }
   else If SucheUndKuerze('Set', s) then begin
      RawMode := SucheUndKuerze('raw', s);
      If SucheUndKuerze('Introduction', s) or SucheUndKuerze('Intro', s) then begin
         BlockAnhaengen (slIntro, s, RawMode, true, true)
      {$IFDEF CopyIf}
      {$ELSE}
      end else If SucheUndKuerze('Sig', s) or SucheUndKuerze('Signature', s) then begin
         Zahl := 0;
         If Copy(s,1,1)='#' then begin
            Delete(s,1,1);
            If Not GetNumber(s, Zahl) then
               Fehler('Hinter "Set Sig #" mu die Nummer der gewnschten Signatur folgen!', s)
         end;
         If ChangeSig then Only7BitTested := false;
         BlockAnhaengen(slSig, s, RawMode, true, true);
         ChooseSig(slSig, Trunc(Zahl)); ChangeSig := true; Changed := true
      end else If SucheUndKuerze('Lines', s) or SucheUndKuerze('Line', s) then begin
         BlockAnhaengen (slAppend, s, RawMode, true, true)
      end else If SucheUndKuerze('Macro', s) then begin
         If GetString(s, s2) or (Length(s2)<6) then begin
            slTemp := TStringlist.Create;
            try
               BlockAnhaengen(slTemp, s, RawMode, true, true);
               ExpandiereMakro (s2, slTemp)
            finally slTemp.free end;
         end else Fehler('Hinter "Set Macro" mu noch der Name des Macros folgen, dieser Name mu mindestens 6 Zeichen umfassen', s)
      {$ENDIF}
      end else If SucheUndKuerze('Header', s) or SucheUndKuerze('H', s) then begin
         If Trim(s) > '' then SetHeader := true
         else begin
            slTemp := TStringlist.Create;
            try
               BlockAnhaengen(slTemp, s, RawMode, false, true);
               If slTemp.Count > 0 then begin
                  s := slTemp[0];
                  While slTemp.Count > 1 do begin
                     s := s + #13#10 + slTemp[1];
                     slTemp.Delete(1)
                  end;
                  SetHeader := true; RawMode := true
               end
            finally
               slTemp.free
            end
         end
      end else
      If SucheUndKuerze('Bodyline', s) then begin
         If GetNumber (s, Zahl) then begin
            slTemp := TStringlist.Create;
            try
               BlockAnhaengen(slTemp, s, RawMode, true, true);
               s2 := slTemp.text; i := Length(s2);
               If (i >= 2) and (s2[i-1]=#13) and (s2[i]=#10) then Delete(s2, i-1, 2);
               If Artikel.Body[Trunc(Zahl)-1] <> s2 then begin
                  Artikel.Body[Trunc(Zahl)-1] := s2;
                  Changed := true
               end
            finally slTemp.free end
         end else  Fehler('Hinter "Set Bodyline" mu noch die Zeilennummer folgen', s)
      end else
      If SucheUndKuerze('Option', s) or SucheUndKuerze('Opt', s) then begin
         If Not SetzeOption (s) then
            Fehler('Fehlerhafter "Set Option"-Befehl, korrekt wre: Set Option INIWert = Wert', s)
      end else If GetVarName(s, s2)<>vnIllegal then begin
         slTemp := TStringlist.Create;
         try
            BlockAnhaengen(slTemp, s, RawMode, false, true);
            s := slTemp[0];
            While slTemp.Count > 1 do begin
               s := s + #13#10 + slTemp[1];
               slTemp.Delete(1)
            end;
            SetVarValue(s2, s)
         finally
            slTemp.free
         end
      {$IFDEF CopyIf}
      end else Fehler ('Unbekannter Set-Befehl "'+s
          +'" (z.Z. nur Variablenname, "H[eader]", "Intro[duction]" und "Option" erlaubt)', s)
      {$ELSE}
      end else Fehler ('Unbekannter Set-Befehl "'+s
          +'" (z.Z. nur Variablenname, "H[eader]", "Intro[duction]", "Line[s]", '
           + '"Sig[nature]", "Macro" und "Option" erlaubt)', s)
      {$ENDIF}
   end else If SucheUndKuerze('Append', s) then begin
      RawMode := SucheUndKuerze('raw', s);
      If SucheUndKuerze('Introduction', s) or SucheUndKuerze('Intro', s) then begin
         BlockAnhaengen (slIntro, s, RawMode, true, false)
      end else If SucheUndKuerze('Header', s) or SucheUndKuerze('H', s) then begin
         SetHeader := true; AppendHeader := true
      end else If GetVarName(s, s2) = vnExist then begin
         slTemp := TStringlist.Create;
         try
            BlockAnhaengen(slTemp, s, RawMode, false, true);
            s := slTemp[0];
            While slTemp.Count > 1 do begin
               s := s + #13#10 + slTemp[1];
               slTemp.Delete(1)
            end;
            SetVarValue(s2, GetVarValue(s2) + #13#10 + s)
         finally
            slTemp.free
         end
      {$IFDEF CopyIf}
      end else Fehler('Unbekannter Append-Befehl "'+s
          +'" (z.Z. nur "Intro[duction]", "H[eader]" und Variablenname erlaubt)', s)
      {$ELSE}
      end else If SucheUndKuerze('Lines', s) or SucheUndKuerze('Line', s) then begin
         BlockAnhaengen (slAppend, s, RawMode, true, false)
      end else If SucheUndKuerze('Signature', s) or SucheUndKuerze('Sig', s) then begin
         Zahl := 0;
         If Copy(s,1,1)='#' then begin
            Delete(s,1,1);
            If Not GetNumber(s, Zahl) then
               Fehler('Hinter "Set Sig #" mu die Nummer der gewnschten Signatur folgen!', s)
         end;
         slTemp := TStringlist.Create;
         BlockAnhaengen(slTemp, s, RawMode, true, true);
         ChooseSig(slTemp, Trunc(Zahl));
         slSig.AddStrings (slTemp); ChangeSig := true; Changed := true;
         slTemp.free
      end else Fehler('Unbekannter Append-Befehl "'+s
          +'" (z.Z. nur "Intro[duction]", "Line[s]", "Sig[nature]", "H[eader]" und Variablenname erlaubt)', s)
      {$ENDIF}
   end else If SucheUndKuerze('Insert', s) then begin
      If SucheUndKuerze('BodyLine', s) then begin
         If GetNumber(s, ab) and SucheUndKuerze('=', s) and GetString(s, s2) then begin
            i := Trunc(ab)-1; If i < 0 then i := 0;
            s2 := Tested(s2, Artikel.qp, false);
            If i < Artikel.body.Count
               then Artikel.Body.Insert (i, s2)
               else Artikel.Body.Append (s2);
            Changed := true
         end else Fehler('Falsche Syntax, korrekt wre: "Insert BodyLine Zeile = Inhalt"', s)
      end else Fehler('Unbekannter Insert-Befehl "'+s +'" (z.Z. nur "Bodyline" erlaubt)', s)
   end else If SucheUndKuerze('Delete', s) then begin
      If SucheUndKuerze('Header', s) then begin
         While Artikel.Header.Change (s, '') do Changed := true
      end else If SucheUndKuerze('Intro', s) or SucheUndKuerze('Introduction', s) then begin
         slIntro.Clear; Only7BitTested := false
      end else If SucheUndKuerze('Bodylines', s) then begin
         SucheUndKuerze('from', s);
         If GetNumber(s, ab) and SucheUndKuerze('to', s) and GetNumber(s, bis) and (Trim(s)='') then begin
            ab := Trunc(Ab)-1; If ab < 0 then ab := 0;
            bis := Trunc(bis)-1; If bis > Artikel.Body.Count-1 then bis := Artikel.Body.Count-1;
            If bis >= ab then begin
               For i:=0 to Trunc(bis-ab) do Artikel.Body.Delete(Trunc(ab));
               Changed := true
            end
         end else Fehler('Falsche Syntax, korrekt ist: "Delete BodyLines from <Zeile> to <Zeile>', s)
      end else If SucheUndKuerze('Bodyline', s) then begin
         If GetNumber(s, ab) and (Trim(s)='') then begin
            ab := Trunc(Ab)-1; If ab < 0 then ab := 0;
            If Trunc(ab) < Artikel.Body.Count then begin
               Artikel.Body.Delete(Trunc(ab));
               Changed := true
            end
         end else Fehler('Falsche Syntax, korrekt ist: "Delete BodyLine <Zeile>', s)
      end else If SucheUndKuerze('between', s) then begin
         ok := true; b3 := false;
         If SucheUndKuerze('last', s) then b3 := false
         else If SucheUndKuerze('first', s) then b3 := true
         else ok := false;
         If ok and GetString(s, s2) and SucheUndKuerze(',', s) and GetString(s, s3) and SucheUndKuerze(',', s) then begin
            ok := false;
            b := TestBedingung(s);
            b2 := SucheUndKuerze(',', s) and GetString(s, s4);
            If (s = '') and ((s2 > '') or b3) and ((s3 > '') or Not b3) then begin
               // b3: Erstes oder letztes Lschen, s2/s3: Regexp von/bis, b: Lsche Trenner?;
               // b2: Ersatztext?; s4: Ersatztext.    
               If LoescheZwischen (b3, s2, s3, b, b2, s4) then Changed := true;
               ok := true
            end
         end;
         If not ok then Fehler('Falsche Syntax, korrekt ist: "Delete between ( first | last ) <regexp>, '
             +'<regexp>, Trenner mitlschen? [, Ersatztext]". Bei "first" mu zumindest der zweite '
             +'regexp-Ausdruck gefllt sein, bei "last" zumindest der erste regexp-Ausdruck.', s)
      end else If SucheUndKuerze('empty Lines at end', s) then begin
         p := 0;
         {$IFNDEF CopyIf} If ChangeSig then slTemp := slSig
          else {$ENDIF} If Artikel.HasSig then slTemp := Artikel.Sig
           else begin slTemp := Artikel.Body; p := 1 end;
         With slTemp do For i:=Count-1 downto p do
            If Strings[i]='' then begin Delete(i); changed := true end
                             else break
      {$IFNDEF CopyIf}
      end else If SucheUndKuerze('sig', s) or SucheUndKuerze('signature', s) then begin
         slSig.Clear; Only7BitTested := false; ChangeSig := true
      end else If SucheUndKuerze('BodyHeader', s) then begin
         DeleteBodyHeader(s)
      end else If SucheUndKuerze('Line', s) or SucheUndKuerze('Lines', s) then begin
         slAppend.Clear; Only7BitTested := false
      {$ENDIF}
      end else Fehler('Unbekannte Delete-Anweisung "'+s+'"', s);
   end else If SucheUndKuerze('Do', s) then begin
      If SucheUndKuerze('Show', s) then begin
         If SucheUndKuerze('Info', s) then begin
            ok := false;
            If GetString(s, s2) then begin
               s3 := Titel;
               If (s='') or (SucheUndKuerze(',', s) and GetString(s, s3)) then begin
                  Messagebox (0, PChar(s2), PChar(s3), MB_ICONINFORMATION);
                  ok := true
               end
            end;
            If not ok then Fehler('Falsche Show-Info-Syntax, korrekt wre: "Do Show Info <Text> [, <berschrift> ]")', s)
         end else Fehler('Unbekannter "Do Show"-Befehl "'+s+'" (z.Z. nur "Info" erlaubt)', s)
      end else
      If SucheUndKuerze('Sort', s) then begin
         If SucheUndKuerze('Header', s) then begin
            SortHeader (s)
         end else Fehler('Unbekannter "Do Sort"-Befehl "'+s+'" (z.Z. nur "Header" erlaubt)', s)
      end else
      If SucheUndKuerze('Repair', s) then begin
         If SucheUndKuerze('OEQuotings', s) then begin
            Check_OE_Zitate
         end else Fehler('Unbekannter "Do Repair"-Befehl "'+s+'" (z.Z. nur "OEQuotings" erlaubt)', s)
      end else
      If SucheUndKuerze('Write', s) then begin
         If SucheUndKuerze('IniStr', s) then begin
            If GetString(s, s2)
               and SucheUndKuerze(',', s) and GetString(s, s3)
               and SucheUndKuerze(',', s) and GetString(s, s4)
               and SucheUndKuerze(',', s) and GetString(s, s5)
            then begin
               With TIniFile.Create(s2) do try WriteString(s3, s4, s5) finally free end
            end else Fehler('Falsche Syntax, richtig wre "Do Write IniStr Datei, Abschnitt, Key, Wert', s)
         end else If SucheUndKuerze('Textfile', s) then begin
            If GetString(s, s2)
               and SucheUndKuerze(',', s) and GetString(s, s3)
               and (s = '')
            then begin
               With TStringList.Create do try
                  Text := s3; SaveToFile (s2)
               finally free end
            end else Fehler('Falsche Syntax, richtig wre "Do Write Textfile Datei, String', s)
         end else Fehler('Unbekannter "Do Write"-Befehl "'+s+'" (z.Z. nur "IniStr" und "Textfile" erlaubt)', s)
      end else
      If SucheUndKuerze('Open', s) then begin
         s3 := '';
         If GetString(s, s2) and ((s='') or ((SucheUndKuerze(',', s) and GetString(s, s3)))) then begin
            x := ShellExecute(GetDesktopWindow, 'open', PChar(s2), PChar(s3), PChar(ExtractFilePath(s2)), SW_SHOW);
            If x<32 then Fehler('Fehler #'+Inttostr(x)+' beim Aufruf von "'+Trim(s2+' '+s3)+'"', s)
         end else Fehler ('Falsche Syntax, korrekt wre: "Do Open Dokument [, Parameter]"', s)
      end else
      If SucheUndKuerze('Print', s) then begin
         s3 := '';
         If GetString(s, s2) and ((s='') or ((SucheUndKuerze(',', s) and GetString(s, s3)))) then begin
            x := ShellExecute(GetDesktopWindow, 'print', PChar(s2), PChar(s3), PChar(ExtractFilePath(s2)), SW_SHOW);
            If x<32 then Fehler('Fehler #'+Inttostr(x)+' beim Aufruf von "'+Trim(s2+' '+s3)+'"', s)
         end else Fehler ('Falsche Syntax, korrekt wre: "Do Print Dokument [, Parameter]"', s)
      end else
      If SucheUndKuerze('Exec', s) or SucheUndKuerze('Run', s) then begin
         Warten := SucheUndKuerze('and wait', s);
         If GetString(s, s2) then begin
            If SucheUndKuerze(',', s) then GetString(s, s3)
                                      else s3 := '';
            If s > '' then Fehler ('Falsche Syntax, korrekt wre: "Do Exec Programm/Dokument, Parameter"', s)
            else begin
               {$IFDEF CopyIf}
               If Opt.Simulate then begin
                   If Opt.ShowFoundedPostingsWhenSimulate then begin
                     If Warten then begin
                        If Not ShowArtikel ('Aufruf incl. Warten von "'+s2+'" mit Parameter "'+s3+'"',
                           Artikel.Gesamttext) then Stop
                     end else begin
                        If Not ShowArtikel ('Aufruf ohne Warten von "'+s2+'" mit Parameter "'+s3+'"',
                           Artikel.Gesamttext) then Stop
                     end
                   end
               end else {$ENDIF} begin
                  If Warten then begin
                     If Not ExecAndWait (s2, s3, SW_SHOWDEFAULT) then Fehler('Fehler beim Ausfhren von "'+Trim(s2+' '+s3)+'"', s)
                  end else begin
                     x := ShellExecute(GetDesktopWindow, 'open', PChar(s2), PChar(s3), PChar(ExtractFilePath(s2)), SW_SHOW);
                     If x<32 then Fehler('Fehler #'+Inttostr(x)+' beim Aufruf von "'+Trim(s2+' '+s3)+'"', s)
                  end
               end
            end
         end
      end else If SucheUndKuerze('Replace', s) then begin
         rm := rmAll;
         If SucheUndKuerze('all', s) then rm := rmAll
         else If SucheUndKuerze('first', s) then rm := rmFirst
         else If SucheUndKuerze('last', s) then rm := rmLast
         else Fehler('Unbekannter "Do Replace"-Typ, nur "All", "Last" oder "First" erlaubt', s);
         If GetString (s, s2) then begin
            If SucheUndKuerze('with', s) then begin
               s4 := '';
               If Not GetString(s, s3) then s3 := '';
               If SucheUndKuerze('in', s) then begin
                  rw := rwBody;
                  If SucheUndKuerze('Body', s) then rw := rwBody
                  else If SucheUndKuerze('Sig', s) then rw := rwSig
                  else If SucheUndKuerze('Lines', s) then rw := rwLines
                  else If SucheUndKuerze('Intro', s) then rw := rwIntro
                  else If SucheUndKuerze('Header', s) then rw := rwHeader
                  else If SucheUndKuerze('Header2', s) then rw := rwHeader2
                  else If GetVarname (s, s4) = vnExist then rw := rwVar
                  else Fehler('Nach "Do Replace <Suchausdruck> with <Ersatz> in" mu noch "Body", "Sig", "Lines", '
                     +'"Intro", "Header", "Header2" oder ein Variablenname kommen.', s)
               end else rw := rwBody;
               ab := -1;
               If SucheUndKuerze('from', s) then begin
                  If not GetNumber(s, ab) then Fehler('Keine gltige Zahl nach "from" im "Do Replace"-Befehl.', s)
               end;
               bis := -1;
               If SucheUndKuerze('to', s) then begin
                  If not GetNumber(s, bis) then Fehler('Keine gltige Zahl nach "to" im "Do Replace"-Befehl.', s)
               end;
               ReplaceInBody (s2, s3, rm, rw, s4, Trunc(ab), Trunc(bis))
            end else Fehler('Nach "Do Replace <Suchausdruck>" mu noch "with <Ersatz>" kommen', s)
         end else Fehler('Nach "Do Replace" mu noch "<Suchausdruck> with <Ersatz>" kommen', s)
      end else If SucheUndKuerze('Convert', s) then begin
        {$IFDEF CopyIf}
         If SucheUndKuerze('QPHeader', s) then begin
            ConvertQPHeader
         end else If SucheUndKuerze('QPBody', s) then begin
            Check_ConvertQP
         end else If SucheUndKuerze('OEBeginBug', s) then begin
            Check_ConvertOEBeginBug
         end else If SucheUndKuerze('OEKillFalseReBug', s) then begin
            Check_ConvertOEKillFalseReBug
         end else
        {$ENDIF}
         If SucheUndKuerze('BoxQuotes', s) then begin
            If GetNumber(s, Zahl) and (s='')
               then ConvertBoxQuotes (Trunc(Zahl))
               else Fehler('Nach "Do Convert Boxquotes" mu noch die Boxquote-Definitions-Nr folgen!', s)
        {$IFDEF CopyIf}
         end else Fehler ('Zur Zeit sind nur die Konvertierungsbefehle "Do Convert QPHeader", '
             +'"Do Convert QPBody", "Do Convert OEBeginBug" und "Do Convert BoxQuotes <Nummer>" zulssig.', s)
        {$ELSE}
         end else Fehler ('Zur Zeit ist nur der Konvertierungsbefehl "Do Convert BoxQuotes <Nummer>'
             +'" zulssig', s)
        {$ENDIF}
      {$IFDEF CopyIf}
      end else If SucheUndKuerze('Export as', s) then begin
         If GetString(s, s2) and (Pos('*', s2)>0) then begin
            Artikel_vollenden;
            ExportArtikel (s2, Opt);
            Artikel_weiter_bearbeiten
         end else Fehler ('Nach "Do Export as" muss noch ein Dateiname mit "*" kommen.', s)
      end else If SucheUndKuerze('Show', s) then begin
         Artikel_vollenden;
         b := Not ShowArtikel ('', Artikel.Gesamttext);
         Artikel_weiter_bearbeiten;
         If b
            then begin Retry := rEndProgram; abort end
            else Skript.Zeile := Skript.Count
      end else If SucheUndKuerze('Copy to Group', s) then begin
         If GetString(s, s2) then begin
            Artikel_vollenden;
            SpeichereArtikelKopie (s2, Opt.AddToMessageID, Opt.CopyIfExist, Opt);
            Artikel_weiter_bearbeiten
         end else Fehler ('Nach "Do Copy to group" muss noch der Gruppenname in Anfhrungsstrichen folgen.', s)
      end else If SucheUndKuerze('Define Counter', s) or SucheUndKuerze('Def Counter', s)then begin
         If GetString(s, s2) then begin
            Repeat
               DefCounter(s2, false);
               If Not SucheUndKuerze(',', s)
                  then break
                  else While SucheUndKuerze(',', s) do DefCounter('', true)
            Until Not GetString(s, s2)
         end else Fehler ('Nach "Do Def[ine] Counter" muss noch der Name des Zhlers kommen.', s)
      end else If SucheUndKuerze('Inc Counter', s) then begin
         If GetString(s, s2) then begin
            If Not (SucheUndKuerze(',', s) and GetString(s, s3)) then s3 := '';
            IncCounter(s2, s3)
         end else Fehler ('Nach "Do Inc Counter" muss noch der Name des Zhlers kommen.', s)
      end else If SucheUndKuerze('Save Changes', s) then begin
         If Changed or (slIntro.Count>0) then begin
            Artikel_vollenden;
            ErsetzeArtikel (Opt);
            Artikel_weiter_bearbeiten
         end
      end else If SucheUndKuerze('Touch', s) then begin
         If GetString(s, s2) and (Trim(s)='')
            then TouchGroups(s2)
            else Fehler ('Korrekte Syntax: "Do Touch <Gruppenauswahl>", wobei <Gruppenauswahl> als regulrer Ausdruck interpretiert wird.', s)
      end else Fehler('Unbekannter Do-Befehl "'+s+'" (z.Z. nur "Include", "Show", "Export as", "Inc Counter", '
         +'"Copy to Group", "Exec", "Open", "Print", "Touch", "Sort" und "Replace" erlaubt)', s)
      {$ELSE}
      end else Fehler('Unbekannter Do-Befehl "'+s+'" (z.Z. nur "Include", "Exec", "Open", "Print", "Sort Header" und "Replace" erlaubt)', s)
      {$ENDIF}
   end else SetHeader := true;

   { Normale Headereintrge }
   If SetHeader then begin
      If Copy(Trim(s), 1, 1)='%' then Fehler('Variablenzuweisungen mssen mit "Set" eingeleitet werden!', s);
      If Split_Headerzeile (s, AktHeader, AktInhalt) then begin
         TestHeader (AktHeader);
         If Not RawMode then AktInhalt := InterpreteWildCards(AktInhalt);
         AktInhalt := HeaderMIMEKodierung(AktInhalt);
         With TStringlist.Create do try
            Text := AktInhalt;
            For i := Count-1 downto 1 do begin
               If Strings[i]='' then Delete(i)
               else If NOT (Strings[i][1] IN [' ', #9]) then Strings[i]:=' '+Strings[i]
            end;
            AktInhalt := Text;
            While (AktInhalt > '') and (AktInhalt[Length(AktInhalt)] IN [#13, #10])
               do System.Delete(AktInhalt, Length(AktInhalt), 1)
         finally
            free
         end;
         With Artikel.Header do If AppendHeader then begin
            p := Position (AktHeader);
            If p >= 0 then Insert(p+1, AktHeader + ': ' + AktInhalt)
                      else Add (AktHeader + ': ' + AktInhalt)
         end else begin
            If Change(AktHeader, AktInhalt) then Changed := true
         end
      end else begin
         If Length(s)>43 then s :=Copy(s,1,40)+'...';
         Fehler('Die Zeile "'+s+'" enthlt weder einen bekannten Befehl (Set, Append, If, ...)'
                 +', noch eine gltige Header-Zuweisung a la "X-Header: Inhalt", bitte auskommentieren '
                 +'(mit ";") oder korrigieren.', s)
      end
   end

end;

Procedure InterpreteLine (Var s: String; Const Typ: TZeilentyp; Var ML: Integer);
Var ok, b: boolean; s2, s3: String; ab, bis, step: Double; 
begin
   ML := 0;
   { Kommentare }
   If (s > '') and Not (s[1] IN['#', ';', ':']) then begin
      { Multi-Line... }
      While (s[Length(s)]='_') and (Skript.Zeile+ML < Skript.Count) do begin
         Inc(ML); s := Trim ( Copy(s, 1, Length(s)-1) + Skript[Skript.Zeile-1+ML].Inhalt)
      end;
      { If? }
      Case Typ of
         ztLine: begin
            If SucheUndKuerze('if', s) then begin
               b := TestBedingung(s);
               If SucheUndKuerze('then', s) and (Trim(s)>'') then begin
                  If b and Bed[Level] then InterpreteCommand(s)
               end else If Trim(s)>'' then
                  Fehler ('Nach "If <Bedingung>" ist nur ein "then" zulssig, "'+s+'" ist nicht sinnvoll interpretierbar!', s)
               else begin
                  If Level = High(TLevel)
                     then Fehler('Die maximale Anzahl ('+IntToStr(Level)+') an If-Schachtelungen wurde berschritten!', s); 
                  Inc(Level);
                  Bed[Level] := Bed[Level-1] and b;
                  Done[Level] := (Not Bed[Level-1]) or Bed[Level]; { Erledigt, wenn Vorebene gesperrt oder If-Zweig gltig }
               end
            { "Else If" }
            end else If SucheUndKuerze('elseif', s) or SucheUndKuerze('else if', s) then begin
               If Level > 0 then begin
                  If Not Done[Level] then begin
                     Bed[Level] := TestBedingung(s);
                     If Bed[Level] then Done[Level] := true
                  end else Bed[Level] := false
               end else Fehler('Kein passendes "If" zum "EndIf"', s)
            { "Else" }
            end else If Lowercase(s)='else' then begin
               If Level > 0 then begin
                  Bed[Level] := Not Done[Level]; Done[Level] := true
               end else Fehler('Kein passendes "If" zum "EndIf"', s)
            { "If" beenden }
            end else If Lowercase(Copy(s,1,5)) = 'endif' then begin
               If Level > 0 then Dec(Level) else Fehler('Kein passendes "If" zum "EndIf"', s)
            { Normale Zeile }
            end else If Bed[Level] then begin
               InterpreteCommand (s)
            end
         end;
         ztFor, ztForNext: If Bed[Level] then begin
            If SucheUndKuerze('For', s) then begin
               ok := false;
               If (GetVarname(s, s2) <> vnIllegal)
                  and SucheUndKuerze('=', s)
                  and GetNumber (s, ab)
                  and SucheUndKuerze('to', s)
                  and GetNumber (s, bis)
               then begin
                  Step := 1;
                  If SucheUndKuerze('Step', s) and GetNumber(s, Step) then;
                  If SucheUndKuerze('do', s) then begin
                     ok := true;
                     If (Ab=Bis) or (Sgn(Bis-Ab) = Sgn(Step)) then Repeat
                        SetVarValue (s2, ToStr(Ab));
                        s3 := s; InterpreteCommand(s3);
                        Ab := Ab + Step
                     Until Sgn(Bis-Ab) <> Sgn(Step)
                  end else begin
                     ok := (Trim(s) = '');
                     If Abs(Step) < 0.0000000001 then Fehler('Schrittweite in For-Variable darf nicht gleich 0 sein!', '');
                     If ok then ForNextOnStack (Skript.Zeile, s2, Ab, Bis, Step);
                     TestNext
                  end
               end;
               If not ok then Fehler('Falsche "For"-Syntax: For %Variable% = <Anfangswert> to <Endwert> [ Step <Schrittweite> ] wre korrekt!', s)
            end
         end;
         ztNext: If Bed[Level] then TestNext;
         ztDo: If Bed[Level] then LoopOnStack (Skript.Zeile);
         ztLoop: If Bed[Level] then TestLoop;
         ztRepeat: If Bed[Level] then RepeatOnStack (Skript.Zeile);
         ztUntil: If Bed[Level] then TestUntil;
         ztWhile: If Bed[Level] then begin
            If SucheUndKuerze('While', s) and (Trim(s)>'')
               then begin WhileOnStack (Skript.Zeile, s); TestWend end
               else Fehler('Falsche "While"-Syntax: While <Bedingung>', s)
         end;
         ztWend: If Bed[Level] then TestWend;
         ztSub: begin
            If SucheUndKuerze('Sub', s) then begin
               Repeat
                  Skript.Zeile := Skript.Zeile + 1;
                  If Skript.Zeile > Skript.Count then Fehler('Kein "End sub" fr "Sub '+s+'"', '')
               Until Skript[Skript.Zeile-1].Typ = ztEndsub
            end
         end;
         ztEndSub: TestEndsub;
      end
   end
end;

Procedure Stop;
begin
   Retry := rEndProgram; Abort
end;

Function FindSub (Const Bez: String; Var Z: Integer; Var Pars: String): boolean;
Var v, s: String; i: Integer;
begin
   Result := false;
   v := LowerCase('Sub '+Bez);
   For i:=0 to Skript.Count-1 do begin
      s := LowerCase(Trim(Skript[i].Inhalt));
      If Copy(s, 1, Length(v)) = v then begin
         Z := i; s := Copy(s, Length(v)+1, Length(s));
         If (s = '') or (s[1] IN[' ', '(', ^I]) then begin
            s := Trim(s);
            If s > '' then begin
               If not Klammerung(s, Pars, true) then Pars := s
            end else begin
               Pars := ''
            end;
            Result := true; exit
         end
      end
   end
end;

Function FindGoto (Const Bez: String; Var Z: Integer): boolean;
Var v, s: String; i: Integer;
begin
   Result := false;
   v := LowerCase(':'+Bez);
   For i:=0 to Skript.Count-1 do If Skript[i].Typ = ztLabel then begin
      s := LowerCase(Trim(Skript[i].Inhalt));
      If s = v then begin
         Z := i; Result := true; exit
      end
   end
end;

Procedure ExecLine;
Var ML: Integer; s: String;
begin
   s := Trim(Skript[Skript.Zeile-1].Inhalt);
   {Retry := rNone;}
   try
      {If Skript.Zeile > 123 then Assert(Inttostr(Skript.Zeile) + ': '+ s);}
      InterpreteLine (s, Skript[Skript.Zeile-1].Typ, ML);
      Case Retry of
         rRetryLine: ;
         rJumpNextLineAndStop: begin Fehler('', ''); Skript.Zeile := Skript.Zeile + ML + 1 end;
         else Skript.Zeile := Skript.Zeile + ML + 1
      end;
   except
      On EAbort do Case Retry of
         rJumpNextLineAndRun: begin Skript.Zeile := Skript.Zeile + ML + 1; Retry := rNone end;
         rJumpNextLineAndStop: Skript.Zeile := Skript.Zeile + ML + 1;
         rEndProgram: exit;
         rRetryLine: Retry := rNone;
         else Exit
      end
   end
end;

Procedure Check_ExtraHeader_einsetzen;
begin
   Level := 0;
   Bed[Level] := true;
   Retry := rNone;
   Skript.Zeile := 1;
   While (Skript.Zeile <= Skript.Count) and (Retry <> rEndProgram) do ExecLine
end;

{ --------------------------------------------------------------------- }

Procedure Check_Empfaengerliste (Const Always: boolean);

   Procedure ExtrahiereAdressen (Const Adr: String; sl: TStringlist);
   Var i, p: Integer; s, s2, s3, s4, AktAdr: String;
   begin
      s := Adr;
      { Alles zwischen Anfhrungsstrichen eleminieren }
      Repeat
         p := pos('"', s);
         If p > 0 then begin
            For i:=p+1 to Length(s) do If s[i]='"' then begin
               s := Copy(s, 1, p-1) + Copy(s, i+1, Length(s)-i);
               break
            end
         end
      Until p = 0;
      { Mailadressen extrahieren }
      While s > '' do begin
         p := pos(',', s);
         If p>0 then begin s2 := Copy(s,1,p-1); s := Copy(s,p+1,Length(s)-p) end
                else begin s2 := s; s := '' end;
         ExtractMailParts (s2, s3, s4, AktAdr);
         If Pos('@', AktAdr)>0 then sl.Add ('<'+Trim(AktAdr)+'>')
      end
   end;

Var Neuaufbau: boolean; i, p1, p2: Integer; s: String; sl1, sl2: TStringlist;
begin With Artikel do begin
   p1 := Header.Position (HamsterFrom);
   p2 := Header.Position (HamsterTo);
   If Always or ((p1 >= 0) and (p2 >= 0)) then begin
      If p1 < 0 then p1 := 0;
      If p2 < 0 then p2 := 0;
      sl1 := TStringlist.Create;
      sl2 := TStringlist.Create;
      try
         With sl1 do For i := p2 to Header.Count-1 do begin
            s := Header[i];
            If s = '' then break;
            If LowerCase(Copy(s, 1, Length(HamsterTo))) = LowerCase(HamsterTo)
               then Add (Copy(s, Length(HamsterTo)+3, Length(s)))
         end;
         ExtrahiereAdressen(Header.Inhalt('To', hiOriginalOhneCRs), sl2);
         ExtrahiereAdressen(Header.Inhalt('CC', hiOriginalOhneCRs), sl2);
         ExtrahiereAdressen(Header.Inhalt('BCC', hiOriginalOhneCRs), sl2);
         { Liste passend? Gleiche eleminieren ... }
         Neuaufbau := false;
         For i := sl2.Count-1 downto 0 do begin
            If sl1.IndexOf (sl2[i]) >= 0 then begin
               sl1.Delete(sl1.IndexOf (sl2[i]));
            end else Neuaufbau := true
         end;
         Neuaufbau := Neuaufbau or (sl1.Count > 0);
         { ggf. neu erstellen }
         If NeuAufbau then begin
            Repeat
               p2 := Header.Position (HamsterTo);
               If p2 >= 0 then Header.Delete(p2)
            Until p2 < 0;
            With sl1 do For i:=Count-1 downto 0 do
               Header.Insert (p1+1, HamsterTo + ': ' + Strings[i]);
            With sl2 do For i:=Count-1 downto 0 do
               Header.Insert (p1+1, HamsterTo + ': ' + Strings[i]);
            Changed := true
         end
      finally sl1.free; sl2.free end
   end
end end;

{ --------------------------------------------------------------------- }

{$IFDEF CopyIf}
{$ELSE}
Procedure Check_Fussnoten;
Const FN_Format = '[%d]';

   Function Test (Var Ges: String): boolean;
   Var Start, p, p2, L, Level: Integer; s, Rest, FNText: String; {Endz: Char;}
   begin
      Result := false;
      Level := 0;
      Repeat
         Start := Pos(FN.Anfang, Ges);
         If Start > 0 then begin
            Rest := Copy(Ges, Start+Length(FN.Anfang), Length(Ges));
            Level := 1; p := 0; L := Length(Rest);
            Repeat
               Inc(p);
               If Rest[p] = FN.Anfang[1] then begin
                  If Copy(Rest, p, Length(FN.Anfang))=FN.Anfang then Inc(Level);
               end;
               If Rest[p] = FN.Ende[1] then begin
                  If Copy(Rest, p, Length(FN.Ende))=FN.Ende then Dec(Level)
               end;
            Until (Level = 0) or (p >= L-1);
            If Level = 0 then begin
               Result := true;
               FNText := Copy(Rest, 1, p-1);
               // Alles vor der Funote
               Ges := Copy(Ges, 1, Start-1) + Format(FN_Format, [slFN.Count+1]);
               // Die Zeile, in der die Funote begann in Rest bernehmen
               p2 := Length(Ges);
               While (p2>0) and (Ges[p2]<>#10) do Dec(p2);
               If p2>0 then begin
                  s := Copy(Ges, p2+1, Length(Ges)-p2);
                  Delete (Ges, p2+1, Length(s))
               end else begin
                  s := Ges; Ges := ''
               end;
               Rest := s + Copy(Rest, p+Length(FN.Ende), Length(Rest));
               // Kompletten Absatz um Funote ermitteln
               s := '';
               Repeat
                  p := Pos(#13#10, Rest);
                  If s > '' then If s[Length(s)]<>' ' then s := s + ' ';
                  If p=0 then begin
                     s := s + Rest; Rest := ''; break
                  end else begin
                     {Endz := Rest[p-1];}
                     s := s + Copy(Rest, 1, p-1); Delete(Rest, 1, p+1);
                     If (p=1) {or (Endz IN ['.','!','?',':'])} then BREAK
                  end
               Until false;
               // Absatz neu umbrechen
               s := WordWrap(s, '', FN.Breite);
               If Rest > '' then Rest := s + #13#10 + Rest else Rest := s;
               // und anhngen...
               Ges := Ges + Rest;
               // Funote erzeugen
               slFN.Add (FNText)
            end
         end
      Until (Start = 0) or (Level > 0)
   end;

Var Ges, s, Vorzeile: String; i, j, k, p: Integer; b: boolean;
begin
   i := 0; b := false;
   While i < Artikel.Body.Count do begin
      s := DecodeBodyString(Artikel.Body[i]);
      if (Pos(FN.Anfang, s)>0) and Not (s[1] IN['>', '|']) then begin
         Ges := s; j := i+1;
         Repeat
            { Zeile noch zu Absatz gehrig? }
            If  j = Artikel.Body.Count then break;
            Vorzeile := s; s := DecodeBodyString(Artikel.Body[j]);
            b := (s>'') and Not ((s+' ')[1] IN['>', '|']);
            If b then begin
               p := Pos(' ', s); If p=0 then p := Length(s)+1;
               b := (Length(Vorzeile) + p + 5) > FN.Breite
            end;
            { Dann weitermachen }
            If b then begin
               Ges := Ges + #13#10 + s; Inc(j)
            end
         Until Not b;
         If Test(Ges) then begin
            b := true;
            For k := i to j-1 do Artikel.Body.Delete(i);
            While Ges > '' do begin
               p := Pos(#13#10, Ges);
               If p>0 then begin
                  Artikel.Body.Insert(i, EncodeBodyString(Copy(Ges, 1, p-1)));
                  Delete (Ges, 1, p+1); Inc(i)
               end else begin
                  Artikel.Body.Insert(i, EncodeBodyString(Ges)); Ges := ''
               end
            end
         end
      end;
      Inc(i)
   end;

   {
   Ges := Artikel.Body.Text;
   If Test (Ges) then begin }
   If b then begin
      i := 0;
      While i < slFN.Count do begin
         s := slFN[i];
         While Test(s) do slFN[i] := s;
         slFN[i] := EncodeBodyString(s);
         Inc (i)
      end;
      {Artikel.Body.Text := Ges;}
      Changed := true
   end
end;

Function KuerzeLeerzeilenAmEnde(Const s: String): String;
Var L: Integer;
begin
   Result := s;
   L := Length(Result);
   While (L>2) and (Result[L-1]=#13) and (Result[L]=#10) do begin
      Dec(L, 2); Delete(Result, L+1, 2)
   end
end;

Procedure Check_AppendFussnoten;
Const FN_Format = '[%d]';

   Function Combine (Const Org: String): String;
   Var i, j, p: Integer; s: String;
   begin
      With TStringlist.Create do try
         Text := Org;
         Result := '';
         For i := 0 to Count-1 do begin
            s := Strings[i];
            If s = '' then Result := Result + #13#10 + #13#10
            else begin
               If Result > '' then Case Result[Length(Result)] of
                  '-': System.Delete(Result, Length(Result), 1);
                  ' ', ^I: ;
                  '.','!','?',':': begin
                     For j := i to Count-1
                        do Result := Result + #13#10 + Strings[j];
                     EXIT
                  end;
                  else Result := Result + ' '
               end;
               Result := Result + s;
            end
         end;
      finally free end;
      If FN.Zeilenwechsel > '' then Repeat
         p := Pos(FN.Zeilenwechsel, Result);
         If p > 0 then begin
            Delete(Result, p, Length(FN.Zeilenwechsel));
            Insert(#13#10, Result, p)
         end
      Until p = 0
   end;

Var s, s2, Nr, Leer: String; i, j: Integer; 
begin
   { Einsetzen }
   s := KuerzeLeerzeilenAmEnde(Artikel.Body.text);
   s := s + #13#10;
   If FN.Titel > '' then begin
      s := s + #13#10 + EncodeBodyString(FN.Titel);
      If FN.TitelUnterstreichen then begin
         s := s + #13#10;
         For i := 1 to Length(FN.Titel) do s := s + FN.UnterstreichenMit;
         If FN.TitelLeerzeile then s := s + #13#10
      end
   end;
   For i := 1 to slFN.Count do begin
      Nr := Format(FN_Format, [i]);
      // Bei mehr als 10 Funoten ggf. einrcken
      If (slFN.Count > 9) and (i < 10) then Nr := ' '+Nr;
      // Einrckung fr Zeile 2 aufwrts
      Leer := Nr+' '; For j:=1 to Length(Nr) do Leer[j] := ' ';
      // Einrckung erste Zeile mit X, um Fehlumbrche zu vermeiden
      s2 := Nr+'X'; For j := 1 to Length(Nr) do s2[j] := 'X';
      // Umbruch durchfhren
      s2 := WordWrap(s2 + Combine(Trim(slFN[i-1])), Leer, FN.Breite);
      // Einrckung erste Zeile korrigieren
      For j:=1 to Length(Nr)+1 do
         If j <= Length(Nr) then s2[j] := Nr[j] else s2[j] := ' ';
      // und fertig...
      s := s + #13#10 + s2
   end;
   Artikel.Body.Text := s
end;
{$ENDIF}

{ --------------------------------------------------------------------- }

{$IFDEF CopyIf}
{$ELSE}
Procedure Check_Reformat;
Var Start, Ende, j: Integer; s, s2, Erkennung1, Erkennung2: String;
begin
   Erkennung1 := Extra.Anfang_Reformat;
   Erkennung2 := Extra.Ende_Reformat;
   Start := 0;
   While Start < Artikel.Body.Count do begin
      If Copy(DecodeBodyString(Artikel.Body[Start]), 1, Length(Erkennung1)) = Erkennung1 then begin
         Ende := -1;
         For j := Start to Artikel.Body.Count-1 do begin
            s := DecodeBodyString(Artikel.Body[j]);
            If Length(s) >= Length(Erkennung2) then begin
               If Copy(s, Length(s)-Length(Erkennung2)+1, Length(Erkennung2)) = Erkennung2 then begin
                  Ende := j; Break
               end
            end;
            If Trim(s) = '' then Break
         end;
         If Ende > 0 then begin
            s := '';
            For j := Start to Ende do begin
               s2 := Trim(DecodeBodyString(Artikel.Body[Start]));
               While (s2>'') and (s2[1] IN[' ','>','|']) do Delete(s2, 1, 1);
               If s > '' then s := s + ' ';
               s := s + s2;
               Artikel.Body.Delete(Start)
            end;
            s := Copy(s, Length(Erkennung1)+1, Length(s)-Length(Erkennung1)-Length(Erkennung2));
            s2 := '';
            For j := 1 to Length(s) do Case s[j] of
               ' ', '>', '|': s2 := s2 + s[j];
               else break
            end;
            Artikel.Body.Insert(Start, WordWrap(s, s2, FN.Breite));
            Changed := true
         end
      end;
      Inc(Start)
   end
end;
{$ENDIF}

{ --------------------------------------------------------------------- }

{$IFDEF CopyIf}
{$ELSE}
Procedure Check_Oneliner;
Var Start, Ende, j: Integer; s, Erkennung1, Erkennung2: String;
begin
   Erkennung1 := Extra.Anfang_Oneliner;
   Erkennung2 := Extra.Ende_Oneliner;
   Start := 0;
   While Start < Artikel.Body.Count do begin
      If Copy(DecodeBodyString(Artikel.Body[Start]), 1, Length(Erkennung1)) = Erkennung1 then begin
         Ende := -1;
         For j := Start to Artikel.Body.Count-1 do begin
            s := DecodeBodyString(Artikel.Body[j]);
            If Length(s) >= Length(Erkennung2) then begin
               If Copy(s, Length(s)-Length(Erkennung2)+1, Length(Erkennung2)) = Erkennung2 then begin
                  Ende := j; Break
               end
            end;
            If Trim(s) = '' then Break
         end;
         If Ende > 0 then begin
            s := '';
            For j := Start to Ende do begin
               s := s + DecodeBodyString(Artikel.Body[Start]);
               Artikel.Body.Delete(Start)
            end;
            s := Copy(s, Length(Erkennung1)+1, Length(s)-Length(Erkennung1)-Length(Erkennung2));
            Artikel.Body.Insert(Start, s);
            Changed := true
         end
      end;
      Inc(Start)
   end
end;
{$ENDIF}

{ --------------------------------------------------------------------- }
{$IFDEF CopyIf}
{$ELSE}
Procedure Check_BodyKorrekturen;
Var i, j, k, l, p, KorrigiereEinrueckung: Integer;
    s, s2, s3, Quotechars: String;
    DoNotChange, checkBody: boolean;
begin
   KorrigiereEinrueckung := 0;
   checkBody := true;
   DoNotChange := false;

   If LowerCase(Artikel.Header.Inhalt('X-Check-Body', hiOriginal)) = 'false' then exit;

   With Artikel do With Body do For i:=0 to Count-1 do begin
      s := Strings[i];
      If Not CheckBody then break;
      If s > '' then begin
         If RegEx.MatchRS(Opt.DoNotChangeBegin, s) then DoNotChange := true;
         If RegEx.MatchRS(Opt.DoNotChangeEnd, s) then DoNotChange := false;
         If Opt.DontCheckSig then
            If (qp and (s = '--%20')) or (Not qp and (s = '-- '))
               then DoNotChange := true
      end;
      If DoNotChange then Continue;
      { Signaturtrenner korrigieren }
      { "Needless" qp }
      If (Opt.ConvertQPTo = kOptimizeQP) and qp then If (Length(s)<5) or (Copy(s,Length(s)-4,5)<>'--=20') then begin
         While Copy(s,Length(s)-2,3)='=20' do s := Copy(s,1,Length(s)-3);
         If s<>Strings[i] then begin Changed := true; Strings[i] := s end
      end;
      { Delete at begin }
      With Opt do If (DelAtBegin > '') and (Copy(s, 1, Length(DelAtBegin))=DelAtBegin) then begin
         s := Copy(s, Length(DelAtBegin)+1, Length(s)); Strings[i] := s; Changed := true
      end;
      { Einrckungen korrigieren }
      If Opt.CheckQuotes and (s>'') then begin
         Quotechars := '';
         If Pos(s[1], Opt.AllowedQuoteChars)>0 then begin
            For j:=1 to Length(s) do begin
               If Pos(s[j], Opt.AllowedQuoteChars)>0 then begin
                  If Opt.SpaceBetweenDifferentQuoteChars and (Quotechars > '')
                     and (QuoteChars[Length(QuoteChars)] <> s[j])
                  then
                     Quotechars := Quotechars + ' ';
                  Quotechars := Quotechars + s[j]
               end else Case s[j] of
                  ' ':
                     If (j < Length(s)) and (s[j-1] = ' ') then begin
                        break
                     end;
                  else begin
                     KorrigiereEinrueckung := 0; break
                  end
               end
            end;
            If (Not Opt.AddSpaceBetweenQuoteAndText) and (j>2)
               and (s[j]=' ') and (s[j-1]=' ')
            then begin
               Dec(j) {; If (Length(s)>(j+2)) and (s[j+2]=' ') then Inc(j)}
            end;
            If Quotechars > '' then begin
               s2 := Quotechars;
               s3 := Copy(s, j, Length(s));
               If (s3 > '') and ((s3 <> '=20') or (not qp)) then begin
                  { Korrigiere Einrueckung von "Unterstreichungen" - Innerhalb von Zitaten }
                  if KorrigiereEinrueckung<>0 then begin
                     l := Length(s2);
                     KorrigiereEinrueckung := KorrigiereEinrueckung - (l-(j-2));
                     If Opt.AddSpaceBetweenQuoteAndText
                        then s2 := s2 + ' '
                        else Inc(KorrigiereEinrueckung);
                     If KorrigiereEinrueckung>0 then
                        For k:=1 to KorrigiereEinrueckung do s2 := s2 + ' ';
                     s2 := s2 + s3;
                     If KorrigiereEinrueckung<0 then
                        For k:=1 to -KorrigiereEinrueckung do
                           If s2[l+1]=' ' then s2 := Copy(s2, 1, l)+Copy(s2, l+2, Length(s2));
                     KorrigiereEinrueckung := l-(j-2)
                  end else begin
                  { Standardzeile  }
                     KorrigiereEinrueckung := Length(s2)-(j-2);
                     If Opt.AddSpaceBetweenQuoteAndText
                        then s2 := s2 + ' '
                        else Dec (KorrigiereEinrueckung);
                     s2 := s2 + s3
                  end;
               end;
               //Assert('#'+s+'# => #'+s2+'# => '+Inttostr(KorrigiereEinrueckung));
               If s<>s2 then begin Changed := true; Strings[i] := s2 end
            end
         end else begin
            { Korrigiere Einrueckung von "Unterstreichungen" - normale Zeile }
            If (KorrigiereEinrueckung<>0) and (s>'') and (s[1]=' ') then begin
               s2 := s;
               For j:=1 to KorrigiereEinrueckung do s2 := ' ' + s2;
               For j:=1 to -KorrigiereEinrueckung do
                  If (s2>'') and (s2[1]=' ') then s2 := Copy(s2, 2, Length(s2)-1);
               If s<>s2 then begin
                  Changed := true; Strings[i] := s2
               end
            end
         end
      end;
      { ggf. falsche Message-ID-Verweise eleminieren }
      s := Strings[i]; p := Pos(FalscheMessageID, s);
      If p > 0 then begin
         Strings[i] := Copy(s, 1, p-1) + RichtigeMessageID + Copy(s, p+Length(FalscheMessageID), Length(s));
         Changed := true
      end
   end
end;
{$ENDIF}

{ --------------------------------------------------------------------- }

{$IFNDEF CopyIf}
Procedure Check_AppendText;
Var s1, s2: String; j: Integer;
begin
   { Einsetzen }
   s1 := KuerzeLeerzeilenAmEnde(Artikel.Body.text);
   s2 := KuerzeLeerzeilenAmEnde(slAppend.text);
   If (Length(s2) > Length(s1)) or (Copy(s1, Length(s1)-Length(s2)+1, Length(s2)) <> s2) then begin
      Changed := true;
      If Artikel.Body.text = #13#10 then
         Artikel.Body.text := slAppend.text
      else begin
         With Artikel.Body do If Count > 0 then begin
            If Opt.BlankBeforeLines and (Strings[Count-1]<>'') then Add('')
         end;
         For j:=0 to slAppend.Count-1 do Artikel.Body.Add (slAppend[j])
      end
   end
end;
{$ENDIF}

{ --------------------------------------------------------------------- }

{$IFNDEF CopyIf}
Procedure Check_ChangeSignature;
begin
   With Artikel do begin
      Sig.Assign (slSig);
      If slSig.Count = 0 then HasSig := false
      else
         If Opt.BlankBeforeSig and (Sig.Count>0) and (Body.Count>0)
            and (Body[Body.Count-1]<>'')
               then Body.Add ('')
   end
end;
{$ENDIF}

{ --------------------------------------------------------------------- }

{$IFDEF CopyIf}
{$ELSE}
Procedure Check_8BitCharsReaction;
Var j: Integer; s, s2: String;
begin
   If (Opt.Undeclared8BitReaction>0) and (Not Artikel.qp) and (Not TestOnly7Bit)
      and (Artikel.Typ IN [atNix, atText])
   then With Artikel do With Header do begin
      If (Position (MIMEVersion) < 0) and (Position(MIMEContentType) < 0) then begin
         Case Opt.Undeclared8BitReaction of
            1: begin
                  Change (MIMEVersion, '1.0');
                  Change (MIMEContentType, 'text/plain; charset=ISO-8859-1');
                  Change (MIMEContentTransfer, MIME_8Bit)
               end;
            2: begin
                  Change (MIMEVersion, '1.0');
                  Change (MIMEContentType, 'text/plain; charset=ISO-8859-15');
                  Change (MIMEContentTransfer, MIME_8Bit)
               end;
            3: With Body do For j := 0 to Count-1 do begin
                  s := Strings[j]; s2 := Sonderzeichen_wandeln(s);
                  If s2 <> s then begin
                     Changed := true; Strings[j] := s2
                  end
               end
         end
      end
   end
end;
{$ENDIF}

{$IFDEF CopyIf}
{$ELSE}
Procedure Check_Lines;
Var Org, Anz: Integer; s: String;
begin
   If Not Opt.SetLines then exit;
   If Artikel.Typ IN [atMIME, atUUEncode] then exit;
   
   With TStringlist.Create do try
      Text := Artikel.Body.Text;
      Anz := Count;
      If Artikel.HasSig or ChangeSig then begin
         Text := Artikel.Sig.Text;
         Anz := Anz + Count + 1
      end;
      s := Artikel.Header.Inhalt ('Lines', hiOriginal);
      Org := 0;
      If s > '' then try Org := StrToInt(s) except end;
      If Org <> Anz then begin
         Artikel.Header.Change ('Lines', IntToStr(Anz));
         changed := true
      end
   finally free end
end;
{$ENDIF}

{ ====================================================================== }

Function Check: boolean;
{$IFNDEF CopyIf} Var j: Integer; s: String; {$ENDIF}
begin
   { Vorbereitungen }
   changed := false; Result := false;
   ChangeSig := false; Only7BitTested := false;

   FuelleSkript;
   slIntro.Clear;
   slVars.Clear; slVarsVal.Clear; slStack.Clear;
   If slOptionenKey.Count > 0 then Opt.ReadSettings (false);
   slOptionenKey.Clear; slOptionenValue.Clear;

   {$IFNDEF CopyIf}
   Check_ConvertQP;
   Check_ConvertBase64;
   {$ENDIF}

   {$IFNDEF CopyIf}
   slBodyHeader.Clear;
   slAppend.Clear; slFN.Clear; slSig.Clear;
   { 1. Durchgang => Subjectkorrektur & manuelle Headereintrge }
   Check_Headeranalyse;
   If opt.SortHeader > '' then SortHeader(Opt.SortHeader);
   {$ENDIF}

   { **** Skript ****** }
   Check_ExtraHeader_einsetzen;

   {$IFNDEF CopyIf}
   { Date-Header setzen }
   j := Artikel.Header.Position (HeaderDate);
   If ((Opt.SetDateHeader = 1) and (j=-1)) or (Opt.SetDateHeader = 2) then begin
      If Opt.DateHeaderTypeGMT
         then s := DT2NNTPDate(NowGMT, true)
         else s := DT2NNTPDate(Now, false);
      Artikel.Header.Change (HeaderDate, s)
   end;
   { Hamster-Empfngerliste berprfen }
   If opt.RecreateRCPT_To then Check_Empfaengerliste (opt.RecreateRCPT_To_Always);
   If opt.HamsterHeaderFirst then SortHeader ('!MAIL FROM, !RCPT TO');

   { Gesamtdurchgang: Body-Check }
   Check_BodyKorrekturen;

   { ggf. Introzeilen setzen }
   If slIntro.Count>0 then Check_SetIntroduction(slIntro);

   { Sonderfunktionen durchfhren }
   If Opt.ConvertFootnotes then Check_Fussnoten;
   If Opt.ConvertReformats then Check_Reformat;
   If Opt.ConvertOneliners then Check_Oneliner;

   { Sinnlose Leerzeilen am Ende lschen }
   If opt.DeleteEmptyLines then With Artikel do begin
      If Not HasSig then With Body do While (Count > 1) and (Trim(Body[Count-1]) = '')
         do begin Delete(Count-1); Result := true end
      else With Sig do While (Count > 0) and (Trim(Sig[Count-1]) = '')
         do begin Delete(Count-1); Result := true end
   end;

   { ggf. Text / Funoten anfgen }
   If FN.Position = fnpVorLines then If slFN.Count>0 then Check_AppendFussnoten;
   If slAppend.Count>0 then Check_AppendText;
   If FN.Position = fnpNachLines then If slFN.Count>0 then Check_AppendFussnoten;
   { Sig anfgen }
   If (Opt.SigFile>'') and Not TestHasSig then begin
      s := 'Set Sig from "'+Opt.SigFile+'"';
      try
         InterpreteCommand (s)
      except
         Fehler ('Achtung! Gewhltes Sigfile "'+Opt.SigFile+'" existiert nicht!', '')
      end
   end;
   If ChangeSig then Check_ChangeSignature;
   { ggf. MIME-Deklaration }
   Check_8BitCharsReaction;
   Check_ConvertQP;
   if Opt.ConvertBoxQuotes then For j:=1 to 9 do ConvertBoxQuotes(j);
   If Opt.CheckOEZitate then Check_OE_Zitate;
   { ggf. Lines-Header korrigieren }
   Check_Lines;
   {$ENDIF}

   If changed then Result := true
end;

{$IFDEF CopyIf}
Procedure CheckPosting (Posting: TStrings; AktOpt: TEinstellungen);
begin
   If Posting.text > '' then begin
      Opt := AktOpt;
      Artikel.Gesamttext := Posting.text;
      FuelleSkript;
      Dateiname := '';
      Check
   end
end;
{$ELSE}
Procedure NewsKorrektur;
Var r: TSearchRec; s: String; AufrufNr, Aufrufe: Integer;

   Procedure Save (Const Dateiname: String);
   Var s: String; Modus: Integer; Cut, p, i, l: Integer;
   begin
      {If FileExists(Dateiname)
         then Modus := fmOpenWrite + fmShareDenyNone
         else }
      If FileExists(Dateiname) then DeleteFile(Dateiname);   
      Modus := fmCreate;
      With TFileStream.Create (Dateiname, Modus) do try
         s := Artikel.Gesamttext; Cut := 0;
         If Length(s)>4 then begin
            If (Copy(s, Length(s)-3, 2) <> #13#10)
                and
               (Copy(s, Length(s)-1, 2) = #13#10)
            then
               Cut := 2
         end;
         If Artikel.IsUnixFile then begin
            p := 1; l := Length(s);
            For i := 1 to l+1 do begin
               If (i>l) or (s[i]=#13) then begin
                  WriteBuffer(s[p], i-p);
                  p := i+1
               end
            end
         end else begin
            If Cut>0 then SetLength(s, Length(s)-Cut);
            WriteBuffer(s[1], Length(s))
         end
      finally
         free
      end
   end;

   Procedure Bearbeite (Const fn: String);
   Var Pfad, s: String;
   begin
      Pfad := ExtractFilePath(fn);
      Artikel.LoadFromFile (fn);
      Dateiname := ExtractFilename(fn);
      If Check or (Opt.ConvertToExt>'') then begin
         s := ChangeFileExt(fn,'.bak');
         If FileExists(s) then DeleteFile(s);
         If Opt.ConvertToExt > '' then
            Save (ChangeFileExt(fn, '.'+Opt.ConvertToExt))
         else begin
            If Opt.MakeBAK then RenameFile (fn, s);
            Save (fn)
         end
      end
   end;

Var Typ, Filename: String;
begin
   { Einstellungen laden }
   Opt := TEinstellungen.Create;
   LoadTextFile ( ExtractFilePath(ParamStr(0))+'lHeader.txt', slSonderheader );
   try
      Aufrufe := ParamCount; If Aufrufe = 0 then Aufrufe := 1;
      Typ := ''; Filename := '';
      If (Aufrufe = 2)
         and (Copy(LowerCase(ParamStr(1)), 1, Length(kTyp)) = LowerCase(kTyp))
         and (Copy(LowerCase(ParamStr(2)), 1, Length(kFilename)) = LowerCase(kFilename))
      then begin
         Typ := Copy(ParamStr(1), Length(kTyp)+1, Length(ParamStr(1)));
         Filename := Copy(ParamStr(2), Length(kFilename)+1, Length(ParamStr(2)));
         Aufrufe := 1
      end;
      For AufrufNr := 1 to Aufrufe do begin
         If Typ = '' then begin
            s := Paramstr(AufrufNr); If s = '' then s := 'Settings'
         end else s := Typ;
         Opt.Dateiname := ExtractFilePath(ParamStr(0))+'Korrnews.ini';
         Opt.Abschnitt := s; Opt.ReadSettings (false);
         With Artikel do begin
            ConvertToSigTrenner := Opt.ConvertToSig;
            SafeReg1 := Opt.SafeReg1;
            SafeReg2 := Opt.SafeReg2;
         end;
         FuelleSkript;
         If Typ > '' then begin
            Bearbeite (Filename)
         end else begin
            If Findfirst(Opt.WorkPath + '*.'+Opt.TestExt, faArchive, r)=0 then begin
               Repeat
                  Bearbeite (Opt.WorkPath + r.Name)
               Until FindNext(r)<>0;
               FindClose(r)
            end
         end
      end
   finally
      Opt.free
   end
end;
{$ENDIF}


initialization
   Bed[Low(Bed)] := true;
   Randomize;
   Skript := TSkript.Create;
   slIntro := TStringlist.Create;
   slStack := TStringlist.Create;
   {$IFNDEF CopyIf}
   slBodyHeader := THeader.Create;       slAppend := TStringlist.Create;
   slFN := TStringlist.Create;           slSig := TStringlist.Create;
   {$ENDIF}
   slVars := TStringlist.Create;         slVarsVal := TStringlist.Create;
   slOptionenKey := TStringlist.Create;  slOptionenValue := TStringlist.Create;
   slSonderheader := TStringlist.Create;
   {$IFNDEF CopyIf}
   LoadTextFile(ExtractFilePath(ParamStr(0))+'lHeader.txt', slSonderheader);
   With slSonderheader do If Count = 0 then begin
      Add ('!MAIL FROM');
      Add ('!RCPT TO');
      SaveToFile (ExtractFilePath(ParamStr(0))+'lHeader.txt')
   end;
   {$ENDIF}
   Init_GetString (GetVarNameForGetStr, GetVarValue, EncodeBodyString, Fehler);
   RegZusatzStringFunktionen;
   Init_GetNum (GetString, Fehler);
   RegZusatzNumerischeFunktionen
finalization
   Skript.free;
   slIntro.free;
   slStack.free;
   {$IFNDEF CopyIf}
   slBodyHeader.free; slAppend.free; slFn.free; slSig.free;
   {$ENDIF}
   slVars.free; slVarsVal.free;
   slOptionenKey.free; slOptionenValue.free;
   slSonderheader.free
end.


