unit Settings;

interface

Uses Classes, Windows, uPerlRe;

Const Ver = '3.2';

Type
  TBoxQuoteType = (bqSimple, bqOpened, bqClosed);
  TCfgBoxQuotes = Record
     bDatei: boolean; Typ: TBoxQuoteType;
     Anfangszeile, Trennzeile, Endzeile, Titelumrandung,
     ObereLinkeEcke, UntereLinkeEcke, LinkerRand,
     ObereRechteEcke, UntereRechteEcke, RechterRand: String;
     Oben, Unten: Char;
     ZeilenbreiteOben, ZeilenbreiteUnten: Integer;
     Nutzbar: boolean;
  end;

  TExtra = Record
     Anfang_Oneliner, Ende_Oneliner,
     Anfang_Reformat, Ende_Reformat: String;
  end;

  TFNPos = (fnpVorLines, fnpNachLines);
  TCfgFootnotes = Record
     Titel, Anfang, Ende, Zeilenwechsel: String;
     Breite: Integer;
     TitelUnterstreichen, TitelLeerzeile: Boolean;
     UnterstreichenMit: Char;
     Position: TFNPos;
     Nutzbar: boolean;
  end;
  TArrayCfgBoxQuotes = Array[1..9] of TCfgBoxQuotes;

  TEinstellungen = Class
    private
      Function GetParam (Const Abschn, Bez, Def: String): String;
    Public
      {$IFDEF CopyIf}
      Simulate, CopyIfExist, Mailinfo, CheckXPostingsOnlyOnce: boolean;
      IgnoreGroups, DontIgnoreGroups, AddToMessageID: String;
      lIgnoreGroups, lDontIgnoreGroups, lCounter: TStringlist;
      NewGroups_TestMax, TestMaxPostings: Integer;
      ShowResultAlways, ShowResultIfAction, ShowResultIfCounter,
        ShowOnlyCounterGreaterThanNull, ShowTaskBarEntry,
        ShowFoundedPostingsWhenSimulate: boolean;
      {$ELSE}
      CheckMIMEHeaders, CheckReplaceSubject8Bits, CheckQuotes, AddSpaceBetweenQuoteAndText,
         SpaceBetweenDifferentQuoteChars, DontCheckSig, CheckKillWasAfterRe, AllowXHeader,
         AllowAnyHeader, DelDoubleRes, FoldingReferences, DateHeaderTypeGMT, MakeBAK,
         DeleteEmptyLines, BlankBeforeSig, BlankBeforeLines, HamsterheaderFirst,
         RecreateRCPT_To, SetLines, RecreateRCPT_To_Always, CheckFromReplyFormat,
         CheckOEZitate, ConvertBoxQuotes, ConvertFootnotes, ConvertOneliners,
         ConvertReFormats, ConvertBase64: Boolean;
      ConvertToSig, AllowedQuoteChars, DoNotChangeBegin, DoNotChangeEnd, ConvertToRe,
         LFalseRes, TestExt, ConvertToExt, WorkPath, FilePath, HeaderDef,
         SigFile, DelAtBegin, SortHeader: String;
      LKillMessageIDBegins, LDelXHeader: TStringlist;
      MaxReferencesLen, SetDateHeader, Undeclared8BitReaction, ConvertQPTo,
      SafeReg1, SafeReg2: Integer;
      {$ENDIF}
      ExtraKeys, ExtraValues: TStringlist;
      Dateiname: String; Abschnitt: String;
      Constructor Create;
      Destructor Destroy; override;
      Procedure ReadSettings (Const LeerAlsLeer: boolean);
      Procedure NoActions;
      Procedure WriteSettings;
  end;
  Var
     BQ: TArrayCfgBoxQuotes;
     FN: TCfgFootnotes;
     Extra: TExtra;

  Const kOptimizeQP = 1; kQPTo8Bit = 2; kQPTo7Bit = 3;

Function Left(Const s: String; Const l: Integer): String;
Function Right(Const s: String; Const l: Integer): String;

Procedure StrToStrings (Const Org: String; l: TStrings;
    Const Trenner: Char; Const Clearfirst: boolean);
Function StringsToStr(l: TStrings; Const Trenner: Char): String;

Procedure Register_AddToMessageID (Const s: String);

Procedure ReadBoxQuoteSettings;
Procedure WriteBoxQuoteSettings;

Procedure ReadFootNoteSettings;
Procedure WriteFootNoteSettings;

Procedure ReadExtraSettings;
Procedure WriteExtraSettings;

implementation

Uses Inifiles, SysUtils;

Var Ini: TIniFile;

Function Left(Const s: String; Const l: Integer): String;
begin
   Result := Copy(s, 1, l)
end;
Function Right(Const s: String; Const l: Integer): String;
begin
   If l<Length(s) then Result := Copy(s, Length(s)-l+1, l)
                  else Result := s
end;

Procedure StrToStrings (Const Org: String; l: TStrings;
    Const Trenner: Char; Const Clearfirst: boolean);
Var p: Integer; s, s2: String;
begin
   With l do begin
      If ClearFirst then Clear;
      s := Org;
      If s > '' then Repeat
         p := Pos(Trenner, s);
         If p=0 then begin s2 := s; s := '' end
                else begin s2 := Copy(s, 1, p-1); s := Copy(s, p+1, Length(s)-p) end;
         If s2>'' then If IndexOf(s2) < 0 then Add(s2)
      Until s=''
   end
end;
Function StringsToStr(l: TStrings; Const Trenner: Char): String;
Var i: Integer;
begin
   Result := '';
   With l do For i:=0 to Count-1 do begin
      if i>0 then Result := Result + ',';
      Result := Result + Strings[i]
   end
end;

Function TEinstellungen.GetParam (Const Abschn, Bez, Def: String): String;
Var p: Integer;
begin
   Result := Ini.ReadString(Abschn, Bez, Chr(255));
   If Result = Chr(255) then begin
      Ini.WriteString(Abschn, Bez, Def); Result := Def
   end;
   If Assigned(ExtraKeys) then begin
      p := ExtraKeys.IndexOf(LowerCase(Bez));
      If p>=0 then Result := ExtraValues[p]
   end
end;

Function ToRelPath (Const s: String): String;
begin
   If (Copy(s, 1, 1)='\') or (Copy(s, 2, 1)=':')
      then Result := s
      else Result := ExtractFilePath(Paramstr(0)) + s;
   If (Result > '') and (Right(Result, 1) <> '\')
      then Result := Result + '\'
end;

Const Display = 'Display';

{ ------------------------------------------------------------------------- }

Procedure TEinstellungen.ReadSettings (Const LeerAlsLeer: boolean);
Var s: String; {$IFDEF CopyIf} p: Integer; {$ELSE} i: Integer; {$ENDIF}
begin
   Ini := TIniFile.Create(Dateiname);
   With Ini do try
      {$IFDEF CopyIf}
         Simulate := GetParam(Abschnitt, 'TestOnly', '1') = '1';
         CopyIfExist := GetParam(Abschnitt, 'CopyIfExist', '0') = '1';
         MailInfo := GetParam(Abschnitt, 'MailInfo', '1') = '1';
         CheckXPostingsOnlyOnce := GetParam(Abschnitt, 'CheckXPostingsOnlyOnce', '1') = '1';
         NewGroups_TestMax := StrToInt(GetParam(Abschnitt, 'NewGroups_TestMax', '100'));
         TestMaxPostings := StrToInt(GetParam(Abschnitt, 'TestMaxPostings', '0'));
         IgnoreGroups := GetParam(Abschnitt, 'IgnoreGroups', '^local\.,^internal\.,\.all$');
         s := IgnoreGroups;
         With lIgnoreGroups do If s >'' then begin
            Clear;
            Repeat
               p := Pos(',', s);
               If p>0 then begin Add (Copy(s, 1, p-1)); s := Copy(s, p+1, Length(s)-p) end
                      else begin Add (s); s := '' end
            Until s = ''
         end;
         DontIgnoreGroups := GetParam(Abschnitt, 'DontIgnoreGroups', ''); s := DontIgnoreGroups;
         With lDontIgnoreGroups do If s>'' then begin
            Clear;
            Repeat
               p := Pos(',', s);
               If p>0 then begin Add (Copy(s, 1, p-1)); s := Copy(s, p+1, Length(s)-p) end
                      else begin Add (s); s := '' end
            Until s = ''
         end;
         AddToMessageID := GetParam(Abschnitt, 'AddToMessageID', '');
         { Display: }
         ShowResultAlways := GetParam(Display, 'ShowResultAlways', '0') = '1';
         ShowResultIfAction := GetParam(Display, 'ShowResultIfAction', '1') = '1';
         ShowResultIfCounter := GetParam(Display, 'ShowResultIfCounter', '1') = '1';
         ShowOnlyCounterGreaterThanNull := GetParam(Display, 'ShowOnlyCounterGreaterThanNull', '1') = '1';
         ShowTaskBarEntry := GetParam(Display, 'ShowTaskBarEntry', '1') = '1';
         ShowFoundedPostingsWhenSimulate := GetParam(Display, 'ShowFoundedPostingsWhenSimulate', '1') = '1';
      {$ELSE}
         CheckMIMEHeaders := GetParam(Abschnitt, 'CheckMIMEHeaders', '1') = '1';
         CheckReplaceSubject8Bits := GetParam(Abschnitt, 'CheckReplaceSubject8Bits', '0') = '1';
         CheckQuotes := GetParam(Abschnitt, 'CheckQuotes', '1') = '1';
         SetLines := GetParam(Abschnitt, 'SetLines', '1') = '1';
         AddSpaceBetweenQuoteAndText := GetParam(Abschnitt, 'CheckQuotes-AddSpaceBetweenQuoteAndText', '1') = '1';
         SpaceBetweenDifferentQuoteChars := GetParam(Abschnitt, 'CheckQuotes-AddSpaceBetweenDifferentQuoteChars', '1') = '1';
         AllowedQuoteChars := GetParam(Abschnitt, 'CheckQuotes-AllowedQuoteChars', '>|');
         While Pos(' ', AllowedQuoteChars)>0 do Delete(AllowedQuoteChars, Pos(' ',AllowedQuoteChars),1);
         DoNotChangeBegin := GetParam(Abschnitt, 'CheckQuotes-DoNotChange-Begin', '-----BEGIN PGP*');
         DoNotChangeEnd := GetParam(Abschnitt, 'CheckQuotes-DoNotChange-End', '-----END PGP*');
         DontCheckSig := GetParam(Abschnitt, 'CheckQuotes-DoNotChangeAfterSigDelimiter', '1') = '1';
         CheckKillWasAfterRe := GetParam(Abschnitt, 'CheckSubjectKillWasAfterRe', '1') = '1';
         AllowXHeader := GetParam(Abschnitt, 'AllowXHeader', '1') = '1';
         AllowAnyHeader := GetParam(Abschnitt, 'AllowAnyHeader', '0') = '1';
         DeleteEmptyLines := GetParam(Abschnitt, 'DeleteEmptyLines', '1') = '1';
         CheckFromReplyFormat := GetParam(Abschnitt, 'CheckFromReplyFormat', '0') = '1';
         BlankBeforeSig := GetParam(Abschnitt, 'BlankBeforeSig', '0') = '1';
         BlankBeforeLines := GetParam(Abschnitt, 'BlankBeforeLines', '1') = '1';
         HamsterheaderFirst := GetParam(Abschnitt, 'HamsterheaderFirst', '1') = '1';
         RecreateRCPT_To := GetParam(Abschnitt, 'RecreateRCPT_To', '0') = '1';
         RecreateRCPT_To_Always := GetParam(Abschnitt, 'RecreateRCPT_To_Always', '0') = '1';
         CheckOEZitate := GetParam(Abschnitt, 'KillOEWordWraps', '0') = '1';
         ConvertBoxQuotes := GetParam(Abschnitt, 'ConvertBoxQuotes', '0') = '1';
         ConvertFootnotes := GetParam(Abschnitt, 'ConvertFootnotes', '0') = '1';
         ConvertReformats := GetParam(Abschnitt, 'ConvertReFormats', '0') = '1';
         ConvertOneliners := GetParam(Abschnitt, 'ConvertOneLiners', '0') = '1';
         ConvertBase64 := GetParam(Abschnitt, 'ConvertBase64To8Bit', '0') = '1';
         ConvertToSig := GetParam(Abschnitt, 'ConvertToSigDelimiter', '');
         ConvertToRe := GetParam(Abschnitt, 'ConvertToRe', '');
         DelDoubleRes := GetParam(Abschnitt, 'DelDoubleRe', '1') = '1';
         LFalseRes := GetParam(Abschnitt, 'AnswerDesignators', 'AW,Re^2,Re^3,Re^4');
         TestExt := GetParam(Abschnitt, 'CheckFilesWithExtension', 'msg');
         ConvertToExt := GetParam(Abschnitt, 'DontChangeRenameToExtension', '');
         WorkPath := GetParam(Abschnitt, 'MessagePath', '');
         If Not LeerAlsLeer then WorkPath := ToRelPath(WorkPath);
         FilePath := GetParam(Abschnitt, 'FilePath', '');
         If Not LeerAlsLeer then FilePath := ToRelPath(FilePath);
         HeaderDef := GetParam(Abschnitt, 'Header.def', 'Header.def');
         SigFile := GetParam(Abschnitt, 'SigFile', '');
         DelAtBegin := GetParam(Abschnitt, 'DelAtBegin', '');
         SortHeader := GetParam(Abschnitt, 'SortHeader', '');
         MaxReferencesLen := StrToInt('0'+GetParam(Abschnitt, 'MaxReferencesLength', '512'));
         FoldingReferences := GetParam(Abschnitt, 'FoldingReferences', '0') = '1';
         SetDateHeader := StrToInt(GetParam(Abschnitt, 'SetDateHeader', '0'));
         DateHeaderTypeGMT := UpperCase(Copy(GetParam(Abschnitt, 'DateHeaderType', 'Local'),1,1))='G';
         Undeclared8BitReaction := StrToInt(GetParam(Abschnitt, 'Undeclared8BitReaction', '1'));
         ConvertQPTo := StrToInt(GetParam(Abschnitt, 'ConvertQPTo', '1'));

         SafeReg1 := StrToInt(GetParam(Abschnitt, 'SafeReg1', '0'));
         SafeReg2 := StrToInt(GetParam(Abschnitt, 'SafeReg2', '0'));

         StrToStrings(GetParam(Abschnitt, 'KillMessageIDBegins', ''),
            lKillMessageIDBegins, ',', true);
         With TIniFile.Create(ExtractFilePath(ParamStr(0))+'Copyfups.ini') do try
            StrToStrings(ReadString('Settings', 'AddToMessageID', ''),
               lKillMessageIDBegins, ',', false);
         finally free end;
         With TIniFile.Create(ExtractFilePath(ParamStr(0))+'CopyIf.ini') do try
            StrToStrings(ReadString('Settings', 'AddToMessageID', ''),
               lKillMessageIDBegins, ',', false);
         finally free end;
         With TIniFile.Create('win.ini') do try
            StrToStrings(ReadString('TGLs Tools', 'AddToMessageID', ''),
               lKillMessageIDBegins, ',', false);
         finally free end;

         LDelXHeader.Clear;
         For i:=1 to StrToInt(GetParam(Abschnitt, 'DelXHeader', '0')) do begin
            s := GetParam(Abschnitt, 'DelXHeader-'+Inttostr(i), '');
            If (s>'') and (UpperCase(Copy(s,1,2))='X-') then LDelXHeader.Add (s)
         end;

         MakeBak := GetParam(Abschnitt, 'MakeBak', '0') = '1'
      {$ENDIF}
   finally free end
end;

Procedure TEinstellungen.NoActions;
begin
   {$IFDEF CopyIf}
   {$ELSE}
   CheckMIMEHeaders := false;
   CheckReplaceSubject8Bits := false;
   CheckQuotes := false;
   SetLines := false;
   DontCheckSig := true;
   CheckKillWasAfterRe := false;
   AllowXHeader := false;
   AllowAnyHeader := false;
   DeleteEmptyLines := false;
   CheckFromReplyFormat := false;
   HamsterheaderFirst := false;
   RecreateRCPT_To := false;
   CheckOEZitate := false;
   ConvertBoxQuotes := false;
   ConvertFootnotes := false;
   ConvertReformats := false;
   ConvertOneliners := false;
   ConvertBase64 := false;
   ConvertToSig := '';
   ConvertToRe := '';
   DelDoubleRes := false;
   SigFile := '';
   DelAtBegin := '';
   SortHeader := '';
   MaxReferencesLen := 0;
   FoldingReferences := false;
   SetDateHeader := 0;
   Undeclared8BitReaction := 0;
   ConvertQPTo := 0;
   LDelXHeader.Clear;
   {$ENDIF}
end;

Procedure TEinstellungen.WriteSettings;

   Procedure SetBool (Const s: String; Const b: Boolean);
   begin
      If b then Ini.WriteInteger(Abschnitt, s, 1)
           else Ini.WriteInteger(Abschnitt, s, 0)
   end;

{$IFNDEF CopyIf} Var s: String; i: Integer; {$ENDIF}
begin
   Ini := TIniFile.Create(Dateiname);
   With Ini do try
      {$IFDEF CopyIf}
      {$ELSE}
      SetBool('CheckMIMEHeaders', CheckMIMEHeaders);
      SetBool('CheckReplaceSubject8Bits', CheckReplaceSubject8Bits);
      SetBool('CheckQuotes', CheckQuotes);
      SetBool('CheckQuotes-AddSpaceBetweenQuoteAndText', AddSpaceBetweenQuoteAndText);
      SetBool('CheckQuotes-AddSpaceBetweenDifferentQuoteChars', SpaceBetweenDifferentQuoteChars);
      SetBool('SetLines', SetLines);
      WriteString(Abschnitt, 'CheckQuotes-AllowedQuoteChars', AllowedQuoteChars);
      WriteString(Abschnitt, 'CheckQuotes-DoNotChange-Begin', DoNotChangeBegin);
      WriteString(Abschnitt, 'CheckQuotes-DoNotChange-End', DoNotChangeEnd);
      SetBool('CheckQuotes-DoNotChangeAfterSigDelimiter', DontCheckSig);
      SetBool('CheckSubjectKillWasAfterRe', CheckKillWasAfterRe);
      SetBool('AllowXHeader', AllowXHeader);
      SetBool('AllowAnyHeader', AllowAnyHeader);
      SetBool('DeleteEmptyLines', DeleteEmptyLines);
      SetBool('CheckFromReplyFormat', CheckFromReplyFormat);
      SetBool('BlankBeforeSig', BlankBeforeSig);
      SetBool('BlankBeforeLines', BlankBeforeLines);
      SetBool('HamsterheaderFirst', HamsterheaderFirst);
      SetBool('RecreateRCPT_To', RecreateRCPT_To);
      SetBool('RecreateRCPT_To_always', RecreateRCPT_To_always);
      SetBool('KillOEWordWraps', CheckOEZitate);
      SetBool('ConvertBoxQuotes', ConvertBoxQuotes);
      SetBool('ConvertFootnotes', ConvertFootnotes);
      SetBool('ConvertReFormats', ConvertReformats);
      SetBool('ConvertOneliners', ConvertOneliners);
      SetBool('ConvertBase64To8Bit', ConvertBase64);

      WriteString(Abschnitt, 'ConvertToSigDelimiter', ConvertToSig);
      WriteString(Abschnitt, 'ConvertToRe', ConvertToRe);
      SetBool('DelDoubleRe', DelDoubleRes);
      WriteString(Abschnitt, 'AnswerDesignators', LFalseRes);
      WriteString(Abschnitt, 'CheckFilesWithExtension', TestExt);
      WriteString(Abschnitt, 'DontChangeRenameToExtension', ConvertToExt);
      WriteString(Abschnitt, 'MessagePath', WorkPath);
      WriteString(Abschnitt, 'FilePath', FilePath);
      WriteString(Abschnitt, 'Header.def', HeaderDef);
      WriteString(Abschnitt, 'SigFile', SigFile);
      WriteString(Abschnitt, 'DelAtBegin', DelAtBegin);
      WriteString(Abschnitt, 'SortHeader', SortHeader);
      WriteInteger(Abschnitt, 'MaxReferencesLength', MaxReferencesLen);
      SetBool('FoldingReferences', FoldingReferences);
      WriteInteger(Abschnitt, 'SetDateHeader', SetDateHeader);
      If DateHeaderTypeGMT then s := 'GMT' else s := 'Local';
      WriteInteger(Abschnitt, 'Undeclared8BitReaction', Undeclared8BitReaction);
      WriteInteger(Abschnitt, 'ConvertQPTo', ConvertQPTo);
      WriteString(Abschnitt, 'DateHeaderType', s);
      WriteString(Abschnitt, 'KillMessageIDBegins', StringsToStr(lKillMessageIDBegins, ','));

      WriteInteger(Abschnitt, 'SafeReg1', SafeReg1);
      WriteInteger(Abschnitt, 'SafeReg2', SafeReg2);

      With LDelXHeader do begin
         WriteInteger(Abschnitt, 'DelXHeader', Count);
         For i:=1 to Count do
            WriteString (Abschnitt, 'DelXHeader-'+Inttostr(i), Strings[i-1])
      end;

      SetBool('MakeBak', MakeBak)
      {$ENDIF}
   finally free end
end;

Procedure ReadBoxQuoteSettings;
Var i: Integer; s, ab: String; Ini: TInifile;
   Function GetStr (Const Key, Def: String): String;
   begin
      Result := Ini.ReadString (Ab, Key, '');
      If (Length(Result)>2) and (Result[1]='#') and (Result[Length(Result)]='#')
         then Result := Copy(Result, 2, Length(Result)-2);
      If Result = '' then Result := Def
   end;
begin
   Ini := TIniFile.Create(ExtractFilePath(ParamStr(0))+'BoxQuotes.ini');
   With Ini do try
      For i := 1 to 9 do begin
         Ab := 'BQ#'+Inttostr(i);
         With BQ[i] do begin
            Typ := bqSimple;
            try Typ := TBoxQuoteType(ReadInteger(Ab, 'BQType', Ord(bqSimple))) except end;
            bDatei := ReadString(Ab, 'BQFrom', 'T') = 'F';
            Anfangszeile := ReadString(Ab, 'BQStartLine', 'boxquote'+IntToStr(i)+':');
            Trennzeile := ReadString(Ab, 'BQSepLine', '-');
            Endzeile := ReadString(Ab, 'BQEndLine', '#');
            s := ReadString(Ab, 'BQGraphics', '');
            If Length(s) = 8 then begin
               ObereLinkeEcke := s[1];  Oben := s[2]; ObereRechteEcke := s[3];
               LinkerRand := s[4]; RechterRand := s[5];
               UntereLinkeEcke := s[6]; Unten := s[7]; UntereRechteEcke := s[8];
            end else begin
               If Length(s) <> 2 then s := '--';
               Oben := s[1]; Unten := s[2];
               ObereLinkeEcke := GetStr('BQTopLeft', ' ,');
               ObereRechteEcke := GetStr('BQTopRight', '.');
               LinkerRand := GetStr('BQLeft', '| ');
               RechterRand := GetStr('BQRight', ' |');
               UntereLinkeEcke := GetStr('BQBottomLeft', ' `');
               UntereRechteEcke := GetStr('BQBottomRight', ' ');
            end;
            ZeilenbreiteOben := ReadInteger(Ab, 'BQWidthTop', 4);
            ZeilenbreiteUnten := ReadInteger(Ab, 'BQWidthDown', 4);
            Titelumrandung := ReadString(Ab, 'BQTitle', '# [ @ ] #');
            If Copy(TitelUmrandung, 1, 1)='#' then Delete(Titelumrandung, 1, 1);
            If Copy(TitelUmrandung, Length(TitelUmrandung), 1)='#' then Delete(Titelumrandung, Length(TitelUmrandung), 1);
            Nutzbar := (Anfangszeile > '') and (Trennzeile > '') and (Endzeile > '')
         end
      end
   finally free end
end;
Procedure WriteBoxQuoteSettings;
Var i: Integer; ab, s: String;
begin
   With TIniFile.Create(ExtractFilePath(ParamStr(0))+'BoxQuotes.ini') do try
      For i := 1 to 9 do begin
         Ab := 'BQ#'+Inttostr(i);
         With BQ[i] do begin
            Nutzbar := (Anfangszeile > '') and (Trennzeile > '') and (Endzeile > '');
            If bDatei then s := 'F' else s := 'T';
            WriteString(Ab, 'BQFrom', s);
            WriteInteger(Ab, 'BQType', Ord(Typ));
            WriteString(Ab, 'BQStartLine', Anfangszeile);
            WriteString(Ab, 'BQSepLine', Trennzeile);
            WriteString(Ab, 'BQEndLine', Endzeile);
            WriteString(Ab, 'BQGraphics', Oben + Unten);
            WriteString(Ab, 'BQTopLeft', '#'+ObereLinkeEcke+'#');
            WriteString(Ab, 'BQTopRight', '#'+ObereRechteEcke+'#');
            WriteString(Ab, 'BQLeft', '#'+LinkerRand+'#');
            WriteString(Ab, 'BQRight', '#'+RechterRand+'#');
            WriteString(Ab, 'BQBottomLeft', '#'+UntereLinkeEcke+'#');
            WriteString(Ab, 'BQBottomRight', '#'+UntereRechteEcke+'#');
            WriteInteger(Ab, 'BQWidthTop', ZeilenbreiteOben);
            WriteInteger(Ab, 'BQWidthDown', ZeilenbreiteUnten);
            WriteString(Ab, 'BQTitle', '#'+Titelumrandung+'#')
         end
      end
   finally free end
end;


Procedure ReadFootNoteSettings;
Var ab: String;
begin
   With TIniFile.Create(ExtractFilePath(ParamStr(0))+'Footnote.ini') do try
      Ab := 'Footnotes';
      With FN do begin
         try Position := TFNPos(ReadInteger(Ab, 'FNPos', Ord(fnpNachLines)))
         except Position := fnpNachLines end;
         Titel := ReadString(Ab, 'FNTitle', 'Funoten:');
         TitelUnterstreichen := ReadBool (Ab, 'FNUnderline', true);
         TitelLeerzeile := ReadBool (Ab, 'FNTitleEmptyLine', false);
         UnterstreichenMit := (ReadString (Ab, 'FNUnderlineWith', '') + '=')[1];
         Anfang := ReadString(Ab, 'FNBegin', '(FN:');
         Ende := ReadString(Ab, 'FNEnd', '#)');
         Zeilenwechsel := ReadString(Ab, 'FNToCRLF', '///');
         Breite := ReadInteger(Ab, 'FNWordWrapAfter', 72);
         Nutzbar := (Anfang <> Ende) and (Anfang > '') and (Ende > '')
      end
   finally free end
end;
Procedure WriteFootNoteSettings;
Var ab: String;
begin
   With TIniFile.Create(ExtractFilePath(ParamStr(0))+'Footnote.ini') do try
      Ab := 'Footnotes';
      With FN do begin
         Nutzbar := (Anfang <> Ende) and (Anfang > '') and (Ende > '');
         WriteInteger(Ab, 'FNPos', Ord(Position));
         WriteString(Ab, 'FNTitle', Titel);
         WriteString(Ab, 'FNBegin', Anfang);
         WriteString(Ab, 'FNEnd', Ende);
         WriteString(Ab, 'FNToCRLF', Zeilenwechsel);
         WriteInteger(Ab, 'FNWordWrapAfter', Breite);
         WriteBool(Ab, 'FNUnderline', TitelUnterstreichen);
         WriteBool (Ab, 'FNTitleEmptyLine', TitelLeerzeile);
         WriteString(Ab, 'FNUnderlineWith', UnterstreichenMit);
      end
   finally free end
end;

Procedure ReadExtraSettings;
Var ab: String;
begin
   With TIniFile.Create(ExtractFilePath(ParamStr(0))+'Specials.ini') do try
      Ab := 'Oneliner';
      With Extra do begin
         Anfang_Oneliner := ReadString(Ab, 'Begin', 'OL:');
         Ende_Oneliner := ReadString(Ab, 'End', '#');
      end;
      Ab := 'Reformat';
      With Extra do begin
         Anfang_Reformat := ReadString(Ab, 'Begin', 'RF:');
         Ende_Reformat := ReadString(Ab, 'End', '#');
      end
   finally free end
end;
Procedure WriteExtraSettings;
Var ab: String;
begin
   With TIniFile.Create(ExtractFilePath(ParamStr(0))+'Specials.ini') do try
      Ab := 'Oneliner';
      With Extra do begin
         WriteString(Ab, 'Begin', Anfang_Oneliner);
         WriteString(Ab, 'End', Ende_Oneliner);
      end;
      Ab := 'Reformat';
      With Extra do begin
         WriteString(Ab, 'Begin', Anfang_Reformat);
         WriteString(Ab, 'End', Ende_Reformat);
      end
   finally free end
end;

Constructor TEinstellungen.Create;
begin
   {$IFDEF CopyIf}
   lCounter := TStringlist.Create;
   lIgnoreGroups := TStringlist.Create;
   lDontIgnoreGroups := TStringlist.Create;
   {$ELSE}
   LKillMessageIDBegins := TStringlist.Create;
   LDelXHeader := TStringlist.Create;
   {$ENDIF}
   ExtraKeys := NIL; ExtraValues := NIL
end;

Destructor TEinstellungen.Destroy;
begin
   {$IFDEF CopyIf}
   lCounter.free;
   lIgnoreGroups.free;
   lDontIgnoreGroups.free;
   {$ELSE}
   LKillMessageIDBegins.free;
   LDelXHeader.free
   {$ENDIF}
end;

{ ---------------------------------------------------------------------- }

{$IFDEF CopyIf}
{$ELSE}
Procedure Tests;
Var s, H: String[255]; b1, b2: Boolean;
begin
   s := ExtractFilePath(Paramstr(0))+'Korrnews.Ini';
   H := ExtractFilePath(Paramstr(0))+'Hamster.exe';
   b1 := FileExists(s);
   b2 := FileExists(H);
   If (Not b1) and b2 then begin
      With TEinstellungen.Create do try
         Dateiname := s;
         Abschnitt := 'News'; ReadSettings(true);
         WorkPath := 'Groups\News.Out'; WriteSettings;
         Abschnitt := 'Mails'; WorkPath := 'Mails\Mail.Out'; WriteSettings;
         Abschnitt := 'News'; ReadSettings(true);
      finally
         free;
         s := s + #0;
         WritePrivateProfileString(Nil,Nil,Nil,@s[1])
      end
   end
end;
{$ENDIF}

Procedure Register_AddToMessageID (Const s: String);
Var v: String;
begin
   If s = '' then exit;
   With TIniFile.Create('win.ini') do try
      v := ReadString('TGLs Tools', 'AddToMessageID', '');
      While Pos(',,', v) > 0 do Delete(v, Pos(',,', v), 1); 
      If Copy(v, 1, 1) =',' then Delete(v, 1, 1);
      If (v>'') and (v[Length(v)]=',') then Delete(v, Length(v), 1);
      If Pos(s, ','+v+',') = 0 then begin
         If v = '' then v := s
                   else v := v + ',' + s;
         WriteString('TGLs Tools', 'AddToMessageID', v)
      end
   finally free end
end;

Initialization
   {$IFDEF CopyIf}
   {$ELSE}
   Tests;
   ReadBoxQuoteSettings;
   ReadFootnoteSettings;
   ReadExtraSettings;
   {$ENDIF}
finalization
end.
