unit uVarList;

interface

Uses Classes;

Type
   TRVN = (vnIllegal, vnExist, vnNew);
   TLocalState = (lsGlobalVar, lsLocalVar, lsVarPar, lsPar, lsBeginLocal, lsEndLocal);
   TVarTyp = (vtNil, vtStr, vtFloat, vtInt, vtBool);
   TVarObj = Class
     private
       VStr: String;
       VNum: Double;
       VName: String;
       Function GetInt: LongInt;
       Procedure SetInt (x: LongInt);
       Function GetBool: Boolean;
       Procedure SetBool (x: Boolean);
       Function GetStr: String;
       Procedure SetStr (x: String);
       Function GetFl: Double;
       Procedure SetFl (x: Double);
     public
       Typ: TVarTyp;
       LocalState: TLocalState;
       property Name: String Read VName;
       Property asString: String Read GetStr Write SetStr;
       Property asFloat: Double Read GetFl Write SetFl;
       Property asInteger: LongInt Read GetInt Write SetInt;
       Property asBoolean: Boolean Read GetBool Write SetBool;
   end;
   TVarList = Class
      private
        sl: TStringlist;
        Function ItemByPos (Const Nr: Integer): TVarObj;
        Function ItemByName (Const Bez: String): TVarObj;
        Function _Add (Const Bez: String; Const AktTyp: TVarTyp;
           Const AktLocalState: TLocalState): TVarObj;
        Function _Ins (Const Pos: Integer; Const Bez: String; Const AktTyp: TVarTyp; Const AktLocalState: TLocalState): TVarObj;
        Procedure _Delete (Const Pos: Integer);
      public
        constructor Create;
        destructor Destroy; override;
        Procedure Clear;
        Function Add (Const Bez: String; Const Typ: TVarTyp): TVarObj;
        Function Count: LongInt;
        Property Item [Const Bez: String]: TVarObj Read ItemByName; default;
        Property Items[Const Nr: Integer]: TVarObj Read ItemByPos;
        Function Exists (Const Bez: String): boolean;
        Function AddLocal (Const Bez: String; Typ: TVarTyp): TVarObj;
        Procedure AddLocalVars (Const SubBez: String;
           Const ABez: Array of String; Const ATyp: Array of TVarTyp;
           Const AInh: Array of String; Const AVarTyp: Array of Boolean);
        Procedure RemoveLocalVars;
        Function SucheTypName(Var s: String; Var vt: TVarTyp): boolean;
   end;

implementation

Uses SysUtils, uGetString;

{ TVarObject }

Function TVarObj.GetInt: LongInt;
begin
   Result := Trunc(VNum)
end;
Procedure TVarObj.SetInt (x: LongInt);
begin
   VNum := x;
   VStr := IntToStr(x)
end;
Function TVarObj.GetBool: Boolean;
begin
   Result := VNum <> 0
end;
Procedure TVarObj.SetBool (x: Boolean);
begin
   If x then begin
      VNum := 1;
      VStr := 'True'
   end else begin
      VNum := 0;
      VStr := 'False'
   end
end;

Function TVarObj.GetStr: String;
begin
   Result := VStr
end;

Procedure TVarObj.SetStr (x: String);
Var F: Integer;
begin
   VStr := x;
   Val(x, VNum, F); if F > 0 then VNum := 0 
end;

Function TVarObj.GetFl: Double;
begin
   Result := VNum
end;

Procedure TVarObj.SetFl (x: Double);
begin
   VNum := x;
   VStr := ToStr(x)
end;

{ TVarList }

constructor TVarList.Create;
begin
   sl := TStringlist.Create;
end;

Destructor TVarList.Destroy;
begin
   Clear; sl.free
end;

Procedure TVarList.Clear;
begin
   While sl.Count > 0 do _Delete(0)
end;

Procedure TVarList._Delete(Const Pos: Integer);
begin
   With sl do begin
      Items[Pos].free; Delete(Pos)
   end
end;

Function TVarList._Add (Const Bez: String; Const AktTyp: TVarTyp;
   Const AktLocalState: TLocalState): TVarObj;
Var P: TVarObj;
begin
   P := TVarObj.Create;
   With P do begin
      VName := Bez;
      VStr := '';
      VNum := 0;
      Typ := AktTyp;
      LocalState := AktLocalState;
   end;
   sl.AddObject (UpperCase(Bez), Pointer(P));
   Result := P
end;
Function TVarList._Ins (Const Pos: Integer; Const Bez: String; Const AktTyp: TVarTyp;
   Const AktLocalState: TLocalState): TVarObj;
Var P: TVarObj;
begin
   P := TVarObj.Create;
   With P do begin
      VName := Bez;
      VStr := '';
      VNum := 0;
      Typ := AktTyp;
      LocalState := AktLocalState;
   end;
   sl.InsertObject (Pos, UpperCase(Bez), Pointer(P));
   Result := P
end;

Function TVarList.Add (Const Bez: String; Const Typ: TVarTyp): TVarObj;
begin
   Result := Item[Bez];
   If (Result = NIL) or (Result.LocalState<>lsGlobalVar) then begin
      Result := _Add (Bez, Typ, lsGlobalVar)
   end else begin
      If Result.Typ <> Typ then Result.Typ := Typ
   end
end;

Function TVarList.Count: LongInt;
begin
   Result := sl.Count
end;

Function TVarList.ItemByName(Const Bez: String): TVarObj;
Var i: Integer; SearchNew, V: String; b: boolean; Akt: TVarObj;
begin
   Result := NIL;
   Akt := NIL;
   SearchNew := '';
   V := UpperCase(Bez);
   For i := 0 to Count-1 do begin
      With Items[i] do begin
         b := sl[i] = V;
         Case LocalState of
            // Lokale und globale Variablen sind direkt gltig
            lsLocalVar, lsGlobalVar: If b then Result := Items[i];

            // Parametervariablen durch lokale Variablen berschreibbar,
            // daher erst bei Ende des Local-Parts gltig
            lsPar: If b then begin Akt := Items[i]; SearchNew := '' end;
            // Var-Parameter verweisen auf andere Variablen,
            // Suche kann aber erst nach Ende des Lokalparts erfolgen
            lsVarPar: If b then begin SearchNew := UpperCase(asString); Akt := NIL end;

            lsEndLocal:
               If Assigned(Akt) then
                  Result := Akt
               else If SearchNew > '' then begin
                  V := SearchNew
               end;
         end
      end;
      If Assigned(Result) then break
   end
end;

Function TVarList.ItemByPos (Const Nr: Integer): TVarObj;
begin
   if (Nr < 0) or (Nr > Count-1)
      then Result := NIL
      else Result := TVarObj(sl.Objects[Nr])
end;

Function TVarList.Exists (Const Bez: String): boolean;
begin
   Result := Item[Bez] <> NIL
end;

Function TVarList.AddLocal (Const Bez: String; Typ: TVarTyp): TVarObj;
Var i, p: Integer; b: boolean;
begin
   p := 0; b := false;
   For i := 0 to Count-1 do begin
      With Items[i] do begin
         If Not b then begin
            If LocalState = lsBeginLocal then b := true;
         end else begin
            If LocalState IN[lsEndLocal, lsLocalVar] then begin
               p := i; Break
            end
         end
      end
   end;
   If b
      then Result := _Ins (p, Bez, Typ, lsLocalVar)
      else Result := Add (Bez, Typ)
end;

Procedure TVarList.AddLocalVars (Const SubBez: String;
   Const ABez: Array of String; Const ATyp: Array of TVarTyp;
   Const AInh: Array of String; Const AVarTyp: Array of Boolean);
Var i: Integer;
begin
   _Ins (0, '', vtNIL, lsEndLocal);
   For i:=High(ABez) downto Low(ABez) do If (ABez[i]>'') then begin
      If AVarTyp[i]
         then _Ins(0, ABez[i], ATyp[i], lsVarPar)
         else _Ins(0, ABez[i], ATyp[i], lsPar);
      Items[0].asString := AInh[i]
   end;
   _Ins (0, '', vtNIL, lsBeginLocal);
   Items[0].asString := SubBez
end;

Procedure TVarList.RemoveLocalVars;
Var i, p1, p2: Integer;
begin
   p1 := -1; p2 := -1;
   For i := 0 to Count-1 do begin
      Case Items[i].LocalState of
         lsBeginLocal: p1 := i;
         lsEndLocal: begin p2 := i; break end
      end
   end;
   If (p1>=0) and (p2>=0) then
      For i := p1 to p2 do _Delete(p1)
end;

Function TVarList.SucheTypName(Var s: String; Var vt: TVarTyp): boolean;
begin
   If SucheUndKuerze('Integer', s) then vt := vtInt
   else If SucheUndKuerze('Float', s) then vt := vtFloat
   else If SucheUndKuerze('Boolean', s) then vt := vtBool
   else If SucheUndKuerze('String', s) then vt := vtStr
   else vt := vtNil;
   Result := vt <> vtNIL
end;

// -------------------------------------------------------------------------------------

end.
