unit uHeader;

interface

Uses classes, uCSMap;

Type
  THeaderinhalt = (hiDecoded, hiRaw);

  TChangedStringlist = Class(TStringList)
  private
     Procedure SetStr (i: Integer; S: String);
     Function GetStr (i: Integer): String;
  public
     Changed: boolean;
     Property Strings[i: Integer]: String Read GetStr Write SetStr; default;
     Function Add (Const s: String): Integer; override;
     Procedure Delete (i: Integer); override;
     Procedure Insert (i: Integer; Const s: String); override;
  end;

  THeader = Class (TChangedStringList)
    private
      fCharsets: TCharsets;
      Function GetName (i: Integer): String;
    public
      Constructor Create (Charsets: TCharsets);
      Property Charsets: TCharsets Read fCharsets;
      Property Name [i: Integer]: String Read GetName;
      Function Change (Const H, I: String): boolean;
      Function Position (Const H: String): Integer;
      Function Add (Const s: String): Integer; override;
      Function AddRaw (Const s: String): Integer;
      Function Inhalt (Const H: String; Const hi: THeaderinhalt): String;
      Function InhaltPerPos (Const i: Integer; Const hi: THeaderinhalt): String;
  end;

Function ToHeader (Const s: String): String;
Function Split_Headerzeile (Const Ges: String; Var Header, Inhalt: String): boolean;
Function TestHeadername (Const s: String; Var p: Integer): Boolean;
//Function HeaderDecode (Const p: Integer; Const InclHeader: boolean): String;

implementation

Uses SysUtils, uISO, Settings;

{ ----------------------------------------------------------------------------- }

Const
  HeaderCont = [^I, ' '];
  Headerzeichen = [#33..#128];
(*  Adressfelder = ' from: reply-to: to: '; { lowercase! }
  MaxISOHeaderLen = 76;
  MIMEStdGrenze = [' '];
  MIMELinkeGrenzeFrom = MIMEStdGrenze + ['"', '('];
  MIMERechteGrenzeFrom = MIMEStdGrenze + ['"', ')'];
*)
Var
  slSonderheader: TStringlist;

Function ToHeader (Const s: String): String;
begin
   Result := Trim(s);
   If Result = '' then Exception.Create('bergebener Headername ist leer!');
   If Result[Length(Result)] <> ':' then Result := Result + ':';
   Result := Result + ' '
end;

Function Split_Headerzeile (Const Ges: String; Var Header, Inhalt: String): boolean;
Var p, q: Integer; s: String;
begin
   Result := false; s := Ges;
   If (s='') or (s[1]=' ') then exit;
   p := Pos(':', s); q := Pos('=', s);
   If (p=0) and (q>0) then p:=q;
   While (p>2) and (s[p-1] IN HeaderCont) do begin
      s := Copy(s, 1, p-2) + Copy(s, p, Length(s)-p+1); Dec(p)
   end;
   If (p > 1) then begin
      Header := Copy (s, 1, p-1);
      If (Length(s)>p) and (s[p+1]<>' ')
         then Inhalt := Copy(s, p+1, Length(s)-p)
         else Inhalt := Copy(s, p+2, Length(s)-p-1);
      Result := true
   end
end;

Function TestHeadername (Const s: String; Var p: Integer): Boolean;
Var i: Integer;
begin
   Result := true;
   p := 0;
   If slSonderheader.IndexOf(s) >= 0 then exit;
   For i:=1 to Length(s) do begin
      If Not (s[i] IN Headerzeichen) then begin
         Result := false; p := i; exit
      end
   end
end;

{ ----------------------------------------------------------------------------- }

Function TChangedStringlist.Add (Const s: String): Integer;
begin
   Result := inherited Add(s);
   changed := true
end;
Procedure TChangedStringlist.Delete (i: Integer);
begin
   inherited Delete(i);
   changed := true
end;

Procedure TChangedStringlist.SetStr (i: Integer; S: String);
begin
   If s <> inherited Strings[i] then begin
      inherited Strings[i] := s;
      changed := true
   end
end;

Function TChangedStringlist.GetStr (i: Integer): String;
begin
   Result := inherited Strings[i]
end;

Procedure TChangedStringlist.Insert (i: Integer; Const s: String);
begin
   inherited Insert(i, s);
   changed := true
end;

{ ----------------------------------------------------------------------------- }

Constructor THeader.Create (Charsets: TCharsets);
begin
   fCharsets := Charsets
end;

Function THeader.GetName (i: Integer): String;
Var p: Integer;
begin
   p := Pos(': ', Strings[i]);
   If p>0 then Result := Copy(Strings[i],1,p-1)
          else Result := ''
end;

Function THeader.Change (Const H, I: String): boolean;
Var p: Integer; Inh: String;
begin
   Inh := EncodeISO (fCharsets, I);
   Result := true;
   p := Position(H);
   If Inh = '' then begin
      If P >= 0 then Delete(P)
                else Result := false
   end else begin
      If p >= 0 then begin
         If Strings[p] = Inh
            then Result := false
            else Strings[p] := ToHeader(H) + Inh
      end else begin
         Add (ToHeader(H) + Inh)
      end
   end
end;

Function THeader.Add (Const s: String): Integer;
begin
   Result := inherited Add(EncodeISO(fCharsets, s))
end;      

Function THeader.AddRaw (Const s: String): Integer;
begin
   Result := inherited Add(s)
end;      

Function THeader.Position (Const H: String): Integer;
Var i, L: Integer; s2: String;
begin
   Result := -1; s2 := LowerCase(ToHeader(H)); L := Length(s2);
   For i:=0 to Count-1 do
      If LowerCase(Copy(Strings[i], 1, L)) = s2
         then begin Result := i; break end
end;

Function THeader.Inhalt (Const H: String; Const hi: THeaderinhalt): String;
Var i: Integer;
begin
   i := Position(H);
   if i<0 then Result := '' else Result := InhaltPerPos(i, hi)
end;

Function THeader.InhaltPerPos (Const i: Integer; Const hi: THeaderinhalt): String;
Var p: Integer;
begin
   Result := Strings[i]; p := Pos(':', Result);
   Result := Copy(Result, p+2, Length(Result)-p-1);
   If hi = hiDecoded then Result := DecodeISO(fCharsets, Result)
end;

initialization
   slSonderheader := TStringlist.Create;
   LoadTextFile(ExtractFilePath(ParamStr(0))+'lHeader.txt', slSonderheader);
   With slSonderheader do If Count = 0 then begin
      Add ('!MAIL FROM');
      Add ('!RCPT TO');
      SaveToFile (ExtractFilePath(ParamStr(0))+'lHeader.txt')
   end;
finalization
   slSonderheader.free
end.
