unit uArtikel;

interface

Uses Classes, Windows, uMIMEInf, uHeader, uCSMap;

Type
  TMCEvent = (mcDecode, mcEncode);
  TNotfiyMissingChar = Procedure (Const AtEvent: TMCEvent; Const MissedText, Charset: String;
     Var TryAgain: boolean) of object;
  TCharsetStringlist = Class(TChangedStringList)
   private
     FCharset: String;
     FCharsets: TCharsets;
     FNotfiyMissingChar: TNotfiyMissingChar;
     Function Encode(Const s: String): String;
     Function Decode(Const s: String): String;
     Procedure ChangeCharset (Const s: String);
     Procedure SetStr (i: Integer; Const S: String);
     Function GetStr (i: Integer): String; 
     Procedure SetConvText (S: String);
     Function GetConvText: String;
     Procedure SetRawText (S: String);
     Function GetRawText: String;
   public
     Constructor Create(Charsets: TCharsets);
     property OnMissingChar: TNotfiyMissingChar Read FNotfiyMissingChar Write FNotfiyMissingChar;
     property Charset: String Read FCharset Write ChangeCharset;
     Property Text: String Read GetConvText Write SetConvText;
     Property RawText: String Read GetRawText; { Write SetRawText;}
     Property Strings[i: Integer]: String Read GetStr Write SetStr; default;
     Function Add (Const s: String): Integer; override;
     Function AddRaw (Const s: String): Integer;
     Procedure Insert (i: Integer; Const s: String); override;
  end;

  TBody = Class(TCharsetStringlist) end;
  TSig = Class(TCharsetStringlist) end;

  TMIMEParts = Class;
  TMIMEPart = Class
    private
       fParent: TMimeParts;
       fHasSig: boolean;
       FExtras: TStringlist;
       fOrgHeader, fOrgBody: String;
       fMIMEInfo: TMIMEInfo;
       fHeaderTested, fBodyTested: boolean;
       fHeader: THeader; fBody: TBody; fSig: TSig;
       Function GetHeader: THeader;
       Function GetBody: TBody;
       Function GetSig: TSig;
       Function GetCodedText: String;
       Function GetMIMEinfo: TMIMEInfo;
       Procedure TestHeader;
       Procedure TestBody;
       Procedure SetExtra (Const Bez: String; O: TObject);
       Function GetExtra (Const Bez: String): TObject;
       Function Decode(Const s: String): String;
       Function Encode(Const s: String): String;
       Procedure MissingChar (Const AtEvent: TMCEvent; Const MissedText, Charset: String;
          Var TryAgain: boolean);
       Function GetHasSig: boolean;
    public
       Property HasSig: boolean read GetHasSig;
       Property Extras [Const Bez: String]: TObject Read GetExtra Write SetExtra;
       Procedure DeleteExtra (Const Bez: String);
       Procedure RefreshMIMEInfo;
       Property MimeInfo: TMIMEInfo Read GetMIMEInfo;
       Procedure ChangeCharset (Const cs: String);
       Procedure ChangeEncoding (Const K: TKodierung);
       Property Header: THeader Read GetHeader;
       Property Body: TBody Read GetBody;
       Function AttBody: String;
       Property Sig: TSig Read GetSig;
       property CodedText: String Read GetCodedText;
       Procedure OptimizeBodycharset;
       Constructor Create (Parent: TMimeParts; Org: String);
       Destructor Destroy; override;
  end;

  TArtikel = Class;
  TMIMEParts = Class
    private
      fParent: TArtikel;
      fStartText: String;
      fMimeInfo: TMIMEInfo;
      fl: TList;
      Function GetList(i: Integer): TMIMEPart;
    public
      Function Count: Integer;
      Procedure Add (Org: String);
      Procedure Delete (Const i: Integer);
      property MimeInfo: TMimeInfo read fMimeInfo;
      Property Part[i: Integer]: TMIMEPart Read GetList; default;
      Procedure Clear;
      Function Text (Var Zeilenzahl: Integer): String;
      Constructor Create (Parent: TArtikel);
      Destructor Destroy; override;
  end;

  TFastLineRead = Class
    private
      fTemp: String;
      fEnde: boolean;
      fStart, fNL: LongInt;
      fUnixfile: boolean;
    public
      property UnixFile: boolean Read fUnixFile;
      property Text: String Read fTemp;
      property Ende: boolean Read fEnde;
      Constructor Create(Const Temp: String);
      Function GetLastTempLine: String;
      Procedure NextTempLine;
      Function GetTempLine: String;
      Function RestTempLine: String;
      Function CheckIfMoreLinesThan(Const Anz: Integer): boolean;
  end;

  TArtikel = Class
    private
      { Intern }
      fAktPart: SmallInt;
      fExtra1, fSafeBegin, fSafeEnd: TStringlist;
      fHeaderCharsets, fBodyCharsets: TCharsets;
      fParts: TMIMEParts;
      fTemporaer, fOriginal: String;
      fHeader: THeader;
      fUnixFile: boolean;
      fSafeReg1, fSafeReg2: Integer;
      { Einstellbar }
      fSigTrenner: String;
      Function GetGesamttext: String;
      Procedure SetGesamttext (s: String);
      Procedure Analyse;
      Procedure SetAktPart(i: SmallInt);
    public
      bSetLines: boolean;
      Constructor Create (Const IntCS, HeaderCS, BodyCS: String);
      Destructor Destroy; override;
      Procedure LoadFromFile (Const s: String);
      Procedure SaveToFile (Const s: String);
      Property Gesamttext: String Read GetGesamttext write SetGesamttext;
      Property Header: THeader Read fHeader;
      property Parts: TMIMEParts read fParts;
      Property ActivePart: SmallInt Read fAktPart Write SetAktPart;
      Function Part: TMIMEPart;
      Property ConvertToSigTrenner: String Read fSigTrenner Write fSigTrenner;
      Property SafeReg1: Integer Write fSafeReg1;
      Property SafeReg2: Integer Write fSafeReg2;
      Property IsUnixfile: boolean Read FUnixFile;
  end;

implementation

Uses SysUtils, uISO;

Const HeaderCont = [^I, ' '];
      HeaderQPKodierung = 'Content-Transfer-Encoding: quoted-printable';
      HeaderBase64Kodierung = 'Content-Transfer-Encoding: base64';
      HeaderMultipart = 'Content-Type: multipart/';

{ ----------------------------------------------------------------------------- }

Constructor TMimePart.Create (Parent: TMimeParts; Org: String);
Var p: Integer;
begin
   inherited Create;
   fParent := Parent;
   fHeader := THeader.Create (Parent.fParent.fHeaderCharsets);
   fBody := TBody.Create (Parent.fParent.fBodyCharsets);
   fBody.OnMissingChar := MissingChar;
   fSig := TSig.Create (Parent.fParent.fBodyCharsets);
   fSig.OnMissingChar := MissingChar;
   fHeaderTested := false;
   fBodyTested := false;
   fOrgHeader := '';
   fOrgBody := '';
   fExtras := TStringList.Create;
   If fParent.fMIMEInfo.Multipart then begin
      p := Pos (#13#10#13#10, Org);
      If p = 0 then
         fOrgHeader := Org
      else begin
         fOrgHeader := Copy(Org, 1, p-1);
         fOrgBody := Copy(Org, p+4, Length(Org))
      end
   end else begin
      fOrgBody := Org
   end
end;

Destructor TMimePart.Destroy;
Var i: Integer;
begin
   fHeader.free;
   fBody.free;
   fSig.free;
   With fExtras do begin
      For i := 0 to Count-1 do TObject(Objects[i]).Free;
      free
   end;
   inherited Destroy
end;

function TMIMEPart.GetExtra(const Bez: String): TObject;
Var i: Integer;
begin
   i := fExtras.IndexOf(LowerCase(Bez));
   If i < 0 then Result := NIL else Result := TObject(fExtras.Objects[i])
end;

procedure TMIMEPart.SetExtra(const Bez: String; O: TObject);
Var i: Integer;
begin
   i := fExtras.IndexOf(LowerCase(Bez));
   If i < 0 then
      fExtras.AddObject(LowerCase(Bez), Pointer(O))
   else begin
      TObject(fExtras.Objects[i]).Free;
      fExtras.Objects[i] := Pointer(O)
   end
end;

procedure TMIMEPart.DeleteExtra(const Bez: String);
Var i: Integer;
begin
   i := fExtras.IndexOf(LowerCase(Bez));
   If i >= 0 then begin
      TObject(fExtras.Objects[i]).Free;
      fExtras.Delete(i)
   end
end;                   

Function TMimePart.GetHasSig: boolean;
begin
   Result := fHasSig;
   If not Result then Result := fSig.Count > 0
end;

Procedure TMimePart.MissingChar (Const AtEvent: TMCEvent; Const MissedText, Charset: String;
   Var TryAgain: boolean);
Var NewCharset: String;
begin
   TryAgain := false;
   Case AtEvent of
      mcEncode: try
         fBody.OnMissingChar := NIL;
         fSig.OnMissingChar := NIL;
         NewCharset := fParent.fParent.fBodyCharsets.GetMinCharsetFor (MissedText + fBody.text + fSig.text).HeaderName;
         If NewCharset > '' then begin
            ChangeCharset (NewCharset);
            TryAgain := true
         end
      finally
         fBody.OnMissingChar := MissingChar;
         fSig.OnMissingChar := MissingChar;
      end;
      mcDecode: ;
   end
end;

Procedure TMimePart.RefreshMIMEInfo;
begin
   If fParent.MimeInfo.Multipart
      then begin fMimeInfo := ExtractMimeInfo(false, fHeader); fMIMEInfo.Multipart := true end
      else begin fParent.fMimeInfo := ExtractMimeInfo(true, fParent.fParent.fHeader); fMimeInfo := fParent.fMimeInfo end
end;

Procedure TMimePart.ChangeCharset (Const cs: String);
//Var b: boolean;
begin
   TestBody;
   If fParent.MimeInfo.Multipart
      then SetMimeCharset(false, fHeader, cs)
      else SetMimeCharset(true, fParent.fParent.fHeader, cs);
   RefreshMIMEInfo;
   fBody.Charset := cs;
   fSig.Charset := cs;
end;

Procedure TMimePart.ChangeEncoding (Const K: TKodierung);
Var s, s2: String; HdM, HdL: THeader;
begin
   TestBody;
   Body.changed := true;
   If fParent.MimeInfo.Multipart then begin
      HdM := fParent.fParent.fHeader; HdL := fHeader
   end else begin
      HdM := fParent.fParent.fHeader; HdL := HdM
   end;
   If K = k7Bit then begin
      s := Body.Text;
      s2 := Convert1252ToAscii (s);
      If s <> s2 then Body.Text := s2;
      s := Sig.Text;
      s2 := Convert1252ToAscii (s);
      If s <> s2 then Sig.Text := s2;
      s := HdL.Inhalt('Content-Transfer-Encoding', hiRaw);
      If (k <> k7Bit) or (s > '') then begin
         If HdM.Inhalt('MIME-Version', hiRaw) = ''
            then HdM.Change ('MIME-Version', '1.0');
         If HdL.Inhalt('Content-Type', hiRaw) = ''
            then HdL.Change ('Content-Type', 'text/plain; charset=us-ascii');
         HdL.Change ('Content-Transfer-Encoding', StrKodierung[k])
      end;
   end else begin
      SetMimeEncoding(Not fParent.MimeInfo.Multipart, HdL, K)
   end;
   RefreshMIMEInfo
end;

Procedure TMimePart.OptimizeBodycharset;
Var NewCharset: String;
begin
   NewCharset := fParent.fParent.fBodyCharsets.GetMinCharsetFor (fBody.text + fSig.text).Headername;
   If NewCharset > '' then ChangeCharset (NewCharset);
end;

Function TMimePart.Decode(Const s: String): String;
Var b: boolean;
begin
   Case fMimeInfo.Kodierung of
      kQP: Result := DecodeQP (fParent.fParent.fBodyCharsets, s, '', false, b);
      kbase64: Result := DecodeBase64(fParent.fParent.fBodyCharsets, s, '', b);
      else Result := s
   end
end;

Function TMimePart.AttBody: String;
begin
   Result := Decode(fOrgBody)
end;

Function TMimePart.Encode(Const s: String): String;
begin
   Case fMimeInfo.Kodierung of
      kQP: Result := EncodeQP (s, '', true);
      kbase64: Result := EncodeBase64(s, '');
      else Result := s
   end
end;

Function TMimePart.GetCodedText: String;
Var s: String; 
begin
   Result := '';
   If fOrgHeader > '' then begin
      If Not fHeader.Changed
         then Result := fOrgHeader + #13#10#13#10
         else begin TestHeader; Result := Result + Header.Text + #13#10 end
   end;
   if fBody.Changed or fSig.Changed then begin
      Testbody;
      s := Body.RawText;
      If fSig.Count > 0 then begin
         s := s + '-- ' + #13#10 + fSig.Text;
         If Copy(s, Length(s)-1, 2) = #13#10 then SetLength(s, Length(s)-2)
      end;
      s := Encode(s)
   end else begin
      s := fOrgBody
   end;
   Result := Result + s
end;

Function TMimePart.GetMIMEInfo: TMIMEInfo;
begin
   if fParent.fMimeInfo.Multipart then begin
      TestHeader;
      Result := fMIMEInfo
   end else begin
      Result := fParent.fMIMEInfo
   end
end;

Function TMimePart.GetHeader: THeader;
begin
   TestHeader;
   Result := fHeader
end;

Function TMimePart.GetSig: TSig;
begin
   TestBody; Result := fSig;
   fHasSig := false
end;

Function TMimePart.GetBody: TBody;
begin
   TestBody; Result := fBody
end;

Procedure TMimePart.TestHeader;
Var s, H: String;
begin
   If fHeaderTested then Exit;
   fHeaderTested := true;
   If fParent.fMIMEInfo.Multipart then begin
      With TFastLineRead.Create(fOrgHeader) do try
         H := '';
         While Not Ende do begin
            s := GetTempLine; NextTempLine;
            If s > '' then begin
               If s[1] IN HeaderCont then
                  H := H + #13#10 + s
               else begin
                  If H > '' then Header.AddRaw (H);
                  H := s
               end
            end
         end;
         If H > '' then Header.AddRaw(H);
          // ggf. Header analysieren
         fHeader.changed := false
      finally
         free
      end
   end;
   RefreshMIMEInfo
end;

Procedure TMimePart.TestBody;
Var s: String; i, j: Integer;
begin
   TestHeader;
   If fBodyTested then Exit;
   fBodyTested := true;
   s := Decode(fOrgBody);
   Body.Charset := fMimeInfo.Charset;
   With TFastLineRead.Create(s) do try
      fHasSig := false;
      With fBody do While Not Ende do begin
         s := GetTempLine;
         //If TestUUEncode(s, fBody) then break;
         NextTempLine;
         If s = '-- ' then begin fHasSig := true; break end;
         AddRaw (s)
      end;
      If fBody.Count = 0 then fBody.AddRaw ('');
      { Sig }
      If fHasSig then With fSig do While Not Ende do begin
         s := GetTempLine;
         NextTempLine;
         AddRaw (s)
      end;
      If (fParent.fParent.ConvertToSigTrenner > '') and (Not fHasSig) then begin
         For i:=fBody.Count-1 downto 0 do If fBody[i]=fParent.fParent.ConvertToSigTrenner then begin
            For j:=i+1 to fBody.Count-1 do fSig.Add (fBody[j]);
            For j:=fBody.Count-1 downto i do fBody.Delete(j);
            fHasSig := true
         end
      end;
      fBody.changed := false;
      fSig.changed := false;
   finally
      free
   end;
end;

{ ----------------------------------------------------------------------------- }

Constructor TMimeParts.Create (Parent: TArtikel);
begin
   inherited Create;
   fParent := Parent;
   fl := TList.Create
end;

Destructor TMimeParts.Destroy;
begin
   Clear;
   fl.Free;
   inherited destroy
end;

Function TMimeParts.GetList(i: Integer): TMIMEPart;
begin
   Result := TMimePart(fl[i])
end;

Function TMimeParts.Count: Integer;
begin
   Result := fl.Count
end;

Procedure TMimeParts.Add (Org: String);
Var Tr1, Tr2: String; i, M1, M2, L1, L2: LongInt; c: Char;
    Trennliste: TList; Letzter: LongInt;
begin
   if fMIMEInfo.Multipart then begin
      Trennliste := TList.Create; Letzter := 0;
      try
         Tr1 := #13#10+'--'+fMIMEInfo.Trenner+#13#10; L1 := Length(Tr1);
         Tr2 := #13#10+'--'+fMIMEInfo.Trenner+'--'+#13#10; L2 := Length(Tr2);
         M1 := 1+2; M2 := 1;
         For i := 1 to Length(Org) do begin
            c := Org[i];
            If Tr1[M1]=c then Inc(M1)
            else If M1 > 1 then begin
               M1 := 1; If Tr1[M1]=c then Inc(M1)
            end;
            If M1 > L1 then begin
               Trennliste.Add(Pointer(i)); M1 := 1
            end;
            If Tr2[M2]=c then Inc(M2)
            else If M2 > 1 then begin
               M2 := 1; If Tr2[M2]=c then Inc(M2)
            end;
            If M2 > L2 then begin
               Letzter := i; M2 := 1
            end
         end;
         if Letzter = 0 then Letzter := Length(Org)+1;
         For i := 0 to Trennliste.Count-1 do begin
            M1 := LongInt(Trennliste[i]) + 1;
            If i < Trennliste.Count-1
               then M2 := LongInt(Trennliste[i+1]) - L1
               else M2 := Letzter - L2 + 1;
            fl.Add (TMimePart.Create(Self, Copy(Org, M1, M2-M1+1)))
         end;
         i := LongInt(Trennliste[0])-Length(Tr1);
         If i > 0
            then fStartText := Copy(Org, 1, i)
            else fStartText := ''
      finally
         Trennliste.free
      end
   end else begin
      fl.Add (TMimePart.Create(Self, Org))
   end
end;

Procedure TMimeParts.Delete (Const i: Integer);
Var p: Pointer;
begin
   p := fl.Items[i];
   TMimePart(p).free;
   fl.Delete(i)
end;

Procedure TMimeParts.Clear;
begin
   While Count > 0 do Delete(0)
end;

Function TMimeParts.Text (Var Zeilenzahl: Integer): String;
Var i: Integer;
begin
   If fMIMEInfo.Multipart then begin
      Result := fStarttext;
      For i := 0 to Count-1 do begin
         Result := Result + #13#10 + '--'+fMIMEInfo.Trenner + #13#10
                   + TMimePart(fl[i]).CodedText;
         If Copy(Result, Length(Result)-3, 4) <> #13#10#13#10 then Result := Result + #13#10
      end;
      Result := Result + '--' + fMIMEInfo.Trenner + '--' + #13#10#13#10
   end else begin
      Result := fParent.Part.CodedText
   end;

   Zeilenzahl := 0;
   For i := 1 to Length(Result) do begin
      If Result[i] = #13 then Inc(Zeilenzahl)
   end

end;

{ ----------------------------------------------------------------------------- }

Constructor TArtikel.Create (Const IntCS, HeaderCS, BodyCS: String);
begin
   inherited Create;
   fBodyCharsets := TCharsets.Create (IntCS, BodyCS);
   fHeaderCharsets := TCharsets.Create (IntCS, HeaderCS);
   fHeader := THeader.Create (fHeaderCharsets);
   fSafeBegin := TStringlist.Create;
   fSafeEnd := TStringlist.Create;
   fExtra1 := TStringlist.Create;
   fParts := TMimeParts.Create(self);
   fAktPart := 1;
   fSigTrenner := ''
end;

Destructor TArtikel.Destroy;
begin
   fHeader.free; fExtra1.free;
   fParts.free;
   fSafeBegin.free; fSafeEnd.free;
   fBodyCharsets.free;
   fHeaderCharsets.free;
   inherited Destroy
end;

Procedure TArtikel.LoadFromFile (Const s: String);
Var L: LongInt;
begin
   With TFileStream.Create(s, fmOpenread) do try
      L := Size;
      SetLength(fTemporaer, L);
      ReadBuffer(fTemporaer[1], L);
      If L > 0 then begin
         If (fTemporaer[L]<>#13) and (fTemporaer[L]<>#10) then begin
            fTemporaer := fTemporaer + #13#10
         end
      end;
      fOriginal := fTemporaer
   finally free end;
   Analyse
end;

Procedure TArtikel.SaveToFile (Const s: String);
Var Inh: String;
begin
   With TFileStream.Create(s, fmCreate) do try
      Inh := GesamtText;
      WriteBuffer(Inh[1], Length(Inh));
   finally free end
end;

Procedure TArtikel.SetGesamttext (s: String);
begin
   fTemporaer := s;
   Analyse
end;

Procedure TArtikel.Analyse;
Var LR: TFastlineRead;
Var s: String; i: Integer;
begin
   LR := TFastLineRead.Create(fTemporaer);
   try
      fSafeBegin.Clear; fSafeEnd.Clear;
      fHeader.Clear; fExtra1.Clear; fParts.Clear;
      { Unvernderbaren Kopf retten }
      For i := 1 to fSafeReg1 do If Not LR.Ende then begin
         FSafeBegin.Add (LR.GetTempLine); LR.NextTempLine
      end;
      { Unvernderbaren Schluss retten }
      For i := 1 to fSafeReg2 do FSafeEnd.Insert (0, LR.GetLastTempLine);
      { Header auslesen }
      While Not LR.Ende do begin
         s := LR.GetTempLine; LR.NextTempLine;
         If s > '' then begin
            If s[1] IN HeaderCont then begin
               fHeader[fHeader.Count-1] := fHeader[fHeader.Count-1] + #13#10 + s;
            end else begin
               fHeader.AddRaw (s)
            end
         end else break
      end;
      { Headeranalyse }
      fAktPart := 1;
      fParts.fMimeInfo := ExtractMimeInfo(true, fHeader);
      fParts.Add (LR.RestTempLine);
      fUnixFile := LR.Unixfile
   finally LR.free end
end;

Function TArtikel.GetGesamttext: String;
Var Zeilen: Integer; B: String;
begin
   Result := '';
   B := fParts.text(Zeilen);
   If bSetLines then fHeader.Change('Lines', IntToStr(Zeilen));
   If fSafeBegin.Count > 0 then Result := fSafeBegin.Text;
   Result := Result + fHeader.Text + #13#10;
   With fExtra1 do If Count > 0 then Result := Result + Text;
   Result := Result + B;
   If fSafeEnd.Count > 0 then Result := Result + fSafeEnd.Text
end;

Procedure TArtikel.SetAktPart(i: SmallInt);
begin
   If (i >= 1) and (i <= fParts.Count) then fAktPart := i
end;

Function TArtikel.Part: TMIMEPart;
begin
   Result := fParts[fAktPart-1]
end;

{ ----------------------------------------------------------------------------- }

Constructor TFastLineRead.Create(Const Temp: String);
begin
   inherited Create;
   fTemp := Temp;
   fEnde := fTemp = ''; fStart := 0; fNL := 0;
   fUnixfile := false
end;

Function TFastLineRead.GetLastTempLine: String;
Var i, p: Integer; b: boolean;
begin
   fNL := Length(fTemp)+1;
   Result := '';
   For i:=Length(fTemp) downto 2 do begin
      b := fTemp[i]=#10;
      If b then begin
         p := i;
         fUnixfile := fTemp[p-1]<>#13;
         Result := Copy(fTemp, p+1, Length(fTemp)-p);
         If Not fUnixFile then Dec(p);
         Delete(fTemp, p, Length(fTemp));
         break
      end
   end
end;

Procedure TFastLineRead.NextTempLine;
begin
   If fUnixFile then fStart := fNL else fStart := fNL + 1;
   If fStart <= Length(fTemp) then If fTemp[fStart]<>#10 then Dec(fStart);
   fEnde := fStart + 2 >= Length(fTemp)
end;

Function TFastLineRead.GetTempLine: String;
Var i: Integer; b: boolean;
begin
   fNL := Length(fTemp)+1;
   b := false;
   For i:=fStart+1 to Length(fTemp) do begin
      If fTemp[i]=#13 then begin
         b := true; If fUnixfile then fUnixfile := false
      end else
      If fTemp[i]=#10 then begin
         b := true; if Not fUnixfile then fUnixfile := true
      end;
      If b then begin
         fNL := i; break
      end
   end;
   Result := Copy(fTemp, fStart+1, fNL-fStart-1);
end;

Function TFastLineRead.RestTempLine: String;
begin
   Result := Copy(fTemp, fStart+1, Length(fTemp)-fStart)
end;

Function TFastLineRead.CheckIfMoreLinesThan(Const Anz: Integer): boolean;
Var i, tr: Integer;
begin
   Result := false; Tr := 0;
   For i := 1 to Length(fTemp) do If fTemp[i]=#13 then begin
      Inc(tr);
      If tr = Anz then begin Result := true; break end
   end
end;

{ ----------------------------------------------------------------------------- }

Procedure TCharsetStringlist.ChangeCharset (Const s: String);
Var Temp: String; Conv: boolean;
begin
   If s = fCharset then exit;
   Conv := (fCharset > '') or (s > '');
   If Conv then Temp := GetConvText;
   fCharset := s;
   If Conv then SetConvText(Temp);
end;

Constructor TCharsetStringlist.Create(Charsets: TCharsets);
begin
   inherited create;
   fCharsets := Charsets
end;

Function TCharsetStringlist.Encode(Const s: String): String;
Var TryAgain, MissingChar: boolean;
begin
   If Charset = '' then
      Result := s
   else begin
      Result := ConvertText (fCharsets, s, '', Charset, MissingChar);
      If MissingChar and Assigned(FNotfiyMissingChar) then begin
         FNotfiyMissingChar (mcEncode, s, Charset, TryAgain);
         If TryAgain then Result := ConvertText (fCharsets, s, '', Charset, MissingChar);
      end
   end
end;

Function TCharsetStringlist.Decode(Const s: String): String;
Var MissingChar: boolean;
begin
   If Charset = '' then
      Result := s
   else begin
      Result := ConvertText (fCharsets, s, Charset, '', MissingChar);
      If MissingChar then Result := ConvertText (fCharsets, s, 'cp1252', '', MissingChar)
   end
end;

Function TCharsetStringlist.Add (Const s: String): Integer;
begin
   Result := AddRaw(Encode(s));
end;

Function TCharsetStringlist.AddRaw (Const s: String): Integer;
begin
   Result := inherited Add (s)
end;

Procedure TCharsetStringlist.SetStr (i: Integer; Const S: String);
Var s2: String;
begin
   s2 := Encode(s);
   If s2 <> inherited Get(i) then inherited Put(i, s2)
end;

Function TCharsetStringlist.GetStr (i: Integer): String;
begin
   Result := Decode(inherited Get(i))
end;

Procedure TCharsetStringlist.Insert (i: Integer; Const s: String);
begin
   inherited Insert(i, Encode(s));
end;

Procedure TCharsetStringlist.SetConvText (S: String);
begin
   inherited Text := s
end;

Function TCharsetStringlist.GetConvText: String;
begin
   Result := Decode (inherited Text)
end;

Procedure TCharsetStringlist.SetRawText (S: String);
Var CS: String;
begin
   CS := fCharset;
   fCharset := '';
   inherited Text := s;
   fCharset := CS
end;

Function TCharsetStringlist.GetRawText: String;
begin
   Result := inherited Text
end;

{ ----------------------------------------------------------------------------- }

end.

