unit uSkript;

interface

Uses Classes;

Type
  TZeilentyp = (ztUnknown, ztComment, ztLabel, ztLine, ztSub, ztEndSub,
                ztFor, ztForNext, ztNext, ztWhile, ztWend, ztRepeat, ztUntil, ztDo, ztLoop,
                ztSelectCase, ztCase, ztCaseElse, ztEndSelect);
  TZeile = Class
   private
     OrgZeile, OrgDatei, AktDatei: String;
     OrgZNr, AktZNr: Integer;
     Procedure SetTyp;
   public
     Inhalt: String;
     Typ: TZeilentyp
  end;
  TSkript = Class
   private
     FZeile: Integer;
     L: TList;
     Function GetZeilen (i: Integer): TZeile;
     Function GetDateinamen (i: Integer): String;
     Function GetZeilenNr (i: Integer): Integer;
     Function GetObjects (i: Integer): Pointer;
   public
     Function Count: Integer;
     Procedure Clear;
     Procedure IncZeile;
     Function  FindObject (P: Pointer): Integer;
     Procedure InsertLine (Const i: Integer; Const s: String);
     Function  AddLine (Const s: String): Integer;
     Property  Zeile: Integer Read FZeile Write FZeile;
     Property  Zeilen[i: Integer]: TZeile Read GetZeilen; default;
     Property  Dateiname[i: Integer]: String Read GetDateinamen;
     Property  ZeilenNr[i: Integer]: Integer Read GetZeilenNr;
     Property  Objects[i: Integer]: Pointer Read GetObjects;
     Procedure Fill (Const Dateiname: String; sl: TStrings);
     Procedure SaveToFile (Const s: String);
     Procedure ExpandLineToFile (Const i: Integer; Const Dateiname: String);
     Constructor Create;
     Destructor Destroy; override;
  end;

implementation

Uses SysUtils, uGetStr;

Constructor TSkript.Create;
begin
   Inherited Create;
   L := TList.Create;
end;

Destructor TSkript.Destroy;
begin
   Clear; L.free;
   Inherited Destroy
end;

Procedure TSkript.Clear;
begin
   FZeile := 1;
   With L do While Count>0 do begin
      TZeile(Items[0]).free; Delete(0)
   end
end;

Function TSkript.GetZeilen (i: Integer): TZeile;
begin
   Result := TZeile(L[i])
end;

Function TSkript.GetDateinamen (i: Integer): String;
begin
   With TZeile(L[i]) do if AktDatei > ''
      then Result := AktDatei
      else Result := OrgDatei
end;

Function TSkript.GetZeilenNr (i: Integer): Integer;
begin
   With TZeile(L[i]) do begin
      If AktZNr > 0 then Result := AktZNr else Result := OrgZNr
   end
end;

Function TSkript.Count: Integer;
begin
   Result := L.Count
end;

Procedure TSkript.Fill (Const Dateiname: String; sl: TStrings);
Var z: String; Nr: Integer;
begin
   Clear;
   For Nr := 1 to sl.Count do begin
      z := sl[Nr-1];
      With TZeile(L[L.Add(TZeile.Create)]) do begin
         OrgZNr := Nr; AktZnr := 0;
         OrgZeile := z; Inhalt := z; SetTyp;
         OrgDatei := Dateiname; AktDatei := ''
      end
   end
end;

Procedure TSkript.SaveToFile (Const s: String);
Var t: TextFile; i: Integer;
begin
   AssignFile(t, s); Rewrite(t);
   With L do For i:=0 to Count-1 do With TZeile(Items[i]) do begin
      If OrgZNr > 0 then Writeln(t, OrgZeile)
   end;
   CloseFile(t)
end;

Procedure TSkript.ExpandLineToFile (Const i: Integer; Const Dateiname: String);
Var z, s: String; Nr, j: Integer; bCR: boolean;
begin
   With TZeile(L[i]) do begin
      Inhalt := ''; SetTyp
   end;
   With TFileStream.Create (Dateiname, fmOpenRead) do try
      SetLength(z, Size);
      Read(z[1], Size)
   finally free end;
   Nr := 0; s := '';
   For j := 1 to Length(z) do begin
      bCR := j = Length(z);
      Case z[j] of
         #13: ;
         #10: bCR := true;
         else s := s + z[j]
      end;
      If bCR then With L do begin
         Inc(Nr);
         If Nr = 1 then With TZeile(Items[i]) do begin
            AktZnr := Nr; Inhalt := s; SetTyp;
            AktDatei := Dateiname
         end else begin
            Insert(i+Nr-1, TZeile.Create);
            With TZeile(Items[i+Nr-1]) do begin
               OrgZNr := 0; AktZnr := Nr;
               OrgZeile := ''; Inhalt := s; SetTyp;
               OrgDatei := ''; AktDatei := Dateiname
            end
         end;
         s := ''
      end
   end
end;

Procedure TSkript.InsertLine (Const i: Integer; Const s: String);
begin
   L.Insert(i, TZeile.Create);
   With TZeile(L[i]) do begin
      OrgZNr := 0; AktZnr := 0;
      OrgZeile := ''; Inhalt := s; SetTyp;
      OrgDatei := ''; AktDatei := ''
   end
end;

Function TSkript.AddLine (Const s: String): Integer;
begin
   Result := L.Add(TZeile.Create);
   With TZeile(L[Result]) do begin
      OrgZNr := 0; AktZnr := 0;
      OrgZeile := ''; Inhalt := s; SetTyp;
      OrgDatei := ''; AktDatei := ''
   end
end;

Function TSkript.GetObjects (i: Integer): Pointer;
begin
   Result := L[i]
end;

Function TSkript.FindObject (P: Pointer): Integer;
begin
   Result := L.IndexOf(P)
end;

Procedure TSkript.IncZeile;
begin
   Inc(FZeile)
end;

{ TZeile }

Procedure TZeile.SetTyp;
Var s: String;
begin
   Typ := ztLine;
   s := Trim(Inhalt);
   If (s = '') then Typ := ztComment
   else If (s[1] IN [';','#', '''', '/', '\']) then Typ := ztComment
   else If s[1]=':' then Typ := ztLabel
   else If SucheUndKuerze('Sub', s) then begin
      Typ := ztSub
   end
   else If SucheUndKuerze('For', s) then begin
      If Pos(' do ', LowerCase(s))>0 then Typ := ztForNext
                                     else Typ := ztFor
   end
   else If SucheUndKuerze('Next', s) then Typ := ztNext
   else If SucheUndKuerze('While', s) then Typ := ztWhile
   else If SucheUndKuerze('Wend', s) then Typ := ztWend
   else If SucheUndKuerze('Repeat', s) then Typ := ztRepeat
   else If SucheUndKuerze('Until', s) then Typ := ztUntil
   else If SucheUndKuerze('Endless', s) then Typ := ztDo
   else If SucheUndKuerze('Loop', s) then Typ := ztLoop
   else If SucheUndKuerze('Select', s) and SucheUndKuerze('Case', s) then Typ := ztSelectCase
   else If SucheUndKuerze('Case', s) then begin
      If SucheUndKuerze('Else', s) then Typ := ztCaseElse
                                   else Typ := ztCase
   end
   else If SucheUndKuerze('Endsub', s) then Typ := ztEndSub
   else If SucheUndKuerze('Endselect', s) then Typ := ztSelectCase
   else If SucheUndKuerze('End', s) then begin
      If SucheUndKuerze('Sub', s) then Typ := ztEndSub
      else If SucheUndKuerze('Select', s) then Typ := ztEndSelect
   end
end;

end.
