unit CfgMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Mask, ToolEdit, IniFiles, ShellAPI, Buttons, ComCtrls;

type
  TFrmMain = class(TForm)
    butOk: TButton;
    butAbort: TButton;
    Panel1: TPanel;
    l: TListBox;
    butNeu: TButton;
    butDel: TButton;
    butKopie: TButton;
    Label7: TLabel;
    pg: TPageControl;
    TabSheet1: TTabSheet;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    txtMessagePath: TDirectoryEdit;
    txtFilePath: TDirectoryEdit;
    txtHeaderDef: TEdit;
    butHeaderDefEdit: TButton;
    txtTestExt: TEdit;
    txtRenameTo: TEdit;
    chkBackup: TCheckBox;
    TabSheet2: TTabSheet;
    Label8: TLabel;
    Label10: TLabel;
    Label9: TLabel;
    Label35: TLabel;
    Label37: TLabel;
    chkISO: TCheckBox;
    chkDelWas: TCheckBox;
    chkDelMultiRes: TCheckBox;
    txtRes: TEdit;
    chkReplaceSubject8Bits: TCheckBox;
    chkCheckFromReplyFormat: TCheckBox;
    chkSetLines: TCheckBox;
    TabSheet3: TTabSheet;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label38: TLabel;
    Label28: TLabel;
    cbSetDate: TComboBox;
    cbDateFormat: TComboBox;
    txtMaxRef: TEdit;
    chkRefFolding: TCheckBox;
    txtSortHeader: TEdit;
    memKillHeaderlines: TMemo;
    TabSheet4: TTabSheet;
    Label12: TLabel;
    Label13: TLabel;
    Label36: TLabel;
    Label34: TLabel;
    txtKillMID: TEdit;
    chkHamsterheaderFirst: TCheckBox;
    chkRCPTto: TCheckBox;
    chkRCPTtoAlways: TCheckBox;
    TabSheet5: TTabSheet;
    Label24: TLabel;
    Label25: TLabel;
    Label22: TLabel;
    Label27: TLabel;
    chkXHeader: TCheckBox;
    chkSonstHeader: TCheckBox;
    txtSigTrenner: TEdit;
    txtSigFile: TFilenameEdit;
    butSigFileEdit: TButton;
    chkBlankLineBeforeSig: TCheckBox;
    TabSheet6: TTabSheet;
    Label23: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label29: TLabel;
    chkQuoting: TCheckBox;
    chkSpaceBefText: TCheckBox;
    chkSpaceBetween: TCheckBox;
    txtZitatzeichen: TEdit;
    txtDoNot1: TEdit;
    txtDoNot2: TEdit;
    chkNoCheckAfterSig: TCheckBox;
    TabSheet7: TTabSheet;
    Label31: TLabel;
    txtDelAtBegin: TEdit;
    chkBlankBeforeLines: TCheckBox;
    chkDelKammQuoting: TCheckBox;
    chkBoxQuotes: TCheckBox;
    frAllgemein: TPanel;
    Button1: TButton;
    Button2: TButton;
    Button4: TButton;
    Button3: TButton;
    chkFootnotes: TCheckBox;
    Label39: TLabel;
    txtSafeReg1: TEdit;
    Label40: TLabel;
    txtSafeReg2: TEdit;
    Label41: TLabel;
    chkReformat: TCheckBox;
    chkOneliner: TCheckBox;
    Button5: TButton;
    TabSheet8: TTabSheet;
    Label30: TLabel;
    chkMinBodyCharset: TCheckBox;
    Label42: TLabel;
    TabSheet9: TTabSheet;
    Label43: TLabel;
    cbDefaultEncoding: TComboBox;
    chkHTML2text: TCheckBox;
    chkConvertQP: TCheckBox;
    chkConvert8Bit: TCheckBox;
    chkConvertBase64: TCheckBox;
    Label44: TLabel;
    chkTrimRight: TCheckBox;
    chkDeleteEmptyLines: TCheckBox;
    cbCSHeader: TComboBox;
    cbCSBody: TComboBox;
    Label32: TLabel;
    txtSaveHTMLAs: TEdit;
    chkSaveAtt: TCheckBox;
    Label33: TLabel;
    txtSaveAttDir: TDirectoryEdit;
    Label45: TLabel;
    cbSaveAttReaction: TComboBox;
    Button6: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure butAbortClick(Sender: TObject);
    procedure butOkClick(Sender: TObject);
    procedure lClick(Sender: TObject);
    procedure butNeuClick(Sender: TObject);
    procedure butDelClick(Sender: TObject);
    procedure butHeaderDefEditClick(Sender: TObject);
    procedure butSigFileEditClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure cbDefaultEncodingChange(Sender: TObject);
    procedure Button6Click(Sender: TObject);
  private
    Inidatei: String;
    lAbschnitte: TStringlist;
    LastNr: Integer;
    procedure FuelleListe;
    procedure Put (Const Nr: Integer);
    procedure Get (Const Nr: Integer);
  end;

var
  FrmMain: TFrmMain;

implementation

Uses Settings, DAssiste, DBoxQuo, DFussnot, DOL_ReF, DDefChSs, uCSMap, uTransla;

{$R *.DFM}

Const Basis = 10;

procedure TFrmMain.FormCreate(Sender: TObject);
Var t: TextFile; s: String; i: Integer; SAR: TActionIfAttExists;
begin
   Translate (self, 'MainForm');
   Caption := 'Korrnews V'+Ver+' konfigurieren';
   lAbschnitte := TStringlist.Create; lAbschnitte.sorted := true;

   cbCSBody.Hint := cbCSHeader.Hint;

   Inidatei := ExtractFilePath(Paramstr(0))+'Korrnews.ini';
   If FileExists(IniDatei) then begin
      AssignFile(T, Inidatei); Reset(T);
      While not EOF(T) do With lAbschnitte do begin
         Readln(t, s); s:=Trim(s);
         If (s>'') and (s[1]='[') and (s[Length(s)]=']') then
            AddObject(Copy(s, 2, Length(s)-2), TKNEinstellungen.Create);
      end;
      CloseFile(T)
   end;
   With lAbschnitte do For i := 0 to Count-1 do With Objects[i] as TKNEinstellungen do begin
      Dateiname := IniDatei; Abschnitt := Strings[i]; ReadSettings(true)
   end;
   FuelleListe;

   With cbCSHeader do begin Items.Assign(CSInfos.Sets); Items.Insert (0, '<Default>') end;
   With cbCSBody do begin Items.Assign(CSInfos.Sets); Items.Insert (0, '<Default>') end;
   With cbSaveAttReaction.Items do begin
      Clear;
      For SAR := Low(TActionIfAttExists) to High(TActionIfAttExists) do Add(ActionNames[SAR])
   end;

   With TIniFile.Create(ExtractFilePath(ParamStr(0))+'Specials.ini') do try
      try l.ItemIndex := ReadInteger('CfgMain', 'Position', 0)
      except If l.Items.Count > 0 then l.ItemIndex := 0 end;
      l.OnClick(nil);
      try pg.ActivePage := pg.Pages[ReadInteger('CfgMain', 'Page', 0)]
      except pg.ActivePage := pg.Pages[0] end;
   finally
      free
   end
   
end;

procedure TFrmMain.FuelleListe;
Var i: Integer;
begin
   With lAbschnitte do begin
      l.Clear;
      l.Items.Add ('Allgemeines');
      For i:=0 to Count-1 do begin
         l.Items.Add ('Konfiguration "'+Strings[i]+'"');
         {, Pointer(Basis * (i+1) + 1));
         For j:=2 to nb.Pages.Count-1 do
            l.Items.AddObject ('  '+nb.Pages[j], Pointer(Basis * (i+1) + j));
         If i < Count-1 then l.Items.Add ('') }
      end;
      {l.OnClick(nil)}
   end
end;

procedure TFrmMain.Get (Const Nr: Integer);
begin
   With lAbschnitte.Objects[Nr-1] as TKNEinstellungen do begin
      { Allgemein }
      txtMessagePath.text := WorkPath;
      txtFilePath.text := FilePath;
      txtHeaderDef.text := HeaderDef;
      txtTestExt.text := TestExt;
      txtRenameTo.text := ConvertToExt;
      chkBackup.checked := MakeBAK;
      txtSafeReg1.text := IntToStr(SafeReg1);
      txtSafeReg2.text := IntToStr(SafeReg2);
      chkTrimRight.checked := RightTrim;
      chkHTML2text.checked := HTML2text;
      txtSaveHTMLAs.text := SaveHTMLas;

      chkSaveAtt.checked := SaveAttachments;
      txtSaveAttDir.text := SaveAttachmentsDir;
      cbSaveAttReaction.Itemindex := Ord(ActionIfAttExists);

      With cbCSHeader do begin
         ItemIndex := Items.IndexOf(HeaderCharsets);
         If ItemIndex < 0 then ItemIndex := 0
      end;
      With cbCSBody do begin
         ItemIndex := Items.IndexOf(BodyCharsets);
         If ItemIndex < 0 then ItemIndex := 0
      end;
      cbDefaultEncoding.ItemIndex := DefaultEncoding;
      cbDefaultEncoding.OnChange (nil);
      chkConvertQP.checked := ConvertQP;
      chkConvertBase64.checked := ConvertBase64;
      chkConvert8Bit.checked := Convert8Bit;
      { Header I }
      chkMinBodyCharset.checked := MinBodyCharset;
      chkISO.checked := CheckMIMEHeaders;
      chkDelWas.checked := CheckKillWasAfterRe;
      chkDelMultiRes.checked := DelDoubleRes;
      txtRes.text := ConvertXXToRe;
      chkReplaceSubject8Bits.checked := CheckReplaceSubject8Bits;
      chkCheckFromReplyFormat.checked := CheckFromReplyFormat;
      chkSetLines.checked := SetLines;
      { Header II }
      cbSetDate.ItemIndex := SetDateHeader;
      With cbDateFormat do
         If DateHeaderTypeGMT then ItemIndex := 0
                              else ItemIndex := 1;
      txtMaxRef.text := IntToStr(MaxReferencesLen);
      txtSortHeader.text := SortHeader;
      chkRefFolding.checked := FoldingReferences;
      { Header III }
      txtKillMID.text := StringsToStr(LKillMessageIDBegins, ',');
      chkHamsterheaderFirst.checked := HamsterheaderFirst;
      chkRCPTto.checked := RecreateRCPT_To;
      chkRCPTtoAlways.checked := RecreateRCPT_To_Always;
      { Body }
      chkXHeader.checked := AllowXHeader;
      chkSonstHeader.checked := AllowAnyHeader;
      txtSigTrenner.text := ConvertToSig;
      chkQuoting.checked := CheckQuotes;
      chkSpaceBefText.checked := AddSpaceBetweenQuoteAndText;
      chkSpaceBetween.checked := SpaceBetweenDifferentQuoteChars;
      txtZitatzeichen.text := AllowedQuoteChars;
      txtDoNot1.text := DoNotChangeBegin;
      txtDoNot2.text := DoNotChangeEnd;
      chkNoCheckAfterSig.checked := DontCheckSig;
      chkDeleteEmptyLines.checked := DeleteEmptyLines;
      txtSigFile.text := SigFile;
      chkDelKammQuoting.checked := CheckOEZitate;
      chkBoxQuotes.checked := ConvertBoxQuotes;
      chkFootnotes.checked := ConvertFootnotes;
      chkOneliner.Checked := ConvertOneliners;
      chkReFormat.checked := ConvertReFormats;
      chkBlankLineBeforeSig.checked := BlankBeforeSig;
      chkBlankBeforeLines.checked := BlankBeforeLines;
      memKillHeaderlines.Lines.Assign(lDelXHeader);
      txtDelAtBegin.text := DelAtBegin
   end
end;
procedure TFrmMain.Put (Const Nr: Integer);
begin
   With lAbschnitte.Objects[Nr-1] as TKNEinstellungen do begin
      { Allgemein }
      WorkPath := txtMessagePath.text;
      FilePath := txtFilePath.text;
      HeaderDef := txtHeaderDef.text;
      TestExt := txtTestExt.text;
      ConvertToExt := txtRenameTo.text;
      MakeBAK := chkBackup.checked;
      SafeReg1 := StrToIntDef(txtSafeReg1.text, 0);
      SafeReg2 := StrToIntDef(txtSafeReg2.text, 0);
      RightTrim := chkTrimRight.checked;
      HTML2text := chkHTML2text.checked;
      SaveHTMLas := txtSaveHTMLAs.text;

      SaveAttachments := chkSaveAtt.checked;
      SaveAttachmentsDir := txtSaveAttDir.text;
      ActionIfAttExists := TActionIfAttExists(cbSaveAttReaction.Itemindex);

      With cbCSHeader do If ItemIndex < 1 then HeaderCharsets :=  '' else HeaderCharsets := Items[ItemIndex];
      With cbCSBody do If ItemIndex < 1 then BodyCharsets := '' else BodyCharsets := Items[ItemIndex];
      DefaultEncoding := cbDefaultEncoding.ItemIndex;
      Convert8Bit := chkConvert8Bit.checked;
      ConvertQP := chkConvertQP.checked;
      ConvertBase64 := chkConvertBase64.checked;
      { Header I }
      MinBodyCharset := chkMinBodyCharset.checked;
      CheckMIMEHeaders := chkISO.checked;
      CheckKillWasAfterRe := chkDelWas.checked;
      DelDoubleRes := chkDelMultiRes.checked;
      ConvertXXToRe := txtRes.text;
      CheckReplaceSubject8Bits := chkReplaceSubject8Bits.checked;
      CheckFromReplyFormat := chkCheckFromReplyFormat.checked;
      SetLines := chkSetLines.checked;
      { Header II }
      SetDateHeader := cbSetDate.ItemIndex;
      DateHeaderTypeGMT := cbDateFormat.ItemIndex = 0;
      MaxReferencesLen := StrToIntDef(txtMaxRef.text, 0);
      SortHeader := txtSortHeader.text;
      FoldingReferences := chkRefFolding.checked;
      { Header III }
      StrToStrings (txtKillMID.text, LKillMessageIDBegins, ',', true);
      HamsterheaderFirst := chkHamsterheaderFirst.checked;
      RecreateRCPT_To := chkRCPTto.checked;
      RecreateRCPT_To_Always := chkRCPTtoAlways.checked;
      { Body }
      AllowXHeader := chkXHeader.checked;
      AllowAnyHeader := chkSonstHeader.checked;
      ConvertToSig := txtSigTrenner.text;
      CheckQuotes := chkQuoting.checked;
      AddSpaceBetweenQuoteAndText := chkSpaceBefText.checked;
      SpaceBetweenDifferentQuoteChars := chkSpaceBetween.checked;
      AllowedQuoteChars := txtZitatzeichen.text;
      DoNotChangeBegin := txtDoNot1.text;
      DoNotChangeEnd := txtDoNot2.text;
      DontCheckSig := chkNoCheckAfterSig.checked;
      DeleteEmptyLines := chkDeleteEmptyLines.checked;
      SigFile := txtSigFile.text;
      CheckOEZitate := chkDelKammQuoting.checked;
      ConvertBoxQuotes := chkBoxQuotes.checked;
      ConvertFootnotes := chkFootnotes.checked;
      ConvertOneliners := chkOneliner.Checked;
      ConvertReFormats := chkReFormat.checked;
      BlankBeforeSig := chkBlankLineBeforeSig.checked;
      BlankBeforeLines := chkBlankBeforeLines.checked;
      lDelXHeader.Assign(memKillHeaderlines.lines);
      DelAtBegin := txtDelAtBegin.text
   end
end;

procedure TFrmMain.FormDestroy(Sender: TObject);
Var i: Integer;
begin
   With lAbschnitte do begin
      For i:=0 to Count-1 do
         (Objects[i] as TKNEinstellungen).free;
      free
   end;
   With TIniFile.Create(ExtractFilePath(ParamStr(0))+'Specials.ini') do try
      WriteInteger('CfgMain', 'Position', l.ItemIndex);
      WriteInteger('CfgMain', 'Page', pg.ActivePage.PageIndex);
   finally
      free
   end
end;

procedure TFrmMain.butAbortClick(Sender: TObject);
begin
   close
end;

procedure TFrmMain.butOkClick(Sender: TObject);
Var i: Integer;
begin
   If LastNr > 0 then Put(LastNr);
   With lAbschnitte do
      For i:=0 to Count-1 do With Objects[i] as TKNEinstellungen do begin
         Dateiname := IniDatei; Abschnitt := Strings[i]; WriteSettings
      end;
   close
end;

procedure TFrmMain.lClick(Sender: TObject);
Var Nr: Integer; 
begin
   Nr := l.ItemIndex;
   frAllgemein.visible := Nr = 0;
   pg.visible := Nr > 0;
   If Nr <> LastNr then begin
      If LastNr > 0 then Put(LastNr);
      LastNr := Nr
   end;
   If Nr > 0 then Get(Nr);
   butDel.enabled := (Nr>0);
   butKopie.enabled := (Nr>0)
end;

procedure TFrmMain.butNeuClick(Sender: TObject);
Var s: String; p: Integer;
begin
   If InputQuery('Neuen Abschnitt erzeugen', 'Wie soll der Abschnitt heien?', s) then begin
      If lAbschnitte.IndexOf(s)<0 then begin
         p := lAbschnitte.AddObject (s, TKNEinstellungen.Create);
         If (LastNr>0) and (LastNr >= p) then Inc(LastNr);
         If Sender = butKopie then If LastNr>0 then begin
            With lAbschnitte.Objects[lastNr-1] as TKNEinstellungen do begin
               Dateiname := INIDatei; Abschnitt := s; WriteSettings
            end
         end;
         With LAbschnitte.Objects[p] as TKNEinstellungen do begin
            Dateiname := IniDatei; Abschnitt := s;
            ReadSettings(true); WriteSettings
         end;
         FuelleListe
      end
   end
end;

procedure TFrmMain.butDelClick(Sender: TObject);
begin
   If (LastNr>0) and (MessageBox (handle, PChar('Soll der aktuelle Abschnitt wirklich gelscht werden?'),
      PChar('Abschnitt lschen'), MB_ICONWARNING+MB_YESNO) = IDYES)
   then begin
      With TIniFile.Create(IniDatei) do try
         EraseSection (lAbschnitte[LastNr-1])
      finally free end;
      lAbschnitte.Objects[LastNr-1].free;
      lAbschnitte.Delete(LastNr-1);
      LastNr := 0; FuelleListe
   end
end;

procedure TFrmMain.butHeaderDefEditClick(Sender: TObject);
Var s: String;
begin
   s := txtFilePath.text;
   If s='' then s := ExtractFilePath(ParamStr(0));
   If Copy(s, Length(s), 1)<>'\' then s:=s+'\';
   s := s + txtHeaderDef.text;
   If Not FileExists(s) then TFileStream.Create(s, fmCreate).free;
   ShellExecute (handle, PChar('Open'), PChar('Notepad.exe'),
                 PChar(s), NIL, SW_SHOWNORMAL)
end;

procedure TFrmMain.butSigFileEditClick(Sender: TObject);
Var s: String;
begin
   s := txtSigFile.text;
   If ExtractFilePath(s)='' then begin
      If txtFilePath.text > '' then s := ExtractFilePath(txtFilePath.text)+s
                               else s := ExtractFilePath(ParamStr(0))+s
   end;
   If s>'' then ShellExecute (handle, PChar('Open'), PChar('Notepad.exe'),
                              PChar(s), NIL, SW_SHOWNORMAL)
end;

procedure TFrmMain.Button1Click(Sender: TObject);
Var x: Word;
begin
   x := ShellExecute(GetDesktopWindow, NIL,
                     PChar(ExtractFilePath(ParamStr(0))+'Korrnews.htm'),
                     nil, nil, SW_SHOW);
   If x < 32 then ShowMessage('Sorry, Korrnews.htm ist leider nicht vorhanden...')
end;

procedure TFrmMain.Button2Click(Sender: TObject);
begin
   With TDlgAssistent.Create(nil) do try
      Abschnitte := lAbschnitte;
      ShowModal
   finally free end;
   FuelleListe
end;

procedure TFrmMain.Button4Click(Sender: TObject);
begin
   ConfigBoxQuotes
end;

procedure TFrmMain.Button3Click(Sender: TObject);
begin
   ConfigFussnoten
end;

procedure TFrmMain.Button5Click(Sender: TObject);
begin
   ConfigOneLinerAndReformat
end;

procedure TFrmMain.cbDefaultEncodingChange(Sender: TObject);
Var x: Integer;
begin
   x := cbDefaultEncoding.ItemIndex;
   chkConvert8Bit.enabled := x <> 0;
   chkConvertQP.enabled := x <> 1;
   chkConvertBase64.enabled := x <> 2;
end;

procedure TFrmMain.Button6Click(Sender: TObject);
begin
   ConfigDefaultCharset
end;

end.





