unit uKNSkr;

interface

Uses uSkript, uHeader, uArtikel, uGetStr, uGetNum, uCSMap, uMimeInf,
     Settings, classes, uVarList;

Const
   Titel = {$IFDEF CopyIf} 'CopyIf ' {$ELSE} 'KorrNews ' {$ENDIF} + 'V'+Ver;

   Extraheader_ConvertHeader = 'X-CopyIf-Converted-Headers: ';
   Extraheader_ConvertBody = 'X-CopyIf-Converted-Body: ';
   Extraheader_OEBeginBug = 'X-CopyIf-OE-Begin-Bug: Fixed!';
   Extraheader_OEKillFalseReBug = 'X-CopyIf-OE-KillFalseRe-Bug: Fixed!';
   Extraheader_RepairOE = 'X-CopyIf-Repaired-OE-Quoting: ';

   HeaderSubject = 'subject: ';
   HeaderReferences = 'references: ';
   XHeaderbegin = 'X-';
   HamsterFrom = '!MAIL FROM';
   HamsterTo = '!RCPT TO';

   kRe = 're:'; kWasbegin = '(was:'; kWasEnde = ')';

Type
   TLevel = -1..30;

   TReplaceMode = (rmAll, rmFirst, rmLast);
   TReplaceWhere = (rwBody, rwSig, rwLines, rwHeader, rwHeader2, rwIntro, rwVar);

   TVerglTyp = (vtNix, vtLike, vtGleich, vtUngleich, vtBeginnt, vtEndet, vtEnthaelt, vtIn, vtIstLeer,
                vtKleiner, vtGroesser, vtGroesserGleich, vtKleinerGleich, vtBetween);
   TVerknuepfungsTyp = (vtFirst, vtOr, vtXor, vtAnd);

   TKNSkript = Class(TSkript)
   private
      Opt: TKNEinstellungen;
      Vars: TVarList;
      slBodyHeader: THeader;
      slStack, slOptionenKey, slOptionenValue: TStringlist;
      fDateiname: String;
      // BodyCharsets, HeaderCharsets: TCharsets;
      Artikel: TArtikel;
      Only7Bit, Only7BitTested: boolean;
      Retry: TRetry;
      Level: TLevel; Bed, Done: Array[TLevel] of Boolean; // Bedingte Ausfhrung
      FalscheMessageID, RichtigeMessageID: String;
      BodyCharsets, HeaderCharsets: TCharsets;
      Function AktIntro: TStringList;
      Function AktIntroExists: Boolean;
      Function AktLines: TStringList;
      Function AktLinesExists: Boolean;
   public
      slAppend, slFN: TStringlist;
      Constructor Create (Const AktDatei: String; AktOptionen: TKNEinstellungen; AktArtikel: TArtikel);
      Destructor Destroy; override;
      Procedure Clear;
      Function Filename_HeaderDef: String;
      Function FilePath: String;
      Function ErgaenzeDateiname (Const d: String): String;
      Procedure Reload;
      // Ablaufsteuerung
      Procedure Check_ExtraHeader_einsetzen;
      Procedure ExecLine;
      Procedure InterpreteLine (Var ML: Integer);
      Procedure InterpreteCommand (Var s: String);
      Procedure Stop;
      Function FindSub (Const Bez: String; Var Z: Integer; Var Pars: String): boolean;
      Function FindGoto (Const Bez: String; Var Z: Integer): boolean;
      // Bool-Funktionen
      Function TestBedingung(Var s: String): boolean;
      Function TestChanged: Boolean;
      // String-Funktionen
      Procedure RegZusatzStringFunktionen;
      Procedure UnregZusatzStringFunktionen;
      Function ZusatzStringFunktionen (Var Pars: TStrParameter): String;
      Function NextMatchedLine (Const ab: Integer; Const Reg: String): Integer;
      Function CountMachedLines (Const Reg: String): Integer;
      // Numerische Funktionen
      Procedure RegZusatzNumerischeFunktionen;
      Procedure UnregZusatzNumerischeFunktionen;
      Function ZusatzNumerischeFunktionen (Var Pars: TNumParameter): Double;
      // Variablen
      Function GetValueAsStr(Var s: String; Const vt: TVarTyp): String;
      Function TestIfVarName (Var s, VarName: String): TRVN; // GetVarName
      Function TestExistingStrVar (Var s, VarName: String): boolean; // GetVarName
      Function GetVarValueStr(Const VarName: String): String;
      Function GetVarValueNum(Const VarName: String): Double;
      Procedure SetzeVariablenInhalt (Const VarName: String; Var s: String);
      //
      Procedure Fehler (Const Beschreibung, Rest: String);
      Procedure DeleteBodyHeader(Const Header: String);
      Procedure InsertBodyHeader;
      Function SetzeOption (Const s: String): boolean;
      Function TestOnly7Bit: Boolean;
      Procedure SaveAttachment (Const Pfad, Dateiname: String; Const Action: TActionIfAttExists);
      // Schleifen, Stack & Co
      Procedure ForNextOnStack (Const ZeilenNr: Integer; Const VarBez: String;
         Const Ab, Bis, Step: Double);
      Procedure TestNext;
      Procedure RepeatOnStack (Const ZeilenNr: Integer);
      Procedure TestUntil;
      Procedure WhileOnStack (Const ZeilenNr: Integer; Const Bedingung: String);
      Procedure TestWend;
      Procedure LoopOnStack (Const ZeilenNr: Integer);
      Procedure TestLoop;
      Procedure TestBreak;
      Procedure TestContinue;
      Procedure TestEndSub;
      Procedure ClearStackBetween (Const Ab, Bis: Integer);
      // Komfortfunktionen (Body)
      Procedure ReplaceInBody (Const Reg, Ersatz: String; Const Modus: TReplaceMode;
        Const Where: TReplaceWhere; Const VarName: String; Const AbZeile, BisZeile: Integer);
      Function LoescheZwischen (Const Erstem: boolean; Const Such1, Such2: String;
        Const DelSuch, SetzeErsatztext: boolean; Const Ersatz: String): boolean;
      Procedure ExpandiereMakro (Const Vergleich: String; slErsatz: TStringlist);
      Procedure Check_ConvertOEBeginBug;
      Procedure Check_OE_Zitate;
      Procedure Check_ConvertHTML2Text;
      Procedure Check_ConvertOEKillFalseReBug;
      Procedure ConvertBoxQuotes (Const Nr: Integer);
      Procedure ConvertMinBodyCharset;
      Procedure Check_MIMEHeader;
      Procedure Check_SetIntroduction;
      Procedure ConvertEncoding (Const K: TKodierung);
      Procedure Check_Fussnoten;
      Procedure Check_AppendFussnoten;
      Procedure Check_Reformat;
      Procedure Check_Oneliner;
      Procedure Check_AppendText;
      Procedure Check_BodyKorrekturen;
      Procedure DeleteEmptyLines;
      Procedure DeleteBlanksAtEndOfLines;
      // Komfortfunktionen (Header)
      Procedure Check_Headeranalyse;
      Procedure ConvertHeaderTo8Bit;
      Procedure SortHeader (Const Headerliste: String);
      Procedure Check_Empfaengerliste (Const Always: boolean);
      //
      Function InterpreteWildCards (Const s: String): String;
      Function Tested (Const s: String; Const TestWildCards: boolean): String;
      Procedure BlockAnhaengen (slAdd: TStrings; Const Rest: String; Const RawMode, Clear: boolean);
   end;

implementation

Uses Windows, Sysutils, ShellApi, inifiles, MMSystem,
     uISO, UPerlRe, uKNTools, uHTML2Te
     {$IFNDEF NOGUI}, Dialogs, DError {$ENDIF};

// ----------------------------------------------------------------------------------

Procedure TKNSkript.Clear;
begin
   Bed[Low(Bed)] := true;
   Only7BitTested := false;
   slBodyHeader.Clear;
   Vars.Clear; slStack.Clear;
   If slOptionenKey.Count > 0 then Opt.ReadSettings (false);
   slOptionenKey.Clear; slOptionenValue.Clear;
   slAppend.Clear;
end;

Constructor TKNSkript.Create (Const AktDatei: String; AktOptionen: TKNEinstellungen; AktArtikel: TArtikel);
begin
   inherited Create;
   fDateiname := AktDatei;
   Opt := AktOptionen;
   Artikel := AktArtikel;
   BodyCharsets := TCharsets.Create (Extra.InternalCharset, Opt.BodyCharsets);
   HeaderCharsets := TCharsets.Create (Extra.InternalCharset, Opt.HeaderCharsets);
   slBodyHeader := THeader.Create ( HeaderCharsets );
   slStack := TStringlist.Create;
   slAppend := TStringlist.Create;
   slFN := TStringlist.Create;
   Vars := TVarList.Create;
   slOptionenKey := TStringlist.Create;
   slOptionenValue := TStringlist.Create;

   Init_GetString (TestExistingStrVar, GetVarValueStr, Fehler);
   RegZusatzStringFunktionen;
   Init_GetNum (GetString, GetVarValueNum, Fehler);
   RegZusatzNumerischeFunktionen
end;

Destructor TKNSkript.Destroy;
begin
   slBodyheader.free;
   slStack.free;
   slAppend.free;
   slFn.free;
   Vars.free;
   slOptionenKey.free;
   slOptionenValue.free;
   BodyCharsets.Free;
   HeaderCharsets.Free;

   UnregZusatzStringFunktionen;
   UnregZusatzNumerischeFunktionen;

   inherited
end;

// ----------------------------------------------------------------------------------

Function TKNSkript.Filename_HeaderDef: String;
begin
   {$IFDEF CopyIf}
   Result := ChangeFileExt (ParamStr(0), '.def');
   {$ELSE}
   If Trim(Opt.HeaderDef) > ''
      then Result := Opt.FilePath + Opt.HeaderDef
      else Result := '';
   {$ENDIF}
end;

Function TKNSkript.FilePath: String;
begin
   {$IFDEF CopyIf}
   Result := ExtractFilePath (ParamStr(0));
   {$ELSE}
   Result := Opt.FilePath;
   {$ENDIF}
end;

Function TKNSkript.ErgaenzeDateiname (Const d: String): String;
begin
   If ((D+' ')[1]='\') or ((D+'  ')[2]=':')
      then Result := D
      else Result := FilePath + D
end;

Procedure TKNSkript.Reload;
Var i, j: Integer; s, s2: String;
    sl: TStringlist;
begin
   Clear;
   s := Filename_HeaderDef;
   If s > '' then begin
      sl := TStringlist.Create;
      try
         If Not FileExists(s) then begin
            If IDYES = Messagebox (0, PChar('Der header.def-Eintrag in den Einstellungen weist auf die Datei "'+s+'", '
                                  + 'welche allerdings nicht existiert. Soll eine leere Datei mit diesem '
                                  + 'Namen angelegt werden, um diese Warnmeldung in Zukunft zu vermeiden?'),
                           PChar('Keine Skript-Ausfhrung'),
                           MB_YESNO + MB_ICONQUESTION)
            then begin
               TFileStream.Create(s, fmCreate).free
            end
         end;
         If FileExists(s) then begin
            LoadTextFile (s, sl);
            Fill  (s, sl)
         end
      finally sl.free end;
   end;

   i := 0; j := 0;
   While i < Count do begin
      s := Trim(self[i].Inhalt); {Assert(s);}
      Zeile := i+1;
      If SucheUndKuerze('Do Include', s) and (j < 20) then begin
         If GetString (s, s2) then begin
            try
               ExpandLineToFile (i, ErgaenzeDateiname(s2))
            except
               On EInOutError do begin
                  Fehler ('Fehler beim Einlesen der Include-Datei "'+ErgaenzeDateiname(s2)+'"', s);
               end
            end;
         end else Fehler ('Nach "Do Include" mu noch der gewnschte Dateiname folgen', s);
         Inc(j)
      end else begin
         Inc(i); j := 0
      end
   end

end;

// ----------------------------------------------------------------------------------

Procedure TKNSkript.Check_ExtraHeader_einsetzen;
begin
   Level := 0;
   Bed[Level] := true;
   Retry := rNone;
   Zeile := 1;
   While (Zeile <= Count) and (Retry <> rEndProgram) do ExecLine
end;

Procedure TKNSkript.ExecLine;
Var ML: Integer;
begin
   try
      InterpreteLine (ML);
      Case Retry of
         rRetryLine: ;
         rJumpNextLineAndStop: Fehler('', '');
         rJumpNextLineAndRun: Zeile := Zeile + ML + 1;
         else Zeile := Zeile + ML + 1
      end;
   except
      On EAbort do Case Retry of
         rJumpNextLineAndRun: begin Zeile := Zeile + ML + 1; Retry := rNone end;
         rJumpNextLineAndStop: Zeile := Zeile + ML + 1;
         rEndProgram: exit;
         rRetryLine: Retry := rNone;
         else Exit
      end
   end
end;

Procedure TKNSkript.InterpreteLine (Var ML: Integer);
Var ok, b, Einzeiler: boolean; s, s2, s3: String; ab, bis, step: Double;
    rvn: TRVN; V: TVarObj;
begin
   s := Trim(self[Zeile-1].Inhalt);
   ML := 0;
   { Kommentare }
   If (s > '') and Not (s[1] IN['#', ';', ':']) then begin
      { Multi-Line... }
      While (s[Length(s)]='_') and (Zeile+ML < Count) do begin
         Inc(ML); s := Trim ( Copy(s, 1, Length(s)-1) + self[Zeile-1+ML].Inhalt)
      end;
      With TIniFile.Create(ExtractFilePath(ParamStr(0))+'KNDebug.txt') do try
         WriteString ('Interprete Line', 'DateTime', DateToStr(Now));
         WriteString ('Interprete Line', 'Filename', fDateiname);
         WriteString ('Interprete Line', 'Line#', Inttostr(Zeile));
         WriteString ('Interprete Line', 'Line', s);
      finally free end;
      { If? }
      Case self[Zeile-1].Typ of
         ztLine: begin
            If SucheUndKuerze('if', s) then begin
               If Bed[Level] then begin
                  b := TestBedingung(s);
                  Einzeiler := SucheUndKuerze('then', s) and (Trim(s)>'')
               end else begin
                  b := false;
                  If ContainsCommand(s, 'then', true)
                     then Einzeiler := Trim(s) > ''
                     else Einzeiler := false;
                  If Not Einzeiler then s := ''
               end;
               If Einzeiler then begin
                  If b then InterpreteCommand(s)
               end else begin
                  If Trim(s)>''
                     then Fehler ('Nach "If <Bedingung>" ist nur ein "then" zulssig, "'+s+'" ist nicht sinnvoll interpretierbar!', s);
                  If Level = High(TLevel)
                     then Fehler('Die maximale Anzahl ('+IntToStr(Level)+') an If-Schachtelungen wurde berschritten!', s);
                  Inc(Level);
                  Bed[Level] := b;
                  Done[Level] := (Not Bed[Level-1]) or Bed[Level]; { Erledigt, wenn Vorebene gesperrt oder If-Zweig gltig }
               end
            { "Else If" }
            end else If SucheUndKuerze('elseif', s) or SucheUndKuerze('else if', s) then begin
               If Level > 0 then begin
                  If Not Done[Level] then begin
                     Bed[Level] := TestBedingung(s);
                     If Bed[Level] then Done[Level] := true
                  end else Bed[Level] := false
               end else Fehler('Kein passendes "If" zum "EndIf"', s)
            { "Else" }
            end else If Lowercase(s)='else' then begin
               If Level > 0 then begin
                  Bed[Level] := Not Done[Level]; Done[Level] := true
               end else Fehler('Kein passendes "If" zum "EndIf"', s)
            { "If" beenden }
            end else If Lowercase(Copy(s,1,5)) = 'endif' then begin
               If Level > 0 then Dec(Level) else Fehler('Kein passendes "If" zum "EndIf"', s)
            { Normale Zeile }
            end else If Bed[Level] then begin
               InterpreteCommand (s)
            end
         end;
         ztFor, ztForNext: If Bed[Level] then begin
            If SucheUndKuerze('For', s) then begin
               ok := false;
               rvn := TestIfVarname(s, s2);
               If rvn = vnNew
                  then V := Vars.Add (s2, vtStr)
                  else V := Vars[s2];
               If ( (rvn=vnNew) or ((rvn=vnExist) and (V.Typ IN [vtStr, vtFloat, vtInt])) )
                  and SucheUndKuerze('=', s)
                  and GetNumber (s, ab)
                  and SucheUndKuerze('to', s)
                  and GetNumber (s, bis)
               then begin
                  Step := 1;
                  If SucheUndKuerze('Step', s) and GetNumber(s, Step) then;
                  If SucheUndKuerze('do', s) then begin
                     ok := true;
                     If (Ab=Bis) or (Sgn(Bis-Ab) = Sgn(Step)) then Repeat
                        V.asFloat := Ab;
                        s3 := s; InterpreteCommand(s3);
                        Ab := Ab + Step
                     Until Sgn(Bis-Ab) <> Sgn(Step)
                  end else begin
                     ok := (Trim(s) = '');
                     If Abs(Step) < 0.0000000001 then Fehler('Schrittweite in For-Variable darf nicht gleich 0 sein!', '');
                     If ok then ForNextOnStack (Zeile, s2, Ab, Bis, Step);
                     TestNext
                  end
               end;
               If not ok then Fehler('Falsche "For"-Syntax: For %Variable% = <Anfangswert> to <Endwert> [ Step <Schrittweite> ] wre korrekt!', s)
            end
         end;
         ztNext: If Bed[Level] then TestNext;
         ztDo: If Bed[Level] then LoopOnStack (Zeile);
         ztLoop: If Bed[Level] then TestLoop;
         ztRepeat: If Bed[Level] then RepeatOnStack (Zeile);
         ztUntil: If Bed[Level] then TestUntil;
         ztWhile: If Bed[Level] then begin
            If SucheUndKuerze('While', s) and (Trim(s)>'')
               then begin WhileOnStack (Zeile, s); TestWend end
               else Fehler('Falsche "While"-Syntax: While <Bedingung>', s)
         end;
         ztWend: If Bed[Level] then TestWend;
         ztSelectCase: ;
         ztCase: ;
         ztCaseElse: ;
         ztEndSelect: ;
         ztSub: begin
            If SucheUndKuerze('Sub', s) then begin
               Repeat
                  Zeile := Zeile + 1;
                  If Zeile > Count then Fehler('Kein "End sub" fr "Sub '+s+'"', '')
               Until self[Zeile-1].Typ = ztEndsub
            end
         end;
         ztEndSub: TestEndsub;
      end
   end
end;

Procedure TKNSkript.InterpreteCommand (Var s: String);
Const MaxPar = 20;
Var s2, s3, s4, s5, AktHeader, AktInhalt: String;
    ok, b, b2, b3, Warten: boolean;
    i, p, Anz1, Anz2: Integer;
    ab, bis, Zahl: Double;
    aPars, aVars: Array[1..MaxPar] of String;
    aIsVar: Array[1..MaxPar] of boolean;
    aTyp: Array[1..MaxPar] of TVarTyp;
    x: Word; L: DWord;
    SetHeader, AppendHeader, RawMode: Boolean;
    rm: TReplaceMode; rw: TReplaceWhere;
    sltemp: TStringlist;
    IfExistsAction: TActionIfAttExists;
    V: TVarObj; vt: TVarTyp;
begin
   SetHeader := false; AppendHeader := false; RawMode := false;
   s2 := Trim(LowerCase(s));
   { Ablaufsteuerung }
   if TestIfVarName(s, s3) <> vnIllegal then SetzeVariableninhalt (s3, s)
   else If SucheUndKuerze('stop', s) then Retry := rJumpNextLineAndStop {sssFehler ('', s)}
   else If SucheUndKuerze('quit', s) then begin
      Retry := rEndProgram; exit
   end
   else If SucheUndKuerze('Next', s) then TestNext
   else If SucheUndKuerze('gosub', s) then begin
      If GetWord(s, s2) then begin
         If FindSub(s2, p, s3) then begin
            { Variablendeklaration der Sub }
            Anz2 := 0;
            While Trim(s3) > '' do begin
               Inc(Anz2);
               aIsVar[Anz2] := SucheUndKuerze('Var', s3);
               If TestIfVarName(s3, s4) <> vnIllegal then begin
                  aVars[Anz2] := s4;
                  If SucheUndKuerze(':', s3) and Vars.SucheTypName(s3, vt)
                     then aTyp[Anz2] := vt
                     else aTyp[Anz2] := vtStr;
                  If (Trim(s3)>'') and (Not SucheUndKuerze(',',s3))
                     then Fehler('Die Parameterliste von Sub "'+s2+'" enthlt Fehler', s)
               end else Fehler('Die Parameterliste von Sub "'+s2+'" enthlt Fehler', s)
            end;
            { bergebene Parameter }
            Anz1 := 0;
            If Trim(s)>'' then begin
               If Not Klammerung(s, s3, true) then begin
                  s3 := s; s := ''
               end;
               While Trim(s3) > '' do begin
                  Inc(Anz1);
                  If Anz1 > Anz2 then break;
                  If aIsVar[Anz1] then begin
                     Case TestIfVarName(s3, s4) of
                        vnIllegal: Fehler('Als '+Inttostr(Anz1)+'. Parameter wird ein Variablenname erwartet', s);
                        vnNew: Vars.Add(s4, aTyp[Anz1]);
                     end;
                     aPars[Anz1] := s4;
                     If (Trim(s3)>'') and (Not SucheUndKuerze(',',s3))
                        then Fehler('Ungltige Parameterliste', s)
                  end else begin
                     aPars[Anz1] := GetValueAsStr(s3, aTyp[Anz1]);
                     If (Trim(s3)>'') and (Not SucheUndKuerze(',',s3))
                        then Fehler('Ungltige Parameterliste beim Aufruf von Sub "'+s2+'"', s)
                  end
               end
            end;
            { Weiter gehts }
            If Anz1 <> Anz2 then Fehler('Anzahl der Parameter fr Sub "'+s2+'" stimmt nicht!', s);
            Vars.AddLocalVars (s2, aVars, aTyp, aPars, aIsVar);
            slStack.InsertObject(0, 'Sub '+s2, Pointer(Zeile));
            Zeile := p+1
         end else Fehler ('Kein "Sub '+s2+'" im Skript auffindbar!', s)
      end else Fehler('Hinter "GoSub" mu noch der Name der gewnschten Sub-Routine folgen!', s)
   end
   else If s2='return' then TestEndSub
   else If s2='break' then TestBreak
   else If (s2='cont') or (s2='continue') then TestContinue
   else If SucheUndKuerze('goto', s) then begin
      If GetWord(s, s2) then begin
         If FindGoto(s2, p) then begin
            ClearStackBetween (Zeile, p+1);
            Zeile := p+1
         end else Fehler ('Kein Label ":'+s2+'" im Skript auffindbar!', s)
      end else Fehler('Hinter "GoTo" mu noch der Name des gewnschten Labels (ohne ":" davor) folgen!', s)
   end
   { Variablendeklarationen }
   else If SucheUndKuerze('Var', s) then begin
      b := true;
      If SucheUndKuerze ('local', s) then b := true
      else If SucheUndKuerze('global', s) then b := false;
      With TStringlist.Create do try
         While Trim(s) > '' do begin
            Clear;
            Repeat
               If TestIfVarName (s, s2) = vnIllegal
                  then Fehler('"'+s+'" ist kein korrekter Variablenname', s);
               Add (s2);
            Until Not SucheUndKuerze(',', s);
            If Not SucheUndKuerze(':', s)
               then Fehler('Nach dem Variablennamen(liste) mu ein Doppelpunkt und ein Variablentyp folgen', s);
            If Not Vars.SucheTypName(s, vt)
               then Fehler('Kein zulssiger Variablentyp, nur Integer, String, Float und Boolean sind zulssig', s);
            s3 := '';
            If SucheUndKuerze('=', s) then s3 := GetValueAsStr(s, vt);
            For i := 0 to Count-1 do begin
               If b
                  then Vars.AddLocal(Strings[i], vt).asString := s3
                  else Vars.Add(Strings[i], vt).asString := s3
            end;
            SucheUndKuerze(',', s);
            SucheUndKuerze(';', s);
         end
      finally free end
   end
   { Set-Befehle/Modi aktivieren }
   else If SucheUndKuerze('Set', s) then With Artikel.Part do begin
      RawMode := SucheUndKuerze('raw', s);
      If SucheUndKuerze('Introduction', s) or SucheUndKuerze('Intro', s) then begin
         BlockAnhaengen (AktIntro, s, RawMode, true)
      {$IFDEF CopyIf}
      {$ELSE}
      end else If SucheUndKuerze('Sig', s) or SucheUndKuerze('Signature', s) then begin
         Zahl := 0;
         If Copy(s,1,1)='#' then begin
            Delete(s,1,1);
            If Not GetNumber(s, Zahl) then
               Fehler('Hinter "Set Sig #" mu die Nummer der gewnschten Signatur folgen!', s)
         end;
         Only7BitTested := false;
         BlockAnhaengen(Sig, s, RawMode, true);
         ChooseSig(Sig, Trunc(Zahl));
      end else If SucheUndKuerze('Lines', s) or SucheUndKuerze('Line', s) then begin
         BlockAnhaengen (slAppend, s, RawMode, true)
      end else If SucheUndKuerze('Macro', s) then begin
         If GetString(s, s2) or (Length(s2)<6) then begin
            slTemp := TStringlist.Create;
            try
               BlockAnhaengen(slTemp, s, RawMode, true);
               ExpandiereMakro (s2, slTemp)
            finally slTemp.free end;
         end else Fehler('Hinter "Set Macro" mu noch der Name des Macros folgen, dieser Name mu mindestens 6 Zeichen umfassen', s)
      {$ENDIF}
      end else If SucheUndKuerze('Header', s) or SucheUndKuerze('H', s) then begin
         If Trim(s) > '' then SetHeader := true
         else begin
            slTemp := TStringlist.Create;
            try
               BlockAnhaengen(slTemp, s, RawMode, true);
               If slTemp.Count > 0 then begin
                  s := slTemp[0];
                  While slTemp.Count > 1 do begin
                     s := s + #13#10 + slTemp[1];
                     slTemp.Delete(1)
                  end;
                  SetHeader := true; RawMode := true
               end
            finally
               slTemp.free
            end
         end
      end else
      If SucheUndKuerze('Headercontent', s) then begin
         If GetNumber (s, Zahl) and (Trunc(Zahl) > 0) and (Trunc(Zahl) <= Artikel.Header.Count) then begin
            slTemp := TStringlist.Create;
            try
               BlockAnhaengen(slTemp, s, RawMode, true);
               s2 := slTemp[0];
               For i := 1 to slTemp.Count-1 do begin
                  s3 := slTemp[i];
                  If s3 > '' then begin
                     If Not (s3[1] IN[' ',^I]) then s3 := ' '+s3;
                     s2 := s2 + s3
                  end
               end;
            finally slTemp.free end;
            s2 := Artikel.Header.Name[Trunc(Zahl)-1]+': '+s2;
            If Not RawMode then s2 := EncodeISO(HeaderCharsets, s2);
            Artikel.Header[Trunc(Zahl)-1] := s2
         end else  Fehler('Hinter "Set HeaderContent" mu noch die Zeilennummer folgen', s)
      end else
      If SucheUndKuerze('Bodyline', s) then begin
         If GetNumber (s, Zahl) then begin
            slTemp := TStringlist.Create;
            try
               BlockAnhaengen(slTemp, s, RawMode, true);
               s2 := slTemp.text; i := Length(s2);
               If (i >= 2) and (s2[i-1]=#13) and (s2[i]=#10) then Delete(s2, i-1, 2);
               If Body[Trunc(Zahl)-1] <> s2 then Body[Trunc(Zahl)-1] := s2;
            finally slTemp.free end
         end else  Fehler('Hinter "Set Bodyline" mu noch die Zeilennummer folgen', s)
      end else
      If SucheUndKuerze('Option', s) or SucheUndKuerze('Opt', s) then begin
         If Not SetzeOption (s) then
            Fehler('Fehlerhafter "Set Option"-Befehl, korrekt wre: Set Option INIWert = Wert', s)
      end else if TestIfVarName(s, s2) <> vnIllegal then begin
         SetzeVariablenInhalt (s2, s)
      end else begin
         {$IFDEF CopyIf}
         Fehler ('Unbekannter Set-Befehl "'+s
             +'" (z.Z. nur Variablenname, "H[eader]", "Intro[duction]" und "Option" erlaubt)', s)
         {$ELSE}
         Fehler ('Unbekannter Set-Befehl "'+s
             +'" (z.Z. nur Variablenname, "H[eader]", "Intro[duction]", "Line[s]", '
              + '"Sig[nature]", "Macro" und "Option" erlaubt)', s)
         {$ENDIF}
      end
   end else If SucheUndKuerze('Append', s) then With Artikel.Part do begin
      RawMode := SucheUndKuerze('raw', s);
      If SucheUndKuerze('Introduction', s) or SucheUndKuerze('Intro', s) then begin
         BlockAnhaengen (AktIntro, s, RawMode, false)
      end else If SucheUndKuerze('Header', s) or SucheUndKuerze('H', s) then begin
         SetHeader := true; AppendHeader := true
      end else If SucheUndKuerze('Lines', s) or SucheUndKuerze('Line', s) then begin
         BlockAnhaengen (slAppend, s, RawMode, false)
      end else If SucheUndKuerze('Signature', s) or SucheUndKuerze('Sig', s) then begin
         Zahl := 0;
         If Copy(s,1,1)='#' then begin
            Delete(s,1,1);
            If Not GetNumber(s, Zahl) then
               Fehler('Hinter "Set Sig #" mu die Nummer der gewnschten Signatur folgen!', s)
         end;
         slTemp := TStringlist.Create;
         BlockAnhaengen(slTemp, s, RawMode, true);
         ChooseSig(slTemp, Trunc(Zahl));
         Artikel.Part.Sig.AddStrings (slTemp);
         slTemp.free
      end else if TestIfVarName(s, s2) <> vnIllegal then begin
         If Not Vars.Exists(s2)
            then Fehler ('Die Variable %'+s2+'% ist noch nicht definiert, Anhngen ist daher unmglich', s);
         V := Vars[s2];
         If V.Typ <> vtStr
            then Fehler ('Die Variable %'+s2+'% ist keine Stringvariable, Anhngen ist daher unmglich', s);
         slTemp := TStringlist.Create;
         try
            BlockAnhaengen(slTemp, s, RawMode, true);
            s := slTemp[0];
            While slTemp.Count > 1 do begin
               s := s + #13#10 + slTemp[1];
               slTemp.Delete(1)
            end;
            V.asString := V.asString + CRLF + s
         finally
            slTemp.free
         end
      end else begin
         Fehler('Unbekannter Append-Befehl "'+s
             +'" (z.Z. nur "Intro[duction]", "Line[s]", "Sig[nature]", "H[eader]" und Variablenname erlaubt)', s)
      end
   end else If SucheUndKuerze('Insert', s) then begin
      If SucheUndKuerze('BodyLine', s) then begin
         If GetNumber(s, ab) and SucheUndKuerze('=', s) and GetString(s, s2) then begin
            i := Trunc(ab)-1; If i < 0 then i := 0;
            s2 := Tested(s2, false);
            If i < Artikel.Part.body.Count
               then Artikel.Part.Body.Insert (i, s2)
               else Artikel.Part.Body.Append (s2);
         end else Fehler('Falsche Syntax, korrekt wre: "Insert BodyLine Zeile = Inhalt"', s)
      end else Fehler('Unbekannter Insert-Befehl "'+s +'" (z.Z. nur "Bodyline" erlaubt)', s)
   end else If SucheUndKuerze('Delete', s) then begin
      If SucheUndKuerze('Header', s) then begin
         s2 := s;
         If GetString(s, s3) and (s = '') then s2 := s3;
         While Artikel.Header.Change (s2, '') do;
      end else If SucheUndKuerze('Intro', s) or SucheUndKuerze('Introduction', s) then begin
         Artikel.Part.DeleteExtra('Intro'); Only7BitTested := false
      end else If SucheUndKuerze('Bodylines', s) then begin
         SucheUndKuerze('from', s);
         If GetNumber(s, ab) and SucheUndKuerze('to', s) and GetNumber(s, bis) and (Trim(s)='') then begin
            ab := Trunc(Ab)-1; If ab < 0 then ab := 0;
            bis := Trunc(bis)-1; If bis > Artikel.Part.Body.Count-1 then bis := Artikel.Part.Body.Count-1;
            If bis >= ab then begin
               For i:=0 to Trunc(bis-ab) do Artikel.Part.Body.Delete(Trunc(ab))
            end
         end else Fehler('Falsche Syntax, korrekt ist: "Delete BodyLines from <Zeile> to <Zeile>', s)
      end else If SucheUndKuerze('Bodyline', s) then begin
         If GetNumber(s, ab) and (Trim(s)='') then begin
            ab := Trunc(Ab)-1; If ab < 0 then ab := 0;
            If Trunc(ab) < Artikel.Part.Body.Count then Artikel.Part.Body.Delete(Trunc(ab))
         end else Fehler('Falsche Syntax, korrekt ist: "Delete BodyLine <Zeile>', s)
      end else If SucheUndKuerze('between', s) then begin
         ok := true; b3 := false;
         If SucheUndKuerze('last', s) then b3 := false
         else If SucheUndKuerze('first', s) then b3 := true
         else ok := false;
         If ok and GetString(s, s2) and SucheUndKuerze(',', s) and GetString(s, s3) and SucheUndKuerze(',', s) then begin
            ok := false;
            b := TestBedingung(s);
            b2 := SucheUndKuerze(',', s) and GetString(s, s4);
            If (s = '') and ((s2 > '') or b3) and ((s3 > '') or Not b3) then begin
               // b3: Erstes oder letztes Lschen, s2/s3: Regexp von/bis, b: Lsche Trenner?;
               // b2: Ersatztext?; s4: Ersatztext.    
               LoescheZwischen (b3, s2, s3, b, b2, s4); 
               ok := true
            end
         end;
         If not ok then Fehler('Falsche Syntax, korrekt ist: "Delete between ( first | last ) <regexp>, '
             +'<regexp>, Trenner mitlschen? [, Ersatztext]". Bei "first" mu zumindest der zweite '
             +'regexp-Ausdruck gefllt sein, bei "last" zumindest der erste regexp-Ausdruck.', s)
      end else If SucheUndKuerze('empty', s) then begin
         If SucheUndKuerze('Lines', s) and SucheUndKuerze('at', s) and SucheUndKuerze('end', s) and (Trim(s)='')
            then DeleteEmptyLines
            else Fehler('Nach "Delete empty" ist bislang nur "Lines at end" zulssig', s)
      end else If SucheUndKuerze('Blanks', s) then begin
         If SucheUndKuerze('at', s) and SucheUndKuerze('end', s)
            and SucheUndKuerze('of', s) and SucheUndKuerze('Lines', s) and (Trim(s)='')
         then DeleteBlanksAtEndOfLines
         else Fehler('Nach "Delete Blanks" ist bislang nur "at end of lines" zulssig', s)
      end else If SucheUndKuerze('part', s) then begin
         If SucheUndKuerze('because', s) and GetString(s, s2) then begin
            Artikel.Part.Body.Text := 'Gelscht: '+s2;
            If Artikel.Part.MimeInfo.Kodierung = kBase64 then Artikel.Part.ChangeEncoding (k8Bit)
         end else begin
            Fehler('Falsche Syntax, korrekt ist: "Delete Part because <Begrndung>"', s)
         end
      {$IFNDEF CopyIf}
      end else If SucheUndKuerze('sig', s) or SucheUndKuerze('signature', s) then begin
         Artikel.Part.Sig.Clear; Only7BitTested := false
      end else If SucheUndKuerze('BodyHeader', s) then begin
         DeleteBodyHeader(s)
      end else If SucheUndKuerze('Line', s) or SucheUndKuerze('Lines', s) then begin
         slAppend.Clear; Only7BitTested := false
      {$ENDIF}
      end else Fehler('Unbekannte Delete-Anweisung "'+s+'"', s);
   end else If SucheUndKuerze('Do', s) then begin
      If SucheUndKuerze('Select', s) then begin
         If SucheUndKuerze('Part', s) then begin
            If GetNumber (s, Zahl) then begin
               If (Trunc(Zahl) >= 1) and (Trunc(Zahl) <= Artikel.Parts.Count)
                  then Artikel.ActivePart := Trunc(Zahl)
            end else Fehler('Nach "Do Select Part" mu die Nummer des gewnschten Mimeparts folgen', s)
         end else Fehler('Unbekannter "Do Select"-Befehl "'+s+'" (z.Z. nur "Part" erlaubt)', s)
      end else
      If SucheUndKuerze('Play', s) then begin
         If SucheUndKuerze('Wave', s) then begin
            ok := false;
            If GetString(s, s2) then begin
               L := SND_FILENAME;
               If SucheUndKuerze('and', s) and SucheUndKuerze('wait', s)
                  then L := L + SND_SYNC
                  else L := L + SND_ASYNC;
               ok := Trim(s) = '';
               If ok then begin
                  If Not PlaySound( PChar(s2), 0, L )
                     then Fehler ('Fehler beim Abspielen der Wave-Datei "'+s2+'"', '')
               end
            end;
            If Not ok then Fehler('Falsche Syntax, korrekt wre: "Do Play <Dateiname> [ and wait ]"', s)
         end else Fehler('Nach "Do Play" ist zur Zeit nur "Wave" erlaubt.', s)
      end else
      If SucheUndKuerze('Show', s) then begin
         If SucheUndKuerze('Info', s) then begin
            ok := false;
            If GetString(s, s2) then begin
               s3 := Titel;
               If (s='') or (SucheUndKuerze(',', s) and GetString(s, s3)) then begin
                  Messagebox (0, PChar(s2), PChar(s3), MB_ICONINFORMATION);
                  ok := true
               end
            end;
            If not ok then Fehler('Falsche Show-Info-Syntax, korrekt wre: "Do Show Info <Text> [, <berschrift> ]")', s)
         end else Fehler('Unbekannter "Do Show"-Befehl "'+s+'" (z.Z. nur "Info" erlaubt)', s)
      end else
      If SucheUndKuerze('Sort', s) then begin
         If SucheUndKuerze('Header', s) then begin
            SortHeader (s)
         end else Fehler('Unbekannter "Do Sort"-Befehl "'+s+'" (z.Z. nur "Header" erlaubt)', s)
      end else
      If SucheUndKuerze('Repair', s) then begin
         If SucheUndKuerze('OEQuotings', s) then begin
            Check_OE_Zitate
         end else Fehler('Unbekannter "Do Repair"-Befehl "'+s+'" (z.Z. nur "OEQuotings" erlaubt)', s)
      end else
      If SucheUndKuerze('Write', s) then begin
         If SucheUndKuerze('IniStr', s) then begin
            If GetString(s, s2)
               and SucheUndKuerze(',', s) and GetString(s, s3)
               and SucheUndKuerze(',', s) and GetString(s, s4)
               and SucheUndKuerze(',', s) and GetString(s, s5)
            then begin
               With TIniFile.Create(s2) do try WriteString(s3, s4, s5) finally free end
            end else Fehler('Falsche Syntax, richtig wre "Do Write IniStr Datei, Abschnitt, Key, Wert', s)
         end else If SucheUndKuerze('Textfile', s) then begin
            If GetString(s, s2)
               and SucheUndKuerze(',', s) and GetString(s, s3)
               and (s = '')
            then begin
               With TStringList.Create do try
                  Text := s3; SaveToFile (s2)
               finally free end
            end else Fehler('Falsche Syntax, richtig wre "Do Write Textfile Datei, String', s)
         end else Fehler('Unbekannter "Do Write"-Befehl "'+s+'" (z.Z. nur "IniStr" und "Textfile" erlaubt)', s)
      end else
      If SucheUndKuerze('Open', s) then begin
         s3 := '';
         If GetString(s, s2) and ((s='') or ((SucheUndKuerze(',', s) and GetString(s, s3)))) then begin
            x := ShellExecute(GetDesktopWindow, 'open', PChar(s2), PChar(s3), PChar(ExtractFilePath(s2)), SW_SHOW);
            If x<32 then Fehler('Fehler #'+Inttostr(x)+' beim Aufruf von "'+Trim(s2+' '+s3)+'"', s)
         end else Fehler ('Falsche Syntax, korrekt wre: "Do Open Dokument [, Parameter]"', s)
      end else
      If SucheUndKuerze('Print', s) then begin
         s3 := '';
         If GetString(s, s2) and ((s='') or ((SucheUndKuerze(',', s) and GetString(s, s3)))) then begin
            x := ShellExecute(GetDesktopWindow, 'print', PChar(s2), PChar(s3), PChar(ExtractFilePath(s2)), SW_SHOW);
            If x<32 then Fehler('Fehler #'+Inttostr(x)+' beim Aufruf von "'+Trim(s2+' '+s3)+'"', s)
         end else Fehler ('Falsche Syntax, korrekt wre: "Do Print Dokument [, Parameter]"', s)
      end else
      If SucheUndKuerze('Exec', s) or SucheUndKuerze('Run', s) then begin
         Warten := SucheUndKuerze('and wait', s);
         If GetString(s, s2) then begin
            If SucheUndKuerze(',', s) then GetString(s, s3)
                                      else s3 := '';
            If s > '' then Fehler ('Falsche Syntax, korrekt wre: "Do Exec Programm/Dokument, Parameter"', s)
            else begin
               {$IFDEF CopyIf}
               If Opt.Simulate then begin
                   If Opt.ShowFoundedPostingsWhenSimulate then begin
                     If Warten then begin
                        If Not ShowArtikel ('Aufruf incl. Warten von "'+s2+'" mit Parameter "'+s3+'"',
                           Artikel.Gesamttext) then Stop
                     end else begin
                        If Not ShowArtikel ('Aufruf ohne Warten von "'+s2+'" mit Parameter "'+s3+'"',
                           Artikel.Gesamttext) then Stop
                     end
                   end
               end else {$ENDIF} begin
                  If Warten then begin
                     If Not ExecAndWait (s2, s3, SW_SHOWDEFAULT) then Fehler('Fehler beim Ausfhren von "'+Trim(s2+' '+s3)+'"', s)
                  end else begin
                     x := ShellExecute(GetDesktopWindow, 'open', PChar(s2), PChar(s3), PChar(ExtractFilePath(s2)), SW_SHOW);
                     If x<32 then Fehler('Fehler #'+Inttostr(x)+' beim Aufruf von "'+Trim(s2+' '+s3)+'"', s)
                  end
               end
            end
         end
      end else If SucheUndKuerze('Replace', s) then begin
         rm := rmAll;
         If SucheUndKuerze('all', s) then rm := rmAll
         else If SucheUndKuerze('first', s) then rm := rmFirst
         else If SucheUndKuerze('last', s) then rm := rmLast
         else Fehler('Unbekannter "Do Replace"-Typ, nur "All", "Last" oder "First" erlaubt', s);
         If GetString (s, s2) then begin
            If SucheUndKuerze('with', s) then begin
               s4 := '';
               If Not GetString(s, s3) then s3 := '';
               If SucheUndKuerze('in', s) then begin
                  rw := rwBody;
                  If SucheUndKuerze('Body', s) then rw := rwBody
                  else If SucheUndKuerze('Sig', s) then rw := rwSig
                  else If SucheUndKuerze('Lines', s) then rw := rwLines
                  else If SucheUndKuerze('Intro', s) then rw := rwIntro
                  else If SucheUndKuerze('Header', s) then rw := rwHeader
                  else If SucheUndKuerze('Header2', s) then rw := rwHeader2
                  else If TestIfVarname (s, s4) = vnExist then rw := rwVar
                  else Fehler('Nach "Do Replace <Suchausdruck> with <Ersatz> in" mu noch "Body", "Sig", "Lines", '
                     +'"Intro", "Header", "Header2" oder ein Variablenname kommen.', s)
               end else rw := rwBody;
               ab := -1;
               If SucheUndKuerze('from', s) then begin
                  If not GetNumber(s, ab) then Fehler('Keine gltige Zahl nach "from" im "Do Replace"-Befehl.', s)
               end;
               bis := -1;
               If SucheUndKuerze('to', s) then begin
                  If not GetNumber(s, bis) then Fehler('Keine gltige Zahl nach "to" im "Do Replace"-Befehl.', s)
               end;
               ReplaceInBody (s2, s3, rm, rw, s4, Trunc(ab), Trunc(bis))
            end else Fehler('Nach "Do Replace <Suchausdruck>" mu noch "with <Ersatz>" kommen', s)
         end else Fehler('Nach "Do Replace" mu noch "<Suchausdruck> with <Ersatz>" kommen', s)
      end else If SucheUndKuerze('Convert', s) then begin
         If SucheUndKuerze('QPHeader', s) then begin
            ConvertHeaderTo8Bit
         end else If SucheUndKuerze('QPBody', s) then begin
            If Artikel.Part.MimeInfo.Kodierung = kQP then ConvertEncoding (k8Bit)
         end else If SucheUndKuerze('Header', s) then begin
            If SucheUndKuerze('to', s) and (SucheUndKuerze('8Bit', s) or SucheUndKuerze('8', s) and SucheUndKuerze('Bit', s))
               then ConvertHeaderTo8Bit
               else Fehler ('Nach "Do Convert Header" kann nur "to 8 Bit" folgen', s)
         end else If SucheUndKuerze('Encoding', s) then begin
            ok := false;
            If SucheUndKuerze('to', s) then begin
               ok := true;
               If SucheUndKuerze('quoted-printable', s) or SucheUndKuerze('qp', s) then
                  ConvertEncoding (kQP)
               else If SucheUndKuerze('8bit', s) or SucheUndKuerze('8-bit', s) or (SucheUndKuerze('8', s) and SucheUndKuerze('Bit', s)) then
                  ConvertEncoding (k8Bit)
               else If SucheUndKuerze('Base64', s) then
                  ConvertEncoding (kBase64)
               else If SucheUndKuerze('ascii', s) or SucheUndKuerze('7-bit', s) or SucheUndKuerze('7Bit', s) or (SucheUndKuerze('7', s) and SucheUndKuerze('Bit', s)) then
                  ConvertEncoding (k7Bit)
               else
                  ok := false
            end;
            If Not ok then Fehler ('Nach "Do Convert Encoding" kann nur "to Encodingtyp" folgen, als Encodingtyp sind '
                +'"8bit", "qp"/"quoted-printable", "base64" und "7bit"/"ascii" zulssig.', s)
         end else If SucheUndKuerze('HTML', s) then begin
            If SucheUndKuerze('to', s) and SucheUndKuerze('Text', s) then begin
               Check_ConvertHTML2Text
            end else Fehler ('Nach "Do Convert HTML" kann zur Zeit nur " to Text" folgen', s)
         end else If SucheUndKuerze('OEBeginBug', s) then begin
            Check_ConvertOEBeginBug
         end else If SucheUndKuerze('OEKillFalseReBug', s) then begin
            Check_ConvertOEKillFalseReBug
         end else
         If SucheUndKuerze('BoxQuotes', s) then begin
            If GetNumber(s, Zahl) and (s='')
               then ConvertBoxQuotes (Trunc(Zahl))
               else Fehler('Nach "Do Convert Boxquotes" mu noch die Boxquote-Definitions-Nr folgen!', s)
         end else Fehler ('Zur Zeit sind nur die Konvertierungsbefehle "Do Convert QPHeader", '
             +'"Do Convert QPBody", "Do Convert OEBeginBug" und "Do Convert BoxQuotes <Nummer>" zulssig.', s)
      end else If SucheUndKuerze('Optimize', s) then begin
         If SucheUndKuerze('BodyCharset', s) then begin
            Artikel.Part.OptimizeBodycharset
         end else
         If SucheUndKuerze('BodyCharsets', s) then begin
            For i := 0 to Artikel.Parts.Count-1 do Artikel.Parts[i].OptimizeBodyCharset
         end else
         If SucheUndKuerze('MIMEHeader', s) then begin
            Check_MIMEHeader
         end else Fehler ('Zur Zeit sind nur die Optimierungsbefehle "Do Optimize BodyCharset / BodyCharsets / MIMEHeader" zulssig', s)
      end else If SucheUndKuerze('Save', s) then begin
         ok := SucheUndKuerze('Part', s);
         s3 := Opt.SaveAttachmentsDir;
         ifExistsAction := Opt.ActionIfAttExists;
         If ok then If not GetString(s, s2) then Fehler('Unzulssiger String-Ausdruck "'+s+'"!', s);
         If s > '' then begin
            If ok then ok := SucheUndKuerze(',', s);
            If ok then If not GetString(s, s3) then Fehler('Unzulssiger String-Ausdruck "'+s+'"!', s);;
            If s > '' then begin
               If ok then ok := SucheUndKuerze(',', s);
               If ok then begin
                  If SucheUndKuerze('Rename', s) then IfExistsAction := aeRename
                  else If SucheUndKuerze('Rename', s) then IfExistsAction := aeOverwrite
                  else ok := false
               end;
               If ok then ok := s = ''
            end
         end;
         If ok
            then SaveAttachment(s3, s2, IfExistsAction)
            else Fehler ('Syntaxfehler, korrekt wre: "Do Save Part <Dateiname>, <Pfad>, ( Nothing | Overwrite | Rename )".', s)
      {$IFDEF CopyIf}
      end else If SucheUndKuerze('Export as', s) then begin
         If GetString(s, s2) and (Pos('*', s2)>0) then begin
            Artikel_vollenden;
            ExportArtikel (s2, Opt);
            Artikel_weiter_bearbeiten
         end else Fehler ('Nach "Do Export as" muss noch ein Dateiname mit "*" kommen.', s)
      end else If SucheUndKuerze('Show', s) then begin
         Artikel_vollenden;
         b := Not ShowArtikel ('', Artikel.Gesamttext);
         Artikel_weiter_bearbeiten;
         If b
            then begin Retry := rEndProgram; abort end
            else Skript.Zeile := Skript.Count
      end else If SucheUndKuerze('Copy to Group', s) then begin
         If GetString(s, s2) then begin
            Artikel_vollenden;
            SpeichereArtikelKopie (s2, Opt.AddToMessageID, Opt.CopyIfExist, Opt);
            Artikel_weiter_bearbeiten
         end else Fehler ('Nach "Do Copy to group" muss noch der Gruppenname in Anfhrungsstrichen folgen.', s)
      end else If SucheUndKuerze('Define Counter', s) or SucheUndKuerze('Def Counter', s)then begin
         If GetString(s, s2) then begin
            Repeat
               DefCounter(s2, false);
               If Not SucheUndKuerze(',', s)
                  then break
                  else While SucheUndKuerze(',', s) do DefCounter('', true)
            Until Not GetString(s, s2)
         end else Fehler ('Nach "Do Def[ine] Counter" muss noch der Name des Zhlers kommen.', s)
      end else If SucheUndKuerze('Inc Counter', s) then begin
         If GetString(s, s2) then begin
            If Not (SucheUndKuerze(',', s) and GetString(s, s3)) then s3 := '';
            IncCounter(s2, s3)
         end else Fehler ('Nach "Do Inc Counter" muss noch der Name des Zhlers kommen.', s)
      end else If SucheUndKuerze('Save Changes', s) then begin
         If Changed or (slIntro.Count>0) then begin
            Artikel_vollenden;
            ErsetzeArtikel (Opt);
            Artikel_weiter_bearbeiten
         end
      end else If SucheUndKuerze('Touch', s) then begin
         If GetString(s, s2) and (Trim(s)='')
            then TouchGroups(s2)
            else Fehler ('Korrekte Syntax: "Do Touch <Gruppenauswahl>", wobei <Gruppenauswahl> als regulrer Ausdruck interpretiert wird.', s)
      end else Fehler('Unbekannter Do-Befehl "'+s+'" (z.Z. nur "Include", "Show", "Export as", "Inc Counter", '
         +'"Copy to Group", "Exec", "Open", "Print", "Touch", "Sort" und "Replace" erlaubt)', s)
      {$ELSE}
      end else Fehler('Unbekannter Do-Befehl "'+s+'" (z.Z. nur "Include", "Exec", "Open", "Print", "Sort Header" und "Replace" erlaubt)', s)
      {$ENDIF}
   end else SetHeader := true;

   { Normale Headereintrge }
   If SetHeader then begin
      If Split_Headerzeile (s, AktHeader, AktInhalt) then begin
         If Not TestHeaderName (AktHeader, i) then begin
            Fehler('Unzulssiges Zeichen "'+AktHeader[i]+'" in Headerbezeichnung!'
               + ' (Falls fr lokale Zwecke (Hamster) ntig, mu der Header "'+AktHeader+'" in ''lheader.txt'' aufgefhrt werden.)', s)
         end;
         If Not RawMode then AktInhalt := InterpreteWildCards(AktInhalt);
         AktInhalt := EncodeISO(HeaderCharsets, AktInhalt);
         With TStringlist.Create do try
            Text := AktInhalt;
            For i := Count-1 downto 1 do begin
               If Strings[i]='' then Delete(i)
               else
               If NOT (Strings[i][1] IN [' ', #9]) and (Pos(': ', Strings[i])=0)
                  then Strings[i]:=' '+Strings[i]
            end;
            AktInhalt := Text;
            While (AktInhalt > '') and (AktInhalt[Length(AktInhalt)] IN [#13, #10])
               do System.Delete(AktInhalt, Length(AktInhalt), 1)
         finally
            free
         end;
         With Artikel.Header do If AppendHeader then begin
            p := Position (AktHeader);
            If p >= 0 then Insert(p+1, AktHeader + ': ' + AktInhalt)
                      else Add (AktHeader + ': ' + AktInhalt)
         end else begin
            If Change(AktHeader, AktInhalt) then Changed := true
         end
      end else begin
         If Length(s)>43 then s :=Copy(s,1,40)+'...';
         Fehler('Die Zeile "'+s+'" enthlt weder einen bekannten Befehl (Set, Append, If, ...)'
                 +', noch eine gltige Header-Zuweisung a la "X-Header: Inhalt", bitte auskommentieren '
                 +'(mit ";") oder korrigieren.', s)
      end
   end

end;

Procedure TKNSkript.Stop;
begin
   Retry := rEndProgram; Abort
end;

Function TKNSkript.FindSub (Const Bez: String; Var Z: Integer; Var Pars: String): boolean;
Var v, s: String; i: Integer;
begin
   Result := false;
   v := LowerCase('Sub '+Bez);
   For i:=0 to Count-1 do begin
      s := LowerCase(Trim(self[i].Inhalt));
      If Copy(s, 1, Length(v)) = v then begin
         Z := i; s := Copy(s, Length(v)+1, Length(s));
         If (s = '') or (s[1] IN[' ', '(', ^I]) then begin
            s := Trim(s);
            If s > '' then begin
               If not Klammerung(s, Pars, true) then Pars := s
            end else begin
               Pars := ''
            end;
            Result := true; exit
         end
      end
   end
end;

Function TKNSkript.FindGoto (Const Bez: String; Var Z: Integer): boolean;
Var v, s: String; i: Integer;
begin
   Result := false;
   v := LowerCase(':'+Bez);
   For i:=0 to Count-1 do If self[i].Typ = ztLabel then begin
      s := LowerCase(Trim(self[i].Inhalt));
      If s = v then begin
         Z := i; Result := true; exit
      end
   end
end;

// ----------------------------------------------------------------------------------

Function TKNSkript.TestChanged: Boolean;
Var i: Integer;
begin
   With Artikel do begin
      Result := Header.changed;
      For i := 0 to Parts.Count-1 do With Parts[i] do begin
         Result := Result or Body.changed or Sig.changed or Header.changed
                   or (slAppend.Count > 0)
      end
   end
end;

// ----------------------------------------------------------------------------------

Function TKNSkript.TestBedingung(Var s: String): boolean;
Var s2, s3, s4: String; x1, x2, x3: Double;
    vt: TVergltyp; Verknuepfung: TVerknuepfungstyp;
    Dreher, First, AktResult, PreResult, ok: boolean;
begin
   PreResult := true;
   First := true;
   s := Trim(s);

   While s > '' do begin

      Verknuepfung := vtFirst;
      If Not First then begin
         If SucheUndKuerze('or', s) then Verknuepfung := vtOr
         else If SucheUndKuerze('and', s) then Verknuepfung := vtAnd
         else If SucheUndKuerze('xor', s) then Verknuepfung := vtXor
         else break
      end;

      Dreher := false;
      While SucheUndKuerze('not', s) do Dreher := Not Dreher;

      AktResult := false;
      If Klammerung(s, s2, true) then begin
         AktResult := TestBedingung(s2);
         If s2 > '' then Fehler ('Keine zulssige Verknpfung in Bedingung: "'+s2+'", nur '
            +' "Not", "or", "and" und "xor" sind erlaubt.', s)
      end
      else If SucheUndKuerze('HasSignature', s) or SucheUndKuerze('HasSig', s) then begin
         AktResult := Artikel.Part.HasSig
      end
      else If SucheUndKuerze('Has8BitChars', s) then begin
         AktResult := Not TestOnly7Bit
      end
      else If SucheUndKuerze('ChangedLines', s) then begin
         AktResult := slAppend.Count > 0
      end
      else If SucheUndKuerze('ChangedSignature', s) or SucheUndKuerze('ChangedSig', s) then begin
         AktResult := Artikel.Part.Sig.changed
      end
      else If SucheUndKuerze('StrToBool', s) then begin
         If (Klammerung(s, s2, true) and GetString(s2, s3) and (s2=''))
            or GetString(s, s3)
         then begin
            IF (s3 = '') or (LowerCase(s3) = 'f') or (s3 = '0') or (LowerCase(s3) = 'false')
                 or (LowerCase(s3) = 'falsch') or (LowerCase(s3) = 'no')  or (LowerCase(s3) = 'nein')
            then AktResult := false
            else If (s3 = '1') or (LowerCase(s3) = 't') or (LowerCase(s3) = 'true')
                 or (LowerCase(s3) = 'wahr') or (LowerCase(s3) = 'yes')  or (LowerCase(s3) = 'ja')
            then AktResult := true
            else Fehler('Der String "'+s3+'" kann nicht in einen boolschen Ausdruck konvertiert werden', s)
         end else Fehler('Nach StrToBool mu ein gltiger String-Ausdruck folgen!', s);
      end
      else If SucheUndKuerze('PartType', s) then begin
         ok := SucheUndKuerze('is', s);
         If ok then begin
            If SucheUndKuerze('Unknown', s) then AktResult := Artikel.Part.MimeInfo.Typ = ctUnbekannt
            else
            If SucheUndKuerze('Text', s) then AktResult := Artikel.Part.MimeInfo.Typ IN [ctPlainText, ctUnknownText]
            else
            If SucheUndKuerze('PlainText', s) then AktResult := Artikel.Part.MimeInfo.Typ = ctPlaintext
            else
            If SucheUndKuerze('UnknownText', s) then AktResult := Artikel.Part.MimeInfo.Typ = ctUnknownText
            else
            If SucheUndKuerze('HTML', s) then AktResult := Artikel.Part.MimeInfo.Typ = ctHTML
            else
            If SucheUndKuerze('Binary', s) then AktResult := Not IstText[Artikel.Part.MimeInfo.Typ]
            else
            If SucheUndKuerze('Application', s) then AktResult := Artikel.Part.MimeInfo.Typ = ctApplication
            else
            If SucheUndKuerze('Audio', s) then AktResult := Artikel.Part.MimeInfo.Typ = ctAudio
            else
            If SucheUndKuerze('Image', s) then AktResult := Artikel.Part.MimeInfo.Typ = ctImage2
            else
            If SucheUndKuerze('Video', s) then AktResult := Artikel.Part.MimeInfo.Typ = ctVideo
            else
            ok := false
         end;
         If Not Ok then Fehler('Nach "Parttype" mu "is <Typ>" folgen, wobei Typ "Unknown", "Text", "Plaintext", '
            +'"UnknownText", "HTML", "Binary", "Application", "Audio", "Image" oder "Video" sein kann.', s);
      end
      else If SucheUndKuerze('PartEncoding', s) then begin
         ok := SucheUndKuerze('is', s);
         If ok then begin
            If SucheUndKuerze('quoted-printable', s) or SucheUndKuerze('qp', s) then
               AktResult := Artikel.Part.MimeInfo.Kodierung = kQP
            else If SucheUndKuerze('8bit', s) or SucheUndKuerze('8-bit', s) or (SucheUndKuerze('8', s) and SucheUndKuerze('Bit', s)) then
               AktResult := Artikel.Part.MimeInfo.Kodierung = k8Bit
            else If SucheUndKuerze('Base64', s) then
               AktResult := Artikel.Part.MimeInfo.Kodierung = kBase64
            else If SucheUndKuerze('ascii', s) or SucheUndKuerze('7-bit', s) or SucheUndKuerze('7Bit', s) or (SucheUndKuerze('7', s) and SucheUndKuerze('Bit', s)) then
               AktResult := Artikel.Part.MimeInfo.Kodierung = k7Bit
            else If SucheUndKuerze('unknown', s) then
               AktResult := Artikel.Part.MimeInfo.Kodierung = kUnbekannt
            else
            ok := false
         end;
         If Not Ok then Fehler('Nach "PartEncoding" mu "is <Typ>" folgen, wobei Typ "Unknown", "qp"/"quoted-printable", '
            +'"8Bit", "7Bit" oder "Base64" sein kann.', s);
      end
      else If SucheUndKuerze('true', s) then begin
         AktResult := true
      end
      else If SucheUndKuerze('false', s) then begin
         AktResult := false
      end
      else If SucheUndKuerze('Ask', s) then begin
         ok := false;
         s4 := Titel;
         If Klammerung(s, s2, true) and GetString(s2, s3)
            and ((Trim(s2) = '') or (SucheUndKuerze(',', s2) and GetString(s2, s4)))
         then begin
            ok := true;
            AktResult := Messagebox (0, PChar(s3), PChar(s4), MB_ICONQUESTION + MB_YESNO) = IDYES
         end;
         If Not ok then Fehler('Falsche Syntax, die Syntax fr Ask lautet: "Ask ( Text [, berschrift] )"', s)
      end
      else If SucheUndKuerze('Abort', s) then begin
         ok := false;
         s4 := Titel;
         If Klammerung(s, s2, true) and GetString(s2, s3)
            and ((Trim(s2) = '') or (SucheUndKuerze(',', s2) and GetString(s2, s4)))
         then begin
            ok := true;
            AktResult := Messagebox (0, PChar(s3), PChar(s4), MB_ICONSTOP + MB_OKCANCEL + MB_DEFBUTTON2) = IDCANCEL
         end;
         If Not ok then Fehler('Falsche Syntax, die Syntax fr Abort lautet: "Abort ( Text [, berschrift] )"', s)
      end
      else If SucheUndKuerze('ChangedIntroduction', s) or SucheUndKuerze('ChangedIntro', s) then begin
         AktResult := AktIntroExists and (AktIntro.Count > 0)
      end
      else If SucheUndKuerze('Changed', s) then begin
         AktResult := TestChanged
      end
      else If SucheUndKuerze('VarExists', s) then begin
         ok := false;
         If Klammerung (s, s2, true) then begin
            Case TestIfVarName (s2, s3) of
               vnNew: AktResult := false;
               vnExist: AktResult := true;
               else Fehler ('"'+s2+'" ist kein zulssiger Variablenname', s)
            end;
            ok := Trim(s2) = ''
         end;
         If Not ok then Fehler ('Syntaxfehler, korrekt wre "VarExists (%Variablenname%)"', s)
      end
      else If SucheUndKuerze('FileExists', s) then begin
         If Klammerung (s, s2, true) and GetString(s2, s3) and (Trim(s2) = '')
            then AktResult := FileExists( s3 )
            else Fehler ('Syntaxfehler, korrekt wre "FileExists ( <Stringausdruck> )"', s)
      end
      else begin
         { boolsche Variable? }
         ok := false;
         s4 := s;
         If TestIfVarName(s4, s2) = vnExist then begin
            With Vars[s2] do begin
               ok := Typ = vtBool;
               If ok then AktResult := asBoolean
            end
         end;
         if ok then
            s := s4
         { Stringvergleich? }
         else If GetString(s, s2) then begin
            vt := vtNix;
            If SucheUndKuerze('not', s) then Dreher := Not Dreher;
            { Vergleichstyp }
            If SucheUndKuerze('contains', s) then vt := vtEnthaelt
            else If SucheUndKuerze('>=', s) then vt := vtGroesserGleich
            else If SucheUndKuerze('<=', s) then vt := vtKleinerGleich
            else If SucheUndKuerze('equals', s) or SucheUndKuerze('=', s) then vt := vtGleich
            else If SucheUndKuerze('<>', s) then vt := vtUnGleich
            else If SucheUndKuerze('like', s) or SucheUndKuerze('matches', s) then vt := vtLike
            else If SucheUndKuerze('begins with', s) then vt := vtBeginnt
            else If SucheUndKuerze('ends with', s) then vt := vtEndet
            else If SucheUndKuerze('is empty', s) then vt := vtIstLeer
            else If SucheUndKuerze('in', s) then vt := vtIn
            else If SucheUndKuerze('less than', s) or SucheUndKuerze('<', s) then vt := vtKleiner
            else If SucheUndKuerze('greater than', s) or SucheUndKuerze('>', s) then vt := vtGroesser
            else If SucheUndKuerze('between', s) then vt := vtBetween
            else Fehler('Unbekannte Vergleichsoperation "'+s+'", untersttzt werden nur '
                +'"contains", "equals"/"=", "<>", "like"/"matches", "begins with", '
                +'"ends with", "is empty", "in", "less than"/"<", "greater than"/">", '
                +'">=", "<=" und "between"', s);
            { Vergleich }
            If vt = vtIstLeer then AktResult := s2 = ''
            else begin
               If GetString(s, s3) then begin
                  Case vt of
                     vtGleich: AktResult := s2 = s3;
                     vtUngleich: AktResult := s2 <> s3;
                     vtBeginnt: AktResult := Copy(s2, 1, Length(s3)) = s3;
                     vtLike: AktResult := TestRegExp (s3, s2);
                     vtEndet: AktResult := Copy(s2, Length(s2)-Length(s3)+1,Length(s3)) = s3;
                     vtEnthaelt: AktResult := pos(s3, s2)>0;
                     vtIn: AktResult := pos(s2, s3)>0;
                     vtKleiner: AktResult := s2 < s3;
                     vtGroesser: AktResult := s2 > s3;
                     vtGroesserGleich: AktResult := s2 >= s3;
                     vtKleinerGleich: AktResult := s2 <= s3;
                     vtBetween:
                        If SucheUndKuerze('and', s) and GetString(s, s4)
                           then AktResult := ((s2 >= s3) and (s2 <= s4)) or ((s2 >= s4) and (s2 <= s3))
                           else Fehler('Syntaxfehler, korrekt wre: "between ... and ..."', s);
                     else Fehler('Interner Fehler, Vergleichsoperation #'+Inttostr(ord(vt))+' ist nicht programmiert', s)
                  end
               end else begin
                  Fehler ('Vergleichsausdruck "'+s+'" fehlt bzw. mu mit ''"'' geklammert werden', s)
               end
            end
         end else
         { Numerischer Vergleich? }
         If GetNumber(s, x1) then begin
            vt := vtNix;
            { Vergleichstyp }
            If SucheUndKuerze('=', s) then vt := vtGleich
            else If SucheUndKuerze('<>', s) then vt := vtUnGleich
            else If SucheUndKuerze('<=', s) then vt := vtKleinerGleich
            else If SucheUndKuerze('>=', s) then vt := vtGroesserGleich
            else If SucheUndKuerze('<', s) then vt := vtKleiner
            else If SucheUndKuerze('>', s) then vt := vtGroesser
            else If SucheUndKuerze('between', s) then vt := vtBetween
            else Fehler('Unbekannte numerische Vergleichsoperation "'+s+'", untersttzt werden nur '
                +'"=", "<>", "<", ">", "<=", ">="', s);
            { Vergleich }
            If vt = vtIstLeer then AktResult := x1 <> 0
            else begin
               If GetNumber(s, x2) then begin
                  Case vt of
                     vtGleich: AktResult := x1 = x2;
                     vtUngleich: AktResult := x1 <> x2;
                     vtKleiner: AktResult := x1 < x2;
                     vtGroesser: AktResult := x1 > x2;
                     vtGroesserGleich: AktResult := x1 >= x2;
                     vtKleinerGleich: AktResult := x1 <= x2;
                     vtBetween:
                        If SucheUndKuerze('and', s) and GetNumber(s, x3)
                           then AktResult := ((x1 >= x2) and (x1 <= x3)) or ((x1 >= x3) and (x1 <= x2))
                           else Fehler('Syntaxfehler, korrekt wre: "between ... and ..."', s);
                     else Fehler('Interner Fehler, Vergleichsoperation #'+Inttostr(ord(vt))+' ist nicht programmiert', s)
                  end
               end else Fehler ('Vergleichswert fehlt!', s)
            end
         end else Fehler('Unbekannter Vergleichsausdruck "'+s+'"', s)
      end;
      If Dreher then AktResult := Not AktResult;

      Case Verknuepfung of
         vtFirst : PreResult := AktResult;
         vtOr    : PreResult := PreResult Or AktResult;
         vtXor   : PreResult := PreResult xor AktResult;
         vtAnd   : PreResult := PreResult and AktResult
      end;
      First := false
   end;
   Result := PreResult
end;

// ----------------------------------------------------------------------------------

Type TStrTyp = (stHeaderName, stHeaderContent, stRawHeaderContent, stHeader,
                stFull, stFirst, stLast, stDecodeISO, st8BitTo7Bit,
                stMakeAddress1, stMakeAddress2,
                stMailAddr1, stMailAddr2, stVorname, stName, stBoolVal,
                stBodyline, stInput, stReadIni, stVersion, stLine, stPartFileName
               {$IFDEF CopyIf} {$ELSE}
                ,stBodyHeader, stFilePath, stFileName
               {$ENDIF} );
     TStrDef = Record Bez: String; Args: String; Simple: boolean end;

Const StrFuncs: Array[TStrTyp] of TStrDef
       = (
           ( Bez: 'HeaderName'; Args: cNum; Simple: false ),
           ( Bez: 'HeaderContent'; Args: cNum; Simple: false ),
           ( Bez: 'RawHeaderContent'; Args: cNum; Simple: false ),
           ( Bez: 'Header'; Args: cStr; Simple: true ),
           ( Bez: 'Full'; Args: ''; Simple: false ),
           ( Bez: 'First'; Args: cStr; Simple: false ),
           ( Bez: 'Last'; Args: cStr; Simple: false ),
           ( Bez: 'DecodeISO'; Args: cStr; Simple: false ),
           ( Bez: '8BitTo7Bit'; Args: cStr; Simple: false ),
           ( Bez: 'MakeAddress'; Args: cStr+cStr; Simple: false ),
           ( Bez: 'MakeAdress'; Args: cStr+cStr; Simple: false ),
           ( Bez: 'Address'; Args: cStr; Simple: false ),
           ( Bez: 'Adress'; Args: cStr; Simple: false ),
           ( Bez: 'FirstName'; Args: cStr; Simple: false ),
           ( Bez: 'Name'; Args: cStr; Simple: false ),
           ( Bez: 'BoolToStr'; Args: cOwn; Simple: false ),
           ( Bez: 'Bodyline'; Args: cNum; Simple: false ),
           ( Bez: 'Input'; Args: cStr+cStr+cStr; Simple: false ),
           ( Bez: 'ReadIniStr'; Args: cStr+cStr+cStr+cStr; Simple: false ),
           ( Bez: 'Version'; Args: ''; Simple: false ),
           ( Bez: 'Line'; Args: cNum+cStr; Simple: false ),
           ( Bez: 'PartFileName'; Args: ''; Simple: false )
           {$IFDEF CopyIf}
           {$ELSE} ,
           ( Bez: 'BodyHeader'; Args: cStr; Simple: true ),
           ( Bez: 'Path'; Args: ''; Simple: false ),
           ( Bez: 'Filename'; Args: ''; Simple: false )
           {$ENDIF}
         );

Procedure TKNSkript.RegZusatzStringFunktionen;
Var i: TStrTyp;
begin
   For i := Low(TStrTyp) to High(TStrTyp) do With StrFuncs[i] do
      Register_StrFunktion (Bez, Args, Simple, ZusatzStringFunktionen, Ord(i))
end;
Procedure TKNSkript.UnRegZusatzStringFunktionen;
Var i: TStrTyp;
begin
   For i := Low(TStrTyp) to High(TStrTyp) do
      With StrFuncs[i] do Unregister_StrFunktion (Bez)
end;

Function TKNSkript.ZusatzStringFunktionen (Var Pars: TStrParameter): String;
Var p: Integer; s1, s2, s3: String; c: Char;
    Raw: boolean;
begin
   With Pars do begin
      Case TStrTyp(Typ) of
         stHeader: Result := Artikel.Header.Inhalt(Trim(Strs[1]), hiDecoded);
         stHeaderName: begin
            p := Trunc(Nums[1]);
            if (p > 0) and (p <= Artikel.Header.Count)
               then Result := Artikel.Header.Name[p-1]
               else Result := ''
         end;
         stHeaderContent: begin
            p := Trunc(Nums[1]);
            if (p > 0) and (p <= Artikel.Header.Count)
               then Result := Artikel.Header.InhaltPerPos(p-1, hiDecoded)
               else Result := ''
         end;
         stRawHeaderContent: begin
            p := Trunc(Nums[1]);
            if (p > 0) and (p <= Artikel.Header.Count)
               then Result := Artikel.Header.InhaltPerPos(p-1, hiRaw)
               else Result := ''
         end;
         {$IFNDEF CopyIf}
         stBodyHeader: Result := slBodyHeader.Inhalt (Trim(Strs[1]), hiDecoded);
         stFileName: Result := ExtractFileName(fDateiname);
         stFilePath: Result := Opt.WorkPath;
         {$ENDIF}
         stFull: begin
            Raw := SucheUndKuerze('raw', Rest);
            If SucheUndKuerze('Header', Rest) then begin
               Result := Artikel.Header.Text;
               If SucheUndKuerze('without', Rest) then Repeat
                  If GetWord (Rest, s2) then begin
                     If Raw
                        then s2 := ToHeader(s2) + Artikel.Header.Inhalt(s2, hiRaw)
                        else s2 := ToHeader(s2) + Artikel.Header.Inhalt(s2, hiDecoded);
                     p := pos(s2, Result);
                     If p>0 then Result := Copy(Result, 1, p-1) + Copy(Result, p+Length(s2)+2, Length(Result))
                  end else break
               Until Not SucheUndKuerze(',', Rest)
            end else
            If SucheUndKuerze('Body', Rest) then
               Result := Artikel.Part.Body.Text
            else If SucheUndKuerze('Sig', Rest) or SucheUndKuerze('Signature', Rest)then
               Result := Artikel.Part.Sig.Text
            else If SucheUndKuerze('Intro', Rest) or SucheUndKuerze('Introduction', Rest) then
               If AktIntroExists then Result := AktIntro.Text else Result := ''
            else If SucheUndKuerze('Article', Rest) or SucheUndKuerze('Posting', Rest) or SucheUndKuerze('Mail', Rest) then
               Result := Artikel.Gesamttext
            else
               Fehler ('Ein Stringbefehl "Full '+Rest+'" ist nicht zulssig, nur "Full [raw] Body", '
                     +'"Full [raw] Header", "Full [raw] Sig[nature]" und "Full Posting/Article/Mail" '
                     +'sind erlaubt', Rest)
         end;
         stFirst, stLast: begin
            Result := Strs[1];
            If ((Result+' ')[1]='<') and (Result[Length(Result)]='>') then begin
               If TStrTyp(Typ)=stFirst then c:='>' else c:='<'
            end else c:=',';
            p := Pos(c, Result);
            If p > 0 then Case TStrTyp(Typ) of
              stFirst: Result := Copy(Result, 1, p-1);
              stLast: Repeat
                 Result := Copy(Result, p+1, length(Result)-p);
                 p := Pos(c, Result)
              Until p=0
            end;
            If c='>' then Result := Result + '>'
            else If c='<' then Result := '<' + Result;
         end;
         stDecodeISO: begin
            Result := DecodeISO (HeaderCharsets, Strs[1]);
            Repeat
               p := Pos(#13#10' ', Result);
               If p=0 then p := Pos(#13#10#9, Result);
               If p>0 then Delete(Result, p, 3);
            Until p = 0
         end;
         st8BitTo7Bit: Result := Convert1252ToAscii(Strs[1]);
         stMakeAddress1, stMakeAddress2: Result := MakeAdress(Strs[1], Strs[2]);
         stMailAddr1, stMailAddr2, stVorname, stName: begin
            ExtractMailParts (Strs[1], s1, s2, s3);
            Case TStrTyp(Typ) of
               stName: Result := s1;
               stVorname: Result := s2;
               stMailAddr1, stMailAddr2: Result := s3;
            end
         end;
         stBoolVal: If TestBedingung(Rest) then Result := '1' else Result := '0';
         stBodyLine: begin
            p := Trunc(Nums[1]);
            If p IN[1..Artikel.Part.Body.Count]
               then Result := Artikel.Part.Body[p-1]
               else Result := ''
         end;
         stLine: begin
            p := Trunc(Nums[1]);
            With TStringlist.Create do try
               Text := Strs[1];
               if (p>0) and (p<=Count) then Result := Strings[p-1] else Result := ''
            finally free end
         end;
         stPartFileName: Result := Artikel.Part.MIMEInfo.FileName;
         stInput: begin
            If Strs[1] = '' then Strs[1] := Titel;
            If Strs[2] = '' then Strs[2] := 'Bitte eingeben:';
            {$IFNDEF NOGUI}
            Result := InputBox (Strs[1], Strs[2], Strs[3])
            {$ELSE}
            s1 := TempName;
            With TIniFile.Create(s1) do try
               WriteString  ('InputBox', 'Title', Strs[1]);
               WriteString  ('InputBox', 'Prompt', Strs[2]);
               WriteString  ('InputBox', 'Default', Strs[3]);
            finally free end;
            ExecAndWait (ExtractFilePath(ParamStr(0))+'Korrnews.exe', '#InputBox# "'+s1+'"', 0);
            With TIniFile.Create(s1) do try
               Result := ReadString ('InputBox', 'Default', '')
            finally free end;
            DeleteFile (s1);
            {$ENDIF}
         end;
         stReadIni: With TIniFile.Create(Strs[1]) do try Result := ReadString(Strs[2], Strs[3], Strs[4]) finally free end;
         stVersion: Result := Ver;
      end
   end
end;

Function TKNSkript.NextMatchedLine (Const ab: Integer; Const Reg: String): Integer;
Var i: Integer; s: String;
begin
   Result := -1;
   For i:=ab to Artikel.Part.Body.Count-1 do begin
      If i < 0 then Continue;
      s := Artikel.Part.Body[i];
      If s>'' then IF Regex.MatchRS (Reg, s) then begin Result := i; BREAK end
   end
end;

Function TKNSkript.CountMachedLines (Const Reg: String): Integer;
Var i: Integer; s: String;
begin
   Result := 0;
   For i:=0 to Artikel.Part.Body.Count-1 do begin
      s := Artikel.Part.Body[i];
      If s>'' then IF Regex.MatchRS (Reg, s) then Inc(Result)
   end
end;

// ----------------------------------------------------------------------------------

Type TNumTyp = (fPartCount, fMatchedLines, fBodylines, fIntrolines,
                fSiglines, fHeaderlines,
                fNextMatchedLine, fCountLines);

     TNumDef = Record Bez: String; Args: String end;

Const NumFuncs: Array[TNumTyp] of TNumDef
       = (
           ( Bez: 'PartCount';           Args: ''),
           ( Bez: 'MatchedLines';        Args: cStr),
           ( Bez: 'Bodylines';           Args: ''),
           ( Bez: 'IntroLines';          Args: ''),
           ( Bez: 'SigLines';            Args: ''),
           ( Bez: 'HeaderLines';         Args: ''),
           ( Bez: 'NextMatchedLine';     Args: cNum+cStr),
           ( Bez: 'CountLines';          Args: cStr)
          );

Procedure TKNSkript.RegZusatzNumerischeFunktionen;
Var i: TNumTyp;
begin
   For i := Low(TNumTyp) to High(TNumTyp) do With NumFuncs[i] do
      Register_NumFunktion (Bez, Args, ZusatzNumerischeFunktionen, Ord(i))
end;
Procedure TKNSkript.UnregZusatzNumerischeFunktionen;
Var i: TNumTyp;
begin
   For i := Low(TNumTyp) to High(TNumTyp) do
      With NumFuncs[i] do Unregister_NumFunktion (Bez)
end;

Function TKNSkript.ZusatzNumerischeFunktionen (Var Pars: TNumParameter): Double;
begin
   Result := 0;
   With Pars do begin
      Case TNumTyp(Typ) of
         fPartCount: Result := Artikel.Parts.Count;
         fMatchedLines: Result := CountMachedLines (Strs[1]);
         fBodylines: Result := Artikel.Part.Body.Count;
         fIntrolines: If AktIntroExists then Result := AktIntro.Count else Result := 0;
         fSiglines: Result := Artikel.Part.Sig.Count;
         fHeaderlines: Result := Artikel.Header.Count;
         fCountLines:
            With TStringlist.Create do try
               Text := Strs[1]; Result := Count
            finally free end;
         fNextMatchedLine: Result := NextMatchedLine(Trunc(Nums[1])-1, Strs[1])+1
      end
   end
end;

// ----------------------------------------------------------------------------------

Function TKNSkript.GetValueAsStr(Var s: String; Const vt: TVarTyp): String;
Var Zahl: Double;
begin
   Case vt of
      vtStr: If Not GetString(s, Result)
         then Fehler('"'+s+'" ist kein gltiger String-Ausdruck', s);
      vtFloat: If GetNumber(s, Zahl)
         then Result := ToStr(Zahl)
         else Fehler('"'+s+'" ist kein gltiger numerischer Ausdruck', s);
      vtInt: If GetNumber(s, Zahl)
         then Result := ToStr(Trunc(Zahl))
         else Fehler('"'+s+'" ist kein gltiger numerischer Ausdruck', s);
      vtBool: If Testbedingung(s)
         then Result := '1'
         else Result := '0';
      else Result := ''
    end
end;

Function TKNSkript.TestIfVarName (Var s, VarName: String): TRVN; // GetVarName
Var p: Integer;
begin
   Result := vnIllegal;
   s := Trim(s); VarName := '';
   If (s+' ')[1]='%' then begin
      p := 2;
      While (p<=length(s)) and (Upcase(s[p]) IN Variablenzeichen) do begin
         VarName := VarName + UpCase(s[p]); Inc(p)
      end;
      If (p<=Length(s)) and (s[p]='%') then begin
         s := Trim(Copy(s, p+1, Length(s)-p));
         If VarName > '' then
            If Vars[VarName] = NIL
               then Result := vnNew
               else Result := vnExist;
      end
   end
end;

Function TKNSkript.TestExistingStrVar (Var s, VarName: String): boolean; // GetVarName
Var Neu: String;
begin
   Result := false;
   Neu := s;
   if TestIfVarName (Neu, VarName) = vnExist then begin
      Result := Vars[VarName].Typ = vtStr;
   end;
   If Result then s := Neu
end;

Function TKNSkript.GetVarValueStr(Const VarName: String): String;
Var V: TVarObj;
begin
   Result := '';
   V := Vars[VarName];
   If Assigned(V)
      then Result := V.asString
      else Fehler ('Unbekannte String-Variable %'+VarName+'%!', '')
end;

Function TKNSkript.GetVarValueNum(Const VarName: String): Double;
Var V: TVarObj;
begin
   Result := 0;
   V := Vars[VarName];
   If Assigned(V)
      then Result := V.asFloat
      else Fehler ('Unbekannte numerische Variable %'+VarName+'%!', '')
end;

Procedure TKNSkript.SetzeVariablenInhalt (Const VarName: String; Var s: String);
Var V: TVarObj; slTemp: TStringlist; Zahl: Double; ok: boolean;
begin
   If Vars.Exists(VarName)
      then V := Vars[VarName]
      else V := Vars.Add (VarName, vtStr);
   Case V.Typ of
      vtStr: begin
         slTemp := TStringlist.Create;
         try
            BlockAnhaengen(slTemp, s, false, true);
            s := slTemp[0];
            While slTemp.Count > 1 do begin
               s := s + #13#10 + slTemp[1];
               slTemp.Delete(1)
            end;
            V.asString := s
         finally
            slTemp.free
         end
      end;
      vtInt: begin
         If SucheUndKuerze('=', s) and GetNumber(s, Zahl) and ( s = '' )
            then V.asInteger := Trunc(Zahl)
            else Fehler ('Fehlerhafte Zuweisung an eine Integervariable, korrekt wre: Set %'+VarName+'% = numerischer Ausdruck', s)
      end;
      vtFloat: begin
         If SucheUndKuerze('=', s) and GetNumber(s, Zahl) and ( s = '' )
            then V.asFloat := Zahl
            else Fehler ('Fehlerhafte Zuweisung an eine Float-Variable, korrekt wre: Set %'+VarName+'% = numerischer Ausdruck', s)
      end;
      vtBool: begin
         ok := false;
         If SucheUndKuerze('=', s) then begin
            V.asBoolean := TestBedingung(s);
            ok := s = ''
         end;
         If Not ok then Fehler ('Fehlerhafte Zuweisung an eine boolsche Variable, korrekt wre: Set %'+VarName+'% = Bedingung', s)
      end;
   end
end;

// ----------------------------------------------------------------------------------

Procedure TKNSkript.Fehler (Const Beschreibung, Rest: String);
Var Zeile2: Integer; i, j, p: Integer; s: String;

   Function ML(Const s: String): String;
   Var i: Integer;
   begin
      With TStringlist.Create do try
         Text := s;
         If Count>0 then Result := Strings[0] else Result := '';
         For i:=1 to Count-1 do Result := Result + #13#10 + '       <CRLF>' + Strings[i]
      finally free end
   end;

   Procedure SaveList (Ini: TInifile; Const Abschn: String; sl: TStrings);
   Var i: Integer;
   begin
      With Ini do try
         EraseSection (Abschn);
         WriteInteger(Abschn, '*', sl.Count);
         For i := 0 to sl.Count-1 do begin
            WriteString(Abschn, Inttostr(i+1), '@'+sl[i])
         end
      except end
   end;

Var ZNr: Integer;
    Zeileninhalt, Skript_Dateiname, Fehlerhinweis: String;
    mGesamt, mVars, mSkript, mText: TStringlist;
    {$IFDEF NOGUI}
    Datei: Text;
    {$ENDIF}
begin With Artikel do begin
   mGesamt := TStringlist.Create;
   mText := TStringlist.Create;
   mVars := TStringlist.Create;
   mSkript := TStringlist.Create;
   try
      If Zeile <= Count then begin
         Zeile2 := ZeilenNr[Zeile-1];
         ZNr := Zeile2;
         Zeileninhalt := Zeilen[Zeile-1].Inhalt;
         Skript_Dateiname := Dateiname[Zeile-1]
      end else begin
         ZNr := 0;
         Zeile2 := 0;
         Zeileninhalt := '';
         Skript_Dateiname := ''
      end;
      Fehlerhinweis := Beschreibung;

      With mGesamt do begin
         Clear;
         For i:=0 to self.Count-1 do Add(self[i].Inhalt)
      end;
      With mSkript do begin
         LoadTextFile(Skript_Dateiname, mSkript);
         p := 0; For i:=0 to Zeile2-2 do p := p + Length(Strings[i])+2;
         If Beschreibung = '' then begin
             p := p + Length(Strings[Zeile2-1])
         end else If Length(Rest) > 0  then begin
            s := Strings[Zeile2-1];
            j := Pos(Rest, s) - 1;
            If j>0 then p := p + j
         end
      end;
      With mVars do begin
         Clear;
         Add ('Zeile '+Inttostr(ZNr)+'/'+InttoStr(self.Count)+': '+Zeileninhalt);
         If Level > 0 then begin
            Add (''); Add ('Bedingte Ausfhrung:');
            For i:=1 to Level do begin
               s := '  '; For j := 2 to i do s := s + ' ';
               If Bed[i] then s := s + 'Wird ausgefhrt' else s := s + 'Wird ignoriert';
               Add (s)
            end;
         end;
         If slStack.Count>0 then begin
            Add (''); Add ('Stack:');
            For i := 0 to slStack.Count-1 do Add ('  '+slStack[i]);
         end;
         If Vars.Count>0 then begin
            Add (''); Add ('Variablen:');
            s := '';
            For i := 0 to Vars.Count-1 do begin
               With Vars.Items[i] do begin
                  Case Typ of
                     vtStr: s := '"'+ML(AsString)+'"';
                     else s := asString
                  end;
                  Case LocalState of
                     lsGlobalVar:  s := '  Global %'+Name+'% = ' + s;
                     lsBeginLocal: s := '  Ausfhrung von Sub '+s;
                     lsPar:        s := '      Parameter %'+Name+'% = ' + s;
                     lsVarPar:     s := '      Var-Parameter %'+Name+'% => %' + AsString + '%';
                     lsLocalVar:   s := '      Local %'+Name+'% = ' + s;
                  end;
               end;
               Add (s)
            end
         end;
         If slOptionenKey.Count>0 then begin
            Add (''); Add ('Neu gesetzte Optionen:');
            For i := 0 to slOptionenKey.Count-1 do
               Add ('  '+slOptionenKey[i] + '=' + slOptionenValue[i])
         end;
         {$IFDEF CopyIf}
         {$ELSE}
         If slBodyHeader.Count>0 then begin
            Add (''); Add ('Bodyheader:');
            For i := 0 to slBodyHeader.Count-1 do Add ('  '+slBodyHeader[i])
         end;
         {$ENDIF}
         If AktIntroExists then With AktIntro do begin
            If Count>0 then begin
               Add (''); Add ('Einleitungszeile(n) "Intro":');
               For i := 0 to Count-1 do Add ('  '+Strings[i])
            end
         end;
         {$IFDEF CopyIf}
         {$ELSE}
         If slAppend.Count>0 then begin
            Add (''); Add ('Anzuhngende "Lines":');
            For i := 0 to slAppend.Count-1 do Add ('  '+slAppend[i])
         end;
         If Part.Sig.changed then begin
            Add (''); Add ('Gewhlte Signatur:');
            For i := 0 to Part.Sig.Count-1 do Add ('  '+Part.Sig[i])
         end;
         {$ENDIF}
         If (Count>0) and (Strings[0]='') then Delete(0)
      end;
      With mText do begin
         try text := Gesamttext except text := '<< Textdatei zu gro fr Memo >>' end
      end;

      {$IFDEF NOGUI}
      s := TempName;
      AssignFile(Datei, s);
      Rewrite(Datei);
      Writeln(Datei, Skript_Dateiname);
      Writeln(Datei, fDateiname);
      Writeln(Datei, ZNr);
      Writeln(Datei, Zeileninhalt);
      Writeln(Datei, Fehlerhinweis);
      Writeln(Datei, p);
      Writeln(Datei, Zeile2);
      With mGesamt do begin
         Writeln(Datei, Count);
         For i := 0 to Count-1 do Writeln(Datei, Strings[i])
      end;
      With mVars do begin
         Writeln(Datei, Count);
         For i := 0 to Count-1 do Writeln(Datei, Strings[i])
      end;
      With mSkript do begin
         Writeln(Datei, Count);
         For i := 0 to Count-1 do Writeln(Datei, Strings[i])
      end;
      With mText do begin
         Writeln(Datei, Count);
         For i := 0 to Count-1 do Writeln(Datei, Strings[i])
      end;
      CloseFile(Datei);
      ExecAndWait (ExtractFilePath(ParamStr(0))+'Korrnews.exe', '#ShowError# "'+s+'"', SW_SHOW);
      Reset(Datei);
      Readln(Datei, Zeile2);
      Readln(Datei, i);
      Retry := TRetry(i);
      CloseFile(Datei);
      DeleteFile (s);
      {$ELSE}
      Fehlerdialog (Skript_Dateiname, fDateiname, ZNr, Zeileninhalt,
                    Fehlerhinweis, mGesamt, mVars, mSkript, p, mText,
                    Retry, Zeile2);
      {$ENDIF}

      Reload;
      Zeile := Zeile2;
      Abort

   finally
      mGesamt.free; mVars.free; mSkript.free; mText.free
   end;

   If Retry = rEndProgram then Halt

end end;

// ----------------------------------------------------------------------------------

Procedure TKNSkript.DeleteBodyHeader(Const Header: String);
Var Suchen: String; L, i: Integer;
begin
   Suchen := LowerCase(Header)+': '; L := Length(Suchen);
   For i:=0 to slBodyHeader.Count-1 do begin
      If Suchen = LowerCase(Copy(slBodyHeader[i], 1, L)) then begin
         slBodyHeader.Delete(i); break
      end
   end
end;

Procedure TKNSkript.InsertBodyHeader;
Var j: Integer; Header, Inhalt: String;
begin
   Artikel.ActivePart := 1;
   If slBodyHeader.Count > 0 then begin
      For j := 0 to slBodyHeader.Count-1 do begin
         If Split_Headerzeile (slBodyHeader[j], Header, Inhalt)
            then Artikel.Header.Change (Header, Inhalt)
      end
   end
end;

// ----------------------------------------------------------------------------------

Function TKNSkript.SetzeOption (Const s: String): boolean;
Var P: Integer; s2, Key, value: String;
begin
   Result := false;
   p := Pos('=', s);
   If p > 0 then begin
      Key := LowerCase(Trim(Copy(s,1,p-1)));
      s2 := Trim(Copy(s,p+1,Length(s)));
      If Not GetString(s2, Value) then Value := s2;
      p := slOptionenKey.IndexOf(key);
      If p<0 then begin
         slOptionenKey.Add(Key); slOptionenValue.Add(Value)
      end else slOptionenValue[p] := value;
      { Optionen wieder einlesen... }
      With Opt do begin
         ExtraKeys := slOptionenKey; ExtraValues := slOptionenValue;
         Opt.ReadSettings (false);
         ExtraKeys := NIL; ExtraValues := NIL
      end;
      Result := true
   end
end;

// ----------------------------------------------------------------------------------

Function TKNSkript.TestOnly7Bit: Boolean;
Var j, i: Integer; s2: String;
begin With Artikel do begin
   If Not Only7BitTested then begin
      Only7Bit := true;
      With Part.Body do For i:= 0 to Count-1 do If Only7Bit then begin
         s2 := Strings[i]; For j:=1 to Length(s2) do If s2[j]>#127 then Only7Bit := false
      end;
      If AktIntroExists then With AktIntro do begin
         For i:= 0 to Count-1 do If Only7Bit then begin
            s2 := Strings[i]; For j:=1 to Length(s2) do If s2[j]>#127 then Only7Bit := false
         end
      end;
      {$IFDEF CopyIf}
      {$ELSE}
      With Part.Sig do For i:= 0 to Count-1 do If Only7Bit then begin
         s2 := Strings[i]; For j:=1 to Length(s2) do If s2[j]>#127 then Only7Bit := false
      end;
      With slAppend do For i:= 0 to Count-1 do If Only7Bit then begin
         s2 := Strings[i]; For j:=1 to Length(s2) do If s2[j]>#127 then Only7Bit := false
      end;
      {$ENDIF}
   end;
   Result := Only7Bit

end end;

// ----------------------------------------------------------------------------------

Procedure TKNSkript.SaveAttachment (Const Pfad, Dateiname: String; Const Action: TActionIfAttExists);
Var Dateiname2: String;
begin
   Dateiname2 := SaveFile (Pfad, Dateiname, Artikel.Part.AttBody, Action);
   if Dateiname2 > '' then begin
      Artikel.Part.Body.Text := 'Saved as <file://localhost/'+Dateiname2+'>';
      If Artikel.Part.MimeInfo.Kodierung = kBase64 then Artikel.Part.ChangeEncoding (k8Bit)
   end
end;

// ----------------------------------------------------------------------------------

{
Function TKNSkript.GetVarName (Var s, VarName: String): TRVN;
Var p: Integer; vt: TTypVariable;
begin
   Result := vnIllegal;
   s := Trim(s); VarName := '';
   If (s+' ')[1]='%' then begin
      p := 2;
      While (p<=length(s)) and (Upcase(s[p]) IN['A'..'Z','0'..'9','_','-','/','+','$','&']) do begin
         VarName := VarName + UpCase(s[p]); Inc(p)
      end;
      If (p<=Length(s)) and (s[p]='%') then begin
         s := Trim(Copy(s, p+1, Length(s)-p));
         If VarName > '' then
            If VarNamePos(Varname, vt) < 0
               then Result := vnNew
               else Result := vnExist;
      end
   end
end;

Function TKNSkript.GetVarNameForGetStr (Var s, VarName: String): boolean;
begin
   Result := false;
   If Not (Bed[Level-1] and Bed[Level]) then begin
      Result := true; Exit
   end;
   Case GetVarName(s, VarName) of
      vnNew: Fehler('Verwendung einer uninitialisierten Variable "%'+VarName+'%"', s);
      vnExist: If GetVarTyp(VarName) = tvString
         then Result := true
         else Fehler('"'+Varname+'" ist keine Stringvariable und kann somit nicht als Argument in Stringfunktionen verwendet werden', s);
   end
end;

// ----------------------------------------------------------------------------------

{ For-Next-Schleife }
Procedure TKNSkript.ForNextOnStack (Const ZeilenNr: Integer; Const VarBez: String;
   Const Ab, Bis, Step: Double);
begin
   slStack.InsertObject(0, 'For-Schleife', Pointer(ZeilenNr));
   slStack.Insert (1, VarBez);
   slStack.Insert (2, ToStr(Ab-Step));
   slStack.Insert (3, ToStr(Bis));
   slStack.Insert (4, ToStr(Step));
   Vars[VarBez].asFloat := Ab
end;
Procedure TKNSkript.TestNext;
Var VarBez: String; x, Bis, Step: Double; i, j, Stack: Integer; Cont: boolean;
begin
   Cont := false;
   If slStack.Count > 0 then begin
      If Copy(slStack[0], 1, 3) <> 'For' then Fehler('"Next" ohne passendes "For"!', '');
      Step := ToNum(slStack[4]);
      x := ToNum(slStack[2]) + Step;
      Bis := ToNum(slStack[3]);
      Cont := ((Step > 0) and (x <= Bis)) or ((Step < 0) and (x >= Bis));
   end else Fehler('"Next" ohne vorheriges "For"!', '');

   i := LongInt(slStack.Objects[0]);
   If Cont then begin
      VarBez := slStack[1];
      x := ToNum(slStack[2]) + ToNum(slStack[4]); { Ab + Step }
      Zeile := i;
      Vars[VarBez].asFloat := x;
      slStack[2] := ToStr(x)
   end else begin
      Stack := 1;
      For j := 0 to 4 do slStack.Delete(0);
      While (Stack <> 0) and (i < Count) do begin
         Inc(i);
         Case self[i-1].Typ of
            ztEndsub: Fehler('Zugehriges "Next" zum "For" fehlt in der aktuellen Prozedur!', '');
            ztSub: Fehler('Zugehriges "Next" mu sich vor einem Prozeduranfang (Sub ...) befinden!', '');
            ztFor: Inc(Stack);
            ztNext: Dec(Stack);
         end
      end;
      If Stack = 0 then Zeile := i
                   else Fehler('Zugehriges "Next" fehlt!', '');
   end
end;

{ Repeat-Until-Schleife }
Procedure TKNSkript.RepeatOnStack (Const ZeilenNr: Integer);
begin
   slStack.InsertObject(0, 'Repeat-Schleife', Pointer(ZeilenNr));
   slStack.Insert (1, '')
end;
Procedure TKNSkript.TestUntil;
Var i, j, Stack, NeuZ: Integer; Cont: boolean; Bedingung: String;
begin
   Cont := false; NeuZ := 0;
   If slStack.Count > 0 then begin
      If Copy(slStack[0], 1, 6) <> 'Repeat' then Fehler('"Until" ohne passendes "Repeat"!', '');
      Bedingung := slStack[1]; NeuZ := LongInt(slStack.Objects[1]);
      If NeuZ = 0 then begin
         i := LongInt(slStack.Objects[0]); Stack := 1;
         While (Stack <> 0) and (i < Count) do begin
            Inc(i);
            Case self[i-1].Typ of
               ztEndsub: Fehler('Zugehriges "Until" zum "Repeat" fehlt in der aktuellen Prozedur!', '');
               ztSub: Fehler('Zugehriges "Until" mu sich vor einem Prozeduranfang (Sub ...) befinden!', '');
               ztRepeat: Inc(Stack);
               ztUntil: Dec(Stack);
            end
         end;
         If Stack = 0 then NeuZ := i
                      else Fehler('Zugehriges "Until" fehlt!', '');
         slStack.Objects[1] := Pointer(NeuZ);
         Bedingung := Trim(self[i-1].Inhalt);
         SucheUndKuerze('Until', Bedingung);
         slStack[1] := Bedingung
      end;
      Cont := Not TestBedingung(Bedingung)
   end else Fehler('"Until" ohne vorheriges "Repeat"!', '');


   If Cont then begin
      Zeile := LongInt(slStack.Objects[0]);
   end else begin
      Zeile := NeuZ;
      For j := 0 to 1 do slStack.Delete(0)
   end
end;

{ While-Wend-Schleife }
Procedure TKNSkript.WhileOnStack (Const ZeilenNr: Integer; Const Bedingung: String);
begin
   slStack.InsertObject(0, 'While-Schleife', Pointer(ZeilenNr));
   slStack.Insert (1, Bedingung)
end;
Procedure TKNSkript.TestWend;
Var i, j, Stack: Integer; Cont: boolean; Bedingung: String;
begin
   Cont := false;
   If Count > 0 then begin
      If Copy(slStack[0], 1, 5) <> 'While' then Fehler('"Wend" ohne passendes "While"!', '');
      Bedingung := slStack[1];
      Cont := TestBedingung(Bedingung)
   end else Fehler('"Wend" ohne vorheriges "While"!', '');

   i := LongInt(slStack.Objects[0]);
   If Cont then begin
      Zeile := i
   end else begin
      Stack := 1;
      For j := 0 to 1 do slStack.Delete(0);
      While (Stack <> 0) and (i < Count) do begin
         Inc(i);
         Case self[i-1].Typ of
            ztEndsub: Fehler('Zugehriges "Wend" zum "While" fehlt in der aktuellen Prozedur!', '');
            ztSub: Fehler('Zugehriges "Wend" mu sich vor einem Prozeduranfang (Sub ...) befinden!', '');
            ztWhile: Inc(Stack);
            ztWend: Dec(Stack);
         end
      end;
      If Stack = 0 then Zeile := i
                   else Fehler('Zugehriges "Wend" fehlt!', '');
   end
end;

{ Endless-Loop-Schleife }
Procedure TKNSkript.LoopOnStack (Const ZeilenNr: Integer);
begin
   slStack.InsertObject(0, 'Endless-Loop-Schleife', Pointer(ZeilenNr));
end;
Procedure TKNSkript.TestLoop;
begin
   If slStack.Count > 0 then begin
      If Copy(slStack[0], 1, 7) <> 'Endless' then Fehler('"Loop" ohne passendes "Endless"!', '');
   end else Fehler('"Loop" ohne passendes "Endless"!', '');
   Zeile := LongInt(slStack.Objects[0])
end;

{ Break / Continue }

Procedure TKNSkript.TestBreak;
Var i, Neu, Anz, Ueb: Integer;
begin
   i := Zeile;
   Neu := -1; Anz := 0; Ueb := 0;
   While (Neu < 0) and (i < Count) do begin
      Inc(i);
      Case self[i-1].Typ of
         ztSub, ztFor, ztWhile, ztRepeat, ztDo, ztSelectCase: Inc(Ueb);
         ztEndSub: If Ueb > 0
            then Dec(Ueb)
            else Fehler('Break ohne passende Schleife, Prozeduren beendet man mit "Return"!', '');
         ztWend, ztUntil: If Ueb>0 then Dec(Ueb) else begin Neu := i; Anz := 2 end;
         ztNext: If Ueb>0 then Dec(Ueb) else begin Neu := i; Anz := 5 end;
         ztLoop: If Ueb>0 then Dec(Ueb) else begin Neu := i; Anz := 1 end;
         ztEndSelect: If Ueb > 0
            then Dec(Ueb)
            else Fehler('Break ohne passende Schleife, Select/Case-Statements sind mit break nicht beendbar!', '');
      end
   end;
   If Neu < 0 then Fehler ('Break ohne passende Schleife!', '');
   Zeile := Neu;
   For i := 1 to Anz do
      If slStack.Count>0
         then slStack.Delete(0)
         else Fehler('Interner Fehler: Stack kann nach "break" nicht korrekt aufgerumt werden, da zuwenig Argumente auf Stack!', '');
end;

Procedure TKNSkript.TestContinue;
Var s: String;
begin
   If slStack.Count = 0 then Fehler('Continue ohne passende Schleife', '')
   else begin
      s := slStack[0];
      If Copy(s, 1, 3) = 'For' then TestNext
      else
      If Copy(s, 1, 5) = 'While' then TestWend
      else
      If Copy(s, 1, 6) = 'Repeat' then TestUntil
      else
      If Copy(s, 1, 7) = 'Endless' then TestLoop
      else
      Fehler ('Auf das Konstrukt "'+s+'" kann "Continue" nicht angewendet werden!', '')
   end
end;

{ Sub / Endsub }
Procedure TKNSkript.TestEndSub;
begin
   If slStack.Count > 0 then begin
      If Copy(slStack[0], 1, 3) <> 'Sub'
         then Fehler('Sub kann erst verlassen werden, wenn zumindest "'+slStack[slStack.Count-1]+'" beendet worden ist!', '');
      Zeile := LongInt(slStack.Objects[0]);
      slStack.Delete(0);
      Vars.RemoveLocalVars
   end else Fehler('"Return"/"EndSub" ohne vorheriges "GoSub"!', '')
end;

{ Clear Stack }
Procedure TKNSkript.ClearStackBetween (Const Ab, Bis: Integer);
Var i, Anz, SubStack: Integer;

   Procedure Test(Const i: Integer);
   begin
      If Not (i < Count) then exit;
      Case self[i].Typ of
         ztSub: Inc(SubStack);
         ztEndSub: Dec(SubStack);
         ztFor: Inc(Anz, 5); ztNext: Dec(Anz, 5);
         ztWhile, ztRepeat: Inc(Anz, 2); ztWend, ztUntil: Dec(Anz, 2);
         ztDo: Inc(Anz, 1); ztLoop: Dec(Anz, 1);
      end
   end;

begin
   Anz := 0; SubStack := 0;
   If Bis > Ab then begin
      For i := Ab+1 - 1 to Bis-1 - 1 do Test(i);
      Anz := - Anz
   end else begin
      For i := Ab-1 - 1 downto Bis+1 - 1 do Test(i)
   end;
   If SubStack <> 0 then Fehler('Goto wrde aktuelle Prozedur verlassen - solche Sprnge sind unzulssig!', '')
   else
   If Anz < 0 then Fehler('Goto wrde in das Innere einer Schleife springen - solche Sprnge sind unzulssig!', '')
   else
   If Anz > 0 then For i := 1 to Anz do slStack.Delete(0)
end;

// ----------------------------------------------------------------------------------

Procedure TKNSkript.ReplaceInBody (Const Reg, Ersatz: String; Const Modus: TReplaceMode;
   Const Where: TReplaceWhere; Const VarName: String; Const AbZeile, BisZeile: Integer);
Var hl, htr: TStringlist;
    PerlRe: TPerlRe;

   Procedure Test (Const Org, Reg, Ersatz: String;
      Var Neu: String; Var Found: boolean);
   Var Anz, j, MaxAnz: Integer;
   begin
      Neu := ''; Found := false;
      If Modus = rmFirst then MaxAnz := 1 else MaxAnz := 0;
      PerlRe.Split2 (Reg, Org, Anz, hl, htr, MaxAnz, 'J', '');
      If Anz > 0 then begin
         Case Modus of
            rmAll:
               For j:=0 to hl.Count-1 do begin
                  If htr[j]>'' then Neu := Neu + Ersatz
                               else Neu := Neu + hl[j];
                  found := true
               end;
            rmFirst:
               For j:=0 to hl.Count-1 do begin
                  If (Not found) and (htr[j]>'') then begin
                     Neu := Neu + Ersatz; Found := true
                  end else Neu := Neu + hl[j]
               end;
            rmLast:
               For j:=hl.Count-1 downto 0 do begin
                  If (Not found) and (htr[j]>'') then begin
                     Neu := Ersatz + Neu; Found := true
                  end else Neu := hl[j] + Neu
               end;
         end
      end
   end;

   Function Anz: Integer;
   begin
      Case Where of
         rwBody   : Result := Artikel.Part.Body.Count;
         rwSig    : Result := Artikel.Part.Sig.Count;
         rwHeader : Result := Artikel.Header.Count;
         rwHeader2: Result := Artikel.Part.Header.Count;
         rwLines  : Result := slAppend.Count;
         rwIntro  : If AktIntroExists then Result := AktIntro.Count else Result := 0;
         else Result := 0
      end
   end;

   Function GetLine(Const i: Integer): String;
   begin
      Case Where of
         rwBody   : Result := Artikel.Part.Body[i];
         rwSig    : Result := Artikel.Part.Sig[i];
         rwHeader : Result := Artikel.Header[i];
         rwHeader2: Result := Artikel.Part.Header[i];
         rwLines  : Result := slAppend[i];
         rwIntro  : If AktIntroExists then Result := AktIntro[i] else Result := '';
      end
   end;

   Procedure SetLine(Const i: Integer; Const s: String);
   begin
      Case Where of
         rwBody   : Artikel.Part.Body[i] := s;
         rwSig    : Artikel.Part.Sig[i] := s;
         rwHeader : Artikel.Header[i] := s;
         rwHeader2: Artikel.Part.Header[i] := s;
         rwLines  : slAppend[i] := s;
         rwIntro  : If AktIntroExists then AktIntro[i] := s;
      end
   end;

Var i, LastPos: Integer; Neu: String; found: boolean;
begin
   If Where = rwVar then begin
      If Not Vars.Exists(VarName) then Fehler('Variable "'+Varname+'" existiert nicht, Replace somit nicht anwendbar', '');
      if Vars[VarName].Typ <> vtStr then Fehler('Variable "'+Varname+'" ist keine Stringvariable, Replace somit nicht anwendbar', '')
   end;
   hl := TStringlist.Create;
   htr := TStringlist.Create;
   PerlRe := TPerlRe.Create(true, 0);
   LastPos := -1;
   try
      If Where = rwVar then begin
         Test (Vars[Varname].asString, Reg, Ersatz, Neu, Found);
         If Found then Vars[VarName].asString := Neu
      end else begin

         For i:=0 to Anz-1 do
            If (GetLine(i)>'') and ((AbZeile=-1) or (i+1 >= AbZeile)) and ((BisZeile=-1) or (i+1 <= BisZeile))
         then begin
            Test (GetLine(i), Reg, Ersatz, Neu, Found);
            If Found then begin
               If Modus = rmLast then begin LastPos := i; continue end;
               SetLine(i, Neu);
               If Modus = rmFirst then break
            end
         end;
         If (Modus = rmLast) and (LastPos >= 0) then begin
            SetLine(LastPos, Neu)
         end
      end
   finally
      hl.free; htr.free; PerlRe.free
   end
end;

Function TKNSkript.LoescheZwischen (Const Erstem: boolean; Const Such1, Such2: String;
    Const DelSuch, SetzeErsatztext: boolean; Const Ersatz: String): boolean;

   Function Found (sl: TStrings): boolean;
   Var M: Byte; i, p1, p2: Integer; s: String;
   begin
      p1 := 0; p2 := 0; M := 0;

      If Erstem then begin
         If Such1 = '' then begin M := 1; p1 := -1 end;
         For i:=0 to sl.Count-1 do begin
            s := sl[i];
            Case M of
               0: If RegEx.MatchRS (Such1, s) then begin p1 := i; Inc(M) end;
               1: If RegEx.MatchRS (Such2, s) then begin p2 := i; Inc(M); break end;
            end
         end
      end else begin
         If Such2 = '' then begin M := 1; p2 := sl.Count end;
         For i:=sl.Count-1 downto 0 do begin
            s := sl[i];
            Case M of
               0: If RegEx.MatchRS (Such2, s) then begin p2 := i; Inc(M) end;
               1: If RegEx.MatchRS (Such1, s) then begin p1 := i; Inc(M); break end;
            end
         end
      end;

      Result := (M = 2);
      If Result then begin
         For i:=1 to p2-p1-1 do sl.Delete(p1+1);
         If DelSuch then begin
            If Such1 > '' then sl.Delete(p1) else p1 := 0;
            If Such2 > '' then sl.Delete(p1)
         end;
         If SetzeErsatztext and (Ersatz>'') then begin
            If (Not DelSuch) then Inc(p1);
            sl.Insert(p1, Tested(Ersatz, true))
         end
      end
   end;

begin
   Result := true;
   If Not Found (Artikel.Part.Sig)
      then If Not Found(Artikel.Part.Body)
         then Result := false
end;

Procedure TKNSkript.ExpandiereMakro (Const Vergleich: String; slErsatz: TStringlist);
Var i, j: Integer;
begin
   With Artikel.Part.Body do For i:=Count-1 downto 0 do If Strings[i] = Vergleich then begin
      changed := true;
      Delete(i);
      For j := slErsatz.Count-1 downto 0 do Insert(i, slErsatz[j])
   end
end;

Procedure TKNSkript.Check_ConvertOEBeginBug;

   Function Test (sl: TStrings): boolean;
   Var i: Integer; s: String;
   begin
      Result := false;
      For i := 0 to sl.Count-1 do begin
         s := sl[i];
         If (Length(s)>7) and (Copy(s,1,7)='begin  ') then begin
            If s[8] IN['A'..'Z', 'a'..'z', '0'..'9'] then begin
               Delete(s, 6, 1); sl[i] := s; Result := true
            end
         end
      end
   end;

Var b: boolean;   
begin
   b := false;
   If Test (Artikel.Part.Body) then b := true;
   If Test (Artikel.Part.Sig) then b := true;
   If b then Artikel.Header.Add (Extraheader_OEBeginBug)
end;

Procedure TKNSkript.Check_OE_Zitate;

  Function ZaehleEbenen(Const s: String): Integer;
  Var OtherChars: Boolean; i: Integer;
  begin
     Result := 0;
     OtherChars := false;
     If Copy(s,1,1)='>' then begin
        For i := 1 to Length(s) do Case s[i] of
           '>': Inc(Result);
           ' ', ^I: ;
           else begin OtherChars := true; break end
        end;
        If Not OtherChars then Result := -1
     end else
     If Copy(s,1,1)+' '=' ' then Result := -1
  end;

Var i, j {$IFDEF CopyIf} , Anz {$ENDIF}: Integer; s1, s2: String;
    Eb1, Eb2, l1, l2, pSp: Integer; ok: boolean;
begin
   {$IFDEF CopyIf}
   If Artikel.Header.Position (Extraheader_RepairOE) >= 0 then exit;
   Anz := 0;
   {$ENDIF}
   i := 0;
   With Artikel do With Part.Body do begin
      While i < Count-1 - 1 do begin
         s1 := Strings[i];   Eb1 := ZaehleEbenen(s1);
         s2 := Strings[i+1]; Eb2 := ZaehleEbenen(s2);
         If (Eb1 > 0) and (Eb2 = 0) then begin
            l1 := Length(s1); l2 := Length(s2); pSp := Pos(' ', s2);
            If (l1 + l2 < 90+2*Eb1) and (l1 + l2 + Eb1 > 60)
               and ((l2<15) or ((pSp < 15) and (l2 < 30)))
            then begin
               ok := false;
               For j := 1 to Length(s2) do begin
                  If s2[j] = '^' then
                     break
                  else if s2[j] <> ' ' then begin
                     ok := true; break
                  end
               end;
               If ok then begin
                  Strings[i] := s1+' '+s2;
                  Delete(i+1);
                  {$IFDEF CopyIf} Inc(Anz); {$ENDIF}
               end
            end
         end;
         Inc(i)
      end
   end;
   {$IFDEF CopyIf}
   If Anz > 0 then Headerzeile_anhaengen (Extraheader_RepairOE + IntToStr(Anz) + 'x')
   {$ENDIF}
end;

Procedure TKNSkript.Check_ConvertHTML2Text;
Const kAlt = 'multipart/alternative';
      kMixed = 'multipart/mixed';
Var s, Datei, Pfad: String; p, L: Integer;
begin
   With Artikel.Part do begin
      s := Body.text;
      Pfad := ExtractFilePath(Opt.SaveHTMLAs);
      If Not DirectoryExists(Pfad) then MkDir(Pfad);
      Datei := SaveFile (Pfad, ExtractFileName(Opt.SaveHTMLAs), s, aeRename);
      If Datei = '' then exit;
      Datei := 'Original: <file://localhost/'+Datei+'>';
      L := Length(s);
      s := DecodeHTML(s);
      If (L<>Length(s)) and (Trim(s)> '') then begin
         Body.Text :=
             '============================================================================' + CRLF
           + '===  Ergebnis der automatischen HTML=>Text-Wandlung von Korrnews' + CRLF
           + '===  ' + Datei + CRLF
           + '============================================================================' + CRLF
           + CRLF + CRLF + s;
         s := Header.Inhalt ( 'Content-Type', hiRaw );
         p := Pos('text/html', LowerCase(s));
         If p > 0 then begin
            System.Delete (s, p, Length('text/html'));
            System.Insert ('text/plain', s, p);
            Header.Change ( 'Content-Type', s );
            RefreshMIMEInfo
         end;
         s := Artikel.Header.Inhalt( 'Content-Type', hiRaw );
         If Copy( s, 1, Length(kAlt)) = kAlt then begin
            Artikel.Header.Change ('Content-Type',
               kMixed + Copy(s, Length(kAlt)+1, Length(s)-Length(kAlt)) )
         end
      end
   end
end;

Procedure TKNSkript.Check_ConvertOEKillFalseReBug;
Var Org, s: String; i, p: Integer; b: boolean;
begin
   Org := Artikel.Header.Inhalt (HeaderSubject, hiDecoded);
   If (Org > '') and (Artikel.Header.Position(HeaderReferences)<0) then begin
      s := DecodeISO (HeaderCharsets, Org); p := Pos(':', s);
      If (p>0) and (p<4) and (Lowercase(Copy(s, 1, 3))<>'re:') then begin
         b := true;
         For i:=1 to p-1 do
            If Not (s[i] IN ['A'..'Z', 'a'..'z']) then begin b := false; break end;
         If b then begin
            Artikel.Header.Change (HeaderSubject, 'XX: '+Org);
            Artikel.Header.Add (Extraheader_OEKillFalseReBug)
         end
      end
   end
end;

Procedure TKNSkript.ConvertBoxQuotes (Const Nr: Integer);
Var M: Byte; i, P1, P2, Zeile: Integer;
    s: String; bTitel: Boolean; Titel: String; slTemp: TStringlist;
begin
   M := 0; P1 := 0;
   bTitel := false;
   With BQ[Nr] do begin
      If Not Nutzbar then exit;
      Zeile := 0;
      While Zeile <= Artikel.Part.Body.Count-1 do begin
         s := Artikel.Part.Body[Zeile]; Inc(Zeile);
         If bDatei then begin
            If Copy(s, 1, Length(Anfangszeile)) = Anfangszeile then begin
               slTemp := TStringlist.Create;
               s := Trim(Copy(s, length(Anfangszeile)+1, Length(s)));
               If FileExists(s) then begin
                  LoadTextfile (s, slTemp);
                  slTemp.Insert(0, ''); slTemp.Add ('');
                  BoxQuote (s, BQ[Nr], slTemp);
                  Dec (Zeile); Artikel.Part.Body.Delete(Zeile);
                  For i:=0 to slTemp.Count-1 do Artikel.Part.Body.Insert (Zeile+i, slTemp[i]);
                  Inc (Zeile, slTemp.Count)
               end else begin
                  Fehler ('Die als BoxQuote anzuzeigende Datei "'+s+'" existiert nicht!', '')
               end
            end
         end else begin
            If s = Anfangszeile then begin M := 1; P1 := Zeile-1; bTitel := false end
            else If (s = Trennzeile) and (M=1) and (Zeile-1-P1=2) then begin Inc(M); bTitel := true end
            else If (s = Endzeile) and (M>0) then begin
               M := 0; p2 := Zeile-1;
               If bTitel then begin
                  Titel := Artikel.Part.Body[P1+1];
                  Artikel.Part.Body.Delete(P1+2); Artikel.Part.Body.Delete(P1+1);
                  Dec(P2, 2); Dec (Zeile, 2)
               end else begin
                  Titel := ''
               end;
               slTemp := TStringlist.Create;
               try
                  For i:=P1 to P2 do slTemp.Add (Artikel.Part.Body[i]);
                  BoxQuote (Titel, BQ[Nr], slTemp);
                  For i:=P1 to P2 do Artikel.Part.Body[i] := slTemp[i-P1]
               finally slTemp.free end
            end
         end
      end
   end
end;

Procedure TKNSkript.ConvertMinBodyCharset;
Var CS, CSAlt: String;
begin
   With Artikel.Part do begin
      CS := BodyCharsets.GetMinCharsetFor(Body.Text+Sig.Text).Headername;
      CSAlt := MimeInfo.Charset;
      If CS <> CSAlt then ChangeCharset (CS)
   end
end;

Procedure TKNSkript.Check_MIMEHeader;
Var i, j: Integer; b: boolean; Org, Neu, AktHeader: String;
begin
   With Artikel.Header do begin
      For i := 0 to Count-1 do begin
         AktHeader := LowerCase(Name[i])+': ';
         Org := DecodeISO(HeaderCharsets, Strings[i]);
         b := false;
         For j := 1 to Length(Org) do If Org[j]>Chr(127) then begin b := true; break end;
         If b then begin
            Neu := EncodeISO (HeaderCharsets, Org);
            If Neu <> Strings[i] then Strings[i] := Neu
         end
      end
   end
end;

Procedure TKNSkript.Check_SetIntroduction;
Var i: Integer; ok: boolean;
begin
   If Not AktIntroExists then Exit;
   With Artikel.Part do begin
      { Test, ob bereits vorhanden }
      If AktIntro.Count <= Body.Count then begin
         ok := false;
         For i:=0 to AktIntro.Count-1 do If Body[i] <> AktIntro[i] then ok := true
      end else ok := true;
      { Einsetzen }
      If ok then begin
         If Body.Text = #13#10
            then Body.Text := AktIntro.text
            else For i:=AktIntro.Count-1 downto 0 do Body.Insert(0, AktIntro[i])
      end
   end
end;

Procedure TKNSkript.ConvertEncoding (Const K: TKodierung);
begin
   With Artikel.Part do If MimeInfo.Kodierung <> K then ChangeEncoding (K);
   If K = k7Bit then begin
      With Artikel.Part do If AktIntroExists then With AktIntro do text := Convert1252ToAscii(text);
      With slAppend do text := Convert1252ToAscii(text);
   end
end;

Procedure TKNSkript.Check_Fussnoten;
Const FN_Format = '[%d]';

   Function Test (Var Ges: String): boolean;
   Var Start, p, p2, L, Level: Integer; s, Rest, FNText: String; {Endz: Char;}
   begin
      Result := false;
      Level := 0;
      Repeat
         Start := Pos(FN.Anfang, Ges);
         If Start > 0 then begin
            Rest := Copy(Ges, Start+Length(FN.Anfang), Length(Ges));
            Level := 1; p := 0; L := Length(Rest);
            Repeat
               Inc(p);
               If Rest[p] = FN.Anfang[1] then begin
                  If Copy(Rest, p, Length(FN.Anfang))=FN.Anfang then Inc(Level);
               end;
               If Rest[p] = FN.Ende[1] then begin
                  If Copy(Rest, p, Length(FN.Ende))=FN.Ende then Dec(Level)
               end;
            Until (Level = 0) or (p >= L-1);
            If Level = 0 then begin
               Result := true;
               FNText := Copy(Rest, 1, p-1);
               // Alles vor der Funote
               Ges := Copy(Ges, 1, Start-1) + Format(FN_Format, [slFN.Count+1]);
               // Die Zeile, in der die Funote begann in Rest bernehmen
               p2 := Length(Ges);
               While (p2>0) and (Ges[p2]<>#10) do Dec(p2);
               If p2>0 then begin
                  s := Copy(Ges, p2+1, Length(Ges)-p2);
                  Delete (Ges, p2+1, Length(s))
               end else begin
                  s := Ges; Ges := ''
               end;
               Rest := s + Copy(Rest, p+Length(FN.Ende), Length(Rest));
               // Kompletten Absatz um Funote ermitteln
               s := '';
               Repeat
                  p := Pos(#13#10, Rest);
                  If s > '' then If s[Length(s)]<>' ' then s := s + ' ';
                  If p=0 then begin
                     s := s + Rest; Rest := ''; break
                  end else begin
                     {Endz := Rest[p-1];}
                     s := s + Copy(Rest, 1, p-1); Delete(Rest, 1, p+1);
                     If (p=1) {or (Endz IN ['.','!','?',':'])} then BREAK
                  end
               Until false;
               // Absatz neu umbrechen
               s := WordWrap(s, '', FN.Breite);
               If Rest > '' then Rest := s + #13#10 + Rest else Rest := s;
               // und anhngen...
               Ges := Ges + Rest;
               // Funote erzeugen
               slFN.Add (FNText)
            end
         end
      Until (Start = 0) or (Level > 0)
   end;

Var Ges, s, Vorzeile: String; i, j, k, p: Integer; b: boolean;
begin
   i := 0; b := false;
   While i < Artikel.Part.Body.Count do begin
      s := Artikel.Part.Body[i];
      if (Pos(FN.Anfang, s)>0) and Not (s[1] IN['>', '|']) then begin
         Ges := s; j := i+1;
         Repeat
            { Zeile noch zu Absatz gehrig? }
            If  j = Artikel.Part.Body.Count then break;
            Vorzeile := s; s := Artikel.Part.Body[j];
            b := (s>'') and Not ((s+' ')[1] IN['>', '|']);
            If b then begin
               p := Pos(' ', s); If p=0 then p := Length(s)+1;
               b := (Length(Vorzeile) + p + 5) > FN.Breite
            end;
            { Dann weitermachen }
            If b then begin
               Ges := Ges + #13#10 + s; Inc(j)
            end
         Until Not b;
         If Test(Ges) then begin
            b := true;
            For k := i to j-1 do Artikel.Part.Body.Delete(i);
            While Ges > '' do begin
               p := Pos(#13#10, Ges);
               If p>0 then begin
                  Artikel.Part.Body.Insert(i, Copy(Ges, 1, p-1));
                  Delete (Ges, 1, p+1); Inc(i)
               end else begin
                  Artikel.Part.Body.Insert(i, Ges); Ges := ''
               end
            end
         end
      end;
      Inc(i)
   end;

   {
   Ges := Artikel.Body.Text;
   If Test (Ges) then begin }
   If b then begin
      i := 0;
      While i < slFN.Count do begin
         s := slFN[i];
         While Test(s) do slFN[i] := s;
         slFN[i] := s;
         Inc (i)
      end;
      {Artikel.Body.Text := Ges;}
   end
end;
Procedure TKNSkript.Check_AppendFussnoten;
Const FN_Format = '[%d]';

   Function Combine (Const Org: String): String;
   Var i, p: Integer; s: String;
   begin
      With TStringlist.Create do try
         Text := Org;
         Result := '';
         For i := 0 to Count-1 do begin
            s := Strings[i];
            If s = '' then
               Result := Result + #13#10 + #13#10
            else begin
               If Result > '' then Case Result[Length(Result)] of
                  '-': System.Delete(Result, Length(Result), 1);
                  ' ', ^I: ;
                 { '.','!','?',':': begin
                     For j := i to Count-1
                        do Result := Result + #13#10 + Strings[j];
                     BREAK
                  end; }
                  else Result := Result + ' '
               end;
               Result := Result + s;
            end
         end;
      finally free end;
      If FN.Zeilenwechsel > '' then Repeat
         p := Pos(FN.Zeilenwechsel, Result);
         If p > 0 then begin
            Delete(Result, p, Length(FN.Zeilenwechsel));
            Insert(#13#10, Result, p)
         end
      Until p = 0
   end;

Var s, s2, Nr, Leer: String; i, j: Integer; 
begin
   { Einsetzen }
   s := KuerzeLeerzeilenAmEnde(Artikel.Part.Body.text);
   s := s + #13#10;
   If FN.Titel > '' then begin
      s := s + #13#10 + FN.Titel;
      If FN.TitelUnterstreichen then begin
         s := s + #13#10;
         For i := 1 to Length(FN.Titel) do s := s + FN.UnterstreichenMit;
         If FN.TitelLeerzeile then s := s + #13#10
      end
   end;
   For i := 1 to slFN.Count do begin
      Nr := Format(FN_Format, [i]);
      // Bei mehr als 10 Funoten ggf. einrcken
      If (slFN.Count > 9) and (i < 10) then Nr := ' '+Nr;
      // Einrckung fr Zeile 2 aufwrts
      Leer := Nr+' '; For j:=1 to Length(Nr) do Leer[j] := ' ';
      // Einrckung erste Zeile mit X, um Fehlumbrche zu vermeiden
      s2 := Nr+'X'; For j := 1 to Length(Nr) do s2[j] := 'X';
      // Umbruch durchfhren
      s2 := WordWrap(s2 + Combine(Trim(slFN[i-1])), Leer, FN.Breite);
      // Einrckung erste Zeile korrigieren
      For j:=1 to Length(Nr)+1 do
         If j <= Length(Nr) then s2[j] := Nr[j] else s2[j] := ' ';
      // und fertig...
      s := s + #13#10 + s2
   end;
   Artikel.Part.Body.Text := s
end;

Procedure TKNSkript.Check_Reformat;
Var Start, Ende, j: Integer; s, s2, Erkennung1, Erkennung2: String;
begin
   Erkennung1 := Extra.Anfang_Reformat;
   Erkennung2 := Extra.Ende_Reformat;
   Start := 0;
   While Start < Artikel.Part.Body.Count do begin
      If Copy(Artikel.Part.Body[Start], 1, Length(Erkennung1)) = Erkennung1 then begin
         Ende := -1;
         For j := Start to Artikel.Part.Body.Count-1 do begin
            s := Artikel.Part.Body[j];
            If Length(s) >= Length(Erkennung2) then begin
               If Copy(s, Length(s)-Length(Erkennung2)+1, Length(Erkennung2)) = Erkennung2 then begin
                  Ende := j; Break
               end
            end;
            If Trim(s) = '' then Break
         end;
         If Ende > 0 then begin
            s := '';
            For j := Start to Ende do begin
               s2 := Trim(Artikel.Part.Body[Start]);
               While (s2>'') and (s2[1] IN[' ','>','|']) do Delete(s2, 1, 1);
               If s > '' then s := s + ' ';
               s := s + s2;
               Artikel.Part.Body.Delete(Start)
            end;
            s := Copy(s, Length(Erkennung1)+1, Length(s)-Length(Erkennung1)-Length(Erkennung2));
            s2 := '';
            For j := 1 to Length(s) do Case s[j] of
               ' ', '>', '|': s2 := s2 + s[j];
               else break
            end;
            Artikel.Part.Body.Insert(Start, WordWrap(s, s2, FN.Breite))
         end
      end;
      Inc(Start)
   end
end;

Procedure TKNSkript.Check_Oneliner;
Var Start, Ende, j: Integer; s, Erkennung1, Erkennung2: String;
begin
   Erkennung1 := Extra.Anfang_Oneliner;
   Erkennung2 := Extra.Ende_Oneliner;
   Start := 0;
   While Start < Artikel.Part.Body.Count do begin
      If Copy(Artikel.Part.Body[Start], 1, Length(Erkennung1)) = Erkennung1 then begin
         Ende := -1;
         For j := Start to Artikel.Part.Body.Count-1 do begin
            s := Artikel.Part.Body[j];
            If Length(s) >= Length(Erkennung2) then begin
               If Copy(s, Length(s)-Length(Erkennung2)+1, Length(Erkennung2)) = Erkennung2 then begin
                  Ende := j; Break
               end
            end;
            If Trim(s) = '' then Break
         end;
         If Ende >= Start then begin
            s := '';
            For j := Start to Ende do begin
               s := s + Artikel.Part.Body[Start];
               Artikel.Part.Body.Delete(Start)
            end;
            s := Copy(s, Length(Erkennung1)+1, Length(s)-Length(Erkennung1)-Length(Erkennung2));
            Artikel.Part.Body.Insert(Start, s)
         end
      end;
      Inc(Start)
   end
end;

Procedure TKNSkript.Check_AppendText;
Var s1, s2: String; j: Integer;
begin
   { Einsetzen }
   s1 := KuerzeLeerzeilenAmEnde(Artikel.Part.Body.text);
   s2 := KuerzeLeerzeilenAmEnde(slAppend.text);
   If (Length(s2) > Length(s1)) or (Copy(s1, Length(s1)-Length(s2)+1, Length(s2)) <> s2) then begin
      If Artikel.Part.Body.text = #13#10 then
         Artikel.Part.Body.text := slAppend.text
      else begin
         With Artikel.Part.Body do If Count > 0 then begin
            If Opt.BlankBeforeLines and (Strings[Count-1]<>'') then Add('')
         end;
         For j:=0 to slAppend.Count-1 do Artikel.Part.Body.Add (slAppend[j])
      end
   end
end;

Procedure TKNSkript.Check_BodyKorrekturen;
Var KorrigiereEinrueckung: Integer;
    DoNotChange: boolean;

   Function Teste (Const s: String): String;
   Var j, k, l, p: Integer;
       s2, s3, Quotechars: String;
   begin
      // If Opt.DontCheckSig then If Org = '-- ' then DoNotChange := true
      Result := s;
      If Result > '' then begin
         If RegEx.MatchRS(Opt.DoNotChangeBegin, Result) then DoNotChange := true;
         If RegEx.MatchRS(Opt.DoNotChangeEnd, Result) then DoNotChange := false;
      end;
      If DoNotChange then exit;
      
      { Delete at begin }
      With Opt do begin
         If (DelAtBegin > '') and (Copy(Result, 1, Length(DelAtBegin))=DelAtBegin)
            then System.Delete(Result, 1, Length(DelAtBegin))
      end;
      { Einrckungen korrigieren }
      If Opt.CheckQuotes and (Result > '') then begin
         Quotechars := '';
         If Pos(Result[1], Opt.AllowedQuoteChars)>0 then begin
            For j:=1 to Length(Result) do begin
               If Pos(Result[j], Opt.AllowedQuoteChars)>0 then begin
                  If Opt.SpaceBetweenDifferentQuoteChars and (Quotechars > '')
                     and (QuoteChars[Length(QuoteChars)] <> Result[j])
                  then
                     Quotechars := Quotechars + ' ';
                  Quotechars := Quotechars + Result[j]
               end else Case Result[j] of
                  ' ':
                     If (j < Length(Result)) and (Result[j-1] = ' ') then begin
                        break
                     end;
                  else begin
                     KorrigiereEinrueckung := 0; break
                  end
               end
            end;
            If (Not Opt.AddSpaceBetweenQuoteAndText) and (j>2)
               and (Result[j]=' ') and (Result[j-1]=' ')
            then begin
               Dec(j) {; If (Length(s)>(j+2)) and (s[j+2]=' ') then Inc(j)}
            end;
            If Quotechars > '' then begin
               s2 := Quotechars;
               s3 := Copy(Result, j, Length(Result));
               If s3 > '' then begin
                  { Korrigiere Einrueckung von "Unterstreichungen" - Innerhalb von Zitaten }
                  if KorrigiereEinrueckung<>0 then begin
                     l := Length(s2);
                     KorrigiereEinrueckung := KorrigiereEinrueckung - (l-(j-2));
                     If Opt.AddSpaceBetweenQuoteAndText
                        then s2 := s2 + ' '
                        else Inc(KorrigiereEinrueckung);
                     If KorrigiereEinrueckung>0 then
                        For k:=1 to KorrigiereEinrueckung do s2 := s2 + ' ';
                     s2 := s2 + s3;
                     If KorrigiereEinrueckung<0 then
                        For k:=1 to -KorrigiereEinrueckung do
                           If s2[l+1]=' ' then s2 := Copy(s2, 1, l)+Copy(s2, l+2, Length(s2));
                     KorrigiereEinrueckung := l-(j-2)
                  end else begin
                  { Standardzeile  }
                     KorrigiereEinrueckung := Length(s2)-(j-2);
                     If Opt.AddSpaceBetweenQuoteAndText
                        then s2 := s2 + ' '
                        else Dec (KorrigiereEinrueckung);
                     s2 := s2 + s3
                  end;
               end;
               //Assert('#'+s+'# => #'+s2+'# => '+Inttostr(KorrigiereEinrueckung));
               Result := s2
            end
         end else begin
            { Korrigiere Einrueckung von "Unterstreichungen" - normale Zeile }
            If (KorrigiereEinrueckung<>0) and (Result>'') and (Result[1]=' ') then begin
               s2 := Result;
               For j:=1 to KorrigiereEinrueckung do s2 := ' ' + s2;
               For j:=1 to -KorrigiereEinrueckung do
                  If (s2>'') and (s2[1]=' ') then s2 := Copy(s2, 2, Length(s2)-1);
               Result := s2;
            end;
            KorrigiereEinrueckung := 0
         end
      end;
      { ggf. falsche Message-ID-Verweise eleminieren }
      p := Pos(FalscheMessageID, Result);
      If p > 0
         then Result := Copy(Result, 1, p-1) + RichtigeMessageID
                   + Copy(Result, p+Length(FalscheMessageID), Length(Result));
   end;

Var Org, Neu: String; i, p: Integer;
begin
   KorrigiereEinrueckung := 0;
   DoNotChange := false;

   If LowerCase(Artikel.Header.Inhalt('X-Check-Body', hiRaw)) = 'false' then exit;

   With Artikel do With Part.Body do For i:=0 to Count-1 do begin
      Org := Strings[i]; Neu := '';
      While Org > '' do begin
         p := Pos(#13#10, Org);
         If p = 0 then begin
            Neu := Neu + Teste (Org);
            Org := ''
         end else begin
            Neu := Neu + Teste(Copy(Org, 1, p-1)) + #13#10;
            System.Delete(Org, 1, p+1)
         end
      end;
      If Neu <> Strings[i] then Strings[i] := Neu
   end;
end;

Procedure TKNSkript.DeleteEmptyLines;
begin
   With Artikel.Part do begin
      With Body do While (Count > 1) and (Trim(Body[Count-1]) = '') do Delete(Count-1);
      If HasSig then With Sig do While (Count > 0) and (Trim(Sig[Count-1]) = '') do Delete(Count-1)
   end
end;

Procedure TKNSkript.DeleteBlanksAtEndOfLines;

  Function Optimize(Var s: String): boolean;
  begin
     Result := false;
     If (s > '') and (s[Length(s)]=' ') then begin
        If (Length(s)<3) or (Copy(s,Length(s)-2,3)<>'-- ') then begin
           While (s > '') and (s[Length(s)]=' ') do begin
              SetLength(s, Length(s)-1); Result := true
            end
         end
     end
  end;

Var s: String; i: Integer;
begin
   With Artikel.Part do begin
      For i := 0 to Body.Count-1 do begin
         s := Body[i]; If Optimize(s) then Body[i] := s
      end;
      For i := 0 to Sig.Count-1 do begin
         s := Sig[i]; If Optimize(s) then Sig[i] := s
      end
   end
end;

// ----------------------------------------------------------------------------------

Procedure TKNSkript.Check_Headeranalyse;

  Procedure Check_Header;
  Var i, j, L, p, p2, q: Integer; b, bReExists: boolean;
      Org, Akt, s2, s3, s4, AktHeader, AktInhalt: String;
  begin
     FalscheMessageID := '';
     With Artikel.Header do begin
        For i := 0 to Count-1 do begin
           AktHeader := LowerCase(Name[i])+': ';
           If AktHeader = HeaderReferences then begin
              Org := Strings[i]; Akt := Org;
              { Message-ID korrigieren? }
              If Opt.lKillMessageIDBegins.Count>0 then begin
                 p := 0;
                 For j:= Length(Akt)-1 downto 1 do If Akt[j] = '<' then begin p := j+1; break end;
                 If p > 0 then begin
                    For j:=0 to Opt.lKillMessageIDBegins.Count-1 do begin
                       s3 := Opt.lKillMessageIDBegins[j];
                       If s3 = Copy(Akt, p, Length(s3)) then begin
                          System.Delete (Akt, p, Length(s3));
                          break
                       end
                    end
                 end
              end;
              { Message-ID zu lang? }
              If Opt.MaxReferencesLen>0 then begin
                 s3 := Akt;
                 With TStringlist.Create do try
                    Repeat
                       p := Pos('<', s3);
                       If p>0 then begin
                          If p>1 then s3 := Copy(s3, p, Length(s3)-p+1);
                          p := Pos('>', s3);
                          If p>0 then begin
                             Add(Copy(s3, 1, p));
                             s3 := Copy(s3, p+1, Length(s3)-p)
                          end
                       end
                    Until p=0;
                    L := Count-1;
                    For j:=0 to Count-1 do L := L + Length(Strings[j]);
                    If (L>Opt.MaxReferencesLen) and (Count>4) then begin
                       { zwischen erstem und drittletzten Eintrag krzen, von vorne beginnen }
                       For j:=1 to Count-3-1 do If L>Opt.MaxReferencesLen then begin
                          Dec(L, Length(Strings[1])+1); Delete(1)
                       end;
                       { Krzung wegschreiben }
                       Akt := Copy(Akt, 1, Length(HeaderReferences)) + Strings[0];
                       For j:=1 to Count-1 do Akt := Akt + ' '+Strings[j]
                    end
                 finally free end
              end;
              { References falten? }
              If Opt.FoldingReferences then begin
                 s3 := Akt;
                 Akt := '';
                 Repeat
                    If (Length(s3)>MaxISOHeaderLen) and (Pos(#13#10, s3)=0) then begin
                       p := 0;
                       For q := Pos('>', s3)+1 to Length(s3) do
                          If (s3[q]='<') and ((p=0) or (q-2<MaxISOHeaderLen)) then p := q;
                       If p>0 then begin
                          Akt := Akt + RTrim(Copy(s3, 1, p-1)) + #13#10;
                          s3 := ' '+Trim(Copy(s3, p, Length(s3)-p+1));
                          Changed := true
                       end;
                    end else p := 0
                 Until p = 0;
                 Akt := Akt + s3;
              end;
              If Akt <> Org then Strings[i] := Akt
           end else begin
              Org := DecodeISO(HeaderCharsets, Strings[i]);
              Akt := Org;
              If AktHeader = HeaderSubject then begin
                 s4 := Left(Akt, Length(HeaderSubject));
                 s2 := Copy(Akt, Length(HeaderSubject)+1, Length(Akt));
                 If Opt.DelDoubleRes then begin
                    bReExists := false;
                    Repeat
                       b := true;
                       p := Pos(': ', s2);
                       p2 := Pos(',', s2); If (p2 > 0) and (p2 < p) then p := 0;
                       If p > 1 then begin
                          s3 := LowerCase(Copy(s2, 1, p-1));
                          If (s3 = 're') or (pos(','+s3+',', LowerCase(','+Opt.ConvertXXToRe+','))>0) then begin
                             s2 := Copy(s2, p+2, Length(s2));
                             bReExists := true; b := false
                          end
                       end
                    Until b;
                    If bReExists then begin
                       s2 := 'Re: '+s2;
                       Akt := s4 + s2
                    end
                 end;
                 If Opt.CheckKillWasAfterRe then begin
                    p := pos(kWasbegin, LowerCase(s2));
                    If (LowerCase(Left(s2, Length(kRe)))=kRe) and (p>0) and (Right(s2, Length(kWasEnde))=kWasEnde) then begin
                       s2 := Trim(Left(s2, p-1)); Akt := s4 + s2
                    end
                 end;
                 If Opt.CheckReplaceSubject8Bits then begin
                    s3 := LowerCase(s2);
                    If (Copy(s3, 1, 3) <> kRe) and (Copy(s3, 1, 5) <> 'cmsg ') and (Copy(s3, 1, 7) <> 'cancel ') then begin
                       p := pos(kWasbegin, s3);
                       If (p > 0) and (Right(s3, Length(kWasEnde))=kWasEnde) then begin
                          s3 := Copy (s2, p, Length(s2)-p+1);
                          System.Delete(s2, p, Length(s2)-p+1)
                       end else begin
                          s3 := ''
                       end;
                       s2 := Convert1252ToAscii(s2)+s3; Akt := s4 + s2
                    end
                 end
              end;
              { From / Reply-To wandeln? }
              If Opt.CheckFromReplyFormat then begin
                 Split_Headerzeile (Akt, AktHeader, AktInhalt);
                 If (LowerCase(AktHeader)='reply-to') or (LowerCase(AktHeader)='from') then begin
                    ExtractMailParts (AktInhalt, s2, s3, s4);
                    s2 := MakeAdress(s2, s4);
                    If s2 <> AktInhalt then Akt := AktHeader + ': ' + s2
                 end
              end;
              // Setzen des genderten Headers...
              If Akt <> Org then Strings[i] := EncodeISO (HeaderCharsets, Akt)
           end
        end
     end
  end;

  Procedure Check_Bodyheader;
  Var Part: Integer; s, s2, AktHeader, AktInhalt: String;
  begin
     For Part := 0 to Artikel.Parts.Count-1 do begin
        If Artikel.Parts[Part].MIMEInfo.Typ = ctPlainText then begin
           With Artikel.Parts[Part].Body do begin
              While Count>0 do begin
                 s := Strings[0];
                 If ((Opt.AllowXHeader and (Pos(XHeaderbegin, s)=1))
                    or (Opt.AllowAnyHeader and (Copy(s,1,1)='@')))
                 then begin
                    { Eigene Headerzeilen }
                    If s[1]='@' then s2 := Copy(s,2,Length(s)-1) else s2 := s;
                    If Split_Headerzeile (s2, AktHeader, AktInhalt) then begin
                       s2 := AktHeader + ': ' + AktInhalt;
                       slBodyHeader.Add (s2);
                       Delete (0)
                    end else break
                 end else break
              end;
              While (Count > 1) and (Trim(Strings[0])='') do Delete(0)
           end
        end
     end
  end;

begin // Check_Headeranalyse;
   Check_Header;
   If Opt.CheckMIMEHeaders then Check_MIMEHeader;
   Check_Bodyheader
end;

Procedure TKNSkript.ConvertHeaderTo8Bit;
Var ConvertHeaders, s, s2: String; i: Integer;
begin
   If Artikel.Header.Position (Extraheader_ConvertHeader) >= 0 then exit;
   ConvertHeaders := '';
   With Artikel do begin
      For i:=Header.Count-1 downto 0 do begin
         s := Header[i];
         s2 := DecodeISO (HeaderCharsets, s);
         If s <> s2 then begin
            Header[i] := s2;
            If ConvertHeaders > '' then ConvertHeaders := ConvertHeaders + ', ';
            ConvertHeaders := ConvertHeaders + Header.Name[i]
         end
      end
   end;
   If ConvertHeaders > '' then Artikel.Header.Add (Extraheader_ConvertHeader + ConvertHeaders)
end;

Procedure TKNSkript.SortHeader (Const Headerliste: String);
Var s, s2: String; i, p: Integer; b: boolean;
begin
   s := Headerliste;
   With TStringlist.Create do try
      Repeat
         s2 := GetFirstElementOfKommaListe (s, b);
         If s2>'' then Repeat
            p := Artikel.Header.Position (s2);
            If p >= 0 then begin
               Add (Artikel.Header[p]);
               Artikel.Header.Delete(p)
            end
         Until p < 0
      Until Not b;
      For i := Count-1 downto 0 do Artikel.Header.Insert(0, Strings[i])
   finally free end
end;

Procedure TKNSkript.Check_Empfaengerliste (Const Always: boolean);

   Procedure ExtrahiereAdressen (Const Adr: String; sl: TStringlist);
   Var i, p: Integer; s, s2, s3, s4, AktAdr: String;
   begin
      s := Adr;
      { Alles zwischen Anfhrungsstrichen eleminieren }
      Repeat
         p := pos('"', s);
         If p > 0 then begin
            For i:=p+1 to Length(s) do If s[i]='"' then begin
               s := Copy(s, 1, p-1) + Copy(s, i+1, Length(s)-i);
               break
            end
         end
      Until p = 0;
      { Mailadressen extrahieren }
      While s > '' do begin
         p := pos(',', s);
         If p>0 then begin s2 := Copy(s,1,p-1); s := Copy(s,p+1,Length(s)-p) end
                else begin s2 := s; s := '' end;
         ExtractMailParts (s2, s3, s4, AktAdr);
         If Pos('@', AktAdr)>0 then sl.Add ('<'+Trim(AktAdr)+'>')
      end
   end;

Var Neuaufbau: boolean; i, p1, p2: Integer; s: String; sl1, sl2: TStringlist;
begin With Artikel do begin
   p1 := Header.Position (HamsterFrom);
   p2 := Header.Position (HamsterTo);
   If Always or ((p1 >= 0) and (p2 >= 0)) then begin
      If p1 < 0 then p1 := 0;
      If p2 < 0 then p2 := 0;
      sl1 := TStringlist.Create;
      sl2 := TStringlist.Create;
      try
         With sl1 do For i := p2 to Header.Count-1 do begin
            s := Header[i];
            If s = '' then break;
            If LowerCase(Copy(s, 1, Length(HamsterTo))) = LowerCase(HamsterTo)
               then Add (Copy(s, Length(HamsterTo)+3, Length(s)))
         end;
         ExtrahiereAdressen(Header.Inhalt('To', hiRaw), sl2);
         ExtrahiereAdressen(Header.Inhalt('CC', hiRaw), sl2);
         ExtrahiereAdressen(Header.Inhalt('BCC', hiRaw), sl2);
         { Liste passend? Gleiche eleminieren ... }
         Neuaufbau := false;
         For i := sl2.Count-1 downto 0 do begin
            If sl1.IndexOf (sl2[i]) >= 0 then begin
               sl1.Delete(sl1.IndexOf (sl2[i]));
            end else Neuaufbau := true
         end;
         Neuaufbau := Neuaufbau or (sl1.Count > 0);
         { ggf. neu erstellen }
         If NeuAufbau then begin
            Repeat
               p2 := Header.Position (HamsterTo);
               If p2 >= 0 then Header.Delete(p2)
            Until p2 < 0;
            With sl1 do For i:=Count-1 downto 0 do
               Header.Insert (p1+1, HamsterTo + ': ' + Strings[i]);
            With sl2 do For i:=Count-1 downto 0 do
               Header.Insert (p1+1, HamsterTo + ': ' + Strings[i])
         end;
         i := Header.IndexOf('BCC');
         If i >= 0 then Header.Delete(i)
      finally sl1.free; sl2.free end
   end
end end;

// ----------------------------------------------------------------------------------

Function TKNSkript.InterpreteWildCards (Const s: String): String;
Var p, q: Integer; flAnf, gef: boolean; s2, H, v: String; c: Char; W: String;
Const KlAuf = '('; KlZu = ')'; Anf = '"''';
begin
   s2 := s; Result := '';
   Repeat
      p := pos('%',s2); q := p; W := '';
      flAnf := false; gef := false;
      { Endekennzeichen suchen, Klammer und Stringausdrcke dabei berspringen... }
      If (p>0) and (Length(s2)>p) then Repeat
         Inc(q); c := s2[q];
         If flAnf then begin
            If (W > '') and (c = W[Length(W)]) then begin
               W := Copy(W, 1, Length(W)-1); flAnf := false
            end
         end else begin
            If Pos(c, Anf)>0 then begin W:=W+C; flAnf:=true end
            {else If Pos(c, KlAuf)>0 then W:=W+KlZu[Pos(c,KlAuf)]}
            else If c = KlAuf then W:=W + KlZu
            else If (Pos(c, KlZu)>0) and (W>'') and (c=W[Length(W)]) then W := Copy(W, 1, Length(W)-1)
         end;
         gef := (c='%') and (Not flAnf) and (W='')
      Until gef or (q = Length(s2));
      { Gefunden? }
      If (p>0) and gef then begin
         If p>1 then Result := Result + Copy(s2, 1, p-1);
         If q = p + 1 then begin
            Result := Result + '%'; Inc(q)
         end else begin
            H :=Copy(s2, p+1, q-p-1);
            If Vars.Exists(H) then Result := Result + Vars[H].asString
            else If GetString(H, v) then Result := Result + v
            else Fehler('"%'+H+'%" ist weder ein gltiger Stringbefehl noch eine existente Variable, '
                       +'sollte der entsprechende Header gemeint sein, dann bitte "%Header('+H+')%" verwenden.', s);
         end;
         s2 := Copy(s2, q+1, Length(s2)-q)
      end else begin
         Result := Result + s2; s2 := ''
      end
   Until s2 = ''
end;

Function TKNSkript.Tested (Const s: String; Const TestWildCards: boolean): String;
begin
   Result := s;
   If s > '' then begin
      If TestWildCards then Result := InterpreteWildCards(Result);
      Only7BitTested := false
   end
end;

Procedure TKNSkript.BlockAnhaengen (slAdd: TStrings; Const Rest: String; Const RawMode, Clear: boolean);
Var Indent, j: Integer; s, s2, Inhalt: String; sl: TStringlist;
begin
   sl := TStringlist.Create;
   try
      If Clear then Inhalt := ''
               else Inhalt := slAdd.text;
      { Einzeiler }
      If Trim(Rest) > '' then begin
         { Aus Datei }
         s := Rest;
         If SucheUndKuerze('from', s) then begin
            If GetString(s, s2) then begin
               s2 := ErgaenzeDateiname(s2);
               If FileExists(s2) then begin
                  LoadTextFile ( s2, sl );
                  For j := 0 to sl.Count-1 do Inhalt := Inhalt + Tested(sl[j], Not RawMode) + #13#10
               end else Fehler('Datei "'+s2+'" konnte nicht gefunden werden!', s)
            end else Fehler ('Nach "from" wird noch ein Dateiname erwartet.', s)
         { Direktzuweisung }
         end else If SucheUndKuerze(':', s) or SucheUndKuerze('=', s) or true then begin
            if GetString(s, s2) then begin
               Inhalt := Inhalt + Tested(s2, false) + #13#10;
               if Trim(s) > ''
                  then Fehler ('Der Text nach dem Stringausdruck kann nicht mehr sinnvoll interpretiert werden: "'+s+'"', s)
            end else begin
               Fehler ('Unzulssiger Stringausdruck: "'+s+'" ist keine String-Konstante, keine String-Funktion und keine Variable!', s)
               //Inhalt := Inhalt + Tested(s, Not RawMode) + #13#10
            end
         end
      { Multi-Zeiler }
      end else begin
         Indent := -1;
         Repeat
            If Zeile >= Count then break;
            Zeile := Zeile + 1;
            { RawMode: Keine "%"-Auswertung, dafr wird Einrckung beibehalten }
            s := Zeilen[Zeile-1].Inhalt;
            If RawMode then begin
               If Indent < 0 then begin
                  Indent := 0;
                  While Copy(s, 1, 1) = ' ' do begin
                     Inc(Indent); s := Copy(s, 2, Length(s)-1)
                  end
               end else
               For j:=1 to Indent do If Copy(s, 1, 1) = ' ' then s := Copy(s, 2, Length(s)-1)
            end else s := Trim(s);
            { Durch? }
            If LowerCase(Trim('-'+s)) = '-end' then
               break
            else begin
               Inhalt := Inhalt + Tested(s, Not RawMode) + #13#10;
            end
         Until false
      end;
      slAdd.text := Inhalt
   finally
      sl.free
   end
end;

Function TKNSkript.AktIntro: TStringList;
begin
   If Not AktIntroExists then Artikel.Part.Extras['Intro'] := TStringList.Create;
   Result := Artikel.Part.Extras['Intro'] as TStringlist
end;
Function TKNSkript.AktIntroExists: Boolean;
begin
   Result := Assigned(Artikel.Part.Extras['Intro'])
end;

Function TKNSkript.AktLines: TStringList;
begin
   If Not AktIntroExists then Artikel.Part.Extras['Lines'] := TStringList.Create;
   Result := Artikel.Part.Extras['Lines'] as TStringlist
end;
Function TKNSkript.AktLinesExists: Boolean;
begin
   Result := Assigned(Artikel.Part.Extras['Lines'])
end;

end.
