unit Korrektu;

{
Type:news-test Filename:H:\Hamster\Out\News\1634.mtg
type:news-test filename:h:\hamster\out\news\0vcard.mtg
}

interface

Uses Windows, Messages, SysUtils, Classes, Settings, ShellApi, uKNSkr, uKNTools,
      uCopyIf,
     {$IFNDEF NOGUI} Dialogs, {$ENDIF} IniFiles {, FileCtrl};

{$IFDEF CopyIf}
Procedure CheckPosting (Posting: TStrings; AktOpt: TEinstellungen);
Procedure Stop;
{$ELSE}
Procedure NewsKorrektur;
{$ENDIF}

implementation

Uses  UPerlRe, uArtikel, uGetStr, uGetNum, uHTML2Te, uHeader, uISO, uCSMap, uMIMEInf
      {$IFNDEF NOGUI}, DError {$ENDIF}
      {$IFDEF CopyIf}, DShow, uHamster {$ENDIF};

Const CRLF = ^M^J;

      HeaderDate = 'Date: ';
      HeaderQPKodierung = 'content-transfer-encoding: quoted-printable';
      

      kTyp = 'Type:';
      kFilename = 'Filename:';

      {$IFNDEF CopyIf}
      {$ENDIF}

{ --------------------------------------------------------------- }
{$IFDEF NOGUI}

Type
  TDlgError = Class
  public
    Skript_Dateiname,
    Fehlerhinweis,
    Zeileninhalt: String;
    ZeilenNr: Integer;
    AktRetry: TRetry;
    Constructor Create (p: Pointer);
    Procedure ShowModal;
  end;

Constructor TDlgError.Create (p: Pointer);
begin
end;

Procedure TDlgError.ShowModal;
Var s: String;
begin
   s := '';
   If Zeileninhalt > '' then begin
      If MessageBox (0, PChar('Fehler in "'+Skript_Dateiname+'" in Zeile '+IntToStr(ZeilenNr)+': '+ Fehlerhinweis+#13#10#13#10
                           +'Die fehlerhafte Zeile lautet:'+#13#10#13#10+Zeileninhalt+#13#10#13#10
                           +'Korrnews wird daher vorzeitig beendet - Skript bearbeiten?'),
                       NIL, MB_YESNO + MB_ICONERROR ) = IDYES
      then begin
         ShellExecute(GetDesktopWindow, 'open', PChar('Notepad.exe'), PChar(Skript_Dateiname), NIL, SW_SHOW)
      end;
      s := 'Fehler in "'+Skript_Dateiname+'" in Zeile '+IntToStr(ZeilenNr)+': '+ Fehlerhinweis+#13#10#13#10
                     +'Die fehlerhafte Zeile lautet:'+#13#10#13#10+Zeileninhalt+#13#10#13#10
                      +'Korrnews wird daher vorzeitig beendet - Skript bearbeiten?'
   end else begin
      MessageBox (0, PChar('Folgender Fehler ist aufgetreten: ' + Fehlerhinweis),
                     NIL, MB_OK + MB_ICONERROR )
   end;
   AktRetry := rEndProgram
end;

{$ENDIF}
{ --------------------------------------------------------------- }


Procedure assert(Const s: String);
begin
   If MessageBox (0, PChar(s), PChar('Assert'), MB_OKCANCEL) = IDCANCEL then Halt
end;

{ Datum / Zeit dank Haible }

function GetCurrentTimeZoneBiasHrs : LongInt;
const TIME_ZONE_ID_UNKNOWN  = 0;
      TIME_ZONE_ID_STANDARD = 1;
      TIME_ZONE_ID_DAYLIGHT = 2;
var  TZI      : TTimeZoneInformation;
     TZResult : Integer;
begin
     TZResult := GetTimeZoneInformation(TZI);

     case TZResult of
        TIME_ZONE_ID_UNKNOWN : Result:=-(TZI.Bias                 ) div 60;
        TIME_ZONE_ID_STANDARD: Result:=-(TZI.Bias+TZI.StandardBias) div 60;
        TIME_ZONE_ID_DAYLIGHT: Result:=-(TZI.Bias+TZI.DaylightBias) div 60;
        else                   Result:=0;
     end;
end;

function NowGMT : TDateTime;
begin
   Result := Now - GetCurrentTimeZoneBiasHrs / 24.0;
end;

function DT2NNTPDate( DT: TDateTime; Const GMT: boolean) : String;
const DAYNAMES   = 'SunMonTueWedThuFriSat';
      MONTHNAMES = 'JanFebMarAprMayJunJulAugSepOctNovDec';
var  sDT         : String;
     DOW, MOY, St: Integer;
begin
     sDT := FormatDateTime( 'dd"."mm"."yyyy hh":"nn":"ss', DT );
     DOW := DayOfWeek( DT );  // 1=Sun, ..., 7=Sat
     MOY := strtoint( copy( sDT, 4, 2 ) );

     // Date: Fri, 27 Mar 1998 12:12:50 +1300
     Result := copy( DAYNAMES, DOW*3-2, 3 ) + ',' + ' '
             + copy( sDT, 1, 2 ) + ' '
             + copy( MONTHNAMES, MOY*3-2, 3 ) + ' '
             + copy( sDT, 7, 4 ) + ' '
             + copy( sDT, 12, 8 ) + ' ';

     St := GetCurrentTimeZoneBiasHrs;
     If GMT or (St=0) then
        Result := Result + 'GMT'
     else begin
        If St < 0 then Result := Result + '-'
                  else Result := Result + '+';
        St := Abs(St);
        Result := Result + Chr( Ord('0')+(St div 10) ) + Chr( Ord('0')+(St Mod 10) ) + '00'
     end
end;


{$IFNDEF CopyIf}
{$ENDIF}

{$IFNDEF CopyIf}
{$ENDIF}

{$IFDEF CopyIf}
{$ELSE}

{$ENDIF}

{$IFDEF CopyIf}
Procedure DefCounter (Const Bez: String; Const Sep: Boolean);
Var p: Integer;
begin
   With Opt.lCounter do begin
      If Sep then begin
         If (Count > 0) and (Strings[Count-1]>'') then Add ('')
      end else begin
         p := IndexOf(Bez);
         If p < 0 then Add(Bez)
      end
   end
end;

Procedure IncCounter (Const Bez, SubBez: String);
Var p, p2, i: Integer;
Const Einschub = ' - ';
begin
   With Opt.lCounter do begin
      p := IndexOf(Bez);
      If p<0 then p := Add(Bez);
      Objects[p] := Pointer(LongInt(Objects[p])+1);
      If SubBez > '' then begin
         p2 := 0;
         For i:=p+1 to Count-1 do begin
            if Copy(Strings[i], 1, Length(Einschub))<>Einschub
               then begin p := i-1; break end
               else If Strings[i] = Einschub+SubBez then p2 := i
         end;
         If p2 = 0 then begin p2 := p+1; Insert (p2, Einschub+SubBez) end;
         Objects[p2] := Pointer(LongInt(Objects[p2])+1)
      end
   end
end;
{$ENDIF}

{ --------------------------------------------------------------------- }

{$IFDEF CopyIf}
Var TempPosting: String;

Procedure Artikel_vollenden;
begin
   TempPosting := Artikel.Body.text;
   If slIntro.Count>0 then Check_SetIntroduction(slIntro);
   Posting.text := Artikel.Gesamttext // Zeilenzahl!
end;

Procedure Artikel_weiter_bearbeiten;
begin
   Artikel.Body.Text := TempPosting
end;
{$ENDIF}

{ Primrfunktionen fr Zeileninterpretation... }

{ --------------------------------------------------------------------- }

{ --------------------------------------------------------------------- }

{$IFDEF CopyIf}
{$ELSE}

{$ENDIF}

{ --------------------------------------------------------------------- }

{$IFDEF CopyIf}
{$ELSE}
{$ENDIF}

{ --------------------------------------------------------------------- }

{$IFDEF CopyIf}
{$ELSE}
{$ENDIF}

{ --------------------------------------------------------------------- }
{$IFDEF CopyIf}
{$ELSE}
{$ENDIF}

{ --------------------------------------------------------------------- }

{$IFNDEF CopyIf}
{$ENDIF}

{ ====================================================================== }

Function Check (Const Datei: String; Optionen: TKNEinstellungen; Artikel: TArtikel): boolean;
Var iPart, j: Integer; s: String; K: TKodierung;
    Skript: TKNSkript;
begin

   { Vorbereitungen }
   Skript := TKNSkript.Create(Datei, Optionen, Artikel);

   try
      Skript.Reload;
      Skript.Clear;

      {$IFNDEF CopyIf}
      { 1. Durchgang => Subjectkorrektur & manuelle Headereintrge }
      Skript.Check_Headeranalyse;
      If Optionen.SortHeader > '' then Skript.SortHeader(Optionen.SortHeader);
      {$ENDIF}

      For j:=0 to Optionen.LDelXHeader.Count-1 do begin
         s := Trim(Optionen.LDelXHeader[j]);
         If Pos(':', s) = 0 then s := s + ':';
         Skript.InterpreteCommand (s)
      end;

      { **** Skript ****** }
      Skript.Check_ExtraHeader_einsetzen;

      {$IFNDEF CopyIf}
      { Date-Header setzen }
      j := Artikel.Header.Position (HeaderDate);
      If ((Optionen.SetDateHeader = 1) and (j=-1)) or (Optionen.SetDateHeader = 2) then begin
         If Optionen.DateHeaderTypeGMT
            then s := DT2NNTPDate(NowGMT, true)
            else s := DT2NNTPDate(Now, false);
         Artikel.Header.Change (HeaderDate, s)
      end;

      { Gesamtdurchgang: Body-Check }
      With Artikel do For iPart := 1 to Parts.Count do begin
         ActivePart := iPart;
         With Part do begin

            // Text => HTML
            If Optionen.HTML2Text and (MIMEInfo.Typ = ctHTML) then Skript.Check_ConvertHTML2Text;

            // Save Attachment
            If Optionen.SaveAttachments and SaveAtt[MIMEInfo.Typ] and (MIMEInfo.Filename>'')
               then Skript.SaveAttachment(Optionen.SaveAttachmentsDir, MIMEInfo.Filename, Optionen.ActionIfAttExists);

            // Sonstige Korrekturen bei Plain-Text
            If MIMEInfo.Typ = ctPlainText then begin

               Skript.slFN.Clear;

               { ggf. Introzeilen setzen }
               Skript.Check_SetIntroduction;

               { Sonderfunktionen durchfhren }
               If Optionen.ConvertFootnotes then Skript.Check_Fussnoten;
               If Optionen.ConvertReformats then Skript.Check_Reformat;
               If Optionen.ConvertOneliners then Skript.Check_Oneliner;

               Skript.Check_BodyKorrekturen;

               { Sinnlose Leerzeilen am Ende lschen }
               If Optionen.DeleteEmptyLines then Skript.DeleteEmptyLines;

               { Leerzeichen am Zeilenende lschen }
               If Optionen.RightTrim then Skript.DeleteBlanksAtEndOfLines;

               { ggf. Text / Funoten anfgen }
               If FN.Position = fnpVorLines then If Skript.slFN.Count>0 then Skript.Check_AppendFussnoten;
               If Skript.slAppend.Count>0 then Skript.Check_AppendText;
               If FN.Position = fnpNachLines then If Skript.slFN.Count>0 then Skript.Check_AppendFussnoten;

               { Sig anfgen }
               If (Optionen.SigFile>'') and Not Artikel.Part.HasSig then begin
                  s := 'Set Sig from "'+Optionen.SigFile+'"';
                  try
                     Skript.InterpreteCommand (s)
                  except
                     Skript.Fehler ('Achtung! Gewhltes Sigfile "'+Optionen.SigFile+'" existiert nicht!', '')
                  end
               end;
               if Optionen.ConvertBoxQuotes then For j:=1 to 9 do Skript.ConvertBoxQuotes(j);
               If Optionen.CheckOEZitate then Skript.Check_OE_Zitate;
               If Optionen.MinBodyCharset then Skript.ConvertMinBodyCharset;
               If Optionen.BlankbeforeSig and HasSig and (Sig.changed or Optionen.DeleteEmptyLines) then begin
                  With Body do If (Count = 0) or (Trim(Body[Count-1])>'') then Add ('')
               end;
            end;

            // Encoding korrigieren
            //If (MIMEInfo.Typ = ctPlainText) and Opt.MinBodyCharset then ConvertMinBodyCharset;
            If KodierungVariabel[MIMEInfo.Typ] then begin
               Case Optionen.DefaultEncoding of
                  0: K := k8Bit;
                  1: K := kQP;
                  2: K := kBase64;
                  3: K := k7Bit
                  else K := kUnbekannt
               end;
               If (K <> kUnbekannt) and (K <> MIMEInfo.Kodierung) then begin
                  Case MIMEInfo.Kodierung of
                     kQP: If Optionen.ConvertQP then ChangeEncoding (K);
                     k8Bit: If Optionen.Convert8Bit then ChangeEncoding (K);
                     kBase64: If Optionen.ConvertBase64 then ChangeEncoding (K)
                  end
               end
            end;

         end
      end;

      { Bodyheader einfgen }
      Skript.InsertBodyHeader;

      { Hamster-Empfngerliste berprfen }
      If Optionen.RecreateRCPT_To then Skript.Check_Empfaengerliste (Optionen.RecreateRCPT_To_Always);
      If Optionen.HamsterHeaderFirst then Skript.SortHeader ('!MAIL FROM, !RCPT TO');

      {$ENDIF}

      Result := Skript.TestChanged
   finally
      Skript.free
   end
end;

Procedure NewsKorrektur;
Var r: TSearchRec; s: String; AufrufNr, Aufrufe: Integer;
    Artikel: TArtikel; Opt: TKNEinstellungen;

   Procedure Save (Const Dateiname: String);
   Var s: String; Modus: Integer; Cut, p, i, l: Integer;
   begin
      If FileExists(Dateiname) then DeleteFile(Dateiname);
      Modus := fmCreate;
      With TFileStream.Create (Dateiname, Modus) do try
         Artikel.bSetLines := Opt.SetLines;
         s := Artikel.Gesamttext;
         Cut := 0;
         If Length(s)>4 then begin
            If (Copy(s, Length(s)-3, 2) <> #13#10)
                and
               (Copy(s, Length(s)-1, 2) = #13#10)
            then
               Cut := 2
         end;
         If Artikel.IsUnixFile then begin
            p := 1; l := Length(s);
            For i := 1 to l+1 do begin
               If (i>l) or (s[i]=#13) then begin
                  WriteBuffer(s[p], i-p);
                  p := i+1
               end
            end
         end else begin
            If Cut>0 then SetLength(s, Length(s)-Cut);
            WriteBuffer(s[1], Length(s))
         end
      finally
         free
      end
   end;

   Procedure Bearbeite (Const fn: String);
   Var Pfad, Dateiname, s: String;
   begin
      Pfad := ExtractFilePath(fn);
      Artikel.LoadFromFile (fn);
      Dateiname := ExtractFilename(fn); // #############
      If Check(Dateiname, Opt, Artikel) or (Opt.ConvertToExt>'') then begin
         s := ChangeFileExt(fn,'.bak');
         If FileExists(s) then DeleteFile(s);
         If Opt.ConvertToExt > '' then
            Save (ChangeFileExt(fn, '.'+Opt.ConvertToExt))
         else begin
            If Opt.MakeBAK then RenameFile (fn, s);
            Save (fn)
         end
      end
   end;

   {$IFNDEF NOGUI}
   Procedure ReadSec (Ini: TIniFile; Const Ab: String; sl: TStrings);
   Var i: Integer;
   begin
      sl.Clear;
      For i := 1 to Ini.ReadInteger (Ab, '*', 0) do sl.Add (Copy(Ini.ReadString(Ab, Inttostr(i), ''), 2, 1000))
   end;
   {$ENDIF}

Var Typ, Filename: String;
   {$IFNDEF NOGUI}
   Datei: Text;
   i, p, Z, ZNr, Zeile2: Integer;
   Retry: TRetry;
   mGesamt, mVars, mSkript, mText: TStringlist;
   Skript_Dateiname, fDateiname, Zeileninhalt, Fehlerhinweis: String;

   Function GetLine: String;
   begin
      Readln (Datei, Result);
      Repeat
        p := pos (#0#0, Result);
        If p > 0 then begin
           Result[p] := #13; Result[p+1] := #10
        end
      Until p = 0
   end;
   {$ENDIF}

begin
   If LowerCase(ParamStr(1))='copyif' then begin
      RunCopyIfMode;
      Exit
   end;
   { Einstellungen laden }
   Opt := TKNEinstellungen.Create;
   try
      Aufrufe := ParamCount;
      Typ := ''; Filename := '';
      If (Aufrufe = 2)
         and (Copy(LowerCase(ParamStr(1)), 1, Length(kTyp)) = LowerCase(kTyp))
         and (Copy(LowerCase(ParamStr(2)), 1, Length(kFilename)) = LowerCase(kFilename))
      then begin
         Typ := Copy(ParamStr(1), Length(kTyp)+1, Length(ParamStr(1)));
         Filename := Copy(ParamStr(2), Length(kFilename)+1, Length(ParamStr(2)));
         Aufrufe := 1
      end;
      {$IFNDEF NOGUI}
      If (Aufrufe = 2) and (ParamStr(1)='#ShowError#') then begin
         mGesamt := TStringlist.Create;
         mVars   := TStringlist.Create;
         mSkript := TStringlist.Create;
         mText   := TStringlist.Create;
         try
            AssignFile(Datei, ParamStr(2));
            Reset(Datei);
            Skript_Dateiname := GetLine;
            fDateiname := GetLine;
            Readln(Datei, ZNr);
            Zeileninhalt := GetLine;
            Fehlerhinweis := GetLine;
            try
               try
                  Readln(Datei, p);
                  Readln(Datei, Zeile2);
                  With mGesamt do begin
                     Readln(Datei, z);
                     For i := 1 to z do Add(GetLine)
                  end;
                  With mVars do begin
                     Readln(Datei, z);
                     For i := 1 to z do Add(GetLine)
                  end;
                  With mSkript do begin
                     Readln(Datei, z);
                     For i := 1 to z do Add(GetLine)
                  end;
                  With mText do begin
                     Readln(Datei, z);
                     For i := 1 to z do Add(GetLine)
                  end
               finally
                  CloseFile(Datei)
               end;
               Fehlerdialog ( Skript_Dateiname, fDateiname, ZNr, Zeileninhalt, Fehlerhinweis,
                              mGesamt, mVars, mSkript, 0, mText, Retry, p );
            except
               ShowMessage ('Fehler beim Auslesen der von Only_KN.exe bergebenene Fehlerdaten, Fehlermeldung selber war: "'+Fehlerhinweis+'"');
               Retry := rEndProgram;
               Zeile2 := 0
            end;

            Rewrite(Datei);
            Writeln(Datei, Zeile2);
            Writeln(Datei, Ord(Retry));
            CloseFile(Datei);

         finally
            mGesamt.free; mVars.free; mSkript.free; mText.free
         end;
         HALT
      end;
      If (Aufrufe = 2) and (ParamStr(1)='#InputBox#') then begin
         With TIniFile.Create(ParamStr(2)) do try
            WriteString ('InputBox', 'Default',
               InputBox ( ReadString('InputBox', 'Title', ''),
                          ReadString('InputBox', 'Prompt', ''),
                          ReadString('InputBox', 'Default', '') ))
         finally free end;
         HALT
      end;
      {$ENDIF}
      For AufrufNr := 1 to Aufrufe do begin
         If Typ = '' then s := Paramstr(AufrufNr) else s := Typ;
         Opt.Dateiname := ExtractFilePath(ParamStr(0))+'Korrnews.ini';
         Opt.Abschnitt := s;

         If Not Opt.AbschnittExists then begin
            Case Messagebox (0, PChar('Der Abschnitt "'+s+'", welcher ausgefhrt werden soll, '
                            + 'existiert in der aktuellen korrnews.ini noch nicht. Soll er jetzt '
                            + 'automatisch angelegt werden?'
                            ),
                     PChar('Unbekannter Abschnitt'),
                     MB_ICONQUESTION + MB_YESNOCANCEL)
            of
               IDYES: ;
               IDNO: Continue;
               IDCANCEL: Exit;
            end
         end;
         Opt.ReadSettings (false);

         Artikel := TArtikel.Create (Extra.InternalCharset, Opt.HeaderCharsets, Opt.BodyCharsets);
         try
            With Artikel do begin
               ConvertToSigTrenner := Opt.ConvertToSig;
               SafeReg1 := Opt.SafeReg1;
               SafeReg2 := Opt.SafeReg2;
            end;
            If Typ > '' then begin
               Bearbeite (Filename)
            end else begin
               If Not DirectoryExists(Opt.WorkPath)
                  then raise Exception.Create('Das Arbeitsverzeichnis "'+Opt.Workpath+'" existiert nicht!');
               If Not DirectoryExists(Opt.FilePath)
                  then raise Exception.Create('Das Dateiverzeichnis "'+Opt.Filepath+'" existiert nicht!');
               If Findfirst(Opt.WorkPath + '*.'+Opt.TestExt, faArchive, r)=0 then begin
                  Repeat
                     Bearbeite (Opt.WorkPath + r.Name)
                  Until FindNext(r)<>0;
                  FindClose(r)
               end
            end
         finally
            Artikel.free
         end
      end
   finally
      Opt.free
   end
end;

end.

{
stop
quit
Next
gosub ... Var ..., ...
return
break
cont[inue]
goto ...
Set [raw] Intro[duction]
Set [raw] Sig[nature]
Set [raw] Line[s]
Set macro
Set h[ader]
Set Bodyline
Set Opt[ion]
Set %...%
Append [raw] Intro[duction]
Append [raw] H[eader]
Append [raw] %...%
Append [raw] Line[s]
Append [raw] Sig[nature]
Insert BodyLine
Delete header
Delete Intro[duction]
Delete Bodylines from ... to ...
Delete Bodyline xx
Delete between [last|first] ..., ..., bool, ...
Delete blanks at end of lines
Delete empty Lines at end
Delete part because ...
Delete Sig[nature]
Delete Bodyheader
Delete Line[s]
Do Select Part xx
Do Show Info ..., ...
Do Sort Header ...
Do Repair OEQuotings
Do Write IniStr ..., ..., ..., ...
Do Write Textfile ..., ...
Do Open ... [, ...]
Do Print ... [, ...]
Do (Run | Exec) [and wait] ... [, ...]
Do Replace all | first | last ... with ... [in ( Body | Sig | Lines | Intro | Header | Header2 | %...% ] [ from xx to xx ]
Do Convert QPHeader
Do Convert QPBody
Do Convert Header to 8Bit
Do Convert Encoding to [ qp | 8bit | base64 | 7bit ]
Do Convert HTML to Text
Do Convert OEBeginBug
Do Convert OEKillFalseReBug
Do Convert Boxquotes xx
Do Optimize MIMEHeader
Do Optimize BodyCharset
Do Optimize Bodycharsets
Do Save Part ..., ..., bool
CopyIF: Do Export as ...
CopyIf: Do Show
CopyIf: Do Copy to group
CopyIf: Do Def[ine] Counter
CopyIf: Do Inc Counter
CopyIf: Do Save Changes
CopyIf: Do Touch ...
}
