unit uTransla;

interface

Uses TypInfo, Forms, Dialogs, Classes, SysUtils;

Procedure Translate (F: TForm; Const Abschnitt: String);

implementation

Procedure Translate (F: TForm; Const Abschnitt: String);

   Procedure Filter(sl: TStrings; Const Abschnitt: String);
   Var p, i: Integer; s: String;
   begin
      p := 0;
      s := Abschnitt+'.';
      For i := 0 to sl.Count-1 do begin
         If Copy(sl[p], 1, Length(s)) = s
            then Inc(p)
            else sl.Delete(p) 
      end
   end;

   Function Search (sl: TStrings; Const key: String; Var Res: String): boolean;
   Var s: String; i, j: Integer;
   begin
      Result := false;
      s := Key+'=';
      For i := 0 to sl.Count-1 do begin
         If Copy(sl[i], 1, Length(s)) = s then begin
            Res := Copy(sl[i], Length(s)+1, Length(sl[i]));
            For j := 2 to Length(Res) do If Res[j] = 'm' then begin
               If Res[j-1]='^' then begin
                  Res[j-1] := #13; Res[j] := #10
               end
            end;
            sl.Delete (i);
            Result := true;
            Exit
         end
      end
   end;

Var c: TComponent; i: Integer; P: PPropInfo; sl: TStringlist; s: String;
begin
   s := ExtractFilePath(ParamStr(0))+'translate.txt';
   If Not FileExists(s) then exit;
   sl := TStringlist.Create;
   try
      sl.LoadFromFile ('translate.txt');
      Filter(sl, Abschnitt);
      If sl.Count = 0 then exit;
      For i := 0 to F.ComponentCount-1 do begin
         c := F.Components[i];
         p := GetPropInfo(C.ClassInfo, 'Caption');
         If Assigned(p) and Search(sl, Abschnitt+'.'+Lowercase(c.Name)+'.caption', s) then SetStrProp (C, p, s);
         p := GetPropInfo(C.ClassInfo, 'Hint');
         If Assigned(p) and Search(sl, Abschnitt+'.'+Lowercase(c.Name)+'.hint', s) then SetStrProp (C, p, s);
      end
   finally
      sl.free
   end
end;

Procedure ExportTranslation (F: TForm; Const Abschnitt: String);

   Function conv(Const s: String): String;
   Var i: Integer;
   begin
      Result := s;
      For i := 1 to Length(s) do Case s[i] of
         #13: Result[i] := '^';
         #10: Result[i] := 'm';
      end
   end;

Var c: TComponent; i: Integer; P: PPropInfo; sl: TStringlist; s: String;
begin
   exit;
   sl := TStringlist.Create;
   With F do try
      For i := 0 to ComponentCount-1 do begin
         c := Components[i];
         p := GetPropInfo(C.ClassInfo, 'Caption');
         If Assigned(p) then begin
            s := GetStrProp (C, p);
            If s > '' then sl.Add (Abschnitt+'.'+Lowercase(c.Name)+'.caption='+conv(s))
         end;
         p := GetPropInfo(C.ClassInfo, 'Hint');
         If Assigned(p) then begin
            s := GetStrProp (C, p);
            If s > '' then sl.Add (Abschnitt+'.'+Lowercase(c.Name)+'.hint='+conv(s))
         end;
      end;
      sl.SaveToFile ('translate.txt')
   finally
      sl.free
   end
end;

end.
