unit DFussnot;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Settings, ComCtrls;

Procedure ConfigFussnoten;

type
  TDlgCfgFN = class(TForm)
    butOk: TButton;
    butAbort: TButton;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    txtAnfang: TEdit;
    txtBreite: TEdit;
    txtTitel: TEdit;
    Label5: TLabel;
    chkUnterstr: TCheckBox;
    txtUnterstr: TEdit;
    Label6: TLabel;
    cbPosition: TComboBox;
    chkTitelLeerzeile: TCheckBox;
    Label7: TLabel;
    txtEnde: TEdit;
    txtCRLF: TEdit;
    Bevel1: TBevel;
    Label8: TLabel;
    Bevel2: TBevel;
    Label9: TLabel;
    procedure butOkClick(Sender: TObject);
    procedure txtTitelChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    msg: TStringlist;
  end;

implementation

{$R *.DFM}

Uses Korrektu, uTransla;

Procedure ConfigFussnoten;
begin
   With TDlgCfgFN.Create(nil) do try
      ReadFootNoteSettings;
      txtAnfang.text := FN.Anfang;
      txtEnde.text := FN.Ende;
      txtCRLF.text := FN.Zeilenwechsel;
      cbPosition.ItemIndex := Ord(FN.Position);
      txtTitel.text := FN.Titel;
      txtBreite.text := IntToStr(FN.Breite);
      chkUnterstr.checked := FN.TitelUnterstreichen;
      txtUnterstr.text := Copy(FN.UnterstreichenMit, 1, 1);
      chkTitelLeerzeile.checked := FN.TitelLeerzeile;
      If ShowModal = mrOK then begin
         FN.Anfang := txtAnfang.text;
         FN.Ende := txtEnde.text;
         FN.Zeilenwechsel := txtCRLF.text;
         FN.Position := TFNPos(cbPosition.ItemIndex);
         FN.Titel := txtTitel.text;
         FN.Breite := StrToInt('0'+txtBreite.text);
         If FN.Breite < 50 then FN.Breite := 72;
         FN.TitelUnterstreichen := chkUnterstr.checked;
         FN.UnterstreichenMit := (txtUnterstr.text+'=')[1];
         FN.TitelLeerzeile := chkTitelLeerzeile.checked;
         WriteFootNoteSettings
      end
   finally free end
end;

procedure TDlgCfgFN.butOkClick(Sender: TObject);
begin
   ModalResult := mrOk
end;

procedure TDlgCfgFN.txtTitelChange(Sender: TObject);
begin
   chkUnterstr.visible := Trim(txtTitel.text)>'';
   txtUnterstr.visible := Trim(txtTitel.text)>'';
   txtUnterstr.enabled := chkUnterstr.checked;
   chkTitelLeerzeile.visible := Trim(txtTitel.text)>''
end;

procedure TDlgCfgFN.FormCreate(Sender: TObject);
begin
   msg := TStringlist.Create;
   Translate (self, 'DlgFootnotes', Msg);
   cbPosition.Items.text := Tr(msg, 'PositionItems', 'oberhalb der "Lines"^munterhalb der "Lines"')
end;

procedure TDlgCfgFN.FormDestroy(Sender: TObject);
begin
   msg.free
end;

end.
