unit uISO;

interface

Uses uCSMap;

Function HexStr(Const x: Byte): String;

Function DecodeQP (Charsets: TCharsets; Const s, CS: String; Const isHeader: boolean;
                   Var ok: boolean): String;
function DecodeBase64 (Charsets: TCharsets; Const s, CS: String; Var ok: boolean): String;

Function Convert1252ToAscii (Const s: String): String;
Function ConvertText (Charsets: TCharsets; Const s, FromCS, ToCS: String; Var MissingChar: boolean): String;
{   If Not Assigned(CSs) then begin
      CSs := TCharsets.Create(Opt.InternalCharset,
                              Opt.BodyCharsets) }

Function EncodeQP (Const Zeilen, CS: String; Const CheckSoftBreak: boolean): String;
Function EncodeBase64(Const Zeilen, CS: String): String;

Function DecodeISO (Charsets: TCharsets; Const s: String): String;
Function EncodeISO (Charsets: TCharsets; Const H: String): String;

Const
  Adressfelder = ' from: reply-to: to: cc: bcc: sender: '; { lowercase! }
  MIMEStdGrenze = [' '];
  MIMELinkeGrenzeFrom = MIMEStdGrenze + ['"', '(', ','];
  MIMERechteGrenzeFrom = MIMEStdGrenze + ['"', ')', ','];
{  MaxISOHeaderLen = 76;
  HeaderCont = [^I, ' '];
  Headerzeichen = [#33..#128]; }

  ISOIntro = '=?'; ISODel = '?'; ISOExtro = '?=';
  HexZiffern = '0123456789ABCDEF';
  Base64Chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
  MaxISOHeaderLen = 76;
  CRLF = ^M^J;
  Ueb8Bit2ASCII: Array[#128..#255] of String[5] = (
//  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    'Euro','?',',', 'f', '"','...','#', '#', '^','o/oo','S','<', 'CE','?', '?', '?',
//  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '?', '''','''','"', '"', '*', '-', '-', '~', 'TM','s', '>', 'oe','?', '?', 'Y',
//  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '','i','C','Pfund','Whrg','Yen','|','Par.','"','(c)','?','<<','?','-','(R)','-',
//  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    'Gr.','+/-','^2','^3','''','?','?','*','?','^1','*','>>','1/4','1/2','3/4','?',
//  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    'A', 'A', 'A', 'A', 'Ae','A', 'AE','C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I',
//  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    'D', 'N', 'O', 'O', 'O', 'O', 'Oe','x', 'DS','U', 'U', 'U', 'Ue','Y', '?','ss',
//  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    'a', 'a', 'a', 'a', 'ae','a', 'ae','c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i',
//  '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''
    'd', 'n', 'o', 'o', 'o', 'o', 'oe','/', 'ds','u', 'u', 'u', 'ue','y', 't', 'y');

implementation

Uses Windows, Classes, Sysutils;

Type TModus = (mDefault, mISOStart, mISOCharset, mISOMode, mISOModeEnd, mISODecode, mISODecodeEnd);

Function CvHex(Const s: String): Byte;
Var p1, p2: Integer;
begin
   p1 := Pos(Upcase(s[1]), HexZiffern); p2 := Pos(UpCase(s[2]), HexZiffern);
   If (p1>0) and (p2>0) then Result := (p1-1) * 16 + (p2-1)
                        else Result := 0
end;

Function DecodeQP (Charsets: TCharsets; Const s, CS: String; Const isHeader: boolean;
     Var ok: boolean): String;
Var j, l, p: Integer; b: boolean;
begin
   SetLength(Result, Length(s)); p := 1;
   j:=1; l := Length(s);
   While j <= l do begin
      Case s[j] of
         '_': begin
                 If isHeader then Result[p] := ' ' else Result[p] := '_';
                 Inc(p)
              end;
         '=': If j+2<=l then begin
                 If (s[j+1] = #13) and (s[j+2] = #10) then
                    Inc(j, 2)
                 else If CvHex(s[j+1]+s[j+2]) > 0 then begin
                    Result[p] := Chr(CvHex(s[j+1]+s[j+2]));
                    Inc(p); Inc(j,2)
                 end else begin
                    Result[p] := s[j]; Inc(p)
                 end
              end else begin
                 Result[p] := s[j]; Inc(p)
              end;
         else begin Result[p] := s[j]; Inc(p) end
      end;
      Inc(j)
   end;
   SetLength(Result, p-1);
   If CS > '' then begin
      Result := ConvertText(Charsets, Result, CS, 'cp1252', b);
      ok := Not b
   end
end;

Function HexStr(Const x: Byte): String;
begin
   Result := HexZiffern[(x div 16)+1] + HexZiffern[(x mod 16)+1]
end;

Function EncodeQP (Const Zeilen, CS: String; Const CheckSoftBreak: boolean): String;
Var s: String; c, Last: Char; L, p, i, j: Integer; bCV, bSoftBreak, bCR: Boolean;
begin
   SetLength(Result, Length(Zeilen)*3);
   // EndCR := (Length(Zeilen) > 2) and (Copy(Zeilen, Length(Zeilen)-1, 2) = #13#10);
   p := 1; Last := #10; L := 0;
   For i := 1 to Length(Zeilen) do begin
      c := Zeilen[i];
      bCR := (c = #13) or (c = #10);
      If bCR then L := 0 else Inc(L);
      bCV := (c='=') or (c>Chr(127)) or ((c<' ') and (c<>#13) and (c<>#10));
      If (Not bCV) and (Last = #10) and (c='F') then bCV := true;
      If (Not bCV) and (c = ' ') and ((i = Length(Zeilen)) or (Zeilen[i+1]=#13)) then bCV := true;

      If CheckSoftBreak then begin
         If bCV
            then bSoftBreak := L+3 > MaxISOHeaderLen
            else bSoftBreak := L+1 > MaxISOHeaderLen;
         If bSoftbreak then begin
            L := 0;
            Result[p] := '='; Inc(p);
            Result[p] := #13; Inc(p);
            Result[p] := #10; Inc(p)
         end
      end;

      If bCV then begin
         s := '='+HexStr(Ord(c));
         For j := 1 to Length(s) do begin
            Result[p] := s[j]; Inc(p)
         end
      end else begin
         Result[p] := c; Inc(p)
      end;
      Last := c
   end;
   SetLength(Result, p-1)
end;

function DecodeBase64 (Charsets: TCharsets; Const s, CS: String; Var ok: boolean): String;
var  B: Cardinal; C: Char; z, I, J, p: Integer; s2: String;
     MissedChar: boolean;
begin
   SetLength(Result, Length(s));
   p := 1;
   z := 1;
   While z <= Length(s) do begin
      B:=0; J:=-1;
      repeat
        C := s[z]; Inc(z);
        case C of
          'A'..'Z' : I:=( 0-ord('A'))+Ord(C);
          'a'..'z' : I:=(26-Ord('a'))+ord(C);
          '0'..'9' : I:=(52-Ord('0'))+ord(C);
          '+'      : I:=62;
          '/'      : I:=63;
          else       I:=-1;
        end;
        if I>=0 then begin
          B:=(B shl 6) or Byte(I); inc(J);
        end;
      until (J=3) or (z > Length(s));
      If J > 0 then begin
         Case J of
            2: B := B shr 2;
            1: B := B shr 4;
         end;
         SetLength(s2, J);
         for I:=J downto 1 do begin
           s2[I]:=Chr(B); B:=B shr 8;
         end;
         For i := 1 to Length(s2) do begin
            Result[p] := s2[i]; Inc(p)
         end
      end
   end;
   SetLength(Result, p-1);
   If CS > '' then begin
      Result := ConvertText(Charsets, Result, CS, 'cp1252', MissedChar);
      ok := Not MissedChar
   end
end;

Function EncodeBase64(Const Zeilen, CS: String): String;
Var i, rp, p, zl: Integer; x, z1, z2, z3, z4: Byte;
begin
   i := 1; p := 0;
   SetLength(Result, ((Length(Zeilen) div (76 div 4))+1) * 78);
   rp := 1; ZL := 0;
   z1 := 0; z2 := 0; z3 := 0; z4 := 0;
   While i <= Length(Zeilen) do begin
      x := Ord(Zeilen[i]);
      Case p of
         0: begin z1 := (x and $FC) shr 2; z2 := (x and $03) shl 4 end;
         1: begin z2 := z2 + ((x and $F0) shr 4); z3 := (x and $0F) shl 2 end;
         2: begin z3 := z3 + ((x and $C0) shr 6); z4 := (x and $3F) end;
      end;

      If p = 2 then begin
         If rp+4 > Length(Result) then SetLength(Result, Length(Result)+100);
         Result[rp] := Base64Chars[z1+1]; Inc(rp);
         Result[rp] := Base64Chars[z2+1]; Inc(rp);
         Result[rp] := Base64Chars[z3+1]; Inc(rp);
         Result[rp] := Base64Chars[z4+1]; Inc(rp);
         Inc(ZL, 4);
         If ZL = 76 then begin
            If rp+2 > Length(Result) then SetLength(Result, Length(Result)+100);
            ZL := 0;
            Result[rp] := #13; Inc(rp);
            Result[rp] := #10; Inc(rp);
         end
      end;
      p := (p+1) mod 3;
      Inc(i)
   end;
   Case p of
      1: begin
            If rp+4 > Length(Result) then SetLength(Result, Length(Result)+100);
            Result[rp] := Base64Chars[z1+1]; Inc(rp);
            Result[rp] := Base64Chars[z2+1]; Inc(rp);
            Result[rp] := '='; Inc(rp);
            Result[rp] := '='; Inc(rp)
         end;
      2: begin
            If rp+4 > Length(Result) then SetLength(Result, Length(Result)+100);
            Result[rp] := Base64Chars[z1+1]; Inc(rp);
            Result[rp] := Base64Chars[z2+1]; Inc(rp);
            Result[rp] := Base64Chars[z3+1]; Inc(rp);
            Result[rp] := '='; Inc(rp)
         end;
   end;
   SetLength(Result, rp-1)
end;

Function Decode (Charsets: TCharsets; Const Inhalt, Charset: String;
        Const DecodeTyp: Char; Const isHeader: boolean;
        Var Ergebnis: String ): boolean;
begin
   Result := false;
   Ergebnis := '';
   Case DecodeTyp of
      'Q': Ergebnis := DecodeQP (Charsets, Inhalt, Charset, isHeader, Result);
      'B': Ergebnis := DecodeBase64 (Charsets, Inhalt, Charset, Result);
   end
end;

Function ConvertText (Charsets: TCharsets; Const s, FromCS, ToCS: String; Var MissingChar: boolean): String;
begin
   Result := Charsets.Unicode2X(Charsets.X2Unicode(s, FromCS), ToCS, MissingChar)
end;

Function Convert1252ToAscii (Const s: String): String;
Var p, i, j: Integer; c: Char; Ueb: String[5];
begin
   i := 2*Length(s);
   If i < 20 then i := 30;
   SetLength(Result, i);
   p := 1;
   For i := 1 to Length(s) do begin
      c := s[i];
      If c > #127 then begin
         Ueb := Ueb8Bit2ASCII[c];
         If p+Length(Ueb) >= Length(Result) then SetLength(Result, p+10);
         For j := 1 to Length(Ueb) do begin
            Result[p] := Ueb[j]; Inc(p)
         end
      end else begin
         If p >= Length(Result) then SetLength(Result, p+10);
         Result[p] := c; Inc(p)
      end;
   end;
   SetLength(Result, p-1)
end;

Function DecodeISO (Charsets: TCharsets; Const s: String): String;
Var M, i: Integer;
    Charset, Org, B, B2, B3, s2: String;
    c, c2, Codebase: Char;
    ok, Ignore, DecodeBuffer, AddBuffer, DelBuffer, Enter: boolean;
begin
   M := 0;
   Result := ''; B := ''; B2 := ''; B3 := ''; Codebase := ' ';
   For i := 1 to Length(s) do begin
      c := s[i];
      c2 := UpCase(c);
      DecodeBuffer := false; AddBuffer := false; DelBuffer := false;
      Enter := c IN [#13, #10];
      If M > 0 then begin
         Ignore := true;
         If Not Enter then B := B + C;
         // If Enter then AddBuffer := true
      end else begin
         Ignore := Enter
      end;
      If Not Enter then Case M of
         0: // Auerhalb jeder ISO-Kodierung
            If c = '=' then begin Inc(M); Ignore := true; B := c end; // ISO-Block?
         1: If c = '?' then Inc(m) // ISO-Block?
            else If c ='=' then Ignore := false // Falsches "=" vor Kodierung wird normal durchgelassen und der Modus kann bleiben
            else AddBuffer := true;
         2: If c2 IN['A'..'Z', '0'..'9'] then begin Charset := c; Inc(m) end // Charset sammeln
            else AddBuffer := true;
         3: If c2 IN['A'..'Z', '0'..'9', '-', '_'] then Charset := Charset+c
            else If c = '?' then Inc(M)
            else AddBuffer := true;
         4: If c2 IN['Q', 'B'] then begin CodeBase := c2; Inc(m) end
            else AddBuffer := true;
         5: If c = '?' then begin Inc(M); Org := '' end
            else AddBuffer := true;
         6: If c2 = '?' then Inc(m)
            else If c IN [Chr(128)..Chr(255)] then AddBuffer := true
            else Org := Org + c;
         7: If c2 = '=' then begin Inc(M); DecodeBuffer := true  end
            else AddBuffer := true;
         8: // Auerhalb jeder ISO-Kodierung
            If c = '=' then begin
               M := 1; B := c
            end
            else If Not (c IN[' ', ^I]) then begin
               Ignore := false;
               B := B3; B3 := ''; AddBuffer := true; M := 0
            end
            else B3 := B3 + c;
         //8: begin Ignore := false; c := '#' end
      end;
      If DecodeBuffer then begin
         ok := false;
         B3 := '';
         ok := CSInfos.CharsetIsKnown (Charset);
         If ok then begin
            Case CodeBase of
              'Q': s2 := DecodeQP(Charsets, Org, Charset, true, ok);
              'B': s2 := DecodeBase64(Charsets, Org, Charset, ok)
            end
         end;
         If ok then begin
            Result := Result + s2;
            DelBuffer := true
         end else begin
            AddBuffer := true
         end
      end;
      If AddBuffer then begin
         Result := Result + B; DelBuffer := true;
         M := 0
      end;
      If DelBuffer then B := '';
      If Not Ignore then Result := Result + c
   end;
   If Length(Result)>0 then begin
      Result[1] := Result[1]
   end
end;

Function ISOChar(Const c: Char): String;
begin
   Case c of
      ' ': Result := '_';
      Chr(0)..Pred(' '),
        '?', '_', '=',
           Chr(128)..Chr(255): Result := '='+HexStr(Ord(c));
      else Result := c;
   end
end;

Function EncodeISO (Charsets: TCharsets; Const H: String): String;
Var LinksGrenze, RechtsGrenze: Set of Char;
    Header, Inhalt, ISOAnf, ISOEnd, ISOCR, CS: String;

    Procedure EncodeFull;
    Var L, KodiereAb, KodiereBis: Integer;
        s, s2, Vor, Conv, Nach: String;
        b, Kodieren {, bAnfStr, bKlammer, bEnde}: Boolean;
        c: Char;
    Var i, j: Integer;
    begin
       LinksGrenze := MIMEStdGrenze;
       RechtsGrenze := MIMEStdGrenze;
       Kodieren := false; KodiereAb := 1; KodiereBis := Length(Inhalt)+1;
       For i:=1 to Length(Inhalt) do begin
          c := Inhalt[i];
          // Kodiernotwendigkeit/ende?
          If Not Kodieren then begin
             If c IN LinksGrenze then KodiereAb := i+1
             else If Ord(c) > 127 then Kodieren := true
          end else begin
             If c IN RechtsGrenze then begin
                If (i > KodiereAb) and (KodiereBis > Length(Inhalt))
                   then KodiereBis := i-1;
             end;
             If Ord(c) > 127 then KodiereBis := Length(Inhalt)+1
          end
       end;
       If Kodieren then begin
          Vor  := Copy(Inhalt, 1, KodiereAb-1);
          Conv := Copy(Inhalt, KodiereAb, KodiereBis-KodiereAb+1);
          Nach := Copy(Inhalt, KodiereBis+1, Length(Inhalt)-KodiereBis);
          Result := Vor + ISOAnf;
          s := ConvertText (Charsets, Conv, '', CS, b);
          For i := 1 to Length(s) do Result := Result + ISOChar(s[i]);
          Result := Result + ISOEnd + Nach;
          If (Length(Result) > MaxISOHeaderLen) then begin
             Conv := Conv + Nach; Nach := '';
             If Length(Header + Vor + ISOAnf + ISOEnd) > MaxISOHeaderLen-3 then begin
                For i := 1 to MaxISOHeaderLen - 3 - Length(Header+ISOAnf+ISOEnd) - 1 do begin
                   If i > Length(Vor) then break;
                   If Vor[i] IN LinksGrenze then KodiereAb := i+1
                end
             end;
             Conv := Copy(Vor, KodiereAb, Length(Vor)-KodiereAb+1) + Conv;
             Delete (Vor, KodiereAb, Length(Vor)-KodiereAb+1);
             Result := Header + Vor + ISOAnf;
             L := Length(Result);
             For i := 1 to Length(Conv) do begin
                s := ConvertText(Charsets, Conv[i], '', CS, b);
                s2 := ''; For j := 1 to Length(s) do s2 := s2 + ISOChar(s[j]);
                L := L + Length(s2);
                If L+Length(ISOEnd) > MaxISOHeaderLen then begin
                   s2 := ' ' + ISOAnf + s2;
                   L := Length(s2);
                   Result := Result + ISOEnd + #13#10 + s2
                end else begin
                   Result := Result + s2
                end
             end;
             Result := Result + ISOEnd;
          end else begin
             Result := Header + Result
          end
       end
    end;

    Procedure EncodeParts;
    Const kSpace = '_'; k8Bit = '8'; k7Bit = '7'; kReady = '*';

       Function Typ(c: Char): Char;
       begin
          If c = ' ' then Result := kSpace
          else If Ord(c)>127 then Result := k8Bit
          else Result := k7Bit
       end;

    Var i, j, p: Integer; c, AktTyp: Char; Typen, s, s2: String;
    begin
       LinksGrenze := MIMELinkeGrenzeFrom;
       RechtsGrenze := MIMERechteGrenzeFrom;
       AktTyp := k7Bit; Typen := '';
       With TStringList.Create do try
          s := '';
          For i := 1 to Length(Inhalt) do begin
             c := Inhalt[i];
             Case Typ(c) of
                k7Bit: If AktTyp = kSpace then begin
                          Typen := Typen + kSpace; Add(s);
                          AktTyp := k7Bit; s := c
                       end else begin
                          s := s + c
                       end;
                k8Bit: If AktTyp = kSpace then begin
                          Typen := Typen + kSpace; Add(s);
                          AktTyp := k8Bit; s := c
                       end else begin
                          s := s + c; AktTyp := k8Bit
                       end;
                kSpace: If AktTyp <> kSpace then begin
                          Typen := Typen + AktTyp; Add(s);
                          AktTyp := kSpace; s := c
                       end else begin
                          s := s + c
                       end;
             end
          end;
          If s > '' then begin
             Typen := Typen + AktTyp; Add(s)
          end;
          // Zusammensetzen
          Result := Header;
          Repeat
             p := Pos(k8Bit, Typen);
             If p = 0 then begin
             // Keine 8-Bit-Anteile
                For i := 1 to Length(Typen) do begin
                   Result := Result + Strings[0];
                   Delete(0)
                end;
                Typen := ''
             end else
             // 7-Bit-Anteile am Anfang abhaken
             If p > 1 then begin
                For i := 1 to p-1 do begin
                   Result := Result + Strings[0];
                   Delete(0)
                end;
                System.Delete (Typen, 1, p-1)
             end else begin
                // 8-Bit-Anteile kodieren: Zu konvertierenden String zusammensetzen
                p := Pos(k7Bit, Typen);
                If p = 0 then p := Length(Typen) else p := p-2;
                s2 := '';
                For i := 1 to p do begin
                   s2 := s2 + Strings[0];
                   Delete(0)
                end;
                System.Delete(Typen, 1, p);
                // Klammern und Anfhrungsstriche auerhalb der Kodierung belassen
                If s2[1] IN LinksGrenze then begin
                   Result := Result + s2[1]; System.Delete(s2, 1, 1)
                end;
                j := Length(s2);
                If s2[j] IN RechtsGrenze then begin
                   s := s2[j]; System.Delete(s2, j, 1)
                end else begin
                   s := ''
                end;
                // Eigentliche Konvertierung
                Result := Result + ISOAnf;
                For i := 1 to Length(s2) do Result := Result + ISOChar(s2[i]);
                Result := Result + ISOEnd + s
             end
          until Typen = ''
       finally
          free
       end
    end;

Var p: Integer; Mailadresse: Boolean;
begin
   Result := H;
   CS := Charsets.GetMinCharsetFor(H).HeaderName;
   ISOAnf := ISOIntro + CS + ISODel + 'Q' + ISODel;
   ISOEnd := ISOExtro;
   ISOCR := #13#10 + ' ';
   p := Pos(': ',  Result);
   If p > 0 then begin
      Header := Copy(H, 1, p+1);
      Inhalt := Copy(Result, p+2, Length(Result)-p-1);
      Mailadresse := Pos(' '+Lowercase(Header), Adressfelder)>0;
      if MailAdresse
         then EncodeParts
         else EncodeFull;
   end
end;

//While Pos(#13#10, Result)>0 do Delete(Result, Pos(#13#10, Result), 2)

initialization
finalization
end.
