unit DDefChSs;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TDlgDefCharsets = class(TForm)
    Panel1: TPanel;
    Label46: TLabel;
    cbCSIntern: TComboBox;
    Label47: TLabel;
    Label48: TLabel;
    cbCSHeader: TComboBox;
    Label49: TLabel;
    cbCSBody: TComboBox;
    butOk: TButton;
    butAbort: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    msg: TStringlist;
  public
    { Public-Deklarationen }
  end;

Procedure ConfigDefaultCharset;

implementation

Uses uCSMap, Settings, uTransla;

{$R *.DFM}

Procedure ConfigDefaultCharset;
Var i: Integer;
begin
   With TDlgDefCharsets.Create(nil) do try

      cbCSIntern.Items.Clear;
      For i := 0 to CSInfos.Count-1
         do cbCSIntern.Items.Add (CSInfos[i].HeaderName + ' ('+CSInfos[i].Desc+')');
      cbCSHeader.Items.Assign(CSInfos.Sets);
      cbCSBody.Items.Assign(CSInfos.Sets);

      ReadExtraSettings;
      With Extra do begin
         cbCSIntern.ItemIndex := CSInfos.CS2Nr(InternalCharset);
         With cbCSHeader do begin
            ItemIndex := Items.IndexOf(DefHeaderCharsets);
            If ItemIndex < 0 then ItemIndex := 0
         end;
         With cbCSBody do begin
            ItemIndex := Items.IndexOf(DefBodyCharsets);
            If ItemIndex < 0 then ItemIndex := 0
         end;
      end;

      If ShowModal = mrOK then begin

         With Extra do begin
            InternalCharset := CSInfos[cbCSIntern.ItemIndex].InternalName;
            With cbCSHeader do DefHeaderCharsets := Items[ItemIndex];
            With cbCSBody do DefBodyCharsets := Items[ItemIndex]
         end;
         WriteExtraSettings

      end
   finally
      free
   end
end;

procedure TDlgDefCharsets.FormCreate(Sender: TObject);
begin
   msg := TStringlist.Create;
   Translate (self, 'DlgDefCharsets', Msg);
end;

procedure TDlgDefCharsets.FormDestroy(Sender: TObject);
begin
   msg.free
end;

end.



