unit DBoxQuo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Settings, ComCtrls;

Procedure ConfigBoxQuotes;

type
  TDlgCfgBQ = class(TForm)
    butOk: TButton;
    butAbort: TButton;
    tc: TTabControl;
    GroupBox1: TGroupBox;
    labAnf: TLabel;
    labTr: TLabel;
    labEnd: TLabel;
    txtAnf: TEdit;
    txtTr: TEdit;
    txtEnd: TEdit;
    gbOptik: TGroupBox;
    txtObLEck: TEdit;
    txtUntLEck: TEdit;
    txtLRand: TEdit;
    txtOben: TEdit;
    txtUnten: TEdit;
    txtTit: TEdit;
    gbPreview: TGroupBox;
    Label11: TLabel;
    lOrg: TListBox;
    lErg: TListBox;
    Label4: TLabel;
    txtObREck: TEdit;
    txtUntREck: TEdit;
    txtRRand: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    cbTyp: TComboBox;
    Button1: TButton;
    Button2: TButton;
    optText: TRadioButton;
    optDatei: TRadioButton;
    labBreiteO: TLabel;
    txtBreiteU: TEdit;
    txtBreiteO: TEdit;
    labBreiteU: TLabel;
    Label1: TLabel;
    procedure Preview (Sender: TObject);
    procedure butOkClick(Sender: TObject);
    procedure tcChange(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    Neu: TArrayCfgBoxQuotes;
    Usermode: boolean;
    msg: TStringlist;
    procedure Anzeige;
  end;

implementation

{$R *.DFM}

Uses uKNTools, uTransla;

Function Test (Const Akt, Def: String): String;
begin
   If Akt > '' then Result := Akt else Result := Def
end;

Procedure ConfigBoxQuotes;
Var i: Integer;
begin
   With TDlgCfgBQ.Create(nil) do try
      ReadBoxQuoteSettings;
      Neu := BQ;
      For i:=Low(Neu) to High(Neu) do
         tc.Tabs[i-Low(Neu)] := Test ( Neu[i].Anfangszeile, '#'+IntToStr(i-Low(Neu)+1) );
      Anzeige;
      If ShowModal = mrOK then begin
         BQ := Neu; WriteBoxQuoteSettings
      end
   finally free end
end;

procedure TDlgCfgBQ.Anzeige;
begin
   Usermode := false;
   With Neu[tc.TabIndex+1] do begin
      cbTyp.ItemIndex := Ord(Typ);
      optDatei.checked := bDatei;
      optText.checked := Not bDatei;
      txtAnf.text := Anfangszeile;
      txtTr.text := Trennzeile;
      txtEnd.text := Endzeile;
      txtobLEck.text := ObereLinkeEcke;
      txtobREck.text := ObereRechteEcke;
      txtUntLEck.text := UntereLinkeEcke;
      txtUntREck.text := UntereRechteEcke;
      txtLRand.text := LinkerRand;
      txtRRand.text := RechterRand;
      txtOben.text := Oben;
      txtUnten.text := Unten;
      txtBreiteO.text := IntToStr(ZeilenbreiteOben);
      txtBreiteU.text := IntToStr(ZeilenbreiteUnten);
      txtTit.text := Titelumrandung;
   end;
   Usermode := true;
   Preview(nil)
end;

procedure TDlgCfgBQ.Preview (Sender: TObject);
Var Titel: String; sl: TStringlist; Nr: Integer;
begin
   If not Usermode then exit;
   Nr := tc.TabIndex+1;
   With Neu[Nr] do begin
      { Zuweisung }
      bDatei := optDatei.checked;
      Typ := TBoxQuoteType(cbTyp.ItemIndex);
      Anfangszeile := txtAnf.text;
      Trennzeile := txtTr.text;
      Endzeile := txtEnd.text;
      TitelUmrandung := txtTit.text;
      ZeilenbreiteOben := StrToInt('0'+txtBreiteO.text);
      If ZeilenbreiteOben < 1 then ZeilenbreiteOben := 1;
      ZeilenbreiteUnten := StrToInt('0'+txtBreiteU.text);
      If ZeilenbreiteUnten < 1 then ZeilenbreiteUnten := 1;
      ObereLinkeEcke := Test(txtobLEck.text, ' ,');
      ObereRechteEcke := Test(txtobREck.text, '.');
      UntereLinkeEcke := Test(txtUntLEck.text, ' `');
      UntereRechteEcke := Test(txtUntREck.text, '');
      LinkerRand := Test(txtLRand.text, '| ');
      RechterRand := Test(txtRRand.text, ' |');
      Oben := (txtOben.text+'-')[1];
      Unten := (txtUnten.text+'-')[1];
      { Elemente ggf. verstecken }
      With labAnf do begin
         If bDatei
            then caption := Tr(msg, 'BeginOfLine', 'Zeilenanfang:')
            else caption := Tr(msg, 'First Line', 'Anfangszeile:')
      end;
      labTr.visible := Not bDatei; txtTr.visible := Not bDatei;
      labEnd.visible := Not bDatei; txtEnd.visible := Not bDatei;
      gbOptik.visible := Nutzbar;
      gbPreview.visible := Nutzbar;
      labBreiteO.visible := Typ = bqSimple;
      txtBreiteO.visible := Typ = bqSimple;
      labBreiteU.visible := Typ = bqSimple;
      txtBreiteU.visible := Typ = bqSimple;
      txtobREck.visible := Typ IN[bqClosed];
      txtRRand.visible := Typ IN[bqClosed];
      txtUntREck.visible := Typ IN[bqClosed];
      { Anzeige }
      sl := TStringlist.Create;
      With lOrg.Items do begin
         BeginUpdate;
         Clear;
         If bDatei then begin
            Titel := Tr(msg, 'FileExample.Title', 'c:\beispiel.ini');
            sl.text := Tr(msg, 'FileExample.Text', '[Setup]^mPfad=C:\Beispiel^mUsername=Testuser^mLetzterZugriff=20001212');
            Add (Anfangszeile+Titel)
         end else begin
            Titel := Tr(msg, 'TextExample.Title', 'Titel');
            sl.text := Tr(msg, 'TextExample.Text', 'Und hier folgt dann^mder Text...^m(Titel ist optional!)');
            Add (Anfangszeile);
            Add (Titel);
            Add (Trennzeile);
            AddStrings (sl);
            Add (Endzeile)
         end;
         EndUpdate
      end;
      With lErg.Items do begin
         sl.Insert(0, ''); sl.Add('');
         BoxQuote (Titel, Neu[tc.TabIndex+1], sl);
         Clear; AddStrings (sl)
      end
   end;
   tc.Tabs[Nr-1] := Test ( Neu[Nr].Anfangszeile, '#'+IntToStr(Nr) )
end;

procedure TDlgCfgBQ.butOkClick(Sender: TObject);
begin
   ModalResult := mrOk
end;

procedure TDlgCfgBQ.tcChange(Sender: TObject);
begin
   Anzeige
end;

procedure TDlgCfgBQ.Button1Click(Sender: TObject);
begin
   With Neu[tc.TabIndex+1] do begin
      ObereLinkeEcke := ' ,';
      ObereRechteEcke := '.';
      UntereLinkeEcke := ' `';
      UntereRechteEcke := '';
      LinkerRand := '| ';
      RechterRand := ' |';
      Oben := '-';
      Unten := '-'
   end;
   Anzeige
end;

procedure TDlgCfgBQ.Button2Click(Sender: TObject);
begin
   With Neu[tc.TabIndex+1] do begin
      ObereLinkeEcke := ' /';
      ObereRechteEcke := '\';
      UntereLinkeEcke := ' \';
      UntereRechteEcke := '/';
      LinkerRand := '| ';
      RechterRand := ' |';
      Oben := '=';
      Unten := '='
   end;
   Anzeige
end;

procedure TDlgCfgBQ.FormCreate(Sender: TObject);
begin
   msg := TStringlist.Create;
   Translate (self, 'DlgBoxquotes', Msg);
end;

procedure TDlgCfgBQ.FormDestroy(Sender: TObject);
begin
   msg.free
end;

end.
