unit uHamster;

interface

Uses OleAuto,
     // ComObj,
     SysUtils, IniFiles, Windows, Classes, Settings;

Type TOKFunction = Function: boolean;
     TEnterFunction = Function (Ini: TIniFile): boolean;

Procedure DoMain (Const IniDatei: String; Enter: TEnterFunction; Enter2, DoIt, Leave: TOkFunction);
Function  Gruppe_erlaubt (Const Gr: String; lIgn, lDontIgn: TStrings): boolean;
Procedure OeffneGruppe;
Procedure LadeArtikel (Const Nr: Integer);

Procedure TouchGroups (Const Gr: String);

Procedure GetHamsterGruppenliste (sl: TStrings);

{Function  PosBodyBegin: Integer;}
{Function  GetPos(Const Header: String; Var Anfang, Ende: Integer;
      Var NeuHeader: String): boolean;}

Procedure ExportArtikel (Const Dateimuster: String; Opt: TCIEinstellungen);
Procedure SpeichereArtikelKopie (Const NewsGroups, AddToMessageID: String;
   Const CopyIfExist: boolean; Opt: TCIEinstellungen);
Procedure ErsetzeArtikel (Opt: TCIEinstellungen);
Procedure LoescheArtikel (Opt: TCIEinstellungen);

Const RefHeader = 'References: ';
      MessageIDHeader = 'Message-ID: ';
      XMessageIDHeader = 'X-'+MessageIDHeader;
      CRLF = #13#10;
      HeaderCopyIf = 'X-ReImported: CopyIf';

Var Hamster: Variant;
    MID: String;
    Ini: TIniFile;
    AktGruppeHandle, MinArtikel,
    AnzGruppen, AktGruppeNr: LongInt;
    AktGruppeBez: String;
    Posting, Touched: TStringlist;
    ZExported, ZSaved, ZCopies: LongInt;
    AktVer: String;

Function MaxArtikel: Longint;

implementation

Uses {DShow,} uPerlRe, Korrektu;

{ ================= Sonderfunktionen ===================== }

Procedure GetHamsterGruppenliste (sl: TStrings);
Var Gr: Integer;
begin
   sl.Clear;
   For Gr := 0 to Hamster.NewsGrpCount - 1 do sl.Add (Hamster.NewsGrpName(Gr));
end;

{ ========================================================= }

Var Gruppe_geoeffnet: boolean;
    ArtikelNr: Integer;

Function MaxArtikel: Longint;
begin
   if Gruppe_geoeffnet then MaxArtikel := Hamster.NewsArtNoMax(AktGruppeHandle)
                       else MaxArtikel := 0
end;

Procedure OeffneGruppe;
begin
   if not Gruppe_geoeffnet then begin
      AktGruppeHandle := Hamster.NewsGrpOpen(AktGruppeBez);
      MinArtikel := Hamster.NewsArtNoMin(AktGruppeHandle);
      Gruppe_geoeffnet := true
   end else begin
      Messagebox (0, PChar('Interner Fehler: Versuch, eine Gruppe mehrfach zu ffnen!'),
                  PChar('Copy Followups V1.1 by Thomas G. Liesner'), 0);
      Halt
   end
end;

Procedure LadeArtikel (Const Nr: Integer);
Var s: String; i: Integer;
begin
   if Gruppe_geoeffnet then begin
      Posting.Text :=  Hamster.NewsArtText(AktGruppeHandle, Nr);
      MID := '';
      For i:=0 to Posting.Count-1 do begin
         s := Posting[i];
         If LowerCase(Copy(s, 1, Length(MessageIDHeader)))=LowerCase(MessageIDHeader) then begin
            MID := Copy (s, Length(MessageIDHeader)+1, Length(s));
            break
         end;
         If s = '' then break
      end;
      ArtikelNr := Nr
   end else begin
      Messagebox (0, PChar('Interner Fehler: Gruppe ist nicht geffnet, aber "LadeArtikel" wurde aufgerufen!'),
                  PChar('Copy Followups V1.1 by Thomas G. Liesner'), 0);
      Halt
   end
end;

Function HeaderPos(Const s: String): Integer;
Var i, l: Integer;
begin
   Result := -1; L := Length(s);
   For i:=0 to Posting.Count-1 do begin
      If Posting[i]='' then break;
      If Copy(Posting[i], 1, l) = s then begin
         Result := i; break
      end
   end
end;

Procedure SpeichereArtikelKopie (Const NewsGroups, AddToMessageID: String;
   Const CopyIfExist: boolean; Opt: TCIEinstellungen);
Var p1, p2: Integer; MID: String; // b: boolean;
    NoMID: boolean;
begin
   If Not Gruppe_geoeffnet then begin
      Messagebox (0, PChar('Interner Fehler: Gruppe ist nicht geffnet, aber "SpeichereArtikelKopie" wurde aufgerufen!'),
                  PChar('CopyIf by Thomas G. Liesner'), 0);
      Halt
   end else
   If ArtikelNr < 0 then begin
      Messagebox (0, PChar('Interner Fehler: Kein Artikel geladen, aber "SpeichereArtikelKopie" wurde aufgerufen!'),
                  PChar('CopyIf by Thomas G. Liesner'), 0);
      Halt
   end else begin
      // b := true;
      If AddToMessageID > '' then begin
         p1 := HeaderPos(MessageIDHeader);
         p2 := HeaderPos(XMessageIDHeader);
         NoMID := (p1 < 0);
         If p2 < 0 then begin
            If Not NoMID then begin
               MID := Copy(Posting[p1], Length(MessageIDHeader)+2, Length(Posting[p1]));
               Posting[p1] := MessageIDHeader + '<' + AddToMessageID + MID;
               Posting.Insert (0, XMessageIDHeader + '<' + MID)
            end
         end;
         If Opt.Simulate then begin
//            If Opt.ShowFoundedPostingsWhenSimulate then ###########
//               b := ShowArtikel ('CopyIf V'+AktVer+': Simulate - Artikel nach "'+Newsgroups+'" unter neuer MID kopieren', Posting.text)
         end else begin
            Hamster.NewsImport(Posting.text, NewsGroups, NoMID or CopyIfExist, false);
            Register_AddToMessageID (AddToMessageID)
         end
      end else begin
         If Opt.Simulate then begin
//            If Opt.ShowFoundedPostingsWhenSimulate ################
//               then b := ShowArtikel ('CopyIf V'+AktVer+': Simulate - Artikel nach "'+Newsgroups+'" mit alter MID kopieren', Posting.text)
         end else begin
            Hamster.NewsImport(Posting.text, NewsGroups, true, false);
            Register_AddToMessageID (AddToMessageID)
         end
      end;
      Inc (ZCopies);
//      If Not b then Stop #########
   end
end;

Procedure ErsetzeArtikel (Opt: TCIEinstellungen);
Var Headerende, v, i: Integer; r: TSearchRec; t: Text; s: String;
begin
   If Opt.Simulate then begin
      Inc (ZSaved);
//      If Opt.ShowFoundedPostingsWhenSimulate then ############
//         If Not ShowArtikel ('CopyIf V'+AktVer+': Simulate - Ersetze alten Artikel durch...', Posting.text) then Stop
   end else begin
      Headerende := Posting.IndexOf('');
      If (MID > '') and (Headerende > 0) then begin
         Inc (ZSaved);
         Repeat Until Not Hamster.NewsDeleteByMID(MID);
         If Posting.IndexOf (HeaderCopyIf) < 0 then Posting.Insert(Headerende, HeaderCopyIf);
         If Not Hamster.NewsImport(Posting.text, '', true, false) then begin
            ShowMessage('Speichern hat nicht funktioniert!');
            i := 0;
            If FindFirst(ExtractFilePath(ParamStr(0))+'ups*.msg', faAnyfile-faDirectory-faVolumeID, r) = 0 then try
               Repeat
                  If Length(r.name)>7 then begin
                     try v := StrToInt(Copy(r.name, 4, Length(r.name)-7)) except v := 0 end;
                     If v > i then i := v
                  end
               Until FindNext(r) <> 0
            finally
               SysUtils.FindClose(r)
            end;
            s := ExtractFilePath(ParamStr(0))+'ups'+Inttostr(i+1)+'.msg';
            AssignFile(t, s);
            Rewrite(t);
            Writeln(t, Posting.text);
            CloseFile(t);
            ShowMessage('Kopie des Posting ist unter "'+s+'" gespeichert!')
         end
      end else begin
// #########         If Not ShowArtikel('CopyIf V'+AktVer+': "Ersetze Artikel" dank leerer MID oder kaputtem Posting unmglich!', Posting.text) then Stop
      end
   end;
end;

Procedure LoescheArtikel (Opt: TCIEinstellungen);
begin
   If Opt.Simulate then begin
//      If Opt.ShowFoundedPostingsWhenSimulate then ##########
//         If Not ShowArtikel ('CopyIf V'+AktVer+': Simulate - Lsche folgenden Artikel...', Posting.text) then Stop
   end else begin
      If (MID > '') then Repeat Until Not Hamster.NewsDeleteByMID(MID)
//                    else If Not ShowArtikel('CopyIf V'+AktVer+': "Lsche Artikel" dank leerer MID oder kaputtem Posting unmglich!',
//                                  Posting.text) then Stop ##########
   end
end;

Procedure ExportArtikel (Const Dateimuster: String; Opt: TCIEinstellungen);
Var s: String; p, Nr: Integer;
begin
   p := Pos('*', Dateimuster); Nr := 0;
   Repeat
      Inc(Nr); s := Copy(Dateimuster, 1, p-1)+Inttostr(nr)+Copy(Dateimuster,p+1,Length(Dateimuster)-p)
   Until Not FileExists(s);
   Inc (ZExported);
   If Opt.Simulate then begin
//      If Opt.ShowFoundedPostingsWhenSimulate then     ##########
//         If Not ShowArtikel ('CopyIf V'+AktVer+': Simulate - Export Artikel unter "'+s+'"', Posting.text) then Stop
   end else Posting.SaveToFile (s)
end;

Procedure DoMain (Const IniDatei: String; Enter: TEnterFunction; Enter2, DoIt, Leave: TOkFunction);
Var Gr: LongInt;
begin
   Ini := TIniFile.Create(IniDatei);
   try
      If Enter(Ini) then try
         Hamster := CreateOleObject('Hamster.App');
         AnzGruppen := Hamster.NewsGrpCount;
         If Enter2 then begin
            For Gr := 0 to Hamster.NewsGrpCount - 1 do begin
               AktGruppeNr := Gr+1;
               AktGruppeBez := Hamster.NewsGrpName(Gr);
               {Hamster.ControlAddLog ('CopyIf - Teste '+AktGruppeBez, 3);}
               Gruppe_geoeffnet := false; ArtikelNr := -1;
               If Not Doit then break;
               If Gruppe_geoeffnet then Hamster.NewsGrpClose(AktGruppeHandle);
            end;
            Leave
         end
      finally
         Hamster := Unassigned
      end
   finally
      Ini.free
   end;
end;

Function Gruppe_erlaubt (Const Gr: String; lIgn, lDontIgn: TStrings): boolean;
Var j: Integer;
begin
   Result := true;
   { ... oder zu ignorierende Gruppen ... }
   With TPerlRe.Create(true, PCRE_CASELESS) do try
      If Assigned(lIgn) then
         For j := 0 to lIgn.Count-1 do
            If Result then Result := Not MatchRS (lIgn[j], Gr);
      If (Not Result) and Assigned(lDontIgn) then begin
         { ... ausser es ist eine trotzdem zu beachtende Gruppe }
         For j := 0 to lDontIgn.Count-1 do
            If Not Result then Result := MatchRS (lDontIgn[j], Gr);
      end
   finally free end
end;

Procedure TouchGroups (Const Gr: String);
Var Pf: String; i: Integer;
begin
   If Gr = '' then exit;
   If Touched.IndexOf(Gr) >= 0
      then exit
      else Touched.Add (Gr);
   try
      Pf := Hamster.ControlGetGroupsPath
   except
      Pf := Hamster.ControlGetPath+'Groups\'
   end;
   With TPerlRe.Create (true, 0) do try
      RegExp := Gr;
      For i := 0 to Hamster.NewsGrpCount-1 do
         If MatchS ( Hamster.NewsGrpName(i) ) then begin
            With TIniFile.Create(Pf + Hamster.NewsGrpName(i) + '\data.ini' ) do try
               WriteString ( 'Info', 'LastClientRead', FormatDateTime('yyyymmddhhnnss', Now) )
            finally free end
         end
   finally free end
end;

initialization
   Posting := TStringlist.Create;
   Touched := TStringlist.Create;
finalization
   Posting.free; Touched.free
end.
