unit uKNTools;

interface

Uses Settings, Classes;

Function SaveFile (Const Pfad, OrgDateiname, Inhalt: String; Const Action: TActionIfAttExists): String;
Function GetWord (Var s, Wort: String): boolean;
Function MakeAdress (Const Name, Adresse: String): String;
Procedure ExtractMailParts (Const Gesamt: String; Var Name, Vorname, Adresse: String);
Procedure BoxQuote (Const Titel: String; Const Def: TCfgBoxQuotes; sl: TStrings);
Function GetFirstElementOfKommaListe (Var s: String; Var Next: boolean): String;
Function Sgn(Const x: Double): Integer;
Procedure ChooseSig (Const Sigs: TStrings; Const Def: Integer);
Function ExecAndWait(const Filename, Params: string;
                     WindowState: word): boolean;
Function KuerzeLeerzeilenAmEnde(Const s: String): String;
Function TempName: String;
Function ContainsCommand(Var Org: String; Const Suchwort: String; Const DelInclSuchwort: boolean): boolean;

implementation

uses Windows, ShellAPI, SysUtils, uGetStr, uPerlRe;

Function SaveFile (Const Pfad, OrgDateiname, Inhalt: String; Const Action: TActionIfAttExists): String;
Var Dateiname, s, s2, Pfad2: String; i, p, Nr: Integer;
begin
   Dateiname := OrgDateiname;
   p := 0;
   For i := 1 to Length(Dateiname) do begin
      Case Dateiname[i] of
         '*': begin
                 If p > 0 then Dateiname[p] := '_';
                 p := i
              end;
         '?', '/', '\', ':', '"', '<', '>', '|': Dateiname[i] := '_';
      end
   end;
   If Dateiname = '' then Dateiname := 'AutoSave_';
   Result := '';
   Pfad2 := Pfad;
   If Pfad2 = '' then Pfad2 := ExtractFilePath(ParamStr(0));
   If Pfad2 > '' then If Pfad2[length(Pfad2)]<>'\' then Pfad2 := Pfad2 + '\';
   Nr := 0;
   If p = 0 then begin
      s := Pfad2 + Dateiname;
      If FileExists(s) then begin
         Case Action of
            aeNothing: Exit;
            aeRename: begin
               Repeat
                  Inc(Nr);
                  s2 := ExtractFileExt(Dateiname);
                  s := Pfad2
                       + Copy(Dateiname, 1, Length(Dateiname)-Length(s2))
                       + '['+Inttostr(Nr)+']' + s2
               Until Not FileExists(s)
            end;
            aeOverwrite: ;
         end
      end
   end else begin
      Repeat
         Inc(Nr);
         s := Pfad2 + Copy(Dateiname, 1, p-1)+Inttostr(nr)+Copy(Dateiname,p+1,Length(Dateiname)-p)
      Until Not FileExists(s)
   end;

   With TFileStream.Create(s, fmCreate) do try
      Write (Inhalt[1], Length(Inhalt));
      Result := s
   finally
      free
   end

end;

Function GetWord (Var s, Wort: String): boolean;
Var l, ls: Integer;
begin
   Result := false;
   s := Trim(s);
   If s > '' then begin
      If s[1] in Wortbestandteil then begin
         l := 1; ls := Length(s);
         While (l<ls) and (s[l+1] IN Wortbestandteil) do Inc(l);
         Wort := Copy(s, 1, l); s := Copy(s, l+1, ls-l);
         Result := true
      end
   end
end;

Function MakeAdress (Const Name, Adresse: String): String;
Var Last, c: Char; ab, bis, i: Integer; bAnf: boolean;
begin
   Result := '';
   If (Name > '') and (Name <> Adresse) then begin
      ab := 1; bis := Length(Name);
      If (Name[1]='"') and (Name[Length(Name)]='"') then begin
         Inc(ab); Dec(bis)
      end;
      Last := ' '; bAnf := false;
      For i:=ab to bis do begin
         c := Name[i];
         If Pos(c, '".,<>')>0 then bAnf := true;
         If (c = '"') and (Last <> '\') then Result := Result + '\';
         Result := Result + c; Last := c
      end;
      If Result > '' then begin
         If bAnf then Result := '"'+Result+'"';
         Result := Result + ' '
      end
   end;
   If Adresse > '' then begin
      If Adresse[1]<>'<' then Result := Result + '<';
      Result := Result + Adresse;
      If Adresse[Length(Adresse)]<>'>' then Result := Result + '>'
   end
end;

Procedure ExtractMailParts (Const Gesamt: String; Var Name, Vorname, Adresse: String);
Var p, i: Integer; s: String;
begin
   s := Trim(Gesamt);
   Adresse := ''; Name := ''; Vorname := '';
   If RegEx.MatchRS ('^.+@.+ (.+)$', s) then begin
      For i:=Length(s)-1 downto 1 do If s[i]='(' then begin
         Name := Trim(Copy(s, i+1, Length(s)-i-1));
         Adresse := Trim(Copy(s, 1, i-1))
      end
   end else If RegEx.MatchRS ('^.+ <.+@.+>$', s) then begin
      For i:=Length(s)-1 downto 1 do If s[i]='<' then begin
         Adresse := Copy(s, i+1, Length(s)-i-1);
         Name := Trim(Copy(s, 1, i-1))
      end
   end else If RegEx.MatchRS ('^<.+@.+>$', s) then begin
      Adresse := Copy(s, 2, Length(s)-2); Name := ''
   end else begin
      Adresse := s
   end;
   If Name > '' then begin
      Vorname := '';
      If (Name[1]='"') and (Name[Length(Name)]='"') then begin
         Name := Trim(Copy(Name, 2, Length(Name)-2))
      end;
      p := pos(',', Name);
      If p > 0 then Vorname := Trim(Copy(Name, p+1, Length(Name)-p))
      else begin
         p := pos(' ', Name);
         If p > 0 then Vorname := Trim(Copy(Name, 1, p-1))
      end
   end;
   If Adresse = '' then Adresse := s;
   If Name = '' then Name := Adresse;
   If Vorname = '' then Vorname := Adresse;
end;

Procedure BoxQuote (Const Titel: String; Const Def: TCfgBoxQuotes; sl: TStrings);
Var l, i, j, p, x, br: Integer; s, TitelLinks, TitelRechts: String; bTitel: Boolean;
begin
   bTitel := Titel > '';
   With Def do begin
      TitelLinks := Titelumrandung;
      i := Pos('@', Titelumrandung);
      If i = 0 then begin
         br := Length(Titelumrandung) div 2;
         Titellinks := Copy(Titelumrandung, 1, br);
         TitelRechts := Copy(Titelumrandung, Length(Titelumrandung) - br + 1, br)
      end else begin
         Titellinks := Copy(Titelumrandung, 1, i-1);
         TitelRechts := Copy(Titelumrandung, i+1, Length(Titelumrandung)-i)
      end;
      If Not Nutzbar then exit;
      If bTitel then br := Length(TitelLinks+Titel+TitelRechts) + 2 else br := 10;
      For i := 1 to sl.Count-2 do begin
         x := Length(sl[i])+2;
         If x>br then br := x;
      end;
      If (Length(Titel) Mod 2) <> (Br Mod 2) then Inc(Br);
      s := ObereLinkeEcke; x := 0;
      Case Typ of
         bqSimple: begin
            s := s + StringOfChar(Oben, ZeilenbreiteOben);
            If bTitel then s := s + TitelLinks + Titel + TitelRechts
         end;
         bqOpened: begin
            x := (br - Length(Titel)) Div 2;
            s := s + StringOfChar(Oben, br);
            If (Length(Titel) Mod 2) <> (Br Mod 2) then Inc(Br)
         end;
         bqClosed: begin
            x := (br - Length(Titel)) Div 2;
            s := s + StringOfChar(Oben, br) + ObereRechteEcke;
         end
      end;
      If bTitel and (x>0) then begin
         For i := 1 to Length(Titel) do s[x+i+Length(ObereLinkeEcke)] := Titel[i];
         For i := 1 to Length(TitelLinks) do s[x+Length(ObereLinkeEcke)+i-Length(TitelLinks)] := TitelLinks[i];
         For i := 1 to Length(TitelRechts) do s[x+Length(Titel)+Length(ObereLinkeEcke)+i] := TitelRechts[i]
      end;
      sl[0] := s;
      For i:=1 to sl.Count-2 do Case Typ of
         bqSimple, bqOpened: sl[i] := LinkerRand + ' '+sl[i];
         bqClosed: begin
            s := LinkerRand + ' ' + sl[i];
            Repeat
               p := Pos(#9, s);
               If p > 0 then begin
                  s[p] := ' '; For j := p+1 to ((p Div 8)+1)*8 do Insert(' ', s, p)
               end
            Until p = 0;
            L := Length(s) - Length(LinkerRand) - 1;
            While L < br-1 do begin s := s + ' '; Inc(L) end;
            sl[i] := s + RechterRand
         end
      end;
      Case Typ of
         bqSimple: s := UntereLinkeEcke + StringOfChar(Unten, ZeilenbreiteUnten);
         bqOpened: s := UntereLinkeEcke + StringOfChar(Unten, br);
         bqClosed: s := UntereLinkeEcke + StringOfChar(Unten, br) + UntereRechteEcke;
      end;
      sl[sl.Count-1] := s;
   end
end;

Function GetFirstElementOfKommaListe (Var s: String; Var Next: boolean): String;
Var p: Integer;
begin
   p := Pos(',', s);
   Next := (p>0);
   If Next then begin
      Result := Trim(Copy(s, 1, p-1)); s := Trim(Copy(s, p+1, Length(s)-p))
   end else begin
      Result := Trim(s); s := ''
   end
end;

Function Sgn(Const x: Double): Integer;
begin
   If x > 0 then Result := 1
   else If x < 0 then Result := -1
   else Result := 0
end;

Procedure ChooseSig (Const Sigs: TStrings; Const Def: Integer);
Var i, j, Nr, Anz: Integer;
begin
   With Sigs do If Count > 0 then begin
      Anz := 0;
      If Trim(Strings[0])<>'--' then Insert(0, '--');
      For i:=0 to Count-1 do begin
         If Trim(Strings[i])='--' then Inc(Anz)
      end;
      If Def < 1 then Nr := Random(Anz) else Nr := Def-1;
      Anz := 0;
      For i:=0 to Count-1 do If Trim(Strings[i])='--' then begin
         Inc(Anz);
         If Anz > Nr then begin
            For j := 0 to i do Delete(0);
            break
         end
      end;
      For i:=0 to Count-1 do If Trim(Strings[i])='--' then begin
         While Count > i do Delete(i);
         break
      end;
      While (Count>0) and (Trim(Strings[Count-1])='') do Delete(Count-1)
   end
end;

Function ExecAndWait(const Filename, Params: string;
                     WindowState: word): boolean;
var
  SUInfo: TStartupInfo;
  ProcInfo: TProcessInformation;
  CmdLine, Path: string;
  Buffer: String[255];
  p, R: Integer;
begin
   { ggf. passende Datei suchen ... }
   If FileExists(FileName) then begin
      CmdLine := Filename
   end else begin
      SetLength(Buffer, 255);
      R := FindExecutable( PChar(FileName), PChar(ExtractFilePath(Filename)), @Buffer[1]);
      p := Pos(#0, Buffer); If p>0 then SetLength(Buffer, P-1);
      If (R > 32) and (p > 0) then CmdLine := Buffer
   end;
  { Enclose filename in quotes to take care of
    long filenames with spaces. }
  Path := ExtractFilePath(CmdLine);
  CmdLine := '"' + CmdLine + '"';
  If Params > '' then CmdLine := CmdLine + ' ' + Params;
  FillChar(SUInfo, SizeOf(SUInfo), #0);
  with SUInfo do begin
    cb := SizeOf(SUInfo);
    dwFlags := STARTF_USESHOWWINDOW;
    wShowWindow := WindowState;
  end;
  Result := CreateProcess(NIL, PChar(CmdLine), NIL, NIL, FALSE,
                          CREATE_NEW_CONSOLE or
                          NORMAL_PRIORITY_CLASS, NIL,
                          PChar(Path),
                          SUInfo, ProcInfo);
  { Wait for it to finish. }
  if Result then
    WaitForSingleObject(ProcInfo.hProcess, INFINITE);
end;

Function KuerzeLeerzeilenAmEnde(Const s: String): String;
Var L: Integer;
begin
   Result := s;
   L := Length(Result);
   While (L>2) and (Result[L-1]=#13) and (Result[L]=#10) do begin
      Dec(L, 2); Delete(Result, L+1, 2)
   end
end;

Type
  EWin32Error = class(Exception)
  public
    ErrorCode: DWORD;
  end;

procedure RaiseLastWin32Error;
var
  LastError: DWORD;
  Error: EWin32Error;
begin
  LastError := GetLastError;
  if LastError <> ERROR_SUCCESS then begin
    Error := EWin32Error.CreateFmt('Win32-Fehler. Code: %d.''#10''%s', [LastError,
      SysErrorMessage(LastError)])
  end else begin
    Error := EWin32Error.Create('Eine Win32-API-Funktion ist fehlgeschlagen')
  end;
  Error.ErrorCode := LastError;
  raise Error;
end;

Function TempName: String;
Var i: integer;
begin
   SetLength (Result, MAX_PATH+1);
   i := GetTempFileName(PChar(ExtractFilePath(ParamStr(0))), PChar('KN-'), 0, @Result[1]);
   If i = 0 then RaiseLastWin32Error //Result := ExtractFilePath(ParamStr(0))+'KNDebug.txt'
            else SetLength(Result, i);
end;

Function ContainsCommand(Var Org: String; Const Suchwort: String; Const DelInclSuchwort: boolean): boolean;
Var s: String; i, M, p: Integer; c: Char;
begin
   s := ' ';
   M := 0;
   For i := 1 to Length(Org) do begin
      c := Org[i];
      Case M of
         0: If c = '''' then M := 1
            else If c = '"' then M := 2
            else If c IN ['(', '[', ']', ')'] then c := ' '
            else c := UpCase(c);
         1: If c = '''' then begin c := ' '; M := 0 end;
         2: If c = '"' then begin c := ' '; M := 0 end;
      end;
      s := s + c
   end;
   s := s + ' ';
   P := Pos(' '+UpperCase(Suchwort)+' ', s);
   Result := p > 0;
   If Result and DelInclSuchwort then Delete(Org, 1, p-1+Length(Suchwort))
end;

end.
