unit uTransla;

interface

Uses TypInfo, classes,
     {$IFNDEF NOGUI} Forms, Dialogs, {$ENDIF}
     SysUtils;

Function LoadLanguages (sl: TStrings): Integer;
Procedure ChangeLanguage(Const Neu: String);
Function  Tr(slMessages: TStrings; Const Key, Def: String): String;
Function  Trl(Const Key, Def: String): String; 
Function  Trf(Const Key, Def: String; Args: Array of Const): String;

{$IFNDEF NOGUI}
Procedure Translate (F: TForm; Const Abschnitt: String; slMessages: TStrings);
Procedure ETranslate (F: TForm; Const Abschnitt: String; egal: TStrings);
{$ENDIF}

implementation

Uses IniFiles;

Const Default = 'Deutsch';

Var slTr, slMsg: TStringlist;
    Sprache: String;

Procedure Init;
Var s: String;
begin
   If Assigned(slTr) then exit;
   With TIniFile.Create(ExtractFilePath(ParamStr(0))+'Specials.ini') do try
      Sprache := ReadString ('General', 'Language', '')
   finally free end;
   slTr := TStringlist.Create;
   s := ExtractFilePath(ParamStr(0))+'Korrnews.dat';
   If FileExists(s) then slTr.LoadFromFile (s)
end;

Function LoadLanguages (sl: TStrings): Integer;
Var s: String; i: Integer;
begin
   Init;
   sl.Clear;
   sl.Add (Default);
   For i := 0 to slTr.Count-1 do begin
      s := slTr[i];
      If (s > '') and (s[1]='[') then begin
         s := Trim(s);
         s := Copy(s, 2, Length(s)-2);
         sl.Add (s)
      end
   end;
   i := sl.IndexOf(Sprache);
   If i < 0 then i := 0;
   Sprache := sl[i];
   Result := i
end;

Procedure ChangeLanguage(Const Neu: String);
begin
   Init;
   With TIniFile.Create(ExtractFilePath(ParamStr(0))+'Specials.ini') do try
      WriteString ('General', 'Language', Neu);
      Sprache := Neu
   finally free end;
end;

Procedure Filter(slTr, slDlg, slMsg: TStrings; Const Abschnitt: String);
Var L, i: Integer; s: String; ok: boolean;
begin
   L := Length(Abschnitt);
   If Assigned(slDlg) then slDlg.Clear;
   slMsg.Clear;
   ok := false;
   For i := 0 to slTr.Count-1 do begin
      s := Trim(slTr[i]);
      if not ok then begin
         ok := s = '['+Sprache+']'
      end else If s > '' then begin
         If s[1]='[' then break;
         If Copy(s, 1, l) = Abschnitt then Case s[l+1] of
            '.': If Assigned(slDlg) then slDlg.Add(s);
            '/': slMsg.Add(Copy(s, l+2, Length(s)-l-1));
         end
      end
   end
end;

{$IFNDEF NOGUI}
Procedure Translate (F: TForm; Const Abschnitt: String; slMessages: TStrings);

   Function Search (sl: TStrings; Const key: String; Var Res: String): boolean;
   Var s: String; i, j: Integer;
   begin
      Result := false;
      s := Key+'=';
      For i := 0 to sl.Count-1 do begin
         If Copy(sl[i], 1, Length(s)) = s then begin
            Res := Copy(sl[i], Length(s)+1, Length(sl[i]));
            For j := 2 to Length(Res) do If Res[j] = 'm' then begin
               If Res[j-1]='^' then begin
                  Res[j-1] := #13; Res[j] := #10
               end
            end;
            sl.Delete (i);
            Result := true;
            Exit
         end
      end
   end;

Var c: TComponent; i: Integer; P: PPropInfo; sl: TStringlist; s: String;
begin
   Init;
   sl := TStringlist.Create;
   try
      Filter(slTr, sl, slMessages, Abschnitt);
      If sl.Count = 0 then exit;
      If Search(sl, Abschnitt+'.caption', s) then F.Caption := s;
      For i := 0 to F.ComponentCount-1 do begin
         c := F.Components[i];
         p := GetPropInfo(C.ClassInfo, 'Caption');
         If Assigned(p) and Search(sl, Abschnitt+'.'+Lowercase(c.Name)+'.caption', s) then SetStrProp (C, p, s);
         p := GetPropInfo(C.ClassInfo, 'Hint');
         If Assigned(p) and Search(sl, Abschnitt+'.'+Lowercase(c.Name)+'.hint', s) then SetStrProp (C, p, s);
      end
   finally
      sl.free
   end
end;
{$endif}

Function  Tr(slMessages: TStrings; Const Key, Def: String): String;
Var i, l: Integer; v, s: String[255];
begin
   Result := Def;
   Init;
   v := LowerCase(Key+'='); l := Length(v);
   For i := 0 to slMessages.Count-1 do begin
      s := slMessages[i];
      If LowerCase(Copy(s, 1, l)) = v then begin
         Result := Copy(slMessages[i], l+1, Length(slMessages[i])-l);
         break
      end
   end;
   For i := 2 to Length(Result) do If Result[i] = 'm' then begin
      If Result[i-1]='^' then begin
         Result[i-1] := #13; Result[i] := #10
      end
   end
end;

Function  Trl(Const Key, Def: String): String;
begin
   Init;
   If Not Assigned(slMsg) then begin
      slMsg := TStringlist.Create;
      Filter(slTr, NIL, slMsg, 'Runtime');
   end;
   Result := Tr(slMsg, Key, Def)
end;

Function  Trf(Const Key, Def: String; Args: Array of Const): String;
begin
   try
      Result := Trl(Key, Def);
      Result := Format(Result, Args)
   except
      Result := '#FmtE# '+Result
   end
end;

{$IFNDEF NOGUI}
Procedure ETranslate (F: TForm; Const Abschnitt: String; egal: TStrings);

   Function conv(Const s: String): String;
   Var i: Integer;
   begin
      Result := s;
      For i := 1 to Length(s) do Case s[i] of
         #13: Result[i] := '^';
         #10: Result[i] := 'm';
      end
   end;

Var c: TComponent; i: Integer; P: PPropInfo; sl: TStringlist; s: String;
begin
   Init;
   sl := TStringlist.Create;
   With F do try
      sl.Add (Abschnitt+'.caption='+caption);
      For i := 0 to ComponentCount-1 do begin
         c := Components[i];
         p := GetPropInfo(C.ClassInfo, 'Caption');
         If Assigned(p) then begin
            s := GetStrProp (C, p);
            If s > '' then sl.Add (Abschnitt+'.'+Lowercase(c.Name)+'.caption='+conv(s))
         end;
         p := GetPropInfo(C.ClassInfo, 'Hint');
         If Assigned(p) then begin
            s := GetStrProp (C, p);
            If s > '' then sl.Add (Abschnitt+'.'+Lowercase(c.Name)+'.hint='+conv(s))
         end;
      end;
      sl.SaveToFile ('translate.txt')
   finally
      sl.free
   end
end;
{$ENDIF}

initialization
   slTr := NIL;
   slMsg := NIL;
finalization
   If Assigned(slTr) then slTr.free;
   If Assigned(slMsg) then slMsg.free
end.
